use Test;

use lib './lib';
use lib '.';

use Lingua::NumericWordForms::Roles::Persian::WordedNumberSpec;
use Lingua::NumericWordForms::Actions::Persian::WordedNumberSpec;

grammar ParseObj
        does Lingua::NumericWordForms::Roles::Persian::WordedNumberSpec {
    rule TOP { <numeric-word-form>  }
};

sub parse-func(Str:D $spec) {
    ParseObj.parse(
            $spec.lc,
            rule => 'numeric-word-form',
            actions => Lingua::NumericWordForms::Actions::Persian::WordedNumberSpec.new).made,
}

plan 14;

#-----------------------------------------------------------
# Worded number specifications parsing
#-----------------------------------------------------------
# The tests below are generated with the following Mathematica code:
#SeedRandom[39902];
#testLanguage = "Persian";
#k = 6;
#lsTestNumbers =
#  Union[Join @@
#    Map[RandomInteger[#, k] &, {{0, 19}, {20, 100}, {101,
#       1000}, {1001, 10000}, {10001, 10^6}, {10^6, 10^9}, {10^9,
#       10^12}}]];
#Length[lsTestNumbers]
#
#lsSentences =
#  Map[IntegerName[#, {"Bulgarian", "Words"}] &, lsTestNumbers];
#Shallow[lsSentences]
#
#StringRiffle[
# MapThread[
#  "## " <> #3 <> "\n" <> "is parse-func('" <> #1 <> "'), " <> #2 <>
#    ",\n'" <> #1 <> "';" &, {lsSentences, ToString /@ lsTestNumbers,
#   ToString /@ Range[Length[lsTestNumbers]]}], "\n\n"]

## 1
is parse-func('صفر'), 0,
        'صفر';

## 2
is parse-func('سه'), 3,
        'سه';

## 3
is parse-func('چهار'), 4,
        'چهار';

## 4
is parse-func('نه'), 9,
        'نه';

## 5
is parse-func('هجده'), 18,
        'هجده';

## 6
is parse-func('نوزده'), 19,
        'نوزده';

## 7
is parse-func('بیست و یک'), 21,
        'بیست و یک';

## 8
is parse-func('بیست و نه'), 29,
        'بیست و نه';

## 9
is parse-func('پنجاه و شش'), 56,
        'پنجاه و شش';

## 10
is parse-func('هفتاد و شش'), 76,
        'هفتاد و شش';

## 11
is parse-func('هشتاد و پنج'), 85,
        'هشتاد و پنج';

## 12
is parse-func('نود و هفت'), 97,
        'نود و هفت';

## 13
is parse-func('صد و شصت و سه'), 163,
        'صد و شصت و سه';

## 14
is parse-func('صد و شصت و هشت'), 168,
        'صد و شصت و هشت';
#
### 15
#is parse-func('دویست و چهار'), 204,
#        'دویست و چهار';
#
### 16
#is parse-func('دویست و شصت'), 260,
#        'دویست و شصت';
#
### 17
#is parse-func('چهارصد و بیست و هفت'), 427,
#        'چهارصد و بیست و هفت';
#
### 18
#is parse-func('هشتصد و چهار'), 804,
#        'هشتصد و چهار';
#
### 19
#is parse-func('دو هزار و هفتاد و دو'), 2072,
#        'دو هزار و هفتاد و دو';
#
### 20
#is parse-func('دو هزار و دویست و بیست و هشت'), 2228,
#        'دو هزار و دویست و بیست و هشت';
#
### 21
#is parse-func('پنج هزار و پانصد و بیست و هشت'), 5528,
#        'پنج هزار و پانصد و بیست و هشت';
#
### 22
#is parse-func('پنج هزار و هشتصد و پنجاه'), 5850,
#        'پنج هزار و هشتصد و پنجاه';
#
### 23
#is parse-func('شش هزار و پانصد و هشت'), 6508,
#        'شش هزار و پانصد و هشت';
#
### 24
#is parse-func('هفت هزار و چهارصد و دوازده'), 7412,
#        'هفت هزار و چهارصد و دوازده';
#
### 25
#is parse-func('دویست و چهل و پنج هزار و سیصد و بیست و چهار'), 245324,
#        'دویست و چهل و پنج هزار و سیصد و بیست و چهار';
#
### 26
#is parse-func('ششصد و پانزده هزار و دویست و نود و هشت'), 615298,
#        'ششصد و پانزده هزار و دویست و نود و هشت';
#
### 27
#is parse-func('هفتصد و سی و یک هزار و صد و شش'), 731106,
#        'هفتصد و سی و یک هزار و صد و شش';
#
### 28
#is parse-func('هشتصد و بیست و سه هزار و هشتصد و بیست و چهار'), 823824,
#        'هشتصد و بیست و سه هزار و هشتصد و بیست و چهار';
#
### 29
#is parse-func('هشتصد و نود و یک هزار و هشتصد و هفتاد و یک'), 891871,
#        'هشتصد و نود و یک هزار و هشتصد و هفتاد و یک';
#
### 30
#is parse-func('نهصد و چهل و یک هزار و پانصد و شش'), 941506,
#        'نهصد و چهل و یک هزار و پانصد و شش';
#
### 31
#is parse-func('پنجاه و پنج میلیون و سیصد و نود هزار و پانصد و بیست و هفت'), 55390527,
#        'پنجاه و پنج میلیون و سیصد و نود هزار و پانصد و بیست و هفت';
#
### 32
#is parse-func('هفتاد و شش میلیون و هفتصد و بیست و چهار هزار و چهارصد و سی و شش'), 76724436,
#        'هفتاد و شش میلیون و هفتصد و بیست و چهار هزار و چهارصد و سی و شش';
#
### 33
#is parse-func('دویست و چهل و هفت میلیون و پانصد و هفت هزار و هجده'), 247507018,
#        'دویست و چهل و هفت میلیون و پانصد و هفت هزار و هجده';
#
### 34
#is parse-func('پانصد و شانزده میلیون و هفتصد و پنجاه و سه هزار و سیصد و هفتاد و هشت'), 516753378,
#        'پانصد و شانزده میلیون و هفتصد و پنجاه و سه هزار و سیصد و هفتاد و هشت';
#
### 35
#is parse-func('هشتصد و چهل و دو میلیون و هفتصد و چهار هزار و هفتصد و هشتاد و سه'), 842704783,
#        'هشتصد و چهل و دو میلیون و هفتصد و چهار هزار و هفتصد و هشتاد و سه';
#
### 36
#is parse-func('نهصد و هشتاد و هشت میلیون و نهصد و شصت و یک هزار و سیصد و بیست و چهار'), 988961324,
#        'نهصد و هشتاد و هشت میلیون و نهصد و شصت و یک هزار و سیصد و بیست و چهار';
#
### 37
#is parse-func('پانصد و هشتاد و هفت میلیارد و هفتصد و بیست و هفت میلیون و دویست و سی هزار و صد و نود و نه'),
#        587727230199,
#        'پانصد و هشتاد و هفت میلیارد و هفتصد و بیست و هفت میلیون و دویست و سی هزار و صد و نود و نه';
#
### 38
#is parse-func('ششصد و بیست و هفت میلیارد و پانصد و هشتاد میلیون و نهصد و سی و پنج هزار و هفتاد و دو'), 627580935072,
#        'ششصد و بیست و هفت میلیارد و پانصد و هشتاد میلیون و نهصد و سی و پنج هزار و هفتاد و دو';
#
### 39
#is parse-func('هفتصد و هشتاد و چهار میلیارد و ششصد و سی میلیون و هفتصد و سی و هشت هزار و صد و بیست'), 784630738120,
#        'هفتصد و هشتاد و چهار میلیارد و ششصد و سی میلیون و هفتصد و سی و هشت هزار و صد و بیست';
#
### 40
#is parse-func('هشتصد و چهار میلیارد و سیصد و نود و هفت میلیون و چهارصد و شانزده هزار و هفتصد و سی و شش'), 804397416736,
#        'هشتصد و چهار میلیارد و سیصد و نود و هفت میلیون و چهارصد و شانزده هزار و هفتصد و سی و شش';
#
### 41
#is parse-func('هشتصد و شصت و هفت میلیارد و پانصد و شصت و یک میلیون و سیصد و هشتاد هزار و چهارصد و چهارده'),
#        867561380414,
#        'هشتصد و شصت و هفت میلیارد و پانصد و شصت و یک میلیون و سیصد و هشتاد هزار و چهارصد و چهارده';
#
### 42
#is parse-func('نهصد و هشتاد میلیارد و هفتصد و سی و شش میلیون و صد و سی و هشت هزار و هشتصد و سی و نه'), 980736138839,
#        'نهصد و هشتاد میلیارد و هفتصد و سی و شش میلیون و صد و سی و هشت هزار و هشتصد و سی و نه';

done-testing;