package Iodef::Pb::Simple::Plugin::Malware;
use base 'Iodef::Pb::Simple::Plugin';

use strict;
use warnings;

sub process {
    my $self = shift;
    my $data = shift;
    my $iodef = shift;
    
    return unless($data->{'malware_md5'}|| $data->{'malware_sha1'});
    
    my $ad = [];
        
    push(@$ad, 
        ExtensionType->new({
            meaning     => 'malware hash',
            formatid    => 'md5',
            content     => $data->{'malware_md5'},
            dtype       => ExtensionType::DtypeType::dtype_type_string(),
        })
    ) if($data->{'malware_md5'});
    
    push(@$ad, 
        ExtensionType->new({
            meaning     => 'malware hash',
            formatid    => 'sha1',
            content     => $data->{'malware_sha1'},
            dtype       => ExtensionType::DtypeType::dtype_type_string(),
        })
    ) if($data->{'malware_sha1'});
    
    my $incident = @{$iodef->get_Incident()}[0];
    push(@{$incident->{'AdditionalData'}},@$ad);  
}

1;