Advanced table generate module for raku lang

![Build
Status](https://travis-ci.org/araraloren/raku-terminal-table.svg?branch=master)

![Windows Build
Status](https://ci.appveyor.com/api/projects/status/sbgq8vt0775fu1pk/branch/master?svg=true)

# Description

Terminal::Table provides a simple and also a advance way generate table
output in terminals. It support multi line table cell. You can create
your own style for your table, and you can colour your table content.
Also the module has common style pre-defined.

# Usage

[中文帮助](README.zh.adoc)

## Interface

### High Level Interface

The simple way to use `Terminal::Table` is use API below:

These subs want a two-dimension array of string. It uses pre-defined
style. Default is `Style::Default::ASCII`, also you can their low case
name such as 'ascii'.

-   print-table(@data, @max-widths = \[\],
    :$style=Style::Default::ASCII)

    Print table to stdout.

-   array-to-table(@data, @max-widths = \[\],
    :$style=Style::Default::ASCII)

    Return an array contain table data;

-   create-generator(@data, :$style=Style::Default::ASCII);

    Return an generator base on the `@data`.

#### Pre-defined Style

``` raku
enum Style::Default  is export <<
    :NONE('none')
    :ASCII('ascii')
    :SPACE('space')
    :DOT('dot')
    :SINGLE('single')
    :DOUBLE('double')
    :ROUND('round')
    :OTHER('other') # other is use for self-defined-style
>>;
```

## Example

### High Level Interface

``` raku
use Terminal::Table;

my @data = [
    [ "Language", "Example" ],
    [ "Chinese",  "你吃饭了吗？\n你好！\n你从哪里来？" ],
    [ "English",  "Nice to meet you!\nWhere are you from?" ],
    [ "Janpanese","ありがとうございます。\nいただきます！"],
    [ "Korean",   "안녕하세요！"],
];

print-table(@data);
```

It will output:

![output for high-level-api](resources/output1.png)

### Low Level Interface

``` raku
#!/usr/bin/env raku

use v6;
use Terminal::Table::Generator;
use Terminal::Table::Style;

my $g = Generator.new(
    style => Style.new(
        corner-style => Style::Corner.double(),
        line-style => Style::Line.double(),
        content-style => Style::Content.space(),
    )
);

$g.add-cell('Language');
$g.add-cell('Example');
$g.add-cell('Country');
$g.end-line;
$g.add-cell('Chinese');
$g.add-cell("你吃饭了吗？\n你好！\n你从哪里来？");
$g.add-cell('China');
$g.end-line;
$g.add-cell('Janpanese');
$g.add-cell('
ありがとうございます。
いただきます！');
$g.add-cell('Janpa');
$g.end-line;
$g.add-cell('English');
$g.add-cell('Nice to meet you!
Are you ok?
Where are you from ?');
$g.add-cell('American、England、Australian .etc');
$g.end-line;
$g.add-cell('Korean');
$g.add-cell('안녕하세요！');
$g.add-cell('Korea');
$g.end-line;
$g.generator().generate().print();
```

It will output:

![output for low-level-api](resources/output2.png)

### Generator join and colour

Terminal::Table use
[Terminal::ANSIColor](https://github.com/tadzik/Terminal-ANSIColor) for
colour process.

``` raku
#!/usr/bin/env raku

use Terminal::Table::Style;
use Terminal::Table::Generator;

my $gl = Generator.new(
    style => Style.new(
        corner-style => Style::Corner.double(),
        line-style   => Style::Line.double(),
        content-style=> Style::Content.space(),
    )
);

for 1 .. 9 -> \x {
    for 1 .. x -> \y {
        $gl.add-cell("{y} x {x} = {x * y}");
    }
    $gl.end-line();
}

my $gr = Generator.new(
    style => Style.new(
        corner-style => Style::Corner.single(),
        line-style   => Style::Line.dot(),
        content-style=> Style::Content.space(),
    )
);

my @data;

for reverse 1 .. 9 -> \x {
    @data.push([ "{.Int} x {x} = {x * .Int}" for 1 .. x ]);
}

$gr.from-array(@data);
$gl.join($gr, :replace-style);

my $g = $gl.generator().generate();

$g.colour(0, 0, Color::String.new(color => <blue bold> ));
$g.colour(8, $_, Color::String.new(color => <red bold> )) for ^9;
$g.colour(9, $_, Color::String.new(color => <green bold> )) for ^9;
$g.print(:coloured);
```

It will output:

![output for join-and-colour](resources/output3.png)

### Irregular shape

``` raku
#!/usr/bin/env raku

use v6;
use Terminal::Table;

constant SIZE = 22;

my $g = create-generator([
    'C' xx SIZE,
    'C' xx SIZE,
    'C' xx SIZE,
    'C' xx SIZE,
    'C' xx SIZE,
    'C' xx SIZE,
    'C' xx SIZE,
]);

$g.generate;

my &hide = -> $x, $y {
    my ($r, $c) = ($g.row-count() * 2, $g.col-count($x) * 2);
    my ($rx, $ry) = ($x * 2, $y * 2);

    my $top = $rx == 0 || $g.is-hidden($rx - 1, $ry + 1);
    my $top-left = ($rx == 0 || $ry == 0) || $g.is-hidden($rx - 1, $ry - 1);
    my $top-right = ($rx == 0 || $ry + 2 == $c) || $g.is-hidden($rx - 1, $ry + 3);
    my $bottom = ($rx + 2 == $r) || $g.is-hidden($rx + 3, $ry + 1);
    my $bottom-left = ($rx + 2 == $r || $ry == 0) || $g.is-hidden($rx + 3, $ry - 1);
    my $bottom-right = ($rx + 2 == $r || $ry + 2 == $c) || $g.is-hidden($rx + 3, $ry + 3);
    my $left = $ry == 0 || $g.is-hidden($rx + 1, $ry - 1);
    my $right = ($ry + 2 == $c) || $g.is-hidden($rx + 1, $ry + 3);

    if $top && $top-left && $left {
        $g.hide($rx, $ry, :replace-with-space);
    }
    if $top {
        $g.hide($rx, $ry + 1, :replace-with-space);
    }
    if $top && $top-right && $right {
        $g.hide($rx, $ry + 2, :replace-with-space);
    }
    if $left {
        $g.hide($rx + 1, $ry, :replace-with-space);
    }
    if $right {
        $g.hide($rx + 1, $ry + 2, :replace-with-space);
    }
    if $left && $bottom-left && $bottom {
        $g.hide($rx + 2, $ry, :replace-with-space);
    }
    if $bottom {
        $g.hide($rx + 2, $ry + 1, :replace-with-space);
    }
    if $right && $bottom-right && $bottom {
        $g.hide($rx + 2, $ry + 2, :replace-with-space);
    }
    $g.hide($rx + 1, $ry + 1, :replace-with-space);
};

&hide(1, 13 + $_) for ^8;
&hide($_, 13) for 2 .. 5;
&hide($_, 14) for 2 .. 5;
&hide(5, 13 + $_) for ^8;
&hide($_, 20) for 3 .. 4;
&hide($_, 19) for 3 .. 4;
&hide(3, 15 + $_) for ^5;

&hide(1, 3 + $_) for ^8;
&hide($_, 3) for 2 .. 5;
&hide($_, 4) for 2 .. 5;
&hide($_, 10) for 2 .. 3;
&hide($_, 9) for 2 .. 3;
&hide(3, 4 + $_) for ^6;
&hide(5, 2 + $_) for ^4;

$g.print;
```

It will output:

![output for irregular shape](resources/output4.png)

### more

For more usage, check out sample or POD document.

# Installation

## From source

``` shell
git clone https://github.com/araraloren/raku-terminal-table

cd raku-terminal-table && git checkout v0.0.1 && zef install .
```

## From zef

``` shell
zef update && zef install Terminal::Table
```

# License

    The MIT License (MIT).

# Author

    Araraloren. Email: blackcatoverwall@gmail.com

# TODO

    None
