package PROP;

our $VERSION = 0.1;

=head1 Name

PROP

=head1 Description

This module serves as a framework for both object and relationship
persistence via a SQL capable database.  Interaction with an
underlying database is accomplished via Perl objects that abstract
away all of the tedious construction, issuance, and processing of SQL
queries.  Within this framework, users may create, modify and delete
objects, as well as link them together in arbitrary ways, and perform
a variety of querying operations.  The querying engine is reasonably
sophisticated, allowing for a large degree of flexibility without
becoming overly cumbersome, and performs intelligent buffering of
results so as to be extensible to large queries.

Divided into several conceptual components, this module provides
several well isolated sub-components that are reasonably easy to
understand on their own.  Short descriptions of these modules may be
found in the following section.

=head1 SYNOPSIS

=over

=item Create Database Tables

The first thing you need to do is to create the underlying database
tables for object and relationship persistence.  This is very simple.
Object tables can have arbitrary fields, but must have a single
automatically incrementing integer field as primary key.  Link tables,
for specifying relationships, must have a dual integer primary key,
keys that will refer to the primary keys of rows in object tables, and
then may also have arbitrarily many "context" fields that are used to
specify information about the context from which an object was loaded.

=item Wrapping Database Functionality With Perl Classes

Once the database has been configured with the appropriate tables, the
next thing to do is to write the Perl that will interface to it.  For
objects, the only thing required is to create classes that specify
PROP::Object as the base class, and provide a get_table_name method
that returns the name of the table in the database.  For
relationships, there is no subclassing involved; rather, one simply
constructs objects of class PROP::Link, passing to its constructor the
name of the link table in the underlying database, and the class names
of the parent and child classes.

=item Create Application

Initialization of your application will entail working with the
PROP::Conf class, in order to let the framework know where the database
with which it will be working lives.  Once the framework has been
configured, working with objects, links, queries, and result sets is a
seamless process that cleanly conceals the underlying database
implementation.  All of the classes know how to work with the database
in a way that is (hopefully) totally transparent to the user.  You
just need to know how to employ their APIs to your end.

=back

=head1 Modules

=over

=item PROP::Object

If any class were said to lie at the center of this module, this would
be the one.  This class serves as the base class for all object types,
and provides a collection of methods for performing all common object
operations, such as saving, modifying, and deleting.  Subclasses to
this class must provide a get_table_name() method, and will probably
also include various and sundry wrapper methods to flesh out the
functionality of the class.  One can load single objects via
themselves, or obtain collections of objects by using the
PROP::Query::Object class.

=item PROP::Link

A PROP::Link object specifies a linking relationship in the database,
and also provides mechanisms for creating, modifying and deleting
relationships between objects as specified by the link in question.

=item PROP::Query::Object

This class is used to specify a query of a collection of objects.
Queries of this type are specified with conditions, bindings of
condition variables to values, and orderings.  One may additionally
specify a list of PROP::Query::Link objects which will specify that the
objects loaded should be loaded with certain parent and/or children
objects.  An object of this class is passed to the constructor of
PROP::ResultSet::Object to perform an actual query.

=item PROP::Query::Link

A PROP::Query::Link object is used to specify a query of a collection
of linked objects.  Queries of this type are specified with a link,
conditions, and orderings.  An object of this class is passed to the
constructor of PROP::ResultSet::Link to perform an actual query.

=item PROP::ResultSet::Object

A PROP::ResultSet::Object is the source of objects as specified by a
PROP::Query::Object object..  By repeatedly invoking the
get_next_result() method until it returns undef, one can iterate over
the results of a query, getting back instances of classes that derive
from PROP::Object.

=item PROP::ResultSet::Link

A PROP::ResultSet::Link is the source of results of a query on a link
as specified by a PROP::Query::Link object.  By repeatedly invoking the
get_next_result() method until it returns undef, one can iterate over
the results of a query, getting back instances of the class
PROP::ResultSet::Link::Result, a helper class for PPO::ResultSet::Link,
the documentation for which may be found within the documentation for
PROP::ResultSet::Link.

=item PROP::Schema

A PROP::Schema object contains all pertinent information about a
database table.  Users will probably never have need to create a
PROP::Schema object directly.  Rather, the PPO::NIST::Object class
provides a get_table() method that returns an object of this type.
The table returned is contingent upon the derived class's
get_table_name() method.  Using the name of the table, PROP::Object
constructs a PROP::Schema object which populates itself with table
structure information by querying the database.

=item PROP::SQL

The PROP::SQL class is a base class for several derived classes, each
of which provides for a certain type of SQL statement.  This class
takes table names, field names, conditions, orderings, and other such
statement parameters, and then via the stringify() method returns a
scalar that holds the statement string.  This tree of classes is
mostly used internally by the framework to populate objects and
manipulate the underlying database, but may also be useful to users
who wish to issue queries that are not directly supported by the
framework and thus need to craft custom queries.

=item PROP::Util

This class holds a collection of static utility methods that allow for
performing common database tasks.

=item PROP::Conf

The PROP::Conf class is a base class for classes that parse connection
configuration information for various RDBMS, e.g. PROP::Conf::MySQL.

=item PROP::DBH

The PROP::DBH class has but a single static method, get_handle(), which
creates database handles via calling DBI->connect(...).  It pulls
configuration information from PROP::Conf.

=back

=head1 Author

Andrew Gibbs (awgibbs@awgibbs.com,andrew.gibbs@nist.gov)

=head1 Legalese

This software was developed at the National Institute of Standards and
Technology by employees of the Federal Government in the course of
their official duties. Pursuant to title 17 Section 105 of the United
States Code this software is not subject to copyright protection and
is in the public domain. PROP is an experimental system. NIST
assumes no responsibility whatsoever for its use by other parties, and
makes no guarantees, expressed or implied, about its quality,
reliability, or any other characteristic. We would appreciate
acknowledgement if the software is used.  This software can be
redistributed and/or modified freely provided that any derivative
works bear some notice that they are derived from it, and any modified
versions bear some notice that they have been modified.
