package WebService::Mattermost::V4::API::Resource::Audits;

# ABSTRACT: Wrapped API methods for the audits API endpoints.

use Moo;
use Types::Standard 'Str';

extends 'WebService::Mattermost::V4::API::Resource';

################################################################################

has view_name => (is => 'ro', isa => Str, default => 'Audit');

################################################################################

sub get {
    my $self = shift;
    my $args = shift;

    return $self->_get({ parameters => $args });
}

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::V4::API::Resource::Audits - Wrapped API methods for the audits API endpoints.

=head1 VERSION

version 0.28

=head1 DESCRIPTION

=head2 USAGE

    use WebService::Mattermost;

    my $mm = WebService::Mattermost->new({
        authenticate => 1,
        username     => 'me@somewhere.com',
        password     => 'hunter2',
        base_url     => 'https://my.mattermost.server.com/api/v4/',
    });

    my $resource = $mm->api->audits;

=head2 METHODS

=over 4

=item C<get()>

L<Get audits|https://api.mattermost.com/#tag/system%2Fpaths%2F~1audits%2Fget>

    my $response = $resource->get({
        # Optional parameters:
        page     => 0,
        per_page => 60,
    });

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2020 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
