#!/usr/bin/env perl
use strict;
use warnings;

use Test::More tests => 1;
use Test::MockModule;

use Git::Wrapper::More;

my $mgwm = Test::MockModule->new('Git::Wrapper');
$mgwm->mock(
    'rev_parse',
    sub {
        my $self = shift;
        return 'dummy_git_repo_name';
    },
);

my $gwm = Git::Wrapper::More->new( dir => '/dummy/dir' );

my $ret = $gwm->cwdbranch();
like( $ret, qr/^dummy_git_repo_name$/, 'cwdbranch returns a repo name' );

__END__
