#!/usr/bin/env perl
use strict;
use warnings;

use Test::More tests => 1;
use Test::Deep;
use Test::MockModule;

use Git::Wrapper::More;

my @dum_ret = (
    qw!
        lib/IdevCover.pm
        lib/IdevCover/ApacheConfig.pm
        lib/IdevCover/Git::Wrapper::More.pm
        lib/IdevCover/NoCoverFiles.pm
        t/01-check_pw_prot_apache.t
        t/unit/lib-IdevCover-ApacheConfig/check_pw_prot.t
        !
);

my $mgwm = Test::MockModule->new('Git::Wrapper');
$mgwm->mock(
    'ls_files',
    sub {
        my $self = shift;

        return @dum_ret;
    },
);

my $gwm = Git::Wrapper::More->new( dir => '/dummy/dir' );

my @ret = $gwm->lsfiles();
cmp_deeply( \@ret, \@dum_ret, 'lsfiles returns the dummy files it was fed' );

exit;

__END__
