# Generated by default/object.tt
package Paws::LicenseManager::ReportGenerator;
  use Moose;
  has CreateTime => (is => 'ro', isa => 'Str');
  has Description => (is => 'ro', isa => 'Str');
  has LastReportGenerationTime => (is => 'ro', isa => 'Str');
  has LastRunFailureReason => (is => 'ro', isa => 'Str');
  has LastRunStatus => (is => 'ro', isa => 'Str');
  has LicenseManagerReportGeneratorArn => (is => 'ro', isa => 'Str');
  has ReportContext => (is => 'ro', isa => 'Paws::LicenseManager::ReportContext');
  has ReportCreatorAccount => (is => 'ro', isa => 'Str');
  has ReportFrequency => (is => 'ro', isa => 'Paws::LicenseManager::ReportFrequency');
  has ReportGeneratorName => (is => 'ro', isa => 'Str');
  has ReportType => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has S3Location => (is => 'ro', isa => 'Paws::LicenseManager::S3Location');
  has Tags => (is => 'ro', isa => 'ArrayRef[Paws::LicenseManager::Tag]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LicenseManager::ReportGenerator

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LicenseManager::ReportGenerator object:

  $service_obj->Method(Att1 => { CreateTime => $value, ..., Tags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LicenseManager::ReportGenerator object:

  $result = $service_obj->Method(...);
  $result->Att1->CreateTime

=head1 DESCRIPTION

Describe the details of a report generator.

=head1 ATTRIBUTES


=head2 CreateTime => Str

Time the report was created.


=head2 Description => Str

Description of the report generator.


=head2 LastReportGenerationTime => Str

Time the last report was generated at.


=head2 LastRunFailureReason => Str

Failure message for the last report generation attempt.


=head2 LastRunStatus => Str

Status of the last report generation attempt.


=head2 LicenseManagerReportGeneratorArn => Str

Amazon Resource Number (ARN) of the report generator.


=head2 ReportContext => L<Paws::LicenseManager::ReportContext>

License configuration type this generator reports on.


=head2 ReportCreatorAccount => Str

The AWS account ID used to create the report generator.


=head2 ReportFrequency => L<Paws::LicenseManager::ReportFrequency>

Details on how frequently reports are generated.


=head2 ReportGeneratorName => Str

Name of the report generator.


=head2 ReportType => ArrayRef[Str|Undef]

Type of reports that are generated.


=head2 S3Location => L<Paws::LicenseManager::S3Location>

Details of the S3 bucket that report generator reports are published
to.


=head2 Tags => ArrayRef[L<Paws::LicenseManager::Tag>]

Tags associated with the report generator.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LicenseManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

