/*
 * Decompiled with CFR 0.152.
 */
package org.ibex.nestedvm;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.ibex.classgen.CGConst;
import org.ibex.classgen.ClassFile;
import org.ibex.classgen.MethodGen;
import org.ibex.classgen.Type;
import org.ibex.nestedvm.Compiler;
import org.ibex.nestedvm.util.ELF;
import org.ibex.nestedvm.util.Seekable;

public class ClassFileCompiler
extends Compiler
implements CGConst {
    private static final boolean OPTIMIZE_CP = true;
    private OutputStream os;
    private File outDir;
    private PrintStream warn = System.err;
    private final Type.Class me;
    private ClassFile cg;
    private MethodGen clinit;
    private MethodGen init;
    private static int initDataCount;
    private int startOfMethod = 0;
    private int endOfMethod = 0;
    private MethodGen.PhantomTarget returnTarget;
    private MethodGen.PhantomTarget defaultTarget;
    private MethodGen.PhantomTarget[] insnTargets;
    private MethodGen mg;
    private static final int UNREACHABLE = 1;
    private static final int SKIP_NEXT = 2;
    private boolean textDone;
    private static final Float POINT_5_F;
    private static final Double POINT_5_D;
    private static final Long FFFFFFFF;
    private static final int R = 0;
    private static final int F = 32;
    private static final int HI = 64;
    private static final int LO = 65;
    private static final int FCSR = 66;
    private static final int REG_COUNT = 67;
    private static final String[] regField;
    private static final int MAX_LOCALS = 4;
    private static final int LOAD_LENGTH = 3;
    private int[] regLocalMapping = new int[67];
    private boolean[] regLocalWritten = new boolean[67];
    private int nextAvailLocal;
    private int loadsStart;
    private int preSetRegStackPos;
    private int[] preSetRegStack = new int[8];
    private int memWriteStage;
    private boolean didPreMemRead;
    private boolean preMemReadDoPreWrite;

    static {
        POINT_5_F = new Float(0.5f);
        POINT_5_D = new Double(0.5);
        FFFFFFFF = new Long(0xFFFFFFFFL);
        regField = new String[]{"r0", "r1", "r2", "r3", "r4", "r5", "r6", "r7", "r8", "r9", "r10", "r11", "r12", "r13", "r14", "r15", "r16", "r17", "r18", "r19", "r20", "r21", "r22", "r23", "r24", "r25", "r26", "r27", "r28", "r29", "r30", "r31", "f0", "f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "f10", "f11", "f12", "f13", "f14", "f15", "f16", "f17", "f18", "f19", "f20", "f21", "f22", "f23", "f24", "f25", "f26", "f27", "f28", "f29", "f30", "f31", "hi", "lo", "fcsr"};
    }

    public ClassFileCompiler(String string, String string2, OutputStream outputStream) throws IOException {
        this((Seekable)new Seekable.File(string), string2, outputStream);
    }

    public ClassFileCompiler(Seekable seekable, String string, OutputStream outputStream) throws IOException {
        this(seekable, string);
        if (outputStream == null) {
            throw new NullPointerException();
        }
        this.os = outputStream;
    }

    public ClassFileCompiler(Seekable seekable, String string, File file) throws IOException {
        this(seekable, string);
        if (file == null) {
            throw new NullPointerException();
        }
        this.outDir = file;
    }

    private ClassFileCompiler(Seekable seekable, String string) throws IOException {
        super(seekable, string);
        this.me = Type.Class.instance((String)this.fullClassName);
    }

    public void setWarnWriter(PrintStream printStream) {
        this.warn = printStream;
    }

    protected void _go() throws Compiler.Exn, IOException {
        try {
            this.__go();
        }
        catch (ClassFile.Exn exn) {
            exn.printStackTrace(this.warn);
            throw new Compiler.Exn("Class generation exception: " + exn.toString());
        }
    }

    private void __go() throws Compiler.Exn, IOException {
        MethodGen methodGen;
        ELF.Symbol[] symbolArray;
        if (!this.pruneCases) {
            throw new Compiler.Exn("-o prunecases MUST be enabled for ClassFileCompiler");
        }
        Type.Class clazz = Type.Class.instance((String)this.runtimeClass);
        this.cg = new ClassFile(this.me, clazz, 49);
        if (this.source != null) {
            this.cg.setSourceFile(this.source);
        }
        this.cg.addField("pc", Type.INT, 2);
        this.cg.addField("hi", Type.INT, 2);
        this.cg.addField("lo", Type.INT, 2);
        this.cg.addField("fcsr", Type.INT, 2);
        int n = 1;
        while (n < 32) {
            this.cg.addField("r" + n, Type.INT, 2);
            ++n;
        }
        n = 0;
        while (n < 32) {
            this.cg.addField("f" + n, this.singleFloat ? Type.FLOAT : Type.INT, 2);
            ++n;
        }
        this.clinit = this.cg.addMethod("<clinit>", Type.VOID, Type.NO_ARGS, 10);
        this.init = this.cg.addMethod("<init>", Type.VOID, Type.NO_ARGS, 1);
        this.init.add((byte)42);
        this.init.add((byte)18, this.pageSize);
        this.init.add((byte)18, this.totalPages);
        this.init.add((byte)-73, (Object)this.me.method("<init>", Type.VOID, new Type[]{Type.INT, Type.INT}));
        this.init.add((byte)-79);
        this.init = this.cg.addMethod("<init>", Type.VOID, new Type[]{Type.BOOLEAN}, 1);
        this.init.add((byte)42);
        this.init.add((byte)18, this.pageSize);
        this.init.add((byte)18, this.totalPages);
        this.init.add((byte)27);
        this.init.add((byte)-73, (Object)this.me.method("<init>", Type.VOID, new Type[]{Type.INT, Type.INT, Type.BOOLEAN}));
        this.init.add((byte)-79);
        this.init = this.cg.addMethod("<init>", Type.VOID, new Type[]{Type.INT, Type.INT}, 1);
        this.init.add((byte)42);
        this.init.add((byte)27);
        this.init.add((byte)28);
        this.init.add((byte)3);
        this.init.add((byte)-73, (Object)this.me.method("<init>", Type.VOID, new Type[]{Type.INT, Type.INT, Type.BOOLEAN}));
        this.init.add((byte)-79);
        this.init = this.cg.addMethod("<init>", Type.VOID, new Type[]{Type.INT, Type.INT, Type.BOOLEAN}, 1);
        this.init.add((byte)42);
        this.init.add((byte)27);
        this.init.add((byte)28);
        this.init.add((byte)29);
        this.init.add((byte)-73, (Object)clazz.method("<init>", Type.VOID, new Type[]{Type.INT, Type.INT, Type.BOOLEAN}));
        if (this.onePage) {
            this.cg.addField("page", (Type)Type.INT.makeArray(), 18);
            this.init.add((byte)42);
            this.init.add((byte)89);
            this.init.add((byte)-76, (Object)this.me.field("readPages", (Type)Type.INT.makeArray(2)));
            this.init.add((byte)18, 0);
            this.init.add((byte)50);
            this.init.add((byte)-75, (Object)this.me.field("page", (Type)Type.INT.makeArray()));
        }
        if (this.supportCall) {
            this.cg.addField("symbols", (Type)Type.Class.instance((String)this.hashClass), 26);
        }
        n = 0;
        int n2 = 0;
        while (n2 < this.elf.sheaders.length) {
            symbolArray = this.elf.sheaders[n2];
            String string = symbolArray.name;
            if (symbolArray.addr != 0) {
                n = Math.max(n, symbolArray.addr + symbolArray.size);
                if (string.equals(".text")) {
                    this.emitText(symbolArray.addr, new DataInputStream(symbolArray.getInputStream()), symbolArray.size);
                } else if (string.equals(".data") || string.equals(".sdata") || string.equals(".rodata") || string.equals(".ctors") || string.equals(".dtors")) {
                    this.emitData(symbolArray.addr, new DataInputStream(symbolArray.getInputStream()), symbolArray.size, string.equals(".rodata"));
                } else if (string.equals(".bss") || string.equals(".sbss")) {
                    this.emitBSS(symbolArray.addr, symbolArray.size);
                } else {
                    throw new Compiler.Exn("Unknown segment: " + string);
                }
            }
            ++n2;
        }
        this.init.add((byte)-79);
        if (this.supportCall) {
            Type.Class clazz2 = Type.Class.instance((String)this.hashClass);
            this.clinit.add((byte)-69, (Object)clazz2);
            this.clinit.add((byte)89);
            this.clinit.add((byte)89);
            this.clinit.add((byte)-73, (Object)clazz2.method("<init>", Type.VOID, Type.NO_ARGS));
            this.clinit.add((byte)-77, (Object)this.me.field("symbols", (Type)clazz2));
            symbolArray = this.elf.getSymtab().symbols;
            int n3 = 0;
            while (n3 < symbolArray.length) {
                ELF.Symbol symbol = symbolArray[n3];
                if (symbol.type == 2 && symbol.binding == 1 && (symbol.name.equals("_call_helper") || !symbol.name.startsWith("_"))) {
                    this.clinit.add((byte)89);
                    this.clinit.add((byte)18, (Object)symbol.name);
                    this.clinit.add((byte)-69, (Object)Type.INTEGER_OBJECT);
                    this.clinit.add((byte)89);
                    this.clinit.add((byte)18, symbol.addr);
                    this.clinit.add((byte)-73, (Object)Type.INTEGER_OBJECT.method("<init>", Type.VOID, new Type[]{Type.INT}));
                    this.clinit.add((byte)-74, (Object)clazz2.method("put", (Type)Type.OBJECT, new Type[]{Type.OBJECT, Type.OBJECT}));
                    this.clinit.add((byte)87);
                }
                ++n3;
            }
            this.clinit.add((byte)87);
        }
        this.clinit.add((byte)-79);
        ELF.SHeader sHeader = this.elf.sectionWithName(".text");
        symbolArray = this.cg.addMethod("trampoline", Type.VOID, Type.NO_ARGS, 2);
        int n4 = symbolArray.size();
        symbolArray.add((byte)42);
        symbolArray.add((byte)-76, (Object)this.me.field("state", Type.INT));
        symbolArray.add((byte)-103, symbolArray.size() + 2);
        symbolArray.add((byte)-79);
        symbolArray.add((byte)42);
        symbolArray.add((byte)42);
        symbolArray.add((byte)-76, (Object)this.me.field("pc", Type.INT));
        symbolArray.add((byte)18, this.methodShift);
        symbolArray.add((byte)124);
        int n5 = sHeader.addr >>> this.methodShift;
        int n6 = sHeader.addr + sHeader.size + this.maxBytesPerMethod - 1 >>> this.methodShift;
        MethodGen.Switch.Table table = new MethodGen.Switch.Table(n5, n6 - 1);
        symbolArray.add((byte)-86, (Object)table);
        int n7 = n5;
        while (n7 < n6) {
            table.setTargetForVal(n7, symbolArray.size());
            symbolArray.add((byte)-73, (Object)this.me.method("run_" + ClassFileCompiler.toHex(n7 << this.methodShift), Type.VOID, Type.NO_ARGS));
            symbolArray.add((byte)-89, n4);
            ++n7;
        }
        table.setDefaultTarget(symbolArray.size());
        symbolArray.add((byte)87);
        symbolArray.add((byte)-69, (Object)Type.Class.instance((String)"org.ibex.nestedvm.Runtime$ExecutionException"));
        symbolArray.add((byte)89);
        symbolArray.add((byte)-69, (Object)Type.STRINGBUFFER);
        symbolArray.add((byte)89);
        symbolArray.add((byte)18, (Object)"Jumped to invalid address in trampoline (r2: ");
        symbolArray.add((byte)-73, (Object)Type.STRINGBUFFER.method("<init>", Type.VOID, new Type[]{Type.STRING}));
        symbolArray.add((byte)42);
        symbolArray.add((byte)-76, (Object)this.me.field("r2", Type.INT));
        symbolArray.add((byte)-74, (Object)Type.STRINGBUFFER.method("append", (Type)Type.STRINGBUFFER, new Type[]{Type.INT}));
        symbolArray.add((byte)18, (Object)" pc: ");
        symbolArray.add((byte)-74, (Object)Type.STRINGBUFFER.method("append", (Type)Type.STRINGBUFFER, new Type[]{Type.STRING}));
        symbolArray.add((byte)42);
        symbolArray.add((byte)-76, (Object)this.me.field("pc", Type.INT));
        symbolArray.add((byte)-74, (Object)Type.STRINGBUFFER.method("append", (Type)Type.STRINGBUFFER, new Type[]{Type.INT}));
        symbolArray.add((byte)18, (Object)")");
        symbolArray.add((byte)-74, (Object)Type.STRINGBUFFER.method("append", (Type)Type.STRINGBUFFER, new Type[]{Type.STRING}));
        symbolArray.add((byte)-74, (Object)Type.STRINGBUFFER.method("toString", (Type)Type.STRING, Type.NO_ARGS));
        symbolArray.add((byte)-73, (Object)Type.Class.instance((String)"org.ibex.nestedvm.Runtime$ExecutionException").method("<init>", Type.VOID, new Type[]{Type.STRING}));
        symbolArray.add((byte)-65);
        this.addConstReturnMethod("gp", this.gp.addr);
        this.addConstReturnMethod("entryPoint", this.elf.header.entry);
        this.addConstReturnMethod("heapStart", n);
        if (this.userInfo != null) {
            this.addConstReturnMethod("userInfoBase", this.userInfo.addr);
            this.addConstReturnMethod("userInfoSize", this.userInfo.size);
        }
        if (this.supportCall) {
            Type.Class clazz3 = Type.Class.instance((String)this.hashClass);
            methodGen = this.cg.addMethod("lookupSymbol", Type.INT, new Type[]{Type.STRING}, 4);
            methodGen.add((byte)-78, (Object)this.me.field("symbols", (Type)clazz3));
            methodGen.add((byte)43);
            methodGen.add((byte)-74, (Object)clazz3.method("get", (Type)Type.OBJECT, new Type[]{Type.OBJECT}));
            methodGen.add((byte)89);
            int n8 = methodGen.add((byte)-58);
            methodGen.add((byte)-64, (Object)Type.INTEGER_OBJECT);
            methodGen.add((byte)-74, (Object)Type.INTEGER_OBJECT.method("intValue", Type.INT, Type.NO_ARGS));
            methodGen.add((byte)-84);
            methodGen.setArg(n8, methodGen.size());
            methodGen.add((byte)87);
            methodGen.add((byte)2);
            methodGen.add((byte)-84);
        }
        Type.Class clazz4 = Type.Class.instance((String)"org.ibex.nestedvm.Runtime$CPUState");
        methodGen = this.cg.addMethod("setCPUState", Type.VOID, new Type[]{clazz4}, 4);
        MethodGen methodGen2 = this.cg.addMethod("getCPUState", Type.VOID, new Type[]{clazz4}, 4);
        methodGen.add((byte)43);
        methodGen2.add((byte)43);
        methodGen.add((byte)-76, (Object)clazz4.field("r", (Type)Type.INT.makeArray()));
        methodGen2.add((byte)-76, (Object)clazz4.field("r", (Type)Type.INT.makeArray()));
        methodGen.add((byte)77);
        methodGen2.add((byte)77);
        int n9 = 1;
        while (n9 < 32) {
            methodGen.add((byte)42);
            methodGen.add((byte)44);
            methodGen.add((byte)18, n9);
            methodGen.add((byte)46);
            methodGen.add((byte)-75, (Object)this.me.field("r" + n9, Type.INT));
            methodGen2.add((byte)44);
            methodGen2.add((byte)18, n9);
            methodGen2.add((byte)42);
            methodGen2.add((byte)-76, (Object)this.me.field("r" + n9, Type.INT));
            methodGen2.add((byte)79);
            ++n9;
        }
        methodGen.add((byte)43);
        methodGen2.add((byte)43);
        methodGen.add((byte)-76, (Object)clazz4.field("f", (Type)Type.INT.makeArray()));
        methodGen2.add((byte)-76, (Object)clazz4.field("f", (Type)Type.INT.makeArray()));
        methodGen.add((byte)77);
        methodGen2.add((byte)77);
        n9 = 0;
        while (n9 < 32) {
            methodGen.add((byte)42);
            methodGen.add((byte)44);
            methodGen.add((byte)18, n9);
            methodGen.add((byte)46);
            if (this.singleFloat) {
                methodGen.add((byte)-72, (Object)Type.FLOAT_OBJECT.method("intBitsToFloat", Type.FLOAT, new Type[]{Type.INT}));
            }
            methodGen.add((byte)-75, (Object)this.me.field("f" + n9, this.singleFloat ? Type.FLOAT : Type.INT));
            methodGen2.add((byte)44);
            methodGen2.add((byte)18, n9);
            methodGen2.add((byte)42);
            methodGen2.add((byte)-76, (Object)this.me.field("f" + n9, this.singleFloat ? Type.FLOAT : Type.INT));
            if (this.singleFloat) {
                methodGen2.add((byte)-72, (Object)Type.FLOAT_OBJECT.method("floatToIntBits", Type.INT, new Type[]{Type.FLOAT}));
            }
            methodGen2.add((byte)79);
            ++n9;
        }
        String[] stringArray = new String[]{"hi", "lo", "fcsr", "pc"};
        int n10 = 0;
        while (n10 < stringArray.length) {
            methodGen.add((byte)42);
            methodGen.add((byte)43);
            methodGen.add((byte)-76, (Object)clazz4.field(stringArray[n10], Type.INT));
            methodGen.add((byte)-75, (Object)this.me.field(stringArray[n10], Type.INT));
            methodGen2.add((byte)43);
            methodGen2.add((byte)42);
            methodGen2.add((byte)-76, (Object)this.me.field(stringArray[n10], Type.INT));
            methodGen2.add((byte)-75, (Object)clazz4.field(stringArray[n10], Type.INT));
            ++n10;
        }
        methodGen.add((byte)-79);
        methodGen2.add((byte)-79);
        MethodGen methodGen3 = this.cg.addMethod("_execute", Type.VOID, Type.NO_ARGS, 4);
        int n11 = methodGen3.size();
        methodGen3.add((byte)42);
        methodGen3.add((byte)-73, (Object)this.me.method("trampoline", Type.VOID, Type.NO_ARGS));
        int n12 = methodGen3.size();
        methodGen3.add((byte)-79);
        int n13 = methodGen3.size();
        methodGen3.add((byte)76);
        methodGen3.add((byte)-69, (Object)Type.Class.instance((String)"org.ibex.nestedvm.Runtime$FaultException"));
        methodGen3.add((byte)89);
        methodGen3.add((byte)43);
        methodGen3.add((byte)-73, (Object)Type.Class.instance((String)"org.ibex.nestedvm.Runtime$FaultException").method("<init>", Type.VOID, new Type[]{Type.Class.instance((String)"java.lang.RuntimeException")}));
        methodGen3.add((byte)-65);
        methodGen3.addExceptionHandler(n11, n12, n13, Type.Class.instance((String)"java.lang.RuntimeException"));
        methodGen3.addThrow(Type.Class.instance((String)"org.ibex.nestedvm.Runtime$ExecutionException"));
        MethodGen methodGen4 = this.cg.addMethod("main", Type.VOID, new Type[]{Type.STRING.makeArray()}, 9);
        methodGen4.add((byte)-69, (Object)this.me);
        methodGen4.add((byte)89);
        methodGen4.add((byte)-73, (Object)this.me.method("<init>", Type.VOID, Type.NO_ARGS));
        methodGen4.add((byte)18, (Object)this.fullClassName);
        methodGen4.add((byte)42);
        if (this.unixRuntime) {
            Type.Class clazz5 = Type.Class.instance((String)"org.ibex.nestedvm.UnixRuntime");
            methodGen4.add((byte)-72, (Object)clazz5.method("runAndExec", Type.INT, new Type[]{clazz5, Type.STRING, Type.STRING.makeArray()}));
        } else {
            methodGen4.add((byte)-74, (Object)this.me.method("run", Type.INT, new Type[]{Type.STRING, Type.STRING.makeArray()}));
        }
        methodGen4.add((byte)-72, (Object)Type.Class.instance((String)"java.lang.System").method("exit", Type.VOID, new Type[]{Type.INT}));
        methodGen4.add((byte)-79);
        if (this.outDir != null) {
            if (!this.outDir.isDirectory()) {
                throw new IOException(this.outDir + " isn't a directory");
            }
            this.cg.dump(this.outDir);
        } else {
            this.cg.dump(this.os);
        }
    }

    private void addConstReturnMethod(String string, int n) {
        MethodGen methodGen = this.cg.addMethod(string, Type.INT, Type.NO_ARGS, 4);
        methodGen.add((byte)18, n);
        methodGen.add((byte)-84);
    }

    private void emitData(int n, DataInputStream dataInputStream, int n2, boolean bl) throws Compiler.Exn, IOException {
        if ((n & 3) != 0 || (n2 & 3) != 0) {
            throw new Compiler.Exn("Data section on weird boundaries");
        }
        int n3 = n + n2;
        while (n < n3) {
            int n4 = Math.min(n2, 28000);
            StringBuffer stringBuffer = new StringBuffer();
            int n5 = 0;
            while (n5 < n4) {
                long l = 0L;
                int n6 = 0;
                while (n6 < 7) {
                    l <<= 8;
                    byte by = n5 + n6 < n2 ? dataInputStream.readByte() : (byte)1;
                    l |= (long)by & 0xFFL;
                    ++n6;
                }
                n6 = 0;
                while (n6 < 8) {
                    stringBuffer.append((char)(l >>> 7 * (7 - n6) & 0x7FL));
                    ++n6;
                }
                n5 += 7;
            }
            String string = "_data" + ++initDataCount;
            this.cg.addField(string, (Type)Type.INT.makeArray(), 26);
            this.clinit.add((byte)18, (Object)stringBuffer.toString());
            this.clinit.add((byte)18, n4 / 4);
            this.clinit.add((byte)-72, (Object)Type.Class.instance((String)"org.ibex.nestedvm.Runtime").method("decodeData", (Type)Type.INT.makeArray(), new Type[]{Type.STRING, Type.INT}));
            this.clinit.add((byte)-77, (Object)this.me.field(string, (Type)Type.INT.makeArray()));
            this.init.add((byte)42);
            this.init.add((byte)-78, (Object)this.me.field(string, (Type)Type.INT.makeArray()));
            this.init.add((byte)18, n);
            this.init.add((byte)18, bl ? 1 : 0);
            this.init.add((byte)-74, (Object)this.me.method("initPages", Type.VOID, new Type[]{Type.INT.makeArray(), Type.INT, Type.BOOLEAN}));
            n += n4;
            n2 -= n4;
        }
        dataInputStream.close();
    }

    private void emitBSS(int n, int n2) throws Compiler.Exn {
        if ((n & 3) != 0) {
            throw new Compiler.Exn("BSS section on weird boundaries");
        }
        n2 = n2 + 3 & 0xFFFFFFFC;
        int n3 = n2 / 4;
        this.init.add((byte)42);
        this.init.add((byte)18, n);
        this.init.add((byte)18, n3);
        this.init.add((byte)-74, (Object)this.me.method("clearPages", Type.VOID, new Type[]{Type.INT, Type.INT}));
    }

    private boolean jumpable(int n) {
        return this.jumpableAddresses.get(new Integer(n)) != null;
    }

    private void emitText(int n, DataInputStream dataInputStream, int n2) throws Compiler.Exn, IOException {
        if (this.textDone) {
            throw new Compiler.Exn("Multiple text segments");
        }
        this.textDone = true;
        if ((n & 3) != 0 || (n2 & 3) != 0) {
            throw new Compiler.Exn("Section on weird boundaries");
        }
        int n3 = n2 / 4;
        int n4 = -1;
        boolean bl = true;
        boolean bl2 = false;
        int n5 = 0;
        while (n5 < n3) {
            block11: {
                int n6;
                block10: {
                    block9: {
                        n6 = bl ? dataInputStream.readInt() : n4;
                        int n7 = n4 = n5 == n3 - 1 ? -1 : dataInputStream.readInt();
                        if (n >= this.endOfMethod) {
                            this.endMethod(n, bl2);
                            this.startMethod(n);
                        }
                        if (this.insnTargets[n5 % this.maxInsnPerMethod] == null) break block9;
                        this.insnTargets[n5 % this.maxInsnPerMethod].setTarget(this.mg.size());
                        bl2 = false;
                        break block10;
                    }
                    if (bl2) break block11;
                }
                try {
                    int n8 = this.emitInstruction(n, n6, n4);
                    bl2 = (n8 & 1) != 0;
                    bl = (n8 & 2) != 0;
                }
                catch (Compiler.Exn exn) {
                    exn.printStackTrace(this.warn);
                    this.warn.println("Exception at " + ClassFileCompiler.toHex(n));
                    throw exn;
                }
                catch (RuntimeException runtimeException) {
                    this.warn.println("Exception at " + ClassFileCompiler.toHex(n));
                    throw runtimeException;
                }
                if (bl) {
                    n += 4;
                    ++n5;
                }
            }
            ++n5;
            n += 4;
        }
        this.endMethod(0, bl2);
        dataInputStream.close();
    }

    private void startMethod(int n) {
        this.startOfMethod = n & this.methodMask;
        this.endOfMethod = this.startOfMethod + this.maxBytesPerMethod;
        this.mg = this.cg.addMethod("run_" + ClassFileCompiler.toHex(this.startOfMethod), Type.VOID, Type.NO_ARGS, 18);
        if (this.onePage) {
            this.mg.add((byte)42);
            this.mg.add((byte)-76, (Object)this.me.field("page", (Type)Type.INT.makeArray()));
            this.mg.add((byte)77);
        } else {
            this.mg.add((byte)42);
            this.mg.add((byte)-76, (Object)this.me.field("readPages", (Type)Type.INT.makeArray(2)));
            this.mg.add((byte)77);
            this.mg.add((byte)42);
            this.mg.add((byte)-76, (Object)this.me.field("writePages", (Type)Type.INT.makeArray(2)));
            this.mg.add((byte)78);
        }
        this.returnTarget = new MethodGen.PhantomTarget();
        this.insnTargets = new MethodGen.PhantomTarget[this.maxBytesPerMethod / 4];
        int[] nArray = new int[this.maxBytesPerMethod / 4];
        Object[] objectArray = new Object[this.maxBytesPerMethod / 4];
        int n2 = 0;
        int n3 = n;
        while (n3 < this.endOfMethod) {
            if (this.jumpable(n3)) {
                MethodGen.PhantomTarget phantomTarget = new MethodGen.PhantomTarget();
                this.insnTargets[(n3 - this.startOfMethod) / 4] = phantomTarget;
                objectArray[n2] = phantomTarget;
                nArray[n2] = n3;
                ++n2;
            }
            n3 += 4;
        }
        MethodGen.Switch.Lookup lookup = new MethodGen.Switch.Lookup(n2);
        System.arraycopy(nArray, 0, lookup.vals, 0, n2);
        System.arraycopy(objectArray, 0, lookup.targets, 0, n2);
        this.defaultTarget = new MethodGen.PhantomTarget();
        lookup.setDefaultTarget((Object)this.defaultTarget);
        this.fixupRegsStart();
        this.mg.add((byte)42);
        this.mg.add((byte)-76, (Object)this.me.field("pc", Type.INT));
        this.mg.add((byte)-85, (Object)lookup);
    }

    private void endMethod(int n, boolean bl) {
        if (this.startOfMethod == 0) {
            return;
        }
        if (!bl) {
            this.preSetPC();
            this.mg.add((byte)18, n);
            this.setPC();
            this.jumpableAddresses.put(new Integer(n), Boolean.TRUE);
        }
        this.returnTarget.setTarget(this.mg.size());
        this.fixupRegsEnd();
        this.mg.add((byte)-79);
        this.defaultTarget.setTarget(this.mg.size());
        if (this.debugCompiler) {
            this.mg.add((byte)-69, (Object)Type.Class.instance((String)"org.ibex.nestedvm.Runtime$ExecutionException"));
            this.mg.add((byte)89);
            this.mg.add((byte)-69, (Object)Type.STRINGBUFFER);
            this.mg.add((byte)89);
            this.mg.add((byte)18, (Object)"Jumped to invalid address: ");
            this.mg.add((byte)-73, (Object)Type.STRINGBUFFER.method("<init>", Type.VOID, new Type[]{Type.STRING}));
            this.mg.add((byte)42);
            this.mg.add((byte)-76, (Object)this.me.field("pc", Type.INT));
            this.mg.add((byte)-74, (Object)Type.STRINGBUFFER.method("append", (Type)Type.STRINGBUFFER, new Type[]{Type.INT}));
            this.mg.add((byte)-74, (Object)Type.STRINGBUFFER.method("toString", (Type)Type.STRING, Type.NO_ARGS));
            this.mg.add((byte)-73, (Object)Type.Class.instance((String)"org.ibex.nestedvm.Runtime$ExecutionException").method("<init>", Type.VOID, new Type[]{Type.STRING}));
            this.mg.add((byte)-65);
        } else {
            this.mg.add((byte)-69, (Object)Type.Class.instance((String)"org.ibex.nestedvm.Runtime$ExecutionException"));
            this.mg.add((byte)89);
            this.mg.add((byte)18, (Object)"Jumped to invalid address");
            this.mg.add((byte)-73, (Object)Type.Class.instance((String)"org.ibex.nestedvm.Runtime$ExecutionException").method("<init>", Type.VOID, new Type[]{Type.STRING}));
            this.mg.add((byte)-65);
        }
        this.startOfMethod = 0;
        this.endOfMethod = 0;
    }

    private void leaveMethod() {
        this.mg.add((byte)-89, (Object)this.returnTarget);
    }

    private void link(int n) {
        this.preSetReg(31);
        if (this.lessConstants) {
            int n2 = n + 8 + 32768 & 0xFFFF0000;
            int n3 = n + 8 - n2;
            if (n3 < Short.MIN_VALUE || n3 > Short.MAX_VALUE) {
                throw new Error("should never happen " + n3);
            }
            this.mg.add((byte)18, n2);
            this.mg.add((byte)18, n3);
            this.mg.add((byte)96);
        } else {
            this.mg.add((byte)18, n + 8);
        }
        this.setReg();
    }

    private void branch(int n, int n2) {
        if ((n & this.methodMask) == (n2 & this.methodMask)) {
            this.mg.add((byte)-89, (Object)this.insnTargets[(n2 - this.startOfMethod) / 4]);
        } else {
            this.preSetPC();
            this.mg.add((byte)18, n2);
            this.setPC();
            this.leaveMethod();
        }
    }

    private int doIfInstruction(byte by, int n, int n2, int n3) throws Compiler.Exn {
        int n4;
        this.emitInstruction(-1, n3, -1);
        if ((n2 & this.methodMask) == (n & this.methodMask)) {
            this.mg.add(by, (Object)this.insnTargets[(n2 - this.startOfMethod) / 4]);
        } else {
            n4 = this.mg.add(MethodGen.negate((byte)by));
            this.branch(n, n2);
            this.mg.setArg(n4, this.mg.size());
        }
        if (!this.jumpable(n + 4)) {
            return 2;
        }
        if (n + 4 == this.endOfMethod) {
            this.jumpableAddresses.put(new Integer(n + 8), Boolean.TRUE);
            this.branch(n, n + 8);
            return 1;
        }
        n4 = this.mg.add((byte)-89);
        this.insnTargets[(n + 4 - this.startOfMethod) / 4].setTarget(this.mg.size());
        this.emitInstruction(-1, n3, 1);
        this.mg.setArg(n4, this.mg.size());
        return 2;
    }

    private int emitInstruction(int n, int n2, int n3) throws Compiler.Exn {
        int n4;
        MethodGen methodGen = this.mg;
        if (n2 == -1) {
            throw new Compiler.Exn("insn is -1");
        }
        int n5 = 0;
        int n6 = n2 >>> 26 & 0xFF;
        int n7 = n2 >>> 21 & 0x1F;
        int n8 = n2 >>> 16 & 0x1F;
        int n9 = n2 >>> 16 & 0x1F;
        int n10 = n2 >>> 11 & 0x1F;
        int n11 = n2 >>> 11 & 0x1F;
        int n12 = n2 >>> 6 & 0x1F;
        int n13 = n2 >>> 6 & 0x1F;
        int n14 = n2 & 0x3F;
        int n15 = n2 >>> 6 & 0xFFFFF;
        int n16 = n2 & 0x3FFFFFF;
        int n17 = n2 & 0xFFFF;
        int n18 = n4 = n2 << 16 >> 16;
        block0 : switch (n6) {
            case 0: {
                switch (n14) {
                    case 0: {
                        if (n2 == 0) break block0;
                        this.preSetReg(0 + n10);
                        this.pushRegWZ(0 + n8);
                        methodGen.add((byte)18, n12);
                        methodGen.add((byte)120);
                        this.setReg();
                        break block0;
                    }
                    case 2: {
                        this.preSetReg(0 + n10);
                        this.pushRegWZ(0 + n8);
                        methodGen.add((byte)18, n12);
                        methodGen.add((byte)124);
                        this.setReg();
                        break block0;
                    }
                    case 3: {
                        this.preSetReg(0 + n10);
                        this.pushRegWZ(0 + n8);
                        methodGen.add((byte)18, n12);
                        methodGen.add((byte)122);
                        this.setReg();
                        break block0;
                    }
                    case 4: {
                        this.preSetReg(0 + n10);
                        this.pushRegWZ(0 + n8);
                        this.pushRegWZ(0 + n7);
                        methodGen.add((byte)120);
                        this.setReg();
                        break block0;
                    }
                    case 6: {
                        this.preSetReg(0 + n10);
                        this.pushRegWZ(0 + n8);
                        this.pushRegWZ(0 + n7);
                        methodGen.add((byte)124);
                        this.setReg();
                        break block0;
                    }
                    case 7: {
                        this.preSetReg(0 + n10);
                        this.pushRegWZ(0 + n8);
                        this.pushRegWZ(0 + n7);
                        methodGen.add((byte)122);
                        this.setReg();
                        break block0;
                    }
                    case 8: {
                        if (n == -1) {
                            throw new Compiler.Exn("pc modifying insn in delay slot");
                        }
                        this.emitInstruction(-1, n3, -1);
                        this.preSetPC();
                        this.pushRegWZ(0 + n7);
                        this.setPC();
                        this.leaveMethod();
                        n5 |= 1;
                        break block0;
                    }
                    case 9: {
                        if (n == -1) {
                            throw new Compiler.Exn("pc modifying insn in delay slot");
                        }
                        this.emitInstruction(-1, n3, -1);
                        this.link(n);
                        this.preSetPC();
                        this.pushRegWZ(0 + n7);
                        this.setPC();
                        this.leaveMethod();
                        n5 |= 1;
                        break block0;
                    }
                    case 12: {
                        this.preSetPC();
                        methodGen.add((byte)18, n);
                        this.setPC();
                        this.restoreChangedRegs();
                        this.preSetReg(2);
                        methodGen.add((byte)42);
                        this.pushRegZ(2);
                        this.pushRegZ(4);
                        this.pushRegZ(5);
                        this.pushRegZ(6);
                        this.pushRegZ(7);
                        this.pushRegZ(8);
                        this.pushRegZ(9);
                        methodGen.add((byte)-74, (Object)this.me.method("syscall", Type.INT, new Type[]{Type.INT, Type.INT, Type.INT, Type.INT, Type.INT, Type.INT, Type.INT}));
                        this.setReg();
                        methodGen.add((byte)42);
                        methodGen.add((byte)-76, (Object)this.me.field("state", Type.INT));
                        int n19 = methodGen.add((byte)-103);
                        this.preSetPC();
                        methodGen.add((byte)18, n + 4);
                        this.setPC();
                        this.leaveMethod();
                        methodGen.setArg(n19, methodGen.size());
                        break block0;
                    }
                    case 13: {
                        methodGen.add((byte)-69, (Object)Type.Class.instance((String)"org.ibex.nestedvm.Runtime$ExecutionException"));
                        methodGen.add((byte)89);
                        methodGen.add((byte)18, (Object)("BREAK Code " + ClassFileCompiler.toHex(n15)));
                        methodGen.add((byte)-73, (Object)Type.Class.instance((String)"org.ibex.nestedvm.Runtime$ExecutionException").method("<init>", Type.VOID, new Type[]{Type.STRING}));
                        methodGen.add((byte)-65);
                        n5 |= 1;
                        break block0;
                    }
                    case 16: {
                        this.preSetReg(0 + n10);
                        this.pushReg(64);
                        this.setReg();
                        break block0;
                    }
                    case 17: {
                        this.preSetReg(64);
                        this.pushRegZ(0 + n7);
                        this.setReg();
                        break block0;
                    }
                    case 18: {
                        this.preSetReg(0 + n10);
                        this.pushReg(65);
                        this.setReg();
                        break block0;
                    }
                    case 19: {
                        this.preSetReg(65);
                        this.pushRegZ(0 + n7);
                        this.setReg();
                        break block0;
                    }
                    case 24: {
                        this.pushRegWZ(0 + n7);
                        methodGen.add((byte)-123);
                        this.pushRegWZ(0 + n8);
                        methodGen.add((byte)-123);
                        methodGen.add((byte)105);
                        methodGen.add((byte)92);
                        methodGen.add((byte)-120);
                        if (this.preSetReg(65)) {
                            methodGen.add((byte)95);
                        }
                        this.setReg();
                        methodGen.add((byte)18, 32);
                        methodGen.add((byte)125);
                        methodGen.add((byte)-120);
                        if (this.preSetReg(64)) {
                            methodGen.add((byte)95);
                        }
                        this.setReg();
                        break block0;
                    }
                    case 25: {
                        this.pushRegWZ(0 + n7);
                        methodGen.add((byte)-123);
                        methodGen.add((byte)18, (Object)FFFFFFFF);
                        methodGen.add((byte)127);
                        this.pushRegWZ(0 + n8);
                        methodGen.add((byte)-123);
                        methodGen.add((byte)18, (Object)FFFFFFFF);
                        methodGen.add((byte)127);
                        methodGen.add((byte)105);
                        methodGen.add((byte)92);
                        methodGen.add((byte)-120);
                        if (this.preSetReg(65)) {
                            methodGen.add((byte)95);
                        }
                        this.setReg();
                        methodGen.add((byte)18, 32);
                        methodGen.add((byte)125);
                        methodGen.add((byte)-120);
                        if (this.preSetReg(64)) {
                            methodGen.add((byte)95);
                        }
                        this.setReg();
                        break block0;
                    }
                    case 26: {
                        this.pushRegWZ(0 + n7);
                        this.pushRegWZ(0 + n8);
                        methodGen.add((byte)92);
                        methodGen.add((byte)108);
                        if (this.preSetReg(65)) {
                            methodGen.add((byte)95);
                        }
                        this.setReg();
                        methodGen.add((byte)112);
                        if (this.preSetReg(64)) {
                            methodGen.add((byte)95);
                        }
                        this.setReg();
                        break block0;
                    }
                    case 27: {
                        this.pushRegWZ(0 + n8);
                        methodGen.add((byte)89);
                        this.setTmp();
                        int n20 = methodGen.add((byte)-103);
                        this.pushRegWZ(0 + n7);
                        methodGen.add((byte)-123);
                        methodGen.add((byte)18, (Object)FFFFFFFF);
                        methodGen.add((byte)127);
                        methodGen.add((byte)92);
                        this.pushTmp();
                        methodGen.add((byte)-123);
                        methodGen.add((byte)18, (Object)FFFFFFFF);
                        methodGen.add((byte)127);
                        methodGen.add((byte)94);
                        methodGen.add((byte)109);
                        methodGen.add((byte)-120);
                        if (this.preSetReg(65)) {
                            methodGen.add((byte)95);
                        }
                        this.setReg();
                        methodGen.add((byte)113);
                        methodGen.add((byte)-120);
                        if (this.preSetReg(64)) {
                            methodGen.add((byte)95);
                        }
                        this.setReg();
                        methodGen.setArg(n20, methodGen.size());
                        break block0;
                    }
                    case 32: {
                        throw new Compiler.Exn("ADD (add with oveflow trap) not suported");
                    }
                    case 33: {
                        this.preSetReg(0 + n10);
                        if (n8 != 0 && n7 != 0) {
                            this.pushReg(0 + n7);
                            this.pushReg(0 + n8);
                            methodGen.add((byte)96);
                        } else if (n7 != 0) {
                            this.pushReg(0 + n7);
                        } else {
                            this.pushRegZ(0 + n8);
                        }
                        this.setReg();
                        break block0;
                    }
                    case 34: {
                        throw new Compiler.Exn("SUB (add with oveflow trap) not suported");
                    }
                    case 35: {
                        this.preSetReg(0 + n10);
                        if (n8 != 0 && n7 != 0) {
                            this.pushReg(0 + n7);
                            this.pushReg(0 + n8);
                            methodGen.add((byte)100);
                        } else if (n8 != 0) {
                            this.pushReg(0 + n8);
                            methodGen.add((byte)116);
                        } else {
                            this.pushRegZ(0 + n7);
                        }
                        this.setReg();
                        break block0;
                    }
                    case 36: {
                        this.preSetReg(0 + n10);
                        this.pushRegWZ(0 + n7);
                        this.pushRegWZ(0 + n8);
                        methodGen.add((byte)126);
                        this.setReg();
                        break block0;
                    }
                    case 37: {
                        this.preSetReg(0 + n10);
                        this.pushRegWZ(0 + n7);
                        this.pushRegWZ(0 + n8);
                        methodGen.add((byte)-128);
                        this.setReg();
                        break block0;
                    }
                    case 38: {
                        this.preSetReg(0 + n10);
                        this.pushRegWZ(0 + n7);
                        this.pushRegWZ(0 + n8);
                        methodGen.add((byte)-126);
                        this.setReg();
                        break block0;
                    }
                    case 39: {
                        this.preSetReg(0 + n10);
                        if (n7 != 0 || n8 != 0) {
                            if (n7 != 0 && n8 != 0) {
                                this.pushReg(0 + n7);
                                this.pushReg(0 + n8);
                                methodGen.add((byte)-128);
                            } else if (n7 != 0) {
                                this.pushReg(0 + n7);
                            } else {
                                this.pushReg(0 + n8);
                            }
                            methodGen.add((byte)2);
                            methodGen.add((byte)-126);
                        } else {
                            methodGen.add((byte)18, -1);
                        }
                        this.setReg();
                        break block0;
                    }
                    case 42: {
                        this.preSetReg(0 + n10);
                        if (n7 != n8) {
                            this.pushRegZ(0 + n7);
                            this.pushRegZ(0 + n8);
                            int n21 = methodGen.add((byte)-95);
                            methodGen.add((byte)3);
                            int n22 = methodGen.add((byte)-89);
                            methodGen.setArg(n21, methodGen.add((byte)4));
                            methodGen.setArg(n22, methodGen.size());
                        } else {
                            methodGen.add((byte)18, 0);
                        }
                        this.setReg();
                        break block0;
                    }
                    case 43: {
                        this.preSetReg(0 + n10);
                        if (n7 != n8) {
                            int n23;
                            if (n7 != 0) {
                                this.pushReg(0 + n7);
                                methodGen.add((byte)-123);
                                methodGen.add((byte)18, (Object)FFFFFFFF);
                                methodGen.add((byte)127);
                                this.pushReg(0 + n8);
                                methodGen.add((byte)-123);
                                methodGen.add((byte)18, (Object)FFFFFFFF);
                                methodGen.add((byte)127);
                                methodGen.add((byte)-108);
                                n23 = methodGen.add((byte)-101);
                            } else {
                                this.pushReg(0 + n8);
                                n23 = methodGen.add((byte)-102);
                            }
                            methodGen.add((byte)3);
                            int n24 = methodGen.add((byte)-89);
                            methodGen.setArg(n23, methodGen.add((byte)4));
                            methodGen.setArg(n24, methodGen.size());
                        } else {
                            methodGen.add((byte)18, 0);
                        }
                        this.setReg();
                        break block0;
                    }
                    default: {
                        throw new Compiler.Exn("Illegal instruction 0/" + n14);
                    }
                }
            }
            case 1: {
                switch (n8) {
                    case 0: {
                        if (n == -1) {
                            throw new Compiler.Exn("pc modifying insn in delay slot");
                        }
                        this.pushRegWZ(0 + n7);
                        return this.doIfInstruction((byte)-101, n, n + n18 * 4 + 4, n3);
                    }
                    case 1: {
                        if (n == -1) {
                            throw new Compiler.Exn("pc modifying insn in delay slot");
                        }
                        this.pushRegWZ(0 + n7);
                        return this.doIfInstruction((byte)-100, n, n + n18 * 4 + 4, n3);
                    }
                    case 16: {
                        if (n == -1) {
                            throw new Compiler.Exn("pc modifying insn in delay slot");
                        }
                        this.pushRegWZ(0 + n7);
                        int n25 = methodGen.add((byte)-100);
                        this.emitInstruction(-1, n3, -1);
                        this.link(n);
                        this.branch(n, n + n18 * 4 + 4);
                        methodGen.setArg(n25, methodGen.size());
                        break block0;
                    }
                    case 17: {
                        if (n == -1) {
                            throw new Compiler.Exn("pc modifying insn in delay slot");
                        }
                        int n26 = -1;
                        if (n7 != 0) {
                            this.pushRegWZ(0 + n7);
                            n26 = methodGen.add((byte)-101);
                        }
                        this.emitInstruction(-1, n3, -1);
                        this.link(n);
                        this.branch(n, n + n18 * 4 + 4);
                        if (n26 != -1) {
                            methodGen.setArg(n26, methodGen.size());
                        }
                        if (n26 != -1) break block0;
                        n5 |= 1;
                        break block0;
                    }
                    default: {
                        throw new Compiler.Exn("Illegal Instruction 1/" + n8);
                    }
                }
            }
            case 2: {
                if (n == -1) {
                    throw new Compiler.Exn("pc modifying insn in delay slot");
                }
                this.emitInstruction(-1, n3, -1);
                this.branch(n, n & 0xF0000000 | n16 << 2);
                n5 |= 1;
                break;
            }
            case 3: {
                if (n == -1) {
                    throw new Compiler.Exn("pc modifying insn in delay slot");
                }
                int n27 = n & 0xF0000000 | n16 << 2;
                this.emitInstruction(-1, n3, -1);
                this.link(n);
                this.branch(n, n27);
                n5 |= 1;
                break;
            }
            case 4: {
                if (n == -1) {
                    throw new Compiler.Exn("pc modifying insn in delay slot");
                }
                if (n7 == n8) {
                    this.emitInstruction(-1, n3, -1);
                    this.branch(n, n + n18 * 4 + 4);
                    n5 |= 1;
                    break;
                }
                if (n7 == 0 || n8 == 0) {
                    this.pushReg(n8 == 0 ? 0 + n7 : 0 + n8);
                    return this.doIfInstruction((byte)-103, n, n + n18 * 4 + 4, n3);
                }
                this.pushReg(0 + n7);
                this.pushReg(0 + n8);
                return this.doIfInstruction((byte)-97, n, n + n18 * 4 + 4, n3);
            }
            case 5: {
                if (n == -1) {
                    throw new Compiler.Exn("pc modifying insn in delay slot");
                }
                this.pushRegWZ(0 + n7);
                if (n8 == 0) {
                    return this.doIfInstruction((byte)-102, n, n + n18 * 4 + 4, n3);
                }
                this.pushReg(0 + n8);
                return this.doIfInstruction((byte)-96, n, n + n18 * 4 + 4, n3);
            }
            case 6: {
                if (n == -1) {
                    throw new Compiler.Exn("pc modifying insn in delay slot");
                }
                this.pushRegWZ(0 + n7);
                return this.doIfInstruction((byte)-98, n, n + n18 * 4 + 4, n3);
            }
            case 7: {
                if (n == -1) {
                    throw new Compiler.Exn("pc modifying insn in delay slot");
                }
                this.pushRegWZ(0 + n7);
                return this.doIfInstruction((byte)-99, n, n + n18 * 4 + 4, n3);
            }
            case 8: {
                throw new Compiler.Exn("ADDI (add immediate with oveflow trap) not suported");
            }
            case 9: {
                if (n7 != 0 && n4 != 0 && n7 == n8 && this.doLocal(n8) && n4 >= Short.MIN_VALUE && n4 <= Short.MAX_VALUE) {
                    this.regLocalWritten[n8] = true;
                    methodGen.add((byte)-124, (Object)new MethodGen.Pair(this.getLocalForReg(n8), n4));
                    break;
                }
                this.preSetReg(0 + n8);
                this.addiu(n7, n4);
                this.setReg();
                break;
            }
            case 10: {
                this.preSetReg(0 + n8);
                this.pushRegWZ(0 + n7);
                methodGen.add((byte)18, n4);
                int n28 = methodGen.add((byte)-95);
                methodGen.add((byte)3);
                int n29 = methodGen.add((byte)-89);
                methodGen.setArg(n28, methodGen.add((byte)4));
                methodGen.setArg(n29, methodGen.size());
                this.setReg();
                break;
            }
            case 11: {
                this.preSetReg(0 + n8);
                this.pushRegWZ(0 + n7);
                methodGen.add((byte)-123);
                methodGen.add((byte)18, (Object)FFFFFFFF);
                methodGen.add((byte)127);
                methodGen.add((byte)18, (Object)new Long((long)n4 & 0xFFFFFFFFL));
                methodGen.add((byte)-108);
                int n30 = methodGen.add((byte)-101);
                methodGen.add((byte)3);
                int n31 = methodGen.add((byte)-89);
                methodGen.setArg(n30, methodGen.add((byte)4));
                methodGen.setArg(n31, methodGen.size());
                this.setReg();
                break;
            }
            case 12: {
                this.preSetReg(0 + n8);
                this.pushRegWZ(0 + n7);
                methodGen.add((byte)18, n17);
                methodGen.add((byte)126);
                this.setReg();
                break;
            }
            case 13: {
                this.preSetReg(0 + n8);
                if (n7 != 0 && n17 != 0) {
                    this.pushReg(0 + n7);
                    methodGen.add((byte)18, n17);
                    methodGen.add((byte)-128);
                } else if (n7 != 0) {
                    this.pushReg(0 + n7);
                } else {
                    methodGen.add((byte)18, n17);
                }
                this.setReg();
                break;
            }
            case 14: {
                this.preSetReg(0 + n8);
                this.pushRegWZ(0 + n7);
                methodGen.add((byte)18, n17);
                methodGen.add((byte)-126);
                this.setReg();
                break;
            }
            case 15: {
                this.preSetReg(0 + n8);
                methodGen.add((byte)18, n17 << 16);
                this.setReg();
                break;
            }
            case 16: {
                throw new Compiler.Exn("TLB/Exception support not implemented");
            }
            case 17: {
                switch (n7) {
                    case 0: {
                        this.preSetReg(0 + n8);
                        this.pushReg(32 + n10);
                        this.setReg();
                        break block0;
                    }
                    case 2: {
                        if (n11 != 31) {
                            throw new Compiler.Exn("FCR " + n11 + " unavailable");
                        }
                        this.preSetReg(0 + n8);
                        this.pushReg(66);
                        this.setReg();
                        break block0;
                    }
                    case 4: {
                        this.preSetReg(32 + n10);
                        if (n8 != 0) {
                            this.pushReg(0 + n8);
                        } else {
                            methodGen.add((byte)3);
                        }
                        this.setReg();
                        break block0;
                    }
                    case 6: {
                        if (n11 != 31) {
                            throw new Compiler.Exn("FCR " + n11 + " unavailable");
                        }
                        this.preSetReg(66);
                        this.pushReg(0 + n8);
                        this.setReg();
                        break block0;
                    }
                    case 8: {
                        this.pushReg(66);
                        methodGen.add((byte)18, 0x800000);
                        methodGen.add((byte)126);
                        return this.doIfInstruction((n2 >>> 16 & 1) == 0 ? (byte)-103 : -102, n, n + n18 * 4 + 4, n3);
                    }
                    case 16: 
                    case 17: {
                        boolean bl = n7 == 17;
                        switch (n14) {
                            case 0: {
                                this.preSetDouble(32 + n13, bl);
                                this.pushDouble(32 + n11, bl);
                                this.pushDouble(32 + n9, bl);
                                methodGen.add(bl ? (byte)99 : 98);
                                this.setDouble(bl);
                                break block0;
                            }
                            case 1: {
                                this.preSetDouble(32 + n13, bl);
                                this.pushDouble(32 + n11, bl);
                                this.pushDouble(32 + n9, bl);
                                methodGen.add(bl ? (byte)103 : 102);
                                this.setDouble(bl);
                                break block0;
                            }
                            case 2: {
                                this.preSetDouble(32 + n13, bl);
                                this.pushDouble(32 + n11, bl);
                                this.pushDouble(32 + n9, bl);
                                methodGen.add(bl ? (byte)107 : 106);
                                this.setDouble(bl);
                                break block0;
                            }
                            case 3: {
                                this.preSetDouble(32 + n13, bl);
                                this.pushDouble(32 + n11, bl);
                                this.pushDouble(32 + n9, bl);
                                methodGen.add(bl ? (byte)111 : 110);
                                this.setDouble(bl);
                                break block0;
                            }
                            case 5: {
                                this.preSetDouble(32 + n13, bl);
                                this.pushDouble(32 + n11, bl);
                                methodGen.add(bl ? (byte)92 : 89);
                                methodGen.add(bl ? (byte)14 : 11);
                                methodGen.add(bl ? (byte)-104 : -106);
                                int n32 = methodGen.add((byte)-99);
                                methodGen.add(bl ? (byte)14 : 11);
                                if (bl) {
                                    methodGen.add((byte)94);
                                    methodGen.add((byte)88);
                                } else {
                                    methodGen.add((byte)95);
                                }
                                methodGen.add(bl ? (byte)103 : 102);
                                methodGen.setArg(n32, methodGen.size());
                                this.setDouble(bl);
                                break block0;
                            }
                            case 6: {
                                this.preSetReg(32 + n13);
                                this.pushReg(32 + n11);
                                this.setReg();
                                if (!bl) break block0;
                                this.preSetReg(32 + n13 + 1);
                                this.pushReg(32 + n11 + 1);
                                this.setReg();
                                break block0;
                            }
                            case 7: {
                                this.preSetDouble(32 + n13, bl);
                                this.pushDouble(32 + n11, bl);
                                methodGen.add(bl ? (byte)119 : 118);
                                this.setDouble(bl);
                                break block0;
                            }
                            case 32: {
                                this.preSetFloat(32 + n13);
                                this.pushDouble(32 + n11, bl);
                                if (bl) {
                                    methodGen.add((byte)-112);
                                }
                                this.setFloat();
                                break block0;
                            }
                            case 33: {
                                this.preSetDouble(32 + n13);
                                this.pushDouble(32 + n11, bl);
                                if (!bl) {
                                    methodGen.add((byte)-115);
                                }
                                this.setDouble();
                                break block0;
                            }
                            case 36: {
                                MethodGen.Switch.Table table = new MethodGen.Switch.Table(0, 3);
                                this.preSetReg(32 + n13);
                                this.pushDouble(32 + n11, bl);
                                this.pushReg(66);
                                methodGen.add((byte)6);
                                methodGen.add((byte)126);
                                methodGen.add((byte)-86, (Object)table);
                                table.setTarget(2, methodGen.size());
                                if (!bl) {
                                    methodGen.add((byte)-115);
                                }
                                methodGen.add((byte)-72, (Object)Type.Class.instance((String)"java.lang.Math").method("ceil", Type.DOUBLE, new Type[]{Type.DOUBLE}));
                                if (!bl) {
                                    methodGen.add((byte)-112);
                                }
                                int n33 = methodGen.add((byte)-89);
                                table.setTarget(0, methodGen.size());
                                methodGen.add((byte)18, (Object)(bl ? (Number)POINT_5_D : (Number)POINT_5_F));
                                methodGen.add(bl ? (byte)99 : 98);
                                table.setTarget(3, methodGen.size());
                                if (!bl) {
                                    methodGen.add((byte)-115);
                                }
                                methodGen.add((byte)-72, (Object)Type.Class.instance((String)"java.lang.Math").method("floor", Type.DOUBLE, new Type[]{Type.DOUBLE}));
                                if (!bl) {
                                    methodGen.add((byte)-112);
                                }
                                table.setTarget(1, methodGen.size());
                                table.setDefaultTarget(methodGen.size());
                                methodGen.setArg(n33, methodGen.size());
                                methodGen.add(bl ? (byte)-114 : -117);
                                this.setReg();
                                break block0;
                            }
                            case 50: 
                            case 60: 
                            case 62: {
                                int n34;
                                this.preSetReg(66);
                                this.pushReg(66);
                                methodGen.add((byte)18, -8388609);
                                methodGen.add((byte)126);
                                this.pushDouble(32 + n11, bl);
                                this.pushDouble(32 + n9, bl);
                                methodGen.add(bl ? (byte)-104 : -106);
                                switch (n14) {
                                    case 50: {
                                        n34 = methodGen.add((byte)-102);
                                        break;
                                    }
                                    case 60: {
                                        n34 = methodGen.add((byte)-100);
                                        break;
                                    }
                                    case 62: {
                                        n34 = methodGen.add((byte)-99);
                                        break;
                                    }
                                    default: {
                                        n34 = -1;
                                    }
                                }
                                methodGen.add((byte)18, 0x800000);
                                methodGen.add((byte)-128);
                                methodGen.setArg(n34, methodGen.size());
                                this.setReg();
                                break block0;
                            }
                            default: {
                                throw new Compiler.Exn("Invalid Instruction 17/" + n7 + "/" + n14);
                            }
                        }
                    }
                    case 20: {
                        switch (n14) {
                            case 32: {
                                this.preSetFloat(32 + n13);
                                this.pushReg(32 + n11);
                                methodGen.add((byte)-122);
                                this.setFloat();
                                break block0;
                            }
                            case 33: {
                                this.preSetDouble(32 + n13);
                                this.pushReg(32 + n11);
                                methodGen.add((byte)-121);
                                this.setDouble();
                                break block0;
                            }
                        }
                        throw new Compiler.Exn("Invalid Instruction 17/" + n7 + "/" + n14);
                    }
                    default: {
                        throw new Compiler.Exn("Invalid Instruction 17/" + n7);
                    }
                }
            }
            case 18: 
            case 19: {
                throw new Compiler.Exn("coprocessor 2 and 3 instructions not available");
            }
            case 32: {
                this.preSetReg(0 + n8);
                this.addiu(0 + n7, n4);
                this.setTmp();
                this.preMemRead();
                this.pushTmp();
                this.memRead(true);
                this.pushTmp();
                methodGen.add((byte)2);
                methodGen.add((byte)-126);
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)124);
                methodGen.add((byte)-111);
                this.setReg();
                break;
            }
            case 33: {
                this.preSetReg(0 + n8);
                this.addiu(0 + n7, n4);
                this.setTmp();
                this.preMemRead();
                this.pushTmp();
                this.memRead(true);
                this.pushTmp();
                methodGen.add((byte)2);
                methodGen.add((byte)-126);
                methodGen.add((byte)5);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)124);
                methodGen.add((byte)-109);
                this.setReg();
                break;
            }
            case 34: {
                this.preSetReg(0 + n8);
                this.addiu(0 + n7, n4);
                this.setTmp();
                this.pushRegWZ(0 + n8);
                methodGen.add((byte)18, 0xFFFFFF);
                this.pushTmp();
                methodGen.add((byte)2);
                methodGen.add((byte)-126);
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)124);
                methodGen.add((byte)126);
                this.preMemRead();
                this.pushTmp();
                this.memRead(true);
                this.pushTmp();
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)120);
                methodGen.add((byte)-128);
                this.setReg();
                break;
            }
            case 35: {
                this.preSetReg(0 + n8);
                this.memRead(0 + n7, n4);
                this.setReg();
                break;
            }
            case 36: {
                this.preSetReg(0 + n8);
                this.addiu(0 + n7, n4);
                this.setTmp();
                this.preMemRead();
                this.pushTmp();
                this.memRead(true);
                this.pushTmp();
                methodGen.add((byte)2);
                methodGen.add((byte)-126);
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)124);
                methodGen.add((byte)18, 255);
                methodGen.add((byte)126);
                this.setReg();
                break;
            }
            case 37: {
                this.preSetReg(0 + n8);
                this.addiu(0 + n7, n4);
                this.setTmp();
                this.preMemRead();
                this.pushTmp();
                this.memRead(true);
                this.pushTmp();
                methodGen.add((byte)2);
                methodGen.add((byte)-126);
                methodGen.add((byte)5);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)124);
                methodGen.add((byte)-110);
                this.setReg();
                break;
            }
            case 38: {
                this.preSetReg(0 + n8);
                this.addiu(0 + n7, n4);
                this.setTmp();
                this.pushRegWZ(0 + n8);
                methodGen.add((byte)18, -256);
                this.pushTmp();
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)120);
                methodGen.add((byte)126);
                this.preMemRead();
                this.pushTmp();
                this.memRead(true);
                this.pushTmp();
                methodGen.add((byte)2);
                methodGen.add((byte)-126);
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)124);
                methodGen.add((byte)-128);
                this.setReg();
                break;
            }
            case 40: {
                this.addiu(0 + n7, n4);
                this.setTmp();
                this.preMemRead(true);
                this.pushTmp();
                this.memRead(true);
                methodGen.add((byte)18, -16777216);
                this.pushTmp();
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)124);
                methodGen.add((byte)2);
                methodGen.add((byte)-126);
                methodGen.add((byte)126);
                if (n8 != 0) {
                    this.pushReg(0 + n8);
                    methodGen.add((byte)18, 255);
                    methodGen.add((byte)126);
                } else {
                    methodGen.add((byte)18, 0);
                }
                this.pushTmp();
                methodGen.add((byte)2);
                methodGen.add((byte)-126);
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)120);
                methodGen.add((byte)-128);
                this.memWrite();
                break;
            }
            case 41: {
                this.addiu(0 + n7, n4);
                this.setTmp();
                this.preMemRead(true);
                this.pushTmp();
                this.memRead(true);
                methodGen.add((byte)18, 65535);
                this.pushTmp();
                methodGen.add((byte)5);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)120);
                methodGen.add((byte)126);
                if (n8 != 0) {
                    this.pushReg(0 + n8);
                    methodGen.add((byte)18, 65535);
                    methodGen.add((byte)126);
                } else {
                    methodGen.add((byte)18, 0);
                }
                this.pushTmp();
                methodGen.add((byte)2);
                methodGen.add((byte)-126);
                methodGen.add((byte)5);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)120);
                methodGen.add((byte)-128);
                this.memWrite();
                break;
            }
            case 42: {
                this.addiu(0 + n7, n4);
                this.setTmp();
                this.preMemRead(true);
                this.pushTmp();
                this.memRead(true);
                methodGen.add((byte)18, -256);
                this.pushTmp();
                methodGen.add((byte)2);
                methodGen.add((byte)-126);
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)120);
                methodGen.add((byte)126);
                this.pushRegWZ(0 + n8);
                this.pushTmp();
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)124);
                methodGen.add((byte)-128);
                this.memWrite();
                break;
            }
            case 43: {
                this.preMemWrite1();
                this.preMemWrite2(0 + n7, n4);
                this.pushRegZ(0 + n8);
                this.memWrite();
                break;
            }
            case 46: {
                this.addiu(0 + n7, n4);
                this.setTmp();
                this.preMemRead(true);
                this.pushTmp();
                this.memRead(true);
                methodGen.add((byte)18, 0xFFFFFF);
                this.pushTmp();
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)124);
                methodGen.add((byte)126);
                this.pushRegWZ(0 + n8);
                this.pushTmp();
                methodGen.add((byte)2);
                methodGen.add((byte)-126);
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)120);
                methodGen.add((byte)-128);
                this.memWrite();
                break;
            }
            case 48: {
                this.preSetReg(0 + n8);
                this.memRead(0 + n7, n4);
                this.setReg();
                break;
            }
            case 49: {
                this.preSetReg(32 + n8);
                this.memRead(0 + n7, n4);
                this.setReg();
                break;
            }
            case 56: {
                this.preSetReg(0 + n8);
                this.preMemWrite1();
                this.preMemWrite2(0 + n7, n4);
                this.pushReg(0 + n8);
                this.memWrite();
                methodGen.add((byte)18, 1);
                this.setReg();
                break;
            }
            case 57: {
                this.preMemWrite1();
                this.preMemWrite2(0 + n7, n4);
                this.pushReg(32 + n8);
                this.memWrite();
                break;
            }
            default: {
                throw new Compiler.Exn("Invalid Instruction: " + n6 + " at " + ClassFileCompiler.toHex(n));
            }
        }
        return n5;
    }

    private boolean doLocal(int n) {
        return n == 2 || n == 3 || n == 4 || n == 29;
    }

    private int getLocalForReg(int n) {
        if (this.regLocalMapping[n] != 0) {
            return this.regLocalMapping[n];
        }
        ++this.nextAvailLocal;
        return this.regLocalMapping[n];
    }

    private void fixupRegsStart() {
        int n = 0;
        while (n < 67) {
            this.regLocalMapping[n] = 0;
            this.regLocalWritten[n] = false;
            ++n;
        }
        this.nextAvailLocal = this.onePage ? 4 : 5;
        this.loadsStart = this.mg.size();
        n = 0;
        while (n < 12) {
            this.mg.add((byte)0);
            ++n;
        }
    }

    private void fixupRegsEnd() {
        int n = this.loadsStart;
        int n2 = 0;
        while (n2 < 67) {
            if (this.regLocalMapping[n2] != 0) {
                this.mg.set(n++, (byte)42);
                this.mg.set(n++, (byte)-76, (Object)this.me.field(regField[n2], Type.INT));
                this.mg.set(n++, (byte)54, this.regLocalMapping[n2]);
                if (this.regLocalWritten[n2]) {
                    this.mg.add((byte)42);
                    this.mg.add((byte)21, this.regLocalMapping[n2]);
                    this.mg.add((byte)-75, (Object)this.me.field(regField[n2], Type.INT));
                }
            }
            ++n2;
        }
    }

    private void restoreChangedRegs() {
        int n = 0;
        while (n < 67) {
            if (this.regLocalWritten[n]) {
                this.mg.add((byte)42);
                this.mg.add((byte)21, this.regLocalMapping[n]);
                this.mg.add((byte)-75, (Object)this.me.field(regField[n], Type.INT));
            }
            ++n;
        }
    }

    private int pushRegWZ(int n) {
        if (n == 0) {
            this.warn.println("Warning: Pushing r0!");
            new Exception().printStackTrace(this.warn);
        }
        return this.pushRegZ(n);
    }

    private int pushRegZ(int n) {
        if (n == 0) {
            return this.mg.add((byte)3);
        }
        return this.pushReg(n);
    }

    private int pushReg(int n) {
        int n2 = this.mg.size();
        if (this.doLocal(n)) {
            this.mg.add((byte)21, this.getLocalForReg(n));
        } else if (n >= 32 && n <= 63 && this.singleFloat) {
            this.mg.add((byte)42);
            this.mg.add((byte)-76, (Object)this.me.field(regField[n], Type.FLOAT));
            this.mg.add((byte)-72, (Object)Type.FLOAT_OBJECT.method("floatToIntBits", Type.INT, new Type[]{Type.FLOAT}));
        } else {
            this.mg.add((byte)42);
            this.mg.add((byte)-76, (Object)this.me.field(regField[n], Type.INT));
        }
        return n2;
    }

    private boolean preSetReg(int n) {
        this.preSetRegStack[this.preSetRegStackPos] = n;
        ++this.preSetRegStackPos;
        if (this.doLocal(n)) {
            return false;
        }
        this.mg.add((byte)42);
        return true;
    }

    private int setReg() {
        if (this.preSetRegStackPos == 0) {
            throw new RuntimeException("didn't do preSetReg");
        }
        --this.preSetRegStackPos;
        int n = this.preSetRegStack[this.preSetRegStackPos];
        int n2 = this.mg.size();
        if (this.doLocal(n)) {
            this.mg.add((byte)54, this.getLocalForReg(n));
            this.regLocalWritten[n] = true;
        } else if (n >= 32 && n <= 63 && this.singleFloat) {
            this.mg.add((byte)-72, (Object)Type.FLOAT_OBJECT.method("intBitsToFloat", Type.FLOAT, new Type[]{Type.INT}));
            this.mg.add((byte)-75, (Object)this.me.field(regField[n], Type.FLOAT));
        } else {
            this.mg.add((byte)-75, (Object)this.me.field(regField[n], Type.INT));
        }
        return n2;
    }

    private int preSetPC() {
        return this.mg.add((byte)42);
    }

    private int setPC() {
        return this.mg.add((byte)-75, (Object)this.me.field("pc", Type.INT));
    }

    private int pushFloat(int n) throws Compiler.Exn {
        return this.pushDouble(n, false);
    }

    private int pushDouble(int n, boolean bl) throws Compiler.Exn {
        if (n < 32 || n >= 64) {
            throw new IllegalArgumentException("" + n);
        }
        int n2 = this.mg.size();
        if (bl) {
            if (this.singleFloat) {
                throw new Compiler.Exn("Double operations not supported when singleFloat is enabled");
            }
            if (n == 63) {
                throw new Compiler.Exn("Tried to use a double in f31");
            }
            this.pushReg(n + 1);
            this.mg.add((byte)-123);
            this.mg.add((byte)18, 32);
            this.mg.add((byte)121);
            this.pushReg(n);
            this.mg.add((byte)-123);
            this.mg.add((byte)18, (Object)FFFFFFFF);
            this.mg.add((byte)127);
            this.mg.add((byte)-127);
            this.mg.add((byte)-72, (Object)Type.DOUBLE_OBJECT.method("longBitsToDouble", Type.DOUBLE, new Type[]{Type.LONG}));
        } else if (this.singleFloat) {
            this.mg.add((byte)42);
            this.mg.add((byte)-76, (Object)this.me.field(regField[n], Type.FLOAT));
        } else {
            this.pushReg(n);
            this.mg.add((byte)-72, (Object)Type.Class.instance((String)"java.lang.Float").method("intBitsToFloat", Type.FLOAT, new Type[]{Type.INT}));
        }
        return n2;
    }

    private void preSetFloat(int n) {
        this.preSetDouble(n, false);
    }

    private void preSetDouble(int n) {
        this.preSetDouble(n, true);
    }

    private void preSetDouble(int n, boolean bl) {
        this.preSetReg(n);
    }

    private int setFloat() throws Compiler.Exn {
        return this.setDouble(false);
    }

    private int setDouble() throws Compiler.Exn {
        return this.setDouble(true);
    }

    private int setDouble(boolean bl) throws Compiler.Exn {
        int n = this.preSetRegStack[this.preSetRegStackPos - 1];
        if (n < 32 || n >= 64) {
            throw new IllegalArgumentException("" + n);
        }
        int n2 = this.mg.size();
        if (bl) {
            if (this.singleFloat) {
                throw new Compiler.Exn("Double operations not supported when singleFloat is enabled");
            }
            if (n == 63) {
                throw new Compiler.Exn("Tried to use a double in f31");
            }
            this.mg.add((byte)-72, (Object)Type.DOUBLE_OBJECT.method("doubleToLongBits", Type.LONG, new Type[]{Type.DOUBLE}));
            this.mg.add((byte)92);
            this.mg.add((byte)18, 32);
            this.mg.add((byte)125);
            this.mg.add((byte)-120);
            if (this.preSetReg(n + 1)) {
                this.mg.add((byte)95);
            }
            this.setReg();
            this.mg.add((byte)-120);
            this.setReg();
        } else if (this.singleFloat) {
            --this.preSetRegStackPos;
            this.mg.add((byte)-75, (Object)this.me.field(regField[n], Type.FLOAT));
        } else {
            this.mg.add((byte)-72, (Object)Type.FLOAT_OBJECT.method("floatToRawIntBits", Type.INT, new Type[]{Type.FLOAT}));
            this.setReg();
        }
        return n2;
    }

    private void pushTmp() {
        this.mg.add((byte)27);
    }

    private void setTmp() {
        this.mg.add((byte)60);
    }

    private void addiu(int n, int n2) {
        if (n != 0 && n2 != 0) {
            this.pushReg(n);
            this.mg.add((byte)18, n2);
            this.mg.add((byte)96);
        } else if (n != 0) {
            this.pushReg(n);
        } else {
            this.mg.add((byte)18, n2);
        }
    }

    private void preMemWrite1() {
        if (this.memWriteStage != 0) {
            throw new Error("pending preMemWrite1/2");
        }
        this.memWriteStage = 1;
        if (this.onePage) {
            this.mg.add((byte)44);
        } else if (this.fastMem) {
            this.mg.add((byte)25, 3);
        } else {
            this.mg.add((byte)42);
        }
    }

    private void preMemWrite2(int n, int n2) {
        this.addiu(n, n2);
        this.preMemWrite2();
    }

    private void preMemWrite2() {
        this.preMemWrite2(false);
    }

    private void preMemWrite2(boolean bl) {
        if (this.memWriteStage != 1) {
            throw new Error("pending preMemWrite2 or no preMemWrite1");
        }
        this.memWriteStage = 2;
        if (this.nullPointerCheck) {
            this.mg.add((byte)89);
            this.mg.add((byte)42);
            this.mg.add((byte)95);
            this.mg.add((byte)-74, (Object)this.me.method("nullPointerCheck", Type.VOID, new Type[]{Type.INT}));
        }
        if (this.onePage) {
            this.mg.add((byte)5);
            this.mg.add((byte)124);
        } else if (this.fastMem) {
            if (!bl) {
                this.mg.add((byte)90);
            }
            this.mg.add((byte)18, this.pageShift);
            this.mg.add((byte)124);
            this.mg.add((byte)50);
            if (bl) {
                this.pushTmp();
            } else {
                this.mg.add((byte)95);
            }
            this.mg.add((byte)5);
            this.mg.add((byte)124);
            this.mg.add((byte)18, (this.pageSize >> 2) - 1);
            this.mg.add((byte)126);
        }
    }

    private void memWrite() {
        if (this.memWriteStage != 2) {
            throw new Error("didn't do preMemWrite1 or preMemWrite2");
        }
        this.memWriteStage = 0;
        if (this.onePage) {
            this.mg.add((byte)79);
        } else if (this.fastMem) {
            this.mg.add((byte)79);
        } else {
            this.mg.add((byte)-74, (Object)this.me.method("unsafeMemWrite", Type.VOID, new Type[]{Type.INT, Type.INT}));
        }
    }

    private void memRead(int n, int n2) {
        this.preMemRead();
        this.addiu(n, n2);
        this.memRead();
    }

    private void preMemRead() {
        this.preMemRead(false);
    }

    private void preMemRead(boolean bl) {
        if (this.didPreMemRead) {
            throw new Error("pending preMemRead");
        }
        this.didPreMemRead = true;
        this.preMemReadDoPreWrite = bl;
        if (this.onePage) {
            this.mg.add((byte)44);
        } else if (this.fastMem) {
            this.mg.add((byte)25, bl ? 3 : 2);
        } else {
            this.mg.add((byte)42);
        }
    }

    private void memRead() {
        this.memRead(false);
    }

    private void memRead(boolean bl) {
        if (!this.didPreMemRead) {
            throw new Error("didn't do preMemRead");
        }
        this.didPreMemRead = false;
        if (this.preMemReadDoPreWrite) {
            this.memWriteStage = 2;
        }
        if (this.nullPointerCheck) {
            this.mg.add((byte)89);
            this.mg.add((byte)42);
            this.mg.add((byte)95);
            this.mg.add((byte)-74, (Object)this.me.method("nullPointerCheck", Type.VOID, new Type[]{Type.INT}));
        }
        if (this.onePage) {
            this.mg.add((byte)5);
            this.mg.add((byte)124);
            if (this.preMemReadDoPreWrite) {
                this.mg.add((byte)92);
            }
            this.mg.add((byte)46);
        } else if (this.fastMem) {
            if (!bl) {
                this.mg.add((byte)90);
            }
            this.mg.add((byte)18, this.pageShift);
            this.mg.add((byte)124);
            this.mg.add((byte)50);
            if (bl) {
                this.pushTmp();
            } else {
                this.mg.add((byte)95);
            }
            this.mg.add((byte)5);
            this.mg.add((byte)124);
            this.mg.add((byte)18, (this.pageSize >> 2) - 1);
            this.mg.add((byte)126);
            if (this.preMemReadDoPreWrite) {
                this.mg.add((byte)92);
            }
            this.mg.add((byte)46);
        } else {
            if (this.preMemReadDoPreWrite) {
                this.mg.add((byte)92);
            }
            this.mg.add((byte)-74, (Object)this.me.method("unsafeMemRead", Type.INT, new Type[]{Type.INT}));
        }
    }
}

