/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.XSLLeafNodeConstructor;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public final class XSLValueOf
extends XSLLeafNodeConstructor {
    private boolean disable = false;
    private Expression separator;

    public void prepareAttributes() throws XPathException {
        String selectAtt = null;
        String disableAtt = null;
        String separatorAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("disable-output-escaping")) {
                disableAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                this.select = this.makeExpression(selectAtt, a);
                continue;
            }
            if (f.equals("separator")) {
                separatorAtt = atts.getValue(a);
                this.separator = this.makeAttributeValueTemplate(separatorAtt, a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (disableAtt != null) {
            this.disable = this.processBooleanAttribute("disable-output-escaping", disableAtt);
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        super.validate(decl);
        this.select = this.typeCheck("select", this.select);
        this.separator = this.typeCheck("separator", this.separator);
    }

    protected String getErrorCodeForSelectPlusContent() {
        return "XTSE0870";
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        Configuration config = this.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        if (this.separator == null && this.select != null && this.xPath10ModeIsEnabled()) {
            this.select = config.getTypeChecker(true).processValueOf(this.select, config);
        } else if (this.separator == null) {
            this.separator = this.select == null ? new StringLiteral(StringValue.EMPTY_STRING) : new StringLiteral(StringValue.SINGLE_SPACE);
        }
        ValueOf inst = new ValueOf(this.select, this.disable, false);
        inst.setRetainedStaticContext(this.makeRetainedStaticContext());
        this.compileContent(exec, decl, inst, this.separator);
        return inst;
    }
}

