# Generated by default/object.tt
package Paws::DevOpsGuru::RecommendationRelatedEvent;
  use Moose;
  has Name => (is => 'ro', isa => 'Str');
  has Resources => (is => 'ro', isa => 'ArrayRef[Paws::DevOpsGuru::RecommendationRelatedEventResource]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DevOpsGuru::RecommendationRelatedEvent

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DevOpsGuru::RecommendationRelatedEvent object:

  $service_obj->Method(Att1 => { Name => $value, ..., Resources => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DevOpsGuru::RecommendationRelatedEvent object:

  $result = $service_obj->Method(...);
  $result->Att1->Name

=head1 DESCRIPTION

Information about an event that is related to a recommendation.

=head1 ATTRIBUTES


=head2 Name => Str

The name of the event. This corresponds to the C<Name> field in an
C<Event> object.


=head2 Resources => ArrayRef[L<Paws::DevOpsGuru::RecommendationRelatedEventResource>]

A C<ResourceCollection> object that contains arrays of the names of AWS
CloudFormation stacks. You can specify up to 500 AWS CloudFormation
stacks.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DevOpsGuru>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

