%define _config_bayonne2 --enable-voices

Name: bayonne2
Summary: "bayonne2" - telephony server of the GNU project
Version: 1.1.7
Release: 1
Epoch: 0
Copyright: LGPL
Group: Development/Libraries
URL: http://www.gnutelephony.org
Source0: ftp://ftp.gnu.org/gnu/bayonne/bayonne2-%{PACKAGE_VERSION}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: ccscript3-devel
BuildRequires: ccaudio2-devel
BuildRequires: ccrtp-devel
BuildRequires: libeXosip-devel
BuildRequires: pkgconfig
%ifos linux
%ifarch i386 i486 i586 i686 k6 k7
BuildRequires: vpb-devel
%endif
%endif

%package runtime
Requires: ccscript3 ccaudio2 ccrtp commoncpp2 libeXosip
Group: Development/Libraries
Summary: runtime library and drivers used in Bayonne2

%package server
Requires: %{name}-runtime = %{epoch}:%{version}-%{release} 
Group: Daemons/Telephony
Summary: Bayonne application services daemon

%package devel
Requires: %{name}-runtime = %{epoch}:%{version}-%{release}
Requires: ccscript3-devel ccaudio2-devel libstdc++-devel
Group: Development/Libraries
Summary: Headers and static link library for Bayonne2

%package en
Requires: %{name}-runtime = %{epoch}:%{version}-%{release}
Group: Multimedia/voice
Summary: Bayonne voice libraries for english language

%package fr
Requires: %{name}-runtime = %{epoch}:%{version}-%{release}
Group: Multimedia/voice
Summary: Bayonne voice libraries for french language 

%package ru
Requires: %{name}-runtime = %{epoch}:%{version}-%{release}
Group: Multimedia/voice
Summary: Bayonne voice libraries for russian language 
       
%description
GNU Bayonne2 is the telephony server of the GNU project.  It offers both
a script driven application server and a runtime environment that can be
used to build alternate telephony services.

%description runtime
GNU Bayonne2 runtime offers an environment that can be used to 
run either a bayonne2 server, or alternate servers that use libbayonne 
and the bayonne drivers.

%description devel
This package provides the header files, link libraries and documentation 
for building drivers and services on top of libbayonne.

%description server
This package configures and installs a bayonne2 server.  It depends on
the runtime package.

%description en
English language contributed voice libraries for Bayonne.

%description fr
French language contributed voice libraries for Bayonne.   

%description ru
Russian language contributed voice libraries for Bayonne.   

%prep
%setup
%build
%configure %{_config_bayonne2}
# first kill config installing, we will do it separately in the spec...
echo "#!/bin/sh" >config/instconfig
chmod +x config/instconfig

# now build...
make %{?_smp_mflags} LDFLAGS="-s" CXXFLAGS="$RPM_OPT_FLAGS"

%install
cd engine ; %makeinstall ; cd ..
cd modules ; %makeinstall ; cd ..
cd config 
	mkdir -p %{buildroot}/%{_sysconfdir}/bayonne
	mkdir -p %{buildroot}/%{_sysconfdir}/init.d
	cp *.conf %{buildroot}/%{_sysconfdir}/bayonne
	cp bayonne.init %{buildroot}/%{_sysconfdir}/init.d/bayonne
	%makeinstall
cd ..
cd scripts 
	mkdir -p %{buildroot}/%{_libdir}/cscc/lib
	mv bayonne.dll %{buildroot}/%{_libdir}/cscc/lib
	mv bayonne.jar %{buildroot}/%{_libdir}/bayonne*
	%makeinstall
	mkdir -p %{buildroot}/%{_datadir}/bayonne/libexec
	cp *.pm *.py *.php *.sh %{buildroot}/%{_datadir}/bayonne/libexec
cd ..
cd audio ; %makeinstall ; cd ..
cd server ; %makeinstall ; cd ..
cd binders ; %makeinstall ; cd ..

cd utils
	mkdir -p %{buildroot}/%{_bindir}
	install -c 'ttstool' %{buildroot}/%{_bindir}/ttstool
	install -s 'btsexec' %{buildroot}/%{_bindir}/btsexec
	(cd %{buildroot}/%{_bindir} ; ln -sf btsexec btsexec-perl)
	(cd %{buildroot}/%{_bindir} ; ln -sf btsexec btsexec-python)
	(cd %{buildroot}/%{_bindir} ; ln -sf btsexec btsexec-php)    
cd ..

%clean
rm -fr %{buildroot}

%files runtime
%defattr(-,root,root,-)
%doc AUTHORS COPYING FAQ NEWS README TODO ChangeLog
%dir %{_datadir}/phrasebook
%dir %{_datadir}/phrasebook/none
%dir %{_datadir}/phrasebook/none/prompts
%{_libdir}/bayonne*/*.ivr
%{_libdir}/bayonne*/*.mon
%{_libdir}/*.so.*
%{_libdir}/bayonne*/*.phrases
%{_datadir}/phrasebook/none/prompts/*
%dir %{_datadir}/bayonne/libexec
%{_datadir}/bayonne/libexec/*
%{_libdir}/bayonne*/libexec
%{_libdir}/bayonne*/*.jar
%{_libdir}/cscc/lib/*.dll
%{_bindir}/*

%files devel
%defattr(-,root,root,-)
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/*.la
%{_includedir}/cc++/*.h
%{_libdir}/pkgconfig/*.pc

%files en
%defattr(-,root,root-)
%dir %{_datadir}/phrasebook/en/*
%{_datadir}/phrasebook/en/*/*

%files fr        
%defattr(-,root,root-)       
%dir %{_datadir}/phrasebook/fr/*
%{_datadir}/phrasebook/fr/*/*   

%files ru        
%defattr(-,root,root-)       
%dir %{_datadir}/phrasebook/ru/*
%{_datadir}/phrasebook/ru/*/*   

%files server
%defattr(-,root,root,-)  
%dir %{_sysconfdir}/bayonne
%config %{_sysconfdir}/bayonne/*.conf
%dir %{_datadir}/bayonne/ivrscript*
%dir %{_datadir}/bayonne/scripts
%dir %{_datadir}/bayonne/macros
%{_sbindir}/*
%{_libdir}/bayonne*/*.bin
%{_mandir}/*/*
%{_sysconfdir}/init.d/bayonne
%{_datadir}/bayonne/ivrscript*/*
%{_datadir}/bayonne/scripts/*
%{_datadir}/bayonne/macros/*

%post devel
/sbin/ldconfig

%postun devel
/sbin/ldconfig

%post server
/sbin/chkconfig --add bayonne
/usr/sbin/adduser -d /var/lib/bayonne -c "Bayonne User" -r bayonne

%preun server
/sbin/chkconfig --del bayonne



