/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class RoutingTab
extends PreferencePanel {
    private boolean initRoutMimicOn;
    private boolean initRoutAutoOn;
    private ArcProto initRoutDefArc;
    private boolean initRoutMimicCanUnstitch;
    private boolean initRoutMimicInteractive;
    private boolean initRoutMimicMatchPorts;
    private boolean initRoutMimicMatchNumArcs;
    private boolean initRoutMimicMatchNodeSize;
    private boolean initRoutMimicMatchNodeType;
    private boolean initRoutMimicNoArcsSameDir;
    private JLabel jLabel67;
    private JLabel jLabel69;
    private JLabel jLabel70;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JRadioButton routAutoStitcher;
    private JComboBox routDefaultArc;
    private JCheckBox routMimicCanUnstitch;
    private JCheckBox routMimicInteractive;
    private JCheckBox routMimicNoOtherArcs;
    private JCheckBox routMimicNodeSizesMustMatch;
    private JCheckBox routMimicNodeTypesMustMatch;
    private JCheckBox routMimicNumArcsMustMatch;
    private JCheckBox routMimicPortsMustMatch;
    private JRadioButton routMimicStitcher;
    private JRadioButton routNoStitcher;
    private ButtonGroup routStitcher;
    private JPanel routing;

    public RoutingTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.routing;
    }

    public String getName() {
        return "Routing";
    }

    public void init() {
        this.initRoutMimicOn = Routing.isMimicStitchOn();
        this.initRoutAutoOn = Routing.isAutoStitchOn();
        if (!this.initRoutMimicOn && !this.initRoutAutoOn) {
            this.routNoStitcher.setSelected(true);
        } else if (this.initRoutMimicOn) {
            this.routMimicStitcher.setSelected(true);
        } else {
            this.routAutoStitcher.setSelected(true);
        }
        this.routDefaultArc.addItem("DEFAULT ARC");
        Iterator it = this.curTech.getArcs();
        while (it.hasNext()) {
            ArcProto ap = (ArcProto)it.next();
            this.routDefaultArc.addItem(ap.describe());
        }
        String prefArcName = Routing.getPreferredRoutingArc();
        this.initRoutDefArc = null;
        if (prefArcName.length() > 0) {
            this.initRoutDefArc = ArcProto.findArcProto(prefArcName);
        }
        if (this.initRoutDefArc != null) {
            this.routDefaultArc.setSelectedItem(this.initRoutDefArc.describe());
        }
        this.initRoutMimicCanUnstitch = Routing.isMimicStitchCanUnstitch();
        this.routMimicCanUnstitch.setSelected(this.initRoutMimicCanUnstitch);
        this.initRoutMimicMatchPorts = Routing.isMimicStitchMatchPorts();
        this.routMimicPortsMustMatch.setSelected(this.initRoutMimicMatchPorts);
        this.initRoutMimicMatchNumArcs = Routing.isMimicStitchMatchNumArcs();
        this.routMimicNumArcsMustMatch.setSelected(this.initRoutMimicMatchNumArcs);
        this.initRoutMimicMatchNodeSize = Routing.isMimicStitchMatchNodeSize();
        this.routMimicNodeSizesMustMatch.setSelected(this.initRoutMimicMatchNodeSize);
        this.initRoutMimicMatchNodeType = Routing.isMimicStitchMatchNodeType();
        this.routMimicNodeTypesMustMatch.setSelected(this.initRoutMimicMatchNodeType);
        this.initRoutMimicNoArcsSameDir = Routing.isMimicStitchNoOtherArcsSameDir();
        this.routMimicNoOtherArcs.setSelected(this.initRoutMimicNoArcsSameDir);
        this.initRoutMimicInteractive = Routing.isMimicStitchInteractive();
        this.routMimicInteractive.setSelected(this.initRoutMimicInteractive);
    }

    public void term() {
        boolean cur;
        boolean curAuto;
        boolean curMimic = this.routMimicStitcher.isSelected();
        if (curMimic != this.initRoutMimicOn) {
            Routing.setMimicStitchOn(curMimic);
        }
        if ((curAuto = this.routAutoStitcher.isSelected()) != this.initRoutAutoOn) {
            Routing.setAutoStitchOn(curAuto);
        }
        ArcProto ap = null;
        int curArcIndex = this.routDefaultArc.getSelectedIndex();
        if (curArcIndex > 0) {
            String curArcName = (String)this.routDefaultArc.getSelectedItem();
            ap = ArcProto.findArcProto(curArcName);
        }
        if (ap != this.initRoutDefArc) {
            String newArcName = "";
            if (ap != null) {
                newArcName = ap.getTechnology().getTechName() + ":" + ap.getName();
            }
            Routing.setPreferredRoutingArc(newArcName);
        }
        if ((cur = this.routMimicCanUnstitch.isSelected()) != this.initRoutMimicCanUnstitch) {
            Routing.setMimicStitchCanUnstitch(cur);
        }
        if ((cur = this.routMimicPortsMustMatch.isSelected()) != this.initRoutMimicMatchPorts) {
            Routing.setMimicStitchMatchPorts(cur);
        }
        if ((cur = this.routMimicNumArcsMustMatch.isSelected()) != this.initRoutMimicMatchNumArcs) {
            Routing.setMimicStitchMatchNumArcs(cur);
        }
        if ((cur = this.routMimicNodeSizesMustMatch.isSelected()) != this.initRoutMimicMatchNodeSize) {
            Routing.setMimicStitchMatchNodeSize(cur);
        }
        if ((cur = this.routMimicNodeTypesMustMatch.isSelected()) != this.initRoutMimicMatchNodeType) {
            Routing.setMimicStitchMatchNodeType(cur);
        }
        if ((cur = this.routMimicNoOtherArcs.isSelected()) != this.initRoutMimicNoArcsSameDir) {
            Routing.setMimicStitchNoOtherArcsSameDir(cur);
        }
        if ((cur = this.routMimicInteractive.isSelected()) != this.initRoutMimicInteractive) {
            Routing.setMimicStitchInteractive(cur);
        }
    }

    private void initComponents() {
        this.routStitcher = new ButtonGroup();
        this.routing = new JPanel();
        this.jPanel7 = new JPanel();
        this.jLabel70 = new JLabel();
        this.routMimicPortsMustMatch = new JCheckBox();
        this.routMimicInteractive = new JCheckBox();
        this.routMimicCanUnstitch = new JCheckBox();
        this.routMimicNumArcsMustMatch = new JCheckBox();
        this.routMimicNodeSizesMustMatch = new JCheckBox();
        this.routMimicNodeTypesMustMatch = new JCheckBox();
        this.routMimicNoOtherArcs = new JCheckBox();
        this.jPanel8 = new JPanel();
        this.jLabel67 = new JLabel();
        this.jLabel69 = new JLabel();
        this.routDefaultArc = new JComboBox();
        this.routNoStitcher = new JRadioButton();
        this.routAutoStitcher = new JRadioButton();
        this.routMimicStitcher = new JRadioButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                RoutingTab.this.closeDialog(evt);
            }
        });
        this.routing.setLayout(new GridBagLayout());
        this.jPanel7.setLayout(new GridBagLayout());
        this.jPanel7.setBorder(new TitledBorder("Mimic Stitcher"));
        this.jLabel70.setText("Restrictions (when non-interactive):");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel7.add((Component)this.jLabel70, gridBagConstraints);
        this.routMimicPortsMustMatch.setText("Ports must match");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        this.jPanel7.add((Component)this.routMimicPortsMustMatch, gridBagConstraints);
        this.routMimicInteractive.setText("Preview new arcs (interactive)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel7.add((Component)this.routMimicInteractive, gridBagConstraints);
        this.routMimicCanUnstitch.setText("Also mimics arc deletion (unstitching)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel7.add((Component)this.routMimicCanUnstitch, gridBagConstraints);
        this.routMimicNumArcsMustMatch.setText("Number of existing arcs must match");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        this.jPanel7.add((Component)this.routMimicNumArcsMustMatch, gridBagConstraints);
        this.routMimicNodeSizesMustMatch.setText("Node sizes must match");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        this.jPanel7.add((Component)this.routMimicNodeSizesMustMatch, gridBagConstraints);
        this.routMimicNodeTypesMustMatch.setText("Node types must match");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        this.jPanel7.add((Component)this.routMimicNodeTypesMustMatch, gridBagConstraints);
        this.routMimicNoOtherArcs.setText("Cannot have other arcs in the same direction");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        this.jPanel7.add((Component)this.routMimicNoOtherArcs, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.routing.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel8.setLayout(new GridBagLayout());
        this.jPanel8.setBorder(new TitledBorder("All Routers"));
        this.jLabel67.setText("Arc to use in stitching routers:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel8.add((Component)this.jLabel67, gridBagConstraints);
        this.jLabel69.setText("Currently:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel8.add((Component)this.jLabel69, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel8.add((Component)this.routDefaultArc, gridBagConstraints);
        this.routNoStitcher.setText("No stitcher running");
        this.routStitcher.add(this.routNoStitcher);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel8.add((Component)this.routNoStitcher, gridBagConstraints);
        this.routAutoStitcher.setText("Auto-stitcher running");
        this.routStitcher.add(this.routAutoStitcher);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel8.add((Component)this.routAutoStitcher, gridBagConstraints);
        this.routMimicStitcher.setText("Mimic-stitcher running");
        this.routStitcher.add(this.routMimicStitcher);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel8.add((Component)this.routMimicStitcher, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.routing.add((Component)this.jPanel8, gridBagConstraints);
        this.getContentPane().add((Component)this.routing, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

