/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SizeListener
implements MouseMotionListener,
MouseListener,
MouseWheelListener,
KeyListener {
    private Geometric stretchGeom;
    private EventListener oldListener;
    private Cursor oldCursor;
    private Point2D farthestPoint;
    private static Cursor sizeCursor = ToolBar.readCursor("CursorSize.gif", 14, 14);

    private SizeListener() {
    }

    public static void sizeObjects() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        List geomList = highlighter.getHighlightedEObjs(true, true);
        if (geomList == null) {
            return;
        }
        if (geomList.size() != 1) {
            System.out.println("Select just one object to size");
            return;
        }
        Geometric geom = (Geometric)geomList.get(0);
        if (geom instanceof Geometric) {
            EventListener newListener = null;
            EventListener oldListener = WindowFrame.getListener();
            Cursor oldCursor = TopLevel.getCurrentCursor();
            System.out.println("Click to stretch " + geom.describe());
            newListener = oldListener;
            if (newListener == null || !(newListener instanceof SizeListener)) {
                newListener = new SizeListener();
                WindowFrame.setListener(newListener);
            }
            ((SizeListener)newListener).stretchGeom = geom;
            ((SizeListener)newListener).oldListener = oldListener;
            ((SizeListener)newListener).oldCursor = oldCursor;
            TopLevel.setCurrentCursor(sizeCursor);
        }
    }

    public static void sizeAllNodes() {
        SizeObjects dialog = new SizeObjects((Frame)TopLevel.getCurrentJFrame(), true, true);
        dialog.setVisible(true);
    }

    public static void sizeAllArcs() {
        SizeObjects dialog = new SizeObjects((Frame)TopLevel.getCurrentJFrame(), true, false);
        dialog.setVisible(true);
    }

    public void mousePressed(MouseEvent evt) {
        this.farthestPoint = null;
        this.showHighlight(evt, (EditWindow)evt.getSource());
    }

    public void mouseMoved(MouseEvent evt) {
        this.farthestPoint = null;
        this.showHighlight(evt, (EditWindow)evt.getSource());
        this.farthestPoint = null;
    }

    public void mouseDragged(MouseEvent evt) {
        this.showHighlight(evt, (EditWindow)evt.getSource());
    }

    public void mouseReleased(MouseEvent evt) {
        WindowFrame.setListener(this.oldListener);
        TopLevel.setCurrentCursor(this.oldCursor);
        EditWindow wnd = (EditWindow)evt.getSource();
        this.showHighlight(null, wnd);
        if (this.stretchGeom instanceof NodeInst) {
            NodeInst ni = (NodeInst)this.stretchGeom;
            Point2D.Double newCenter = new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY());
            Point2D newSize = this.getNewNodeSize(evt, newCenter);
            ScaleNode job = new ScaleNode(ni, newCenter, newSize.getX(), newSize.getY());
        } else {
            ArcInst ai = (ArcInst)this.stretchGeom;
            double newWidth = this.getNewArcSize(evt);
            ScaleArc job = new ScaleArc(ai, newWidth);
        }
        wnd.repaint();
    }

    public void keyPressed(KeyEvent evt) {
        int chr = evt.getKeyCode();
        EditWindow wnd = (EditWindow)evt.getSource();
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        if (chr == 27) {
            WindowFrame.setListener(this.oldListener);
            TopLevel.setCurrentCursor(this.oldCursor);
            this.showHighlight(null, wnd);
            System.out.println("Aborted");
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseWheelMoved(MouseWheelEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
    }

    private void showHighlight(MouseEvent evt, EditWindow wnd) {
        Highlighter highlighter = wnd.getHighlighter();
        highlighter.clear();
        highlighter.addElectricObject(this.stretchGeom, this.stretchGeom.getParent());
        highlighter.finished();
        if (evt != null) {
            if (this.stretchGeom instanceof NodeInst) {
                NodeInst ni = (NodeInst)this.stretchGeom;
                Point2D.Double newCenter = new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY());
                Point2D newSize = this.getNewNodeSize(evt, newCenter);
                SizeOffset so = ni.getSizeOffset();
                AffineTransform trans = NodeInst.rotateAbout(ni.getAngle(), ((Point2D)newCenter).getX(), ((Point2D)newCenter).getY(), newSize.getX(), newSize.getY());
                double stretchedLowX = ((Point2D)newCenter).getX() - newSize.getX() / 2.0 + so.getLowXOffset();
                double stretchedHighX = ((Point2D)newCenter).getX() + newSize.getX() / 2.0 - so.getHighXOffset();
                double stretchedLowY = ((Point2D)newCenter).getY() - newSize.getY() / 2.0 + so.getLowYOffset();
                double stretchedHighY = ((Point2D)newCenter).getY() + newSize.getY() / 2.0 - so.getHighYOffset();
                Poly stretchedPoly = new Poly((stretchedLowX + stretchedHighX) / 2.0, (stretchedLowY + stretchedHighY) / 2.0, stretchedHighX - stretchedLowX, stretchedHighY - stretchedLowY);
                stretchedPoly.transform(trans);
                Point2D[] stretchedPoints = stretchedPoly.getPoints();
                for (int i = 0; i < stretchedPoints.length; ++i) {
                    int lastI = i - 1;
                    if (lastI < 0) {
                        lastI = stretchedPoints.length - 1;
                    }
                    highlighter.addLine(stretchedPoints[lastI], stretchedPoints[i], ni.getParent());
                }
            } else {
                double newWidth = this.getNewArcSize(evt);
                ArcInst ai = (ArcInst)this.stretchGeom;
                Poly stretchedPoly = ai.makePoly(ai.getLength(), newWidth - ai.getProto().getWidthOffset(), Poly.Type.CLOSED);
                if (stretchedPoly == null) {
                    return;
                }
                Point2D[] stretchedPoints = stretchedPoly.getPoints();
                for (int i = 0; i < stretchedPoints.length; ++i) {
                    int lastI = i - 1;
                    if (lastI < 0) {
                        lastI = stretchedPoints.length - 1;
                    }
                    highlighter.addLine(stretchedPoints[lastI], stretchedPoints[i], ai.getParent());
                }
            }
            wnd.repaint();
        }
    }

    private Point2D getNewNodeSize(MouseEvent evt, Point2D newCenter) {
        double growthRatioY;
        double growthRatioX;
        EditWindow wnd = (EditWindow)evt.getSource();
        int oldx = evt.getX();
        int oldy = evt.getY();
        Point2D pt = wnd.screenToDatabase(oldx, oldy);
        NodeInst ni = (NodeInst)this.stretchGeom;
        NodeProto np = ni.getProto();
        SizeOffset so = ni.getSizeOffset();
        double nodeLowX = ni.getTrueCenterX() - ni.getXSize() / 2.0 + so.getLowXOffset();
        double nodeHighX = ni.getTrueCenterX() + ni.getXSize() / 2.0 - so.getHighXOffset();
        double nodeLowY = ni.getTrueCenterY() - ni.getYSize() / 2.0 + so.getLowYOffset();
        double nodeHighY = ni.getTrueCenterY() + ni.getYSize() / 2.0 - so.getHighYOffset();
        Poly nodePoly = new Poly((nodeLowX + nodeHighX) / 2.0, (nodeLowY + nodeHighY) / 2.0, nodeHighX - nodeLowX, nodeHighY - nodeLowY);
        AffineTransform trans = ni.rotateOutAboutTrueCenter();
        nodePoly.transform(trans);
        Point2D[] points = nodePoly.getPoints();
        Point2D closest = null;
        Point2D farthest = null;
        if (this.farthestPoint != null) {
            for (int i = 0; i < points.length; ++i) {
                if (!points[i].equals(this.farthestPoint)) continue;
                closest = points[(i + points.length / 2) % points.length];
                farthest = this.farthestPoint;
                break;
            }
        }
        if (farthest == null || closest == null) {
            double closestDist = Double.MAX_VALUE;
            for (int i = 0; i < points.length; ++i) {
                double dist = pt.distance(points[i]);
                if (!(dist < closestDist)) continue;
                closestDist = dist;
                closest = points[i];
                farthest = points[(i + points.length / 2) % points.length];
            }
        }
        this.farthestPoint = farthest;
        boolean centerBased = (evt.getModifiersEx() & 0x40) != 0;
        AffineTransform transIn = ni.rotateIn();
        double closestX = closest.getX();
        double closestY = closest.getY();
        double farthestX = this.farthestPoint.getX();
        double farthestY = this.farthestPoint.getY();
        transIn.transform(pt, pt);
        transIn.transform(closest, closest);
        transIn.transform(farthest, farthest);
        if (centerBased) {
            double ptToCenterX = Math.abs(pt.getX() - ni.getTrueCenterX());
            double closestToCenterX = Math.abs(closest.getX() - ni.getTrueCenterX());
            double ptToCenterY = Math.abs(pt.getY() - ni.getTrueCenterY());
            double closestToCenterY = Math.abs(closest.getY() - ni.getTrueCenterY());
            growthRatioX = ptToCenterX / closestToCenterX;
            growthRatioY = ptToCenterY / closestToCenterY;
        } else {
            double ptToFarthestX = Math.abs(pt.getX() - farthest.getX());
            double closestToFarthestX = Math.abs(closest.getX() - farthest.getX());
            double ptToFarthestY = Math.abs(pt.getY() - farthest.getY());
            double closestToFarthestY = Math.abs(closest.getY() - farthest.getY());
            growthRatioX = ptToFarthestX / closestToFarthestX;
            growthRatioY = ptToFarthestY / closestToFarthestY;
        }
        if ((evt.getModifiersEx() & 0x80) != 0) {
            double gry;
            double grx = Math.abs(growthRatioX);
            if (grx < 1.0) {
                grx = grx == 0.0 ? 9999.0 : 1.0 / grx;
            }
            if ((gry = Math.abs(growthRatioY)) < 1.0) {
                gry = gry == 0.0 ? 9999.0 : 1.0 / gry;
            }
            if (grx > gry) {
                growthRatioY = 1.0;
            } else {
                growthRatioX = 1.0;
            }
        }
        if (ni.getProto() instanceof PrimitiveNode && ((PrimitiveNode)ni.getProto()).isSquare()) {
            if (growthRatioX > growthRatioY) {
                growthRatioY = growthRatioX;
            } else {
                growthRatioX = growthRatioY;
            }
        }
        double newXSize = (ni.getXSize() - so.getLowXOffset() - so.getHighXOffset()) * growthRatioX;
        double newYSize = (ni.getYSize() - so.getLowYOffset() - so.getHighYOffset()) * growthRatioY;
        Point2D.Double newSize = new Point2D.Double(newXSize, newYSize);
        if (centerBased) {
            EditWindow.gridAlign(newSize);
        } else {
            double alignment = User.getAlignmentToGrid();
            EditWindow.gridAlign(newSize, alignment);
        }
        if (!centerBased) {
            AffineTransform pureTrans = ni.pureRotateOut();
            Point2D.Double xformedSize = new Point2D.Double();
            pureTrans.transform(newSize, xformedSize);
            closestX = closestX > farthestX ? farthestX + Math.abs(((Point2D)xformedSize).getX()) : farthestX - Math.abs(((Point2D)xformedSize).getX());
            closestY = closestY > farthestY ? farthestY + Math.abs(((Point2D)xformedSize).getY()) : farthestY - Math.abs(((Point2D)xformedSize).getY());
            newCenter.setLocation((closestX + farthestX) / 2.0, (closestY + farthestY) / 2.0);
        }
        ((Point2D)newSize).setLocation(((Point2D)newSize).getX() + so.getLowXOffset() + so.getHighXOffset(), ((Point2D)newSize).getY() + so.getLowYOffset() + so.getHighYOffset());
        return newSize;
    }

    private double getNewArcSize(MouseEvent evt) {
        EditWindow wnd = (EditWindow)evt.getSource();
        int oldx = evt.getX();
        int oldy = evt.getY();
        Point2D pt = wnd.screenToDatabase(oldx, oldy);
        ArcInst ai = (ArcInst)this.stretchGeom;
        ArcProto ap = ai.getProto();
        double offset = ap.getWidthOffset();
        Point2D ptOnLine = DBMath.closestPointToLine(ai.getHead().getLocation(), ai.getTail().getLocation(), pt);
        double newWidth = ptOnLine.distance(pt) * 2.0 + offset;
        Point2D.Double newSize = new Point2D.Double(newWidth, newWidth);
        EditWindow.gridAlign(newSize);
        return ((Point2D)newSize).getX();
    }

    private static class ScaleArc
    extends Job {
        private ArcInst stretchArc;
        private double newWidth;

        protected ScaleArc(ArcInst stretchArc, double newWidth) {
            super("Scale arc", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.stretchArc = stretchArc;
            this.newWidth = newWidth;
            this.startJob();
        }

        public boolean doIt() {
            if (CircuitChanges.cantEdit(this.stretchArc.getParent(), null, true) != 0) {
                return false;
            }
            this.stretchArc.modify(this.newWidth - this.stretchArc.getWidth(), 0.0, 0.0, 0.0, 0.0);
            return true;
        }
    }

    private static class ScaleNode
    extends Job {
        private NodeInst stretchNode;
        private Point2D newCenter;
        private double newWidth;
        private double newHeight;

        protected ScaleNode(NodeInst stretchNode, Point2D newCenter, double newWidth, double newHeight) {
            super("Scale node", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.stretchNode = stretchNode;
            this.newCenter = newCenter;
            this.newWidth = newWidth;
            this.newHeight = newHeight;
            this.startJob();
        }

        public boolean doIt() {
            if (CircuitChanges.cantEdit(this.stretchNode.getParent(), null, true) != 0) {
                return false;
            }
            double dWid = this.stretchNode.getXSizeWithMirror();
            dWid = dWid < 0.0 ? -this.newWidth - dWid : this.newWidth - dWid;
            double dHei = this.stretchNode.getYSizeWithMirror();
            dHei = dHei < 0.0 ? -this.newHeight - dHei : this.newHeight - dHei;
            this.stretchNode.modifyInstance(this.newCenter.getX() - this.stretchNode.getAnchorCenterX(), this.newCenter.getY() - this.stretchNode.getAnchorCenterY(), dWid, dHei, 0);
            return true;
        }
    }

    private static class ResizeStuff
    extends Job {
        SizeObjects dialog;

        protected ResizeStuff(SizeObjects dialog) {
            super("Resize Objects", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.dialog = dialog;
            this.startJob();
        }

        public boolean doIt() {
            Cell cell = WindowFrame.needCurCell();
            if (cell == null) {
                return false;
            }
            if (CircuitChanges.cantEdit(cell, null, true) != 0) {
                return false;
            }
            EditWindow wnd = EditWindow.needCurrent();
            if (wnd == null) {
                return false;
            }
            Highlighter highlighter = wnd.getHighlighter();
            double xS = TextUtils.atof(this.dialog.xSize.getText());
            double yS = 0.0;
            if (this.dialog.nodes) {
                yS = TextUtils.atof(this.dialog.ySize.getText());
            }
            boolean didSomething = false;
            Iterator it = highlighter.getHighlightedEObjs(true, true).iterator();
            while (it.hasNext()) {
                Geometric geom = (Geometric)it.next();
                if (geom instanceof NodeInst && this.dialog.nodes) {
                    NodeInst ni = (NodeInst)geom;
                    SizeOffset so = ni.getSizeOffset();
                    double x = xS + so.getLowXOffset() + so.getHighXOffset();
                    double y = yS + so.getLowYOffset() + so.getHighYOffset();
                    if (ni.getProto() instanceof PrimitiveNode && ((PrimitiveNode)ni.getProto()).isSquare()) {
                        if (y > x) {
                            x = y;
                        } else {
                            y = x;
                        }
                    }
                    ni.modifyInstance(0.0, 0.0, x - ni.getXSize(), y - ni.getYSize(), 0);
                    didSomething = true;
                    continue;
                }
                if (!(geom instanceof ArcInst) || this.dialog.nodes) continue;
                ArcInst ai = (ArcInst)geom;
                double w = xS + ai.getProto().getWidthOffset();
                ai.modify(w - ai.getWidth(), 0.0, 0.0, 0.0, 0.0);
                didSomething = true;
            }
            if (!didSomething) {
                System.out.println("Could not find any " + (this.dialog.nodes ? "nodes" : "arcs") + " to resize");
            }
            return true;
        }
    }

    private static class SizeObjects
    extends EDialog {
        private JTextField xSize;
        private JTextField ySize;
        boolean nodes;

        public SizeObjects(Frame parent, boolean modal, boolean nodes) {
            super(parent, modal);
            GridBagConstraints gbc;
            EditWindow wnd = EditWindow.needCurrent();
            if (wnd == null) {
                return;
            }
            Highlighter highlighter = wnd.getHighlighter();
            this.getContentPane().setLayout(new GridBagLayout());
            String label = "Width:";
            this.nodes = nodes;
            if (nodes) {
                label = "X Size:";
                this.setTitle("Set Node Size");
                JLabel ySizeLabel = new JLabel("Y Size:");
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.insets = new Insets(4, 4, 4, 4);
                this.getContentPane().add((Component)ySizeLabel, gbc);
                this.ySize = new JTextField();
                this.ySize.setColumns(6);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 1;
                gbc.weightx = 1.0;
                gbc.fill = 2;
                gbc.insets = new Insets(4, 4, 4, 4);
                this.getContentPane().add((Component)this.ySize, gbc);
            } else {
                this.setTitle("Set Arc Size");
            }
            JLabel xSizeLabel = new JLabel(label);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)xSizeLabel, gbc);
            this.xSize = new JTextField();
            this.xSize.setColumns(6);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.xSize, gbc);
            JButton ok = new JButton("OK");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            JButton cancel = new JButton("Cancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ SizeObjects this$0;
                {
                    this.this$0 = this$0;
                }

                public void windowClosing(WindowEvent evt) {
                    SizeObjects.access$000(this.this$0, evt);
                }
            });
            cancel.addActionListener(new ActionListener(this){
                private final /* synthetic */ SizeObjects this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent evt) {
                    SizeObjects.access$100(this.this$0, evt);
                }
            });
            ok.addActionListener(new ActionListener(this){
                private final /* synthetic */ SizeObjects this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent evt) {
                    SizeObjects.access$200(this.this$0, evt);
                }
            });
            this.pack();
            this.getRootPane().setDefaultButton(ok);
            double xS = 0.0;
            double yS = 0.0;
            Iterator it = highlighter.getHighlightedEObjs(true, true).iterator();
            while (it.hasNext()) {
                Geometric geom = (Geometric)it.next();
                if (geom instanceof NodeInst && nodes) {
                    NodeInst ni = (NodeInst)geom;
                    SizeOffset so = ni.getSizeOffset();
                    xS = ni.getXSize() - so.getLowXOffset() - so.getHighXOffset();
                    yS = ni.getYSize() - so.getLowYOffset() - so.getHighYOffset();
                    continue;
                }
                if (!(geom instanceof ArcInst) || nodes) continue;
                ArcInst ai = (ArcInst)geom;
                xS = ai.getWidth() - ai.getProto().getWidthOffset();
            }
            this.xSize.setText(TextUtils.formatDouble(xS));
            if (nodes) {
                this.ySize.setText(TextUtils.formatDouble(yS));
            }
        }

        private void cancel(ActionEvent evt) {
            this.SizeObjectsClosing(null);
        }

        private void ok(ActionEvent evt) {
            ResizeStuff job = new ResizeStuff(this);
            this.SizeObjectsClosing(null);
        }

        private void SizeObjectsClosing(WindowEvent evt) {
            this.setVisible(false);
            this.dispose();
        }

        static /* synthetic */ void access$000(SizeObjects x0, WindowEvent x1) {
            x0.SizeObjectsClosing(x1);
        }

        static /* synthetic */ void access$100(SizeObjects x0, ActionEvent x1) {
            x0.cancel(x1);
        }

        static /* synthetic */ void access$200(SizeObjects x0, ActionEvent x1) {
            x0.ok(x1);
        }
    }
}

