/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import [Ljava.lang.Integer;;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.DRCRules;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.drc.Quick;
import com.sun.electric.tool.drc.Schematic;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class DRC
extends Listener {
    protected static DRC tool = new DRC();
    private static HashMap prefDRCOverride = new HashMap();
    private static HashMap cellsToCheck = new HashMap();
    private static boolean incrementalRunning = false;
    private static final Variable.Key DRC_LAST_GOOD_DATE = Variable.newKey("DRC_last_good_drc_date");
    private static final Variable.Key DRC_LAST_GOOD_BIT = Variable.newKey("DRC_last_good_drc_bit");
    public static final int DRC_BIT_AREA = 1;
    public static final int DRC_BIT_COVERAGE = 2;
    public static final int DRC_BIT_ST_FOUNDRY = 3;
    public static final int DRC_BIT_TSMC_FOUNDRY = 4;
    public static final int ERROR_CHECK_DEFAULT = 0;
    public static final int ERROR_CHECK_CELL = 1;
    public static final int ERROR_CHECK_EXHAUSTIVE = 2;
    private static Technology currentTechnology = null;
    private static Pref cacheIncrementalDRCOn = Pref.makeBooleanPref("IncrementalDRCOn", DRC.tool.prefs, true);
    private static Pref cacheErrorCheckLevel = Pref.makeIntPref("ErrorCheckLevel", DRC.tool.prefs, 0);
    private static Pref cacheUseMultipleThreads = Pref.makeBooleanPref("UseMultipleThreads", DRC.tool.prefs, false);
    private static Pref cacheNumberOfThreads = Pref.makeIntPref("NumberOfThreads", DRC.tool.prefs, 2);
    private static Pref cacheIgnoreCenterCuts = Pref.makeBooleanPref("IgnoreCenterCuts", DRC.tool.prefs, false);
    private static Pref cacheIgnoreAreaChecking = Pref.makeBooleanPref("IgnoreAreaCheck", DRC.tool.prefs, false);
    private static Pref cacheIgnoreExtensionRuleChecking = Pref.makeBooleanPref("IgnoreExtensionRuleCheck", DRC.tool.prefs, false);

    private DRC() {
        super("drc");
    }

    public void init() {
        this.setOn();
    }

    public static DRC getDRCTool() {
        return tool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void includeGeometric(Geometric geom) {
        if (!DRC.isIncrementalDRCOn()) {
            return;
        }
        Cell cell = geom.getParent();
        HashMap hashMap = cellsToCheck;
        synchronized (hashMap) {
            HashSet<Geometric> cellSet = (HashSet<Geometric>)cellsToCheck.get(cell);
            if (cellSet == null) {
                cellSet = new HashSet<Geometric>();
                cellsToCheck.put(cell, cellSet);
            }
            cellSet.add(geom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeGeometric(Geometric geom) {
        if (!DRC.isIncrementalDRCOn()) {
            return;
        }
        Cell cell = geom.getParent();
        HashMap hashMap = cellsToCheck;
        synchronized (hashMap) {
            HashSet cellSet = (HashSet)cellsToCheck.get(cell);
            if (cellSet != null) {
                cellSet.remove(geom);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doIncrementalDRCTask() {
        if (!DRC.isIncrementalDRCOn()) {
            return;
        }
        if (incrementalRunning) {
            return;
        }
        Library curLib = Library.getCurrent();
        if (curLib == null) {
            return;
        }
        Cell cellToCheck = curLib.getCurCell();
        HashSet cellSet = null;
        HashMap hashMap = cellsToCheck;
        synchronized (hashMap) {
            if (cellToCheck != null) {
                cellSet = (HashSet)cellsToCheck.get(cellToCheck);
            }
            if (cellSet == null && cellsToCheck.size() > 0) {
                cellToCheck = (Cell)cellsToCheck.keySet().iterator().next();
                cellSet = (HashSet)cellsToCheck.get(cellToCheck);
            }
            if (cellSet != null) {
                cellsToCheck.remove(cellToCheck);
            }
        }
        if (cellToCheck == null) {
            return;
        }
        if (!cellToCheck.isLinked()) {
            return;
        }
        if (cellToCheck.getLibrary().isHidden()) {
            return;
        }
        if (cellSet != null) {
            Geometric[] objectsToCheck = new Geometric[cellSet.size()];
            int i = 0;
            Iterator it = cellSet.iterator();
            while (it.hasNext()) {
                objectsToCheck[i++] = (Geometric)it.next();
            }
            new CheckLayoutIncrementally(cellToCheck, objectsToCheck);
        }
    }

    public void endBatch() {
        DRC.doIncrementalDRCTask();
    }

    public void modifyNodeInst(NodeInst ni, ImmutableNodeInst oD) {
        DRC.includeGeometric(ni);
    }

    public void modifyArcInst(ArcInst ai, double oHX, double oHY, double oTX, double oTY, double oWid) {
        DRC.includeGeometric(ai);
    }

    public void newObject(ElectricObject obj) {
        if (obj instanceof Geometric) {
            DRC.includeGeometric((Geometric)obj);
        }
    }

    public void killObject(ElectricObject obj) {
        if (obj instanceof Geometric) {
            DRC.removeGeometric((Geometric)obj);
        }
    }

    public static void checkHierarchically(boolean areaCheck, int mode) {
        Cell curCell = null;
        Rectangle2D bounds = null;
        if (!areaCheck) {
            curCell = WindowFrame.needCurCell();
        } else {
            EditWindow wnd = EditWindow.getCurrent();
            if (wnd == null) {
                return;
            }
            Highlighter h = wnd.getHighlighter();
            bounds = h.getHighlightedArea(wnd);
            curCell = wnd.getCell();
        }
        if (curCell == null) {
            return;
        }
        if (curCell.isSchematic() || curCell.getTechnology() == Schematics.tech || curCell.isIcon() || curCell.getTechnology() == Artwork.tech) {
            new CheckSchematicHierarchically(curCell);
        } else {
            new CheckLayoutHierarchically(curCell, bounds, mode);
        }
    }

    public static void resetDRCDates() {
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                DRC.cleanDRCDateAndBits(cell);
            }
        }
    }

    public static DRCRules getRules(Technology tech) {
        DRCRules currentRules = tech.getCachedRules();
        if (currentRules != null && tech == currentTechnology) {
            return currentRules;
        }
        currentRules = tech.getFactoryDesignRules();
        if (currentRules != null) {
            StringBuffer override = DRC.getDRCOverrides(tech);
            currentRules.applyDRCOverrides(override.toString(), tech);
        }
        currentTechnology = tech;
        tech.setCachedRules(currentRules);
        return currentRules;
    }

    public static void setRules(Technology tech, DRCRules newRules) {
        DRCRules factoryRules = tech.getFactoryDesignRules();
        StringBuffer changes = Technology.getRuleDifferences(factoryRules, newRules);
        StringBuffer override = DRC.getDRCOverrides(tech);
        if (changes.toString().equals(override.toString())) {
            return;
        }
        DRC.setDRCOverrides(changes, tech);
        tech.setRuleVariables(newRules);
        if (currentTechnology == tech) {
            currentTechnology = null;
        }
    }

    public static double getWorstSpacingDistance(Technology tech) {
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return 0.0;
        }
        return rules.getWorstSpacingDistance();
    }

    public static double getMaxSurround(Layer layer, double maxSize) {
        Technology tech = layer.getTechnology();
        if (tech == null) {
            return -1.0;
        }
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return -1.0;
        }
        return rules.getMaxSurround(tech, layer, maxSize);
    }

    public static DRCTemplate getEdgeRule(Layer layer1, Layer layer2, int techMode) {
        Technology tech = layer1.getTechnology();
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return null;
        }
        return rules.getEdgeRule(tech, layer1, layer2, techMode);
    }

    public static DRCTemplate getSpacingRule(Layer layer1, Geometric geo1, Layer layer2, Geometric geo2, boolean connected, int multiCut, double wideS, double length, int techMode) {
        Technology tech = layer1.getTechnology();
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return null;
        }
        return rules.getSpacingRule(tech, layer1, geo1, layer2, geo2, connected, multiCut, wideS, length, techMode);
    }

    public static DRCTemplate getExtensionRule(Layer layer1, Layer layer2, int techMode, boolean isGateExtension) {
        Technology tech = layer1.getTechnology();
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return null;
        }
        return rules.getExtensionRule(tech, layer1, layer2, techMode, isGateExtension);
    }

    public static boolean isAnyRule(Layer layer1, Layer layer2) {
        Technology tech = layer1.getTechnology();
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return false;
        }
        return rules.isAnyRule(tech, layer1, layer2);
    }

    public static DRCTemplate getMinValue(Layer layer, int type, int techmode) {
        Technology tech = layer.getTechnology();
        if (tech == null) {
            return null;
        }
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return null;
        }
        return rules.getMinValue(layer, type, techmode);
    }

    public static boolean isForbiddenNode(int elemIndex, int type, Technology tech, int techmode) {
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return false;
        }
        int index = elemIndex;
        if (type == 24) {
            index += tech.getNumLayers();
        }
        return rules.isForbiddenNode(index, type, techmode);
    }

    public static NodeSizeRule getMinSize(NodeProto np) {
        if (np instanceof Cell) {
            return null;
        }
        PrimitiveNode pnp = (PrimitiveNode)np;
        if (pnp.getMinWidth() < 0.0 && pnp.getMinHeight() < 0.0) {
            return null;
        }
        return new NodeSizeRule(pnp.getMinWidth(), pnp.getMinHeight(), pnp.getMinSizeRule());
    }

    private static StringBuffer getDRCOverrides(Technology tech) {
        Pref pref = (Pref)prefDRCOverride.get(tech);
        if (pref == null) {
            pref = Pref.makeStringPref("DRCOverridesFor" + tech.getTechName(), DRC.tool.prefs, "");
            prefDRCOverride.put(tech, pref);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(pref.getString());
        return sb;
    }

    private static void setDRCOverrides(StringBuffer sb, Technology tech) {
        Pref pref;
        if (sb.length() >= 8192) {
            System.out.println("Warning: Design rule overrides are too complex to be saved (are " + sb.length() + " long which is more than the limit of " + 8192 + ")");
        }
        if ((pref = (Pref)prefDRCOverride.get(tech)) == null) {
            pref = Pref.makeStringPref("DRCOverridesFor" + tech.getTechName(), DRC.tool.prefs, "");
            prefDRCOverride.put(tech, pref);
        }
        pref.setString(sb.toString());
    }

    public static Date getLastDRCDateBasedOnBits(Cell cell, int activeBits) {
        boolean sameManufacturer;
        Variable varDate = cell.getVar(DRC_LAST_GOOD_DATE, Integer;.class);
        if (varDate == null) {
            return null;
        }
        Variable varBits = cell.getVar(DRC_LAST_GOOD_BIT, Integer.class);
        int thisByte = 0;
        if (varBits == null) {
            varBits = cell.getVar(DRC_LAST_GOOD_BIT, Byte.class);
            thisByte = ((Byte)varBits.getObject()).byteValue();
        } else {
            thisByte = (Integer)varBits.getObject();
        }
        boolean area = (thisByte & 1) == (activeBits & 1);
        boolean coverage = (thisByte & 2) == (activeBits & 2);
        boolean bl = sameManufacturer = (thisByte & 4) == (activeBits & 4) && (thisByte & 3) == (activeBits & 3);
        if (!(activeBits == 0 || area && coverage && sameManufacturer)) {
            return null;
        }
        Integer[] lastDRCDateAsInts = (Integer[])varDate.getObject();
        long lastDRCDateInSecondsHigh = lastDRCDateAsInts[0].intValue();
        long lastDRCDateInSecondsLow = lastDRCDateAsInts[1].intValue();
        long lastDRCDateInSeconds = lastDRCDateInSecondsHigh << 32 | lastDRCDateInSecondsLow & 0xFFFFFFFFL;
        Date lastDRCDate = new Date(lastDRCDateInSeconds);
        return lastDRCDate;
    }

    public static void setLastDRCDateAndBits(Cell cell, Date date, int bits) {
        long iVal = date.getTime();
        Integer[] dateArray = new Integer[]{new Integer((int)(iVal >> 32)), new Integer((int)(iVal & 0xFFFFFFFFFFFFFFFFL))};
        cell.newVar(DRC_LAST_GOOD_DATE, (Object)dateArray);
        Integer b = new Integer(bits);
        cell.newVar(DRC_LAST_GOOD_BIT, (Object)b);
    }

    public static void cleanDRCDateAndBits(Cell cell) {
        cell.delVar(DRC_LAST_GOOD_DATE);
        cell.delVar(DRC_LAST_GOOD_BIT);
    }

    public static int getActiveBits(Technology tech) {
        int foundry;
        int bits = 0;
        if (!DRC.isIgnoreAreaChecking()) {
            bits |= 1;
        }
        if (!DRC.isIgnoreExtensionRuleChecking()) {
            bits |= 2;
        }
        if ((foundry = tech.getFoundry()) != 0) {
            bits |= foundry == 8192 ? 3 : 4;
        }
        return bits;
    }

    public static boolean isIncrementalDRCOn() {
        return cacheIncrementalDRCOn.getBoolean();
    }

    public static void setIncrementalDRCOn(boolean on) {
        cacheIncrementalDRCOn.setBoolean(on);
    }

    public static int getErrorType() {
        return cacheErrorCheckLevel.getInt();
    }

    public static void setErrorType(int type) {
        cacheErrorCheckLevel.setInt(type);
    }

    public static boolean isUseMultipleThreads() {
        return cacheUseMultipleThreads.getBoolean();
    }

    public static void setUseMultipleThreads(boolean on) {
        cacheUseMultipleThreads.setBoolean(on);
    }

    public static int getNumberOfThreads() {
        return cacheNumberOfThreads.getInt();
    }

    public static void setNumberOfThreads(int th) {
        cacheNumberOfThreads.setInt(th);
    }

    public static boolean isIgnoreCenterCuts() {
        return cacheIgnoreCenterCuts.getBoolean();
    }

    public static void setIgnoreCenterCuts(boolean on) {
        cacheIgnoreCenterCuts.setBoolean(on);
    }

    public static boolean isIgnoreAreaChecking() {
        return cacheIgnoreAreaChecking.getBoolean();
    }

    public static void setIgnoreAreaChecking(boolean on) {
        cacheIgnoreAreaChecking.setBoolean(on);
    }

    public static boolean isIgnoreExtensionRuleChecking() {
        return cacheIgnoreExtensionRuleChecking.getBoolean();
    }

    public static void setIgnoreExtensionRuleChecking(boolean on) {
        cacheIgnoreExtensionRuleChecking.setBoolean(on);
    }

    private static class CheckSchematicHierarchically
    extends Job {
        Cell cell;

        protected CheckSchematicHierarchically(Cell cell) {
            super("Design-Rule Check " + cell, tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() {
            long startTime = System.currentTimeMillis();
            ErrorLogger errorLog = Schematic.doCheck(this.cell);
            long endTime = System.currentTimeMillis();
            int errorCount = errorLog.getNumErrors();
            System.out.println(errorCount + " errors found (took " + TextUtils.getElapsedTime(endTime - startTime) + ")");
            return true;
        }
    }

    private static class CheckLayoutIncrementally
    extends CheckDRCLayoutJob {
        Geometric[] objectsToCheck;

        protected CheckLayoutIncrementally(Cell cell, Geometric[] objectsToCheck) {
            super("DRC in " + cell, cell, tool, Job.Priority.ANALYSIS);
            this.objectsToCheck = objectsToCheck;
            this.startJob();
        }

        public boolean doIt() {
            incrementalRunning = true;
            int errorsFound = Quick.checkDesignRules(this.cell, this.objectsToCheck, null, null, this);
            if (errorsFound > 0) {
                System.out.println("Incremental DRC found " + errorsFound + " errors/warnings in " + this.cell);
            }
            incrementalRunning = false;
            DRC.doIncrementalDRCTask();
            return true;
        }
    }

    private static class CheckLayoutHierarchically
    extends CheckDRCLayoutJob {
        Rectangle2D bounds;
        private int mergeMode;

        protected CheckLayoutHierarchically(Cell cell, Rectangle2D bounds, int mode) {
            super("Design-Rule Check", cell, tool, Job.Priority.USER);
            this.bounds = bounds;
            this.mergeMode = mode;
            this.startJob();
        }

        public boolean doIt() {
            long startTime = System.currentTimeMillis();
            int errorCount = 0;
            int warnCount = 0;
            if (Quick.checkDesignRules(this.cell, null, null, this.bounds, this, this.mergeMode) > 0) {
                errorCount = ErrorLogger.getCurrent().getNumErrors();
                warnCount = ErrorLogger.getCurrent().getNumWarnings();
            }
            long endTime = System.currentTimeMillis();
            System.out.println(errorCount + " errors and " + warnCount + " warnings found (took " + TextUtils.getElapsedTime(endTime - startTime) + ")");
            return true;
        }
    }

    public static class CheckDRCLayoutJob
    extends Job {
        Cell cell;

        protected CheckDRCLayoutJob(String title, Cell cell, Listener tool, Job.Priority priority) {
            super(title, tool, Job.Type.EXAMINE, null, null, priority);
            this.cell = cell;
        }

        public boolean doIt() {
            return false;
        }
    }

    public static class NodeSizeRule {
        public double sizeX;
        public double sizeY;
        public String rule;

        NodeSizeRule(double sizeX, double sizeY, String rule) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.rule = rule;
        }
    }
}

