/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.Aborter;
import com.sun.electric.tool.ncc.ListNccAnnotations;
import com.sun.electric.tool.ncc.NccBackAnnotate;
import com.sun.electric.tool.ncc.NccBottomUp;
import com.sun.electric.tool.ncc.NccGuiOptions;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.NccResult;
import com.sun.electric.tool.ncc.basic.CellContext;
import com.sun.electric.tool.ncc.basic.NccUtils;
import java.util.Date;

public class Ncc {
    private void prln(String s) {
        System.out.println(s);
    }

    private void pr(String s) {
        System.out.print(s);
    }

    private Ncc() {
    }

    private NccResult compare1(CellContext cc1, CellContext cc2, NccOptions options, Aborter aborter) {
        if (options.operation == 3) {
            ListNccAnnotations.doYourJob(cc1.cell, cc2.cell);
            return new NccResult(true, true, true, null);
        }
        Date before = new Date();
        switch (options.operation) {
            case 2: {
                this.pr("Flat NCC top cells: ");
                break;
            }
            case 1: {
                this.pr("Flat NCC every cell in the design: ");
                break;
            }
            case 0: {
                this.pr("Hierarchical NCC every cell in the design: ");
                break;
            }
            default: {
                LayoutLib.error(true, "bad operation: " + options.operation);
            }
        }
        this.prln(cc1.cell + "  " + cc2.cell);
        NccResult result = NccBottomUp.compare(cc1, cc2, options, aborter);
        if (aborter.userWantsToAbort()) {
            this.prln("NCC run aborted by user");
            return result;
        }
        this.prln("Summary for all cells: " + result.summary(options.checkSizes));
        Date after = new Date();
        this.prln("NCC command completed in: " + NccUtils.hourMinSec(before, after) + ".");
        if (NccGuiOptions.getBackAnnotateLayoutNetNames() && result.match()) {
            NccBackAnnotate.backAnnotateNetNames(result);
        }
        return result;
    }

    public static NccResult compare(Cell cell1, VarContext ctxt1, Cell cell2, VarContext ctxt2, NccOptions options) {
        return Ncc.compare(cell1, ctxt1, cell2, ctxt2, options, null);
    }

    public static NccResult compare(Cell cell1, VarContext ctxt1, Cell cell2, VarContext ctxt2, NccOptions options, Job job) {
        if (ctxt1 == null) {
            ctxt1 = VarContext.globalContext;
        }
        if (ctxt2 == null) {
            ctxt2 = VarContext.globalContext;
        }
        Ncc ncc = new Ncc();
        return ncc.compare1(new CellContext(cell1, ctxt1), new CellContext(cell2, ctxt2), options, new Aborter(job));
    }
}

