/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.processing;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.basic.CellContext;
import com.sun.electric.tool.ncc.basic.CompareList;
import com.sun.electric.tool.ncc.basic.CompareLists;
import com.sun.electric.tool.ncc.processing.SubcircuitInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HierarchyInfo {
    private String subcktName;
    private int compareListID = 0;
    private List cellsInCompareList = new ArrayList();
    private boolean purgeCurrentCompareList;
    private Map cellToSubcktInfo = new HashMap();
    private Set cellsInSharedCellGroups;

    public void beginNextCompareList(String subcktName) {
        this.subcktName = subcktName;
        ++this.compareListID;
        this.purgeCurrentCompareList = false;
        this.cellsInCompareList.clear();
        this.cellsInSharedCellGroups = null;
    }

    public void restrictSubcktDetection(CellContext cc1, CellContext cc2, Set compareListCells) {
        List compareLists = CompareLists.getCompareLists(cc1, cc2);
        this.cellsInSharedCellGroups = new HashSet();
        Iterator it = compareLists.iterator();
        while (it.hasNext()) {
            CompareList compareList = (CompareList)it.next();
            Iterator it2 = compareList.iterator();
            while (it2.hasNext()) {
                Cell c = ((CellContext)it2.next()).cell;
                if (compareListCells.contains(c)) continue;
                this.cellsInSharedCellGroups.add(c);
            }
        }
    }

    public void addSubcircuitInfo(Cell c, SubcircuitInfo subcktInfo) {
        if (this.purgeCurrentCompareList) {
            return;
        }
        LayoutLib.error(this.cellToSubcktInfo.containsKey(c), "SubcircuitInfo already exists for Cell");
        this.cellsInCompareList.add(c);
        this.cellToSubcktInfo.put(c, subcktInfo);
    }

    public void purgeCurrentCompareList() {
        this.purgeCurrentCompareList = true;
        Iterator it = this.cellsInCompareList.iterator();
        while (it.hasNext()) {
            Cell c = (Cell)it.next();
            LayoutLib.error(!this.cellToSubcktInfo.containsKey(c), "Cell not in map?");
            this.cellToSubcktInfo.remove(c);
        }
        this.cellsInCompareList.clear();
    }

    public String currentSubcircuitName() {
        return this.subcktName;
    }

    public int currentSubcircuitID() {
        return this.compareListID;
    }

    public boolean treatAsPrimitive(Cell c) {
        return this.cellToSubcktInfo.containsKey(c) && (this.cellsInSharedCellGroups == null || this.cellsInSharedCellGroups.contains(c));
    }

    public SubcircuitInfo getSubcircuitInfo(Cell c) {
        return (SubcircuitInfo)this.cellToSubcktInfo.get(c);
    }
}

