/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCRules;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitiveNodeSize;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.TransistorSize;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.BiCMOS;
import com.sun.electric.technology.technologies.Bipolar;
import com.sun.electric.technology.technologies.CMOS;
import com.sun.electric.technology.technologies.EFIDO;
import com.sun.electric.technology.technologies.FPGA;
import com.sun.electric.technology.technologies.GEM;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.MoCMOS;
import com.sun.electric.technology.technologies.MoCMOSOld;
import com.sun.electric.technology.technologies.MoCMOSSub;
import com.sun.electric.technology.technologies.PCB;
import com.sun.electric.technology.technologies.RCMOS;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.technology.technologies.nMOS;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.projectSettings.ProjSettings;
import com.sun.electric.tool.user.projectSettings.ProjSettingsNode;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Technology
implements Comparable<Technology> {
    private static final int NONELECTRICAL = 1;
    private static final int NODIRECTIONALARCS = 2;
    private static final int NONEGATEDARCS = 4;
    private static final int NONSTANDARD = 8;
    private static final int STATICTECHNOLOGY = 16;
    private static final int NOPRIMTECHNOLOGY = 32;
    private static Pref.Group prefs = null;
    private static TreeMap<String, Technology> technologies = new TreeMap();
    private static Technology curTech = null;
    private static Technology curLayoutTech = null;
    private static int techNumber = 0;
    private String techName;
    private String techShortName;
    private String techDesc;
    private int userBits;
    private int techIndex;
    private boolean scaleRelevant;
    private int transparentLayers;
    private Pref[] transparentColorPrefs;
    private Color[] colorMap;
    private final List<Layer> layers = new ArrayList<Layer>();
    private LinkedHashMap<String, PrimitiveNode> nodes = new LinkedHashMap();
    private int nodeIndex = 0;
    private LinkedHashMap<String, ArcProto> arcs = new LinkedHashMap();
    private List<NodeLayer> nodeLayers;
    private String[] spiceHeaderLevel1;
    private String[] spiceHeaderLevel2;
    private String[] spiceHeaderLevel3;
    private Pref prefScale;
    private Pref prefResolution;
    private Pref prefFoundry;
    protected List<Foundry> foundries;
    private Pref prefMinResistance;
    private Pref prefMinCapacitance;
    private Pref prefGateLengthSubtraction;
    private Pref prefIncludeGate;
    private Pref prefIncludeGnd;
    private Pref prefMaxSeriesResistance;
    private Pref cacheGlobalFanout;
    private Pref cacheConvergenceEpsilon;
    private Pref cacheMaxIterations;
    private Pref cacheGateCapacitance;
    private Pref cacheWireRatio;
    private Pref cacheDiffAlpha;
    private Pref cacheKeeperRatio;
    private static double DEFAULT_GLOBALFANOUT = 4.7;
    private static double DEFAULT_EPSILON = 0.001;
    private static int DEFAULT_MAXITER = 30;
    private static double DEFAULT_GATECAP = 0.4;
    private static double DEFAULT_WIRERATIO = 0.16;
    private static double DEFAULT_DIFFALPHA = 0.7;
    private static double DEFAULT_KEEPERRATIO = 0.1;
    protected Object[][] nodeGroups;
    public static final int N_TYPE = 1;
    public static final int P_TYPE = 0;
    protected DRCRules cachedRules = null;
    private static final String[] extraTechnologies = new String[]{"tsmc.TSMC90"};
    private static Technology tsmc90 = null;
    private static boolean tsmcCached = false;
    public static final LayerHeight LAYERS_BY_HEIGHT = new LayerHeight(false);
    public static final LayerHeight LAYERS_BY_HEIGHT_LIFT_CONTACTS = new LayerHeight(true);
    private static final List<Layer.Function> diffLayers = new ArrayList<Layer.Function>(2);
    private static final NodeLayer[] nullPrimLayers;
    public static final Variable.Key TECH_TMPVAR;

    protected Technology(String techName) {
        this.techName = techName;
        this.nodeLayers = new ArrayList<NodeLayer>();
        this.scaleRelevant = true;
        this.techIndex = techNumber++;
        this.userBits = 0;
        if (prefs == null) {
            prefs = Pref.groupForPackage(Schematics.class);
        }
        assert (Technology.findTechnology(techName) == null);
        technologies.put(techName, this);
        this.foundries = new ArrayList<Foundry>();
    }

    public static void initAllTechnologies() {
        Artwork.tech.setup();
        BiCMOS.tech.setup();
        Bipolar.tech.setup();
        CMOS.tech.setup();
        EFIDO.tech.setup();
        FPGA.tech.setup();
        GEM.tech.setup();
        MoCMOS.tech.setup();
        MoCMOSOld.tech.setup();
        MoCMOSSub.tech.setup();
        nMOS.tech.setup();
        PCB.tech.setup();
        RCMOS.tech.setup();
        Schematics.tech.setup();
        Generic.tech.setup();
        for (int i = 0; i < extraTechnologies.length; ++i) {
            try {
                Class<?> extraTechClass = Class.forName("com.sun.electric.plugins." + extraTechnologies[i]);
                extraTechClass.getMethod("setItUp", null).invoke(null, (Object[])null);
                continue;
            }
            catch (ClassNotFoundException e) {
                if (!Job.getDebug()) continue;
                System.out.println("GNU Release can't find extra technologies");
                continue;
            }
            catch (Exception e) {
                System.out.println("Exceptions while importing extra technologies");
                ActivityLogger.logException(e);
            }
        }
        Technology tech = Technology.findTechnology(User.getDefaultTechnology());
        if (tech == null) {
            tech = MoCMOS.tech;
        }
        tech.setCurrent();
        Generic.tech.makeUnivList();
    }

    public static Technology getTSMC90Technology() {
        if (tsmcCached) {
            return tsmc90;
        }
        tsmcCached = true;
        try {
            Class<?> tsmc90Class = Class.forName("com.sun.electric.plugins." + extraTechnologies[0]);
            Field techField = tsmc90Class.getDeclaredField("tech");
            tsmc90 = (Technology)techField.get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tsmc90;
    }

    protected void setup() {
        this.init();
        Iterator<Layer> it = this.getLayers();
        block0: while (it.hasNext()) {
            Layer layer = it.next();
            int extras = layer.getFunctionExtras();
            if ((extras & 0x1000) == 0) continue;
            Layer.Function fun = layer.getFunction();
            Iterator<Layer> oIt = this.getLayers();
            while (oIt.hasNext()) {
                Layer oLayer = oIt.next();
                int oExtras = oLayer.getFunctionExtras();
                Layer.Function oFun = oLayer.getFunction();
                if (oFun != fun || oExtras != (extras & 0xFFFFEFFF)) continue;
                layer.setNonPseudoLayer(oLayer);
                continue block0;
            }
        }
    }

    public void setState(boolean resizeNodes) {
    }

    public void init() {
        double width;
        HashMap<ArcProto, Double> arcWidths = new HashMap<ArcProto, Double>();
        Iterator<ArcProto> it = this.getArcs();
        while (it.hasNext()) {
            ArcProto ap = it.next();
            double width2 = ap.getDefaultWidth();
            arcWidths.put(ap, width2);
        }
        HashMap<PrimitiveNode, Point2D.Double> nodeSizes = new HashMap<PrimitiveNode, Point2D.Double>();
        Iterator<Comparable<PrimitiveNode>> it2 = this.getNodes();
        while (it2.hasNext()) {
            PrimitiveNode np = it2.next();
            double width3 = np.getDefWidth();
            double height = np.getDefHeight();
            nodeSizes.put(np, new Point2D.Double(width3, height));
        }
        this.setState(true);
        it2 = this.getArcs();
        while (it2.hasNext()) {
            ArcProto ap = (ArcProto)it2.next();
            Double origWidth = (Double)arcWidths.get(ap);
            if (origWidth == null) continue;
            width = ap.getDefaultWidth();
            if (!(origWidth > width)) continue;
            ap.setDefaultWidth(origWidth);
        }
        it2 = this.getNodes();
        while (it2.hasNext()) {
            PrimitiveNode np = (PrimitiveNode)it2.next();
            Point2D size = (Point2D)nodeSizes.get(np);
            if (size == null) continue;
            width = np.getDefWidth();
            double height = np.getDefHeight();
            if (!(size.getX() > width) && !(size.getY() > height)) continue;
            np.setDefSize(size.getX(), size.getY());
        }
    }

    public static Technology getCurrent() {
        return curTech;
    }

    public void setCurrent() {
        curTech = this;
        if (this != Generic.tech && this != Schematics.tech && this != Artwork.tech) {
            curLayoutTech = this;
        }
    }

    public static int getNumTechnologies() {
        return technologies.size();
    }

    public static Technology findTechnology(String name) {
        if (name == null) {
            return null;
        }
        Technology tech = technologies.get(name);
        if (tech != null) {
            return tech;
        }
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology t = it.next();
            if (!t.techName.equalsIgnoreCase(name)) continue;
            return t;
        }
        return null;
    }

    public static Iterator<Technology> getTechnologies() {
        return technologies.values().iterator();
    }

    public Map<String, Object> convertOldVariable(String varName, Object value) {
        return null;
    }

    public boolean cleanUnusedNodesInLibrary(NodeInst ni, List<Geometric> list) {
        return false;
    }

    public Iterator<Layer> getLayers() {
        return this.layers.iterator();
    }

    public Layer getLayer(int index) {
        return this.layers.get(index);
    }

    public int getNumLayers() {
        return this.layers.size();
    }

    public Layer findLayer(String layerName) {
        Iterator<Layer> it = this.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            if (!layer.getName().equalsIgnoreCase(layerName)) continue;
            return layer;
        }
        return null;
    }

    public int getRuleNodeIndex(String name) {
        int count = 0;
        Iterator<PrimitiveNode> it = this.getNodes();
        while (it.hasNext()) {
            PrimitiveNode pn = it.next();
            if (pn.getName().equalsIgnoreCase(name)) {
                return this.getNumLayers() + count;
            }
            ++count;
        }
        return -1;
    }

    public static Layer getLayerFromOverride(String override, int startPos, char endChr, Technology tech) {
        int endPos = override.indexOf(endChr, startPos);
        if (endPos < 0) {
            return null;
        }
        String layerName = override.substring(startPos, endPos);
        return tech.findLayer(layerName);
    }

    public Layer findLayerFromFunction(Layer.Function fun) {
        Iterator<Layer> it = this.getLayers();
        while (it.hasNext()) {
            Layer lay = it.next();
            Layer.Function lFun = lay.getFunction();
            if (lFun != fun) continue;
            return lay;
        }
        return null;
    }

    public void addLayer(Layer layer) {
        layer.setIndex(this.layers.size());
        this.layers.add(layer);
    }

    public boolean sameLayer(Layer layer1, Layer layer2) {
        return layer1 == layer2;
    }

    public List<Layer> getLayersSortedByHeight() {
        ArrayList<Layer> layerList = new ArrayList<Layer>();
        Iterator<Layer> it = this.getLayers();
        while (it.hasNext()) {
            layerList.add(it.next());
        }
        Collections.sort(layerList, LAYERS_BY_HEIGHT);
        return layerList;
    }

    public int getNumMetals() {
        return 0;
    }

    public ArcProto findArcProto(String name) {
        if (name == null) {
            return null;
        }
        ArcProto primArc = this.arcs.get(name);
        if (primArc != null) {
            return primArc;
        }
        Iterator<ArcProto> it = this.getArcs();
        while (it.hasNext()) {
            ArcProto ap = it.next();
            if (!ap.getName().equalsIgnoreCase(name)) continue;
            return ap;
        }
        return null;
    }

    public Iterator<ArcProto> getArcs() {
        return this.arcs.values().iterator();
    }

    public int getNumArcs() {
        return this.arcs.size();
    }

    public void addArcProto(ArcProto ap) {
        assert (this.findArcProto(ap.getName()) == null);
        ap.primArcIndex = this.arcs.size();
        this.arcs.put(ap.getName(), ap);
    }

    protected void setNoDirectionalArcs() {
        this.userBits |= 2;
    }

    public boolean isNoDirectionalArcs() {
        return (this.userBits & 2) != 0;
    }

    protected void setNoNegatedArcs() {
        this.userBits |= 4;
    }

    public boolean isNoNegatedArcs() {
        return (this.userBits & 4) != 0;
    }

    public Poly[] getShapeOfArc(ArcInst ai) {
        return this.getShapeOfArc(ai, null, null, null);
    }

    public Poly[] getShapeOfArc(ArcInst ai, EditWindow0 wnd) {
        return this.getShapeOfArc(ai, wnd, null, null);
    }

    public Poly[] getShapeOfArc(ArcInst ai, EditWindow0 wnd, Layer layerOverride, List<Layer.Function> onlyTheseLayers) {
        int i;
        ArcProto ap = ai.getProto();
        Technology tech = ap.getTechnology();
        ArcLayer[] primLayers = ap.getLayers();
        if (onlyTheseLayers != null) {
            ArrayList<ArcLayer> layerArray = new ArrayList<ArcLayer>();
            for (int i2 = 0; i2 < primLayers.length; ++i2) {
                ArcLayer primLayer = primLayers[i2];
                if (!onlyTheseLayers.contains(primLayer.layer.getFunction())) continue;
                layerArray.add(primLayer);
            }
            primLayers = new ArcLayer[layerArray.size()];
            layerArray.toArray(primLayers);
        }
        if (primLayers.length == 0) {
            return new Poly[0];
        }
        int numDisplayable = ai.numDisplayableVariables(true);
        if (wnd == null) {
            numDisplayable = 0;
        }
        int maxPolys = primLayers.length + numDisplayable;
        boolean addArrow = false;
        if (!tech.isNoDirectionalArcs()) {
            if (ai.isBodyArrowed()) {
                addArrow = true;
                ++maxPolys;
            }
            if (ai.isHeadArrowed()) {
                addArrow = true;
                ++maxPolys;
            }
            if (ai.isTailArrowed()) {
                addArrow = true;
                ++maxPolys;
            }
        }
        boolean negated = false;
        Point2D headLoc = ai.getHeadLocation();
        Point2D tailLoc = ai.getTailLocation();
        if (!tech.isNoNegatedArcs() && (ai.isHeadNegated() || ai.isTailNegated())) {
            negated = true;
        }
        Poly[] polys = new Poly[maxPolys];
        int polyNum = 0;
        Layer lastLayer = null;
        if (negated) {
            for (i = 0; i < primLayers.length; ++i) {
                double headX = ((Point2D)headLoc).getX();
                double headY = ((Point2D)headLoc).getY();
                double tailX = ((Point2D)tailLoc).getX();
                double tailY = ((Point2D)tailLoc).getY();
                int angle = ai.getAngle();
                double bubbleSize = Schematics.getNegatingBubbleSize();
                double cosDist = DBMath.cos(angle) * bubbleSize;
                double sinDist = DBMath.sin(angle) * bubbleSize;
                if (ai.isHeadNegated()) {
                    headX -= cosDist;
                    headY -= sinDist;
                }
                if (ai.isTailNegated()) {
                    tailX += cosDist;
                    tailY += sinDist;
                }
                Point2D[] points = new Point2D.Double[2];
                headLoc = new Point2D.Double(headX, headY);
                points[0] = headLoc;
                tailLoc = new Point2D.Double(tailX, tailY);
                points[1] = tailLoc;
                polys[polyNum] = new Poly(points);
                polys[polyNum].setStyle(Poly.Type.OPENED);
                lastLayer = layerOverride;
                if (lastLayer == null) {
                    ArcLayer primLayer = primLayers[i];
                    lastLayer = primLayer.getLayer();
                }
                polys[polyNum].setLayer(lastLayer);
                ++polyNum;
            }
        } else {
            for (i = 0; i < primLayers.length; ++i) {
                ArcLayer primLayer = primLayers[i];
                polys[polyNum] = ai.makePoly(ai.getWidth() - primLayer.getOffset(), primLayer.getStyle());
                if (polys[polyNum] == null) {
                    return null;
                }
                lastLayer = layerOverride;
                if (lastLayer == null) {
                    lastLayer = primLayer.getLayer();
                }
                polys[polyNum].setLayer(lastLayer);
                ++polyNum;
            }
        }
        if (addArrow) {
            int backAngle2;
            double headX = ((Point2D)headLoc).getX();
            double headY = ((Point2D)headLoc).getY();
            double tailX = ((Point2D)tailLoc).getX();
            double tailY = ((Point2D)tailLoc).getY();
            int angle = ai.getAngle();
            if (ai.isBodyArrowed()) {
                Point2D[] points = new Point2D.Double[]{new Point2D.Double(headX, headY), new Point2D.Double(tailX, tailY)};
                polys[polyNum] = new Poly(points);
                polys[polyNum].setStyle(Poly.Type.VECTORS);
                polys[polyNum].setLayer(lastLayer);
                ++polyNum;
            }
            if (ai.isTailArrowed()) {
                Point2D[] points;
                int angleOfArrow = 3300;
                int backAngle1 = angle - angleOfArrow;
                backAngle2 = angle + angleOfArrow;
                points = new Point2D.Double[]{new Point2D.Double(tailX, tailY), new Point2D.Double(tailX + DBMath.cos(backAngle1), tailY + DBMath.sin(backAngle1)), points[0], new Point2D.Double(tailX + DBMath.cos(backAngle2), tailY + DBMath.sin(backAngle2))};
                polys[polyNum] = new Poly(points);
                polys[polyNum].setStyle(Poly.Type.VECTORS);
                polys[polyNum].setLayer(lastLayer);
                ++polyNum;
            }
            if (ai.isHeadArrowed()) {
                Point2D[] points;
                angle = (angle + 1800) % 3600;
                int angleOfArrow = 300;
                int backAngle1 = angle - angleOfArrow;
                backAngle2 = angle + angleOfArrow;
                points = new Point2D.Double[]{new Point2D.Double(headX, headY), new Point2D.Double(headX + DBMath.cos(backAngle1), headY + DBMath.sin(backAngle1)), points[0], new Point2D.Double(headX + DBMath.cos(backAngle2), headY + DBMath.sin(backAngle2))};
                polys[polyNum] = new Poly(points);
                polys[polyNum].setStyle(Poly.Type.VECTORS);
                polys[polyNum].setLayer(lastLayer);
                ++polyNum;
            }
        }
        if (numDisplayable > 0) {
            Rectangle2D rect = ai.getBounds();
            ai.addDisplayableVariables(rect, polys, polyNum, wnd, true);
        }
        return polys;
    }

    public ArcProto convertOldArcName(String name) {
        return null;
    }

    public List<PrimitiveNode> getNodesSortedByName() {
        TreeMap<String, PrimitiveNode> sortedMap = new TreeMap<String, PrimitiveNode>(TextUtils.STRING_NUMBER_ORDER);
        Iterator<PrimitiveNode> it = this.getNodes();
        while (it.hasNext()) {
            PrimitiveNode pn = it.next();
            sortedMap.put(pn.getName(), pn);
        }
        return new ArrayList<PrimitiveNode>(sortedMap.values());
    }

    public PrimitiveNode findNodeProto(String name) {
        if (name == null) {
            return null;
        }
        PrimitiveNode primNode = this.nodes.get(name);
        if (primNode != null) {
            return primNode;
        }
        Iterator<PrimitiveNode> it = this.getNodes();
        while (it.hasNext()) {
            PrimitiveNode pn = it.next();
            if (!pn.getName().equalsIgnoreCase(name)) continue;
            return pn;
        }
        return null;
    }

    public Iterator<PrimitiveNode> getNodes() {
        return this.nodes.values().iterator();
    }

    public int getNumNodes() {
        return this.nodes.size();
    }

    public void addNodeProto(PrimitiveNode np) {
        assert (this.findNodeProto(np.getName()) == null);
        np.setPrimNodeIndexInTech(this.nodeIndex++);
        this.nodes.put(np.getName(), np);
    }

    public Iterator<NodeLayer> getNodeLayers() {
        return this.nodeLayers.iterator();
    }

    private void addNodeLayer(NodeLayer nodeLayer) {
        this.nodeLayers.add(nodeLayer);
    }

    public PrimitiveNode.Function getPrimitiveFunction(PrimitiveNode pn, int techBits) {
        return pn.getFunction();
    }

    public PrimitiveNodeSize getResistorSize(NodeInst ni, VarContext context) {
        if (ni.isCellInstance()) {
            return null;
        }
        SizeOffset so = ni.getSizeOffset();
        double length = ni.getXSize() - so.getLowXOffset() - so.getHighXOffset();
        double width = ni.getYSize() - so.getLowYOffset() - so.getHighYOffset();
        PrimitiveNodeSize size = new PrimitiveNodeSize(new Double(width), new Double(length));
        return size;
    }

    public double getTransistorActiveLength(NodeInst ni) {
        Poly[] diffList = this.getShapeOfNode(ni, null, null, true, false, diffLayers);
        double activeLen = 0.0;
        if (diffList.length > 0) {
            Poly poly = diffList[0];
            activeLen = poly.getBounds2D().getHeight();
        }
        return activeLen;
    }

    public TransistorSize getTransistorSize(NodeInst ni, VarContext context) {
        SizeOffset so = ni.getSizeOffset();
        double width = ni.getXSize() - so.getLowXOffset() - so.getHighXOffset();
        double height = ni.getYSize() - so.getLowYOffset() - so.getHighYOffset();
        Point2D[] trace = ni.getTrace();
        if (trace != null) {
            width = 0.0;
            for (int i = 1; i < trace.length; ++i) {
                width += trace[i - 1].distance(trace[i]);
            }
            height = 2.0;
            double serpentineLength = ni.getSerpentineTransistorLength();
            if (serpentineLength > 0.0) {
                height = serpentineLength;
            }
            System.out.println("No calculating length for active regions yet");
        }
        double activeLen = this.getTransistorActiveLength(ni);
        TransistorSize size = new TransistorSize(new Double(width), new Double(height), new Double(activeLen));
        return size;
    }

    public void setPrimitiveNodeSize(NodeInst ni, double width, double length) {
        SizeOffset so = ni.getSizeOffset();
        double oldWidth = ni.getXSize() - so.getLowXOffset() - so.getHighXOffset();
        double oldLength = ni.getYSize() - so.getLowYOffset() - so.getHighYOffset();
        double dW = width - oldWidth;
        double dL = length - oldLength;
        ni.resize(dW, dL);
    }

    public PortInst getTransistorGatePort(NodeInst ni) {
        return ni.getPortInst(0);
    }

    public PortInst getTransistorBasePort(NodeInst ni) {
        return ni.getPortInst(0);
    }

    public PortInst getTransistorSourcePort(NodeInst ni) {
        return ni.getPortInst(1);
    }

    public PortInst getTransistorEmitterPort(NodeInst ni) {
        return ni.getPortInst(1);
    }

    public PortInst getTransistorDrainPort(NodeInst ni) {
        if (ni.getProto().getTechnology() == Schematics.tech) {
            return ni.getPortInst(2);
        }
        return ni.getPortInst(3);
    }

    public PortInst getTransistorCollectorPort(NodeInst ni) {
        return ni.getPortInst(2);
    }

    public PortInst getTransistorBiasPort(NodeInst ni) {
        if (ni.getNumPortInsts() < 4) {
            return null;
        }
        if (ni.getProto().getTechnology() != Schematics.tech) {
            return null;
        }
        return ni.getPortInst(3);
    }

    public void setPrimitiveFunction(NodeInst ni, PrimitiveNode.Function function) {
    }

    public void setNoPrimitiveNodes() {
        this.userBits |= 0x20;
    }

    public boolean isNoPrimitiveNodes() {
        return (this.userBits & 0x20) != 0;
    }

    public void setDefaultOutline(NodeInst ni) {
    }

    public SizeOffset getNodeInstSizeOffset(NodeInst ni) {
        NodeProto np = ni.getProto();
        return np.getProtoSizeOffset();
    }

    public Poly[] getShapeOfNode(NodeInst ni) {
        return this.getShapeOfNode(ni, null, null, false, false, null);
    }

    public Poly[] getShapeOfNode(NodeInst ni, EditWindow0 wnd) {
        VarContext var = wnd != null ? wnd.getVarContext() : null;
        return this.getShapeOfNode(ni, wnd, var, false, false, null);
    }

    public Poly[] getShapeOfNode(NodeInst ni, EditWindow0 wnd, VarContext context, boolean electrical, boolean reasonable, List<Layer.Function> onlyTheseLayers) {
        NodeLayer[] eLayers;
        if (ni.isCellInstance()) {
            return null;
        }
        PrimitiveNode np = (PrimitiveNode)ni.getProto();
        NodeLayer[] primLayers = np.getLayers();
        if (electrical && (eLayers = np.getElectricalLayers()) != null) {
            primLayers = eLayers;
        }
        if (onlyTheseLayers != null) {
            ArrayList<NodeLayer> layerArray = new ArrayList<NodeLayer>();
            for (int i = 0; i < primLayers.length; ++i) {
                NodeLayer primLayer = primLayers[i];
                if (!onlyTheseLayers.contains(primLayer.layer.getFunction())) continue;
                layerArray.add(primLayer);
            }
            primLayers = new NodeLayer[layerArray.size()];
            layerArray.toArray(primLayers);
        }
        if (primLayers.length == 0) {
            return new Poly[0];
        }
        return this.getShapeOfNode(ni, wnd, context, electrical, reasonable, primLayers, null);
    }

    protected Poly[] getShapeOfNode(NodeInst ni, EditWindow0 wnd, VarContext context, boolean electrical, boolean reasonable, NodeLayer[] primLayers, Layer layerOverride) {
        if (!electrical) {
            if (ni.isWiped()) {
                primLayers = nullPrimLayers;
            } else {
                PrimitiveNode np = (PrimitiveNode)ni.getProto();
                if (np.isWipeOn1or2() && ni.pinUseCount()) {
                    primLayers = nullPrimLayers;
                }
            }
        }
        return this.computeShapeOfNode(ni, wnd, context, electrical, reasonable, primLayers, layerOverride);
    }

    protected Poly[] computeShapeOfNode(NodeInst ni, EditWindow0 wnd, VarContext context, boolean electrical, boolean reasonable, NodeLayer[] primLayers, Layer layerOverride) {
        int i;
        Point2D[] outline;
        PrimitiveNode np = (PrimitiveNode)ni.getProto();
        int specialType = np.getSpecialType();
        if (specialType != 1 && np.isHoldsOutline() && (outline = ni.getTrace()) != null) {
            int portIndex;
            int numPolys = 1;
            if (wnd != null) {
                numPolys += ni.numDisplayableVariables(true);
            }
            Poly[] polys = new Poly[numPolys];
            Point2D[] pointList = new Point2D.Double[outline.length];
            for (int i2 = 0; i2 < outline.length; ++i2) {
                pointList[i2] = new Point2D.Double(ni.getAnchorCenterX() + outline[i2].getX(), ni.getAnchorCenterY() + outline[i2].getY());
            }
            polys[0] = new Poly(pointList);
            NodeLayer primLayer = primLayers[0];
            polys[0].setStyle(primLayer.getStyle());
            if (layerOverride != null) {
                polys[0].setLayer(layerOverride);
            } else {
                polys[0].setLayer(primLayer.getLayer());
            }
            if (electrical && (portIndex = primLayer.getPortNum()) >= 0) {
                polys[0].setPort(np.getPort(portIndex));
            }
            Rectangle2D rect = ni.getBounds();
            if (wnd != null) {
                ni.addDisplayableVariables(rect, polys, 1, wnd, true);
            }
            return polys;
        }
        int numBasicLayers = primLayers.length;
        boolean isCutLayer = numBasicLayers > 0 && primLayers[numBasicLayers - 1].getLayer().getFunction().isContact();
        int numExtraLayers = 0;
        MultiCutData mcd = null;
        SerpentineTrans std = null;
        if (specialType == 3 && isCutLayer) {
            mcd = new MultiCutData(ni.getD(), np.getSpecialValues());
            numExtraLayers = reasonable ? mcd.cutsReasonable : mcd.cutsTotal;
            --numBasicLayers;
        } else if (specialType == 1 && (std = new SerpentineTrans(ni.getD())).layersTotal > 0) {
            numExtraLayers = std.layersTotal;
            numBasicLayers = 0;
        }
        int numNegatingBubbles = 0;
        Iterator<Connection> it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = it.next();
            if (!con.isNegated()) continue;
            ++numNegatingBubbles;
        }
        int numPolys = numBasicLayers + numExtraLayers + numNegatingBubbles;
        if (wnd != null) {
            numPolys += ni.numDisplayableVariables(true);
        }
        Poly[] polys = new Poly[numPolys];
        double xCenter = ni.getAnchorCenterX();
        double yCenter = ni.getAnchorCenterY();
        double xSize = ni.getXSize();
        double ySize = ni.getYSize();
        int fillPoly = 0;
        for (i = 0; i < numBasicLayers; ++i) {
            int portIndex;
            NodeLayer primLayer = primLayers[i];
            int representation = primLayer.getRepresentation();
            if (representation == 1 || representation == 2) {
                EdgeH leftEdge = primLayer.getLeftEdge();
                EdgeH rightEdge = primLayer.getRightEdge();
                EdgeV topEdge = primLayer.getTopEdge();
                EdgeV bottomEdge = primLayer.getBottomEdge();
                double portLowX = xCenter + leftEdge.getMultiplier() * xSize + leftEdge.getAdder();
                double portHighX = xCenter + rightEdge.getMultiplier() * xSize + rightEdge.getAdder();
                double portLowY = yCenter + bottomEdge.getMultiplier() * ySize + bottomEdge.getAdder();
                double portHighY = yCenter + topEdge.getMultiplier() * ySize + topEdge.getAdder();
                Point2D[] pointList = Poly.makePoints(portLowX, portHighX, portLowY, portHighY);
                polys[fillPoly] = new Poly(pointList);
            } else if (representation == 0) {
                TechPoint[] points = primLayer.getPoints();
                Point2D[] pointList = new Point2D.Double[points.length];
                for (int j = 0; j < points.length; ++j) {
                    EdgeH xFactor = points[j].getX();
                    EdgeV yFactor = points[j].getY();
                    double x = 0.0;
                    double y = 0.0;
                    if (xFactor != null && yFactor != null) {
                        x = xCenter + xFactor.getMultiplier() * xSize + xFactor.getAdder();
                        y = yCenter + yFactor.getMultiplier() * ySize + yFactor.getAdder();
                    }
                    pointList[j] = new Point2D.Double(x, y);
                }
                polys[fillPoly] = new Poly(pointList);
            }
            Poly.Type style = primLayer.getStyle();
            if (style.isText()) {
                polys[fillPoly].setString(primLayer.getMessage());
                polys[fillPoly].setTextDescriptor(primLayer.getDescriptor());
            }
            polys[i].setStyle(style);
            if (layerOverride != null) {
                polys[i].setLayer(layerOverride);
            } else {
                polys[fillPoly].setLayer(primLayer.getLayer());
            }
            if (electrical && (portIndex = primLayer.getPortNum()) >= 0) {
                polys[fillPoly].setPort(np.getPort(portIndex));
            }
            ++fillPoly;
        }
        if (mcd != null) {
            NodeLayer primLayer = primLayers[numBasicLayers];
            Poly.Type style = primLayer.getStyle();
            PrimitivePort port = null;
            if (electrical) {
                port = np.getPort(0);
            }
            for (int i3 = 0; i3 < numExtraLayers; ++i3) {
                polys[fillPoly] = mcd.fillCutPoly(ni.getD(), i3);
                polys[fillPoly].setStyle(style);
                polys[fillPoly].setLayer(primLayer.getLayer());
                polys[fillPoly].setPort(port);
                ++fillPoly;
            }
        }
        if (numNegatingBubbles > 0) {
            double bubbleRadius = Schematics.getNegatingBubbleSize() / 2.0;
            Iterator<Connection> it2 = ni.getConnections();
            while (it2.hasNext()) {
                Connection con = it2.next();
                if (!con.isNegated()) continue;
                AffineTransform trans = ni.rotateIn();
                Point2D.Double portLocation = new Point2D.Double(con.getLocation().getX(), con.getLocation().getY());
                trans.transform(portLocation, portLocation);
                double x = ((Point2D)portLocation).getX();
                double y = ((Point2D)portLocation).getY();
                PrimitivePort pp = (PrimitivePort)con.getPortInst().getPortProto();
                int angle = pp.getAngle() * 10;
                double dX = DBMath.cos(angle) * bubbleRadius;
                double dY = DBMath.sin(angle) * bubbleRadius;
                Point2D[] points = new Point2D[]{new Point2D.Double(x + dX, y + dY), new Point2D.Double(x, y)};
                polys[fillPoly] = new Poly(points);
                polys[fillPoly].setStyle(Poly.Type.CIRCLE);
                polys[fillPoly].setLayer(Schematics.tech.node_lay);
                ++fillPoly;
            }
        }
        if (std != null) {
            for (i = 0; i < numExtraLayers; ++i) {
                polys[fillPoly] = std.fillTransPoly(i, electrical);
                ++fillPoly;
            }
        }
        if (wnd != null) {
            Rectangle2D rect = ni.getUntransformedBounds();
            ni.addDisplayableVariables(rect, polys, fillPoly, wnd, true);
        }
        return polys;
    }

    public boolean isMultiCutInTechnology(MultiCutData mcd) {
        return mcd.numCuts() > 1;
    }

    public boolean isMultiCutCase(NodeInst ni) {
        if (ni.isCellInstance()) {
            return false;
        }
        PrimitiveNode pnp = (PrimitiveNode)ni.getProto();
        if (pnp.getSpecialType() != 3) {
            return false;
        }
        return this.isMultiCutInTechnology(new MultiCutData(ni.getD(), pnp.getSpecialValues()));
    }

    public PrimitiveNode convertOldNodeName(String name) {
        return null;
    }

    public Poly getShapeOfPort(NodeInst ni, PrimitivePort pp) {
        return this.getShapeOfPort(ni, pp, null);
    }

    public Poly getShapeOfPort(NodeInst ni, PrimitivePort pp, Point2D selectPt) {
        Point2D[] outline;
        SerpentineTrans std;
        PrimitiveNode np = (PrimitiveNode)ni.getProto();
        if (np.getSpecialType() == 1 && (std = new SerpentineTrans(ni.getD())).hasValidData()) {
            return std.fillTransPort(pp);
        }
        if (np.isHoldsOutline() && (outline = ni.getTrace()) != null) {
            double cX = ni.getAnchorCenterX();
            double cY = ni.getAnchorCenterY();
            Point2D[] pointList = new Point2D.Double[outline.length];
            for (int i = 0; i < outline.length; ++i) {
                pointList[i] = new Point2D.Double(cX + outline[i].getX(), cY + outline[i].getY());
            }
            Poly portPoly = new Poly(pointList);
            if (ni.getFunction() == PrimitiveNode.Function.NODE) {
                portPoly.setStyle(Poly.Type.FILLED);
            } else {
                portPoly.setStyle(Poly.Type.OPENED);
            }
            portPoly.setTextDescriptor(TextDescriptor.getExportTextDescriptor());
            return portPoly;
        }
        double portLowX = ni.getAnchorCenterX() + pp.getLeft().getMultiplier() * ni.getXSize() + pp.getLeft().getAdder();
        double portHighX = ni.getAnchorCenterX() + pp.getRight().getMultiplier() * ni.getXSize() + pp.getRight().getAdder();
        double portLowY = ni.getAnchorCenterY() + pp.getBottom().getMultiplier() * ni.getYSize() + pp.getBottom().getAdder();
        double portHighY = ni.getAnchorCenterY() + pp.getTop().getMultiplier() * ni.getYSize() + pp.getTop().getAdder();
        double portX = (portLowX + portHighX) / 2.0;
        double portY = (portLowY + portHighY) / 2.0;
        Poly portPoly = new Poly(portX, portY, portHighX - portLowX, portHighY - portLowY);
        portPoly.setStyle(Poly.Type.FILLED);
        portPoly.setTextDescriptor(TextDescriptor.getExportTextDescriptor());
        return portPoly;
    }

    public PrimitivePort convertOldPortName(String portName, PrimitiveNode np) {
        PrimitivePort pp;
        int len = portName.length() - 4;
        if (len > 0 && portName.substring(len).equals("-bot") && (pp = (PrimitivePort)np.findPortProto(portName + "tom")) != null) {
            return pp;
        }
        return null;
    }

    private Pref getParasiticSetting(String what, Pref pref, double factory) {
        if (pref == null) {
            pref = Pref.makeDoubleSetting(what + "IN" + this.getTechName(), prefs, this, this.getProjectSettings(), what, "Parasitic tab", this.getTechShortName() + " " + what, factory);
        }
        return pref;
    }

    private Pref getParasiticSetting(String what, Pref pref, boolean factory) {
        if (pref == null) {
            pref = Pref.makeBooleanSetting(what + "IN" + this.getTechName(), prefs, this, this.getProjectSettings(), what, "Parasitic tab", this.getTechShortName() + " " + what, factory);
        }
        return pref;
    }

    public static Pref.Group getTechnologyPreferences() {
        return prefs;
    }

    public double getMinResistance() {
        this.prefMinResistance = this.getParasiticSetting("MininumResistance", this.prefMinResistance, 10.0);
        return this.prefMinResistance.getDouble();
    }

    public void setMinResistance(double minResistance) {
        this.prefMinResistance = this.getParasiticSetting("MininumResistance", this.prefMinResistance, minResistance);
        this.prefMinResistance.setDouble(minResistance);
    }

    public double getMinCapacitance() {
        this.prefMinCapacitance = this.getParasiticSetting("MininumCapacitance", this.prefMinCapacitance, 0.0);
        return this.prefMinCapacitance.getDouble();
    }

    public void setMinCapacitance(double minCapacitance) {
        this.prefMinCapacitance = this.getParasiticSetting("MininumCapacitance", this.prefMinCapacitance, minCapacitance);
        this.prefMinCapacitance.setDouble(minCapacitance);
    }

    public double getMaxSeriesResistance() {
        this.prefMaxSeriesResistance = this.getParasiticSetting("MaxSeriesResistance", this.prefMaxSeriesResistance, 10.0);
        return this.prefMaxSeriesResistance.getDouble();
    }

    public void setMaxSeriesResistance(double maxSeriesResistance) {
        this.prefMaxSeriesResistance = this.getParasiticSetting("MaxSeriesResistance", this.prefMaxSeriesResistance, maxSeriesResistance);
        this.prefMaxSeriesResistance.setDouble(maxSeriesResistance);
    }

    public boolean isGateIncluded() {
        this.prefIncludeGate = this.getParasiticSetting("Gate Inclusion", this.prefIncludeGate, false);
        return this.prefIncludeGate.getBoolean();
    }

    public void setGateIncluded(boolean set) {
        this.prefIncludeGate = this.getParasiticSetting("Gate Inclusion", this.prefIncludeGate, set);
        this.prefIncludeGate.setBoolean(set);
    }

    public void setGroundNetIncluded(boolean set) {
        this.prefIncludeGnd = this.getParasiticSetting("Ground Net Inclusion", this.prefIncludeGnd, set);
        this.prefIncludeGnd.setBoolean(set);
    }

    public boolean isGroundNetIncluded() {
        this.prefIncludeGnd = this.getParasiticSetting("Ground Net Inclusion", this.prefIncludeGnd, false);
        return this.prefIncludeGnd.getBoolean();
    }

    public double getGateLengthSubtraction() {
        this.prefGateLengthSubtraction = this.getParasiticSetting("GateLengthSubtraction", this.prefGateLengthSubtraction, 0.0);
        return this.prefGateLengthSubtraction.getDouble();
    }

    public void setGateLengthSubtraction(double value) {
        this.getGateLengthSubtraction();
        this.prefGateLengthSubtraction.setDouble(value);
    }

    public void setFactoryParasitics(double minResistance, double minCapacitance) {
        this.prefMinResistance = this.getParasiticSetting("MininumResistance", this.prefMinResistance, minResistance);
        this.prefMinCapacitance = this.getParasiticSetting("MininumCapacitance", this.prefMinCapacitance, minCapacitance);
    }

    private ProjSettingsNode getLESettingsNode() {
        ProjSettingsNode node = this.getProjectSettings().getNode("LogicalEffort");
        if (node == null) {
            node = new ProjSettingsNode();
            this.getProjectSettings().putNode("LogicalEffort", node);
        }
        return node;
    }

    private Pref getLESetting(String what, Pref pref, double factory) {
        if (pref == null) {
            pref = Pref.makeDoubleSetting(what + "IN" + this.getTechName(), prefs, this, this.getLESettingsNode(), what, "Logical Effort tab", this.getTechShortName() + " " + what, factory);
        }
        return pref;
    }

    private Pref getLESetting(String what, Pref pref, int factory) {
        if (pref == null) {
            pref = Pref.makeIntSetting(what + "IN" + this.getTechName(), prefs, this, this.getLESettingsNode(), what, "Logical Effort tab", this.getTechShortName() + " " + what, factory);
        }
        return pref;
    }

    public double getGlobalFanout() {
        this.cacheGlobalFanout = this.getLESetting("GlobalFanout", this.cacheGlobalFanout, DEFAULT_GLOBALFANOUT);
        return this.cacheGlobalFanout.getDouble();
    }

    public void setGlobalFanout(double fo) {
        this.cacheGlobalFanout = this.getLESetting("GlobalFanout", this.cacheGlobalFanout, fo);
        this.cacheGlobalFanout.setDouble(fo);
    }

    public double getConvergenceEpsilon() {
        this.cacheConvergenceEpsilon = this.getLESetting("ConvergenceEpsilon", this.cacheConvergenceEpsilon, DEFAULT_EPSILON);
        return this.cacheConvergenceEpsilon.getDouble();
    }

    public void setConvergenceEpsilon(double ep) {
        this.cacheConvergenceEpsilon = this.getLESetting("ConvergenceEpsilon", this.cacheConvergenceEpsilon, ep);
        this.cacheConvergenceEpsilon.setDouble(ep);
    }

    public int getMaxIterations() {
        this.cacheMaxIterations = this.getLESetting("MaxIterations", this.cacheMaxIterations, DEFAULT_MAXITER);
        return this.cacheMaxIterations.getInt();
    }

    public void setMaxIterations(int it) {
        this.cacheMaxIterations = this.getLESetting("MaxIterations", this.cacheMaxIterations, it);
        this.cacheMaxIterations.setInt(it);
    }

    public double getKeeperRatio() {
        this.cacheKeeperRatio = this.getLESetting("KeeperRatio", this.cacheKeeperRatio, DEFAULT_KEEPERRATIO);
        return this.cacheKeeperRatio.getDouble();
    }

    public void setKeeperRatio(double kr) {
        this.cacheKeeperRatio = this.getLESetting("KeeperRatio", this.cacheKeeperRatio, kr);
        this.cacheKeeperRatio.setDouble(kr);
    }

    public double getGateCapacitance() {
        this.cacheGateCapacitance = this.getLESetting("GateCapacitance", this.cacheGateCapacitance, DEFAULT_GATECAP);
        return this.cacheGateCapacitance.getDouble();
    }

    public void setGateCapacitance(double gc) {
        this.cacheGateCapacitance = this.getLESetting("GateCapacitance", this.cacheGateCapacitance, gc);
        this.cacheGateCapacitance.setDouble(gc);
    }

    public double getWireRatio() {
        this.cacheWireRatio = this.getLESetting("WireRatio", this.cacheWireRatio, DEFAULT_WIRERATIO);
        return this.cacheWireRatio.getDouble();
    }

    public void setWireRatio(double wr) {
        this.cacheWireRatio = this.getLESetting("WireRatio", this.cacheWireRatio, wr);
        this.cacheWireRatio.setDouble(wr);
    }

    public double getDiffAlpha() {
        this.cacheDiffAlpha = this.getLESetting("DiffAlpha", this.cacheDiffAlpha, DEFAULT_DIFFALPHA);
        return this.cacheDiffAlpha.getDouble();
    }

    public void setDiffAlpha(double da) {
        this.cacheDiffAlpha = this.getLESetting("DiffAlpha", this.cacheDiffAlpha, da);
        this.cacheDiffAlpha.setDouble(da);
    }

    public String[] getSpiceHeaderLevel1() {
        return this.spiceHeaderLevel1;
    }

    public void setSpiceHeaderLevel1(String[] lines) {
        this.spiceHeaderLevel1 = lines;
    }

    public String[] getSpiceHeaderLevel2() {
        return this.spiceHeaderLevel2;
    }

    public void setSpiceHeaderLevel2(String[] lines) {
        this.spiceHeaderLevel2 = lines;
    }

    public String[] getSpiceHeaderLevel3() {
        return this.spiceHeaderLevel3;
    }

    public void setSpiceHeaderLevel3(String[] lines) {
        this.spiceHeaderLevel3 = lines;
    }

    protected void setNonElectrical() {
        this.userBits |= 1;
    }

    public boolean isNonElectrical() {
        return (this.userBits & 1) != 0;
    }

    protected void setNonStandard() {
        this.userBits |= 8;
    }

    public boolean isNonStandard() {
        return (this.userBits & 8) != 0;
    }

    protected void setStaticTechnology() {
        this.userBits |= 0x10;
    }

    public boolean isStaticTechnology() {
        return (this.userBits & 0x10) != 0;
    }

    public String getTechName() {
        return this.techName;
    }

    public void setTechName(String techName) {
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            if (tech == this || !tech.techName.equalsIgnoreCase(techName)) continue;
            System.out.println("Cannot rename " + this + "to '" + techName + "' because that name is used by another technology");
            return;
        }
        if (!Technology.jelibSafeName(techName)) {
            System.out.println("Technology name " + techName + " is not safe to write into JELIB");
        }
        this.techName = techName;
    }

    static boolean jelibSafeName(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch != '\n' && ch != '|' && ch != '^' && ch != '\"') continue;
            return false;
        }
        return true;
    }

    public String getTechShortName() {
        return this.techShortName;
    }

    protected void setTechShortName(String techShortName) {
        this.techShortName = techShortName;
    }

    public String getTechDesc() {
        return this.techDesc;
    }

    public void setTechDesc(String techDesc) {
        this.techDesc = techDesc;
    }

    public double getScale() {
        return this.prefScale.getDouble();
    }

    public String getScaleVariableName() {
        return "ScaleFOR" + this.getTechName();
    }

    protected void setFactoryScale(double factory, boolean scaleRelevant) {
        this.scaleRelevant = scaleRelevant;
        this.prefScale = Pref.makeDoubleSetting(this.getScaleVariableName(), prefs, this, this.getProjectSettings(), "Scale", "Scale tab", this.getTechShortName() + " scale", factory);
        Pref.Meaning meaning = this.prefScale.getMeaning();
        meaning.setValidOption(this.isScaleRelevant());
    }

    public void setScale(double scale) {
        if (scale == 0.0) {
            return;
        }
        this.prefScale.setDouble(scale);
    }

    public boolean isScaleRelevant() {
        return this.scaleRelevant;
    }

    protected void setFactoryResolution(double factory) {
        this.prefResolution = Pref.makeDoublePref("ResolutionValueFor" + this.techName, prefs, factory);
    }

    public void setResolution(double resolution) {
        if (this.prefResolution == null) {
            this.setFactoryResolution(0.0);
        }
        this.prefResolution.setDouble(resolution);
    }

    public double getResolution() {
        if (this.prefResolution == null) {
            this.setFactoryResolution(0.0);
        }
        return this.prefResolution.getDouble();
    }

    public String getPrefFoundry() {
        if (this.prefFoundry == null) {
            this.setFactoryPrefFoundry("");
        }
        return this.prefFoundry.getString().toUpperCase();
    }

    public void setPrefFoundry(String t) {
        this.prefFoundry.setString(t);
    }

    public void setPrefFoundryAndResize(String t, boolean resize) {
        this.setPrefFoundry(t);
        TechPref.technologyChanged(this, resize);
    }

    protected void setFactoryPrefFoundry(String factoryName) {
        this.prefFoundry = TechPref.makeStringSetting(this, "SelectedFoundryFor" + this.techName, "Technology tab", this.techName + " foundry", this.getProjectSettings(), "Foundry", factoryName.toUpperCase());
    }

    protected Foundry findFoundry(String name) {
        if (name == null) {
            return null;
        }
        for (Foundry f : this.foundries) {
            Foundry.Type t = f.getType();
            if (!t.name().equalsIgnoreCase(name)) continue;
            return f;
        }
        return null;
    }

    public Iterator<Foundry> getFoundries() {
        return this.foundries.iterator();
    }

    public void addFoundry(Foundry f) {
        Foundry old = this.findFoundry(f.toString());
        if (old != null) {
            this.foundries.remove(old);
        }
        this.foundries.add(f);
    }

    public Foundry getSelectedFoundry() {
        String foundryName = this.getPrefFoundry();
        Foundry f = this.findFoundry(foundryName);
        if (f != null) {
            return f;
        }
        if (this.foundries.size() > 0) {
            return this.foundries.get(0);
        }
        return null;
    }

    protected void setFactoryTransparentLayers(Color[] layers) {
        this.transparentLayers = layers.length;
        this.transparentColorPrefs = new Pref[this.transparentLayers];
        for (int i = 0; i < layers.length; ++i) {
            this.transparentColorPrefs[i] = Pref.makeIntPref("TransparentLayer" + (i + 1) + "For" + this.techName, prefs, layers[i].getRGB());
            layers[i] = new Color(this.transparentColorPrefs[i].getInt());
        }
        this.setColorMapFromLayers(layers);
    }

    public static void cacheTransparentLayerColors() {
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            Iterator<Layer> lIt = tech.getLayers();
            while (lIt.hasNext()) {
                Layer layer = lIt.next();
                layer.getGraphics().recachePrefs();
            }
            if (tech.transparentLayers <= 0) continue;
            Color[] layers = new Color[tech.transparentLayers];
            for (int i = 0; i < tech.transparentLayers; ++i) {
                layers[i] = new Color(tech.transparentColorPrefs[i].getInt());
            }
            tech.setColorMapFromLayers(layers);
        }
    }

    public Color[] getFactoryColorMap() {
        if (this.transparentLayers <= 0) {
            return null;
        }
        Color[] layers = new Color[this.transparentLayers];
        for (int i = 0; i < this.transparentLayers; ++i) {
            layers[i] = new Color(this.transparentColorPrefs[i].getIntFactoryValue());
        }
        Color[] map = this.getColorMap(layers);
        return map;
    }

    public int getNumTransparentLayers() {
        return this.transparentLayers;
    }

    public void setColorMap(Color[] map) {
        this.colorMap = map;
    }

    private void normalizeColor(double[] a) {
        double mag = Math.sqrt(a[0] * a[0] + a[1] * a[1] + a[2] * a[2]);
        if (mag > (double)1.0E-11f) {
            a[0] = a[0] / mag;
            a[1] = a[1] / mag;
            a[2] = a[2] / mag;
        }
    }

    public void setColorMapFromLayers(Color[] layers) {
        if (this.transparentColorPrefs != null) {
            for (int i = 0; i < layers.length; ++i) {
                Pref pref = this.transparentColorPrefs[i];
                if (layers[i] == null) continue;
                pref.setInt(layers[i].getRGB());
            }
        }
        Color[] map = this.getColorMap(layers);
        this.setColorMap(map);
    }

    private Color[] getColorMap(Color[] layers) {
        int numEntries = 1 << this.transparentLayers;
        Color[] map = new Color[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            int r = 200;
            int g = 200;
            int b = 200;
            boolean hasPrevious = false;
            for (int j = 0; j < this.transparentLayers; ++j) {
                if ((i & 1 << j) == 0) continue;
                if (hasPrevious) {
                    double[] lastColor = new double[]{(double)r / 255.0, (double)g / 255.0, (double)b / 255.0};
                    this.normalizeColor(lastColor);
                    double[] curColor = new double[]{(double)layers[j].getRed() / 255.0, (double)layers[j].getGreen() / 255.0, (double)layers[j].getBlue() / 255.0};
                    this.normalizeColor(curColor);
                    for (int k = 0; k < 3; ++k) {
                        int n = k;
                        curColor[n] = curColor[n] + lastColor[k];
                    }
                    this.normalizeColor(curColor);
                    r = (int)(curColor[0] * 255.0);
                    g = (int)(curColor[1] * 255.0);
                    b = (int)(curColor[2] * 255.0);
                    continue;
                }
                r = layers[j].getRed();
                g = layers[j].getGreen();
                b = layers[j].getBlue();
                hasPrevious = true;
            }
            map[i] = new Color(r, g, b);
        }
        return map;
    }

    public DRCRules getFactoryDesignRules(boolean resizeNodes) {
        return null;
    }

    public static StringBuffer getRuleDifferences(DRCRules origRules, DRCRules newRules) {
        return new StringBuffer("");
    }

    public void setRuleVariables(DRCRules newRules) {
    }

    public static DRCRules makeSimpleRules(double[] conDist, double[] unConDist) {
        return null;
    }

    public Color[] getColorMap() {
        return this.colorMap;
    }

    public int getIndex() {
        return this.techIndex;
    }

    public static Technology whatTechnology(NodeProto cell) {
        Technology tech = Technology.whatTechnology(cell, null, 0, 0, null, 0, 0);
        return tech;
    }

    public static Technology whatTechnology(NodeProto cellOrPrim, NodeProto[] nodeProtoList, int startNodeProto, int endNodeProto, ArcProto[] arcProtoList, int startArcProto, int endArcProto) {
        int i;
        if (cellOrPrim instanceof PrimitiveNode) {
            return ((PrimitiveNode)cellOrPrim).getTechnology();
        }
        Cell cell = (Cell)cellOrPrim;
        int maxTech = 0;
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            if (tech.getIndex() <= maxTech) continue;
            maxTech = tech.getIndex();
        }
        int[] useCount = new int[++maxTech];
        for (i = 0; i < maxTech; ++i) {
            useCount[i] = 0;
        }
        if (nodeProtoList != null) {
            for (i = startNodeProto; i < endNodeProto; ++i) {
                Cell subCell;
                NodeProto np = nodeProtoList[i];
                if (np == null) continue;
                Technology nodeTech = np.getTechnology();
                if (np instanceof Cell && (subCell = (Cell)np).isIcon()) {
                    nodeTech = Schematics.tech;
                }
                if (nodeTech == null) continue;
                int n = nodeTech.getIndex();
                useCount[n] = useCount[n] + 1;
            }
        } else {
            Iterator<NodeInst> it2 = cell.getNodes();
            while (it2.hasNext()) {
                Cell subCell;
                NodeInst ni = it2.next();
                NodeProto np = ni.getProto();
                Technology nodeTech = np.getTechnology();
                if (ni.isCellInstance() && (subCell = (Cell)np).isIcon()) {
                    nodeTech = Schematics.tech;
                }
                if (nodeTech == null) continue;
                int n = nodeTech.getIndex();
                useCount[n] = useCount[n] + 1;
            }
        }
        if (arcProtoList != null) {
            for (int i2 = startArcProto; i2 < endArcProto; ++i2) {
                ArcProto ap = arcProtoList[i2];
                if (ap == null) continue;
                int n = ap.getTechnology().getIndex();
                useCount[n] = useCount[n] + 1;
            }
        } else {
            Iterator<ArcInst> it3 = cell.getArcs();
            while (it3.hasNext()) {
                ArcInst ai = it3.next();
                ArcProto ap = ai.getProto();
                int n = ap.getTechnology().getIndex();
                useCount[n] = useCount[n] + 1;
            }
        }
        int best = 0;
        Technology bestTech = null;
        int bestLayout = 0;
        Technology bestLayoutTech = null;
        Iterator<Technology> it4 = Technology.getTechnologies();
        while (it4.hasNext()) {
            Technology tech = it4.next();
            if (tech == Generic.tech) continue;
            if (useCount[tech.getIndex()] > best) {
                best = useCount[tech.getIndex()];
                bestTech = tech;
            }
            if (!tech.isLayout() || useCount[tech.getIndex()] <= bestLayout) continue;
            bestLayout = useCount[tech.getIndex()];
            bestLayoutTech = tech;
        }
        Technology retTech = null;
        if (cell.isIcon() || cell.getView().isTextView()) {
            if (useCount[Artwork.tech.getIndex()] > 0) {
                return Artwork.tech;
            }
            if (bestTech == null) {
                return Artwork.tech;
            }
            retTech = Artwork.tech;
        } else if (cell.isSchematic()) {
            if (useCount[Schematics.tech.getIndex()] > 0) {
                return Schematics.tech;
            }
            if (bestTech == null) {
                return Schematics.tech;
            }
            retTech = Schematics.tech;
        } else {
            retTech = curLayoutTech;
        }
        if (bestLayoutTech != null) {
            retTech = bestLayoutTech;
        } else if (bestTech != null) {
            retTech = bestTech;
        }
        return retTech;
    }

    public boolean isLayout() {
        return this != Schematics.tech && this != Artwork.tech && this != Generic.tech;
    }

    @Override
    public int compareTo(Technology that) {
        return TextUtils.STRING_NUMBER_ORDER.compare(this.techName, that.techName);
    }

    public String toString() {
        return "Technology " + this.techName;
    }

    protected void setArcLayerSurroundLayer(ArcProto aty, Layer outerLayer, Layer innerLayer, double surround) {
        ArcLayer inLayer = aty.findArcLayer(innerLayer);
        if (inLayer == null) {
            System.out.println("Internal error in " + this.getTechDesc() + " surround computation. Arc layer '" + inLayer.getLayer().getName() + "' is not valid in '" + aty.getName() + "'");
            return;
        }
        ArcLayer outLayer = aty.findArcLayer(outerLayer);
        if (outLayer == null) {
            System.out.println("Internal error in " + this.getTechDesc() + " surround computation. Arc layer '" + inLayer.getLayer().getName() + "' is not valid in '" + aty.getName() + "'");
            return;
        }
        double indent = inLayer.getOffset() - surround * 2.0;
        outLayer.setOffset(indent);
    }

    protected void setLayerMinWidth(String layername, String rulename, double width) {
        PrimitiveNode np;
        ArcProto ap = this.findArcProto(layername);
        if (ap == null) {
            return;
        }
        boolean hasChanged = false;
        if (ap.getDefaultWidth() != width + ap.getWidthOffset()) {
            hasChanged = true;
        }
        if ((np = ap.findPinProto()) == null) {
            return;
        }
        SizeOffset so = np.getProtoSizeOffset();
        double newWidth = width + so.getLowXOffset() + so.getHighXOffset();
        double newHeight = width + so.getLowYOffset() + so.getHighYOffset();
        if (np.getDefHeight() != newHeight || np.getDefWidth() != newWidth) {
            hasChanged = true;
        }
        PrimitivePort pp = (PrimitivePort)np.getPorts().next();
        EdgeH left = pp.getLeft();
        EdgeH right = pp.getRight();
        EdgeV bottom = pp.getBottom();
        EdgeV top = pp.getTop();
        double indent = newWidth / 2.0;
        if (left.getAdder() != indent || right.getAdder() != -indent || top.getAdder() != -indent || bottom.getAdder() != indent) {
            hasChanged = true;
        }
        if (hasChanged) {
            String errorMessage = "User preference of " + width + " overwrites original layer minimum size in layer '" + layername + "', primitive '" + np.getName() + ":" + this.getTechShortName() + "' by rule " + rulename;
            if (Job.LOCALDEBUGFLAG) {
                System.out.println(errorMessage);
            }
        }
    }

    protected void setDefNodeSize(PrimitiveNode nty, double wid, double hei) {
        double xindent = (nty.getDefWidth() - wid) / 2.0;
        double yindent = (nty.getDefHeight() - hei) / 2.0;
        nty.setSizeOffset(new SizeOffset(xindent, xindent, yindent, yindent));
    }

    public Object[][] getNodesGrouped() {
        if (this.nodeGroups == null) {
            ArrayList<Object> things = new ArrayList<Object>();
            Iterator<Comparable<ArcProto>> it = this.getArcs();
            while (it.hasNext()) {
                ArcProto ap = it.next();
                if (ap.isNotUsed()) continue;
                things.add(ap);
            }
            it = this.getNodes();
            while (it.hasNext()) {
                PrimitiveNode np = (PrimitiveNode)it.next();
                if (np.isNotUsed() || np.getFunction() == PrimitiveNode.Function.NODE) continue;
                things.add(np);
            }
            things.add("Pure");
            things.add("Misc.");
            things.add("Cell");
            int columns = (things.size() + 13) / 14;
            int rows = (things.size() + columns - 1) / columns;
            this.nodeGroups = new Object[rows][columns];
            int rowPos = 0;
            int colPos = 0;
            for (Object e : things) {
                this.nodeGroups[rowPos][colPos] = e;
                if (++rowPos < rows) continue;
                rowPos = 0;
                ++colPos;
            }
        }
        ArrayList<Object[]> list = new ArrayList<Object[]>(this.nodeGroups.length);
        for (int i = 0; i < this.nodeGroups.length; ++i) {
            Object[] objs = this.nodeGroups[i];
            if (objs == null) continue;
            Object obj = objs[0];
            boolean valid = true;
            if (obj instanceof ArcProto) {
                ArcProto ap = (ArcProto)obj;
                boolean bl = valid = !ap.isNotUsed();
            }
            if (!valid) continue;
            list.add(objs);
        }
        Object[][] newMatrix = new Object[list.size()][this.nodeGroups[0].length];
        for (int i = 0; i < list.size(); ++i) {
            Object[] objs = (Object[])list.get(i);
            for (int j = 0; j < objs.length; ++j) {
                NodeInst ni;
                List list2;
                Object o;
                Object obj = objs[j];
                if (obj instanceof PrimitiveNode && ((PrimitiveNode)obj).isNotUsed()) {
                    obj = null;
                } else if (obj instanceof List && (o = (list2 = (List)obj).get(0)) instanceof NodeInst && !(ni = (NodeInst)o).isCellInstance() && ((PrimitiveNode)ni.getProto()).isNotUsed()) {
                    obj = null;
                }
                newMatrix[i][j] = obj;
            }
        }
        return newMatrix;
    }

    public static NodeInst makeNodeInst(NodeProto np, PrimitiveNode.Function func, int angle, boolean display, String varName, double fontSize) {
        SizeOffset so = np.getProtoSizeOffset();
        Point2D.Double pt = new Point2D.Double((so.getHighXOffset() - so.getLowXOffset()) / 2.0, (so.getHighYOffset() - so.getLowYOffset()) / 2.0);
        Orientation orient = Orientation.fromAngle(angle);
        AffineTransform trans = orient.pureRotate();
        trans.transform(pt, pt);
        NodeInst ni = NodeInst.makeDummyInstance(np, pt, np.getDefWidth(), np.getDefHeight(), orient);
        np.getTechnology().setPrimitiveFunction(ni, func);
        np.getTechnology().setDefaultOutline(ni);
        if (varName != null) {
            ni.newVar(TECH_TMPVAR, (Object)varName, TextDescriptor.getNodeTextDescriptor().withDisplay(display).withRelSize(fontSize).withOff(0.0, -6.0));
        }
        return ni;
    }

    public double[] getSpacingDistances(Poly poly1, Poly poly2) {
        double size1 = poly1.getMinSize();
        double size2 = poly1.getMinSize();
        double length = 0.0;
        double wideS = size1 > size2 ? size1 : size2;
        double[] results = new double[]{wideS, length};
        return results;
    }

    public DRCRules getCachedRules() {
        return this.cachedRules;
    }

    public void setCachedRules(DRCRules rules) {
        this.cachedRules = rules;
    }

    public boolean polyCoverByAnyVTLayer(Cell cell, DRCTemplate theRule, Technology tech, Poly[] polys, Layer[] layers, Geometric[] geoms, boolean ignoreCenterCuts) {
        return false;
    }

    public ProjSettingsNode getProjectSettings() {
        ProjSettingsNode node = ProjSettings.getSettings().getNode(this.getTechName());
        if (node == null) {
            node = new ProjSettingsNode();
            ProjSettings.getSettings().putNode(this.getTechName(), node);
        }
        return node;
    }

    static {
        diffLayers.add(Layer.Function.DIFFP);
        diffLayers.add(Layer.Function.DIFFN);
        nullPrimLayers = new NodeLayer[0];
        TECH_TMPVAR = Variable.newKey("TECH_TMPVAR");
    }

    public static class TechPref
    extends Pref {
        private Technology tech;

        private TechPref(Technology tech, String location, String description, String name) {
            super(prefs, name);
            this.tech = tech;
            this.attachToObject(tech, location, description);
        }

        protected void setSideEffect() {
            TechPref.technologyChanged(this.tech, true);
        }

        private static void reloadUIData() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    User.technologyChanged();
                    UserInterface ui = Job.getUserInterface();
                    ui.loadComponentMenuForTechnology();
                    ui.repaintAllEditWindows();
                }
            });
        }

        public static void allTechnologiesChanged() {
            Iterator<Technology> it = Technology.getTechnologies();
            while (it.hasNext()) {
                Technology tech = it.next();
                tech.setState(true);
            }
            TechPref.reloadUIData();
        }

        public static void technologyChanged(Technology tech, boolean resizeNodes) {
            tech.setState(resizeNodes);
            TechPref.reloadUIData();
        }

        public static Pref makeBooleanSetting(Technology tech, String name, String location, String description, ProjSettingsNode xmlNode, String xmlName, boolean factory) {
            TechPref pref = new TechPref(tech, location, description, name);
            pref.initBoolean(factory);
            pref.linkProjectSettings(xmlNode, name, xmlName);
            return pref;
        }

        public static Pref makeIntSetting(Technology tech, String name, String location, String description, ProjSettingsNode xmlNode, String xmlName, int factory) {
            TechPref pref = new TechPref(tech, location, description, name);
            pref.initInt(factory);
            pref.linkProjectSettings(xmlNode, name, xmlName);
            return pref;
        }

        public static Pref makeStringSetting(Technology tech, String name, String location, String description, ProjSettingsNode xmlNode, String xmlName, String factory) {
            TechPref pref = new TechPref(tech, location, description, name);
            pref.initString(factory);
            pref.linkProjectSettings(xmlNode, name, xmlName);
            return pref;
        }
    }

    private static class SerpentineTrans {
        private ImmutableNodeInst theNode;
        private PrimitiveNode theProto;
        private int layersTotal;
        private int numSegments;
        private double extraScale;
        private NodeLayer[] primLayers;
        private Point2D[] points;
        private double[] specialValues;
        private static final int LEFTANGLE = 900;
        private static final int RIGHTANGLE = 2700;

        public SerpentineTrans(ImmutableNodeInst niD) {
            this.theNode = niD;
            this.layersTotal = 0;
            this.points = niD.getTrace();
            if (this.points != null && this.points.length < 2) {
                this.points = null;
            }
            if (this.points != null) {
                this.theProto = (PrimitiveNode)niD.protoId;
                this.specialValues = this.theProto.getSpecialValues();
                this.primLayers = this.theProto.getLayers();
                int count = this.primLayers.length;
                this.numSegments = this.points.length - 1;
                this.layersTotal = count * this.numSegments;
                this.extraScale = 0.0;
                double length = niD.getSerpentineTransistorLength();
                if (length > 0.0) {
                    this.extraScale = (length - this.specialValues[3]) / 2.0;
                }
            }
        }

        public boolean hasValidData() {
            return this.points != null;
        }

        private Poly fillTransPoly(int box, boolean electrical) {
            int portIndex;
            Point2D otherPt;
            int otherang;
            int ang;
            int segment = box % this.numSegments;
            int element = box / this.numSegments;
            double lwid = this.primLayers[element].getSerpentineLWidth();
            double rwid = this.primLayers[element].getSerpentineRWidth();
            double extendt = this.primLayers[element].getSerpentineExtentT();
            double extendb = this.primLayers[element].getSerpentineExtentB();
            lwid += this.extraScale;
            rwid += this.extraScale;
            double xoff = this.theNode.anchor.getX();
            double yoff = this.theNode.anchor.getY();
            int thissg = segment;
            int next = segment + 1;
            Point2D thisPt = this.points[thissg];
            Point2D nextPt = this.points[next];
            int angle = DBMath.figureAngle(thisPt, nextPt);
            if (thissg == 0) {
                ang = angle + 1800;
                thisPt = DBMath.addPoints(thisPt, DBMath.cos(ang) * extendt, DBMath.sin(ang) * extendt);
            }
            if (next == this.numSegments) {
                nextPt = DBMath.addPoints(nextPt, DBMath.cos(angle) * extendb, DBMath.sin(angle) * extendb);
            }
            ang = angle + 900;
            double sin = DBMath.sin(ang) * lwid;
            double cos = DBMath.cos(ang) * lwid;
            Point2D thisL = DBMath.addPoints(thisPt, cos, sin);
            Point2D nextL = DBMath.addPoints(nextPt, cos, sin);
            ang = angle + 2700;
            sin = DBMath.sin(ang) * rwid;
            cos = DBMath.cos(ang) * rwid;
            Point2D thisR = DBMath.addPoints(thisPt, cos, sin);
            Point2D nextR = DBMath.addPoints(nextPt, cos, sin);
            if (thissg != 0 && (otherang = DBMath.figureAngle(otherPt = this.points[thissg - 1], thisPt)) != angle) {
                ang = otherang + 900;
                thisL = DBMath.intersect(DBMath.addPoints(thisPt, DBMath.cos(ang) * lwid, DBMath.sin(ang) * lwid), otherang, thisL, angle);
                ang = otherang + 2700;
                thisR = DBMath.intersect(DBMath.addPoints(thisPt, DBMath.cos(ang) * rwid, DBMath.sin(ang) * rwid), otherang, thisR, angle);
            }
            if (next != this.numSegments && (otherang = DBMath.figureAngle(nextPt, otherPt = this.points[next + 1])) != angle) {
                ang = otherang + 900;
                Point2D newPtL = DBMath.addPoints(nextPt, DBMath.cos(ang) * lwid, DBMath.sin(ang) * lwid);
                nextL = DBMath.intersect(newPtL, otherang, nextL, angle);
                ang = otherang + 2700;
                Point2D newPtR = DBMath.addPoints(nextPt, DBMath.cos(ang) * rwid, DBMath.sin(ang) * rwid);
                nextR = DBMath.intersect(newPtR, otherang, nextR, angle);
            }
            Point2D[] points = new Point2D.Double[]{DBMath.addPoints(thisL, xoff, yoff), DBMath.addPoints(thisR, xoff, yoff), DBMath.addPoints(nextR, xoff, yoff), DBMath.addPoints(nextL, xoff, yoff)};
            Poly retPoly = new Poly(points);
            NodeLayer primLayer = this.primLayers[element];
            retPoly.setStyle(primLayer.getStyle());
            retPoly.setLayer(primLayer.getLayer());
            if (electrical && (portIndex = primLayer.getPortNum()) >= 0) {
                PrimitiveNode np = (PrimitiveNode)this.theNode.protoId;
                PrimitivePort port = np.getPort(portIndex);
                retPoly.setPort(port);
            }
            return retPoly;
        }

        private Poly fillTransPort(PortProto pp) {
            Point2D.Double nextPt;
            Point2D.Double thisPt;
            PortProto lpp;
            double diffInset = this.specialValues[1];
            double diffExtend = this.specialValues[2];
            double defWid = this.specialValues[3] + this.extraScale;
            double polyInset = this.specialValues[4];
            double polyExtend = this.specialValues[5];
            double xOff = this.theNode.anchor.getX();
            double yOff = this.theNode.anchor.getY();
            int total = this.points.length;
            AffineTransform trans = this.theNode.orient.rotateAbout(this.theNode.anchor.getX(), this.theNode.anchor.getY());
            int which = 0;
            Iterator<PortProto> it = this.theProto.getPorts();
            while (it.hasNext() && (lpp = it.next()) != pp) {
                ++which;
            }
            if (which == 0) {
                thisPt = new Point2D.Double(this.points[0].getX(), this.points[0].getY());
                nextPt = new Point2D.Double(this.points[1].getX(), this.points[1].getY());
                int angle = DBMath.figureAngle(thisPt, nextPt);
                int ang = (angle + 1800) % 3600;
                ((Point2D)thisPt).setLocation(((Point2D)thisPt).getX() + DBMath.cos(ang) * polyExtend + xOff, ((Point2D)thisPt).getY() + DBMath.sin(ang) * polyExtend + yOff);
                ang = (angle + 900) % 3600;
                Point2D.Double end1 = new Point2D.Double(((Point2D)thisPt).getX() + DBMath.cos(ang) * (defWid / 2.0 - polyInset), ((Point2D)thisPt).getY() + DBMath.sin(ang) * (defWid / 2.0 - polyInset));
                ang = (angle + 2700) % 3600;
                Point2D.Double end2 = new Point2D.Double(((Point2D)thisPt).getX() + DBMath.cos(ang) * (defWid / 2.0 - polyInset), ((Point2D)thisPt).getY() + DBMath.sin(ang) * (defWid / 2.0 - polyInset));
                Point2D[] portPoints = new Point2D.Double[]{end1, end2};
                trans.transform(portPoints, 0, portPoints, 0, 2);
                Poly retPoly = new Poly(portPoints);
                retPoly.setStyle(Poly.Type.OPENED);
                return retPoly;
            }
            if (which == 2) {
                thisPt = new Point2D.Double(this.points[total - 1].getX(), this.points[total - 1].getY());
                nextPt = new Point2D.Double(this.points[total - 2].getX(), this.points[total - 2].getY());
                int angle = DBMath.figureAngle(thisPt, nextPt);
                int ang = (angle + 1800) % 3600;
                ((Point2D)thisPt).setLocation(((Point2D)thisPt).getX() + DBMath.cos(ang) * polyExtend + xOff, ((Point2D)thisPt).getY() + DBMath.sin(ang) * polyExtend + yOff);
                ang = (angle + 900) % 3600;
                Point2D.Double end1 = new Point2D.Double(((Point2D)thisPt).getX() + DBMath.cos(ang) * (defWid / 2.0 - polyInset), ((Point2D)thisPt).getY() + DBMath.sin(ang) * (defWid / 2.0 - polyInset));
                ang = (angle + 2700) % 3600;
                Point2D.Double end2 = new Point2D.Double(((Point2D)thisPt).getX() + DBMath.cos(ang) * (defWid / 2.0 - polyInset), ((Point2D)thisPt).getY() + DBMath.sin(ang) * (defWid / 2.0 - polyInset));
                Point2D[] portPoints = new Point2D.Double[]{end1, end2};
                trans.transform(portPoints, 0, portPoints, 0, 2);
                Poly retPoly = new Poly(portPoints);
                retPoly.setStyle(Poly.Type.OPENED);
                return retPoly;
            }
            if (which == 3) {
                diffExtend = -diffExtend;
                defWid = -defWid;
            }
            if (which == 4) {
                defWid = 0.0;
                diffExtend = 0.0;
            }
            Point2D[] portPoints = new Point2D.Double[total];
            Point2D.Double lastPoint = null;
            int lastAngle = 0;
            for (int nextIndex = 1; nextIndex < total; ++nextIndex) {
                int thisIndex = nextIndex - 1;
                Point2D thisPt2 = new Point2D.Double(this.points[thisIndex].getX() + xOff, this.points[thisIndex].getY() + yOff);
                Point2D.Double nextPt2 = new Point2D.Double(this.points[nextIndex].getX() + xOff, this.points[nextIndex].getY() + yOff);
                int angle = DBMath.figureAngle(thisPt2, nextPt2);
                if (thisIndex == 0) {
                    ((Point2D)thisPt2).setLocation(((Point2D)thisPt2).getX() + DBMath.cos(angle) * diffInset, ((Point2D)thisPt2).getY() + DBMath.sin(angle) * diffInset);
                }
                if (nextIndex == total - 1) {
                    int backAng = (angle + 1800) % 3600;
                    ((Point2D)nextPt2).setLocation(((Point2D)nextPt2).getX() + DBMath.cos(backAng) * diffInset, ((Point2D)nextPt2).getY() + DBMath.sin(backAng) * diffInset);
                }
                int ang = (angle + 900) % 3600;
                double sine = DBMath.sin(ang);
                double cosine = DBMath.cos(ang);
                ((Point2D)thisPt2).setLocation(((Point2D)thisPt2).getX() + cosine * (defWid / 2.0 + diffExtend), ((Point2D)thisPt2).getY() + sine * (defWid / 2.0 + diffExtend));
                ((Point2D)nextPt2).setLocation(((Point2D)nextPt2).getX() + cosine * (defWid / 2.0 + diffExtend), ((Point2D)nextPt2).getY() + sine * (defWid / 2.0 + diffExtend));
                if (thisIndex != 0) {
                    thisPt2 = DBMath.intersect(lastPoint, lastAngle, thisPt2, angle);
                }
                portPoints[thisIndex] = thisPt2;
                lastPoint = thisPt2;
                lastAngle = angle;
                if (nextIndex != total - 1) continue;
                portPoints[nextIndex] = nextPt2;
            }
            if (total > 0) {
                trans.transform(portPoints, 0, portPoints, 0, total);
            }
            Poly retPoly = new Poly(portPoints);
            retPoly.setStyle(Poly.Type.OPENED);
            return retPoly;
        }
    }

    public static class MultiCutData {
        private double cutSizeX;
        private double cutSizeY;
        private double cutSep;
        private double cutSep1D;
        private double cutSep2D;
        private double cutIndentX;
        private double cutIndentY;
        private int cutsX;
        private int cutsY;
        private int cutsTotal;
        private int cutsReasonable;
        private double cutBaseX;
        private double cutBaseY;
        private double cutTopEdge;
        private double cutLeftEdge;
        private double cutRightEdge;

        private void calcultateInternalData(double xSize, double ySize, double anchorCenterX, double anchorCenterY, double cutLX, double cutHX, double cutLY, double cutHY, double[] specialValues) {
            this.cutSizeX = specialValues[0];
            this.cutSizeY = specialValues[1];
            this.cutIndentX = specialValues[2];
            this.cutIndentY = specialValues[3];
            this.cutSep1D = specialValues[4];
            this.cutSep2D = specialValues[5];
            double cutAreaWidth = xSize - cutLX - cutHX;
            double cutAreaHeight = ySize - cutLY - cutHY;
            int oneDcutsX = (int)(DBMath.round(cutAreaWidth - this.cutIndentX * 2.0 + this.cutSep1D) / (this.cutSizeX + this.cutSep1D));
            int oneDcutsY = (int)DBMath.round((cutAreaHeight - this.cutIndentY * 2.0 + this.cutSep1D) / (this.cutSizeY + this.cutSep1D));
            int twoDcutsX = (int)(DBMath.round(cutAreaWidth - this.cutIndentX * 2.0 + this.cutSep2D) / (this.cutSizeX + this.cutSep2D));
            int twoDcutsY = (int)(DBMath.round(cutAreaHeight - this.cutIndentY * 2.0 + this.cutSep2D) / (this.cutSizeY + this.cutSep2D));
            this.cutSep = this.cutSep1D;
            this.cutsX = oneDcutsX;
            this.cutsY = oneDcutsY;
            if (this.cutsX > 1 && this.cutsY > 1) {
                this.cutSep = this.cutSep2D;
                this.cutsX = twoDcutsX;
                this.cutsY = twoDcutsY;
                if (this.cutsX == 1 || this.cutsY == 1) {
                    this.cutSep = this.cutSep1D;
                    if (cutAreaWidth > cutAreaHeight) {
                        this.cutsX = oneDcutsX;
                    } else {
                        this.cutsY = oneDcutsY;
                    }
                }
            }
            if (this.cutsX <= 0) {
                this.cutsX = 1;
            }
            if (this.cutsY <= 0) {
                this.cutsY = 1;
            }
            this.cutsReasonable = this.cutsTotal = this.cutsX * this.cutsY;
            if (this.cutsTotal != 1) {
                this.cutBaseX = (cutAreaWidth - this.cutIndentX * 2.0 - this.cutSizeX * (double)this.cutsX - this.cutSep * (double)(this.cutsX - 1)) / 2.0 + (cutLX + this.cutIndentX + this.cutSizeX / 2.0) + anchorCenterX - xSize / 2.0;
                this.cutBaseY = (cutAreaHeight - this.cutIndentY * 2.0 - this.cutSizeY * (double)this.cutsY - this.cutSep * (double)(this.cutsY - 1)) / 2.0 + (cutLY + this.cutIndentY + this.cutSizeY / 2.0) + anchorCenterY - ySize / 2.0;
                if (this.cutsX > 2 && this.cutsY > 2) {
                    this.cutsReasonable = this.cutsX * 2 + (this.cutsY - 2) * 2;
                    this.cutTopEdge = this.cutsX * 2;
                    this.cutLeftEdge = this.cutsX * 2 + this.cutsY - 2;
                    this.cutRightEdge = this.cutsX * 2 + (this.cutsY - 2) * 2;
                }
            }
        }

        public MultiCutData(double xSize, double ySize, double anchorCenterX, double anchorCenterY, double cutLX, double cutHX, double cutLY, double cutHY, double[] specialValues) {
            this.calcultateInternalData(xSize, ySize, anchorCenterX, anchorCenterY, cutLX, cutHX, cutLY, cutHY, specialValues);
        }

        public MultiCutData(ImmutableNodeInst niD, double[] specialValues) {
            PrimitiveNode pn = (PrimitiveNode)niD.protoId;
            SizeOffset so = pn.getProtoSizeOffset();
            this.calcultateInternalData(niD.width, niD.height, niD.anchor.getX(), niD.anchor.getY(), so.getLowXOffset(), so.getHighXOffset(), so.getLowYOffset(), so.getHighYOffset(), specialValues);
        }

        public int numCuts() {
            return this.cutsTotal;
        }

        public int numCutsX() {
            return this.cutsX;
        }

        public int numCutsY() {
            return this.cutsY;
        }

        public double getCutSizeX() {
            return this.cutSizeX;
        }

        public double getCutSizeY() {
            return this.cutSizeY;
        }

        protected Poly fillCutPoly(ImmutableNodeInst ni, int cut) {
            return this.fillCutPoly(ni.anchor.getX(), ni.anchor.getY(), cut);
        }

        public Poly fillCutPoly(double anchorX, double anchorY, int cut) {
            if (this.cutsX > 2 && this.cutsY > 2 && cut >= this.cutsX) {
                if ((double)cut < this.cutTopEdge) {
                    cut += this.cutsX * (this.cutsY - 2);
                } else if ((double)cut < this.cutLeftEdge) {
                    cut = (int)(((double)cut - this.cutTopEdge) * (double)this.cutsX + (double)this.cutsX);
                } else if ((double)cut < this.cutRightEdge) {
                    cut = (int)(((double)cut - this.cutLeftEdge) * (double)this.cutsX + (double)(this.cutsX * 2) - 1.0);
                } else {
                    int cutx = (cut -= (int)this.cutRightEdge) % (this.cutsX - 2);
                    int cuty = cut / (this.cutsX - 2);
                    cut = cuty * this.cutsX + cutx + this.cutsX + 1;
                }
            }
            double cX = this.cutsX == 1 ? anchorX : this.cutBaseX + (double)(cut % this.cutsX) * (this.cutSizeX + this.cutSep);
            double cY = this.cutsY == 1 ? anchorY : this.cutBaseY + (double)(cut / this.cutsX) * (this.cutSizeY + this.cutSep);
            return new Poly(cX, cY, this.cutSizeX, this.cutSizeY);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LayerHeight
    implements Comparator<Layer> {
        final boolean liftContacts;

        private LayerHeight(boolean liftContacts) {
            this.liftContacts = liftContacts;
        }

        @Override
        public int compare(Layer l1, Layer l2) {
            Technology tech2;
            int cmp;
            Layer.Function f1 = l1.getFunction();
            Layer.Function f2 = l2.getFunction();
            int h1 = f1.getHeight();
            int h2 = f2.getHeight();
            if (this.liftContacts) {
                if (f1.isContact()) {
                    ++h1;
                } else if (f1.isMetal()) {
                    --h1;
                }
                if (f2.isContact()) {
                    ++h2;
                } else if (f2.isMetal()) {
                    --h2;
                }
            }
            if ((cmp = h1 - h2) != 0) {
                return cmp;
            }
            Technology tech1 = l1.getTechnology();
            if (tech1 != (tech2 = l2.getTechnology())) {
                int techIndex1 = tech1 != null ? tech1.getIndex() : -1;
                int techIndex2 = tech2 != null ? tech2.getIndex() : -1;
                return techIndex1 - techIndex2;
            }
            return l1.getIndex() - l2.getIndex();
        }
    }

    public static class NodeLayer {
        private Layer layer;
        private int portNum;
        private Poly.Type style;
        private int representation;
        private TechPoint[] points;
        private String message;
        private TextDescriptor descriptor;
        private double lWidth;
        private double rWidth;
        private double extentT;
        private double extendB;
        public static final int POINTS = 0;
        public static final int BOX = 1;
        public static final int MINBOX = 2;

        public NodeLayer(Layer layer, int portNum, Poly.Type style, int representation, TechPoint[] points) {
            this.layer = layer;
            this.portNum = portNum;
            this.style = style;
            this.representation = representation;
            this.points = points;
            this.descriptor = TextDescriptor.EMPTY;
            layer.getTechnology().addNodeLayer(this);
            this.extendB = 0.0;
            this.extentT = 0.0;
            this.rWidth = 0.0;
            this.lWidth = 0.0;
        }

        public NodeLayer(Layer layer, int portNum, Poly.Type style, int representation, TechPoint[] points, double lWidth, double rWidth, double extentT, double extendB) {
            this.layer = layer;
            this.portNum = portNum;
            this.style = style;
            this.representation = representation;
            this.points = points;
            this.descriptor = TextDescriptor.EMPTY;
            layer.getTechnology().addNodeLayer(this);
            this.lWidth = lWidth;
            this.rWidth = rWidth;
            this.extentT = extentT;
            this.extendB = extendB;
        }

        public NodeLayer(NodeLayer node) {
            this.layer = node.getLayer();
            this.portNum = node.getPortNum();
            this.style = node.getStyle();
            this.representation = node.getRepresentation();
            this.descriptor = TextDescriptor.EMPTY;
            this.layer.getTechnology().addNodeLayer(this);
            TechPoint[] oldPoints = node.getPoints();
            this.points = new TechPoint[oldPoints.length];
            for (int i = 0; i < oldPoints.length; ++i) {
                this.points[i] = oldPoints[i].duplicate();
            }
            this.extendB = 0.0;
            this.extentT = 0.0;
            this.rWidth = 0.0;
            this.lWidth = 0.0;
        }

        public Layer getLayer() {
            return this.layer;
        }

        public int getPortNum() {
            return this.portNum;
        }

        public Poly.Type getStyle() {
            return this.style;
        }

        public int getRepresentation() {
            return this.representation;
        }

        public TechPoint[] getPoints() {
            return this.points;
        }

        public void setPoints(TechPoint[] pts) {
            this.points = pts;
        }

        public EdgeH getLeftEdge() {
            return this.points[0].getX();
        }

        public EdgeV getBottomEdge() {
            return this.points[0].getY();
        }

        public EdgeH getRightEdge() {
            return this.points[1].getX();
        }

        public EdgeV getTopEdge() {
            return this.points[1].getY();
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public TextDescriptor getDescriptor() {
            return this.descriptor;
        }

        public void setDescriptor(TextDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public double getSerpentineLWidth() {
            return this.lWidth;
        }

        public void setSerpentineLWidth(double lWidth) {
            this.lWidth = lWidth;
        }

        public double getSerpentineRWidth() {
            return this.rWidth;
        }

        public void setSerpentineRWidth(double rWidth) {
            this.rWidth = rWidth;
        }

        public double getSerpentineExtentT() {
            return this.extentT;
        }

        public void setSerpentineExtentT(double extentT) {
            this.extentT = extentT;
        }

        public double getSerpentineExtentB() {
            return this.extendB;
        }

        public void setSerpentineExtentB(double extendB) {
            this.extendB = extendB;
        }
    }

    public static class TechPoint {
        private EdgeH x;
        private EdgeV y;

        public TechPoint(EdgeH x, EdgeV y) {
            this.x = x;
            this.y = y;
        }

        public TechPoint duplicate() {
            TechPoint newTP = new TechPoint(new EdgeH(this.x.getMultiplier(), this.x.getAdder()), new EdgeV(this.y.getMultiplier(), this.y.getAdder()));
            return newTP;
        }

        public static TechPoint[] makeCenterBox() {
            return new TechPoint[]{new TechPoint(EdgeH.fromCenter(0.0), EdgeV.fromCenter(0.0)), new TechPoint(EdgeH.fromCenter(0.0), EdgeV.fromCenter(0.0))};
        }

        public static TechPoint[] makeFullBox() {
            return TechPoint.makeIndented(0.0);
        }

        public static TechPoint[] makeIndented(double amount) {
            return new TechPoint[]{new TechPoint(EdgeH.fromLeft(amount), EdgeV.fromBottom(amount)), new TechPoint(EdgeH.fromRight(amount), EdgeV.fromTop(amount))};
        }

        public EdgeH getX() {
            return this.x;
        }

        public EdgeV getY() {
            return this.y;
        }
    }

    public static class ArcLayer {
        private Layer layer;
        private double offset;
        private Poly.Type style;

        public ArcLayer(Layer layer, double offset, Poly.Type style) {
            this.layer = layer;
            this.offset = offset;
            this.style = style;
        }

        public Layer getLayer() {
            return this.layer;
        }

        public double getOffset() {
            return this.offset;
        }

        public void setOffset(double offset) {
            this.offset = offset;
        }

        public Poly.Type getStyle() {
            return this.style;
        }
    }
}

