/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.user.HighlightArea;
import com.sun.electric.tool.user.HighlightLine;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Highlight2
implements Cloneable {
    public static final BasicStroke solidLine = new BasicStroke(0.0f);
    public static final BasicStroke dottedLine = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f}, 0.0f);
    public static final BasicStroke dashedLine = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{10.0f}, 0.0f);
    public static final BasicStroke boldLine = new BasicStroke(3.0f);
    protected Cell cell;
    private static final int CROSSSIZE = 3;

    Highlight2(Cell c) {
        this.cell = c;
    }

    public Cell getCell() {
        return this.cell;
    }

    boolean isValid() {
        return this.cell == null || this.cell.isLinked();
    }

    public boolean isHighlightEOBJ() {
        return false;
    }

    public boolean isHighlightText() {
        return false;
    }

    public Object getObject() {
        return null;
    }

    public Variable.Key getVarKey() {
        return null;
    }

    public void setPoint(int p) {
    }

    public int getPoint() {
        return -1;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    boolean sameThing(Highlight2 obj) {
        return false;
    }

    public boolean nodeMovesWithText() {
        return false;
    }

    public void showHighlight(EditWindow wnd, Graphics g, int highOffX, int highOffY, boolean onlyHighlight, Color mainColor, Stroke primaryStroke, boolean setConnected) {
        if (!this.isValid()) {
            return;
        }
        g.setColor(mainColor);
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(primaryStroke);
        this.showInternalHighlight(wnd, g, highOffX, highOffY, onlyHighlight, setConnected);
    }

    abstract void showInternalHighlight(EditWindow var1, Graphics var2, int var3, int var4, boolean var5, boolean var6);

    void getHighlightedEObjs(Highlighter highlighter, List<Geometric> list, boolean wantNodes, boolean wantArcs) {
    }

    static void getHighlightedEObjsInternal(Geometric geom, List<Geometric> list, boolean wantNodes, boolean wantArcs) {
        if (geom == null) {
            return;
        }
        if (!wantNodes && geom instanceof NodeInst) {
            return;
        }
        if (!wantArcs && geom instanceof ArcInst) {
            return;
        }
        if (list.contains(geom)) {
            return;
        }
        list.add(geom);
    }

    public Geometric getGeometric() {
        return null;
    }

    void getHighlightedNodes(Highlighter highlighter, List<NodeInst> list) {
    }

    static void getHighlightedNodesInternal(Geometric geom, List<NodeInst> list) {
        if (geom == null || !(geom instanceof NodeInst)) {
            return;
        }
        NodeInst ni = (NodeInst)geom;
        if (list.contains(ni)) {
            return;
        }
        list.add(ni);
    }

    void getHighlightedArcs(Highlighter highlighter, List<ArcInst> list) {
    }

    static void getHighlightedArcsInternal(Geometric geom, List<ArcInst> list) {
        if (geom == null || !(geom instanceof ArcInst)) {
            return;
        }
        ArcInst ai = (ArcInst)geom;
        if (list.contains(ai)) {
            return;
        }
        list.add(ai);
    }

    void getHighlightedNetworks(Set<Network> nets, Netlist netlist) {
    }

    void getHighlightedText(List<DisplayedText> list, boolean unique, List<Highlight2> getHighlights) {
    }

    Rectangle2D getHighlightedArea(EditWindow wnd) {
        return null;
    }

    public ElectricObject getElectricObject() {
        return null;
    }

    boolean overHighlighted(EditWindow wnd, int x, int y, Highlighter highlighter) {
        return false;
    }

    public String getInfo() {
        return null;
    }

    public static NodeInst getInfoCommand(List<Highlight2> list, int[] counts) {
        NodeInst theNode = null;
        for (Highlight2 h : list) {
            ElectricObject eobj = h.getElectricObject();
            if (h.isHighlightEOBJ()) {
                if (eobj instanceof NodeInst || eobj instanceof PortInst) {
                    counts[1] = counts[1] + 1;
                    if (eobj instanceof NodeInst) {
                        theNode = (NodeInst)eobj;
                        continue;
                    }
                    theNode = ((PortInst)eobj).getNodeInst();
                    continue;
                }
                if (!(eobj instanceof ArcInst)) continue;
                counts[0] = counts[0] + 1;
                continue;
            }
            if (h.isHighlightText()) {
                if (h.getVarKey() == Export.EXPORT_NAME) {
                    counts[2] = counts[2] + 1;
                    continue;
                }
                if (h.getElectricObject() instanceof NodeInst) {
                    theNode = (NodeInst)h.getElectricObject();
                }
                counts[3] = counts[3] + 1;
                continue;
            }
            if (h instanceof HighlightArea) {
                counts[4] = counts[4] + 1;
                continue;
            }
            if (!(h instanceof HighlightLine)) continue;
            counts[4] = counts[4] + 1;
        }
        return theNode;
    }

    public static void drawOutlineFromPoints(EditWindow wnd, Graphics g, Point2D[] points, int offX, int offY, boolean opened, boolean thickLine) {
        boolean onePoint = true;
        if (points.length <= 0) {
            return;
        }
        Point firstP = wnd.databaseToScreen(points[0].getX(), points[0].getY());
        for (int i = 1; i < points.length; ++i) {
            Point p = wnd.databaseToScreen(points[i].getX(), points[i].getY());
            if (DBMath.doublesEqual(p.getX(), firstP.getX()) && DBMath.doublesEqual(p.getY(), firstP.getY())) continue;
            onePoint = false;
            break;
        }
        if (onePoint) {
            Highlight2.drawLine(g, wnd, firstP.x + offX - 3, firstP.y + offY, firstP.x + offX + 3, firstP.y + offY);
            Highlight2.drawLine(g, wnd, firstP.x + offX, firstP.y + offY - 3, firstP.x + offX, firstP.y + offY + 3);
            return;
        }
        int cX = 0;
        int cY = 0;
        for (int i = 0; i < points.length; ++i) {
            int lastI = i - 1;
            if (lastI < 0) {
                if (opened) continue;
                lastI = points.length - 1;
            }
            Point lp = wnd.databaseToScreen(points[lastI].getX(), points[lastI].getY());
            Point p = wnd.databaseToScreen(points[i].getX(), points[i].getY());
            int fX = lp.x + offX;
            int fY = lp.y + offY;
            int tX = p.x + offX;
            int tY = p.y + offY;
            Highlight2.drawLine(g, wnd, fX, fY, tX, tY);
            if (!thickLine) continue;
            fX = fX < cX ? --fX : ++fX;
            fY = fY < cY ? --fY : ++fY;
            tX = tX < cX ? --tX : ++tX;
            tY = tY < cY ? --tY : ++tY;
            Highlight2.drawLine(g, wnd, fX, fY, tX, tY);
        }
    }

    void internalDescribe(StringBuffer desc) {
    }

    public String describe() {
        StringBuffer desc = new StringBuffer();
        desc.append(this.getClass().getName());
        if (this.cell != null) {
            desc.append(" in ");
            desc.append(this.cell);
        }
        desc.append(": ");
        this.internalDescribe(desc);
        return desc.toString();
    }

    public static Poly getNodeInstOutline(NodeInst ni) {
        AffineTransform trans = ni.rotateOutAboutTrueCenter();
        Poly poly = null;
        if (!ni.isCellInstance()) {
            double[] angles;
            Point2D[] outline;
            PrimitiveNode pn = (PrimitiveNode)ni.getProto();
            if (pn.isHoldsOutline() && (outline = ni.getTrace()) != null) {
                int numPoints = outline.length;
                Point2D[] pointList = new Point2D.Double[numPoints];
                for (int i = 0; i < numPoints; ++i) {
                    pointList[i] = new Point2D.Double(ni.getAnchorCenterX() + outline[i].getX(), ni.getAnchorCenterY() + outline[i].getY());
                }
                trans.transform(pointList, 0, pointList, 0, numPoints);
                poly = new Poly(pointList);
                if (ni.getFunction() == PrimitiveNode.Function.NODE) {
                    poly.setStyle(Poly.Type.FILLED);
                } else {
                    poly.setStyle(Poly.Type.OPENED);
                }
            }
            if (!(pn != Artwork.tech().circleNode && pn != Artwork.tech().thickCircleNode || (angles = ni.getArcDegrees())[0] == 0.0 && angles[1] == 0.0)) {
                Point2D[] pointList = Artwork.fillEllipse(ni.getAnchorCenter(), ni.getXSize(), ni.getYSize(), angles[0], angles[1]);
                poly = new Poly(pointList);
                poly.setStyle(Poly.Type.OPENED);
                poly.transform(ni.rotateOut());
            }
        }
        if (poly == null) {
            poly = ni.getBaseShape();
        }
        return poly;
    }

    public static void drawLine(Graphics g, EditWindow wnd, int x1, int y1, int x2, int y2) {
        Dimension size = wnd.getScreenSize();
        Point pt1 = new Point(x1, y1);
        Point pt2 = new Point(x2, y2);
        if (GenMath.clipLine(pt1, pt2, 0, size.width - 1, 0, size.height - 1)) {
            return;
        }
        g.drawLine(pt1.x, pt1.y, pt2.x, pt2.y);
    }
}

