/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.compaction;

import com.sun.electric.database.constraint.Layout;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.drc.DRC;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class Compaction
extends Tool {
    private static Compaction tool = new Compaction();
    private static int limitLoops = 10;
    private static Pref cacheAllowSpreading = Pref.makeBooleanPref("AllowSpreading", Compaction.tool.prefs, false);

    private Compaction() {
        super("compaction");
    }

    public void init() {
    }

    public static Compaction getCompactionTool() {
        return tool;
    }

    public static void compactNow() {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.getCurrentCell();
        if (cell == null) {
            return;
        }
        Compaction.compactNow(cell);
    }

    public static void compactNow(Cell cell) {
        CompactCellJob job = new CompactCellJob(cell, true, CompactCell.Axis.HORIZONTAL);
        job.startJob();
    }

    public static boolean isAllowsSpreading() {
        return cacheAllowSpreading.getBoolean();
    }

    public static void setAllowsSpreading(boolean on) {
        cacheAllowSpreading.setBoolean(on);
    }

    public static boolean isFactoryAllowsSpreading() {
        return cacheAllowSpreading.getBooleanFactoryValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompactCell {
        private static final double DEFAULT_VAL = -9.9999999E7;
        private double maxBoundary;
        private double lowBound;
        private int flatIndex;
        private Axis curAxis;
        private Cell cell;

        private CompactCell(Cell cell) {
            this.cell = cell;
        }

        private boolean compactOneDirection(Axis curAxis) {
            this.curAxis = curAxis;
            this.maxBoundary = DRC.getWorstSpacingDistance(Technology.getCurrent(), -1);
            if (curAxis == Axis.HORIZONTAL) {
                System.out.println("Compacting horizontally");
            } else {
                System.out.println("Compacting vertically");
            }
            HashMap<PortProto, Integer> portIndices = new HashMap<PortProto, Integer>();
            this.flatIndex = 1;
            Netlist nl = this.cell.acquireUserNetlist();
            if (nl == null) {
                System.out.println("Sorry, a deadlock aborted compaction (network information unavailable).  Please try again");
                return false;
            }
            Iterator<PortProto> it = this.cell.getPorts();
            while (it.hasNext()) {
                Export oPp;
                Export pp = (Export)it.next();
                Network net = nl.getNetwork(pp, 0);
                Export found = null;
                Iterator<PortProto> oIt = this.cell.getPorts();
                while (oIt.hasNext() && (oPp = (Export)oIt.next()) != pp) {
                    Network oNet = nl.getNetwork(oPp, 0);
                    if (net != oNet) continue;
                    found = oPp;
                    break;
                }
                if (found != null) {
                    Integer oIndex = portIndices.get(found);
                    portIndices.put(pp, oIndex);
                    continue;
                }
                portIndices.put(pp, new Integer(this.flatIndex++));
            }
            HashMap<ArcInst, Integer> arcIndices = this.subCellSmash(this.cell, portIndices);
            HashSet<NodeInst> nodesSeen = new HashSet<NodeInst>();
            Line lineComp = null;
            ArrayList<GeomObj> otherObjectList = new ArrayList<GeomObj>();
            Iterator<NodeInst> it2 = this.cell.getNodes();
            while (it2.hasNext()) {
                NodeInst ni = it2.next();
                if (ni.getProto() == Generic.tech().cellCenterNode || ni.getProto() == Generic.tech().essentialBoundsNode) continue;
                ArrayList<GeomObj> thisObjectList = new ArrayList<GeomObj>();
                this.createObjects(ni, thisObjectList, otherObjectList, nodesSeen, arcIndices, portIndices);
                if (thisObjectList.size() == 0) continue;
                lineComp = this.makeObjectLine(lineComp, thisObjectList);
            }
            Line lineStretch = null;
            if (otherObjectList.size() != 0) {
                lineStretch = this.makeObjectLine(null, otherObjectList);
            }
            Line curLine = lineComp;
            while (curLine != null) {
                this.computeLineHiAndLow(curLine);
                curLine = curLine.nextLine;
            }
            lineComp = this.sortLines(lineComp);
            this.lowBound = this.findLeastLow(lineComp);
            boolean change = false;
            change = this.compactLine(lineComp, lineStretch, change, this.cell);
            return change;
        }

        private boolean compactLine(Line line, Line lineStretch, boolean change, Cell cell) {
            boolean spread = Compaction.isAllowsSpreading();
            Line curLine = line.nextLine;
            while (curLine != null) {
                if (!(curLine.low <= line.low)) {
                    double bestMotion = -9.9999999E7;
                    Line prevLine = curLine.prevLine;
                    while (prevLine != null) {
                        GeomObj curObject = curLine.firstObject;
                        while (curObject != null) {
                            double thisMotion;
                            if (!(bestMotion != -9.9999999E7 && curLine.low - prevLine.high > bestMotion || (thisMotion = this.checkInst(curObject, prevLine, cell)) == -9.9999999E7 || bestMotion != -9.9999999E7 && !(thisMotion < bestMotion))) {
                                bestMotion = thisMotion;
                            }
                            curObject = curObject.nextObject;
                        }
                        prevLine = prevLine.prevLine;
                    }
                    if (bestMotion == -9.9999999E7) {
                        bestMotion = curLine.low - this.lowBound;
                    }
                    if (bestMotion > DBMath.getEpsilon() || spread && bestMotion < -DBMath.getEpsilon()) {
                        HashSet<ArcInst> clearedArcs = this.ensureSlidability(lineStretch);
                        this.setupTemporaryRigidity(line, lineStretch);
                        change = this.curAxis == Axis.HORIZONTAL ? this.moveLine(curLine, bestMotion, 0.0, change) : this.moveLine(curLine, 0.0, bestMotion, change);
                        this.restoreSlidability(clearedArcs);
                    }
                }
                curLine = curLine.nextLine;
            }
            return change;
        }

        private double checkInst(GeomObj object, Line line, Cell cell) {
            double bestMotion = -9.9999999E7;
            PolyList polys = object.firstPolyList;
            while (polys != null) {
                Poly poly = polys.poly;
                Layer layer = poly.getLayer().getNonPseudoLayer();
                double thisMotion = this.minSeparate(object, layer, polys, line, cell);
                if (thisMotion != -9.9999999E7 && (bestMotion == -9.9999999E7 || thisMotion < bestMotion)) {
                    bestMotion = thisMotion;
                }
                polys = polys.nextPolyList;
            }
            return bestMotion;
        }

        private double minSeparate(GeomObj object, Layer nLayer, PolyList nPolys, Line line, Cell cell) {
            Poly nPoly = nPolys.poly;
            Technology tech = nPolys.tech;
            int nIndex = nPolys.networkNum;
            double bound = DRC.getMaxSurround(nLayer, Double.MAX_VALUE);
            if (bound < 0.0) {
                return -9.9999999E7;
            }
            Rectangle2D nbox = nPoly.getBox();
            if (nbox == null) {
                return bound;
            }
            double bestMotion = -9.9999999E7;
            double geomLow = object.lowy;
            if (this.curAxis == Axis.HORIZONTAL) {
                geomLow = object.lowx;
            }
            GeomObj curObject = line.firstObject;
            while (curObject != null) {
                block16: {
                    if (this.curAxis == Axis.HORIZONTAL ? !this.isInBound(nbox.getMinY() - bound, nbox.getMaxY() + bound, curObject.outerLowy, curObject.outerHighy) : !this.isInBound(nbox.getMinX() - bound, nbox.getMaxX() + bound, curObject.outerLowx, curObject.outerHighx)) break block16;
                    PolyList polys = curObject.firstPolyList;
                    while (polys != null) {
                        block17: {
                            double dist;
                            Rectangle2D polyBox;
                            int pIndex;
                            Layer layer;
                            block19: {
                                boolean con;
                                block18: {
                                    double thisMotion;
                                    if (polys.tech != tech) break block17;
                                    Poly poly = polys.poly;
                                    layer = poly.getLayer().getNonPseudoLayer();
                                    pIndex = polys.networkNum;
                                    con = false;
                                    if (pIndex == nIndex && pIndex != -1) {
                                        Layer.Function nFun = nLayer.getFunction();
                                        Layer.Function fun = layer.getFunction();
                                        if (!nFun.isSubstrate() && !fun.isSubstrate()) {
                                            con = true;
                                        }
                                    }
                                    if ((polyBox = poly.getBox()) != null) break block18;
                                    double niHigh = curObject.outerHighy;
                                    if (this.curAxis == Axis.HORIZONTAL) {
                                        niHigh = curObject.outerHighx;
                                    }
                                    if ((thisMotion = geomLow - niHigh - bound) != -9.9999999E7 && (thisMotion < bestMotion || bestMotion == -9.9999999E7)) {
                                        bestMotion = thisMotion;
                                    }
                                    break block17;
                                }
                                dist = -1.0;
                                DRCTemplate rule = DRC.getSpacingRule(nLayer, null, layer, null, con, -1, 0.0, 0.0);
                                if (rule != null) {
                                    dist = rule.getValue(0);
                                }
                                if (dist < 0.0) break block17;
                                if (nLayer != layer) break block19;
                                Layer.Function fun = nLayer.getFunction();
                                if (!con ? fun.isSubstrate() : !fun.isContact()) break block17;
                            }
                            if (!(this.curAxis != Axis.HORIZONTAL ? !this.isInBound(nbox.getMinX() - dist, nbox.getMaxX() + dist, polyBox.getMinX(), polyBox.getMaxX()) : !this.isInBound(nbox.getMinY() - dist, nbox.getMaxY() + dist, polyBox.getMinY(), polyBox.getMaxY()))) {
                                double thisMotion = this.checkLayers(nLayer, nIndex, object, polyBox, layer, pIndex, curObject, nbox, dist);
                                if (thisMotion != -9.9999999E7 && (thisMotion < bestMotion || bestMotion == -9.9999999E7)) {
                                    bestMotion = thisMotion;
                                }
                            }
                        }
                        polys = polys.nextPolyList;
                    }
                }
                curObject = curObject.nextObject;
            }
            return bestMotion;
        }

        private double checkLayers(Layer layer1, int index1, GeomObj object1, Rectangle2D bound1, Layer layer2, int index2, GeomObj object2, Rectangle2D bound2, double dist) {
            if (object1.inst instanceof NodeInst && this.cropNodeInst(object1.firstPolyList, bound2, layer2, index2)) {
                return -9.9999999E7;
            }
            if (object2.inst instanceof NodeInst && this.cropNodeInst(object2.firstPolyList, bound1, layer1, index1)) {
                return -9.9999999E7;
            }
            if (this.curAxis == Axis.HORIZONTAL) {
                if (bound1.getMaxY() + dist > bound2.getMinY() && bound1.getMinY() - dist < bound2.getMaxY()) {
                    double spacing = bound2.getMinX() - bound1.getMaxX() - dist;
                    return spacing;
                }
            } else if (bound1.getMaxX() + dist > bound2.getMinX() && bound1.getMinX() - dist < bound2.getMaxX()) {
                double spacing = bound2.getMinY() - bound1.getMaxY() - dist;
                return spacing;
            }
            return -9.9999999E7;
        }

        private boolean cropNodeInst(PolyList polys, Rectangle2D bound, Layer nLayer, int nIndex) {
            PolyList curPoly = polys;
            while (curPoly != null) {
                int temp;
                Rectangle2D polyBox;
                if (curPoly.networkNum == nIndex && curPoly.poly.getLayer() == nLayer && (polyBox = curPoly.poly.getBox()) != null && (temp = Poly.cropBox(bound, polyBox)) > 0) {
                    return true;
                }
                curPoly = curPoly.nextPolyList;
            }
            return false;
        }

        private boolean isInBound(double ll, double lh, double rl, double rh) {
            return rh > ll && rl < lh;
        }

        private boolean moveLine(Line line, double moveX, double moveY, boolean change) {
            double move = moveX;
            if (moveX == 0.0) {
                move = moveY;
            }
            if (line == null) {
                return false;
            }
            if (!change && move != 0.0) {
                change = true;
            }
            GeomObj curObject = line.firstObject;
            while (curObject != null) {
                if (curObject.inst instanceof NodeInst) {
                    NodeInst ni = (NodeInst)curObject.inst;
                    ni.move(-moveX, -moveY);
                    break;
                }
                curObject = curObject.nextObject;
            }
            curObject = line.firstObject;
            while (curObject != null) {
                curObject.lowx -= moveX;
                curObject.highx -= moveX;
                curObject.lowy -= moveY;
                curObject.highy -= moveY;
                curObject.outerLowx -= moveX;
                curObject.outerHighx -= moveX;
                curObject.outerLowy -= moveY;
                curObject.outerHighy -= moveY;
                PolyList polys = curObject.firstPolyList;
                while (polys != null) {
                    Point2D[] points = polys.poly.getPoints();
                    for (int i = 0; i < points.length; ++i) {
                        polys.poly.setPoint(i, points[i].getX() - moveX, points[i].getY() - moveY);
                    }
                    polys = polys.nextPolyList;
                }
                curObject = curObject.nextObject;
            }
            line.high -= move;
            line.low -= move;
            return change;
        }

        private double findLeastLow(Line line) {
            if (line == null) {
                return 0.0;
            }
            boolean first = true;
            double low = 0.0;
            GeomObj curObject = line.firstObject;
            while (curObject != null) {
                if (curObject.inst instanceof NodeInst) {
                    double thisLow = curObject.lowy;
                    if (this.curAxis == Axis.HORIZONTAL) {
                        thisLow = curObject.lowx;
                    }
                    if (!first) {
                        low = Math.min(low, thisLow);
                    } else {
                        low = thisLow;
                        first = false;
                    }
                }
                curObject = curObject.nextObject;
            }
            line.low = low;
            return low;
        }

        private void setupTemporaryRigidity(Line fixLine, Line lineStretch) {
            GeomObj curObject;
            Line curLine = fixLine;
            while (curLine != null) {
                curObject = curLine.firstObject;
                while (curObject != null) {
                    if (!(curObject.inst instanceof NodeInst)) {
                        Layout.setTempRigid((ArcInst)curObject.inst, true);
                    }
                    curObject = curObject.nextObject;
                }
                curLine = curLine.nextLine;
            }
            curLine = lineStretch;
            while (curLine != null) {
                curObject = curLine.firstObject;
                while (curObject != null) {
                    if (!(curObject.inst instanceof NodeInst)) {
                        Layout.setTempRigid((ArcInst)curObject.inst, false);
                    }
                    curObject = curObject.nextObject;
                }
                curLine = curLine.nextLine;
            }
        }

        private HashSet<ArcInst> ensureSlidability(Line line) {
            HashSet<ArcInst> clearedArcs = new HashSet<ArcInst>();
            Line curLine = line;
            while (curLine != null) {
                GeomObj curObject = curLine.firstObject;
                while (curObject != null) {
                    ArcInst ai;
                    if (!(curObject.inst instanceof NodeInst) && (ai = (ArcInst)curObject.inst).isSlidable()) {
                        ai.setSlidable(false);
                        clearedArcs.add(ai);
                    }
                    curObject = curObject.nextObject;
                }
                curLine = curLine.nextLine;
            }
            return clearedArcs;
        }

        private void restoreSlidability(HashSet<ArcInst> clearedArcs) {
            for (ArcInst ai : clearedArcs) {
                ai.setSlidable(true);
            }
        }

        private void computeLineHiAndLow(Line line) {
            boolean first = true;
            double lx = 0.0;
            double hx = 0.0;
            double ly = 0.0;
            double hy = 0.0;
            GeomObj curObject = line.firstObject;
            while (curObject != null) {
                if (curObject.inst instanceof NodeInst) {
                    if (first) {
                        lx = curObject.outerLowx;
                        hx = curObject.outerHighx;
                        ly = curObject.outerLowy;
                        hy = curObject.outerHighy;
                        first = false;
                    } else {
                        if (curObject.outerLowx < lx) {
                            lx = curObject.outerLowx;
                        }
                        if (curObject.outerHighx > hx) {
                            hx = curObject.outerHighx;
                        }
                        if (curObject.outerLowy < ly) {
                            ly = curObject.outerLowy;
                        }
                        if (curObject.outerHighy > hy) {
                            hy = curObject.outerHighy;
                        }
                    }
                }
                curObject = curObject.nextObject;
            }
            if (this.curAxis == Axis.HORIZONTAL) {
                line.low = lx;
                line.high = hx;
            } else {
                line.low = ly;
                line.high = hy;
            }
        }

        private Line sortLines(Line line) {
            if (line == null) {
                System.out.println("Error: sortLines called with null argument");
                return null;
            }
            Line curLine = line;
            while (curLine != null) {
                double ave = 0.0;
                double totalLen = 0.0;
                GeomObj curObject = curLine.firstObject;
                while (curObject != null) {
                    double ctr = 0.0;
                    ctr = this.curAxis == Axis.HORIZONTAL ? (curObject.lowx + curObject.highx) / 2.0 : (curObject.lowy + curObject.highy) / 2.0;
                    totalLen += 1.0;
                    ave += ctr;
                    curObject = curObject.nextObject;
                }
                if (totalLen != 0.0) {
                    ave /= totalLen;
                }
                curLine.val = ave;
                curLine = curLine.nextLine;
            }
            Line newLine = null;
            while (line != null) {
                boolean first = true;
                double bestVal = 0.0;
                Line bestLine = null;
                Line curLine2 = line;
                while (curLine2 != null) {
                    if (first) {
                        bestVal = curLine2.val;
                        bestLine = curLine2;
                        first = false;
                    } else if (curLine2.val > bestVal) {
                        bestVal = curLine2.val;
                        bestLine = curLine2;
                    }
                    curLine2 = curLine2.nextLine;
                }
                if (bestLine.prevLine == null) {
                    line = bestLine.nextLine;
                } else {
                    bestLine.prevLine.nextLine = bestLine.nextLine;
                }
                if (bestLine.nextLine != null) {
                    bestLine.nextLine.prevLine = bestLine.prevLine;
                }
                if (newLine != null) {
                    newLine.prevLine = bestLine;
                }
                bestLine.nextLine = newLine;
                bestLine.prevLine = null;
                newLine = bestLine;
            }
            return newLine;
        }

        private Line makeObjectLine(Line line, List<GeomObj> objectList) {
            Line newLine = new Line();
            newLine.nextLine = line;
            newLine.prevLine = null;
            newLine.firstObject = null;
            GeomObj lastObject = null;
            for (GeomObj gO : objectList) {
                if (lastObject == null) {
                    newLine.firstObject = gO;
                } else {
                    lastObject.nextObject = gO;
                }
                lastObject = gO;
            }
            if (line != null) {
                line.prevLine = newLine;
            }
            return newLine;
        }

        private void createObjects(NodeInst ni, List<GeomObj> thisObject, List<GeomObj> otherObject, HashSet<NodeInst> nodesSeen, HashMap<ArcInst, Integer> arcIndices, HashMap<PortProto, Integer> portIndices) {
            double stHigh;
            double stLow;
            if (nodesSeen.contains(ni)) {
                return;
            }
            nodesSeen.add(ni);
            if (thisObject.size() == 0) {
                thisObject.add(this.makeNodeInstObject(ni, null, GenMath.MATID, 0.0, 0.0, 0.0, 0.0, arcIndices, portIndices));
            }
            GeomObj firstObject = thisObject.get(0);
            if (this.curAxis == Axis.HORIZONTAL) {
                stLow = firstObject.lowx;
                stHigh = firstObject.highx;
            } else {
                stLow = firstObject.lowy;
                stHigh = firstObject.highy;
            }
            Iterator<Connection> it = ni.getConnections();
            while (it.hasNext()) {
                double bdHigh;
                double bdLow;
                Connection con = it.next();
                ArcInst ai = con.getArc();
                NodeInst otherEnd = ai.getTailPortInst().getNodeInst();
                if (otherEnd == ni) {
                    otherEnd = ai.getHeadPortInst().getNodeInst();
                }
                if (nodesSeen.contains(otherEnd)) continue;
                GeomObj newObject = this.makeArcInstObject(ai, null, GenMath.MATID, 0.0, 0.0, 0.0, 0.0, arcIndices);
                GeomObj secondObject = this.makeNodeInstObject(otherEnd, null, GenMath.MATID, 0.0, 0.0, 0.0, 0.0, arcIndices, portIndices);
                boolean partOfLine = false;
                if (this.curAxis == Axis.HORIZONTAL) {
                    bdLow = secondObject.lowx;
                    bdHigh = secondObject.highx;
                    if (ai.getHeadLocation().getX() == ai.getTailLocation().getX()) {
                        partOfLine = true;
                    }
                    if (DBMath.doublesEqual(ni.getAnchorCenterX(), otherEnd.getAnchorCenterX())) {
                        partOfLine = true;
                    }
                } else {
                    bdLow = secondObject.lowy;
                    bdHigh = secondObject.highy;
                    if (ai.getHeadLocation().getY() == ai.getTailLocation().getY()) {
                        partOfLine = true;
                    }
                    if (DBMath.doublesEqual(ni.getAnchorCenterY(), otherEnd.getAnchorCenterY())) {
                        partOfLine = true;
                    }
                }
                if (bdHigh > stLow && bdLow < stHigh) {
                    partOfLine = true;
                }
                if (partOfLine) {
                    thisObject.add(newObject);
                    thisObject.add(secondObject);
                    this.createObjects(otherEnd, thisObject, otherObject, nodesSeen, arcIndices, portIndices);
                    continue;
                }
                otherObject.add(newObject);
            }
        }

        private GeomObj makeNodeInstObject(NodeInst ni, GeomObj object, AffineTransform newTrans, double low1, double high1, double low2, double high2, HashMap<ArcInst, Integer> arcIndices, HashMap<PortProto, Integer> portIndices) {
            GeomObj newObject = object;
            if (newObject == null) {
                newObject = new GeomObj();
                newObject.inst = ni;
                newObject.nextObject = null;
                newObject.firstPolyList = null;
                Rectangle2D bounds = ni.getBounds();
                newObject.outerLowx = bounds.getMinX();
                newObject.outerHighx = bounds.getMaxX();
                newObject.outerLowy = bounds.getMinY();
                newObject.outerHighy = bounds.getMaxY();
                if (ni.isCellInstance()) {
                    newObject.lowx = newObject.outerLowx;
                    newObject.highx = newObject.outerHighx;
                    newObject.lowy = newObject.outerLowy;
                    newObject.highy = newObject.outerHighy;
                } else {
                    Rectangle2D bound = ni.getBaseShape().getBounds2D();
                    newObject.lowx = bound.getMinX();
                    newObject.highx = bound.getMaxX();
                    newObject.lowy = bound.getMinY();
                    newObject.highy = bound.getMaxY();
                }
            }
            HashMap<PortProto, Integer> localPortIndices = this.fillNode(ni, arcIndices, portIndices);
            if (ni.isCellInstance()) {
                Cell subCell = (Cell)ni.getProto();
                AffineTransform trans = ni.translateOut(newTrans);
                HashMap<ArcInst, Integer> localArcIndices = this.subCellSmash(subCell, localPortIndices);
                if (object == null) {
                    Rectangle2D bounds = ni.getBounds();
                    if (this.curAxis == Axis.HORIZONTAL) {
                        low1 = bounds.getMinX();
                        high1 = bounds.getMinX() + this.maxBoundary;
                        low2 = bounds.getMaxX() - this.maxBoundary;
                        high2 = bounds.getMaxX();
                    } else {
                        low1 = bounds.getMinY();
                        high1 = bounds.getMinY() + this.maxBoundary;
                        low2 = bounds.getMaxY() - this.maxBoundary;
                        high2 = bounds.getMaxY();
                    }
                }
                Iterator<Geometric> it = subCell.getNodes();
                while (it.hasNext()) {
                    NodeInst subNi = it.next();
                    this.makeNodeInstObject(subNi, newObject, trans, low1, high1, low2, high2, localArcIndices, localPortIndices);
                }
                it = subCell.getArcs();
                while (it.hasNext()) {
                    ArcInst subAi = (ArcInst)it.next();
                    this.makeArcInstObject(subAi, newObject, trans, low1, high1, low2, high2, localArcIndices);
                }
            } else {
                AffineTransform trans = ni.rotateOut(newTrans);
                Technology tech = ni.getProto().getTechnology();
                for (Poly poly : tech.getShapeOfNode(ni, true, true, null)) {
                    Integer i;
                    poly.transform(trans);
                    if (object != null) {
                        Rectangle2D bounds = poly.getBounds2D();
                        if (this.curAxis == Axis.HORIZONTAL ? (bounds.getMaxX() < low1 || bounds.getMinX() > high1) && (bounds.getMaxX() < low2 || bounds.getMinX() > high2) : (bounds.getMaxY() < low1 || bounds.getMinY() > high1) && (bounds.getMaxY() < low2 || bounds.getMinY() > high2)) continue;
                    }
                    int pIndex = -1;
                    if (poly.getPort() != null && (i = localPortIndices.get(poly.getPort())) != null) {
                        pIndex = i;
                    }
                    this.addPolyToPolyList(poly, newObject, pIndex, tech);
                }
            }
            return newObject;
        }

        private HashMap<PortProto, Integer> fillNode(NodeInst ni, HashMap<ArcInst, Integer> arcIndices, HashMap<PortProto, Integer> portIndices) {
            PortProto pp;
            HashMap<PortProto, Integer> localPortIndices = new HashMap<PortProto, Integer>();
            Iterator<Object> it = ni.getConnections();
            while (it.hasNext()) {
                Connection con = it.next();
                ArcInst ai = con.getArc();
                PortProto pp2 = con.getPortInst().getPortProto();
                if (localPortIndices.get(pp2) != null) continue;
                Integer aIndex = arcIndices.get(ai);
                localPortIndices.put(pp2, aIndex);
            }
            it = ni.getExports();
            while (it.hasNext()) {
                Export e = (Export)it.next();
                pp = e.getOriginalPort().getPortProto();
                if (localPortIndices.get(pp) != null) continue;
                Integer pIndex = portIndices.get(e);
                localPortIndices.put(pp, pIndex);
            }
            Netlist nl = ni.getParent().getUserNetlist();
            Iterator<PortProto> it2 = ni.getProto().getPorts();
            while (it2.hasNext()) {
                pp = it2.next();
                if (localPortIndices.get(pp) != null) continue;
                boolean found = false;
                Network net = nl.getNetwork(ni, pp, 0);
                Iterator<PortProto> oIt = ni.getProto().getPorts();
                while (oIt.hasNext()) {
                    Integer oIndex;
                    PortProto oPp = oIt.next();
                    Network oNet = nl.getNetwork(ni, oPp, 0);
                    if (oNet != net || (oIndex = localPortIndices.get(oPp)) == null) continue;
                    localPortIndices.put(pp, oIndex);
                    found = true;
                    break;
                }
                if (found) continue;
                localPortIndices.put(pp, new Integer(this.flatIndex++));
            }
            return localPortIndices;
        }

        private GeomObj makeArcInstObject(ArcInst ai, GeomObj object, AffineTransform newTrans, double low1, double high1, double low2, double high2, HashMap<ArcInst, Integer> arcIndices) {
            GeomObj newObject = object;
            if (object == null) {
                newObject = new GeomObj();
                newObject.inst = ai;
                newObject.nextObject = null;
                newObject.firstPolyList = null;
                Poly poly = ai.makeLambdaPoly(ai.getGridBaseWidth(), Poly.Type.CLOSED);
                Rectangle2D bounds = poly.getBounds2D();
                newObject.lowx = bounds.getMinX();
                newObject.highx = bounds.getMaxX();
                newObject.lowy = bounds.getMinY();
                newObject.highy = bounds.getMaxY();
                poly = ai.makeLambdaPoly(ai.getGridFullWidth(), Poly.Type.CLOSED);
                bounds = poly.getBounds2D();
                newObject.outerLowx = bounds.getMinX();
                newObject.outerHighx = bounds.getMaxX();
                newObject.outerLowy = bounds.getMinY();
                newObject.outerHighy = bounds.getMaxY();
            }
            Technology tech = ai.getProto().getTechnology();
            for (Poly poly : tech.getShapeOfArc(ai)) {
                if (poly.getLayer() == null) continue;
                if (object != null) {
                    poly.transform(newTrans);
                    Rectangle2D bounds = poly.getBounds2D();
                    if (this.curAxis == Axis.HORIZONTAL ? (bounds.getMaxX() < low1 || bounds.getMinX() > high1) && (bounds.getMaxX() < low2 || bounds.getMinX() > high2) : (bounds.getMaxY() < low1 || bounds.getMinY() > high1) && (bounds.getMaxY() < low2 || bounds.getMinY() > high2)) continue;
                }
                int aIndex = -1;
                Integer iv = arcIndices.get(ai);
                if (iv != null) {
                    aIndex = iv;
                }
                this.addPolyToPolyList(poly, newObject, aIndex, tech);
            }
            return newObject;
        }

        private void addPolyToPolyList(Poly poly, GeomObj object, int networkNum, Technology tech) {
            PolyList newPolyList = new PolyList();
            newPolyList.poly = poly;
            newPolyList.tech = tech;
            newPolyList.networkNum = networkNum;
            newPolyList.nextPolyList = object.firstPolyList;
            object.firstPolyList = newPolyList;
        }

        private HashMap<ArcInst, Integer> subCellSmash(Cell topCell, HashMap<PortProto, Integer> portIndices) {
            Netlist nl = topCell.getUserNetlist();
            HashMap<ArcInst, Integer> arcIndices = new HashMap<ArcInst, Integer>();
            Iterator<ArcInst> it = topCell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                if (arcIndices.get(ai) != null) continue;
                Network aNet = nl.getNetwork(ai, 0);
                boolean found = false;
                Iterator<PortProto> pIt = topCell.getPorts();
                while (pIt.hasNext()) {
                    Export pp = (Export)pIt.next();
                    Integer pIndex = portIndices.get(pp);
                    Network pNet = nl.getNetwork(pp, 0);
                    if (pNet != aNet) continue;
                    Iterator<ArcInst> aIt = topCell.getArcs();
                    while (aIt.hasNext()) {
                        ArcInst oAi = aIt.next();
                        Network oANet = nl.getNetwork(oAi, 0);
                        if (oANet != aNet) continue;
                        arcIndices.put(oAi, pIndex);
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                Integer pIndex = new Integer(this.flatIndex++);
                Iterator<ArcInst> aIt = topCell.getArcs();
                while (aIt.hasNext()) {
                    ArcInst oAi = aIt.next();
                    Network oANet = nl.getNetwork(oAi, 0);
                    if (oANet != aNet) continue;
                    arcIndices.put(oAi, pIndex);
                }
            }
            return arcIndices;
        }

        private static class Line {
            private double val;
            private double low;
            private double high;
            private GeomObj firstObject;
            private Line nextLine;
            private Line prevLine;

            private Line() {
            }
        }

        private static class GeomObj {
            private Geometric inst;
            private PolyList firstPolyList;
            private double lowx;
            private double highx;
            private double lowy;
            private double highy;
            private double outerLowx;
            private double outerHighx;
            private double outerLowy;
            private double outerHighy;
            private GeomObj nextObject;

            private GeomObj() {
            }
        }

        private static class PolyList {
            private Poly poly;
            private Technology tech;
            private int networkNum;
            private PolyList nextPolyList;

            private PolyList() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Axis {
            HORIZONTAL,
            VERTICAL;

        }
    }

    private static class CompactCellJob
    extends Job {
        private Cell cell;
        private boolean lastTime;
        private CompactCell.Axis curAxis;

        private CompactCellJob(Cell cell, boolean lastTime, CompactCell.Axis curAxis) {
            super("Compact " + cell, tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.lastTime = lastTime;
            this.curAxis = curAxis;
        }

        public boolean doIt() throws JobException {
            CompactCell cc = new CompactCell(this.cell);
            boolean change = cc.compactOneDirection(this.curAxis);
            if (--limitLoops <= 0) {
                change = false;
            }
            if (this.lastTime || change) {
                this.curAxis = this.curAxis == CompactCell.Axis.HORIZONTAL ? CompactCell.Axis.VERTICAL : CompactCell.Axis.HORIZONTAL;
                CompactCellJob job = new CompactCellJob(this.cell, change, this.curAxis);
                job.startJobOnMyResult();
            } else {
                System.out.println("Compaction complete");
            }
            return true;
        }
    }
}

