/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.simulation.DigitalAnalysis;
import com.sun.electric.tool.simulation.DigitalSignal;
import com.sun.electric.tool.simulation.Stimuli;
import java.awt.Point;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ArchSimOut
extends Simulate {
    ArchSimOut() {
    }

    protected Stimuli readSimulationOutput(URL fileURL, Cell cell) throws IOException {
        if (this.openTextInput(fileURL)) {
            return null;
        }
        ArchSimOut.startProgressDialog("ArchSim output", fileURL.getFile());
        Stimuli sd = this.readArchSimFile(cell);
        ArchSimOut.stopProgressDialog();
        this.closeInput();
        return sd;
    }

    private Stimuli readArchSimFile(Cell cell) throws IOException {
        String line;
        HashMap<String, ArrayList<Point>> symbolTable = new HashMap<String, ArrayList<Point>>();
        int greatestTime = 0;
        while ((line = this.getLineFromSimulator()) != null) {
            int firstColon = line.indexOf(58);
            int secondColon = line.indexOf(58, firstColon + 1);
            if (firstColon < 0 || secondColon < 0) {
                System.out.println("Line " + this.lineReader.getLineNumber() + " is missing two colons: " + line);
                continue;
            }
            int time = TextUtils.atoi(line.substring(0, firstColon));
            if (time > greatestTime) {
                greatestTime = time;
            }
            String signalName = line.substring(firstColon + 1, secondColon);
            int value = TextUtils.atoi(line.substring(secondColon + 1));
            ArrayList<Point> values = (ArrayList<Point>)symbolTable.get(signalName);
            if (values == null) {
                values = new ArrayList<Point>();
                symbolTable.put(signalName, values);
            }
            values.add(new Point(time, value));
        }
        Stimuli sd = new Stimuli();
        DigitalAnalysis an = new DigitalAnalysis(sd, true);
        sd.setCell(cell);
        for (String signalName : symbolTable.keySet()) {
            List values = (List)symbolTable.get(signalName);
            int numStimuli = values.size();
            DigitalSignal sig = new DigitalSignal(an);
            sig.setSignalName(signalName, null);
            sig.buildTime(numStimuli);
            sig.buildState(numStimuli);
            int i = 0;
            for (Point pt : values) {
                sig.setTime(i, pt.x);
                int state = 8;
                if (pt.y != 0) {
                    state = 10;
                }
                sig.setState(i, state);
                ++i;
            }
        }
        return sd;
    }
}

