/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortOriginal;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCRules;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Consumer;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.CheckInst;
import com.sun.electric.tool.drc.CheckProto;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.drc.InstanceInter;
import com.sun.electric.tool.drc.MTDRCAreaTool;
import com.sun.electric.tool.drc.MTDRCTool;
import com.sun.electric.tool.drc.ValidationLayers;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTDRCLayoutTool
extends MTDRCTool {
    private boolean ignoreExtensionRules = true;

    public MTDRCLayoutTool(DRC.DRCPreferences dp, Cell c, boolean ignoreExtensionR, Consumer<MTDRCTool.MTDRCResult> consumer) {
        super("Design-Rule Layout Check " + c, dp, c, consumer);
        this.ignoreExtensionRules = ignoreExtensionR;
    }

    @Override
    boolean checkArea() {
        return false;
    }

    @Override
    public MTDRCTool.MTDRCResult runTaskInternal(Layer taskKey) {
        return new Task(this.rules, this).runTaskInternal(taskKey);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Task {
        private HashMap<NodeInst, CheckInst> checkInsts;
        private HashMap<Cell, CheckProto> checkProtos;
        private HashMap<Network, Integer[]> networkLists;
        private HashMap<Geometric, Geometric> nodesMap = new HashMap();
        private Map<Layer, NodeInst> od2Layers = new HashMap<Layer, NodeInst>(3);
        private List<InstanceInter> instanceInteractionList = new ArrayList<InstanceInter>();
        private Map<Cell, Area> exclusionMap = new HashMap<Cell, Area>();
        private NodeInst tinyNodeInst;
        private Geometric tinyGeometric;
        private HashSet<Cell> goodSpacingDRCDate = new HashSet();
        private HashSet<Cell> cleanSpacingDRCDate = new HashSet();
        private HashSet<Cell> goodAreaDRCDate = new HashSet();
        private HashSet<Cell> cleanAreaDRCDate = new HashSet();
        private DRC.ReportInfo reportInfo;
        ValidationLayers validLayers;
        private Layer theLayer;
        private Layer.Function.Set thisLayerFunction;
        private DRCRules currentRules;
        private Job job;

        Task(DRCRules rules, Job j) {
            this.currentRules = rules;
            this.job = j;
        }

        private MTDRCTool.MTDRCResult runTaskInternal(Layer taskKey) {
            String name;
            Technology tech = MTDRCLayoutTool.this.topCell.getTechnology();
            if (taskKey != null) {
                name = "Layer " + taskKey.getName();
                this.thisLayerFunction = DRC.getMultiLayersSet(taskKey);
            } else {
                name = "Node Min. Size";
            }
            this.theLayer = taskKey;
            Geometric[] geomsToCheck = null;
            int count = geomsToCheck != null ? geomsToCheck.length : 0;
            boolean[] validity = null;
            Rectangle2D bounds = null;
            ErrorLogger errorLogger = DRC.getDRCErrorLogger(true, false, ", " + name);
            this.reportInfo = new DRC.ReportInfo(errorLogger, tech, MTDRCLayoutTool.this.dp, count > 0);
            System.out.println("Running DRC for " + name + " with " + DRC.explainBits(this.reportInfo.activeSpacingBits, MTDRCLayoutTool.this.dp));
            if (this.currentRules == null || this.currentRules.getNumberOfRules() == 0) {
                return null;
            }
            this.validLayers = new ValidationLayers(this.reportInfo.errorLogger, MTDRCLayoutTool.this.topCell, MTDRCLayoutTool.this.rules);
            this.instanceInteractionList.clear();
            this.nodesMap.clear();
            this.checkProtos = new HashMap();
            this.checkInsts = new HashMap();
            Netlist netlist = MTDRCLayoutTool.this.topCell.getNetlist();
            CheckProto cp = this.checkEnumerateProtos(MTDRCLayoutTool.this.topCell, netlist);
            cp.hierInstanceCount = 1;
            this.reportInfo.checkTimeStamp = 0;
            this.checkEnumerateInstances(MTDRCLayoutTool.this.topCell);
            this.networkLists = new HashMap();
            for (Map.Entry<Cell, CheckProto> e : this.checkProtos.entrySet()) {
                NodeProto np;
                NodeInst ni;
                Iterator<Comparable<NodeInst>> nIt;
                Cell libCell = e.getKey();
                CheckProto subCP = e.getValue();
                if (subCP.hierInstanceCount > 0) {
                    nIt = subCP.netlist.getNetworks();
                    while (nIt.hasNext()) {
                        Network net = (Network)nIt.next();
                        Integer[] netNumbers = new Integer[subCP.hierInstanceCount];
                        for (int i = 0; i < subCP.hierInstanceCount; ++i) {
                            netNumbers[i] = new Integer(0);
                        }
                        this.networkLists.put(net, netNumbers);
                    }
                }
                nIt = libCell.getNodes();
                while (nIt.hasNext()) {
                    ni = (NodeInst)nIt.next();
                    np = ni.getProto();
                    if (!ni.isCellInstance() || ni.isIconOfParent()) continue;
                    CheckInst ci = this.checkInsts.get(ni);
                    CheckProto ocp = this.getCheckProto((Cell)np);
                    ci.offset = ocp.totalPerCell;
                }
                ++this.reportInfo.checkTimeStamp;
                nIt = libCell.getNodes();
                while (nIt.hasNext()) {
                    ni = (NodeInst)nIt.next();
                    np = ni.getProto();
                    if (!ni.isCellInstance() || ni.isIconOfParent()) continue;
                    CheckProto ocp = this.getCheckProto((Cell)np);
                    if (ocp.timeStamp == this.reportInfo.checkTimeStamp) continue;
                    CheckInst ci = this.checkInsts.get(ni);
                    ocp.timeStamp = this.reportInfo.checkTimeStamp;
                    ocp.totalPerCell += subCP.hierInstanceCount * ci.multiplier;
                }
            }
            this.reportInfo.checkTimeStamp = 0;
            this.reportInfo.checkNetNumber = 1;
            HashMap<Network, Integer> enumeratedNets = new HashMap<Network, Integer>();
            Iterator<Network> nIt = cp.netlist.getNetworks();
            while (nIt.hasNext()) {
                Network net = nIt.next();
                enumeratedNets.put(net, new Integer(this.reportInfo.checkNetNumber));
                ++this.reportInfo.checkNetNumber;
            }
            this.checkEnumerateNetworks(MTDRCLayoutTool.this.topCell, cp, 0, enumeratedNets);
            if (count <= 0) {
                System.out.println("Found " + this.reportInfo.checkNetNumber + " networks");
            }
            this.exclusionMap.clear();
            this.accumulateExclusion(MTDRCLayoutTool.this.topCell);
            int logsFound = 0;
            if (count == 0) {
                this.checkThisCell(MTDRCLayoutTool.this.topCell, 0, bounds);
                errorLogger.sortLogs();
            } else {
                if (validity == null) {
                    logsFound = errorLogger.getNumLogs();
                }
                this.checkTheseGeometrics(MTDRCLayoutTool.this.topCell, count, geomsToCheck, validity);
            }
            if (errorLogger != null) {
                errorLogger.termLogging(true);
                logsFound = errorLogger.getNumLogs() - logsFound;
            }
            return new MTDRCTool.MTDRCResult(errorLogger.getNumErrors(), errorLogger.getNumWarnings(), !MTDRCLayoutTool.this.checkAbort(), this.goodSpacingDRCDate, this.cleanSpacingDRCDate, this.goodAreaDRCDate, this.cleanAreaDRCDate, null);
        }

        private int checkThisCell(Cell cell, int globalIndex, Rectangle2D bounds) {
            Variable drcVar;
            if (MTDRCLayoutTool.this.checkAbort()) {
                return -1;
            }
            if (this.getCheckProto((Cell)cell).cellChecked) {
                return 0;
            }
            int prevErrors = 0;
            int prevWarns = 0;
            if (this.reportInfo.errorLogger != null) {
                prevErrors = this.reportInfo.errorLogger.getNumErrors();
                prevWarns = this.reportInfo.errorLogger.getNumWarnings();
            }
            if ((drcVar = cell.getVar(DRC.DRC_ANNOTATION_KEY)) != null && drcVar.getObject().toString().startsWith("black")) {
                assert (this.reportInfo.totalSpacingMsgFound == 0);
                return this.reportInfo.totalSpacingMsgFound;
            }
            boolean allSubCellsStillOK = true;
            Area area = this.exclusionMap.get(cell);
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                if (MTDRCLayoutTool.this.checkAbort()) {
                    return -1;
                }
                NodeInst ni = it.next();
                NodeProto np = ni.getProto();
                if (!ni.isCellInstance() || ni.isIconOfParent() || area != null && area.contains(ni.getBounds())) continue;
                Rectangle2D subBounds = bounds;
                if (subBounds != null) {
                    if (!ni.getBounds().intersects(bounds)) continue;
                    AffineTransform trans = ni.rotateIn();
                    AffineTransform xTrnI = ni.translateIn();
                    trans.preConcatenate(xTrnI);
                    subBounds = new Rectangle2D.Double();
                    subBounds.setRect(bounds);
                    DBMath.transformRect(subBounds, trans);
                }
                CheckProto cp = this.getCheckProto((Cell)np);
                if (cp.cellChecked && !cp.cellParameterized) continue;
                CheckInst ci = this.checkInsts.get(ni);
                int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
                int retval = this.checkThisCell((Cell)np, localIndex, subBounds);
                if (retval < 0) {
                    return retval;
                }
                if (retval <= 0 && !this.goodSpacingDRCDate.contains(np)) continue;
                allSubCellsStillOK = false;
            }
            CheckProto cp = this.getCheckProto(cell);
            cp.cellChecked = true;
            boolean skipLayer = MTDRCTool.skipLayerInvalidForMinArea(this.theLayer);
            boolean checkArea = cell == MTDRCLayoutTool.this.topCell && !skipLayer && !MTDRCLayoutTool.this.dp.ignoreAreaCheck && this.reportInfo.errorTypeSearch != DRC.DRCCheckMode.ERROR_CHECK_CELL;
            Date lastSpacingGoodDate = DRC.getLastDRCDateBasedOnBits(cell, true, this.reportInfo.activeSpacingBits, !this.reportInfo.inMemory);
            Date lastAreaGoodDate = DRC.getLastDRCDateBasedOnBits(cell, false, -1, !this.reportInfo.inMemory);
            if (allSubCellsStillOK && DRC.isCellDRCDateGood(cell, lastSpacingGoodDate) && (!checkArea || DRC.isCellDRCDateGood(cell, lastAreaGoodDate))) {
                return 0;
            }
            long startTime = System.currentTimeMillis();
            if (MTDRCLayoutTool.this.printLog) {
                System.out.println("Checking " + cell + ", " + this.theLayer);
            }
            this.reportInfo.totalSpacingMsgFound = 0;
            if (checkArea) {
                assert (this.reportInfo.totalSpacingMsgFound == 0);
                int totalAreaMsgFound = MTDRCAreaTool.checkMinArea(this.theLayer, MTDRCLayoutTool.this.topCell, this.reportInfo, this.currentRules, MTDRCLayoutTool.this.cellLayersCon, this.job, null);
                if (totalAreaMsgFound == 0) {
                    this.goodAreaDRCDate.add(cell);
                } else {
                    this.cleanAreaDRCDate.add(cell);
                }
            }
            Iterator<NodeInst> it2 = cell.getNodes();
            while (it2.hasNext()) {
                if (MTDRCLayoutTool.this.checkAbort()) {
                    return -1;
                }
                NodeInst ni = it2.next();
                if (bounds != null && !ni.getBounds().intersects(bounds) || area != null && area.contains(ni.getBounds())) continue;
                boolean ret = false;
                if (this.thisLayerFunction == null) {
                    if (ni.isCellInstance()) continue;
                    ret = this.checkNodeInst(ni, globalIndex);
                } else {
                    boolean bl = ret = ni.isCellInstance() ? this.checkCellInst(ni, globalIndex) : this.checkNodeInst(ni, globalIndex);
                }
                if (!ret) continue;
                ++this.reportInfo.totalSpacingMsgFound;
                if (this.reportInfo.errorTypeSearch != DRC.DRCCheckMode.ERROR_CHECK_CELL) continue;
                break;
            }
            if (this.thisLayerFunction != null) {
                Technology cellTech = cell.getTechnology();
                Iterator<ArcInst> it3 = cell.getArcs();
                while (it3.hasNext()) {
                    if (MTDRCLayoutTool.this.checkAbort()) {
                        return -1;
                    }
                    ArcInst ai = it3.next();
                    Technology tech = ai.getProto().getTechnology();
                    if (tech != cellTech) {
                        DRC.createDRCErrorLogger(this.reportInfo, DRC.DRCErrorType.TECHMIXWARN, " belongs to " + tech.getTechName(), cell, 0.0, 0.0, null, null, ai, null, null, null, null);
                        continue;
                    }
                    if (bounds != null && !ai.getBounds().intersects(bounds) || !this.checkArcInst(cp, ai, globalIndex)) continue;
                    ++this.reportInfo.totalSpacingMsgFound;
                    if (this.reportInfo.errorTypeSearch != DRC.DRCCheckMode.ERROR_CHECK_CELL) continue;
                    break;
                }
            }
            if (this.reportInfo.totalSpacingMsgFound > 0) {
                this.cleanSpacingDRCDate.add(cell);
            } else if (lastSpacingGoodDate == null) {
                this.goodSpacingDRCDate.add(cell);
            }
            if (this.reportInfo.errorLogger != null && MTDRCLayoutTool.this.printLog) {
                int localErrors = this.reportInfo.errorLogger.getNumErrors() - prevErrors;
                int localWarnings = this.reportInfo.errorLogger.getNumWarnings() - prevWarns;
                long endTime = System.currentTimeMillis();
                if (localErrors == 0 && localWarnings == 0) {
                    System.out.println("\tNo errors/warnings found");
                } else {
                    if (localErrors > 0) {
                        System.out.println("\tFOUND " + localErrors + " ERRORS");
                    }
                    if (localWarnings > 0) {
                        System.out.println("\tFOUND " + localWarnings + " WARNINGS");
                    }
                }
                if (Job.getDebug()) {
                    System.out.println("\t(took " + TextUtils.getElapsedTime(endTime - startTime) + ")");
                }
            }
            return this.reportInfo.totalSpacingMsgFound;
        }

        private boolean checkResolution(PolyBase poly, Cell cell, Geometric geom) {
            Point2D[] points;
            if (this.reportInfo.minAllowedResolution == 0.0) {
                return false;
            }
            int count = 0;
            String resolutionError = "";
            for (Point2D point : points = poly.getPoints()) {
                if (DBMath.hasRemainder(point.getX(), this.reportInfo.minAllowedResolution)) {
                    ++count;
                    resolutionError = TextUtils.formatDistance(Math.abs(point.getX() / this.reportInfo.minAllowedResolution % 1.0 * this.reportInfo.minAllowedResolution)) + "(X=" + point.getX() + ")";
                    break;
                }
                if (!DBMath.hasRemainder(point.getY(), this.reportInfo.minAllowedResolution)) continue;
                ++count;
                resolutionError = TextUtils.formatDistance(Math.abs(point.getY() / this.reportInfo.minAllowedResolution % 1.0 * this.reportInfo.minAllowedResolution)) + "(Y=" + point.getY() + ")";
                break;
            }
            if (count == 0) {
                return false;
            }
            Layer layer = poly.getLayer();
            DRC.createDRCErrorLogger(this.reportInfo, DRC.DRCErrorType.RESOLUTION, " resolution of " + resolutionError + " less than " + this.reportInfo.minAllowedResolution + " on layer " + layer.getName(), cell, 0.0, 0.0, "Resolution", null, geom, null, null, null, null);
            return true;
        }

        private boolean coverByExclusion(Geometric geo) {
            Cell cell = geo.getParent();
            Area area = this.exclusionMap.get(cell);
            return area != null && area.contains(geo.getBounds());
        }

        private boolean coverByExclusion(Poly poly, Cell parent) {
            Point2D[] pts;
            Area area = this.exclusionMap.get(parent);
            if (area == null) {
                return false;
            }
            for (Point2D point : pts = poly.getPoints()) {
                if (area.contains(point)) continue;
                return false;
            }
            return true;
        }

        private boolean checkNodeInst(NodeInst ni, int globalIndex) {
            Cell cell = ni.getParent();
            Netlist netlist = this.getCheckProto((Cell)cell).netlist;
            NodeProto np = ni.getProto();
            Technology tech = np.getTechnology();
            AffineTransform trans = ni.rotateOut();
            boolean errorsFound = false;
            if (NodeInst.isSpecialNode(ni)) {
                return false;
            }
            if (!np.getTechnology().isLayout()) {
                return false;
            }
            if (np.getFunction() == PrimitiveNode.Function.PIN) {
                return false;
            }
            if (this.coverByExclusion(ni)) {
                return false;
            }
            if (this.nodesMap.get(ni) != null) {
                return false;
            }
            this.nodesMap.put(ni, ni);
            if (this.thisLayerFunction != null) {
                Poly[] nodeInstPolyList = tech.getShapeOfNode(ni, true, this.reportInfo.ignoreCenterCuts, this.thisLayerFunction);
                this.convertPseudoLayers(ni, nodeInstPolyList);
                int tot = nodeInstPolyList.length;
                boolean isTransistor = np.getFunction().isTransistor();
                Technology.MultiCutData multiCutData = tech.getMultiCutData(ni);
                for (int j = 0; j < tot; ++j) {
                    int netNumber;
                    Poly poly = nodeInstPolyList[j];
                    Layer layer = poly.getLayer();
                    if (layer == null || this.coverByExclusion(poly, cell)) continue;
                    boolean ret = DRC.checkOD2Combination(tech, ni, layer, this.od2Layers, this.reportInfo);
                    if (ret) {
                        return true;
                    }
                    poly.transform(trans);
                    ret = this.checkResolution(poly, cell, ni);
                    if (ret) {
                        if (this.reportInfo.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                            return true;
                        }
                        errorsFound = true;
                    }
                    if (ret = this.badBox(poly, layer, netNumber = this.getDRCNetNumber(netlist, poly.getPort(), ni, globalIndex), tech, ni, trans, cell, globalIndex, multiCutData)) {
                        if (this.reportInfo.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                            return true;
                        }
                        errorsFound = true;
                    }
                    if (ret = this.checkMinWidth(ni, layer, poly, tot == 1)) {
                        if (this.reportInfo.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                            return true;
                        }
                        errorsFound = true;
                    }
                    boolean bl = ret = !isTransistor && this.checkExtensionRules(ni, layer, poly, cell);
                    if (ret) {
                        if (this.reportInfo.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                            return true;
                        }
                        errorsFound = true;
                    }
                    if (!this.validLayers.isABadLayer(tech, layer.getIndex())) continue;
                    DRC.createDRCErrorLogger(this.reportInfo, DRC.DRCErrorType.BADLAYERERROR, null, cell, 0.0, 0.0, null, poly, ni, layer, null, null, null);
                    if (this.reportInfo.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                        return true;
                    }
                    errorsFound = true;
                }
            } else {
                if (DRC.checkNodeAgainstCombinationRules(ni, this.reportInfo)) {
                    if (this.reportInfo.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                        return true;
                    }
                    errorsFound = true;
                }
                if (DRC.checkNodeSize(ni, cell, this.reportInfo)) {
                    errorsFound = true;
                }
            }
            return errorsFound;
        }

        private boolean checkArcInst(CheckProto cp, ArcInst ai, int globalIndex) {
            Poly[] arcInstPolyList;
            if (this.thisLayerFunction == null) {
                return false;
            }
            Network net = cp.netlist.getNetwork(ai, 0);
            if (net == null) {
                return false;
            }
            Integer[] netNumbers = this.networkLists.get(net);
            if (this.nodesMap.get(ai) != null) {
                return false;
            }
            this.nodesMap.put(ai, ai);
            boolean errorsFound = false;
            EPoint from = ai.getHeadLocation();
            EPoint to = ai.getTailLocation();
            if (!DBMath.areEquals(((Point2D)from).getX(), ((Point2D)to).getX()) && !DBMath.areEquals(((Point2D)from).getY(), ((Point2D)to).getY())) {
                DRC.createDRCErrorLogger(this.reportInfo, DRC.DRCErrorType.CROOKEDERROR, null, ai.getParent(), -1.0, -1.0, null, null, ai, null, null, null, null);
                if (this.reportInfo.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                    return true;
                }
                errorsFound = true;
            }
            Technology tech = ai.getProto().getTechnology();
            for (Poly poly : arcInstPolyList = tech.getShapeOfArc(ai, this.thisLayerFunction)) {
                boolean ret;
                Layer layer = poly.getLayer();
                if (layer == null || layer.isNonElectrical() || !(ret = this.checkResolution(poly, ai.getParent(), ai))) continue;
                if (this.reportInfo.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                    return true;
                }
                errorsFound = true;
            }
            this.cropActiveArc(ai, arcInstPolyList);
            int tot = arcInstPolyList.length;
            for (int j = 0; j < tot; ++j) {
                Poly poly = arcInstPolyList[j];
                Layer layer = poly.getLayer();
                if (layer == null || layer.isNonElectrical()) continue;
                int layerNum = layer.getIndex();
                int netNumber = netNumbers[globalIndex];
                boolean ret = this.badBox(poly, layer, netNumber, tech, ai, DBMath.MATID, ai.getParent(), globalIndex, null);
                if (ret) {
                    if (this.reportInfo.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                        return true;
                    }
                    errorsFound = true;
                }
                if (ret = this.checkMinWidth(ai, layer, poly, tot == 1)) {
                    if (this.reportInfo.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                        return true;
                    }
                    errorsFound = true;
                }
                if (ret = this.checkExtensionRules(ai, layer, poly, ai.getParent())) {
                    if (this.reportInfo.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                        return true;
                    }
                    errorsFound = true;
                }
                if (!this.validLayers.isABadLayer(tech, layerNum)) continue;
                DRC.createDRCErrorLogger(this.reportInfo, DRC.DRCErrorType.BADLAYERERROR, null, ai.getParent(), 0.0, 0.0, null, tot == 1 ? null : poly, ai, layer, null, null, null);
                if (this.reportInfo.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                    return true;
                }
                errorsFound = true;
            }
            return errorsFound;
        }

        private boolean checkCellInst(NodeInst ni, int globalIndex) {
            Cell thisCell = (Cell)ni.getProto();
            if (!thisCell.isLayout()) {
                return false;
            }
            AffineTransform upTrans = ni.translateOut(ni.rotateOut());
            CheckInst ci = this.checkInsts.get(ni);
            int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
            boolean errorFound = false;
            Rectangle2D nodeBounds = ni.getBounds();
            double worstInteractionDistance = this.reportInfo.worstInteractionDistance;
            Rectangle2D.Double searchBounds = new Rectangle2D.Double(nodeBounds.getMinX() - worstInteractionDistance, nodeBounds.getMinY() - worstInteractionDistance, nodeBounds.getWidth() + worstInteractionDistance * 2.0, nodeBounds.getHeight() + worstInteractionDistance * 2.0);
            this.instanceInteractionList.clear();
            Iterator<RTBounds> it = ni.getParent().searchIterator(searchBounds);
            while (it.hasNext()) {
                Rectangle2D nearNodeBounds;
                Rectangle2D.Double subBounds;
                boolean ret;
                NodeInst oNi;
                RTBounds geom = it.next();
                if (geom == ni || !(geom instanceof NodeInst) || (oNi = (NodeInst)geom).getNodeIndex() <= ni.getNodeIndex() || !oNi.isCellInstance() || this.checkInteraction(ni, null, oNi, null, null) || !(ret = this.checkCellInstContents(subBounds = new Rectangle2D.Double((nearNodeBounds = oNi.getBounds()).getMinX() - worstInteractionDistance, nearNodeBounds.getMinY() - worstInteractionDistance, nearNodeBounds.getWidth() + worstInteractionDistance * 2.0, nearNodeBounds.getHeight() + worstInteractionDistance * 2.0), ni, upTrans, localIndex, oNi, null, globalIndex, null))) continue;
                errorFound = true;
            }
            return errorFound;
        }

        private boolean checkCellInstContents(Rectangle2D bounds, NodeInst thisNi, AffineTransform upTrans, int globalIndex, NodeInst oNi, NodeInst oNiParent, int topGlobalIndex, NodeInst triggerNi) {
            if (MTDRCLayoutTool.this.checkAbort()) {
                return true;
            }
            Cell cell = (Cell)thisNi.getProto();
            boolean logsFound = false;
            Netlist netlist = this.getCheckProto((Cell)cell).netlist;
            Technology cellTech = cell.getTechnology();
            Rectangle2D bb = (Rectangle2D)bounds.clone();
            AffineTransform downTrans = thisNi.transformIn();
            DBMath.transformRect(bb, downTrans);
            Iterator<RTBounds> it = cell.searchIterator(bb);
            while (it.hasNext()) {
                int j;
                RTBounds geom = it.next();
                if (geom instanceof NodeInst) {
                    NodeInst ni = (NodeInst)geom;
                    NodeProto np = ni.getProto();
                    if (NodeInst.isSpecialNode(ni)) continue;
                    if (ni.isCellInstance()) {
                        if (this.checkInteraction(ni, thisNi, oNi, oNiParent, triggerNi)) continue;
                        AffineTransform subUpTrans = ni.translateOut(ni.rotateOut());
                        subUpTrans.preConcatenate(upTrans);
                        CheckInst ci = this.checkInsts.get(ni);
                        int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
                        boolean ret = this.checkCellInstContents(bb, ni, subUpTrans, localIndex, oNi, oNiParent, topGlobalIndex, triggerNi == null ? ni : triggerNi);
                        if (!ret) continue;
                        if (this.reportInfo.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                            return true;
                        }
                        logsFound = true;
                        continue;
                    }
                    AffineTransform rTrans = ni.rotateOut();
                    rTrans.preConcatenate(upTrans);
                    Technology tech = np.getTechnology();
                    Poly[] primPolyList = tech.getShapeOfNode(ni, true, this.reportInfo.ignoreCenterCuts, this.thisLayerFunction);
                    this.convertPseudoLayers(ni, primPolyList);
                    int tot = primPolyList.length;
                    Technology.MultiCutData multiCutData = tech.getMultiCutData(ni);
                    for (int j2 = 0; j2 < tot; ++j2) {
                        Poly poly = primPolyList[j2];
                        Layer layer = poly.getLayer();
                        if (layer == null) {
                            assert (false);
                            if (!Job.LOCALDEBUGFLAG) continue;
                            System.out.println("When is this case?");
                            continue;
                        }
                        poly.transform(rTrans);
                        int net = this.getDRCNetNumber(netlist, poly.getPort(), ni, globalIndex);
                        boolean ret = this.badSubBox(poly, layer, net, tech, ni, rTrans, globalIndex, oNi, topGlobalIndex, multiCutData);
                        if (!ret) continue;
                        if (this.reportInfo.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                            return true;
                        }
                        logsFound = true;
                    }
                    continue;
                }
                ArcInst ai = (ArcInst)geom;
                Technology tech = ai.getProto().getTechnology();
                if (tech != cellTech) {
                    DRC.createDRCErrorLogger(this.reportInfo, DRC.DRCErrorType.TECHMIXWARN, " belongs to " + tech.getTechName(), cell, 0.0, 0.0, null, null, ai, null, null, null, null);
                    continue;
                }
                Poly[] arcPolyList = tech.getShapeOfArc(ai, this.thisLayerFunction);
                int tot = arcPolyList.length;
                for (j = 0; j < tot; ++j) {
                    arcPolyList[j].transform(upTrans);
                }
                this.cropActiveArc(ai, arcPolyList);
                for (j = 0; j < tot; ++j) {
                    boolean ret;
                    Poly poly = arcPolyList[j];
                    Layer layer = poly.getLayer();
                    if (layer == null || layer.isNonElectrical()) continue;
                    Network jNet = netlist.getNetwork(ai, 0);
                    int net = -1;
                    if (jNet != null) {
                        Integer[] netList = this.networkLists.get(jNet);
                        net = netList[globalIndex];
                    }
                    if (!(ret = this.badSubBox(poly, layer, net, tech, ai, upTrans, globalIndex, oNi, topGlobalIndex, null))) continue;
                    if (this.reportInfo.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                        return true;
                    }
                    logsFound = true;
                }
            }
            return logsFound;
        }

        private boolean badSubBox(Poly poly, Layer layer, int net, Technology tech, Geometric geom, AffineTransform trans, int globalIndex, NodeInst oNi, int topGlobalIndex, Technology.MultiCutData multiCutData) {
            double maxSize = poly.getMaxSize();
            double bound = this.currentRules.getMaxSurround(layer, maxSize);
            if (bound < 0.0) {
                return false;
            }
            Rectangle2D.Double bounds = new Rectangle2D.Double();
            ((Rectangle2D)bounds).setRect(poly.getBounds2D());
            AffineTransform downTrans = oNi.rotateIn();
            AffineTransform tTransI = oNi.translateIn();
            downTrans.preConcatenate(tTransI);
            DBMath.transformRect(bounds, downTrans);
            AffineTransform upTrans = oNi.translateOut(oNi.rotateOut());
            CheckInst ci = this.checkInsts.get(oNi);
            int localIndex = topGlobalIndex * ci.multiplier + ci.localIndex + ci.offset;
            ((Rectangle2D)bounds).setRect(bounds.getMinX() - bound, bounds.getMinY() - bound, ((RectangularShape)bounds).getWidth() + bound * 2.0, ((RectangularShape)bounds).getHeight() + bound * 2.0);
            return this.badBoxInArea(poly, layer, tech, net, geom, trans, globalIndex, bounds, (Cell)oNi.getProto(), localIndex, oNi.getParent(), topGlobalIndex, upTrans, multiCutData, false);
        }

        private boolean badBox(Poly poly, Layer layer, int net, Technology tech, Geometric geom, AffineTransform trans, Cell cell, int globalIndex, Technology.MultiCutData multiCutData) {
            double maxSize = poly.getMaxSize();
            double bound = this.currentRules.getMaxSurround(layer, maxSize);
            if (bound < 0.0) {
                return false;
            }
            Rectangle2D.Double bounds = new Rectangle2D.Double();
            ((Rectangle2D)bounds).setRect(poly.getBounds2D());
            ((Rectangle2D)bounds).setRect(bounds.getMinX() - bound, bounds.getMinY() - bound, ((RectangularShape)bounds).getWidth() + bound * 2.0, ((RectangularShape)bounds).getHeight() + bound * 2.0);
            return this.badBoxInArea(poly, layer, tech, net, geom, trans, globalIndex, bounds, cell, globalIndex, cell, globalIndex, DBMath.MATID, multiCutData, true);
        }

        private boolean badBoxInArea(Poly poly, Layer layer, Technology tech, int net, Geometric geom, AffineTransform trans, int globalIndex, Rectangle2D bounds, Cell cell, int cellGlobalIndex, Cell topCell, int topGlobalIndex, AffineTransform upTrans, Technology.MultiCutData multiCutData, boolean sameInstance) {
            Rectangle2D.Double rBound = new Rectangle2D.Double();
            ((Rectangle2D)rBound).setRect(bounds);
            DBMath.transformRect(rBound, upTrans);
            Netlist netlist = this.getCheckProto((Cell)cell).netlist;
            Rectangle2D.Double subBound = new Rectangle2D.Double();
            boolean foundError = false;
            boolean isLayerAContact = layer.getFunction().isContact();
            boolean baseMulti = tech.isMultiCutInTechnology(multiCutData);
            if (geom instanceof NodeInst && NodeInst.isSpecialNode((NodeInst)geom)) {
                return false;
            }
            Iterator<RTBounds> it = cell.searchIterator(bounds);
            while (it.hasNext()) {
                DRCTemplate theRule;
                boolean edge;
                Rectangle2D trueBox2;
                Rectangle2D trueBox1;
                boolean maytouch;
                boolean ret;
                Geometric nGeom = (Geometric)it.next();
                if (nGeom == geom && sameInstance || this.coverByExclusion(nGeom)) continue;
                if (nGeom instanceof NodeInst) {
                    NodeInst ni = (NodeInst)nGeom;
                    NodeProto np = ni.getProto();
                    if (NodeInst.isSpecialNode(ni)) continue;
                    if (ni.isCellInstance()) {
                        AffineTransform rTransI = ni.rotateIn();
                        AffineTransform tTransI = ni.translateIn();
                        rTransI.preConcatenate(tTransI);
                        ((Rectangle2D)subBound).setRect(bounds);
                        DBMath.transformRect(subBound, rTransI);
                        CheckInst ci = this.checkInsts.get(ni);
                        int localIndex = cellGlobalIndex * ci.multiplier + ci.localIndex + ci.offset;
                        AffineTransform subTrans = ni.translateOut(ni.rotateOut());
                        subTrans.preConcatenate(upTrans);
                        if (!this.badBoxInArea(poly, layer, tech, net, geom, trans, globalIndex, subBound, (Cell)np, localIndex, topCell, topGlobalIndex, subTrans, multiCutData, sameInstance)) continue;
                        foundError = true;
                        if (this.reportInfo.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_EXHAUSTIVE) continue;
                        return true;
                    }
                    if (np.getTechnology() != tech || !this.validLayers.checkLayerWithNode(layer, np)) continue;
                    boolean touch = sameInstance && nGeom.isConnected(geom);
                    AffineTransform rTrans = ni.rotateOut();
                    rTrans.preConcatenate(upTrans);
                    Poly[] subPolyList = tech.getShapeOfNode(ni, true, this.reportInfo.ignoreCenterCuts, null);
                    this.convertPseudoLayers(ni, subPolyList);
                    int tot = subPolyList.length;
                    for (int i = 0; i < tot; ++i) {
                        subPolyList[i].transform(rTrans);
                    }
                    boolean multi = baseMulti;
                    Technology.MultiCutData niMCD = tech.getMultiCutData(ni);
                    if (!multi && isLayerAContact && niMCD != null && !(multi = tech.isMultiCutInTechnology(niMCD))) {
                        NodeInst gNi = (NodeInst)geom;
                        if (multiCutData == null || multiCutData.numCutsX() == 1) {
                            if (niMCD.numCutsY() != 1 && ni.getAnchorCenterX() != gNi.getAnchorCenterX()) {
                                multi = true;
                            }
                        } else if (niMCD.numCutsX() != 1 && ni.getAnchorCenterY() != gNi.getAnchorCenterY()) {
                            multi = true;
                        }
                    }
                    int multiInt = multi ? 1 : 0;
                    for (int j = 0; j < tot; ++j) {
                        Rectangle2D nPolyRect;
                        Poly npoly = subPolyList[j];
                        Layer nLayer = npoly.getLayer();
                        if (nLayer == null || this.coverByExclusion(npoly, nGeom.getParent()) || DBMath.isGreaterThan((nPolyRect = npoly.getBounds2D()).getMinX(), rBound.getMaxX()) || DBMath.isGreaterThan(rBound.getMinX(), nPolyRect.getMaxX()) || DBMath.isGreaterThan(nPolyRect.getMinY(), rBound.getMaxY()) || DBMath.isGreaterThan(rBound.getMinY(), nPolyRect.getMaxY())) continue;
                        int nNet = this.getDRCNetNumber(netlist, npoly.getPort(), ni, cellGlobalIndex);
                        boolean con = false;
                        if (nNet >= 0 && nNet == net) {
                            con = true;
                        }
                        if (ret = this.checkExtensionGateRule(geom, layer, poly, nLayer, npoly, netlist)) {
                            foundError = true;
                            if (this.reportInfo.errorTypeSearch != DRC.DRCCheckMode.ERROR_CHECK_EXHAUSTIVE) {
                                return true;
                            }
                        }
                        if (ret = this.checkCutSizes(np, geom, layer, poly, nGeom, nLayer, npoly, topCell)) {
                            foundError = true;
                            if (this.reportInfo.errorTypeSearch != DRC.DRCCheckMode.ERROR_CHECK_EXHAUSTIVE) {
                                return true;
                            }
                        }
                        if (con && touch) {
                            maytouch = DRC.mayTouch(tech, con, layer, nLayer);
                            trueBox1 = poly.getBox();
                            if (trueBox1 == null) {
                                trueBox1 = poly.getBounds2D();
                            }
                            if ((trueBox2 = npoly.getBox()) == null) {
                                trueBox1 = npoly.getBounds2D();
                            }
                            if (!(ret = this.checkMinDefects(cell, maytouch, geom, poly, trueBox1, layer, nGeom, npoly, trueBox2, nLayer, topCell))) continue;
                            foundError = true;
                            if (this.reportInfo.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_EXHAUSTIVE) continue;
                            return true;
                        }
                        edge = false;
                        theRule = this.getSpacingRule(layer, poly, geom, nLayer, npoly, ni, con, multiInt);
                        if (theRule == null) {
                            theRule = this.currentRules.getEdgeRule(layer, nLayer);
                            edge = true;
                        }
                        if (theRule == null || !(ret = this.checkDist(tech, topCell, topGlobalIndex, poly, layer, net, geom, trans, globalIndex, npoly, nLayer, nNet, nGeom, rTrans, cellGlobalIndex, con, theRule, edge))) continue;
                        foundError = true;
                        if (this.reportInfo.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_EXHAUSTIVE) continue;
                        return true;
                    }
                    continue;
                }
                ArcInst ai = (ArcInst)nGeom;
                ArcProto ap = ai.getProto();
                if (ap.getTechnology() != tech || !this.validLayers.checkLayerWithArc(layer, ap)) continue;
                boolean touch = sameInstance && nGeom.isConnected(geom);
                Network jNet = netlist.getNetwork(ai, 0);
                Integer[] netNumbers = this.networkLists.get(jNet);
                int nNet = netNumbers[cellGlobalIndex];
                boolean con = false;
                if (net >= 0 && nNet == net) {
                    con = true;
                }
                Poly[] subPolyList = tech.getShapeOfArc(ai);
                int tot = subPolyList.length;
                for (int i = 0; i < tot; ++i) {
                    subPolyList[i].transform(upTrans);
                }
                this.cropActiveArc(ai, subPolyList);
                boolean multi = baseMulti;
                int multiInt = multi ? 1 : 0;
                for (int j = 0; j < tot; ++j) {
                    Rectangle2D nPolyRect;
                    Poly nPoly = subPolyList[j];
                    Layer nLayer = nPoly.getLayer();
                    if (nLayer == null || this.coverByExclusion(nPoly, nGeom.getParent()) || (nPolyRect = nPoly.getBounds2D()).getMinX() > rBound.getMaxX() || nPolyRect.getMaxX() < rBound.getMinX() || nPolyRect.getMinY() > rBound.getMaxY() || nPolyRect.getMaxY() < rBound.getMinY()) continue;
                    ret = false;
                    if (con && touch) {
                        maytouch = DRC.mayTouch(tech, con, layer, nLayer);
                        trueBox1 = poly.getBox();
                        if (trueBox1 == null) {
                            trueBox1 = poly.getBounds2D();
                        }
                        if ((trueBox2 = nPoly.getBox()) == null) {
                            trueBox1 = nPoly.getBounds2D();
                        }
                        if (!(ret = this.checkMinDefects(cell, maytouch, geom, poly, trueBox1, layer, nGeom, nPoly, trueBox2, nLayer, topCell))) continue;
                        foundError = true;
                        if (this.reportInfo.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_EXHAUSTIVE) continue;
                        return true;
                    }
                    edge = false;
                    theRule = this.getSpacingRule(layer, poly, geom, nLayer, nPoly, ai, con, multiInt);
                    if (theRule == null) {
                        theRule = this.currentRules.getEdgeRule(layer, nLayer);
                        edge = true;
                    }
                    if (theRule == null) continue;
                    ret = this.checkDist(tech, topCell, topGlobalIndex, poly, layer, net, geom, trans, globalIndex, nPoly, nLayer, nNet, nGeom, upTrans, cellGlobalIndex, con, theRule, edge);
                    if (ret) {
                        foundError = true;
                        if (this.reportInfo.errorTypeSearch != DRC.DRCCheckMode.ERROR_CHECK_EXHAUSTIVE) {
                            return true;
                        }
                    }
                    if (!(ret = this.checkExtensionGateRule(geom, layer, poly, nLayer, nPoly, netlist))) continue;
                    foundError = true;
                    if (this.reportInfo.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_EXHAUSTIVE) continue;
                    return true;
                }
            }
            return foundError;
        }

        private boolean checkMinDefects(Cell cell, boolean maytouch, Geometric geom1, Poly poly1, Rectangle2D trueBox1, Layer layer1, Geometric geom2, Poly poly2, Rectangle2D trueBox2, Layer layer2, Cell topCell) {
            if (trueBox1 == null || trueBox2 == null) {
                return false;
            }
            if (!maytouch) {
                return false;
            }
            double pdx = DBMath.round(Math.max(trueBox2.getMinX() - trueBox1.getMaxX(), trueBox1.getMinX() - trueBox2.getMaxX()));
            double pdy = DBMath.round(Math.max(trueBox2.getMinY() - trueBox1.getMaxY(), trueBox1.getMinY() - trueBox2.getMaxY()));
            double pd = Math.max(pdx, pdy);
            if (DBMath.areEquals(pdx, 0.0) && DBMath.areEquals(pdy, 0.0)) {
                pd = 0.0;
            }
            boolean foundError = false;
            if (DBMath.isGreaterThan(pd, 0.0)) {
                return false;
            }
            DRCTemplate wRule = this.currentRules.getMinValue(layer1, DRCTemplate.DRCRuleType.MINWID);
            if (wRule == null) {
                return false;
            }
            double minWidth = wRule.getValue(0);
            double lxb = DBMath.round(Math.max(trueBox1.getMinX(), trueBox2.getMinX()));
            double hxb = DBMath.round(Math.min(trueBox1.getMaxX(), trueBox2.getMaxX()));
            double lyb = DBMath.round(Math.max(trueBox1.getMinY(), trueBox2.getMinY()));
            double hyb = DBMath.round(Math.min(trueBox1.getMaxY(), trueBox2.getMaxY()));
            Point2D.Double lowB = new Point2D.Double(lxb, lyb);
            Point2D.Double highB = new Point2D.Double(hxb, hyb);
            Rectangle2D.Double bounds = new Rectangle2D.Double(lxb, lyb, hxb - lxb, hyb - lyb);
            if (bounds.equals(trueBox1) || bounds.equals(trueBox2)) {
                return false;
            }
            double actual = lowB.distance(highB);
            if (DBMath.isGreaterThan(minWidth, actual) && this.foundSmallSizeDefect(cell, geom1, poly1, layer1, geom2, poly2, pd, lxb, lyb, hxb, hyb)) {
                DRC.createDRCErrorLogger(this.reportInfo, DRC.DRCErrorType.MINWIDTHERROR, null, topCell, minWidth, actual, wRule.ruleName, new Poly(bounds), null, layer1, null, null, layer2);
                foundError = true;
            }
            return foundError;
        }

        private boolean foundSmallSizeDefect(Cell cell, Geometric geom1, Poly poly1, Layer layer1, Geometric geom2, Poly poly2, double pd, double lxb, double lyb, double hxb, double hyb) {
            boolean foundError = false;
            boolean[] pointsFound = new boolean[2];
            pointsFound[1] = false;
            pointsFound[0] = false;
            Point2D.Double lowB = new Point2D.Double(lxb, lyb);
            Point2D.Double highB = new Point2D.Double(hxb, hyb);
            Rectangle2D.Double bounds = new Rectangle2D.Double(lxb, lyb, hxb - lxb, hyb - lyb);
            Poly rebuild = new Poly(bounds);
            Point2D pt1 = null;
            Point2D pt2 = null;
            Point2D.Double pt1d = null;
            Point2D.Double pt2d = null;
            Rectangle2D.Double search = new Rectangle2D.Double(DBMath.round(lxb - DRC.TINYDELTA), DBMath.round(lyb - DRC.TINYDELTA), DBMath.round(hxb - lxb + 2.0 * DRC.TINYDELTA), DBMath.round(hyb - lyb + 2.0 * DRC.TINYDELTA));
            if (pd == 0.0) {
                pt1 = lowB;
                pt2 = highB;
                pt1d = lowB;
                pt2d = highB;
            } else {
                double delta;
                Point2D[] points = rebuild.getPoints();
                int[] cornerPoints = new int[2];
                int corners = 0;
                for (int i = 0; i < points.length && corners < 2; ++i) {
                    if (DBMath.pointInsideRect(points[i], poly1.getBounds2D()) || DBMath.pointInsideRect(points[i], poly2.getBounds2D())) continue;
                    cornerPoints[corners++] = i;
                }
                if (corners != 2) {
                    throw new Error("Wrong corners in Quick.foundSmallSizeDefect()");
                }
                pt1 = points[cornerPoints[0]];
                pt2 = points[cornerPoints[1]];
                double d = delta = (pt2.getY() - pt1.getY()) / (pt2.getX() - pt1.getX()) > 0.0 ? 1.0 : -1.0;
                if (pt1.getX() < pt2.getX()) {
                    pt1d = new Point2D.Double(pt1.getX() - DRC.TINYDELTA, -delta * DRC.TINYDELTA + pt1.getY());
                    pt2d = new Point2D.Double(pt2.getX() + DRC.TINYDELTA, delta * DRC.TINYDELTA + pt2.getY());
                } else {
                    pt1d = new Point2D.Double(pt2.getX() - DRC.TINYDELTA, -delta * DRC.TINYDELTA + pt2.getY());
                    pt2d = new Point2D.Double(pt1.getX() + DRC.TINYDELTA, delta * DRC.TINYDELTA + pt1.getY());
                }
                if (DBMath.areEquals(pt1.getX(), pt2.getX()) || DBMath.areEquals(pt1.getY(), pt2.getY())) {
                    return false;
                }
            }
            DRC.lookForLayerCoverage(geom1, poly1, geom2, poly2, cell, layer1, DBMath.MATID, search, pt1d, pt2d, null, pointsFound, false, this.thisLayerFunction, false, this.reportInfo.ignoreCenterCuts);
            if (!pointsFound[0] && !pointsFound[1]) {
                foundError = true;
            }
            return foundError;
        }

        private boolean checkDist(Technology tech, Cell cell, int globalIndex, Poly poly1, Layer layer1, int net1, Geometric geom1, AffineTransform trans1, int globalIndex1, Poly poly2, Layer layer2, int net2, Geometric geom2, AffineTransform trans2, int globalIndex2, boolean con, DRCTemplate theRule, boolean edge) {
            Rectangle2D isBox2;
            Rectangle2D trueBox2;
            this.tinyNodeInst = null;
            Poly origPoly1 = poly1;
            Poly origPoly2 = poly2;
            Rectangle2D isBox1 = poly1.getBox();
            Rectangle2D trueBox1 = isBox1;
            if (trueBox1 == null) {
                trueBox1 = poly1.getBounds2D();
            }
            if ((trueBox2 = (isBox2 = poly2.getBox())) == null) {
                trueBox2 = poly2.getBounds2D();
            }
            boolean errorFound = false;
            boolean maytouch = DRC.mayTouch(tech, con, layer1, layer2);
            double pd = 0.0;
            boolean overlap = false;
            if (isBox1 != null && isBox2 != null) {
                double pdx = DBMath.round(Math.max(trueBox2.getMinX() - trueBox1.getMaxX(), trueBox1.getMinX() - trueBox2.getMaxX()));
                double pdy = DBMath.round(Math.max(trueBox2.getMinY() - trueBox1.getMaxY(), trueBox1.getMinY() - trueBox2.getMaxY()));
                pd = Math.max(pdx, pdy);
                if (DBMath.areEquals(pdx, 0.0) && DBMath.areEquals(pdy, 0.0)) {
                    pd = 0.0;
                }
                overlap = DBMath.isLessThan(pd, 0.0);
                if (maytouch && this.checkMinDefects(cell, maytouch, geom1, poly1, trueBox1, layer2, geom2, poly2, trueBox2, layer2, cell)) {
                    if (this.reportInfo.errorTypeSearch != DRC.DRCCheckMode.ERROR_CHECK_EXHAUSTIVE) {
                        return true;
                    }
                    errorFound = true;
                }
                trueBox1 = new Rectangle2D.Double(trueBox1.getMinX(), trueBox1.getMinY(), trueBox1.getWidth(), trueBox1.getHeight());
                trueBox2 = new Rectangle2D.Double(trueBox2.getMinX(), trueBox2.getMinY(), trueBox2.getWidth(), trueBox2.getHeight());
                boolean geom1IsNode = geom1 instanceof NodeInst;
                boolean geom2IsNode = geom2 instanceof NodeInst;
                if (!geom1IsNode && this.cropArcInst((ArcInst)geom1, layer1, trans1, trueBox1, overlap)) {
                    return errorFound;
                }
                if (!geom2IsNode && this.cropArcInst((ArcInst)geom2, layer2, trans2, trueBox2, overlap)) {
                    return errorFound;
                }
                if (geom1IsNode && this.cropNodeInst((NodeInst)geom1, globalIndex1, trans1, layer2, net2, geom2, trueBox2)) {
                    return errorFound;
                }
                if (geom2 instanceof NodeInst && this.cropNodeInst((NodeInst)geom2, globalIndex2, trans2, layer1, net1, geom1, trueBox1)) {
                    return errorFound;
                }
                poly1 = new Poly(trueBox1);
                poly1.setStyle(Poly.Type.FILLED);
                poly2 = new Poly(trueBox2);
                poly2.setStyle(Poly.Type.FILLED);
                double lX1 = trueBox1.getMinX();
                double hX1 = trueBox1.getMaxX();
                double lY1 = trueBox1.getMinY();
                double hY1 = trueBox1.getMaxY();
                double lX2 = trueBox2.getMinX();
                double hX2 = trueBox2.getMaxX();
                double lY2 = trueBox2.getMinY();
                double hY2 = trueBox2.getMaxY();
                if (edge) {
                    double pdedge = DBMath.round(Math.min(Math.min(Math.min(Math.abs(lX1 - lX2), Math.abs(lX1 - hX2)), Math.min(Math.abs(hX1 - lX2), Math.abs(hX1 - hX2))), Math.min(Math.min(Math.abs(lY1 - lY2), Math.abs(lY1 - hY2)), Math.min(Math.abs(hY1 - lY2), Math.abs(hY1 - hY2)))));
                    pd = Math.max(pd, pdedge);
                } else {
                    pdx = DBMath.round(Math.max(lX2 - hX1, lX1 - hX2));
                    pdy = DBMath.round(Math.max(lY2 - hY1, lY1 - hY2));
                    if (DBMath.areEquals(pdx, 0.0) && DBMath.areEquals(pdy, 0.0)) {
                        pd = 0.0;
                    } else {
                        pd = Math.max(pdx, pdy);
                        if (pd < theRule.getValue(0) && pd > 0.0) {
                            pd = poly1.separation(poly2);
                        }
                    }
                }
            } else {
                Poly.Type style = poly1.getStyle();
                if (style != Poly.Type.FILLED && style != Poly.Type.CLOSED && style != Poly.Type.CROSSED && style != Poly.Type.OPENED && style != Poly.Type.OPENEDT1 && style != Poly.Type.OPENEDT2 && style != Poly.Type.OPENEDT3 && style != Poly.Type.VECTORS) {
                    return errorFound;
                }
                style = poly2.getStyle();
                if (style != Poly.Type.FILLED && style != Poly.Type.CLOSED && style != Poly.Type.CROSSED && style != Poly.Type.OPENED && style != Poly.Type.OPENEDT1 && style != Poly.Type.OPENEDT2 && style != Poly.Type.OPENEDT3 && style != Poly.Type.VECTORS) {
                    return errorFound;
                }
                double pd1 = poly1.separation(poly2);
                if (!DBMath.areEquals(pd1, pd = poly1.intersects(poly2) ? 0.0 : poly1.separation(poly2))) {
                    System.out.println("Wrong case in non-nonmanhattan, Quick.");
                }
            }
            DRC.DRCErrorType errorType = DRC.DRCErrorType.SPACINGERROR;
            if (theRule.ruleType == DRCTemplate.DRCRuleType.SURROUND) {
                if (DBMath.isGreaterThan(pd, 0.0)) {
                    return errorFound;
                }
                pd = Math.abs(pd);
                errorType = DRC.DRCErrorType.SURROUNDERROR;
            }
            if (!DBMath.isGreaterThan(theRule.getValue(0), pd)) {
                return errorFound;
            }
            if (theRule.ruleType != DRCTemplate.DRCRuleType.SURROUND) {
                if (this.activeOnTransistor(poly1, layer1, net1, poly2, layer2, net2, cell, globalIndex)) {
                    return errorFound;
                }
                if (this.polyCoverByAnyVTLayer(cell, theRule, tech, new Poly[]{poly1, poly2}, new Layer[]{layer1, layer2}, new Geometric[]{geom1, geom2}, this.reportInfo.ignoreCenterCuts)) {
                    return errorFound;
                }
                if (tech.sameLayer(layer1, layer2) && maytouch) {
                    if (DBMath.isLessThanOrEqualTo(pd, 0.0)) {
                        return errorFound;
                    }
                    boolean newR = this.lookForCrossPolygons(geom1, poly1, geom2, poly2, layer1, cell, overlap);
                    if (newR) {
                        return errorFound;
                    }
                    errorType = DRC.DRCErrorType.NOTCHERROR;
                }
            }
            String msg = null;
            if (!(this.tinyNodeInst == null || this.tinyNodeInst != geom1 && this.tinyNodeInst != geom2 || this.tinyGeometric != geom1 && this.tinyGeometric != geom2)) {
                msg = this.tinyNodeInst + " is too small for the " + this.tinyGeometric;
            }
            DRC.createDRCErrorLogger(this.reportInfo, errorType, msg, cell, theRule.getValue(0), pd, theRule.ruleName, origPoly1, geom1, layer1, origPoly2, geom2, layer2);
            return true;
        }

        private void checkTheseGeometrics(Cell cell, int count, Geometric[] geomsToCheck, boolean[] validity) {
            CheckProto cp = this.getCheckProto(cell);
            for (int i = 0; i < count; ++i) {
                Geometric geomToCheck = geomsToCheck[i];
                boolean errors = false;
                if (geomToCheck instanceof NodeInst) {
                    NodeInst ni = (NodeInst)geomToCheck;
                    errors = ni.isCellInstance() ? this.checkThisCellPlease(ni) : this.checkNodeInst(ni, 0);
                } else {
                    ArcInst ai = (ArcInst)geomToCheck;
                    errors = this.checkArcInst(cp, ai, 0);
                }
                if (validity == null) continue;
                validity[i] = !errors;
            }
        }

        private boolean checkThisCellPlease(NodeInst ni) {
            Cell cell = ni.getParent();
            Netlist netlist = this.getCheckProto((Cell)cell).netlist;
            int globalIndex = 0;
            AffineTransform upTrans = ni.translateOut(ni.rotateOut());
            CheckInst ci = this.checkInsts.get(ni);
            if (ci == null) {
                return false;
            }
            int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
            Rectangle2D nodeBounds = ni.getBounds();
            double worstInteractionDistance = this.reportInfo.worstInteractionDistance;
            Rectangle2D.Double searchBounds = new Rectangle2D.Double(nodeBounds.getMinX() - worstInteractionDistance, nodeBounds.getMinY() - worstInteractionDistance, nodeBounds.getWidth() + worstInteractionDistance * 2.0, nodeBounds.getHeight() + worstInteractionDistance * 2.0);
            Iterator<RTBounds> it = cell.searchIterator(searchBounds);
            while (it.hasNext()) {
                Rectangle2D subNodeBounds;
                Rectangle2D.Double subBounds;
                NodeInst oNi;
                Geometric geom = (Geometric)it.next();
                if (geom == ni || !(geom instanceof ArcInst ? this.checkGeomAgainstInstance(netlist, geom, ni) : ((oNi = (NodeInst)geom).getProto() instanceof PrimitiveNode ? this.checkGeomAgainstInstance(netlist, geom, ni) : this.checkCellInstContents(subBounds = new Rectangle2D.Double((subNodeBounds = oNi.getBounds()).getMinX() - worstInteractionDistance, subNodeBounds.getMinY() - worstInteractionDistance, subNodeBounds.getWidth() + worstInteractionDistance * 2.0, subNodeBounds.getHeight() + worstInteractionDistance * 2.0), ni, upTrans, localIndex, oNi, null, globalIndex, null)))) continue;
                return true;
            }
            return false;
        }

        private boolean checkGeomAgainstInstance(Netlist netlist, Geometric geom, NodeInst ni) {
            NodeProto np = ni.getProto();
            int globalIndex = 0;
            Cell subCell = geom.getParent();
            Technology.MultiCutData multiCutData = null;
            Technology tech = null;
            Poly[] nodeInstPolyList = null;
            AffineTransform trans = DBMath.MATID;
            if (geom instanceof NodeInst) {
                NodeInst oNi = (NodeInst)geom;
                if (NodeInst.isSpecialNode(oNi)) {
                    return false;
                }
                tech = oNi.getProto().getTechnology();
                trans = oNi.rotateOut();
                nodeInstPolyList = tech.getShapeOfNode(oNi, true, this.reportInfo.ignoreCenterCuts, this.thisLayerFunction);
                this.convertPseudoLayers(oNi, nodeInstPolyList);
                multiCutData = tech.getMultiCutData(oNi);
            } else {
                ArcInst oAi = (ArcInst)geom;
                tech = oAi.getProto().getTechnology();
                assert (false);
                nodeInstPolyList = tech.getShapeOfArc(oAi, this.thisLayerFunction);
            }
            if (nodeInstPolyList == null) {
                return false;
            }
            int tot = nodeInstPolyList.length;
            CheckInst ci = this.checkInsts.get(ni);
            if (ci == null) {
                return false;
            }
            int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
            for (int j = 0; j < tot; ++j) {
                int net;
                double maxSize;
                double bound;
                Poly poly = nodeInstPolyList[j];
                Layer polyLayer = poly.getLayer();
                if (polyLayer == null || (bound = this.currentRules.getMaxSurround(polyLayer, maxSize = poly.getMaxSize())) < 0.0) continue;
                if (geom instanceof NodeInst) {
                    net = this.getDRCNetNumber(netlist, poly.getPort(), (NodeInst)geom, globalIndex);
                } else {
                    ArcInst oAi = (ArcInst)geom;
                    Network jNet = netlist.getNetwork(oAi, 0);
                    Integer[] netNumbers = this.networkLists.get(jNet);
                    net = netNumbers[globalIndex];
                }
                Rectangle2D polyBounds = poly.getBounds2D();
                Rectangle2D.Double subBounds = new Rectangle2D.Double(polyBounds.getMinX() - bound, polyBounds.getMinY() - bound, polyBounds.getWidth() + bound * 2.0, polyBounds.getHeight() + bound * 2.0);
                AffineTransform tempTrans = ni.rotateIn();
                AffineTransform tTransI = ni.translateIn();
                tempTrans.preConcatenate(tTransI);
                DBMath.transformRect(subBounds, tempTrans);
                AffineTransform subTrans = ni.translateOut(ni.rotateOut());
                if (!this.badBoxInArea(poly, polyLayer, tech, net, geom, trans, globalIndex, subBounds, (Cell)np, localIndex, subCell, globalIndex, subTrans, multiCutData, false)) continue;
                return true;
            }
            return false;
        }

        private boolean checkInteraction(NodeInst ni1, NodeInst n1Parent, NodeInst ni2, NodeInst n2Parent, NodeInst triggerNi) {
            if (this.reportInfo.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_EXHAUSTIVE) {
                return false;
            }
            CheckProto cp = this.getCheckProto((Cell)ni1.getProto());
            if (cp.cellParameterized) {
                return false;
            }
            cp = this.getCheckProto((Cell)ni2.getProto());
            if (cp.cellParameterized) {
                return false;
            }
            InstanceInter dii = new InstanceInter();
            if (ni1.getNodeIndex() < ni2.getNodeIndex()) {
                NodeInst swapni = ni1;
                ni1 = ni2;
                ni2 = swapni;
            } else if (ni1 == ni2) {
                int node1Orientation = ni1.getAngle();
                if (ni1.isMirroredAboutXAxis()) {
                    node1Orientation += 3600;
                }
                if (ni1.isMirroredAboutYAxis()) {
                    node1Orientation += 7200;
                }
                int node2Orientation = ni2.getAngle();
                if (ni2.isMirroredAboutXAxis()) {
                    node2Orientation += 3600;
                }
                if (ni2.isMirroredAboutYAxis()) {
                    node2Orientation += 7200;
                }
                if (node1Orientation < node2Orientation) {
                    NodeInst swapNI = ni1;
                    ni1 = ni2;
                    ni2 = swapNI;
                    System.out.println("Check this case in Quick.checkInteraction");
                }
            }
            dii.cell1 = (Cell)ni1.getProto();
            dii.or1 = ni1.getOrient();
            dii.cell2 = (Cell)ni2.getProto();
            dii.or2 = ni2.getOrient();
            dii.dx = ni2.getAnchorCenterX() - ni1.getAnchorCenterX();
            dii.dy = ni2.getAnchorCenterY() - ni1.getAnchorCenterY();
            dii.n1Parent = n1Parent;
            dii.n2Parent = n2Parent;
            dii.triggerNi = triggerNi;
            if (this.findInteraction(dii)) {
                return true;
            }
            this.instanceInteractionList.add(dii);
            return false;
        }

        private boolean findInteraction(InstanceInter dii) {
            for (InstanceInter thisII : this.instanceInteractionList) {
                if (thisII.cell1 != dii.cell1 || thisII.cell2 != dii.cell2 || !thisII.or1.equals(dii.or1) || !thisII.or2.equals(dii.or2) || thisII.dx != dii.dx || thisII.dy != dii.dy || thisII.n1Parent != dii.n1Parent || thisII.n2Parent != dii.n2Parent || dii.triggerNi != thisII.triggerNi) continue;
                return true;
            }
            return false;
        }

        private CheckProto checkEnumerateProtos(Cell cell, Netlist netlist) {
            CheckProto cp = this.getCheckProto(cell);
            if (cp != null) {
                return cp;
            }
            cp = new CheckProto();
            cp.instanceCount = 0;
            cp.timeStamp = 0;
            cp.hierInstanceCount = 0;
            cp.totalPerCell = 0;
            cp.cellChecked = false;
            cp.cellParameterized = false;
            cp.netlist = netlist;
            if (cell.hasParameters()) {
                cp.cellParameterized = true;
            }
            this.checkProtos.put(cell, cp);
            Iterator<NodeInst> nIt = cell.getNodes();
            while (nIt.hasNext()) {
                NodeInst ni = nIt.next();
                if (!ni.isCellInstance() || ni.isIconOfParent()) continue;
                Cell subCell = (Cell)ni.getProto();
                CheckInst ci = new CheckInst();
                this.checkInsts.put(ni, ci);
                CheckProto subCP = this.checkEnumerateProtos(subCell, netlist.getNetlist(ni));
            }
            return cp;
        }

        private final CheckProto getCheckProto(Cell cell) {
            return this.checkProtos.get(cell);
        }

        private void checkEnumerateInstances(Cell cell) {
            NodeProto np;
            NodeInst ni;
            if (MTDRCLayoutTool.this.checkAbort()) {
                return;
            }
            ++this.reportInfo.checkTimeStamp;
            ArrayList<CheckProto> subCheckProtos = new ArrayList<CheckProto>();
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                ni = it.next();
                np = ni.getProto();
                if (!ni.isCellInstance() || ni.isIconOfParent()) continue;
                CheckProto cp = this.getCheckProto((Cell)np);
                if (cp.timeStamp != this.reportInfo.checkTimeStamp) {
                    cp.timeStamp = this.reportInfo.checkTimeStamp;
                    cp.instanceCount = 0;
                    cp.nodesInCell = new ArrayList<CheckInst>();
                    subCheckProtos.add(cp);
                }
                CheckInst ci = this.checkInsts.get(ni);
                ++cp.instanceCount;
                ci.localIndex = ci.localIndex;
                cp.nodesInCell.add(ci);
            }
            for (CheckProto cp : subCheckProtos) {
                cp.hierInstanceCount += cp.instanceCount;
                for (CheckInst ci : cp.nodesInCell) {
                    ci.multiplier = cp.instanceCount;
                }
            }
            it = cell.getNodes();
            while (it.hasNext()) {
                ni = it.next();
                np = ni.getProto();
                if (!ni.isCellInstance() || ni.isIconOfParent()) continue;
                this.checkEnumerateInstances((Cell)np);
            }
        }

        private void checkEnumerateNetworks(Cell cell, CheckProto cp, int globalIndex, HashMap<Network, Integer> enumeratedNets) {
            Iterator<Network> nIt = cp.netlist.getNetworks();
            while (nIt.hasNext()) {
                Network net = nIt.next();
                Integer netNumber = enumeratedNets.get(net);
                Integer[] netNumbers = this.networkLists.get(net);
                netNumbers[globalIndex] = netNumber;
            }
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                NodeProto np = ni.getProto();
                if (!ni.isCellInstance() || ni.isIconOfParent()) continue;
                CheckInst ci = this.checkInsts.get(ni);
                int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
                Cell subCell = (Cell)np;
                CheckProto subCP = this.getCheckProto(subCell);
                HashMap<Network, Integer> subEnumeratedNets = new HashMap<Network, Integer>();
                Iterator<PortInst> pIt = ni.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi = pIt.next();
                    Export subPP = (Export)pi.getPortProto();
                    Network net = cp.netlist.getNetwork(ni, subPP, 0);
                    if (net == null) continue;
                    Integer netNumber = enumeratedNets.get(net);
                    Network subNet = subCP.netlist.getNetwork(subPP, 0);
                    subEnumeratedNets.put(subNet, netNumber);
                }
                Iterator<Network> nIt2 = subCP.netlist.getNetworks();
                while (nIt2.hasNext()) {
                    Network net = nIt2.next();
                    if (subEnumeratedNets.get(net) != null) continue;
                    subEnumeratedNets.put(net, new Integer(this.reportInfo.checkNetNumber++));
                }
                this.checkEnumerateNetworks(subCell, subCP, localIndex, subEnumeratedNets);
            }
        }

        private boolean searchForCondLayer(Geometric geom, Poly poly, Layer layer, Cell cell, boolean ignoreCenterCuts) {
            Rectangle2D polyBnd = poly.getBounds2D();
            double midPointX = (polyBnd.getMinX() + polyBnd.getMaxX()) / 2.0;
            double midPointY = (polyBnd.getMinY() + polyBnd.getMaxY()) / 2.0;
            Point2D.Double pt1 = new Point2D.Double(midPointX, polyBnd.getMinY());
            Point2D.Double pt2 = new Point2D.Double(midPointX, polyBnd.getMaxY());
            Point2D.Double pt3 = new Point2D.Double(midPointX, midPointY);
            Rectangle2D.Double bnd = new Rectangle2D.Double(DBMath.round(polyBnd.getMinX() - DRC.TINYDELTA), DBMath.round(polyBnd.getMinY() - DRC.TINYDELTA), DBMath.round(polyBnd.getWidth() + 2.0 * DRC.TINYDELTA), DBMath.round(polyBnd.getHeight() + 2.0 * DRC.TINYDELTA));
            boolean[] pointsFound = new boolean[3];
            pointsFound[2] = false;
            pointsFound[1] = false;
            pointsFound[0] = false;
            boolean found = DRC.lookForLayerCoverage(geom, poly, null, null, cell, layer, DBMath.MATID, bnd, pt1, pt2, pt3, pointsFound, true, null, false, ignoreCenterCuts);
            if (!found) {
                return found;
            }
            ((Point2D)pt1).setLocation(polyBnd.getMinX(), midPointY);
            ((Point2D)pt2).setLocation(polyBnd.getMaxX(), midPointY);
            pointsFound[1] = false;
            pointsFound[0] = false;
            pointsFound[2] = true;
            found = DRC.lookForLayerCoverage(geom, poly, null, null, cell, layer, DBMath.MATID, bnd, pt1, pt2, null, pointsFound, true, null, false, ignoreCenterCuts);
            return found;
        }

        private boolean checkMinWidth(Geometric geom, Layer layer, Poly poly, boolean onlyOne) {
            DRCTemplate minWidthRule = this.currentRules.getMinValue(layer, DRCTemplate.DRCRuleType.MINWID);
            boolean errorDefault = false;
            if (minWidthRule != null && !(errorDefault = DRC.checkMinWidthInternal(geom, layer, poly, onlyOne, minWidthRule, false, this.thisLayerFunction, this.reportInfo))) {
                return false;
            }
            DRCTemplate minWidthRuleCond = this.currentRules.getMinValue(layer, DRCTemplate.DRCRuleType.MINWIDCOND);
            if (minWidthRuleCond == null || !minWidthRuleCond.condition.startsWith("overlap(")) {
                if (errorDefault) {
                    DRC.checkMinWidthInternal(geom, layer, poly, onlyOne, minWidthRule, true, this.thisLayerFunction, this.reportInfo);
                }
                return errorDefault;
            }
            String[] layers = TextUtils.parseString(minWidthRuleCond.condition.substring(7), "(,)");
            boolean found = false;
            for (String la : layers) {
                Layer l = layer.getTechnology().findLayer(la);
                found = this.searchForCondLayer(geom, poly, l, geom.getParent(), this.reportInfo.ignoreCenterCuts);
                if (!found) break;
            }
            if (found) {
                errorDefault = DRC.checkMinWidthInternal(geom, layer, poly, onlyOne, minWidthRuleCond, true, this.thisLayerFunction, this.reportInfo);
            } else if (errorDefault) {
                DRC.checkMinWidthInternal(geom, layer, poly, onlyOne, minWidthRule, true, this.thisLayerFunction, this.reportInfo);
            }
            return errorDefault;
        }

        private void traversePolyTree(Layer layer, PolyBase.PolyBaseTree obj, int level, DRCTemplate minAreaRule, DRCTemplate encloseAreaRule, DRCTemplate spacingRule, Cell cell, GenMath.MutableInteger count) {
            List<PolyBase.PolyBaseTree> sons = obj.getSons();
            for (PolyBase.PolyBaseTree son : sons) {
                this.traversePolyTree(layer, son, level + 1, minAreaRule, encloseAreaRule, spacingRule, cell, count);
            }
            boolean minAreaCheck = level % 2 == 0;
            boolean checkMin = false;
            boolean checkNotch = false;
            DRC.DRCErrorType errorType = DRC.DRCErrorType.MINAREAERROR;
            double minVal = 0.0;
            String ruleName = "";
            if (minAreaCheck) {
                if (minAreaRule == null) {
                    return;
                }
                minVal = minAreaRule.getValue(0);
                ruleName = minAreaRule.ruleName;
                checkMin = true;
            } else {
                errorType = DRC.DRCErrorType.ENCLOSEDAREAERROR;
                if (encloseAreaRule != null) {
                    minVal = encloseAreaRule.getValue(0);
                    ruleName = encloseAreaRule.ruleName;
                    checkMin = true;
                }
                checkNotch = spacingRule != null;
            }
            PolyBase poly = obj.getPoly();
            if (checkMin) {
                double area = poly.getArea();
                if (!DBMath.isGreaterThan(minVal, area)) {
                    return;
                }
                count.increment();
                DRC.createDRCErrorLogger(this.reportInfo, errorType, null, cell, minVal, area, ruleName, poly, null, layer, null, null, null);
            }
            if (checkNotch) {
                Rectangle2D bnd = poly.getBounds2D();
                if (bnd.getWidth() < spacingRule.getValue(0)) {
                    count.increment();
                    DRC.createDRCErrorLogger(this.reportInfo, DRC.DRCErrorType.NOTCHERROR, "(X axis)", cell, spacingRule.getValue(0), bnd.getWidth(), spacingRule.ruleName, poly, null, layer, null, null, layer);
                }
                if (bnd.getHeight() < spacingRule.getValue(1)) {
                    count.increment();
                    DRC.createDRCErrorLogger(this.reportInfo, DRC.DRCErrorType.NOTCHERROR, "(Y axis)", cell, spacingRule.getValue(1), bnd.getHeight(), spacingRule.ruleName, poly, null, layer, null, null, layer);
                }
            }
        }

        private int findInterveningPoints(Poly poly1, Poly poly2, Point2D pt1, Point2D pt2, boolean newFix) {
            Rectangle2D isBox1 = poly1.getBox();
            Rectangle2D isBox2 = poly2.getBox();
            if (newFix) {
                if (isBox1 == null) {
                    isBox1 = poly1.getBounds2D();
                }
                if (isBox2 == null) {
                    isBox2 = poly2.getBounds2D();
                }
            }
            if (isBox1 != null && isBox2 != null) {
                if (isBox1.getMinX() > isBox2.getMaxX() || isBox2.getMinX() > isBox1.getMaxX()) {
                    if (isBox1.getMinY() <= isBox2.getMaxY() && isBox2.getMinY() <= isBox1.getMaxY()) {
                        double yf1 = Math.max(isBox1.getMinY(), isBox2.getMinY());
                        double yf2 = Math.min(isBox1.getMaxY(), isBox2.getMaxY());
                        if (isBox1.getMinX() > isBox2.getMaxX()) {
                            double x = (isBox1.getMinX() + isBox2.getMaxX()) / 2.0;
                            pt1.setLocation(x, yf1);
                            pt2.setLocation(x, yf2);
                        } else {
                            double x = (isBox2.getMinX() + isBox1.getMaxX()) / 2.0;
                            pt1.setLocation(x, yf1);
                            pt2.setLocation(x, yf2);
                        }
                        return 2;
                    }
                } else if (isBox1.getMinY() > isBox2.getMaxY() || isBox2.getMinY() > isBox1.getMaxY()) {
                    if (isBox1.getMinX() <= isBox2.getMaxX() && isBox2.getMinX() <= isBox1.getMaxX()) {
                        double xf1 = Math.max(isBox1.getMinX(), isBox2.getMinX());
                        double xf2 = Math.min(isBox1.getMaxX(), isBox2.getMaxX());
                        if (isBox1.getMinY() > isBox2.getMaxY()) {
                            double y = (isBox1.getMinY() + isBox2.getMaxY()) / 2.0;
                            pt1.setLocation(xf1, y);
                            pt2.setLocation(xf2, y);
                        } else {
                            double y = (isBox2.getMinY() + isBox1.getMaxY()) / 2.0;
                            pt1.setLocation(xf1, y);
                            pt2.setLocation(xf2, y);
                        }
                        return 2;
                    }
                } else if (isBox1.getMinX() == isBox2.getMaxX() || isBox2.getMinX() == isBox1.getMaxX() || isBox1.getMinY() == isBox2.getMaxY() || isBox2.getMinY() == isBox2.getMaxY()) {
                    double xc = isBox2.getMinX();
                    if (isBox1.getMinX() == isBox2.getMaxX()) {
                        xc = isBox1.getMinX();
                    }
                    double yc = isBox2.getMinY();
                    if (isBox1.getMinY() == isBox2.getMaxY()) {
                        yc = isBox1.getMinY();
                    }
                    double xPlus = xc + DRC.TINYDELTA;
                    double yPlus = yc + DRC.TINYDELTA;
                    pt1.setLocation(xPlus, yPlus);
                    pt2.setLocation(xPlus, yPlus);
                    if ((xPlus < isBox1.getMinX() || xPlus > isBox1.getMaxX() || yPlus < isBox1.getMinY() || yPlus > isBox1.getMaxY()) && (xPlus < isBox2.getMinX() || xPlus > isBox2.getMaxX() || yPlus < isBox2.getMinY() || yPlus > isBox2.getMaxY())) {
                        return 1;
                    }
                    pt1.setLocation(xc + DRC.TINYDELTA, yc - DRC.TINYDELTA);
                    pt2.setLocation(xc - DRC.TINYDELTA, yc + DRC.TINYDELTA);
                    return 1;
                }
                if (isBox1.getMinX() > isBox2.getMaxX()) {
                    if (isBox1.getMinY() > isBox2.getMaxY()) {
                        pt1.setLocation(isBox1.getMinX(), isBox1.getMinY());
                        pt2.setLocation(isBox2.getMaxX(), isBox2.getMaxY());
                        return 1;
                    }
                    if (isBox2.getMinY() > isBox1.getMaxY()) {
                        pt1.setLocation(isBox1.getMinX(), isBox1.getMaxY());
                        pt2.setLocation(isBox2.getMaxX(), isBox2.getMinY());
                        return 1;
                    }
                }
                if (isBox2.getMinX() > isBox1.getMaxX()) {
                    if (isBox1.getMinY() > isBox2.getMaxY()) {
                        pt1.setLocation(isBox1.getMaxX(), isBox1.getMinY());
                        pt2.setLocation(isBox2.getMinX(), isBox2.getMaxY());
                        return 1;
                    }
                    if (isBox2.getMinY() > isBox1.getMaxY()) {
                        pt1.setLocation(isBox1.getMaxX(), isBox1.getMaxY());
                        pt2.setLocation(isBox2.getMinX(), isBox2.getMinY());
                        return 1;
                    }
                }
            }
            isBox1 = poly1.getBounds2D();
            isBox2 = poly2.getBounds2D();
            pt1.setLocation((isBox1.getMinX() + isBox1.getMaxX()) / 2.0, (isBox2.getMinY() + isBox2.getMaxY()) / 2.0);
            pt2.setLocation((isBox2.getMinX() + isBox2.getMaxX()) / 2.0, (isBox1.getMinY() + isBox1.getMaxY()) / 2.0);
            return 1;
        }

        private boolean lookForCrossPolygons(Geometric geo1, Poly poly1, Geometric geo2, Poly poly2, Layer layer, Cell cell, boolean overlap) {
            Point2D.Double pt1 = new Point2D.Double();
            Point2D.Double pt2 = new Point2D.Double();
            this.findInterveningPoints(poly1, poly2, pt1, pt2, true);
            double flx = Math.min(((Point2D)pt1).getX(), ((Point2D)pt2).getX());
            double fhx = Math.max(((Point2D)pt1).getX(), ((Point2D)pt2).getX());
            double fly = Math.min(((Point2D)pt1).getY(), ((Point2D)pt2).getY());
            double fhy = Math.max(((Point2D)pt1).getY(), ((Point2D)pt2).getY());
            Rectangle2D.Double bounds = new Rectangle2D.Double(DBMath.round(flx - DRC.TINYDELTA), DBMath.round(fly - DRC.TINYDELTA), DBMath.round(fhx - flx + 2.0 * DRC.TINYDELTA), DBMath.round(fhy - fly + 2.0 * DRC.TINYDELTA));
            boolean[] pointsFound = new boolean[2];
            pointsFound[1] = false;
            pointsFound[0] = false;
            boolean allFound = DRC.lookForLayerCoverage(geo1, poly1, geo2, poly2, cell, layer, DBMath.MATID, bounds, pt1, pt2, null, pointsFound, overlap, this.thisLayerFunction, false, this.reportInfo.ignoreCenterCuts);
            return allFound;
        }

        private boolean lookForLayerWithPoints(Geometric geo1, Poly poly1, Geometric geo2, Poly poly2, Cell cell, Layer layer, AffineTransform moreTrans, Rectangle2D bounds, Point2D[] pts, boolean[] pointsFound, int length, boolean overlap) {
            assert (pts.length == pointsFound.length);
            Rectangle2D.Double newBounds = new Rectangle2D.Double();
            Iterator<RTBounds> it = cell.searchIterator(bounds);
            block0: while (it.hasNext()) {
                int j;
                RTBounds g = it.next();
                if (g instanceof NodeInst) {
                    NodeInst ni = (NodeInst)g;
                    if (NodeInst.isSpecialNode(ni)) continue;
                    if (ni.isCellInstance()) {
                        AffineTransform rotI = ni.rotateIn();
                        AffineTransform transI = ni.translateIn();
                        rotI.preConcatenate(transI);
                        ((Rectangle2D)newBounds).setRect(bounds);
                        DBMath.transformRect(newBounds, rotI);
                        AffineTransform trans = ni.translateOut(ni.rotateOut());
                        trans.preConcatenate(moreTrans);
                        if (!this.lookForLayerWithPoints(geo1, poly1, geo2, poly2, (Cell)ni.getProto(), layer, trans, newBounds, pts, pointsFound, length, overlap)) continue;
                        return true;
                    }
                    AffineTransform bound = ni.rotateOut();
                    bound.preConcatenate(moreTrans);
                    Technology tech = ni.getProto().getTechnology();
                    for (Poly poly : tech.getShapeOfNode(ni, false, this.reportInfo.ignoreCenterCuts, this.thisLayerFunction)) {
                        if (!tech.sameLayer(poly.getLayer(), layer)) continue;
                        poly.transform(bound);
                        if (poly1 != null && !overlap && poly.polySame(poly1) || poly2 != null && !overlap && poly.polySame(poly2)) continue;
                        for (j = 0; j < length; ++j) {
                            if (pointsFound[j] || !poly.isInside(pts[j])) continue;
                            pointsFound[j] = true;
                        }
                        for (j = 0; j < length && pointsFound[j]; ++j) {
                        }
                        if (j != length) continue block0;
                        return true;
                    }
                    continue;
                }
                ArcInst ai = (ArcInst)g;
                Technology tech = ai.getProto().getTechnology();
                for (Poly poly : tech.getShapeOfArc(ai, this.thisLayerFunction)) {
                    if (!tech.sameLayer(poly.getLayer(), layer)) continue;
                    poly.transform(moreTrans);
                    for (j = 0; j < length; ++j) {
                        if (pointsFound[j] || !poly.isInside(pts[j])) continue;
                        pointsFound[j] = true;
                    }
                    for (j = 0; j < length && pointsFound[j]; ++j) {
                    }
                    if (j != length) continue block0;
                    return true;
                }
            }
            return false;
        }

        private boolean checkCutSizes(NodeProto np, Geometric geom, Layer layer, Poly poly, Geometric nGeom, Layer nLayer, Poly nPoly, Cell topCell) {
            String ruleName;
            if (!(np instanceof PrimitiveNode && layer == nLayer && layer.getFunction().isContact() && nLayer.getFunction().isContact())) {
                return false;
            }
            PrimitiveNode nty = (PrimitiveNode)np;
            Technology.NodeLayer cutLayer = nty.findMulticut();
            if (cutLayer == null) {
                return false;
            }
            double cutSizeX = cutLayer.getMulticutSizeX();
            double cutSizeY = cutLayer.getMulticutSizeY();
            Rectangle2D box1 = poly.getBounds2D();
            Rectangle2D box2 = nPoly.getBounds2D();
            double pdx = DBMath.round(Math.max(box2.getMinX() - box1.getMaxX(), box1.getMinX() - box2.getMaxX()));
            double pdy = DBMath.round(Math.max(box2.getMinY() - box1.getMaxY(), box1.getMinY() - box2.getMaxY()));
            double pd = Math.max(pdx, pdy);
            if (DBMath.areEquals(pdx, 0.0) && DBMath.areEquals(pdy, 0.0)) {
                pd = 0.0;
            }
            if (DBMath.isGreaterThan(pd, 0.0)) {
                return false;
            }
            boolean foundError = false;
            double minX = Math.min(box1.getMinX(), box2.getMinX());
            double minY = Math.min(box1.getMinY(), box2.getMinY());
            double maxX = Math.max(box1.getMaxX(), box2.getMaxX());
            double maxY = Math.max(box1.getMaxY(), box2.getMaxY());
            Rectangle2D.Double rect = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
            DRCTemplate rule = this.currentRules.getRule(layer.getIndex(), DRCTemplate.DRCRuleType.MINWID);
            String string = ruleName = rule != null ? rule.ruleName : "for contacts";
            if (DBMath.isGreaterThan(((RectangularShape)rect).getWidth(), cutSizeX)) {
                DRC.createDRCErrorLogger(this.reportInfo, DRC.DRCErrorType.CUTERROR, "along X", topCell, cutSizeX, ((RectangularShape)rect).getWidth(), ruleName, new Poly(rect), null, layer, null, null, nLayer);
                foundError = true;
            }
            if (DBMath.isGreaterThan(((RectangularShape)rect).getHeight(), cutSizeY)) {
                DRC.createDRCErrorLogger(this.reportInfo, DRC.DRCErrorType.CUTERROR, "along Y", topCell, cutSizeY, ((RectangularShape)rect).getHeight(), ruleName, new Poly(rect), null, layer, null, null, layer);
                foundError = true;
            }
            return foundError;
        }

        private boolean checkExtensionGateRule(Geometric geom, Layer layer, Poly poly, Layer nLayer, Poly nPoly, Netlist netlist) {
            if (MTDRCLayoutTool.this.ignoreExtensionRules) {
                return false;
            }
            return false;
        }

        private boolean checkExtensionRules(Geometric geom, Layer layer, Poly poly, Cell cell) {
            if (MTDRCLayoutTool.this.ignoreExtensionRules) {
                return false;
            }
            List<DRCTemplate> rules = this.currentRules.getRules(layer, DRCTemplate.DRCRuleType.SURROUND);
            Point2D[] basePts = new Point2D[4];
            Rectangle2D polyBnd = poly.getBounds2D();
            basePts[0] = new Point2D.Double(polyBnd.getMinX(), polyBnd.getMinY());
            basePts[1] = new Point2D.Double(polyBnd.getMinX(), polyBnd.getMaxY());
            basePts[2] = new Point2D.Double(polyBnd.getMaxX(), polyBnd.getMaxY());
            basePts[3] = new Point2D.Double(polyBnd.getMaxX(), polyBnd.getMinY());
            block6: for (DRCTemplate rule : rules) {
                if (rule.nodeName != null || rule.condition == null || !rule.name1.equals(layer.getName())) continue;
                String[] layersS = TextUtils.parseString(rule.condition.substring(2), "(,)");
                Layer[] layers = new Layer[layersS.length];
                for (int i = 0; i < layersS.length; ++i) {
                    layers[i] = layer.getTechnology().findLayer(layersS[i]);
                }
                for (int j = 0; j < 4; ++j) {
                    boolean[] basicFound = new boolean[3];
                    Point2D[] basicPts = new Point2D[3];
                    basicFound[0] = false;
                    basicPts[0] = basePts[j];
                    Rectangle2D.Double basicBnd = new Rectangle2D.Double(DBMath.round(basicPts[0].getX() - DRC.TINYDELTA), DBMath.round(basicPts[0].getY() - DRC.TINYDELTA), 2.0 * DRC.TINYDELTA, 2.0 * DRC.TINYDELTA);
                    boolean f = false;
                    for (int i = 0; i < layers.length && !(f = this.lookForLayerWithPoints(geom, poly, null, null, cell, layers[i], DBMath.MATID, basicBnd, basicPts, basicFound, 1, true)); ++i) {
                    }
                    if (!f) continue;
                    basicFound[2] = false;
                    basicFound[1] = false;
                    basicFound[0] = false;
                    double cos45 = 1.0 / Math.sqrt(2.0);
                    double xValue = rule.getValue(0);
                    double yValue = rule.getValue(1);
                    double x45Value = xValue * cos45;
                    double y45Value = yValue * cos45;
                    Point2D basicBndPoint = null;
                    switch (j) {
                        case 0: {
                            basicPts[0] = new Point2D.Double(polyBnd.getMinX() - x45Value, polyBnd.getMinY() - y45Value);
                            basicPts[1] = new Point2D.Double(polyBnd.getMinX() - xValue, polyBnd.getMinY());
                            basicPts[2] = new Point2D.Double(polyBnd.getMinX(), polyBnd.getMinY() - yValue);
                            basicBndPoint = new Point2D.Double(polyBnd.getMinX() - xValue, polyBnd.getMinY() - yValue);
                            break;
                        }
                        case 1: {
                            basicPts[0] = new Point2D.Double(polyBnd.getMinX() - x45Value, polyBnd.getMaxY() + y45Value);
                            basicPts[1] = new Point2D.Double(polyBnd.getMinX() - xValue, polyBnd.getMaxY());
                            basicPts[2] = new Point2D.Double(polyBnd.getMinX(), polyBnd.getMaxY() + yValue);
                            basicBndPoint = basicPts[1];
                            break;
                        }
                        case 2: {
                            basicPts[0] = new Point2D.Double(polyBnd.getMaxX() + x45Value, polyBnd.getMaxY() + y45Value);
                            basicPts[1] = new Point2D.Double(polyBnd.getMaxX() + xValue, polyBnd.getMaxY());
                            basicPts[2] = new Point2D.Double(polyBnd.getMaxX(), polyBnd.getMaxY() + yValue);
                            basicBndPoint = new Point2D.Double(polyBnd.getMaxX(), polyBnd.getMaxY());
                            break;
                        }
                        case 3: {
                            basicPts[0] = new Point2D.Double(polyBnd.getMaxX() + x45Value, polyBnd.getMinY() - y45Value);
                            basicPts[1] = new Point2D.Double(polyBnd.getMaxX() + xValue, polyBnd.getMinY());
                            basicPts[2] = new Point2D.Double(polyBnd.getMaxX(), polyBnd.getMinY() - yValue);
                            basicBndPoint = basicPts[2];
                        }
                    }
                    basicBnd = new Rectangle2D.Double(DBMath.round(basicBndPoint.getX() - DRC.TINYDELTA), DBMath.round(basicBndPoint.getY() - DRC.TINYDELTA), DBMath.round(xValue + 2.0 * DRC.TINYDELTA), DBMath.round(yValue + 2.0 * DRC.TINYDELTA));
                    for (int i = 0; i < layers.length && !(f = this.lookForLayerWithPoints(geom, poly, null, null, cell, layers[i], DBMath.MATID, basicBnd, basicPts, basicFound, 3, true)); ++i) {
                    }
                    if (f) continue;
                    DRC.createDRCErrorLogger(this.reportInfo, DRC.DRCErrorType.LAYERSURROUNDERROR, "No enough surround of " + rule.condition + ", ", geom.getParent(), rule.getValue(0), -1.0, rule.ruleName, poly, geom, layer, null, null, null);
                    if (this.reportInfo.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_EXHAUSTIVE) continue block6;
                    return true;
                }
            }
            return false;
        }

        public boolean polyCoverByAnyVTLayer(Cell cell, DRCTemplate theRule, Technology tech, Poly[] polys, Layer[] layers, Geometric[] geoms, boolean ignoreCenterCuts) {
            PrimitiveNode pn;
            NodeProto np;
            if (!tech.isValidVTPolyRule(theRule)) {
                return false;
            }
            int polyIndex = -1;
            int vtIndex = -1;
            for (int i = 0; i < polys.length; ++i) {
                Layer.Function fun = layers[i].getFunction();
                if (fun.isGatePoly()) {
                    polyIndex = i;
                    continue;
                }
                if (!layers[i].isVTImplantLayer()) continue;
                vtIndex = i;
            }
            if (polyIndex == -1 || vtIndex == -1) {
                return false;
            }
            if (geoms[polyIndex] instanceof NodeInst && (np = ((NodeInst)geoms[polyIndex]).getProto()) instanceof PrimitiveNode && ((pn = (PrimitiveNode)np).isNodeBitOn(8) || pn.isNodeBitOn(16))) {
                return true;
            }
            Rectangle2D polyBounds = polys[polyIndex].getBounds2D();
            boolean[] basicFound = new boolean[4];
            Point2D[] basePts = new Point2D[]{new Point2D.Double(polyBounds.getMinX(), polyBounds.getMinY()), new Point2D.Double(polyBounds.getMinX(), polyBounds.getMaxY()), new Point2D.Double(polyBounds.getMaxX(), polyBounds.getMaxY()), new Point2D.Double(polyBounds.getMaxX(), polyBounds.getMinY())};
            Rectangle2D.Double basicBnd = new Rectangle2D.Double(DBMath.round(basePts[0].getX() - DRC.TINYDELTA), DBMath.round(basePts[0].getY() - DRC.TINYDELTA), DBMath.round(2.0 * DRC.TINYDELTA + polyBounds.getWidth()), DBMath.round(2.0 * DRC.TINYDELTA + polyBounds.getHeight()));
            boolean found = this.lookForLayerWithPoints(null, polys[polyIndex], null, null, cell, layers[vtIndex], DBMath.MATID, basicBnd, basePts, basicFound, 1, true);
            return found;
        }

        private boolean activeOnTransistor(Poly poly1, Layer layer1, int net1, Poly poly2, Layer layer2, int net2, Cell cell, int globalIndex) {
            if (net1 == net2) {
                return false;
            }
            Layer.Function fun = layer1.getFunction();
            int funExtras = layer1.getFunctionExtras();
            if (!(fun.isDiff() || fun.isContact() && (funExtras & 0x10000) != 0)) {
                return false;
            }
            funExtras = layer2.getFunctionExtras();
            fun = layer2.getFunction();
            if (!(fun.isDiff() || fun.isContact() && (funExtras & 0x10000) != 0)) {
                return false;
            }
            Rectangle2D bounds1 = poly1.getBounds2D();
            Rectangle2D bounds2 = poly2.getBounds2D();
            Rectangle2D.union(bounds1, bounds2, bounds1);
            return this.activeOnTransistorRecurse(bounds1, net1, net2, cell, globalIndex, DBMath.MATID);
        }

        private boolean activeOnTransistorRecurse(Rectangle2D bounds, int net1, int net2, Cell cell, int globalIndex, AffineTransform trans) {
            Netlist netlist = this.getCheckProto((Cell)cell).netlist;
            Rectangle2D.Double subBounds = new Rectangle2D.Double();
            Iterator<RTBounds> sIt = cell.searchIterator(bounds);
            while (sIt.hasNext()) {
                RTBounds g = sIt.next();
                if (!(g instanceof NodeInst)) continue;
                NodeInst ni = (NodeInst)g;
                NodeProto np = ni.getProto();
                if (ni.isCellInstance()) {
                    AffineTransform rTransI = ni.rotateIn();
                    AffineTransform tTransI = ni.translateIn();
                    rTransI.preConcatenate(tTransI);
                    ((Rectangle2D)subBounds).setRect(bounds);
                    DBMath.transformRect(subBounds, rTransI);
                    CheckInst ci = this.checkInsts.get(ni);
                    int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
                    boolean ret = this.activeOnTransistorRecurse(subBounds, net1, net2, (Cell)np, localIndex, trans);
                    if (!ret) continue;
                    return true;
                }
                if (!ni.getFunction().isFET()) continue;
                Rectangle2D nodeBounds = ni.getBounds();
                double cX = nodeBounds.getCenterX();
                double cY = nodeBounds.getCenterY();
                if (cX < bounds.getMinX() || cX > bounds.getMaxX() || cY < bounds.getMinY() || cY > bounds.getMaxY()) continue;
                PortProto badport = np.getPort(0);
                Network badNet = netlist.getNetwork(ni, badport, 0);
                boolean on1 = false;
                boolean on2 = false;
                Iterator<PortInst> it = ni.getPortInsts();
                while (it.hasNext()) {
                    Integer[] netNumbers;
                    int net;
                    PortInst pi = it.next();
                    PortProto po = pi.getPortProto();
                    String name = po.getName();
                    boolean found = false;
                    boolean oldFound = false;
                    Network piNet = netlist.getNetwork(pi);
                    if (name.indexOf("poly") != -1) {
                        found = true;
                    }
                    if (piNet == badNet) {
                        oldFound = true;
                    }
                    if (Job.LOCALDEBUGFLAG && oldFound != found) {
                        System.out.println("Here is different in activeOnTransistorRecurse");
                    }
                    if (found || (net = (netNumbers = this.networkLists.get(piNet))[globalIndex].intValue()) < 0) continue;
                    if (net == net1) {
                        on1 = true;
                    }
                    if (net != net2) continue;
                    on2 = true;
                }
                if (!on1 || !on2) continue;
                return true;
            }
            return false;
        }

        private boolean cropNodeInst(NodeInst ni, int globalIndex, AffineTransform trans, Layer nLayer, int nNet, Geometric nGeom, Rectangle2D bound) {
            Technology tech = ni.getProto().getTechnology();
            Poly[] cropNodePolyList = tech.getShapeOfNode(ni, true, this.reportInfo.ignoreCenterCuts, null);
            this.convertPseudoLayers(ni, cropNodePolyList);
            int tot = cropNodePolyList.length;
            if (tot < 0) {
                return false;
            }
            boolean[] rotated = new boolean[tot];
            Arrays.fill(rotated, false);
            boolean isConnected = false;
            Netlist netlist = this.getCheckProto((Cell)ni.getParent()).netlist;
            for (int j = 0; j < tot; ++j) {
                int net;
                Poly poly = cropNodePolyList[j];
                if (!tech.sameLayer(poly.getLayer(), nLayer)) continue;
                poly.transform(trans);
                rotated[j] = true;
                if (nNet >= 0 && (poly.getPort() == null || (net = this.getDRCNetNumber(netlist, poly.getPort(), ni, globalIndex)) >= 0 && net != nNet)) continue;
                isConnected = true;
                break;
            }
            if (!isConnected) {
                return false;
            }
            boolean allgone = false;
            for (int j = 0; j < tot; ++j) {
                Rectangle2D polyBox;
                Poly poly = cropNodePolyList[j];
                if (!tech.sameLayer(poly.getLayer(), nLayer)) continue;
                if (!rotated[j]) {
                    poly.transform(trans);
                }
                if ((polyBox = poly.getBox()) == null) continue;
                int temp = Poly.cropBox(bound, polyBox);
                if (temp > 0) {
                    allgone = true;
                    break;
                }
                if (temp >= 0) continue;
                this.tinyNodeInst = ni;
                this.tinyGeometric = nGeom;
            }
            return allgone;
        }

        private boolean cropArcInst(ArcInst ai, Layer lay, AffineTransform inTrans, Rectangle2D bounds, boolean overlap) {
            for (int i = 0; i < 2; ++i) {
                PortInst pi = ai.getPortInst(i);
                PortOriginal fp = new PortOriginal(pi, inTrans);
                NodeInst ni = fp.getBottomNodeInst();
                NodeProto np = ni.getProto();
                AffineTransform trans = fp.getTransformToTop();
                Technology tech = np.getTechnology();
                Poly[] cropArcPolyList = null;
                for (Poly poly : tech.getShapeOfNode(ni, false, this.reportInfo.ignoreCenterCuts, null)) {
                    if (!tech.sameLayer(poly.getLayer(), lay)) continue;
                    poly.transform(trans);
                    Rectangle2D polyBox = poly.getBox();
                    if (polyBox == null) continue;
                    int temp = Poly.halfCropBox(bounds, polyBox);
                    if (temp > 0) {
                        return true;
                    }
                    if (temp >= 0) continue;
                    this.tinyNodeInst = ni;
                    this.tinyGeometric = ai;
                }
            }
            return false;
        }

        private void cropActiveArc(ArcInst ai, Poly[] pList) {
            int tot = pList.length;
            int diffPoly = -1;
            for (int j = 0; j < tot; ++j) {
                Layer.Function fun;
                Poly poly = pList[j];
                Layer layer = poly.getLayer();
                if (layer == null || !(fun = layer.getFunction()).isDiff()) continue;
                diffPoly = j;
                break;
            }
            if (diffPoly < 0) {
                return;
            }
            Poly poly = pList[diffPoly];
            Rectangle2D polyBounds = poly.getBox();
            if (polyBounds == null) {
                return;
            }
            polyBounds = new Rectangle2D.Double(polyBounds.getMinX(), polyBounds.getMinY(), polyBounds.getWidth(), polyBounds.getHeight());
            boolean cropped = false;
            boolean halved = false;
            for (int i = 0; i < 2; ++i) {
                PortInst pi = ai.getPortInst(i);
                NodeInst ni = pi.getNodeInst();
                if (!ni.getFunction().isFET()) continue;
                AffineTransform trans = ni.rotateOut();
                Technology tech = ni.getProto().getTechnology();
                for (Poly nPoly : tech.getShapeOfNode(ni, false, this.reportInfo.ignoreCenterCuts, null)) {
                    int result;
                    if (nPoly.getLayer() != poly.getLayer()) continue;
                    nPoly.transform(trans);
                    Rectangle2D nPolyBounds = nPoly.getBox();
                    if (nPolyBounds == null) continue;
                    int n = result = halved ? Poly.cropBox(polyBounds, nPolyBounds) : Poly.halfCropBox(polyBounds, nPolyBounds);
                    if (result == 1) {
                        poly.setLayer(null);
                        return;
                    }
                    cropped = true;
                    halved = true;
                }
            }
            if (cropped) {
                Poly.Type style = poly.getStyle();
                Layer layer = poly.getLayer();
                poly = new Poly(polyBounds);
                poly.setStyle(style);
                poly.setLayer(layer);
                pList[diffPoly] = poly;
            }
        }

        private void convertPseudoLayers(NodeInst ni, Poly[] pList) {
            if (ni.getProto().getFunction() != PrimitiveNode.Function.PIN) {
                return;
            }
            assert (false);
            System.out.println("I should not get this");
            if (ni.hasConnections()) {
                return;
            }
            if (!ni.hasExports()) {
                return;
            }
            for (Poly poly : pList) {
                Layer layer = poly.getLayer();
                if (layer == null) continue;
                poly.setLayer(layer.getNonPseudoLayer());
            }
        }

        private DRCTemplate getSpacingRule(Layer layer1, Poly poly1, Geometric geo1, Layer layer2, Poly poly2, Geometric geo2, boolean con, int multi) {
            double[] values;
            DRCTemplate theRule;
            if (!con && layer1 == layer2) {
                Layer.Function fun = layer1.getFunction();
                con = fun.isSubstrate();
            }
            if ((theRule = this.currentRules.getSpacingRule(layer1, geo1, layer2, geo2, con, multi, (values = layer1.getTechnology().getSpacingDistances(poly1, poly2))[0], values[1])) != null && theRule.condition != null) {
                String[] conds = TextUtils.parseString(theRule.condition, "{,}");
                assert (conds.length == 2);
                String layerName1 = conds[0];
                String[] parameters = TextUtils.parseString(conds[1], "()");
                assert (parameters.length == 2);
                assert (parameters[0].equals("no_overlap"));
                String layerName2 = parameters[1];
                if (!layer1.getName().equals(layerName1)) {
                    theRule = null;
                } else {
                    Layer l = layer1.getTechnology().findLayer(layerName2);
                    boolean found = this.searchForCondLayer(geo1, poly1, l, geo1.getParent(), this.reportInfo.ignoreCenterCuts);
                    if (found) {
                        theRule = null;
                    }
                }
            }
            return theRule;
        }

        private int getDRCNetNumber(Netlist netlist, PortProto pp, NodeInst ni, int globalIndex) {
            if (pp == null) {
                return -1;
            }
            Network net = netlist.getNetwork(ni, pp, 0);
            Integer[] nets = this.networkLists.get(net);
            if (nets == null) {
                return -1;
            }
            return nets[globalIndex];
        }

        private void accumulateExclusion(Cell cell) {
            Area area = null;
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                NodeProto np = ni.getProto();
                if (np == Generic.tech().drcNode) {
                    AffineTransform trans = ni.rotateOut();
                    Poly[] list = cell.getTechnology().getShapeOfNode(ni, true, true, null);
                    assert (list.length == 1);
                    list[0].transform(trans);
                    Area thisArea = new Area(list[0]);
                    if (area == null) {
                        area = thisArea;
                        continue;
                    }
                    area.add(thisArea);
                    continue;
                }
                if (!ni.isCellInstance()) continue;
                this.accumulateExclusion((Cell)np);
            }
            this.exclusionMap.put(cell, area);
        }
    }
}

