/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.tool.simulation.NewSignal;
import com.sun.electric.tool.simulation.ScalarSample;
import com.sun.electric.tool.simulation.Waveform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaveformImpl
implements Waveform {
    private double[] time;
    private double[] value;
    private NewSignal.Approximation<ScalarSample> approximation = null;

    public WaveformImpl(double[] time, double[] value) {
        if (time.length != value.length) {
            throw new IllegalArgumentException();
        }
        this.time = time;
        this.value = value;
    }

    @Override
    public int getNumEvents() {
        return this.time.length;
    }

    @Override
    public void getEvent(int index, double[] result) {
        result[0] = this.time[index];
        result[1] = result[2] = this.value[index];
    }

    @Override
    public NewSignal.Approximation<ScalarSample> getApproximation(double t0, double t1, int tn, ScalarSample v0, ScalarSample v1, int vd) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public NewSignal.Approximation<ScalarSample> getPixelatedApproximation(double t0, double t1, int numRegions) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public synchronized NewSignal.Approximation<ScalarSample> getPreferredApproximation() {
        if (this.approximation == null) {
            this.approximation = new ApproximationImpl();
        }
        return this.approximation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ApproximationImpl
    implements NewSignal.Approximation<ScalarSample> {
        private final float[] times;
        private final float[] values;
        private final int eventWithMinValue;
        private final int eventWithMaxValue;

        public ApproximationImpl() {
            WaveformImpl waveform = WaveformImpl.this;
            int count = waveform.getNumEvents();
            this.times = new float[count == 0 ? 1 : count];
            this.values = new float[count == 0 ? 1 : count];
            double minValue = Double.MAX_VALUE;
            double maxValue = Double.MIN_VALUE;
            int evmin = 0;
            int evmax = 0;
            double[] result = new double[10];
            for (int i = 0; i < count; ++i) {
                if (waveform != null) {
                    waveform.getEvent(i, result);
                    this.times[i] = (float)result[0];
                    this.values[i] = (float)result[1];
                }
                if ((double)this.values[i] < minValue) {
                    evmin = i;
                    minValue = this.values[evmin];
                }
                if ((double)this.values[i] > maxValue) {
                    evmax = i;
                    maxValue = this.values[evmax];
                }
                if (i <= 0 || !(this.times[i] < this.times[i - 1])) continue;
                throw new RuntimeException("got non-monotonic sample data, and I haven't implement sorting yet");
            }
            this.eventWithMinValue = evmin;
            this.eventWithMaxValue = evmax;
        }

        @Override
        public int getNumEvents() {
            return this.times.length;
        }

        @Override
        public double getTime(int index) {
            return this.times[index];
        }

        @Override
        public ScalarSample getSample(int index) {
            return new ScalarSample(this.values[index]);
        }

        @Override
        public int getTimeNumerator(int index) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public int getTimeDenominator() {
            throw new RuntimeException("not implemented");
        }

        @Override
        public int getEventWithMaxValue() {
            return this.eventWithMaxValue;
        }

        @Override
        public int getEventWithMinValue() {
            return this.eventWithMinValue;
        }
    }
}

