/* $NetBSD: tegra_xusbreg.h,v 1.1 2016/09/26 20:05:03 jakllsch Exp $ */

/*
 * Copyright (c) 2016 Jonathan A. Kollasch
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _TEGRA_XUSBREG_H_
#define _TEGRA_XUSBREG_H_

/* in FPCI space */
#define T_XUSB_CFG_ARU_MAILBOX_CMD_REG		0x0e4
#define T_XUSB_CFG_ARU_MAILBOX_CMD_INT_EN		__BIT(31)
#define T_XUSB_CFG_ARU_MAILBOX_CMD_DEST_XHCI		__BIT(30)
#define T_XUSB_CFG_ARU_MAILBOX_CMD_DEST_SMI		__BIT(29)
#define T_XUSB_CFG_ARU_MAILBOX_CMD_DEST_PME		__BIT(28)
#define T_XUSB_CFG_ARU_MAILBOX_CMD_DEST_FALCON		__BIT(27)
#define T_XUSB_CFG_ARU_MAILBOX_DATA_IN_REG	0x0e8
#define MAILBOX_DATA_DATA				__BITS(23,0)
#define MAILBOX_DATA_TYPE				__BITS(31,24)
#define T_XUSB_CFG_ARU_MAILBOX_DATA_OUT_REG	0x0ec
#define T_XUSB_CFG_ARU_MAILBOX_OWNER_REG	0x0f0
#define T_XUSB_CFG_ARU_MAILBOX_OWNER_ID			__BITS(7,0)
#define MAILBOX_OWNER_NONE					0
#define MAILBOX_OWNER_FW					1
#define MAILBOX_OWNER_SW					2
#define T_XUSB_CFG_ARU_C11_CSBRANGE_REG		0x41c
#define T_XUSB_CFG_ARU_C11_CSBRANGE_RANGE		__BITS(31-9,9-9)
#define T_XUSB_CFG_ARU_SMI_INTR_REG		0x428
#define T_XUSB_CFG_ARU_SMI_INTR_EN			__BIT(3)
#define T_XUSB_CFG_ARU_SMI_INTR_FW_HANG			__BIT(1)
#define T_XUSB_CFG_CSB_BASE_ADDR		0x800

#define XUSB_CSB_RANGE __BITS(31,9)
#define XUSB_CSB_OFFSET __BITS(8,0)

/* in CSB space via FPCI space*/
#define XUSB_CSB_FALCON_CPUCTL_REG		0x100
#define XUSB_CSB_FALCON_CPUCTL_STOPPED			__BIT(5)
#define XUSB_CSB_FALCON_CPUCTL_HALTED			__BIT(4)
#define XUSB_CSB_FALCON_CPUCTL_STARTCPU			__BIT(1)
#define XUSB_CSB_FALCON_BOOTVEC_REG		0x104
#define XUSB_CSB_FALCON_DMACTL_REG		0x10c
#define XUSB_CSB_FALCON_IMFILLRNG1_REG		0x154
#define XUSB_CSB_FALCON_IMFILLRNG1_TAG_HI		__BITS(31,16)
#define XUSB_CSB_FALCON_IMFILLRNG1_TAG_LO		__BITS(15,0)
#define XUSB_CSB_FALCON_IMFILLCTL_REG		0x158
#define XUSB_CSB_FALCON_IMFILLCTL_NBLOCKS		__BITS(7,0)

#define XUSB_CSB_MEMPOOL_APMAP_REG		0x10181c
#define XUSB_CSB_MEMPOOL_APMAP_BOOTPATH			__BIT(31)

#define XUSB_CSB_MEMPOOL_ILOAD_ATTR_REG		0x101a00
#define XUSB_CSB_MEMPOOL_ILOAD_BASE_LO_REG	0x101a04
#define XUSB_CSB_MEMPOOL_ILOAD_BASE_LO_SRC_ADDR		__BITS(7,0)
#define XUSB_CSB_MEMPOOL_ILOAD_BASE_HI_REG	0x101a08
#define XUSB_CSB_MEMPOOL_ILOAD_BASE_HI_SRC_ADDR		__BITS(7,0)
#define XUSB_CSB_MEMPOOL_L2IMEMOP_SIZE_REG	0x101a10
#define XUSB_CSB_MEMPOOL_L2IMEMOP_SIZE_SRC_COUNT	__BITS(31,24)
#define XUSB_CSB_MEMPOOL_L2IMEMOP_SIZE_SRC_OFFSET	__BITS(19,8)
#define XUSB_CSB_MEMPOOL_L2IMEMOP_TRIG_REG	0x101a14
#define XUSB_CSB_MEMPOOL_L2IMEMOP_TRIG_ACTION		__BITS(31,24)
#define ACTION_L2IMEM_LOAD_LOCKED_RESULT			0x11
#define ACTION_L2IMEM_INVALIDATE_ALL				0x40

#define IMEM_BLOCK_SIZE 256

#endif /* _TEGRA_XUSBREG_H_ */
