/*
 * Copyright (c) 2012 Michael Lorenz
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: valkyriefbreg.h,v 1.5 2020/04/16 23:29:52 rin Exp $");

#ifndef VALKYRIEFBREG_H
#define VALKYRIEFBREG_H

#define VAL_FB_OFFSET	0x00000000
#define VAL_CMAP_OFFSET	0x00304000
#define VAL_CMAP_ADDR	0x00000000
#define VAL_CMAP_LUT	0x00000008
#define VAL_REGS_OFFSET	0x0030a000
#define VAL_MODE	0x00000000
	#define VAL_MODE_STOP	0x80
	#define VAL_MODE_NOSYNC	0x40
	
#define VAL_DEPTH	0x00000008
	#define VAL_DEPTH_8	3
	#define VAL_DEPTH_16	4
#define VAL_STATUS	0x00000010
#define VAL_REG3	0x00000018
#define VAL_INTR	0x00000020
#define VAL_REG5	0x00000028
#define VAL_INTR_EN	0x00000030
#define VAL_MPSENSE	0x00000038

#endif /* VALKYRIEFBREG_H */
