/*
Original work Copyright (c) 2018 Shannon Miwa
Modified work Copyright (c) 2019 dtinth

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

/*
 * a rendering of the Comic Mono font found here:
 * https://github.com/dtinth/comic-mono-font/
 */

static u_char Comic_Mono_16x34_data[];

static struct wsdisplay_font Comic_Mono_16x34 = {
	"Comic Mono 16x34",		/* typeface name */
	32,				/* firstchar */
	127 - 32,			/* numchar */
	WSDISPLAY_FONTENC_ISO,		/* encoding */
	16,				/* width */
	34,				/* height */
	16,				/* stride */
	WSDISPLAY_FONTORDER_L2R,	/* bit order */
	WSDISPLAY_FONTORDER_L2R,	/* byte order */
	Comic_Mono_16x34_data		/* data */
};

static u_char Comic_Mono_16x34_data[] = {
	/* 32 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 33 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xf4, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       oX-        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      .XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xd6, 0xea, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       OX-        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x5e, 0x69, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       -+         */
0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      aXXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0xf4, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XXXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      aXXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x89, 0x79, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       o+         */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 34 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0xc0, 0xf5, 0x5e, 0x00, 0x6b, 0xf5, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, /*     OX- +Xa      */
0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa7, 0x00, 0xa7, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XXa aXX      */
0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XXa aXX      */
0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XXa aXX      */
0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa7, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XXa aXX      */
0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa6, 0x00, 0xa8, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XXa aXX      */
0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa1, 0x00, 0xa8, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XXa aXX      */
0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x94, 0x00, 0xa7, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XXo aXX      */
0x00, 0x00, 0x00, 0x00, 0xb4, 0xea, 0x46, 0x00, 0x66, 0xf1, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, /*     aX- +Xo      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 35 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x19, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, /*       .          */
0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xfd, 0xf2, 0x12, 0x00, 0x00, 0x8b, 0xf8, 0x67, 0x00, 0x00, /*      .XX   oX+   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x85, 0xff, 0xff, 0x1d, 0x00, 0x03, 0xf5, 0xff, 0xa9, 0x00, 0x00, /*      oXX   XXa   */
0x00, 0x00, 0x00, 0x00, 0x00, 0xb4, 0xff, 0xee, 0x00, 0x00, 0x28, 0xff, 0xff, 0x78, 0x00, 0x00, /*      aXX  .XX+   */
0x00, 0x00, 0x00, 0x00, 0x00, 0xe2, 0xff, 0xbd, 0x00, 0x00, 0x57, 0xff, 0xff, 0x46, 0x00, 0x00, /*      XXa  -XX-   */
0x00, 0x00, 0x00, 0x00, 0x11, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x85, 0xff, 0xff, 0x19, 0x00, 0x00, /*      XXo  oXX    */
0x00, 0x00, 0xb0, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x99, 0x00, /*   aXXXXXXXXXXXo  */
0x00, 0x00, 0xdb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x00, /*   OXXXXXXXXXXXO  */
0x00, 0x00, 0x0a, 0x2e, 0xb8, 0xff, 0xf5, 0x30, 0x30, 0x3b, 0xff, 0xff, 0x9d, 0x2d, 0x0a, 0x00, /*    .aXX...XXo.   */
0x00, 0x00, 0x00, 0x00, 0xd3, 0xff, 0xc6, 0x00, 0x00, 0x37, 0xff, 0xff, 0x61, 0x00, 0x00, 0x00, /*     OXO  .XX+    */
0x00, 0x00, 0x00, 0x07, 0xfb, 0xff, 0x95, 0x00, 0x00, 0x64, 0xff, 0xff, 0x37, 0x00, 0x00, 0x00, /*     XXo  +XX.    */
0x00, 0x00, 0x00, 0x32, 0xff, 0xff, 0x64, 0x00, 0x00, 0x91, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, /*    .XX+  oXX     */
0x00, 0x0b, 0x2e, 0x7b, 0xff, 0xff, 0x5d, 0x30, 0x30, 0xc7, 0xff, 0xec, 0x2f, 0x12, 0x00, 0x00, /*   .+XX-..OXX.    */
0x00, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x00, 0x00, /*  OXXXXXXXXXXXX   */
0x00, 0xbf, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0x00, 0x00, /*  aXXXXXXXXXXXO   */
0x00, 0x00, 0x09, 0xfa, 0xff, 0xa2, 0x00, 0x00, 0x44, 0xff, 0xff, 0x61, 0x00, 0x00, 0x00, 0x00, /*    XXa  -XX+     */
0x00, 0x00, 0x3b, 0xff, 0xff, 0x70, 0x00, 0x00, 0x74, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, /*   .XX+  +XX.     */
0x00, 0x00, 0x77, 0xff, 0xff, 0x3d, 0x00, 0x00, 0xa9, 0xff, 0xfd, 0x0a, 0x00, 0x00, 0x00, 0x00, /*   +XX.  aXX      */
0x00, 0x00, 0xab, 0xff, 0xfd, 0x0c, 0x00, 0x00, 0xdc, 0xff, 0xd7, 0x00, 0x00, 0x00, 0x00, 0x00, /*   aXX   OXO      */
0x00, 0x00, 0x7f, 0xff, 0x93, 0x00, 0x00, 0x00, 0xbd, 0xff, 0x77, 0x00, 0x00, 0x00, 0x00, 0x00, /*   +Xo   aX+      */
0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00, 0x08, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*          .       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 36 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x72, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       +.         */
0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xde, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      oXO         */
0x00, 0x00, 0x00, 0x00, 0x00, 0xa7, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      aXX         */
0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      aXX         */
0x00, 0x00, 0x00, 0x1d, 0x8b, 0xea, 0xff, 0xff, 0xf2, 0xc1, 0x7e, 0x1e, 0x00, 0x00, 0x00, 0x00, /*     oXXXXO+      */
0x00, 0x00, 0x4d, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x00, 0x00, 0x00, 0x00, /*   -XXXXXXXXX     */
0x00, 0x1d, 0xf6, 0xff, 0xe5, 0xd6, 0xff, 0xff, 0x41, 0x80, 0xda, 0xcd, 0x00, 0x00, 0x00, 0x00, /*   XXXOXX-oOO     */
0x00, 0x94, 0xff, 0xfa, 0x25, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  oXX.aXX         */
0x00, 0xd7, 0xff, 0xbc, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  OXa aXX         */
0x00, 0xf5, 0xff, 0xb9, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa aXX         */
0x00, 0xd9, 0xff, 0xfa, 0x2f, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  OXX.aXX         */
0x00, 0x72, 0xff, 0xff, 0xf4, 0xe5, 0xff, 0xff, 0x44, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  +XXXXXX-        */
0x00, 0x04, 0x99, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xb1, 0x31, 0x00, 0x00, 0x00, 0x00, /*   oXXXXXXXa.     */
0x00, 0x00, 0x00, 0x3a, 0x80, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x46, 0x00, 0x00, 0x00, /*    .oOXXXXXX-    */
0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x4b, 0xc7, 0xff, 0xff, 0xf1, 0x18, 0x00, 0x00, /*      aXX-OXXX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x03, 0xad, 0xff, 0xff, 0x72, 0x00, 0x00, /*      aXX  aXX+   */
0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x2a, 0xff, 0xff, 0x9a, 0x00, 0x00, /*      aXX  .XXo   */
0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x0c, 0xff, 0xff, 0x9a, 0x00, 0x00, /*      aXX   XXo   */
0x05, 0x2a, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x48, 0xff, 0xff, 0x6d, 0x00, 0x00, /*  .   aXX  -XX+   */
0xb8, 0xff, 0x75, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x1c, 0xdb, 0xff, 0xf5, 0x18, 0x00, 0x00, /* aX+  aXX  OXX    */
0xbd, 0xff, 0xfb, 0x59, 0x00, 0xa8, 0xff, 0xff, 0x69, 0xe9, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, /* aXX- aXX+XXX+    */
0x34, 0xf8, 0xff, 0xff, 0xd4, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x69, 0x00, 0x00, 0x00, 0x00, /* .XXXOXXXXXX+     */
0x00, 0x38, 0xd5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xb4, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, /*  .OXXXXXXa.      */
0x00, 0x00, 0x00, 0x3b, 0x67, 0xd3, 0xff, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    .+OXX         */
0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      aXX         */
0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xef, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      aXX         */
0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x76, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      .+.         */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 37 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x63, 0xd9, 0xf8, 0xd5, 0x5b, 0x00, 0x00, 0x00, 0x00, 0x41, 0xd6, 0x7a, 0x00, 0x00, /*   +OXO-    -O+   */
0x00, 0x52, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4f, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xb4, 0x00, 0x00, /*  -XXXXX-   OXa   */
0x00, 0xca, 0xff, 0x83, 0x39, 0x96, 0xff, 0xa7, 0x00, 0x00, 0x4d, 0xff, 0xfe, 0x37, 0x00, 0x00, /*  OXo.oXa  -XX.   */
0x00, 0xf4, 0xee, 0x00, 0x00, 0x0d, 0xff, 0xc9, 0x00, 0x01, 0xce, 0xff, 0xa6, 0x00, 0x00, 0x00, /*  XX   XO  OXa    */
0x00, 0xe6, 0xfc, 0x40, 0x09, 0x6a, 0xff, 0xc0, 0x00, 0x56, 0xff, 0xf8, 0x20, 0x00, 0x00, 0x00, /*  XX- +XO -XX.    */
0x00, 0x8b, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7b, 0x04, 0xda, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, /*  oXXXXX+ OXo     */
0x00, 0x08, 0xa3, 0xfe, 0xff, 0xfc, 0x9b, 0x06, 0x6a, 0xff, 0xee, 0x11, 0x00, 0x00, 0x00, 0x00, /*   aXXXo +XX      */
0x00, 0x00, 0x00, 0x14, 0x25, 0x07, 0x00, 0x0d, 0xe9, 0xff, 0x75, 0x00, 0x00, 0x00, 0x00, 0x00, /*     .   XX+      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83, 0xff, 0xe2, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, /*        oXX       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0xf5, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*        XX+       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9b, 0xff, 0xd3, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       oXO        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xfc, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      .XX-        */
0x00, 0x00, 0x00, 0x00, 0x00, 0xb3, 0xff, 0xc2, 0x00, 0x6b, 0xde, 0xf5, 0xc3, 0x31, 0x00, 0x00, /*      aXO +OXO.   */
0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0x3a, 0x53, 0xff, 0xff, 0xff, 0xff, 0xef, 0x14, 0x00, /*     .XX.-XXXXX   */
0x00, 0x00, 0x00, 0x00, 0xc9, 0xff, 0xb2, 0x00, 0xc7, 0xff, 0x79, 0x46, 0xe3, 0xff, 0x63, 0x00, /*     OXa OX+-XX+  */
0x00, 0x00, 0x00, 0x54, 0xff, 0xfd, 0x2d, 0x00, 0xf1, 0xef, 0x00, 0x00, 0x8c, 0xff, 0x7f, 0x00, /*    -XX. XX  oX+  */
0x00, 0x00, 0x04, 0xd9, 0xff, 0xa5, 0x00, 0x00, 0xf0, 0xf7, 0x0b, 0x00, 0xbc, 0xff, 0x70, 0x00, /*    OXa  XX  aX+  */
0x00, 0x00, 0x62, 0xff, 0xfb, 0x25, 0x00, 0x00, 0xae, 0xff, 0xdb, 0xc5, 0xff, 0xff, 0x3f, 0x00, /*   +XX.  aXOOXX.  */
0x00, 0x01, 0xdc, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x25, 0xe9, 0xff, 0xff, 0xff, 0xa4, 0x00, 0x00, /*   OXo   .XXXXa   */
0x00, 0x0b, 0xf9, 0xf6, 0x22, 0x00, 0x00, 0x00, 0x00, 0x14, 0x69, 0x70, 0x40, 0x00, 0x00, 0x00, /*   XX.     ++-    */
0x00, 0x00, 0x31, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   ..             */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 38 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x3d, 0xb4, 0xe2, 0xf4, 0xcf, 0x72, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, /*     .aXXO+       */
0x00, 0x00, 0x00, 0x42, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcb, 0x07, 0x00, 0x00, 0x00, 0x00, /*    -XXXXXXO      */
0x00, 0x00, 0x00, 0xcb, 0xff, 0xfa, 0x5f, 0x42, 0xc3, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, /*    OXX--OXX+     */
0x00, 0x00, 0x00, 0xf9, 0xff, 0xb9, 0x00, 0x00, 0x20, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, /*    XXa  .XXo     */
0x00, 0x00, 0x00, 0xe6, 0xff, 0xb8, 0x00, 0x00, 0x0e, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, /*    XXa   XXo     */
0x00, 0x00, 0x00, 0x91, 0xff, 0xf5, 0x14, 0x00, 0x5e, 0xff, 0xff, 0x4d, 0x00, 0x00, 0x00, 0x00, /*    oXX  -XX-     */
0x00, 0x00, 0x00, 0x0f, 0xe1, 0xff, 0xa3, 0x82, 0xf9, 0xff, 0xc4, 0x01, 0x00, 0x00, 0x00, 0x00, /*     XXaoXXO      */
0x00, 0x00, 0x00, 0x00, 0x41, 0xff, 0xff, 0xff, 0xff, 0xb7, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, /*     -XXXXa       */
0x00, 0x00, 0x00, 0x36, 0xcc, 0xff, 0xff, 0xf7, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    .OXXX-        */
0x00, 0x00, 0x42, 0xf9, 0xff, 0xfa, 0xef, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   -XXXXX+        */
0x00, 0x15, 0xf1, 0xff, 0xe3, 0x2f, 0x4e, 0xff, 0xf6, 0x2d, 0x00, 0x00, 0x6a, 0xed, 0x4c, 0x00, /*   XXX.-XX.  +X-  */
0x00, 0x7a, 0xff, 0xff, 0x42, 0x00, 0x00, 0x9b, 0xff, 0xda, 0x0f, 0x1f, 0xf9, 0xff, 0x83, 0x00, /*  +XX-  oXO  XXo  */
0x00, 0xc9, 0xff, 0xdf, 0x00, 0x00, 0x00, 0x0c, 0xdc, 0xff, 0xb1, 0x94, 0xff, 0xf9, 0x2c, 0x00, /*  OXO    OXaoXX.  */
0x00, 0xe8, 0xff, 0xb5, 0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0xff, 0xff, 0xff, 0x6b, 0x00, 0x00, /*  XXa    -XXXX+   */
0x00, 0xf7, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, /*  XXa     OXXa    */
0x00, 0xd6, 0xff, 0xe3, 0x04, 0x00, 0x00, 0x00, 0x01, 0xb4, 0xff, 0xff, 0xdb, 0x06, 0x00, 0x00, /*  OXX     aXXO    */
0x00, 0x7c, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x08, 0x98, 0xff, 0xfc, 0xff, 0xff, 0x75, 0x00, 0x00, /*  +XX+   oXXXX+   */
0x00, 0x09, 0xd1, 0xff, 0xff, 0xd6, 0xb9, 0xeb, 0xff, 0xf8, 0x48, 0xe4, 0xff, 0xee, 0x0a, 0x00, /*   OXXOaXXX-XXX   */
0x00, 0x00, 0x13, 0xb3, 0xff, 0xff, 0xff, 0xff, 0xe5, 0x43, 0x00, 0x73, 0xff, 0xff, 0x2d, 0x00, /*    aXXXXX- +XX.  */
0x00, 0x00, 0x00, 0x00, 0x2d, 0x68, 0x78, 0x54, 0x09, 0x00, 0x00, 0x03, 0x8d, 0xb9, 0x07, 0x00, /*     .++-    oa   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 39 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xf5, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aX-        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXo        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xae, 0xee, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aX.        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 40 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, /*          .       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xd7, 0xff, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, /*        -OXX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0xff, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00, /*       +XXXa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xfd, 0xff, 0x8e, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      -XXo        */
0x00, 0x00, 0x00, 0x00, 0x0a, 0xe8, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XXa         */
0x00, 0x00, 0x00, 0x00, 0x75, 0xff, 0xfc, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     +XX.         */
0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     OXa          */
0x00, 0x00, 0x00, 0x19, 0xff, 0xff, 0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XX+          */
0x00, 0x00, 0x00, 0x4d, 0xff, 0xff, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    -XX.          */
0x00, 0x00, 0x00, 0x75, 0xff, 0xff, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    +XX           */
0x00, 0x00, 0x00, 0x91, 0xff, 0xff, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    oXX           */
0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    aXX           */
0x00, 0x00, 0x00, 0xb7, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    aXX           */
0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    OXX           */
0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    OXX           */
0x00, 0x00, 0x00, 0xb4, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    aXX.          */
0x00, 0x00, 0x00, 0x96, 0xff, 0xff, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    oXX.          */
0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    +XX+          */
0x00, 0x00, 0x00, 0x47, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    -XXo          */
0x00, 0x00, 0x00, 0x0c, 0xf8, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XXX          */
0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     aXX.         */
0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     -XXa         */
0x00, 0x00, 0x00, 0x00, 0x02, 0xd6, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      OXX-        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xfb, 0xff, 0xf1, 0x5e, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, /*      -XXX-       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xfd, 0xff, 0xff, 0xe5, 0x00, 0x00, 0x00, 0x00, 0x00, /*       +XXXX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xbc, 0xf5, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00, /*        -aXa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 41 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x12, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     .            */
0x00, 0x00, 0x00, 0xe5, 0xff, 0xd8, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXO-          */
0x00, 0x00, 0x00, 0xbd, 0xff, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    aXXX+         */
0x00, 0x00, 0x00, 0x00, 0x13, 0x91, 0xff, 0xfe, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      oXX-        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xae, 0xff, 0xe9, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xfd, 0xff, 0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       .XX+       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xd5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*        aXO       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, /*        +XX       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, /*        .XX-      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0xff, 0xff, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, /*         XX+      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, /*         XXo      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, /*         XXa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, /*         XXa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, /*         XXO      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, /*         XXO      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, /*        .XXa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0xff, 0xff, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, /*        .XXo      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x65, 0xff, 0xff, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, /*        +XX+      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9d, 0xff, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, /*        oXX-      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe4, 0xff, 0xf8, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, /*        XXX       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       .XXa       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0xff, 0xff, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX-       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xd5, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      -XXO        */
0x00, 0x00, 0x00, 0x13, 0x5f, 0xf1, 0xff, 0xfa, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     -XXX.        */
0x00, 0x00, 0x00, 0xe6, 0xff, 0xff, 0xfd, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXXX+         */
0x00, 0x00, 0x00, 0xbe, 0xf5, 0xbc, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    aXa.          */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 42 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x05, 0x67, 0x2e, 0x00, 0x00, 0x00, 0x25, 0x69, 0x06, 0x00, 0x00, 0x00, 0x00, /*     +.   .+      */
0x00, 0x00, 0x00, 0x4c, 0xff, 0xf0, 0x19, 0x00, 0x07, 0xe1, 0xff, 0x69, 0x00, 0x00, 0x00, 0x00, /*    -XX   XX+     */
0x00, 0x00, 0x00, 0x21, 0xfb, 0xff, 0x8b, 0x00, 0x63, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, /*    .XXo +XX-     */
0x00, 0x00, 0x00, 0x00, 0x89, 0xff, 0xf3, 0x18, 0xdd, 0xff, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00, /*     oXX OXa      */
0x00, 0x00, 0x00, 0x00, 0x0a, 0xe3, 0xff, 0xd4, 0xff, 0xf9, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XXOXX.      */
0x00, 0x20, 0x51, 0x45, 0x3e, 0x8f, 0xff, 0xff, 0xff, 0xb5, 0x41, 0x53, 0x79, 0x4e, 0x00, 0x00, /*  .--.oXXXa--+-   */
0x00, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x07, 0x00, /*  XXXXXXXXXXXXX   */
0x00, 0xb6, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3, 0x01, 0x00, /*  aXXXXXXXXXXXX   */
0x00, 0x00, 0x00, 0x00, 0x01, 0xca, 0xff, 0xff, 0xff, 0xb8, 0x03, 0x0b, 0x1e, 0x11, 0x00, 0x00, /*      OXXXa       */
0x00, 0x00, 0x00, 0x00, 0x63, 0xff, 0xff, 0x7f, 0xf8, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, /*     +XX+XX-      */
0x00, 0x00, 0x00, 0x0f, 0xea, 0xff, 0xe8, 0x07, 0x9b, 0xff, 0xd7, 0x04, 0x00, 0x00, 0x00, 0x00, /*     XXX oXO      */
0x00, 0x00, 0x00, 0x53, 0xff, 0xff, 0x7d, 0x00, 0x35, 0xff, 0xff, 0x51, 0x00, 0x00, 0x00, 0x00, /*    -XX+ .XX-     */
0x00, 0x00, 0x00, 0x1b, 0xd6, 0xe2, 0x16, 0x00, 0x00, 0xad, 0xef, 0x41, 0x00, 0x00, 0x00, 0x00, /*     OX   aX-     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 43 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x6f, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       .+         */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXo        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x0a, 0x2e, 0x30, 0x30, 0xff, 0xff, 0xb8, 0x30, 0x30, 0x2c, 0x04, 0x00, 0x00, 0x00, /*    ...XXa...     */
0x00, 0x00, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x81, 0x00, 0x00, 0x00, /*   OXXXXXXXXXo    */
0x00, 0x00, 0xb7, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x77, 0x00, 0x00, 0x00, /*   aXXXXXXXXX+    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x02, 0x07, 0x10, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb4, 0xf1, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aX+        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 44 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xe9, 0xc5, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       .XO        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x79, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       +XX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 0xff, 0xe7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       OXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xfd, 0xff, 0xa3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      +XX-        */
0x00, 0x00, 0x00, 0x00, 0x00, 0xc8, 0xff, 0xfa, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      OXX         */
0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     .XXa         */
0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     oXX-         */
0x00, 0x00, 0x00, 0x17, 0xfb, 0xff, 0xe6, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XXX          */
0x00, 0x00, 0x00, 0x05, 0xba, 0xc6, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     aO.          */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 45 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x10, 0x2f, 0x30, 0x30, 0x30, 0x30, 0x2f, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, /*     ......       */
0x00, 0x00, 0x00, 0xe3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXXXXXXX      */
0x00, 0x00, 0x00, 0xc7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, /*    OXXXXXXO      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 46 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xde, 0xea, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      -OX-        */
0x00, 0x00, 0x00, 0x00, 0x00, 0xe1, 0xff, 0xff, 0xe9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XXXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0xe9, 0xff, 0xff, 0xe5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XXXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x65, 0xfc, 0xf3, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      +XX-        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 47 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xae, 0xeb, 0x3c, 0x00, 0x00, /*            aX.   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0xff, 0xff, 0x6f, 0x00, 0x00, /*           +XX+   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xdd, 0xff, 0xf6, 0x1a, 0x00, 0x00, /*           OXX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0xff, 0xff, 0x87, 0x00, 0x00, 0x00, /*          +XXo    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xdb, 0xff, 0xea, 0x0f, 0x00, 0x00, 0x00, /*          OXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, /*         +XX+     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xe4, 0xff, 0xd3, 0x03, 0x00, 0x00, 0x00, 0x00, /*         XXO      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x75, 0xff, 0xff, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, /*        +XX-      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0xee, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*        XXa       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xf8, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       oXX.       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf8, 0xff, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXo        */
0x00, 0x00, 0x00, 0x00, 0x00, 0xa7, 0xff, 0xe7, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      aXX         */
0x00, 0x00, 0x00, 0x00, 0x36, 0xfe, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     .XX+         */
0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xcd, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     OXO          */
0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    -XX.          */
0x00, 0x00, 0x08, 0xe1, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x7c, 0xff, 0xff, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   +XX.           */
0x00, 0x1c, 0xf4, 0xff, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0xa6, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  aXX-            */
0x32, 0xff, 0xff, 0xcb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* .XXO             */
0x72, 0xff, 0xff, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* +XX-             */
0x38, 0xe3, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* .Xo              */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 48 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x08, 0x63, 0xbf, 0xe4, 0xf9, 0xe1, 0x94, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, /*     +aXXXo       */
0x00, 0x00, 0x1a, 0xcb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x32, 0x00, 0x00, 0x00, 0x00, /*    OXXXXXXX.     */
0x00, 0x00, 0xbb, 0xff, 0xff, 0xab, 0x4a, 0x3e, 0x98, 0xff, 0xff, 0xdf, 0x07, 0x00, 0x00, 0x00, /*   aXXa-.oXXO     */
0x00, 0x3f, 0xff, 0xff, 0xb5, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xff, 0x5f, 0x00, 0x00, 0x00, /*  .XXa    aXX-    */
0x00, 0x89, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x13, 0xef, 0xff, 0xff, 0xad, 0x00, 0x00, 0x00, /*  oXX.    XXXa    */
0x00, 0xbf, 0xff, 0xef, 0x02, 0x00, 0x00, 0x00, 0x94, 0xff, 0xfe, 0xff, 0xd8, 0x00, 0x00, 0x00, /*  aXX    oXXXO    */
0x00, 0xe7, 0xff, 0xc9, 0x00, 0x00, 0x00, 0x29, 0xfb, 0xe3, 0xc2, 0xff, 0xef, 0x00, 0x00, 0x00, /*  XXO   .XXOXX    */
0x00, 0xfb, 0xff, 0xb1, 0x00, 0x00, 0x00, 0xb7, 0xff, 0x61, 0xb3, 0xff, 0xfa, 0x00, 0x00, 0x00, /*  XXa   aX+aXX    */
0x00, 0xff, 0xff, 0xa9, 0x00, 0x00, 0x4b, 0xff, 0xd1, 0x02, 0xad, 0xff, 0xfe, 0x00, 0x00, 0x00, /*  XXa  -XO aXX    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x0d, 0xe2, 0xfd, 0x36, 0x00, 0xa9, 0xff, 0xff, 0x00, 0x00, 0x00, /*  XXa  XX. aXX    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x96, 0xff, 0x8e, 0x00, 0x00, 0xae, 0xff, 0xff, 0x00, 0x00, 0x00, /*  XXa oXo  aXX    */
0x00, 0xff, 0xff, 0xa8, 0x3d, 0xfe, 0xd1, 0x09, 0x00, 0x00, 0xbc, 0xff, 0xff, 0x00, 0x00, 0x00, /*  XXa.XO   aXX    */
0x00, 0xff, 0xff, 0xb2, 0xd9, 0xf1, 0x24, 0x00, 0x00, 0x00, 0xcf, 0xff, 0xfa, 0x00, 0x00, 0x00, /*  XXaOX.   OXX    */
0x00, 0xf5, 0xff, 0xfe, 0xfb, 0x4a, 0x00, 0x00, 0x00, 0x00, 0xee, 0xff, 0xeb, 0x00, 0x00, 0x00, /*  XXXX-    XXX    */
0x00, 0xd4, 0xff, 0xfe, 0x5d, 0x00, 0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x00, /*  OXX-    .XXa    */
0x00, 0x8d, 0xff, 0xde, 0x05, 0x00, 0x00, 0x00, 0x05, 0xb9, 0xff, 0xff, 0x6d, 0x00, 0x00, 0x00, /*  oXO     aXX+    */
0x00, 0x1f, 0xf4, 0xff, 0xbb, 0x48, 0x37, 0x5a, 0xc4, 0xff, 0xff, 0xef, 0x11, 0x00, 0x00, 0x00, /*   XXa-.-OXXX     */
0x00, 0x00, 0x52, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x5b, 0x00, 0x00, 0x00, 0x00, /*   -XXXXXXXX-     */
0x00, 0x00, 0x00, 0x28, 0xa0, 0xe4, 0xfc, 0xff, 0xf1, 0xbd, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, /*    .aXXXXa-      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 49 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0xb5, 0xed, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aX+        */
0x00, 0x00, 0x00, 0x00, 0x42, 0xeb, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     -XXXX        */
0x00, 0x00, 0x01, 0x77, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    +XXXXX        */
0x00, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xed, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   oXXXXXX        */
0x00, 0x00, 0xda, 0xff, 0xf6, 0x5c, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   OXX-aXX        */
0x00, 0x00, 0x44, 0xa0, 0x29, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   -a. aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x37, 0x73, 0x74, 0x74, 0x74, 0xcf, 0xff, 0xff, 0x74, 0x74, 0x74, 0x72, 0x3c, 0x00, 0x00, /*  .++++OXX++++.   */
0x00, 0xed, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x00, 0x00, /*  XXXXXXXXXXXXX   */
0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xaa, 0x00, 0x00, /*  aXXXXXXXXXXXa   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 50 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x13, 0x7b, 0xd3, 0xf8, 0xf5, 0xd8, 0x98, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, /*     +OXXOo.      */
0x00, 0x00, 0x47, 0xed, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x57, 0x00, 0x00, 0x00, 0x00, /*   -XXXXXXXX-     */
0x00, 0x3c, 0xfb, 0xff, 0xfc, 0x97, 0x43, 0x40, 0x75, 0xec, 0xff, 0xf6, 0x1a, 0x00, 0x00, 0x00, /*  .XXXo--+XXX     */
0x00, 0xac, 0xff, 0xfa, 0x49, 0x00, 0x00, 0x00, 0x00, 0x4b, 0xff, 0xff, 0x71, 0x00, 0x00, 0x00, /*  aXX-    -XX+    */
0x00, 0x75, 0xf8, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0x9b, 0x00, 0x00, 0x00, /*  +X+      XXo    */
0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, /*           XXa    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x65, 0xff, 0xff, 0x81, 0x00, 0x00, 0x00, /*          +XXo    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf3, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00, /*         .XXX.    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x88, 0xfb, 0xff, 0xff, 0x93, 0x00, 0x00, 0x00, 0x00, /*        oXXXo     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xe3, 0xff, 0xff, 0xfb, 0x7f, 0x01, 0x00, 0x00, 0x00, 0x00, /*      -XXXX+      */
0x00, 0x00, 0x00, 0x14, 0xb6, 0xff, 0xff, 0xff, 0xc2, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     aXXXO.       */
0x00, 0x00, 0x11, 0xd1, 0xff, 0xff, 0xdb, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    OXXO-         */
0x00, 0x00, 0xac, 0xff, 0xff, 0xa5, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   aXXa           */
0x00, 0x42, 0xff, 0xff, 0xbc, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -XXa            */
0x00, 0xaa, 0xff, 0xfe, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  aXX.            */
0x00, 0xe8, 0xff, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXO             */
0x00, 0xfb, 0xff, 0xc2, 0x3c, 0x3c, 0x3c, 0x3c, 0x3e, 0x4d, 0x63, 0x79, 0x5a, 0x00, 0x00, 0x00, /*  XXO.....-++-    */
0x00, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00, /*  XXXXXXXXXXXX    */
0x00, 0x7f, 0xf1, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00, /*  +XXXXXXXXXXa    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 51 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x24, 0x99, 0xdb, 0xf8, 0xf3, 0xd8, 0xa0, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, /*    .oOXXOa.      */
0x00, 0x00, 0x40, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x87, 0x00, 0x00, 0x00, 0x00, /*   -XXXXXXXXo     */
0x00, 0x0b, 0xe7, 0xff, 0xf9, 0x7b, 0x37, 0x42, 0x72, 0xe4, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, /*   XXX+.-+XXX.    */
0x00, 0x3d, 0xff, 0xff, 0x5f, 0x00, 0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0x8f, 0x00, 0x00, 0x00, /*  .XX-    .XXo    */
0x00, 0x07, 0x8c, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0x9d, 0x00, 0x00, 0x00, /*   o+      XXo    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0x6d, 0x00, 0x00, 0x00, /*          +XX+    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x17, 0x3e, 0x9e, 0xfd, 0xff, 0xc5, 0x08, 0x00, 0x00, 0x00, /*        .oXXO     */
0x00, 0x00, 0x00, 0x00, 0x4e, 0xf9, 0xff, 0xff, 0xff, 0xc3, 0x64, 0x05, 0x00, 0x00, 0x00, 0x00, /*     -XXXXO+      */
0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x9e, 0x12, 0x00, 0x00, 0x00, 0x00, /*     -XXXXXo      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x3c, 0x64, 0xbd, 0xff, 0xff, 0xe2, 0x1c, 0x00, 0x00, 0x00, /*      ..+aXXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00, /*          oXXo    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xec, 0xff, 0xe0, 0x00, 0x00, 0x00, /*           XXX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb7, 0xff, 0xf9, 0x00, 0x00, 0x00, /*           aXX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xf2, 0x00, 0x00, 0x00, /*           aXX    */
0x00, 0x99, 0xe5, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xff, 0xce, 0x00, 0x00, 0x00, /*  oX.      OXO    */
0x00, 0xdb, 0xff, 0xeb, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, /*  OXX.    +XXo    */
0x00, 0x69, 0xff, 0xff, 0xf3, 0x80, 0x3d, 0x50, 0xa6, 0xff, 0xff, 0xe5, 0x12, 0x00, 0x00, 0x00, /*  +XXXo.-aXXX     */
0x00, 0x00, 0x6f, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x31, 0x00, 0x00, 0x00, 0x00, /*   +XXXXXXXX.     */
0x00, 0x00, 0x00, 0x24, 0x94, 0xdf, 0xfa, 0xf1, 0xca, 0x7c, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, /*    .oOXXO+       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 52 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x98, 0xf7, 0xdf, 0x32, 0x00, 0x00, 0x00, 0x00, /*         oXO.     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x87, 0xff, 0xff, 0xff, 0x87, 0x00, 0x00, 0x00, 0x00, /*        oXXXo     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xfe, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, /*       -XXXXo     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xec, 0xff, 0x82, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, /*       XXoXXa     */
0x00, 0x00, 0x00, 0x00, 0x06, 0xca, 0xff, 0xad, 0x01, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, /*      OXa XXa     */
0x00, 0x00, 0x00, 0x00, 0x95, 0xff, 0xd5, 0x0b, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, /*     oXO  XXa     */
0x00, 0x00, 0x00, 0x56, 0xff, 0xf3, 0x28, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, /*    -XX.  XXa     */
0x00, 0x00, 0x22, 0xf0, 0xff, 0x5e, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, /*   .XX-   XXa     */
0x00, 0x02, 0xc6, 0xff, 0xad, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, /*   OXa    XXa     */
0x00, 0x70, 0xff, 0xf2, 0x1a, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, /*  +XX     XXa     */
0x00, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x00, 0x00, /*  XXXXXXXXXXXXO   */
0x00, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x00, 0x00, /*  XXXXXXXXXXXXO   */
0x00, 0x42, 0x94, 0x74, 0x58, 0x46, 0x3b, 0x35, 0x32, 0xff, 0xff, 0xb8, 0x2e, 0x0d, 0x00, 0x00, /*  -o+--...XXa.    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, /*          XXa     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, /*          XXa     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, /*          XXa     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xbb, 0x00, 0x00, 0x00, 0x00, /*          XXa     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfd, 0xff, 0xc5, 0x00, 0x00, 0x00, 0x00, /*          XXO     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83, 0xf1, 0x6c, 0x00, 0x00, 0x00, 0x00, /*          oX+     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 53 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x15, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb3, 0x00, 0x00, 0x00, /*  OXXXXXXXXXXa    */
0x3b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00, 0x00, /* .XXXXXXXXXXXX    */
0x02, 0xff, 0xff, 0xb8, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x18, 0x00, 0x00, 0x00, /*  XXa........     */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x0a, 0x71, 0xc4, 0xee, 0xf8, 0xd3, 0x6d, 0x02, 0x00, 0x00, 0x00, 0x00, /*  XXa +OXXO+      */
0x00, 0xff, 0xff, 0xca, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9d, 0x00, 0x00, 0x00, 0x00, /*  XXOOXXXXXXo     */
0x00, 0xee, 0xff, 0xff, 0xfc, 0x97, 0x47, 0x39, 0x6b, 0xef, 0xff, 0xff, 0x45, 0x00, 0x00, 0x00, /*  XXXXo-.+XXX-    */
0x00, 0xc0, 0xff, 0xf7, 0x46, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, /*  OXX-    .XXa    */
0x00, 0x23, 0x72, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd7, 0xff, 0xe5, 0x00, 0x00, 0x00, /*  .+.      OXX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb3, 0xff, 0xfa, 0x00, 0x00, 0x00, /*           aXX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb1, 0xff, 0xf1, 0x00, 0x00, 0x00, /*           aXX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcb, 0xff, 0xdb, 0x00, 0x00, 0x00, /*           OXO    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xf7, 0xff, 0xa7, 0x00, 0x00, 0x00, /*           XXa    */
0x1d, 0xb6, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x69, 0xff, 0xff, 0x5f, 0x00, 0x00, 0x00, /*  a+      +XX-    */
0x64, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x25, 0xec, 0xff, 0xeb, 0x09, 0x00, 0x00, 0x00, /* +XX-    .XXX     */
0x19, 0xee, 0xff, 0xfd, 0x95, 0x42, 0x3a, 0x76, 0xee, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, /*  XXXo-.+XXX-     */
0x00, 0x3f, 0xeb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, /*  .XXXXXXXX+      */
0x00, 0x00, 0x18, 0x86, 0xcb, 0xe9, 0xf9, 0xe0, 0x9e, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    oOXXXo.       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 54 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x2d, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, /*          ..      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x65, 0xc6, 0xfc, 0xff, 0xff, 0x52, 0x00, 0x00, 0x00, 0x00, /*       +OXXX-     */
0x00, 0x00, 0x00, 0x00, 0x2c, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xcf, 0x1e, 0x00, 0x00, 0x00, 0x00, /*     .OXXXXO      */
0x00, 0x00, 0x00, 0x32, 0xee, 0xff, 0xff, 0xcc, 0x67, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    .XXXO+.       */
0x00, 0x00, 0x11, 0xe0, 0xff, 0xfd, 0x6d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXX+          */
0x00, 0x00, 0x90, 0xff, 0xff, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   oXX+           */
0x00, 0x11, 0xf8, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x61, 0xff, 0xff, 0x3d, 0x00, 0x02, 0x1b, 0x2a, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  +XX.   .        */
0x00, 0xa2, 0xff, 0xe3, 0x26, 0xa1, 0xee, 0xff, 0xff, 0xff, 0xd9, 0x59, 0x00, 0x00, 0x00, 0x00, /*  aXX.aXXXXO-     */
0x00, 0xcf, 0xff, 0xde, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6b, 0x00, 0x00, 0x00, /*  OXOXXXXXXXX+    */
0x00, 0xeb, 0xff, 0xff, 0xff, 0xae, 0x3b, 0x0b, 0x0f, 0x5e, 0xf4, 0xff, 0xf5, 0x10, 0x00, 0x00, /*  XXXXa.  -XXX    */
0x00, 0xf8, 0xff, 0xff, 0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0xff, 0xff, 0x5d, 0x00, 0x00, /*  XXX+     +XX-   */
0x00, 0xfa, 0xff, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0xff, 0xff, 0x8d, 0x00, 0x00, /*  XXa      .XXo   */
0x00, 0xef, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xa0, 0x00, 0x00, /*  XXa       XXa   */
0x00, 0xd4, 0xff, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0x9b, 0x00, 0x00, /*  OXa       XXo   */
0x00, 0xaa, 0xff, 0xe4, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0xff, 0xff, 0x7c, 0x00, 0x00, /*  aXX      .XX+   */
0x00, 0x64, 0xff, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x93, 0xff, 0xff, 0x36, 0x00, 0x00, /*  +XX-     oXX.   */
0x00, 0x12, 0xf2, 0xff, 0xdb, 0x0f, 0x00, 0x00, 0x00, 0x3d, 0xfa, 0xff, 0xca, 0x00, 0x00, 0x00, /*   XXO    .XXO    */
0x00, 0x00, 0x78, 0xff, 0xff, 0xde, 0x5b, 0x3a, 0x7a, 0xf4, 0xff, 0xf9, 0x32, 0x00, 0x00, 0x00, /*   +XXO-.+XXX.    */
0x00, 0x00, 0x01, 0xa0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x49, 0x00, 0x00, 0x00, 0x00, /*    aXXXXXXX-     */
0x00, 0x00, 0x00, 0x00, 0x55, 0xb9, 0xea, 0xf8, 0xdc, 0x8f, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, /*     -aXXOo       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 55 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x8e, 0xe0, 0xf6, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xa5, 0x00, 0x00, 0x00, /*  oXXXXXXXXXXa    */
0x00, 0xeb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x00, 0x00, 0x00, /*  XXXXXXXXXXXX    */
0x00, 0x35, 0x56, 0x3d, 0x33, 0x30, 0x30, 0x30, 0x30, 0x43, 0xfe, 0xff, 0x8f, 0x00, 0x00, 0x00, /*  .-......-XXo    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0xff, 0xf5, 0x1a, 0x00, 0x00, 0x00, /*          +XX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xeb, 0xff, 0x83, 0x00, 0x00, 0x00, 0x00, /*          XXo     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x89, 0xff, 0xe5, 0x0b, 0x00, 0x00, 0x00, 0x00, /*         oXX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0xf9, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, /*        .XX-      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0xff, 0xc7, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, /*        aXO       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0xfe, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       -XX.       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xd9, 0xff, 0xa3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       OXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0xff, 0xf8, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      +XX         */
0x00, 0x00, 0x00, 0x00, 0x12, 0xef, 0xff, 0x8f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XXo         */
0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xf5, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     oXX          */
0x00, 0x00, 0x00, 0x19, 0xf6, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XXo          */
0x00, 0x00, 0x00, 0x93, 0xff, 0xf8, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    oXX           */
0x00, 0x00, 0x1d, 0xf8, 0xff, 0x97, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXo           */
0x00, 0x00, 0x9a, 0xff, 0xfb, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   oXX.           */
0x00, 0x20, 0xfa, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  .XXa            */
0x00, 0x5a, 0xff, 0xf9, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -XX.            */
0x00, 0x0a, 0x81, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   o.             */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 56 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x22, 0x96, 0xd3, 0xf1, 0xf1, 0xd5, 0x97, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, /*    .oOXXOo.      */
0x00, 0x00, 0x44, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x4a, 0x00, 0x00, 0x00, 0x00, /*   -XXXXXXXX-     */
0x00, 0x10, 0xed, 0xff, 0xff, 0xa1, 0x45, 0x49, 0xb9, 0xff, 0xff, 0xf1, 0x14, 0x00, 0x00, 0x00, /*   XXXa--aXXX     */
0x00, 0x6a, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x01, 0xa7, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, /*  +XXo    aXX+    */
0x00, 0x9f, 0xff, 0xff, 0x19, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, /*  oXX     .XXa    */
0x00, 0x8c, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x19, 0xff, 0xff, 0x8d, 0x00, 0x00, 0x00, /*  oXX.     XXo    */
0x00, 0x31, 0xfd, 0xff, 0xc8, 0x1c, 0x00, 0x00, 0x09, 0xb7, 0xff, 0xee, 0x21, 0x00, 0x00, 0x00, /*  .XXO    aXX.    */
0x00, 0x00, 0x72, 0xff, 0xff, 0xf3, 0x90, 0x57, 0xd4, 0xff, 0xde, 0x31, 0x00, 0x00, 0x00, 0x00, /*   +XXXo-OXO.     */
0x00, 0x00, 0x00, 0x49, 0xe5, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, /*    -XXXXXX-      */
0x00, 0x00, 0x0a, 0xa2, 0xfe, 0xff, 0xf9, 0xe1, 0xff, 0xff, 0xff, 0xa4, 0x0b, 0x00, 0x00, 0x00, /*    aXXXXXXXa     */
0x00, 0x02, 0xb6, 0xff, 0xff, 0xab, 0x1a, 0x01, 0x4d, 0xd6, 0xff, 0xff, 0xc1, 0x04, 0x00, 0x00, /*   aXXa  -OXXO    */
0x00, 0x5f, 0xff, 0xff, 0xa7, 0x02, 0x00, 0x00, 0x00, 0x07, 0xb3, 0xff, 0xff, 0x77, 0x00, 0x00, /*  -XXa     aXX+   */
0x00, 0xc7, 0xff, 0xf4, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xf2, 0xff, 0xdb, 0x00, 0x00, /*  OXX       XXO   */
0x00, 0xf6, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb4, 0xff, 0xf7, 0x00, 0x00, /*  XXO       aXX   */
0x00, 0xea, 0xff, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xdc, 0x00, 0x00, /*  XXa       aXO   */
0x00, 0xc1, 0xff, 0xf8, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0xfa, 0xff, 0xa2, 0x00, 0x00, /*  OXX      .XXa   */
0x00, 0x5f, 0xff, 0xff, 0xd4, 0x2a, 0x00, 0x00, 0x00, 0x44, 0xe2, 0xff, 0xf9, 0x2b, 0x00, 0x00, /*  -XXO.   -XXX.   */
0x00, 0x01, 0xa8, 0xff, 0xff, 0xfe, 0xcd, 0xb9, 0xdf, 0xff, 0xff, 0xfd, 0x55, 0x00, 0x00, 0x00, /*   aXXXOaOXXX-    */
0x00, 0x00, 0x08, 0x93, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd5, 0x49, 0x00, 0x00, 0x00, 0x00, /*    oXXXXXXO-     */
0x00, 0x00, 0x00, 0x00, 0x14, 0x54, 0x75, 0x79, 0x63, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      -+++.       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 57 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x1b, 0x27, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*        .         */
0x00, 0x00, 0x00, 0x0a, 0x7f, 0xe4, 0xff, 0xff, 0xff, 0xc7, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, /*     +XXXXO-      */
0x00, 0x00, 0x17, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x6b, 0x00, 0x00, 0x00, 0x00, /*    OXXXXXXX+     */
0x00, 0x01, 0xc0, 0xff, 0xff, 0xa7, 0x25, 0x09, 0x52, 0xe8, 0xff, 0xfc, 0x30, 0x00, 0x00, 0x00, /*   OXXa. -XXX.    */
0x00, 0x52, 0xff, 0xff, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x29, 0xf7, 0xff, 0xae, 0x00, 0x00, 0x00, /*  -XXa    .XXa    */
0x00, 0xaf, 0xff, 0xfa, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8d, 0xff, 0xf9, 0x0d, 0x00, 0x00, /*  aXX      oXX    */
0x00, 0xe6, 0xff, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xff, 0xff, 0x4a, 0x00, 0x00, /*  XXO      .XX-   */
0x00, 0xfa, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0x73, 0x00, 0x00, /*  XXa       XX+   */
0x00, 0xeb, 0xff, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x91, 0x00, 0x00, /*  XXa       XXo   */
0x00, 0xb6, 0xff, 0xef, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0x9e, 0x00, 0x00, /*  aXX       XXo   */
0x00, 0x5b, 0xff, 0xff, 0x6f, 0x00, 0x00, 0x00, 0x00, 0x05, 0x9d, 0xff, 0xff, 0xa2, 0x00, 0x00, /*  -XX+     oXXa   */
0x00, 0x03, 0xcb, 0xff, 0xfc, 0x90, 0x41, 0x3a, 0x6a, 0xd4, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, /*   OXXo-.+OXXXo   */
0x00, 0x00, 0x1d, 0xdb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0x76, 0x00, 0x00, /*    OXXXXXXXXX+   */
0x00, 0x00, 0x00, 0x0d, 0x87, 0xde, 0xfb, 0xf3, 0xd5, 0x93, 0x5c, 0xff, 0xff, 0x3d, 0x00, 0x00, /*     oOXXOo-XX.   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xae, 0xff, 0xeb, 0x06, 0x00, 0x00, /*           aXX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, /*          -XXo    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xe1, 0xff, 0xe8, 0x10, 0x00, 0x00, 0x00, /*         .XXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xe6, 0xff, 0xfa, 0x44, 0x00, 0x00, 0x00, 0x00, /*        -XXX-     */
0x00, 0x00, 0x00, 0x0d, 0x4b, 0x8a, 0xdb, 0xff, 0xff, 0xf6, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, /*     -oOXXX-      */
0x00, 0x00, 0x2c, 0xef, 0xff, 0xff, 0xff, 0xff, 0xc9, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   .XXXXXO.       */
0x00, 0x00, 0x3e, 0xf8, 0xfd, 0xdd, 0x9f, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   .XXOo-         */
0x00, 0x00, 0x00, 0x08, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 58 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa7, 0xf9, 0xcf, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXO        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXX-       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf5, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXX.       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x95, 0xf7, 0xb6, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       oXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xf7, 0xbd, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXX-       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXX.       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x97, 0xf3, 0xae, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       oXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 59 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0x77, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       .+-        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXX.       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXX-       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xec, 0xff, 0xff, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXX.       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0xf0, 0xb0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       +Xa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       ..         */
0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      .XX+        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x7b, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      +XXo        */
0x00, 0x00, 0x00, 0x00, 0x00, 0xb1, 0xff, 0xff, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      aXX-        */
0x00, 0x00, 0x00, 0x00, 0x00, 0xe6, 0xff, 0xff, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XXX         */
0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xd9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XXO         */
0x00, 0x00, 0x00, 0x00, 0x49, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     -XXo         */
0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     +XX-         */
0x00, 0x00, 0x00, 0x00, 0x9d, 0xff, 0xfe, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     oXX          */
0x00, 0x00, 0x00, 0x00, 0x63, 0xf2, 0x97, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     +Xo          */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 60 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0xb7, 0xeb, 0x42, 0x00, 0x00, /*            aX-   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xf0, 0xff, 0xff, 0x9f, 0x00, 0x00, /*          -XXXo   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x7f, 0xfe, 0xff, 0xff, 0xd9, 0x1f, 0x00, 0x00, /*         +XXXO    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xa9, 0xff, 0xff, 0xff, 0xab, 0x0f, 0x00, 0x00, 0x00, /*        aXXXa     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0xc9, 0xff, 0xff, 0xfb, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, /*       OXXX+      */
0x00, 0x00, 0x00, 0x00, 0x2c, 0xe0, 0xff, 0xff, 0xea, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     .XXXX.       */
0x00, 0x00, 0x00, 0x48, 0xf1, 0xff, 0xff, 0xcc, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    -XXXO         */
0x00, 0x00, 0x71, 0xfc, 0xff, 0xff, 0xa2, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   +XXXa          */
0x00, 0x96, 0xff, 0xff, 0xfb, 0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  oXXX+           */
0x09, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXX+            */
0x00, 0xb4, 0xff, 0xff, 0xfb, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  aXXX+           */
0x00, 0x06, 0x9c, 0xff, 0xff, 0xff, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   oXXX+          */
0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0x8b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    oXXXo         */
0x00, 0x00, 0x00, 0x00, 0x6f, 0xfe, 0xff, 0xff, 0x93, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     +XXXo        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0xfc, 0xff, 0xff, 0xa1, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, /*      +XXXa       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xfa, 0xff, 0xff, 0xb2, 0x0b, 0x00, 0x00, 0x00, 0x00, /*       -XXXa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4b, 0xf6, 0xff, 0xff, 0xcf, 0x24, 0x00, 0x00, 0x00, /*        -XXXO.    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xe9, 0xff, 0xff, 0xf1, 0x46, 0x00, 0x00, /*         .XXXX-   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xc1, 0xff, 0xff, 0xc4, 0x00, 0x00, /*           OXXO   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x4b, 0x7a, 0x2b, 0x00, 0x00, /*            -+.   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 61 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0xb6, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0x00, 0x00, 0x00, 0x00, /*   aXXXXXXXXO     */
0x00, 0x00, 0xd9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x00, /*   OXXXXXXXXX     */
0x00, 0x00, 0x09, 0x2d, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x2f, 0x14, 0x00, 0x00, 0x00, 0x00, /*    ........      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0xb4, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, /*   aXXXXXXXXO     */
0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, /*   OXXXXXXXXX     */
0x00, 0x00, 0x0b, 0x2e, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x2f, 0x14, 0x00, 0x00, 0x00, 0x00, /*    ........      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 62 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x2b, 0x5b, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  .-              */
0x0a, 0xf6, 0xff, 0xf6, 0x72, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXX+            */
0x00, 0xa4, 0xff, 0xff, 0xff, 0xad, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  aXXXa           */
0x00, 0x00, 0x6d, 0xf9, 0xff, 0xff, 0xc5, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   +XXXO          */
0x00, 0x00, 0x00, 0x3b, 0xec, 0xff, 0xff, 0xcf, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    .XXXO         */
0x00, 0x00, 0x00, 0x00, 0x2a, 0xe5, 0xff, 0xff, 0xd7, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     .XXXO        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0xdd, 0xff, 0xff, 0xdf, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, /*      .OXXO.      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0xd7, 0xff, 0xff, 0xe7, 0x2e, 0x00, 0x00, 0x00, 0x00, /*        OXXX.     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0xcd, 0xff, 0xff, 0xf1, 0x44, 0x00, 0x00, 0x00, /*         OXXX-    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xba, 0xff, 0xff, 0xfc, 0x57, 0x00, 0x00, /*          aXXX-   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xbd, 0xff, 0xff, 0xc4, 0x00, 0x00, /*           aXXO   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x7f, 0xfe, 0xff, 0xff, 0x71, 0x00, 0x00, /*          +XXX+   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xb1, 0xff, 0xff, 0xf7, 0x5d, 0x00, 0x00, 0x00, /*         aXXX-    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xd6, 0xff, 0xff, 0xe6, 0x35, 0x00, 0x00, 0x00, 0x00, /*       .OXXX.     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0xef, 0xff, 0xff, 0xcf, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, /*      -XXXO       */
0x00, 0x00, 0x00, 0x01, 0x7d, 0xfd, 0xff, 0xff, 0xb4, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     +XXXa        */
0x00, 0x00, 0x13, 0xb4, 0xff, 0xff, 0xff, 0x91, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    aXXXo         */
0x00, 0x2f, 0xe2, 0xff, 0xff, 0xfa, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  .XXXX+          */
0x00, 0xd9, 0xff, 0xff, 0xe6, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  OXXX.           */
0x00, 0xa1, 0xff, 0xad, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  aXa             */
0x00, 0x01, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 63 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x23, 0xa6, 0xed, 0xfa, 0xe6, 0xb2, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, /*     .aXXXa-      */
0x00, 0x00, 0x00, 0x4c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa1, 0x01, 0x00, 0x00, 0x00, /*    -XXXXXXXa     */
0x00, 0x00, 0x2b, 0xf8, 0xff, 0xf2, 0x6f, 0x3a, 0x5c, 0xce, 0xff, 0xff, 0x63, 0x00, 0x00, 0x00, /*   .XXX+.-OXX+    */
0x00, 0x00, 0xb1, 0xff, 0xfb, 0x41, 0x00, 0x00, 0x00, 0x10, 0xeb, 0xff, 0xc3, 0x00, 0x00, 0x00, /*   aXX-    XXO    */
0x00, 0x00, 0xbb, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb7, 0xff, 0xf0, 0x00, 0x00, 0x00, /*   aXo     aXX    */
0x00, 0x00, 0x0d, 0x42, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcd, 0xff, 0xf3, 0x00, 0x00, 0x00, /*    -      OXX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, /*          -XXO    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0xfa, 0xff, 0xfb, 0x3f, 0x00, 0x00, 0x00, /*         -XXX.    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xfe, 0xff, 0xf2, 0x4c, 0x00, 0x00, 0x00, 0x00, /*        +XXX-     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xfd, 0xff, 0xe0, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, /*       .XXX.      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xf4, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       OXX.       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0xff, 0xff, 0x97, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      .XXo        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xff, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      .XX-        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x6e, 0x81, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       +o         */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       ..         */
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      oXXo        */
0x00, 0x00, 0x00, 0x00, 0x00, 0xf1, 0xff, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XXXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0xd2, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      OXXO        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0xb9, 0xaa, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      .aa.        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 64 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0xc4, 0xf4, 0xf0, 0xcc, 0x72, 0x04, 0x00, 0x00, 0x00, 0x00, /*      -OXXO+      */
0x00, 0x00, 0x00, 0x00, 0x95, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0x08, 0x00, 0x00, 0x00, /*     oXXXXXXa     */
0x00, 0x00, 0x00, 0x71, 0xff, 0xff, 0xd1, 0x56, 0x35, 0x7a, 0xf8, 0xff, 0x87, 0x00, 0x00, 0x00, /*    +XXO-.+XXo    */
0x00, 0x00, 0x1c, 0xf6, 0xff, 0xca, 0x0c, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xf3, 0x0d, 0x00, 0x00, /*    XXO    -XX    */
0x00, 0x00, 0x90, 0xff, 0xfb, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd4, 0xff, 0x54, 0x00, 0x00, /*   oXX.     OX-   */
0x00, 0x04, 0xec, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83, 0xff, 0x8e, 0x00, 0x00, /*   XXa      oXo   */
0x00, 0x42, 0xff, 0xff, 0x56, 0x07, 0x70, 0xb5, 0xaf, 0x66, 0x01, 0x44, 0xff, 0xb8, 0x00, 0x00, /*  -XX- +aa+ -Xa   */
0x00, 0x7d, 0xff, 0xff, 0x1d, 0xbf, 0xff, 0xff, 0xff, 0xff, 0x5b, 0x1c, 0xff, 0xd6, 0x00, 0x00, /*  +XX aXXXX- XO   */
0x00, 0xae, 0xff, 0xe7, 0x77, 0xff, 0xdc, 0x49, 0x44, 0x62, 0x0b, 0x04, 0xff, 0xea, 0x00, 0x00, /*  aXX+XO--+  XX   */
0x00, 0xce, 0xff, 0xc4, 0xcb, 0xff, 0x42, 0x00, 0x16, 0x9d, 0x73, 0x00, 0xf9, 0xf8, 0x00, 0x00, /*  OXOOX-  o+ XX   */
0x00, 0xe9, 0xff, 0xb4, 0xec, 0xff, 0x0a, 0x00, 0x69, 0xff, 0xb0, 0x00, 0xee, 0xfd, 0x00, 0x00, /*  XXaXX  +Xa XX   */
0x00, 0xf5, 0xff, 0xaa, 0xfb, 0xff, 0x0e, 0x00, 0x81, 0xff, 0xa6, 0x00, 0xee, 0xf3, 0x00, 0x00, /*  XXaXX  oXa XX   */
0x00, 0xfd, 0xff, 0xb0, 0xe1, 0xff, 0x6e, 0x1a, 0xd8, 0xff, 0xb6, 0x06, 0xfd, 0xde, 0x00, 0x00, /*  XXaXX+ OXa XO   */
0x00, 0xf0, 0xff, 0xbd, 0x92, 0xff, 0xff, 0xff, 0xff, 0xec, 0xf0, 0x6e, 0xff, 0xa9, 0x00, 0x00, /*  XXaoXXXXXX+Xa   */
0x00, 0xdb, 0xff, 0xdc, 0x0e, 0xa9, 0xfd, 0xff, 0xb8, 0x6a, 0xff, 0xff, 0xff, 0x5c, 0x00, 0x00, /*  OXO aXXa+XXX-   */
0x00, 0xa8, 0xff, 0xfd, 0x0e, 0x00, 0x0a, 0x1b, 0x00, 0x08, 0xb4, 0xf4, 0x9e, 0x02, 0x00, 0x00, /*  aXX      aXo    */
0x00, 0x66, 0xff, 0xff, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x00, 0x00, /*  +XX-            */
0x00, 0x0e, 0xf3, 0xff, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0xea, 0xa5, 0x00, 0x00, /*   XXa       Xa   */
0x00, 0x00, 0x84, 0xff, 0xff, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa5, 0xff, 0x82, 0x00, 0x00, /*   oXX-     aXo   */
0x00, 0x00, 0x08, 0xd2, 0xff, 0xf9, 0x6f, 0x1a, 0x0b, 0x35, 0xac, 0xff, 0xf6, 0x1c, 0x00, 0x00, /*    OXX+  .aXX    */
0x00, 0x00, 0x00, 0x19, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x61, 0x00, 0x00, 0x00, /*     OXXXXXXX+    */
0x00, 0x00, 0x00, 0x00, 0x0b, 0x8b, 0xf0, 0xff, 0xff, 0xfc, 0xc4, 0x44, 0x00, 0x00, 0x00, 0x00, /*      oXXXXO-     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x22, 0x24, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*        ..        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 65 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xc8, 0xea, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, /*         OX.      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa5, 0xff, 0xff, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, /*        aXX+      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, /*       .XXXo      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xe8, 0xff, 0xcb, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXXXO      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xe7, 0x5c, 0xff, 0xf7, 0x03, 0x00, 0x00, 0x00, 0x00, /*      .XX-XX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0xb3, 0xff, 0x78, 0x1f, 0xff, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, /*      aX+ XX.     */
0x00, 0x00, 0x00, 0x00, 0x28, 0xfe, 0xf6, 0x11, 0x00, 0xec, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, /*     .XX  XX-     */
0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0x9f, 0x00, 0x00, 0xbb, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, /*     oXo  aXo     */
0x00, 0x00, 0x00, 0x11, 0xf5, 0xff, 0x38, 0x00, 0x00, 0x88, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, /*     XX.  oXO     */
0x00, 0x00, 0x00, 0x73, 0xff, 0xd7, 0x00, 0x00, 0x00, 0x56, 0xff, 0xf4, 0x02, 0x00, 0x00, 0x00, /*    +XO   -XX     */
0x00, 0x00, 0x01, 0xdb, 0xff, 0x78, 0x02, 0x17, 0x25, 0x4f, 0xff, 0xff, 0x2b, 0x00, 0x00, 0x00, /*    OX+  .-XX.    */
0x00, 0x02, 0x74, 0xff, 0xff, 0xed, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0x61, 0x00, 0x00, 0x00, /*   +XXXXXXXXX+    */
0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x97, 0x00, 0x00, 0x00, /*  +XXXXXXXXXXo    */
0x00, 0x3a, 0xff, 0xff, 0xa1, 0x5a, 0x38, 0x1d, 0x13, 0x09, 0x8f, 0xff, 0xd0, 0x00, 0x00, 0x00, /*  .XXa-.   oXO    */
0x00, 0x75, 0xff, 0xfb, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x59, 0xff, 0xfc, 0x0d, 0x00, 0x00, /*  +XX      -XX    */
0x00, 0xd5, 0xff, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0x48, 0x00, 0x00, /*  OXa      .XX-   */
0x31, 0xff, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe9, 0xff, 0x8b, 0x00, 0x00, /* .XX+       XXo   */
0x7f, 0xff, 0xfc, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xad, 0xff, 0xdc, 0x01, 0x00, /* +XX        aXO   */
0xa0, 0xff, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0x28, 0x00, /* aXa        +XX.  */
0x48, 0xcb, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xbe, 0xb7, 0x03, 0x00, /* -O.         aa   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 66 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x9f, 0xfd, 0xff, 0xff, 0xff, 0xfc, 0xe8, 0xbd, 0x6b, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, /*  oXXXXXXa+       */
0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x22, 0x00, 0x00, 0x00, 0x00, /*  XXXXXXXXXO.     */
0x00, 0xff, 0xff, 0xce, 0x55, 0x3b, 0x37, 0x5f, 0xbf, 0xff, 0xff, 0xdb, 0x06, 0x00, 0x00, 0x00, /*  XXO-..-aXXO     */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0x61, 0x00, 0x00, 0x00, /*  XXa     oXX+    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0xff, 0xff, 0x95, 0x00, 0x00, 0x00, /*  XXa      XXo    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, /*  XXa      XXo    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, /*  XXa     +XX-    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x0c, 0x31, 0x8b, 0xfc, 0xff, 0xb9, 0x02, 0x00, 0x00, 0x00, /*  XXa   .oXXa     */
0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x81, 0x07, 0x00, 0x00, 0x00, 0x00, /*  XXXXXXXXXo      */
0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x41, 0x00, 0x00, 0x00, 0x00, /*  XXXXXXXXXO-     */
0x00, 0xff, 0xff, 0xb8, 0x30, 0x30, 0x48, 0x82, 0xd1, 0xff, 0xff, 0xfe, 0x73, 0x00, 0x00, 0x00, /*  XXa..-oOXXX+    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0xdf, 0xff, 0xff, 0x4a, 0x00, 0x00, /*  XXa     -OXX-   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0xff, 0xff, 0x9c, 0x00, 0x00, /*  XXa      .XXo   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xff, 0xff, 0x83, 0x00, 0x00, /*  XXa      .XXo   */
0x01, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xc1, 0xff, 0xfe, 0x2c, 0x00, 0x00, /*  XXa      OXX.   */
0x04, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x36, 0xcb, 0xff, 0xff, 0x91, 0x00, 0x00, 0x00, /*  XXa    .OXXo    */
0x08, 0xff, 0xff, 0xd8, 0x8c, 0x8d, 0x9f, 0xd5, 0xff, 0xff, 0xff, 0xa3, 0x03, 0x00, 0x00, 0x00, /*  XXOoooOXXXa     */
0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x5b, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXXXXXXXO-      */
0x02, 0xc0, 0xfe, 0xfe, 0xef, 0xd8, 0xb6, 0x88, 0x3e, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  OXXXOao.        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 67 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xa4, 0x14, 0x00, /*             +a   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xb1, 0xed, 0xf4, 0xd6, 0xfe, 0xff, 0x7d, 0x00, /*        -aXXOXX+  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xae, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa1, 0x00, /*       aXXXXXXXa  */
0x00, 0x00, 0x00, 0x00, 0x14, 0xd2, 0xff, 0xff, 0xc7, 0x59, 0x3c, 0xa0, 0xff, 0xff, 0xa8, 0x00, /*      OXXO-.aXXa  */
0x00, 0x00, 0x00, 0x03, 0xc1, 0xff, 0xff, 0x86, 0x02, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa1, 0x00, /*     OXXo    XXa  */
0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xfe, 0x48, 0x00, /*    +XXo     OX-  */
0x00, 0x00, 0x17, 0xf0, 0xff, 0xcd, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x25, 0x00, 0x00, /*    XXO       .   */
0x00, 0x00, 0x96, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   oXX.           */
0x00, 0x0c, 0xf3, 0xff, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x52, 0xff, 0xff, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -XX-            */
0x00, 0x95, 0xff, 0xfd, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  oXX             */
0x00, 0xc4, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  OXO             */
0x00, 0xe7, 0xff, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xf6, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xf5, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXO             */
0x00, 0xd4, 0xff, 0xf8, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  OXX             */
0x00, 0x96, 0xff, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xa6, 0xdc, 0x21, 0x00, /*  oXXo       aO.  */
0x00, 0x24, 0xf8, 0xff, 0xfc, 0x5f, 0x00, 0x00, 0x00, 0x16, 0x73, 0xe9, 0xff, 0xf9, 0x25, 0x00, /*  .XXX-    +XXX.  */
0x00, 0x00, 0x57, 0xfe, 0xff, 0xff, 0xd5, 0xb9, 0xd3, 0xfd, 0xff, 0xff, 0xf3, 0x4c, 0x00, 0x00, /*   -XXXOaOXXXX-   */
0x00, 0x00, 0x00, 0x4e, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x9e, 0x23, 0x00, 0x00, 0x00, /*    -XXXXXXXo.    */
0x00, 0x00, 0x00, 0x00, 0x09, 0x4f, 0x77, 0x76, 0x64, 0x3e, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, /*      -+++.       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 68 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0xa5, 0xf9, 0xe3, 0xb6, 0x77, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  aXXa+.          */
0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXXXXXO-        */
0x00, 0xff, 0xff, 0xdc, 0xd2, 0xff, 0xff, 0xff, 0xff, 0xb1, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXOOXXXXa       */
0x00, 0xff, 0xff, 0xae, 0x00, 0x3a, 0xae, 0xfe, 0xff, 0xff, 0xe6, 0x2a, 0x00, 0x00, 0x00, 0x00, /*  XXa .aXXXX.     */
0x00, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 0x34, 0xd7, 0xff, 0xff, 0xe5, 0x14, 0x00, 0x00, 0x00, /*  XXa   .OXXX     */
0x00, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xb8, 0xff, 0xff, 0xab, 0x00, 0x00, 0x00, /*  XXa     aXXa    */
0x00, 0xff, 0xff, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xd1, 0xff, 0xff, 0x4f, 0x00, 0x00, /*  XXa      OXX-   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0xfb, 0xff, 0xc3, 0x00, 0x00, /*  XXa      .XXO   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb3, 0xff, 0xfe, 0x17, 0x00, /*  XXa       aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0xff, 0xff, 0x54, 0x00, /*  XXa       -XX-  */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0xff, 0xff, 0x80, 0x00, /*  XXa       .XXo  */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x98, 0x00, /*  XXa        XXo  */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xa3, 0x00, /*  XXa        XXa  */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xff, 0x94, 0x00, /*  XXa       .XXo  */
0x02, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0xff, 0xff, 0x5f, 0x00, /*  XXa       oXX-  */
0x04, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xe3, 0xff, 0xf5, 0x12, 0x00, /*  XXa       XXX   */
0x09, 0xff, 0xff, 0xd3, 0x40, 0x04, 0x00, 0x00, 0x00, 0x06, 0xa6, 0xff, 0xff, 0x7f, 0x00, 0x00, /*  XXO-     aXX+   */
0x11, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xcf, 0xb9, 0xb4, 0xe4, 0xff, 0xff, 0xbd, 0x03, 0x00, 0x00, /*  XXXXXOaaXXXa    */
0x03, 0xc9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa5, 0x0c, 0x00, 0x00, 0x00, /*  OXXXXXXXXXa     */
0x00, 0x00, 0x0c, 0x30, 0x4f, 0x66, 0x72, 0x79, 0x7d, 0x6a, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, /*    .-+++++.      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 69 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x9f, 0xf3, 0xac, 0xc8, 0xeb, 0xf9, 0xff, 0xff, 0xff, 0xfe, 0xf8, 0xe5, 0x94, 0x00, 0x00, /*  oXaOXXXXXXXXo   */
0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, /*  XXXXXXXXXXXXX   */
0x00, 0xff, 0xff, 0xd3, 0x6a, 0x4b, 0x3d, 0x34, 0x36, 0x3f, 0x49, 0x53, 0x5c, 0x36, 0x00, 0x00, /*  XXO+-....---.   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xb8, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x2b, 0x02, 0x00, 0x00, /*  XXa.........    */
0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x68, 0x00, 0x00, /*  XXXXXXXXXXXX+   */
0x00, 0xff, 0xff, 0xff, 0xfa, 0xee, 0xdf, 0xce, 0xbb, 0xa9, 0x96, 0x84, 0x73, 0x17, 0x00, 0x00, /*  XXXXXOOaaoo+    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xfe, 0xff, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xf4, 0xff, 0xd9, 0x4b, 0x3a, 0x32, 0x30, 0x31, 0x36, 0x41, 0x5a, 0x88, 0x56, 0x00, 0x00, /*  XXO-.....--o-   */
0x00, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x00, /*  OXXXXXXXXXXXX   */
0x00, 0x2d, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2, 0x00, 0x00, /*  .OXXXXXXXXXXa   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x07, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 70 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0xa2, 0xf6, 0xb0, 0xb6, 0xd5, 0xea, 0xf4, 0xfd, 0xfc, 0xf8, 0xef, 0xe1, 0x9f, 0x00, 0x00, /*  aXaaOXXXXXXXo   */
0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x00, 0x00, /*  XXXXXXXXXXXXO   */
0x00, 0xff, 0xff, 0xd0, 0x6f, 0x63, 0x58, 0x4c, 0x42, 0x3e, 0x3a, 0x36, 0x30, 0x0d, 0x00, 0x00, /*  XXO++---....    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xae, 0x1d, 0x29, 0x2e, 0x2c, 0x25, 0x17, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa ....        */
0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xe4, 0x9d, 0x00, 0x00, 0x00, /*  XXXXXXXXXXXo    */
0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x06, 0x00, 0x00, /*  XXXXXXXXXXXX    */
0x00, 0xff, 0xff, 0xac, 0x08, 0x03, 0x00, 0x00, 0x00, 0x00, 0x05, 0x14, 0x0d, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x01, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x04, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x08, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x10, 0xff, 0xff, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x03, 0xca, 0xea, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  OX-             */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 71 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xb9, 0xf1, 0xf1, 0xc1, 0x6d, 0x0d, 0x00, 0x00, /*        -aXXO+    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xb5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xeb, 0x30, 0x00, /*       aXXXXXXX.  */
0x00, 0x00, 0x00, 0x00, 0x13, 0xd2, 0xff, 0xff, 0xbe, 0x52, 0x3e, 0x9a, 0xfb, 0xff, 0x7e, 0x00, /*      OXXa-.oXX+  */
0x00, 0x00, 0x00, 0x02, 0xbd, 0xff, 0xff, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x28, 0x83, 0x1f, 0x00, /*     aXX+    .o   */
0x00, 0x00, 0x00, 0x67, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    +XXo          */
0x00, 0x00, 0x12, 0xec, 0xff, 0xc9, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXO           */
0x00, 0x00, 0x8d, 0xff, 0xff, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   oXX.           */
0x00, 0x07, 0xed, 0xff, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x49, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -XX-            */
0x00, 0x8d, 0xff, 0xfe, 0x0f, 0x00, 0x00, 0x11, 0x32, 0x49, 0x5c, 0x6d, 0x77, 0x72, 0x10, 0x00, /*  oXX    .--+++   */
0x00, 0xbe, 0xff, 0xda, 0x00, 0x47, 0xd7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66, 0x00, /*  aXO -OXXXXXXX+  */
0x00, 0xe3, 0xff, 0xba, 0x00, 0xcb, 0xff, 0xff, 0xea, 0xd2, 0xc1, 0xbd, 0xff, 0xec, 0x15, 0x00, /*  XXa OXXXOOaXX   */
0x00, 0xf5, 0xff, 0xac, 0x00, 0x42, 0x6c, 0x1b, 0x00, 0x00, 0x00, 0x66, 0xff, 0xc3, 0x00, 0x00, /*  XXa -+    +XO   */
0x00, 0xf8, 0xff, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xd4, 0xff, 0x82, 0x00, 0x00, /*  XXa       OXo   */
0x00, 0xd9, 0xff, 0xf5, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xfb, 0x1e, 0x00, 0x00, /*  OXX      +XX    */
0x00, 0xa0, 0xff, 0xff, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x22, 0xf1, 0xff, 0x92, 0x00, 0x00, 0x00, /*  aXX+    .XXo    */
0x00, 0x2d, 0xfb, 0xff, 0xfb, 0x5b, 0x00, 0x00, 0x2e, 0xe2, 0xff, 0xdb, 0x0b, 0x00, 0x00, 0x00, /*  .XXX-  .XXO     */
0x00, 0x00, 0x66, 0xff, 0xff, 0xff, 0xd4, 0xbf, 0xfb, 0xff, 0xe2, 0x21, 0x00, 0x00, 0x00, 0x00, /*   +XXXOaXXX.     */
0x00, 0x00, 0x00, 0x66, 0xef, 0xff, 0xff, 0xff, 0xff, 0xaf, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, /*    +XXXXXa       */
0x00, 0x00, 0x00, 0x00, 0x0c, 0x52, 0x78, 0x6f, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      -++.        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 72 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0xa3, 0xf3, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xf3, 0xa6, 0x00, 0x00, 0x00, /*  aX-      -Xa    */
0x00, 0xfc, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa5, 0xff, 0xfd, 0x00, 0x00, 0x00, /*  XXa      aXX    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*  XXa      aXX    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*  XXa      aXX    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*  XXa      aXX    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*  XXa      aXX    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*  XXa      aXX    */
0x00, 0xff, 0xff, 0xb9, 0x3b, 0x48, 0x59, 0x76, 0x96, 0xba, 0xef, 0xff, 0xff, 0x00, 0x00, 0x00, /*  XXa.--+oaXXX    */
0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, /*  XXXXXXXXXXXX    */
0x00, 0xff, 0xff, 0xff, 0xf5, 0xdd, 0xbe, 0x9a, 0x76, 0x52, 0xbd, 0xff, 0xff, 0x00, 0x00, 0x00, /*  XXXXOao+-aXX    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*  XXa      aXX    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*  XXa      aXX    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*  XXa      aXX    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*  XXa      aXX    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*  XXa      aXX    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*  XXa      aXX    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*  XXa      aXX    */
0x00, 0xfe, 0xff, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xfd, 0x00, 0x00, 0x00, /*  XXa      aXX    */
0x00, 0xb5, 0xea, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0xf4, 0x93, 0x00, 0x00, 0x00, /*  aX-      +Xo    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 73 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0xaf, 0xfc, 0xfd, 0xfb, 0xf9, 0xf4, 0xee, 0xe8, 0xdd, 0xd2, 0xc2, 0xb1, 0x71, 0x00, 0x00, /*  aXXXXXXXOOOa+   */
0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe9, 0x00, 0x00, /*  OXXXXXXXXXXXX   */
0x00, 0x09, 0x2d, 0x30, 0x30, 0x30, 0xb8, 0xff, 0xff, 0x31, 0x33, 0x39, 0x48, 0x24, 0x00, 0x00, /*   ....aXX...-.   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x0a, 0x2d, 0x30, 0x30, 0x30, 0xb8, 0xff, 0xff, 0x30, 0x30, 0x30, 0x30, 0x16, 0x00, 0x00, /*   ....aXX....    */
0x00, 0xd7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x05, 0x00, /*  OXXXXXXXXXXXX   */
0x00, 0xbf, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x03, 0x00, /*  aXXXXXXXXXXXX   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x11, 0x0b, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 74 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0xaf, 0xfc, 0xfd, 0xfb, 0xf9, 0xf4, 0xee, 0xe7, 0xdb, 0xd0, 0xc0, 0xad, 0x6c, 0x00, 0x00, /*  aXXXXXXXOOOa+   */
0x00, 0xdd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xeb, 0x00, 0x00, /*  OXXXXXXXXXXXX   */
0x00, 0x0b, 0x2e, 0x30, 0x30, 0x30, 0x30, 0xb8, 0xff, 0xff, 0x33, 0x39, 0x4c, 0x27, 0x00, 0x00, /*   .....aXX..-.   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*        aXX       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*        aXX       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*        aXX       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*        aXX       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*        aXX       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*        aXX       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*        aXX       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*        aXX       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*        aXX       */
0x02, 0x6b, 0x49, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  +-    aXX       */
0x4c, 0xff, 0xeb, 0x00, 0x00, 0x00, 0x00, 0xab, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* -XX    aXX       */
0x53, 0xff, 0xff, 0x1d, 0x00, 0x00, 0x00, 0xb5, 0xff, 0xd7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* -XX    aXO       */
0x0f, 0xf2, 0xff, 0x88, 0x00, 0x00, 0x00, 0xcc, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXo   OXa       */
0x00, 0x78, 0xff, 0xf9, 0x51, 0x00, 0x09, 0xf5, 0xff, 0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  +XX-  XX+       */
0x00, 0x01, 0xa8, 0xff, 0xff, 0xd4, 0xcb, 0xff, 0xfe, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   aXXOOXX.       */
0x00, 0x00, 0x01, 0x7a, 0xf0, 0xff, 0xff, 0xff, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    +XXXXo        */
0x00, 0x00, 0x00, 0x00, 0x0d, 0x4f, 0x72, 0x59, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      -+-         */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 75 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x1e, 0x00, 0x00, 0x00, /*            .     */
0x00, 0xa6, 0xf2, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xfd, 0xcf, 0x00, 0x00, 0x00, /*  aX-      +XO    */
0x00, 0xfc, 0xff, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0xff, 0xff, 0x95, 0x00, 0x00, 0x00, /*  XXa     +XXo    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xc1, 0x08, 0x00, 0x00, 0x00, /*  XXa    +XXO     */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x72, 0xff, 0xff, 0xcd, 0x0e, 0x00, 0x00, 0x00, 0x00, /*  XXa   +XXO      */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x6d, 0xff, 0xff, 0xd6, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa  +XXO       */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x67, 0xff, 0xff, 0xdb, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa +XXO        */
0x00, 0xff, 0xff, 0xa8, 0x61, 0xfe, 0xff, 0xdf, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa+XXO         */
0x00, 0xff, 0xff, 0xe3, 0xfd, 0xff, 0xdf, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXXXXO.         */
0x00, 0xff, 0xff, 0xff, 0xff, 0xde, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXXXO           */
0x00, 0xff, 0xff, 0xff, 0xff, 0xce, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXXXO           */
0x00, 0xff, 0xff, 0xef, 0xff, 0xff, 0xcb, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXXXXO          */
0x00, 0xff, 0xff, 0xa8, 0x8f, 0xff, 0xff, 0xcc, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXaoXXO         */
0x00, 0xff, 0xff, 0xa8, 0x01, 0x9e, 0xff, 0xff, 0xd1, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa oXXO        */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x02, 0xa4, 0xff, 0xff, 0xd5, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa  aXXO       */
0x01, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x02, 0xa2, 0xff, 0xff, 0xd8, 0x19, 0x00, 0x00, 0x00, 0x00, /*  XXa   aXXO      */
0x04, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x02, 0x9e, 0xff, 0xff, 0xd9, 0x19, 0x00, 0x00, 0x00, /*  XXa    oXXO     */
0x08, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x95, 0xff, 0xff, 0xd6, 0x14, 0x00, 0x00, /*  XXa     oXXO    */
0x10, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8b, 0xff, 0xff, 0xb5, 0x00, 0x00, /*  XXa      oXXa   */
0x03, 0xca, 0xea, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x89, 0xff, 0xc2, 0x00, 0x00, /*  OX-       oXO   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x16, 0x00, 0x00, /*             -    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 76 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0xa3, 0xf1, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  aX-             */
0x00, 0xfc, 0xff, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x02, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x09, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x10, 0xff, 0xff, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXo             */
0x20, 0xff, 0xff, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* .XXo             */
0x35, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* .XX+             */
0x49, 0xff, 0xff, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* -XX-             */
0x63, 0xff, 0xff, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* +XX.             */
0x7e, 0xff, 0xff, 0x53, 0x36, 0x40, 0x53, 0x68, 0x80, 0x9e, 0xc2, 0xef, 0xb5, 0x00, 0x00, 0x00, /* +XX-.--+ooOXa    */
0x93, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x00, 0x00, 0x00, /* oXXXXXXXXXXXX    */
0x59, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xf7, 0xe9, 0xd3, 0xaf, 0x54, 0x00, 0x00, 0x00, /* -XXXXXXXXXOa-    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 77 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x15, 0xc8, 0xf2, 0x74, 0x00, 0x00, 0x00, 0x11, 0xcd, 0xfc, 0xab, 0x00, 0x00, 0x00, /*    OX+    OXa    */
0x00, 0x00, 0x80, 0xff, 0xff, 0xed, 0x00, 0x00, 0x00, 0x67, 0xff, 0xff, 0xff, 0x0a, 0x00, 0x00, /*   oXXX   +XXX    */
0x00, 0x00, 0xb4, 0xff, 0xff, 0xff, 0x20, 0x00, 0x00, 0x9e, 0xff, 0xf0, 0xff, 0x20, 0x00, 0x00, /*   aXXX.  oXXX.   */
0x00, 0x00, 0xd8, 0xf9, 0xff, 0xff, 0x49, 0x00, 0x00, 0xd0, 0xff, 0xc4, 0xff, 0x34, 0x00, 0x00, /*   OXXX-  OXOX.   */
0x00, 0x00, 0xf4, 0xd0, 0xe5, 0xff, 0x6e, 0x00, 0x04, 0xfa, 0xff, 0x98, 0xff, 0x47, 0x00, 0x00, /*   XOXX+  XXoX-   */
0x00, 0x0e, 0xff, 0xa8, 0xbf, 0xff, 0x91, 0x00, 0x24, 0xff, 0xed, 0x7e, 0xff, 0x5a, 0x00, 0x00, /*   XaaXo .XX+X-   */
0x00, 0x25, 0xff, 0x8b, 0x99, 0xff, 0xb2, 0x00, 0x48, 0xff, 0xcb, 0x7c, 0xff, 0x6d, 0x00, 0x00, /*  .XooXa -XO+X+   */
0x00, 0x3b, 0xff, 0x80, 0x72, 0xff, 0xd4, 0x00, 0x6c, 0xff, 0xaf, 0x7a, 0xff, 0x7f, 0x00, 0x00, /*  .Xo+XO +Xa+X+   */
0x00, 0x4f, 0xff, 0x80, 0x4c, 0xff, 0xf3, 0x00, 0x8f, 0xff, 0x93, 0x77, 0xff, 0x92, 0x00, 0x00, /*  -Xo-XX oXo+Xo   */
0x00, 0x62, 0xff, 0x80, 0x24, 0xff, 0xff, 0x11, 0xac, 0xff, 0x78, 0x73, 0xff, 0xa4, 0x00, 0x00, /*  +Xo.XX aX++Xa   */
0x00, 0x76, 0xff, 0x80, 0x03, 0xf8, 0xff, 0x2f, 0xc5, 0xff, 0x5f, 0x6e, 0xff, 0xb6, 0x00, 0x00, /*  +Xo XX.OX-+Xa   */
0x00, 0x8a, 0xff, 0x80, 0x00, 0xd4, 0xff, 0x4d, 0xde, 0xff, 0x46, 0x69, 0xff, 0xc9, 0x00, 0x00, /*  oXo OX-OX-+XO   */
0x00, 0x9e, 0xff, 0x82, 0x00, 0xab, 0xff, 0x6a, 0xf5, 0xff, 0x2a, 0x61, 0xff, 0xdd, 0x00, 0x00, /*  oXo aX+XX.+XO   */
0x00, 0xb5, 0xff, 0x87, 0x00, 0x82, 0xff, 0x91, 0xff, 0xff, 0x0a, 0x58, 0xff, 0xf2, 0x00, 0x00, /*  aXo oXoXX -XX   */
0x00, 0xcd, 0xff, 0x8e, 0x00, 0x57, 0xff, 0xc4, 0xff, 0xe8, 0x00, 0x4e, 0xff, 0xff, 0x08, 0x00, /*  OXo -XOXX -XX   */
0x00, 0xe4, 0xff, 0x98, 0x00, 0x2a, 0xff, 0xf5, 0xff, 0xc3, 0x00, 0x3f, 0xff, 0xff, 0x1f, 0x00, /*  XXo .XXXO .XX   */
0x00, 0xf9, 0xff, 0xa3, 0x00, 0x04, 0xf8, 0xff, 0xff, 0x99, 0x00, 0x2a, 0xff, 0xff, 0x3b, 0x00, /*  XXa  XXXo .XX.  */
0x00, 0xf6, 0xff, 0x9a, 0x00, 0x00, 0xcd, 0xff, 0xff, 0x69, 0x00, 0x0b, 0xfd, 0xff, 0x5e, 0x00, /*  XXo  OXX+  XX-  */
0x00, 0xa2, 0xe5, 0x32, 0x00, 0x00, 0x68, 0xf1, 0xd2, 0x19, 0x00, 0x00, 0xa6, 0xfd, 0x3d, 0x00, /*  aX.  +XO   aX.  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x18, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 78 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x7c, 0xf3, 0xee, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xf5, 0x8e, 0x00, 0x00, /*  +XX-      oXo   */
0x00, 0xf5, 0xff, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd4, 0xff, 0xe9, 0x00, 0x00, /*  XXXO      OXX   */
0x00, 0xff, 0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xf8, 0x00, 0x00, /*  XXXX.     OXX   */
0x00, 0xff, 0xff, 0xfd, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xfc, 0x00, 0x00, /*  XXXXa     aXX   */
0x00, 0xff, 0xff, 0xbc, 0xf9, 0xf9, 0x19, 0x00, 0x00, 0x00, 0x00, 0xb1, 0xff, 0xfe, 0x00, 0x00, /*  XXaXX     aXX   */
0x00, 0xff, 0xff, 0xa8, 0xa8, 0xff, 0x89, 0x00, 0x00, 0x00, 0x00, 0xab, 0xff, 0xff, 0x00, 0x00, /*  XXaaXo    aXX   */
0x00, 0xff, 0xff, 0xa8, 0x36, 0xff, 0xf2, 0x11, 0x00, 0x00, 0x00, 0xaa, 0xff, 0xff, 0x00, 0x00, /*  XXa.XX    aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0xc0, 0xff, 0x7f, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, /*  XXa OX+   aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x43, 0xff, 0xef, 0x0e, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, /*  XXa -XX   aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0xc0, 0xff, 0x7c, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, /*  XXa  OX+  aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x3b, 0xff, 0xee, 0x0f, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, /*  XXa  .XX  aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0xb2, 0xff, 0x80, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, /*  XXa   aXo aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x29, 0xfc, 0xf1, 0x13, 0xa8, 0xff, 0xff, 0x00, 0x00, /*  XXa   .XX aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0x8b, 0xa8, 0xff, 0xff, 0x00, 0x00, /*  XXa    oXoaXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x17, 0xf3, 0xf8, 0xc6, 0xff, 0xfd, 0x00, 0x00, /*  XXa     XXOXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00, /*  XXa     +XXXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xe4, 0xff, 0xff, 0xf1, 0x00, 0x00, /*  XXa      XXXX   */
0x00, 0xfa, 0xff, 0x9f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0xff, 0xff, 0xdf, 0x00, 0x00, /*  XXo      +XXO   */
0x00, 0xb1, 0xea, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xb7, 0xf2, 0x81, 0x00, 0x00, /*  aX-       aXo   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 79 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x25, 0x94, 0xda, 0xf8, 0xf0, 0xba, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, /*     .oOXXa-      */
0x00, 0x00, 0x00, 0x62, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8d, 0x00, 0x00, 0x00, 0x00, /*    +XXXXXXXo     */
0x00, 0x00, 0x61, 0xff, 0xff, 0xf3, 0x75, 0x37, 0x5b, 0xe0, 0xff, 0xff, 0x61, 0x00, 0x00, 0x00, /*   +XXX+.-XXX+    */
0x00, 0x11, 0xed, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x20, 0xf5, 0xff, 0xe4, 0x03, 0x00, 0x00, /*   XXX-   .XXX    */
0x00, 0x65, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x89, 0xff, 0xff, 0x42, 0x00, 0x00, /*  +XXa     oXX-   */
0x00, 0xb1, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0xff, 0xff, 0x76, 0x00, 0x00, /*  aXX-     -XX+   */
0x00, 0xdb, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xff, 0x90, 0x00, 0x00, /*  OXX       XXo   */
0x00, 0xf4, 0xff, 0xf5, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0xff, 0xff, 0x9b, 0x00, 0x00, /*  XXX       XXo   */
0x00, 0xff, 0xff, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0xa5, 0x00, 0x00, /*  XXO       XXa   */
0x00, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xa8, 0x00, 0x00, /*  XXO       XXa   */
0x00, 0xff, 0xff, 0xb5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xa8, 0x00, 0x00, /*  XXa       XXa   */
0x00, 0xff, 0xff, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0xff, 0xff, 0xa7, 0x00, 0x00, /*  XXa       XXa   */
0x00, 0xf6, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0x9e, 0x00, 0x00, /*  XXa      .XXo   */
0x00, 0xde, 0xff, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0xff, 0x85, 0x00, 0x00, /*  OXO      -XXo   */
0x00, 0xa5, 0xff, 0xfc, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb1, 0xff, 0xff, 0x47, 0x00, 0x00, /*  aXX      aXX-   */
0x00, 0x4e, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0xe0, 0x04, 0x00, 0x00, /*  -XX+    +XXX    */
0x00, 0x00, 0xbf, 0xff, 0xfc, 0x76, 0x37, 0x52, 0xac, 0xff, 0xff, 0xff, 0x58, 0x00, 0x00, 0x00, /*   aXX+.-aXXX-    */
0x00, 0x00, 0x17, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7d, 0x00, 0x00, 0x00, 0x00, /*    OXXXXXXX+     */
0x00, 0x00, 0x00, 0x0d, 0x7f, 0xd7, 0xf8, 0xf2, 0xda, 0x99, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, /*     +OXXOo.      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 80 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x09, 0xad, 0xe6, 0xf7, 0xff, 0xff, 0xff, 0xef, 0xcf, 0x84, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, /*  aXXXXXXOo       */
0x3a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x4d, 0x00, 0x00, 0x00, 0x00, /* .XXXXXXXXXX-     */
0x04, 0xff, 0xff, 0xc9, 0x52, 0x3e, 0x33, 0x47, 0x93, 0xfa, 0xff, 0xf7, 0x2c, 0x00, 0x00, 0x00, /*  XXO-..-oXXX.    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0xfe, 0xff, 0xa4, 0x00, 0x00, 0x00, /*  XXa     -XXa    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xff, 0xe1, 0x00, 0x00, 0x00, /*  XXa      OXX    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xff, 0xf9, 0x00, 0x00, 0x00, /*  XXa      aXX    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xe6, 0x00, 0x00, 0x00, /*  XXa      aXX    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xea, 0xff, 0xae, 0x00, 0x00, 0x00, /*  XXa      XXa    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x53, 0x00, 0x00, 0x00, /*  XXa     +XX-    */
0x00, 0xff, 0xff, 0xc3, 0x26, 0x08, 0x0c, 0x31, 0x90, 0xfd, 0xff, 0xc4, 0x02, 0x00, 0x00, 0x00, /*  XXO.  .oXXO     */
0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd7, 0x1b, 0x00, 0x00, 0x00, 0x00, /*  XXXXXXXXXO      */
0x00, 0xff, 0xff, 0xfa, 0xfe, 0xff, 0xff, 0xff, 0xe8, 0x87, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXXXXXXXo       */
0x00, 0xff, 0xff, 0xa8, 0x0b, 0x24, 0x2c, 0x1d, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa ..          */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXO             */
0x00, 0xff, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXO             */
0x00, 0xfe, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXX             */
0x00, 0xaf, 0xf6, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  aXo             */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 81 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x06, 0x6a, 0xc4, 0xf2, 0xf8, 0xd4, 0x7a, 0x09, 0x00, 0x00, 0x00, 0x00, /*      +OXXO+      */
0x00, 0x00, 0x00, 0x19, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x12, 0x00, 0x00, 0x00, /*     OXXXXXXO     */
0x00, 0x00, 0x0c, 0xdd, 0xff, 0xf6, 0x7c, 0x3f, 0x4d, 0xc4, 0xff, 0xff, 0xb1, 0x00, 0x00, 0x00, /*    OXX+.-OXXa    */
0x00, 0x00, 0x88, 0xff, 0xfc, 0x39, 0x00, 0x00, 0x00, 0x06, 0xcf, 0xff, 0xff, 0x30, 0x00, 0x00, /*   oXX.    OXX.   */
0x00, 0x05, 0xf0, 0xff, 0x97, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0xff, 0x84, 0x00, 0x00, /*   XXo     -XXo   */
0x00, 0x44, 0xff, 0xff, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xf7, 0xff, 0xb6, 0x00, 0x00, /*  -XX.      XXa   */
0x00, 0x7d, 0xff, 0xf9, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd3, 0xff, 0xd5, 0x00, 0x00, /*  +XX       OXO   */
0x00, 0xad, 0xff, 0xd5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xe9, 0x00, 0x00, /*  aXO       OXX   */
0x00, 0xcc, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xf5, 0x00, 0x00, /*  OXa       aXX   */
0x00, 0xe6, 0xff, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xff, 0xfb, 0x00, 0x00, /*  XXa       aXX   */
0x00, 0xf4, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xfe, 0x00, 0x00, /*  XXa       aXX   */
0x00, 0xfc, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb5, 0xff, 0xf8, 0x00, 0x00, /*  XXa       aXX   */
0x00, 0xf9, 0xff, 0xb9, 0x00, 0x00, 0x18, 0x6a, 0x01, 0x00, 0x00, 0xc5, 0xff, 0xea, 0x00, 0x00, /*  XXa   +   OXX   */
0x00, 0xdf, 0xff, 0xe6, 0x00, 0x00, 0x98, 0xff, 0x59, 0x00, 0x00, 0xe1, 0xff, 0xcb, 0x00, 0x00, /*  OXX  oX-  XXO   */
0x00, 0x9e, 0xff, 0xff, 0x40, 0x00, 0x8b, 0xff, 0xc5, 0x00, 0x2e, 0xff, 0xff, 0x93, 0x00, 0x00, /*  oXX- oXO .XXo   */
0x00, 0x37, 0xff, 0xff, 0xcf, 0x0b, 0x2f, 0xff, 0xff, 0x4a, 0xba, 0xff, 0xff, 0x3c, 0x00, 0x00, /*  .XXO .XX-aXX.   */
0x00, 0x00, 0xa3, 0xff, 0xff, 0xcd, 0x53, 0xcb, 0xff, 0xfa, 0xff, 0xff, 0xae, 0x00, 0x00, 0x00, /*   aXXO-OXXXXa    */
0x00, 0x00, 0x07, 0xbd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb5, 0x0b, 0x00, 0x00, 0x00, /*    aXXXXXXXa     */
0x00, 0x00, 0x00, 0x03, 0x64, 0xc4, 0xf2, 0xfa, 0xf2, 0xff, 0xfb, 0x29, 0x00, 0x00, 0x00, 0x00, /*     +OXXXXX.     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xe2, 0xff, 0xcd, 0x06, 0x00, 0x00, 0x00, /*          XXO     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0xff, 0xff, 0x8f, 0x00, 0x00, 0x00, /*          -XXo    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb1, 0xff, 0xff, 0x50, 0x00, 0x00, /*           aXX-   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xee, 0xff, 0xdf, 0x00, 0x00, /*            XXO   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4d, 0xf7, 0xa3, 0x00, 0x00, /*            -Xa   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 82 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x26, 0xd3, 0xfe, 0xfc, 0xed, 0xd4, 0xa0, 0x5c, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* .OXXXOa-         */
0x79, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x82, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, /* +XXXXXXXXo       */
0x5d, 0xff, 0xff, 0xb5, 0x56, 0xa4, 0xf7, 0xff, 0xff, 0xff, 0xd1, 0x18, 0x00, 0x00, 0x00, 0x00, /* -XXa-aXXXXO      */
0x36, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x11, 0x86, 0xf8, 0xff, 0xff, 0xd0, 0x08, 0x00, 0x00, 0x00, /* .XXa   oXXXO     */
0x14, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x25, 0xd9, 0xff, 0xff, 0x78, 0x00, 0x00, 0x00, /*  XXa    .OXX+    */
0x03, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xf9, 0xff, 0xd4, 0x00, 0x00, 0x00, /*  XXa     .XXO    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xf8, 0x00, 0x00, 0x00, /*  XXa      aXX    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xd4, 0xff, 0xe1, 0x00, 0x00, 0x00, /*  XXa      OXX    */
0x00, 0xff, 0xff, 0xa9, 0x00, 0x00, 0x00, 0x19, 0x50, 0xbc, 0xff, 0xff, 0x87, 0x00, 0x00, 0x00, /*  XXa    -aXXo    */
0x00, 0xff, 0xff, 0xfb, 0xed, 0xed, 0xf9, 0xff, 0xff, 0xff, 0xfd, 0x9b, 0x05, 0x00, 0x00, 0x00, /*  XXXXXXXXXXo     */
0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xd3, 0xac, 0x75, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXXXXXOa+.      */
0x00, 0xff, 0xff, 0xee, 0xfd, 0xff, 0xdf, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXXXXO-         */
0x00, 0xff, 0xff, 0xae, 0x37, 0xdb, 0xff, 0xff, 0xac, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa.OXXa        */
0x00, 0xff, 0xff, 0xb8, 0x00, 0x0d, 0xb3, 0xff, 0xff, 0xda, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa  aXXO.      */
0x00, 0xff, 0xff, 0xcc, 0x00, 0x00, 0x02, 0x92, 0xff, 0xff, 0xf1, 0x3d, 0x00, 0x00, 0x00, 0x00, /*  XXO   oXXX.     */
0x01, 0xff, 0xff, 0xe1, 0x00, 0x00, 0x00, 0x00, 0x73, 0xff, 0xff, 0xf4, 0x35, 0x00, 0x00, 0x00, /*  XXX    +XXX.    */
0x07, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xe4, 0x12, 0x00, 0x00, /*  XXX     +XXX    */
0x13, 0xff, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0x82, 0x00, 0x00, /*  XXX      +XXo   */
0x04, 0xc5, 0xf6, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9b, 0xff, 0x5b, 0x00, 0x00, /*  OXa       oX-   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 83 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x31, 0x8f, 0xcc, 0xf0, 0xfc, 0xf4, 0xdd, 0xb5, 0x4b, 0x00, 0x00, 0x00, /*     .oOXXXOa-    */
0x00, 0x00, 0x06, 0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x00, 0x00, /*    oXXXXXXXXX    */
0x00, 0x06, 0xc1, 0xff, 0xff, 0xcb, 0x6f, 0x40, 0x33, 0x3e, 0x5f, 0x98, 0x88, 0x00, 0x00, 0x00, /*   OXXO+-..-oo    */
0x00, 0x76, 0xff, 0xff, 0x7d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  +XX+            */
0x00, 0xd6, 0xff, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  OXO             */
0x00, 0xf8, 0xff, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xd1, 0xff, 0xfa, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  OXX-            */
0x00, 0x5a, 0xff, 0xff, 0xfd, 0xb5, 0x88, 0x71, 0x52, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -XXXao+-        */
0x00, 0x00, 0x7a, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x9d, 0x0f, 0x00, 0x00, 0x00, 0x00, /*   +XXXXXXXo      */
0x00, 0x00, 0x00, 0x19, 0x60, 0x8d, 0xb7, 0xf1, 0xff, 0xff, 0xff, 0xc1, 0x07, 0x00, 0x00, 0x00, /*     +oaXXXXO     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x63, 0xed, 0xff, 0xff, 0x7b, 0x00, 0x00, 0x00, /*         +XXX+    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xfb, 0xff, 0xd3, 0x00, 0x00, 0x00, /*          .XXO    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xf4, 0x00, 0x00, 0x00, /*           OXX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xf1, 0x00, 0x00, 0x00, /*           aXX    */
0x06, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xe8, 0xff, 0xc4, 0x00, 0x00, 0x06, /*           XXO    */
0xde, 0xf5, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xa2, 0xff, 0xff, 0x67, 0x00, 0x00, 0x07, /* OX.      aXX+    */
0xf5, 0xff, 0xe8, 0x47, 0x00, 0x00, 0x01, 0x41, 0xc5, 0xff, 0xff, 0xca, 0x05, 0x00, 0x00, 0x00, /* XXX-   -OXXO     */
0x6c, 0xff, 0xff, 0xff, 0xe6, 0xcf, 0xed, 0xff, 0xff, 0xff, 0xbc, 0x13, 0x00, 0x00, 0x00, 0x00, /* +XXXXOXXXXa      */
0x00, 0x58, 0xe5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe9, 0x76, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -XXXXXXX+       */
0x00, 0x00, 0x03, 0x41, 0x6a, 0x7b, 0x6a, 0x3c, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    -+++.         */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 84 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x1a, 0x38, 0x24, 0x18, 0x10, 0x0b, 0x07, 0x04, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, /*   ..             */
0x00, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0x00, 0x00, /*  OXXXXXXXXXXXa   */
0x00, 0xb3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x00, 0x00, /*  aXXXXXXXXXXXX   */
0x00, 0x00, 0x0c, 0x1a, 0x1e, 0x20, 0xb3, 0xff, 0xff, 0x64, 0x64, 0x64, 0x63, 0x29, 0x00, 0x00, /*      .aXX++++.   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa9, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xab, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xae, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb3, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb9, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xf5, 0x8f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       +Xo        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 85 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x90, 0xf4, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0xf6, 0x9d, 0x00, 0x00, /*  oX+       -Xo   */
0x00, 0xfa, 0xff, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xff, 0xfb, 0x00, 0x00, /*  XXa       aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, /*  XXa       aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, /*  XXa       aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, /*  XXa       aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, /*  XXa       aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, /*  XXa       aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, /*  XXa       aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, /*  XXa       aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, /*  XXa       aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, /*  XXa       aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, /*  XXa       aXX   */
0x00, 0xfd, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xad, 0xff, 0xf6, 0x00, 0x00, /*  XXa       aXX   */
0x00, 0xec, 0xff, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xd8, 0x00, 0x00, /*  XXO       OXO   */
0x00, 0xc1, 0xff, 0xf7, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xf2, 0xff, 0x9d, 0x00, 0x00, /*  OXX       XXo   */
0x00, 0x75, 0xff, 0xff, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x69, 0xff, 0xff, 0x3d, 0x00, 0x00, /*  +XX+     +XX.   */
0x00, 0x12, 0xec, 0xff, 0xf2, 0x4b, 0x00, 0x00, 0x00, 0x58, 0xf6, 0xff, 0xa4, 0x00, 0x00, 0x00, /*   XXX-   -XXa    */
0x00, 0x00, 0x48, 0xf6, 0xff, 0xff, 0xce, 0xb6, 0xde, 0xff, 0xff, 0xc7, 0x0f, 0x00, 0x00, 0x00, /*   -XXXOaOXXO     */
0x00, 0x00, 0x00, 0x3b, 0xde, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x8a, 0x09, 0x00, 0x00, 0x00, 0x00, /*    .OXXXXXo      */
0x00, 0x00, 0x00, 0x00, 0x04, 0x44, 0x6e, 0x75, 0x53, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      -++-        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 86 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x16, 0x68, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4b, 0x43, 0x00, 0x00, /*  +          --   */
0x96, 0xff, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0xff, 0xfc, 0x15, 0x00, /* oXo        .XX   */
0x94, 0xff, 0xe8, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xf9, 0x0f, 0x00, /* oXX        oXX   */
0x5a, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe1, 0xff, 0xa9, 0x00, 0x00, /* -XX.       XXa   */
0x14, 0xfd, 0xff, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xff, 0xff, 0x4c, 0x00, 0x00, /*  XXo      .XX-   */
0x00, 0xc4, 0xff, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xed, 0x05, 0x00, 0x00, /*  OXO      oXX    */
0x00, 0x76, 0xff, 0xfe, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd2, 0xff, 0x9a, 0x00, 0x00, 0x00, /*  +XX      OXo    */
0x00, 0x25, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x21, 0xff, 0xff, 0x43, 0x00, 0x00, 0x00, /*  .XX+    .XX-    */
0x00, 0x00, 0xd4, 0xff, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x72, 0xff, 0xe9, 0x03, 0x00, 0x00, 0x00, /*   OXa    +XX     */
0x00, 0x00, 0x83, 0xff, 0xf5, 0x08, 0x00, 0x00, 0x00, 0xc1, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, /*   oXX    OXo     */
0x00, 0x00, 0x2f, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x14, 0xfc, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, /*   .XX-   XX-     */
0x00, 0x00, 0x00, 0xdc, 0xff, 0x99, 0x00, 0x00, 0x62, 0xff, 0xe9, 0x03, 0x00, 0x00, 0x00, 0x00, /*    OXo  +XX      */
0x00, 0x00, 0x00, 0x88, 0xff, 0xe7, 0x01, 0x00, 0xb3, 0xff, 0x97, 0x00, 0x00, 0x00, 0x00, 0x00, /*    oXX  aXo      */
0x00, 0x00, 0x00, 0x34, 0xff, 0xff, 0x38, 0x0d, 0xf8, 0xff, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, /*    .XX. XX-      */
0x00, 0x00, 0x00, 0x00, 0xdd, 0xff, 0x88, 0x57, 0xff, 0xed, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, /*     OXo-XX       */
0x00, 0x00, 0x00, 0x00, 0x87, 0xff, 0xdb, 0xac, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     oXOaXa       */
0x00, 0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0xfb, 0xff, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     .XXXX-       */
0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0xf9, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      OXXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x79, 0xff, 0xff, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      +XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xc4, 0xf6, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       OX-        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 87 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x4f, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, /* -.             . */
0xff, 0xec, 0x00, 0x00, 0x00, 0x50, 0xec, 0xdd, 0x1d, 0x00, 0x00, 0x78, 0xf1, 0x4e, 0x00, 0x3f, /* XX   -XO   +X- . */
0xff, 0xff, 0x05, 0x00, 0x00, 0xb4, 0xff, 0xff, 0x5d, 0x00, 0x00, 0xf2, 0xff, 0x9e, 0x00, 0x2f, /* XX   aXX-  XXo . */
0xff, 0xff, 0x13, 0x00, 0x00, 0xe2, 0xff, 0xff, 0x82, 0x00, 0x00, 0xff, 0xff, 0xa3, 0x00, 0x19, /* XX   XXXo  XXa   */
0xff, 0xff, 0x24, 0x00, 0x0a, 0xfe, 0xf4, 0xff, 0xa2, 0x00, 0x00, 0xff, 0xff, 0x97, 0x00, 0x05, /* XX.  XXXa  XXo   */
0xfe, 0xff, 0x37, 0x00, 0x2e, 0xff, 0xc3, 0xff, 0xc3, 0x00, 0x00, 0xff, 0xff, 0x85, 0x00, 0x00, /* XX. .XOXO  XXo   */
0xee, 0xff, 0x4a, 0x00, 0x50, 0xff, 0x92, 0xff, 0xe3, 0x00, 0x00, 0xff, 0xff, 0x6f, 0x00, 0x00, /* XX- -XoXX  XX+   */
0xd9, 0xff, 0x5e, 0x00, 0x71, 0xff, 0x69, 0xf9, 0xfd, 0x04, 0x03, 0xff, 0xff, 0x58, 0x00, 0x00, /* OX- +X+XX  XX-   */
0xc2, 0xff, 0x73, 0x00, 0x91, 0xff, 0x4f, 0xe3, 0xff, 0x1f, 0x07, 0xff, 0xff, 0x40, 0x00, 0x00, /* OX+ oX-XX  XX-   */
0xab, 0xff, 0x88, 0x00, 0xb1, 0xff, 0x34, 0xcd, 0xff, 0x3d, 0x0b, 0xff, 0xff, 0x29, 0x00, 0x00, /* aXo aX.OX. XX.   */
0x96, 0xff, 0x9e, 0x00, 0xd0, 0xff, 0x18, 0xb7, 0xff, 0x5c, 0x16, 0xff, 0xff, 0x10, 0x00, 0x00, /* oXo OX aX- XX    */
0x7f, 0xff, 0xb4, 0x00, 0xef, 0xfa, 0x02, 0xa2, 0xff, 0x7b, 0x24, 0xff, 0xf7, 0x00, 0x00, 0x00, /* +Xa XX aX+.XX    */
0x67, 0xff, 0xca, 0x0d, 0xff, 0xe1, 0x00, 0x8b, 0xff, 0x9c, 0x33, 0xff, 0xdd, 0x00, 0x00, 0x00, /* +XO XX oXo.XO    */
0x4f, 0xff, 0xe0, 0x2c, 0xff, 0xc5, 0x00, 0x72, 0xff, 0xc2, 0x4c, 0xff, 0xc1, 0x00, 0x00, 0x00, /* -XX.XO +XO-XO    */
0x36, 0xff, 0xf8, 0x4a, 0xff, 0xa7, 0x00, 0x57, 0xff, 0xe9, 0x66, 0xff, 0xa5, 0x00, 0x00, 0x00, /* .XX-Xa -XX+Xa    */
0x16, 0xff, 0xff, 0x7c, 0xff, 0x88, 0x00, 0x36, 0xff, 0xff, 0x9e, 0xff, 0x88, 0x00, 0x00, 0x00, /*  XX+Xo .XXoXo    */
0x00, 0xf0, 0xff, 0xb5, 0xff, 0x66, 0x00, 0x10, 0xff, 0xff, 0xed, 0xff, 0x66, 0x00, 0x00, 0x00, /*  XXaX+  XXXX+    */
0x00, 0xc9, 0xff, 0xef, 0xff, 0x40, 0x00, 0x00, 0xe6, 0xff, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, /*  OXXX-  XXXX.    */
0x00, 0xa0, 0xff, 0xff, 0xff, 0x14, 0x00, 0x00, 0xb2, 0xff, 0xff, 0xf4, 0x09, 0x00, 0x00, 0x00, /*  aXXX   aXXX     */
0x00, 0x48, 0xf5, 0xfa, 0x92, 0x00, 0x00, 0x00, 0x43, 0xe8, 0xea, 0x5e, 0x00, 0x00, 0x00, 0x00, /*  -XXo   -XX-     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 88 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, /*                  */
0x0d, 0xd3, 0xe0, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xfb, 0x42, 0x00, 0x00, /*  OX.       aX-   */
0x20, 0xff, 0xff, 0xcf, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0x5c, 0x00, 0x00, /* .XXO      -XX-   */
0x00, 0xaa, 0xff, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xe7, 0xff, 0xdd, 0x07, 0x00, 0x00, /*  aXX+     XXO    */
0x00, 0x18, 0xef, 0xff, 0xf5, 0x1d, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0x4b, 0x00, 0x00, 0x00, /*   XXX    oXX-    */
0x00, 0x00, 0x63, 0xff, 0xff, 0xac, 0x00, 0x00, 0x1b, 0xf6, 0xff, 0xb1, 0x00, 0x00, 0x00, 0x00, /*   +XXa   XXa     */
0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0x44, 0x00, 0x9d, 0xff, 0xf6, 0x20, 0x00, 0x00, 0x00, 0x00, /*    aXX- oXX.     */
0x00, 0x00, 0x00, 0x23, 0xf6, 0xff, 0xd6, 0x2f, 0xfc, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, /*    .XXO.XX+      */
0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xeb, 0xff, 0xdd, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, /*     +XXXXO       */
0x00, 0x00, 0x00, 0x00, 0x03, 0xce, 0xff, 0xff, 0xff, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      OXXX-       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      +XXO        */
0x00, 0x00, 0x00, 0x00, 0x12, 0xeb, 0xff, 0xff, 0xff, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XXXX.       */
0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xee, 0xe1, 0xff, 0xcd, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, /*     oXXXXO       */
0x00, 0x00, 0x00, 0x38, 0xfe, 0xff, 0x63, 0x5d, 0xff, 0xff, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, /*    .XX+-XX+      */
0x00, 0x00, 0x04, 0xd1, 0xff, 0xca, 0x01, 0x02, 0xd2, 0xff, 0xe7, 0x0d, 0x00, 0x00, 0x00, 0x00, /*    OXO  OXX      */
0x00, 0x00, 0x78, 0xff, 0xff, 0x39, 0x00, 0x00, 0x4a, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, /*   +XX.  -XXo     */
0x00, 0x22, 0xf6, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xf9, 0x25, 0x00, 0x00, 0x00, /*  .XXa    aXX.    */
0x00, 0xb9, 0xff, 0xf8, 0x20, 0x00, 0x00, 0x00, 0x00, 0x30, 0xfd, 0xff, 0xbb, 0x00, 0x00, 0x00, /*  aXX.    .XXa    */
0x4c, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0xff, 0x59, 0x00, 0x00, /* -XXo      oXX-   */
0x7f, 0xff, 0xe6, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xd8, 0xff, 0xad, 0x00, 0x00, /* +XX        OXa   */
0x13, 0x8e, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x7f, 0x2d, 0x00, 0x00, /*  o.         +.   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 89 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x1c, 0xc2, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0xeb, 0x96, 0x00, 0x00, /*  Oo        .Xo   */
0x70, 0xff, 0xff, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0xf2, 0x00, 0x00, /* +XX.       OXX   */
0x44, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xbb, 0x00, 0x00, /* -XXo      .XXa   */
0x01, 0xd7, 0xff, 0xf0, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xff, 0xff, 0x42, 0x00, 0x00, /*  OXX      aXX-   */
0x00, 0x61, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x1d, 0xfb, 0xff, 0xc8, 0x00, 0x00, 0x00, /*  +XX+     XXO    */
0x00, 0x03, 0xd5, 0xff, 0xee, 0x13, 0x00, 0x00, 0x00, 0x90, 0xff, 0xff, 0x53, 0x00, 0x00, 0x00, /*   OXX    oXX-    */
0x00, 0x00, 0x49, 0xff, 0xff, 0x91, 0x00, 0x00, 0x14, 0xf4, 0xff, 0xd2, 0x01, 0x00, 0x00, 0x00, /*   -XXo   XXO     */
0x00, 0x00, 0x00, 0xb7, 0xff, 0xf9, 0x1c, 0x00, 0x82, 0xff, 0xff, 0x52, 0x00, 0x00, 0x00, 0x00, /*    aXX  oXX-     */
0x00, 0x00, 0x00, 0x2d, 0xfd, 0xff, 0x92, 0x0a, 0xed, 0xff, 0xd4, 0x01, 0x00, 0x00, 0x00, 0x00, /*    .XXo XXO      */
0x00, 0x00, 0x00, 0x00, 0x9f, 0xff, 0xf7, 0x83, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, /*     oXXoXX+      */
0x00, 0x00, 0x00, 0x00, 0x1b, 0xf6, 0xff, 0xff, 0xff, 0xe6, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XXXXX       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x85, 0xff, 0xff, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      oXXX+       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0xfb, 0xff, 0xef, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      -XXo        */
0x00, 0x00, 0x00, 0x00, 0x00, 0xcb, 0xff, 0xf3, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      OXX         */
0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0xff, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     -XXo         */
0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xf5, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     OXX          */
0x00, 0x00, 0x00, 0x41, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    -XXo          */
0x00, 0x00, 0x00, 0xad, 0xff, 0xf8, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    aXX           */
0x00, 0x00, 0x00, 0xa1, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    aXo           */
0x00, 0x00, 0x00, 0x08, 0x47, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     -            */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 90 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x8e, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa7, 0x00, 0x00, /*  oXXXXXXXXXXXa   */
0x00, 0xe3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0x00, 0x00, /*  XXXXXXXXXXXXO   */
0x00, 0x10, 0x2f, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x4a, 0xf9, 0xff, 0xf3, 0x31, 0x00, 0x00, /*   .......-XXX.   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xba, 0xff, 0xff, 0x4f, 0x00, 0x00, 0x00, /*          aXX-    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x69, 0xff, 0xff, 0xa3, 0x00, 0x00, 0x00, 0x00, /*         +XXa     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xf4, 0xff, 0xe5, 0x11, 0x00, 0x00, 0x00, 0x00, /*        .XXX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, /*        aXX-      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x65, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       +XXo       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xf0, 0xff, 0xd9, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXO        */
0x00, 0x00, 0x00, 0x00, 0x00, 0xae, 0xff, 0xfc, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      aXX.        */
0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     -XXo         */
0x00, 0x00, 0x00, 0x0e, 0xe5, 0xff, 0xcd, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XXO          */
0x00, 0x00, 0x00, 0x93, 0xff, 0xf9, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    oXX.          */
0x00, 0x00, 0x31, 0xfd, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   .XX+           */
0x00, 0x00, 0xc4, 0xff, 0xd4, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   OXO            */
0x00, 0x4a, 0xff, 0xff, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -XX-            */
0x00, 0xbc, 0xff, 0xcb, 0x30, 0x30, 0x30, 0x30, 0x30, 0x2e, 0x2a, 0x20, 0x0b, 0x00, 0x00, 0x00, /*  aXO........     */
0x00, 0xf5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x00, 0x00, /*  XXXXXXXXXXXXa   */
0x00, 0x93, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xba, 0x00, 0x00, /*  oXXXXXXXXXXXa   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 91 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x08, 0x2d, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x1c, 0x00, 0x00, 0x00, 0x00, /*     .......      */
0x00, 0x00, 0x00, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x2b, 0x00, 0x00, 0x00, /*    OXXXXXXXX.    */
0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x2c, 0x00, 0x00, 0x00, /*    XXXXXXXXX.    */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x02, 0x05, 0x0c, 0x18, 0x2c, 0x26, 0x00, 0x00, 0x00, 0x00, /*    XXa    ..     */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xb8, 0x30, 0x30, 0x30, 0x30, 0x30, 0x25, 0x00, 0x00, 0x00, 0x00, /*    XXa......     */
0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, /*    XXXXXXXXX-    */
0x00, 0x00, 0x05, 0xd3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x3c, 0x00, 0x00, 0x00, /*    OXXXXXXXX.    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0d, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 92 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x35, 0xe9, 0xb6, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* .Xa              */
0x66, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* +XX+             */
0x13, 0xf2, 0xff, 0xe5, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXX             */
0x00, 0x7c, 0xff, 0xff, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  +XX+            */
0x00, 0x0a, 0xe4, 0xff, 0xe3, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXX            */
0x00, 0x00, 0x5e, 0xff, 0xff, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   -XX+           */
0x00, 0x00, 0x01, 0xca, 0xff, 0xeb, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    OXX           */
0x00, 0x00, 0x00, 0x39, 0xff, 0xff, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    .XXo          */
0x00, 0x00, 0x00, 0x00, 0xa4, 0xff, 0xf3, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     aXX          */
0x00, 0x00, 0x00, 0x00, 0x1b, 0xf4, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XXo         */
0x00, 0x00, 0x00, 0x00, 0x00, 0x7b, 0xff, 0xfb, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      +XX.        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xdf, 0xff, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       OXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xff, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       -XX-       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc1, 0xff, 0xcf, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, /*        OXO       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0xfe, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, /*        .XX+      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa9, 0xff, 0xe8, 0x0d, 0x00, 0x00, 0x00, 0x00, /*         aXX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0xfe, 0xff, 0x89, 0x00, 0x00, 0x00, 0x00, /*         .XXo     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb2, 0xff, 0xf9, 0x25, 0x00, 0x00, 0x00, /*          aXX.    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, /*          .XXa    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0x3f, 0x00, 0x00, /*           aXX.   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xff, 0xff, 0x7b, 0x00, 0x00, /*           -XX+   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x79, 0xe3, 0x3e, 0x00, 0x00, /*            +X.   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 93 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x0f, 0x2f, 0x30, 0x30, 0x30, 0x30, 0x30, 0x2e, 0x09, 0x00, 0x00, 0x00, 0x00, /*     .......      */
0x00, 0x00, 0x00, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, /*    OXXXXXXXO     */
0x00, 0x00, 0x00, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*    OXXXXXXXX     */
0x00, 0x00, 0x00, 0x16, 0x32, 0x1b, 0x0d, 0x05, 0x02, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*     .    aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*          aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*          aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*          aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*          aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*          aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*          aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*          aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*          aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*          aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*          aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*          aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*          aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*          aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*          aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*          aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*          aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*          aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*          aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*          aXX     */
0x00, 0x00, 0x00, 0x14, 0x2f, 0x30, 0x30, 0x30, 0x30, 0xb8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*     .....aXX     */
0x00, 0x00, 0x00, 0xe3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, /*    XXXXXXXXX     */
0x00, 0x00, 0x00, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x04, 0x00, 0x00, 0x00, /*    OXXXXXXXO     */
0x00, 0x00, 0x00, 0x08, 0x0e, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 94 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x5a, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       --         */
0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      +XX+        */
0x00, 0x00, 0x00, 0x00, 0x2e, 0xf6, 0xff, 0xff, 0xfc, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     .XXXX.       */
0x00, 0x00, 0x00, 0x0f, 0xda, 0xff, 0xff, 0xfe, 0xff, 0xe4, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, /*     OXXXXX       */
0x00, 0x00, 0x03, 0xb8, 0xff, 0xff, 0xb4, 0x70, 0xff, 0xff, 0xc3, 0x07, 0x00, 0x00, 0x00, 0x00, /*    aXXa+XXO      */
0x00, 0x00, 0x93, 0xff, 0xff, 0xdc, 0x12, 0x01, 0xb2, 0xff, 0xff, 0xab, 0x02, 0x00, 0x00, 0x00, /*   oXXO  aXXa     */
0x00, 0x68, 0xff, 0xff, 0xe6, 0x25, 0x00, 0x00, 0x0f, 0xd3, 0xff, 0xff, 0x97, 0x00, 0x00, 0x00, /*  +XXX.   OXXo    */
0x35, 0xfa, 0xff, 0xe9, 0x26, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xde, 0xff, 0xff, 0x78, 0x00, 0x00, /* .XXX.     OXX+   */
0x9a, 0xff, 0xf2, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xe7, 0xff, 0xcd, 0x00, 0x00, /* oXX.      .XXO   */
0x42, 0xde, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0xb7, 0x3a, 0x00, 0x00, /* -O-        .a.   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 95 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x0f, 0x2f, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x2f, 0x11, 0x00, 0x00, /*   ...........    */
0x00, 0xe3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x00, 0x00, /*  XXXXXXXXXXXXO   */
0x00, 0xc7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0x00, 0x00, /*  OXXXXXXXXXXXO   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 96 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x8a, 0xc0, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     oO.          */
0x00, 0x00, 0x00, 0x00, 0xf1, 0xff, 0xf7, 0x5b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XXX-         */
0x00, 0x00, 0x00, 0x00, 0x72, 0xfe, 0xff, 0xff, 0x9c, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     +XXXo        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xdc, 0xff, 0xff, 0xdd, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, /*      -OXXO       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x78, 0xf0, 0xfe, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, /*        +XX.      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 97 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x0b, 0x71, 0xbd, 0xe8, 0xfa, 0xea, 0xb0, 0x3a, 0x00, 0x00, 0x00, 0x00, /*      +aXXXa.     */
0x00, 0x00, 0x00, 0x48, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x79, 0x00, 0x00, 0x00, /*    -XXXXXXXX+    */
0x00, 0x00, 0x36, 0xf9, 0xff, 0xf8, 0x87, 0x40, 0x3e, 0x8f, 0xfd, 0xff, 0xfd, 0x04, 0x00, 0x00, /*   .XXXo-.oXXX    */
0x00, 0x01, 0xca, 0xff, 0xf7, 0x42, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xe7, 0x00, 0x00, 0x00, /*   OXX-    aXX    */
0x00, 0x49, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd2, 0xff, 0xd0, 0x00, 0x00, 0x00, /*  -XX+     OXO    */
0x00, 0x98, 0xff, 0xfa, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe6, 0xff, 0xbd, 0x00, 0x00, 0x00, /*  oXX      XXa    */
0x00, 0xca, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf2, 0xff, 0xaf, 0x00, 0x00, 0x00, /*  OXO      XXa    */
0x00, 0xe1, 0xff, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfa, 0xff, 0xa9, 0x00, 0x00, 0x00, /*  XXa      XXa    */
0x00, 0xf6, 0xff, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x00, /*  XXa      XXa    */
0x00, 0xec, 0xff, 0xd3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0xc3, 0x00, 0x00, 0x00, /*  XXO     oXXO    */
0x00, 0xbb, 0xff, 0xff, 0x21, 0x00, 0x00, 0x00, 0x30, 0xf9, 0xff, 0xff, 0xd8, 0x00, 0x00, 0x00, /*  aXX.   .XXXO    */
0x00, 0x52, 0xff, 0xff, 0xb3, 0x01, 0x00, 0x37, 0xe7, 0xff, 0xfd, 0xff, 0xfb, 0x06, 0x00, 0x00, /*  -XXa  .XXXXX    */
0x00, 0x01, 0xaf, 0xff, 0xff, 0xd7, 0xc2, 0xfd, 0xff, 0xc7, 0x9b, 0xff, 0xff, 0x2c, 0x00, 0x00, /*   aXXOOXXOoXX.   */
0x00, 0x00, 0x0d, 0xa1, 0xff, 0xff, 0xff, 0xff, 0xbb, 0x13, 0x66, 0xff, 0xff, 0x53, 0x00, 0x00, /*    aXXXXa +XX-   */
0x00, 0x00, 0x00, 0x00, 0x31, 0x71, 0x70, 0x3b, 0x00, 0x00, 0x10, 0xc7, 0xd8, 0x29, 0x00, 0x00, /*     .++.   OO.   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 98 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0xaf, 0xf6, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  aX-             */
0x00, 0xfc, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xff, 0xff, 0xa8, 0x4a, 0xaf, 0xe7, 0xf9, 0xe1, 0xa2, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa-aXXXa.      */
0x00, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x48, 0x00, 0x00, 0x00, 0x00, /*  XXXXXXXXXX-     */
0x00, 0xff, 0xff, 0xff, 0xe7, 0x7a, 0x3d, 0x45, 0xa8, 0xff, 0xff, 0xed, 0x14, 0x00, 0x00, 0x00, /*  XXXX+.-aXXX     */
0x00, 0xff, 0xff, 0xce, 0x10, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0x7d, 0x00, 0x00, 0x00, /*  XXO     oXX+    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0xfb, 0xff, 0xc8, 0x00, 0x00, 0x00, /*  XXa      XXO    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc7, 0xff, 0xea, 0x00, 0x00, 0x00, /*  XXa      OXX    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xae, 0xff, 0xfb, 0x00, 0x00, 0x00, /*  XXa      aXX    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xf0, 0x00, 0x00, 0x00, /*  XXa      OXX    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xff, 0xce, 0x00, 0x00, 0x00, /*  XXa      OXO    */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0xff, 0xff, 0x93, 0x00, 0x00, 0x00, /*  XXa     .XXo    */
0x00, 0xff, 0xff, 0xb5, 0x00, 0x00, 0x00, 0x00, 0x01, 0xb5, 0xff, 0xff, 0x37, 0x00, 0x00, 0x00, /*  XXa     aXX.    */
0x00, 0xff, 0xff, 0xff, 0xab, 0x4f, 0x35, 0x4d, 0xb9, 0xff, 0xff, 0xa1, 0x00, 0x00, 0x00, 0x00, /*  XXXa-.-aXXa     */
0x00, 0xfb, 0xff, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x08, 0x00, 0x00, 0x00, 0x00, /*  XXXXXXXXXO      */
0x00, 0xa5, 0xf2, 0x43, 0x5e, 0xbd, 0xee, 0xfa, 0xd7, 0x78, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, /*  aX--aXXO+       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 99 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x08, 0x6c, 0xc3, 0xf1, 0xf0, 0xb5, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, /*      +OXXa.      */
0x00, 0x00, 0x00, 0x28, 0xd9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x2d, 0x00, 0x00, 0x00, 0x00, /*    .OXXXXXX.     */
0x00, 0x00, 0x1e, 0xea, 0xff, 0xf2, 0x78, 0x3b, 0x6f, 0xfe, 0xff, 0xcb, 0x00, 0x00, 0x00, 0x00, /*    XXX+.+XXO     */
0x00, 0x00, 0xba, 0xff, 0xf5, 0x38, 0x00, 0x00, 0x00, 0xb9, 0xff, 0xff, 0x2a, 0x00, 0x00, 0x00, /*   aXX.   aXX.    */
0x00, 0x36, 0xff, 0xff, 0x75, 0x00, 0x00, 0x00, 0x00, 0x5b, 0xff, 0xfc, 0x22, 0x00, 0x00, 0x00, /*  .XX+    -XX.    */
0x00, 0x8e, 0xff, 0xfb, 0x12, 0x00, 0x00, 0x00, 0x00, 0x01, 0x4d, 0x30, 0x00, 0x00, 0x00, 0x00, /*  oXX      -.     */
0x00, 0xc7, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  OXO             */
0x00, 0xeb, 0xff, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xfa, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXa             */
0x00, 0xf2, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x01, 0x00, 0x00, 0x00, /*  XXO             */
0x00, 0xc0, 0xff, 0xf9, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xa0, 0x00, 0x00, 0x00, /*  OXX      +Xa    */
0x00, 0x5c, 0xff, 0xff, 0xaf, 0x09, 0x00, 0x00, 0x01, 0x53, 0xf7, 0xff, 0xb6, 0x00, 0x00, 0x00, /*  -XXa    -XXa    */
0x00, 0x01, 0xb6, 0xff, 0xff, 0xec, 0xb8, 0xbd, 0xe7, 0xff, 0xff, 0xf4, 0x2e, 0x00, 0x00, 0x00, /*   aXXXaaXXXX.    */
0x00, 0x00, 0x07, 0x97, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x2c, 0x00, 0x00, 0x00, 0x00, /*    oXXXXXXa.     */
0x00, 0x00, 0x00, 0x00, 0x1c, 0x62, 0x7a, 0x6a, 0x51, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      +++-        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 100 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xe7, 0xb0, 0x00, 0x00, 0x00, /*           .Xa    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xfa, 0x00, 0x00, 0x00, /*           +XX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0xff, 0x00, 0x00, 0x00, /*           oXX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0x00, 0x00, 0x00, /*           oXX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0x00, 0x00, 0x00, /*           aXX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa5, 0xff, 0xff, 0x00, 0x00, 0x00, /*           aXX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa7, 0xff, 0xff, 0x00, 0x00, 0x00, /*           aXX    */
0x00, 0x00, 0x00, 0x1e, 0x95, 0xdd, 0xf9, 0xec, 0xbd, 0x63, 0xac, 0xff, 0xff, 0x00, 0x00, 0x00, /*     oOXXa+aXX    */
0x00, 0x00, 0x38, 0xed, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, /*   .XXXXXXXXXX    */
0x00, 0x0e, 0xe4, 0xff, 0xff, 0xa3, 0x43, 0x47, 0xa8, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, /*   XXXa--aXXXX    */
0x00, 0x76, 0xff, 0xff, 0x93, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, /*  +XXo    +XXX    */
0x00, 0xc6, 0xff, 0xf8, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0x00, 0x00, 0x00, /*  OXX      OXX    */
0x00, 0xeb, 0xff, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*  XXO      aXX    */
0x00, 0xfb, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*  XXa      aXX    */
0x00, 0xef, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x01, 0x00, 0x00, /*  XXa      aXX    */
0x00, 0xcb, 0xff, 0xd7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x06, 0x00, 0x00, /*  OXO      aXX    */
0x00, 0x8f, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x01, 0xd2, 0xff, 0xff, 0x15, 0x00, 0x00, /*  oXX      OXX    */
0x00, 0x32, 0xff, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0x2d, 0x00, 0x00, /*  .XXa    +XXX.   */
0x00, 0x00, 0x9a, 0xff, 0xff, 0xa6, 0x42, 0x3c, 0x87, 0xfc, 0xff, 0xff, 0xff, 0x55, 0x00, 0x00, /*   oXXa-.oXXXX-   */
0x00, 0x00, 0x05, 0xb9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0xa3, 0xff, 0xff, 0x81, 0x00, 0x00, /*    aXXXXXXaXXo   */
0x00, 0x00, 0x00, 0x04, 0x71, 0xd5, 0xf9, 0xe7, 0x9f, 0x1b, 0x25, 0xea, 0xec, 0x3e, 0x00, 0x00, /*     +OXXo .XX.   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 101 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x27, 0x97, 0xdc, 0xf7, 0xe1, 0x88, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, /*     .oOXXo       */
0x00, 0x00, 0x00, 0x73, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0x27, 0x00, 0x00, 0x00, 0x00, /*    +XXXXXXO.     */
0x00, 0x00, 0x69, 0xff, 0xff, 0xcb, 0x53, 0x3c, 0x96, 0xff, 0xff, 0xde, 0x0d, 0x00, 0x00, 0x00, /*   +XXO-.oXXO     */
0x00, 0x16, 0xf5, 0xff, 0xc0, 0x07, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0x6b, 0x00, 0x00, 0x00, /*   XXO    oXX+    */
0x00, 0x7d, 0xff, 0xfe, 0x26, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, /*  +XX.    +XX-    */
0x00, 0xc4, 0xff, 0xcf, 0x00, 0x00, 0x12, 0x66, 0xd2, 0xff, 0xff, 0xbf, 0x03, 0x00, 0x00, 0x00, /*  OXO   +OXXa     */
0x00, 0xeb, 0xff, 0xc5, 0x76, 0xbc, 0xfa, 0xff, 0xff, 0xfb, 0x8f, 0x0a, 0x00, 0x00, 0x00, 0x00, /*  XXO+aXXXXo      */
0x00, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x90, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXXXXXXo        */
0x00, 0xf2, 0xff, 0xff, 0xfc, 0xba, 0x5d, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  XXXXa-          */
0x00, 0xd3, 0xff, 0xd8, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x05, 0x00, 0x00, 0x00, /*  OXO       .     */
0x00, 0x98, 0xff, 0xf7, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0xff, 0xb6, 0x00, 0x00, 0x00, /*  oXX      oXa    */
0x00, 0x37, 0xff, 0xff, 0xad, 0x09, 0x00, 0x00, 0x1c, 0x9f, 0xff, 0xff, 0xc1, 0x00, 0x00, 0x00, /*  .XXa    oXXO    */
0x00, 0x00, 0x9c, 0xff, 0xff, 0xeb, 0xbc, 0xcf, 0xfb, 0xff, 0xff, 0xf1, 0x2c, 0x00, 0x00, 0x00, /*   oXXXaOXXXX.    */
0x00, 0x00, 0x04, 0x97, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcb, 0x2e, 0x00, 0x00, 0x00, 0x00, /*    oXXXXXXO.     */
0x00, 0x00, 0x00, 0x00, 0x22, 0x65, 0x7c, 0x77, 0x61, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     .++++.       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 102 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x8b, 0xc8, 0xe3, 0xf7, 0xb7, 0x00, 0x00, 0x00, /*        .oOXXa    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x95, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xdd, 0x00, 0x00, 0x00, /*       oXXXXXO    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0xfd, 0xa7, 0x5a, 0x39, 0x11, 0x00, 0x00, 0x00, /*      oXXXa-.     */
0x00, 0x00, 0x00, 0x00, 0x31, 0xff, 0xff, 0xf0, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     .XXX.        */
0x00, 0x00, 0x00, 0x00, 0x81, 0xff, 0xff, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     oXX+         */
0x00, 0x00, 0x00, 0x00, 0xa1, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     aXX          */
0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     aXX          */
0x00, 0x00, 0xc5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, /*   OXXXXXXXXXO    */
0x00, 0x00, 0xe5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0x00, 0x00, 0x00, /*   XXXXXXXXXXO    */
0x00, 0x00, 0x11, 0x2f, 0xb8, 0xff, 0xff, 0x30, 0x30, 0x30, 0x30, 0x2f, 0x0e, 0x00, 0x00, 0x00, /*    .aXX.....     */
0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     aXX          */
0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     aXX          */
0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     aXX          */
0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     aXX          */
0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     aXX          */
0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     aXX          */
0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     aXX          */
0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     oXX          */
0x00, 0x00, 0x10, 0x2f, 0x81, 0xff, 0xff, 0x44, 0x3a, 0x33, 0x2d, 0x0b, 0x00, 0x00, 0x00, 0x00, /*    .oXX-...      */
0x00, 0x00, 0xdd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x00, 0x00, 0x00, 0x00, /*   OXXXXXXXXO     */
0x00, 0x00, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xad, 0x00, 0x00, 0x00, 0x00, /*   aXXXXXXXXa     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 103 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x7f, 0xc8, 0xf0, 0xfd, 0xf8, 0xda, 0x7d, 0x01, 0x00, 0x00, /*       +OXXXO+    */
0x00, 0x00, 0x00, 0x00, 0x5f, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x12, 0x00, 0x00, /*     -XXXXXXXX    */
0x00, 0x00, 0x00, 0x61, 0xff, 0xff, 0xe5, 0x71, 0x3a, 0x41, 0x6e, 0xea, 0xfe, 0x65, 0x00, 0x00, /*    +XXX+.-+XX+   */
0x00, 0x00, 0x16, 0xf2, 0xff, 0xd2, 0x16, 0x00, 0x00, 0x00, 0x00, 0xfd, 0xff, 0xa7, 0x00, 0x00, /*    XXO     XXa   */
0x00, 0x00, 0x79, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, /*   +XX.     XXa   */
0x00, 0x00, 0xc0, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, /*   OXO      XXa   */
0x00, 0x00, 0xeb, 0xff, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, /*   XXa      XXa   */
0x00, 0x00, 0xfb, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, /*   XXa      XXa   */
0x00, 0x00, 0xf7, 0xff, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xa8, 0x00, 0x00, /*   XXa      XXa   */
0x00, 0x00, 0xe3, 0xff, 0xc5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xa8, 0x00, 0x00, /*   XXO     .XXa   */
0x00, 0x00, 0xb9, 0xff, 0xf6, 0x0d, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0xa8, 0x00, 0x00, /*   aXX     aXXa   */
0x00, 0x00, 0x71, 0xff, 0xff, 0x91, 0x00, 0x00, 0x07, 0x8a, 0xff, 0xff, 0xff, 0xa7, 0x00, 0x00, /*   +XXo   oXXXa   */
0x00, 0x00, 0x0f, 0xeb, 0xff, 0xff, 0xd2, 0xbe, 0xed, 0xff, 0xfa, 0xff, 0xff, 0xa2, 0x00, 0x00, /*    XXXOaXXXXXa   */
0x00, 0x00, 0x00, 0x3b, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xe9, 0x50, 0xff, 0xff, 0x9b, 0x00, 0x00, /*    .XXXXXX-XXo   */
0x00, 0x00, 0x00, 0x00, 0x0c, 0x54, 0x77, 0x73, 0x4d, 0x0a, 0x0f, 0xff, 0xff, 0x8c, 0x00, 0x00, /*      -++-  XXo   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0x71, 0x00, 0x00, /*           .XX+   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x91, 0xff, 0xff, 0x3f, 0x00, 0x00, /*           oXX.   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0xf7, 0xff, 0xe9, 0x03, 0x00, 0x00, /*          .XXX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xe1, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, /*         .XXX+    */
0x00, 0x00, 0xc3, 0xd9, 0x6a, 0x39, 0x52, 0xa0, 0xfa, 0xff, 0xff, 0xae, 0x02, 0x00, 0x00, 0x00, /*   OO+.-aXXXa     */
0x00, 0x00, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8b, 0x02, 0x00, 0x00, 0x00, 0x00, /*   XXXXXXXXo      */
0x00, 0x00, 0x15, 0x7e, 0xca, 0xee, 0xf8, 0xdb, 0x9b, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    +OXXOo.       */
	/* 104 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0xa2, 0xf2, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   aX-            */
0x00, 0x00, 0xfc, 0xff, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x42, 0xac, 0xdb, 0xf5, 0xe5, 0x6f, 0x00, 0x00, 0x00, 0x00, /*   XXa -aOXX+     */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x8d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x47, 0x00, 0x00, 0x00, /*   XXaoXXXXXX-    */
0x00, 0x00, 0xff, 0xff, 0xf1, 0xff, 0xf1, 0x77, 0x39, 0x96, 0xff, 0xff, 0xa5, 0x00, 0x00, 0x00, /*   XXXXX+.oXXa    */
0x00, 0x00, 0xff, 0xff, 0xff, 0xef, 0x27, 0x00, 0x00, 0x06, 0xf4, 0xff, 0xdf, 0x00, 0x00, 0x00, /*   XXXX.   XXO    */
0x00, 0x00, 0xff, 0xff, 0xff, 0x69, 0x00, 0x00, 0x00, 0x00, 0xc3, 0xff, 0xf5, 0x00, 0x00, 0x00, /*   XXX+    OXX    */
0x00, 0x00, 0xff, 0xff, 0xf6, 0x09, 0x00, 0x00, 0x00, 0x00, 0xb0, 0xff, 0xff, 0x00, 0x00, 0x00, /*   XXX     aXX    */
0x00, 0x00, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*   XXO     aXX    */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*   XXa     aXX    */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*   XXa     aXX    */
0x00, 0x01, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*   XXa     aXX    */
0x00, 0x03, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*   XXa     aXX    */
0x00, 0x08, 0xff, 0xff, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*   XXa     aXX    */
0x00, 0x10, 0xff, 0xff, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa3, 0xff, 0xf7, 0x00, 0x00, 0x00, /*   XXo     aXX    */
0x00, 0x02, 0xc8, 0xe6, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xee, 0x8d, 0x00, 0x00, 0x00, /*   OX.     -Xo    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 105 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xde, 0xea, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      -OX-        */
0x00, 0x00, 0x00, 0x00, 0x00, 0xe1, 0xff, 0xff, 0xe9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XXXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0xe8, 0xff, 0xff, 0xe4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XXXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xfb, 0xf1, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      +XX-        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x10, 0x2f, 0x30, 0x30, 0x30, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    .....         */
0x00, 0x00, 0xe1, 0xff, 0xff, 0xff, 0xff, 0xff, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXXXXX+        */
0x00, 0x00, 0xc7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   OXXXXXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xfe, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x1e, 0x43, 0x44, 0x44, 0x44, 0xff, 0xff, 0xbf, 0x44, 0x44, 0x43, 0x21, 0x00, 0x00, 0x00, /*   ----XXa---.    */
0x00, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x00, 0x00, 0x00, /*  XXXXXXXXXXXX    */
0x00, 0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc5, 0x00, 0x00, 0x00, /*  aXXXXXXXXXXO    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 106 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xe8, 0xe6, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, /*        -XX-      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, /*        XXXX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xff, 0xff, 0xe4, 0x00, 0x00, 0x00, 0x00, 0x00, /*        OXXX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0xe3, 0xe5, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, /*        -XX-      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x4d, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -XXXXXXXX+      */
0x00, 0x54, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -XXXXXXXXO      */
0x00, 0x00, 0x1f, 0x30, 0x30, 0x30, 0x30, 0x30, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00, /*    .....XXa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x00, /*         XXa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, /*         XXa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, /*         XXa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, /*         XXa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, /*         XXa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, /*         XXa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, /*         XXa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, /*         XXa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, /*         XXa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, /*         XXa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00, /*         XXa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0xff, 0xff, 0x9f, 0x00, 0x00, 0x00, 0x00, 0x00, /*         XXo      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0xff, 0xff, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, /*        -XXo      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xc9, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, /*        OXX-      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xb5, 0xff, 0xff, 0xcb, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXXO       */
0x00, 0x0c, 0x3a, 0x54, 0x98, 0xee, 0xff, 0xff, 0xe7, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   .-oXXXX        */
0x00, 0xd1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  OXXXXXa.        */
0x00, 0xb9, 0xfa, 0xee, 0xcb, 0x94, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  aXXOo.          */
	/* 107 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0xa3, 0xf5, 0x5d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   aX-            */
0x00, 0x00, 0xfd, 0xff, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xb7, 0x59, 0x00, 0x00, 0x00, /*   XXa     .a-    */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xee, 0xff, 0xa2, 0x00, 0x00, 0x00, /*   XXa    .XXa    */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x58, 0xf8, 0xff, 0xeb, 0x24, 0x00, 0x00, 0x00, /*   XXa   -XXX.    */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x74, 0xfe, 0xff, 0xe7, 0x2c, 0x00, 0x00, 0x00, 0x00, /*   XXa  +XXX.     */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x01, 0x90, 0xff, 0xff, 0xde, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa oXXO.      */
0x00, 0x00, 0xff, 0xff, 0xac, 0xa2, 0xff, 0xff, 0xd2, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXaaXXO        */
0x00, 0x00, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xcd, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXXXXXO        */
0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff, 0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXXXOXX+       */
0x00, 0x00, 0xff, 0xff, 0xff, 0x91, 0x03, 0xca, 0xff, 0xfa, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXXo OXX.      */
0x00, 0x00, 0xff, 0xff, 0x9b, 0x00, 0x00, 0x34, 0xfb, 0xff, 0xdc, 0x0e, 0x00, 0x00, 0x00, 0x00, /*   XXo  .XXO      */
0x00, 0x01, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, /*   XX+   oXXa     */
0x00, 0x04, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x04, 0xc6, 0xff, 0xff, 0x66, 0x00, 0x00, 0x00, /*   XXo    OXX+    */
0x00, 0x0b, 0xff, 0xff, 0x9b, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xea, 0xff, 0xf6, 0x2b, 0x00, 0x00, /*   XXo     XXX.   */
0x00, 0x17, 0xff, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xfc, 0xff, 0xaf, 0x00, 0x00, /*   XXa     -XXa   */
0x00, 0x04, 0xc7, 0xf3, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xfe, 0x73, 0x00, 0x00, /*   OX-      +X+   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 108 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   aXXXXXa        */
0x00, 0x00, 0xd1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   OXXXXXO        */
0x00, 0x00, 0x0d, 0x2f, 0x2d, 0x26, 0xff, 0xff, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    ...XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x0f, 0x2f, 0x30, 0x30, 0x30, 0xff, 0xff, 0xb8, 0x30, 0x30, 0x30, 0x2d, 0x0c, 0x00, 0x00, /*   ....XXa....    */
0x00, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x00, 0x00, /*  OXXXXXXXXXXXX   */
0x00, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xb3, 0x00, 0x00, /*  OXXXXXXXXXXXa   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 109 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x81, 0xf4, 0x81, 0x1f, 0xb0, 0xf1, 0x89, 0x00, 0x11, 0x90, 0xe1, 0xee, 0x3b, 0x00, 0x00, /*  oXo aXo  oXX.   */
0x00, 0xf6, 0xff, 0xb5, 0xe1, 0xff, 0xff, 0xfb, 0x2d, 0xdd, 0xff, 0xff, 0xff, 0xac, 0x00, 0x00, /*  XXaXXXX.OXXXa   */
0x00, 0xff, 0xff, 0xf8, 0xe6, 0x60, 0xff, 0xff, 0xec, 0xee, 0x57, 0xe2, 0xff, 0xdc, 0x00, 0x00, /*  XXXX+XXXX-XXO   */
0x00, 0xff, 0xff, 0xff, 0x56, 0x06, 0xff, 0xff, 0xff, 0x55, 0x00, 0xb7, 0xff, 0xf0, 0x00, 0x00, /*  XXX- XXX- aXX   */
0x00, 0xff, 0xff, 0xe4, 0x02, 0x01, 0xff, 0xff, 0xde, 0x01, 0x00, 0xaa, 0xff, 0xfa, 0x00, 0x00, /*  XXX  XXO  aXX   */
0x00, 0xff, 0xff, 0xa9, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0xa8, 0xff, 0xfe, 0x00, 0x00, /*  XXa  XXa  aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, /*  XXa  XXa  aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, /*  XXa  XXa  aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, /*  XXa  XXa  aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, /*  XXa  XXa  aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0xa7, 0xff, 0xff, 0x00, 0x00, /*  XXa  XXa  aXX   */
0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0xa4, 0xff, 0xff, 0x00, 0x00, /*  XXa  XXa  aXX   */
0x00, 0xfe, 0xff, 0xa3, 0x00, 0x00, 0xf8, 0xff, 0xa4, 0x00, 0x00, 0x93, 0xff, 0xf9, 0x00, 0x00, /*  XXa  XXa  oXX   */
0x00, 0xb8, 0xf5, 0x58, 0x00, 0x00, 0x9e, 0xf7, 0x60, 0x00, 0x00, 0x3b, 0xed, 0xb3, 0x00, 0x00, /*  aX-  oX+  .Xa   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 110 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x88, 0xf5, 0x8d, 0x01, 0x5e, 0xbf, 0xeb, 0xf8, 0xcb, 0x41, 0x00, 0x00, 0x00, 0x00, /*   oXo -aXXO-     */
0x00, 0x00, 0xf9, 0xff, 0xc9, 0xb9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x2b, 0x00, 0x00, 0x00, /*   XXOaXXXXXX.    */
0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x83, 0x41, 0x71, 0xff, 0xff, 0x9f, 0x00, 0x00, 0x00, /*   XXXXXo-+XXo    */
0x00, 0x00, 0xff, 0xff, 0xff, 0xe9, 0x2b, 0x00, 0x00, 0x00, 0xd5, 0xff, 0xdd, 0x00, 0x00, 0x00, /*   XXXX.   OXO    */
0x00, 0x00, 0xff, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00, 0x00, 0xb5, 0xff, 0xf8, 0x00, 0x00, 0x00, /*   XXX-    aXX    */
0x00, 0x00, 0xff, 0xff, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00, 0xab, 0xff, 0xff, 0x04, 0x00, 0x00, /*   XXa     aXX    */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa3, 0xff, 0xff, 0x10, 0x00, 0x00, /*   XXa     aXX    */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x97, 0xff, 0xff, 0x25, 0x00, 0x00, /*   XXa     oXX.   */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0xff, 0xff, 0x41, 0x00, 0x00, /*   XXa     oXX-   */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x65, 0xff, 0xff, 0x5e, 0x00, 0x00, /*   XXa     +XX-   */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0xff, 0xff, 0x7d, 0x00, 0x00, /*   XXa     -XX+   */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0x98, 0x00, 0x00, /*   XXa     .XXo   */
0x00, 0x00, 0xfd, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf8, 0xff, 0xa1, 0x00, 0x00, /*   XXa      XXa   */
0x00, 0x00, 0xa8, 0xf7, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x91, 0xf4, 0x56, 0x00, 0x00, /*   aX-      oX-   */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 111 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x01, 0x5b, 0xbc, 0xec, 0xf9, 0xdb, 0x8b, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, /*     -aXXOo       */
0x00, 0x00, 0x08, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x23, 0x00, 0x00, 0x00, 0x00, /*    aXXXXXXX.     */
0x00, 0x00, 0x9d, 0xff, 0xfe, 0x90, 0x3b, 0x46, 0xa6, 0xff, 0xff, 0xce, 0x02, 0x00, 0x00, 0x00, /*   oXXo.-aXXO     */
0x00, 0x2e, 0xfe, 0xff, 0x8f, 0x00, 0x00, 0x00, 0x00, 0x99, 0xff, 0xff, 0x4f, 0x00, 0x00, 0x00, /*  .XXo    oXX-    */
0x00, 0x8f, 0xff, 0xfe, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0xfd, 0xff, 0x9e, 0x00, 0x00, 0x00, /*  oXX      XXo    */
0x00, 0xcd, 0xff, 0xd4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd4, 0xff, 0xcf, 0x00, 0x00, 0x00, /*  OXO      OXO    */
0x00, 0xf0, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb5, 0xff, 0xee, 0x00, 0x00, 0x00, /*  XXa      aXX    */
0x00, 0xfb, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xad, 0xff, 0xfa, 0x00, 0x00, 0x00, /*  XXa      aXX    */
0x00, 0xec, 0xff, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc5, 0xff, 0xf5, 0x00, 0x00, 0x00, /*  XXa      OXX    */
0x00, 0xc0, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xea, 0xff, 0xdb, 0x00, 0x00, 0x00, /*  OXO      XXO    */
0x00, 0x74, 0xff, 0xfd, 0x20, 0x00, 0x00, 0x00, 0x00, 0x4b, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, /*  +XX.    -XXa    */
0x00, 0x13, 0xef, 0xff, 0xc0, 0x17, 0x00, 0x00, 0x18, 0xd6, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x00, /*   XXO    OXX.    */
0x00, 0x00, 0x5c, 0xff, 0xff, 0xf6, 0xc9, 0xbb, 0xf5, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00, /*   -XXXOaXXXo     */
0x00, 0x00, 0x00, 0x5d, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x83, 0x02, 0x00, 0x00, 0x00, 0x00, /*    -XXXXXXo      */
0x00, 0x00, 0x00, 0x00, 0x0d, 0x59, 0x79, 0x70, 0x4e, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      -++-        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 112 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x7d, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   +X+            */
0x00, 0x00, 0xe6, 0xff, 0x87, 0x50, 0xb5, 0xed, 0xf6, 0xd8, 0x9a, 0x1a, 0x00, 0x00, 0x00, 0x00, /*   XXo-aXXOo      */
0x00, 0x00, 0xfa, 0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x20, 0x00, 0x00, 0x00, /*   XXXXXXXXXX.    */
0x00, 0x00, 0xff, 0xff, 0xff, 0xfd, 0xa5, 0x4f, 0x3a, 0x8e, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, /*   XXXXa-.oXXa    */
0x00, 0x00, 0xff, 0xff, 0xe2, 0x32, 0x00, 0x00, 0x00, 0x00, 0xad, 0xff, 0xfd, 0x17, 0x00, 0x00, /*   XXX.    aXX    */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0xff, 0xff, 0x55, 0x00, 0x00, /*   XXa     -XX-   */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0x7f, 0x00, 0x00, /*   XXa      XX+   */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0x99, 0x00, 0x00, /*   XXa      XXo   */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xa3, 0x00, 0x00, /*   XXa      XXa   */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0xff, 0xff, 0x92, 0x00, 0x00, /*   XXa     .XXo   */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0xff, 0xff, 0x6f, 0x00, 0x00, /*   XXa     -XX+   */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0xff, 0xfe, 0x20, 0x00, 0x00, /*   XXa     aXX.   */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xfc, 0xff, 0xb4, 0x00, 0x00, 0x00, /*   XXa    -XXa    */
0x00, 0x00, 0xff, 0xff, 0xf1, 0xba, 0xb0, 0xb0, 0xc7, 0xff, 0xff, 0xed, 0x1a, 0x00, 0x00, 0x00, /*   XXXaaaOXXX     */
0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x28, 0x00, 0x00, 0x00, 0x00, /*   XXXXXXXXO.     */
0x00, 0x00, 0xff, 0xff, 0xba, 0x56, 0x71, 0x7c, 0x78, 0x4c, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa-+++-       */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x00, 0xfd, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x00, 0xaa, 0xf3, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   aX-            */
	/* 113 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x28, 0x96, 0xcf, 0xed, 0xf6, 0xd8, 0x90, 0x20, 0x00, 0x00, 0x00, 0x00, /*     .oOXXOo.     */
0x00, 0x00, 0x00, 0x71, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x38, 0x00, 0x00, 0x00, /*    +XXXXXXXX.    */
0x00, 0x00, 0x61, 0xff, 0xff, 0xda, 0x5e, 0x33, 0x4e, 0xd8, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, /*   +XXO-.-OXXa    */
0x00, 0x10, 0xee, 0xff, 0xd4, 0x11, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x1d, 0x00, 0x00, 0x00, /*   XXO    aXX     */
0x00, 0x69, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*  +XX.    aXX     */
0x00, 0xb1, 0xff, 0xe4, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*  aXX     aXX     */
0x00, 0xe0, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*  XXa     aXX     */
0x00, 0xf5, 0xff, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*  XXa     aXX     */
0x00, 0xf6, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*  XXO     aXX     */
0x00, 0xd9, 0xff, 0xe9, 0x01, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*  OXX     aXX     */
0x00, 0x97, 0xff, 0xff, 0x35, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*  oXX.    aXX     */
0x00, 0x33, 0xfe, 0xff, 0xc2, 0x0a, 0x00, 0x00, 0x09, 0xbb, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*  .XXO    aXX     */
0x00, 0x00, 0x8d, 0xff, 0xff, 0xe7, 0xb7, 0xc8, 0xf3, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*   oXXXaOXXXX     */
0x00, 0x00, 0x05, 0x89, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*    oXXXXXXXX     */
0x00, 0x00, 0x00, 0x00, 0x29, 0x6e, 0x79, 0x68, 0x3b, 0xad, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*     .+++.aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*          aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*          aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, /*          aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, /*          aXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, /*          OXX     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc8, 0xff, 0xdb, 0x00, 0x00, 0x00, 0x00, /*          OXO     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xf2, 0x63, 0x00, 0x00, 0x00, 0x00, /*          +X+     */
	/* 114 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x4c, 0xef, 0xae, 0x00, 0x00, 0x15, 0x74, 0xb9, 0xe4, 0xf8, 0x74, 0x00, 0x00, 0x00, /*   -Xa   +aXX+    */
0x00, 0x00, 0xa3, 0xff, 0xfb, 0x01, 0x72, 0xf5, 0xff, 0xff, 0xff, 0xff, 0xcb, 0x00, 0x00, 0x00, /*   aXX +XXXXXO    */
0x00, 0x00, 0xb0, 0xff, 0xfd, 0x94, 0xff, 0xff, 0xc2, 0x82, 0xea, 0xff, 0xf0, 0x00, 0x00, 0x00, /*   aXXoXXOoXXX    */
0x00, 0x00, 0xbd, 0xff, 0xff, 0xff, 0xe2, 0x45, 0x00, 0x00, 0xad, 0xff, 0xfb, 0x00, 0x00, 0x00, /*   aXXXX-  aXX    */
0x00, 0x00, 0xcc, 0xff, 0xff, 0xe0, 0x1e, 0x00, 0x00, 0x00, 0x90, 0xff, 0xc7, 0x00, 0x00, 0x00, /*   OXXX    oXO    */
0x00, 0x00, 0xda, 0xff, 0xfc, 0x34, 0x00, 0x00, 0x00, 0x00, 0x12, 0x6f, 0x1d, 0x00, 0x00, 0x00, /*   OXX.     +     */
0x00, 0x00, 0xe8, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x00, 0xf3, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x00, 0xfc, 0xff, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x00, 0xfe, 0xff, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXa            */
0x00, 0x00, 0xf3, 0xff, 0xc7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   XXO            */
0x00, 0x00, 0xd9, 0xff, 0xe1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   OXX            */
0x00, 0x00, 0xb7, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   aXX            */
0x00, 0x00, 0x65, 0xf1, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   +Xa            */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 115 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x02, 0x49, 0x8f, 0xc0, 0xe0, 0xf1, 0xfa, 0x59, 0x00, 0x00, 0x00, 0x00, /*      -oOXXX-     */
0x00, 0x00, 0x00, 0x46, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb1, 0x00, 0x00, 0x00, 0x00, /*    -OXXXXXXa     */
0x00, 0x00, 0x4a, 0xfc, 0xff, 0xf2, 0xa1, 0x63, 0x42, 0xae, 0xff, 0xeb, 0x00, 0x00, 0x00, 0x00, /*   -XXXa+-aXX     */
0x00, 0x00, 0xcf, 0xff, 0xd6, 0x16, 0x00, 0x00, 0x00, 0x51, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, /*   OXO    -XX     */
0x00, 0x00, 0xf7, 0xff, 0xb1, 0x04, 0x00, 0x00, 0x00, 0x04, 0x93, 0x7b, 0x00, 0x00, 0x00, 0x00, /*   XXa     o+     */
0x00, 0x00, 0xd4, 0xff, 0xff, 0xe7, 0x9d, 0x60, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   OXXXo+.        */
0x00, 0x00, 0x39, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x7a, 0x10, 0x00, 0x00, 0x00, 0x00, /*   .XXXXXXO+      */
0x00, 0x00, 0x00, 0x03, 0x4e, 0x9c, 0xe1, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x22, 0x00, 0x00, 0x00, /*     -oXXXXXX.    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x68, 0xc2, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x00, /*        .+OXXa    */
0x00, 0x00, 0x21, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0xe1, 0x00, 0x00, 0x00, /*   .       OXX    */
0x00, 0x80, 0xff, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xf4, 0xff, 0xa5, 0x00, 0x00, 0x00, /*  oXa     .XXa    */
0x00, 0xa1, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x0a, 0x6f, 0xf1, 0xff, 0xfa, 0x30, 0x00, 0x00, 0x00, /*  aXX-   +XXX.    */
0x00, 0x4b, 0xff, 0xff, 0xf8, 0xbd, 0xbf, 0xf4, 0xff, 0xff, 0xfa, 0x5e, 0x00, 0x00, 0x00, 0x00, /*  -XXXaaXXXX-     */
0x00, 0x00, 0x74, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xba, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, /*   +XXXXXXa.      */
0x00, 0x00, 0x00, 0x18, 0x5f, 0x7a, 0x70, 0x54, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     -++-         */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 116 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x08, 0xd9, 0xd0, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    OO.           */
0x00, 0x00, 0x23, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   .XXo           */
0x00, 0x00, 0x16, 0xff, 0xff, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x07, 0xff, 0xff, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x16, 0x2b, 0xfb, 0xff, 0xbe, 0x30, 0x30, 0x30, 0x30, 0x2f, 0x0f, 0x00, 0x00, 0x00, 0x00, /*   .XXa.....      */
0x00, 0xe9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, /*  XXXXXXXXXXX     */
0x00, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x00, 0x00, 0x00, 0x00, /*  OXXXXXXXXXO     */
0x00, 0x00, 0x00, 0xe8, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xfa, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXa           */
0x00, 0x00, 0x00, 0xee, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    XXO           */
0x00, 0x00, 0x00, 0xb0, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x12, 0x56, 0x10, 0x00, 0x00, 0x00, /*    aXX+    -     */
0x00, 0x00, 0x00, 0x31, 0xf8, 0xff, 0xff, 0xd4, 0xb8, 0xd0, 0xfb, 0xff, 0x78, 0x00, 0x00, 0x00, /*    .XXXOaOXX+    */
0x00, 0x00, 0x00, 0x00, 0x44, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd7, 0x26, 0x00, 0x00, 0x00, /*     -XXXXXXO.    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x4e, 0x77, 0x76, 0x62, 0x31, 0x02, 0x00, 0x00, 0x00, 0x00, /*       -+++.      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 117 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0xad, 0xf0, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xf3, 0x9c, 0x00, 0x00, 0x00, /*   aX-     -Xo    */
0x00, 0x00, 0xfe, 0xff, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xfd, 0x00, 0x00, 0x00, /*   XXa     aXX    */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*   XXa     aXX    */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*   XXa     aXX    */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*   XXa     aXX    */
0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*   XXa     aXX    */
0x00, 0x00, 0xff, 0xff, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*   XXa     aXX    */
0x00, 0x00, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*   XXa     aXX    */
0x00, 0x00, 0xff, 0xff, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x00, 0x00, 0x00, /*   XXa     aXX    */
0x00, 0x00, 0xff, 0xff, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x08, 0xc4, 0xff, 0xff, 0x00, 0x00, 0x00, /*   XXO     OXX    */
0x00, 0x00, 0xef, 0xff, 0xf8, 0x0e, 0x00, 0x00, 0x3b, 0xd7, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, /*   XXX   .OXXX    */
0x00, 0x00, 0xa5, 0xff, 0xff, 0xd4, 0xa7, 0xd0, 0xff, 0xff, 0xfb, 0xff, 0xff, 0x00, 0x00, 0x00, /*   aXXOaOXXXXX    */
0x00, 0x00, 0x1e, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x78, 0xa5, 0xff, 0xfc, 0x00, 0x00, 0x00, /*    XXXXXX+aXX    */
0x00, 0x00, 0x00, 0x22, 0xa7, 0xda, 0xc8, 0x85, 0x1f, 0x00, 0x55, 0xf4, 0xb3, 0x00, 0x00, 0x00, /*    .aOOo  -Xa    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 118 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, /*                  */
0x00, 0x94, 0xec, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0x5c, 0x00, 0x00, /*  oX-       oX-   */
0x00, 0xf4, 0xff, 0xc9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xf1, 0xff, 0x91, 0x00, 0x00, /*  XXO       XXo   */
0x00, 0xc3, 0xff, 0xff, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xff, 0xff, 0x53, 0x00, 0x00, /*  OXX      -XX-   */
0x00, 0x63, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa9, 0xff, 0xed, 0x06, 0x00, 0x00, /*  +XX+     aXX    */
0x00, 0x0c, 0xf3, 0xff, 0xcb, 0x00, 0x00, 0x00, 0x00, 0x13, 0xf9, 0xff, 0x91, 0x00, 0x00, 0x00, /*   XXO     XXo    */
0x00, 0x00, 0x98, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x72, 0xff, 0xfd, 0x25, 0x00, 0x00, 0x00, /*   oXX.   +XX.    */
0x00, 0x00, 0x2a, 0xff, 0xff, 0x90, 0x00, 0x00, 0x02, 0xde, 0xff, 0xaf, 0x00, 0x00, 0x00, 0x00, /*   .XXo   OXa     */
0x00, 0x00, 0x00, 0xbc, 0xff, 0xee, 0x09, 0x00, 0x51, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, /*    aXX  -XX.     */
0x00, 0x00, 0x00, 0x48, 0xff, 0xff, 0x64, 0x00, 0xc8, 0xff, 0xc5, 0x00, 0x00, 0x00, 0x00, 0x00, /*    -XX+ OXO      */
0x00, 0x00, 0x00, 0x00, 0xcf, 0xff, 0xd0, 0x43, 0xff, 0xff, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, /*     OXO-XX-      */
0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0xe1, 0xff, 0xd8, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, /*     -XXXXO       */
0x00, 0x00, 0x00, 0x00, 0x02, 0xd7, 0xff, 0xff, 0xff, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      OXXX+       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x59, 0xff, 0xff, 0xe9, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      -XXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xcd, 0xff, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       OX+        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*        .         */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 119 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x69, 0xd0, 0x45, 0x00, 0x00, 0x00, 0x99, 0xee, 0x53, 0x00, 0x00, 0x05, 0xb0, 0x98, 0x00, 0x00, /* +O-   oX-   ao   */
0xc1, 0xff, 0xad, 0x00, 0x00, 0x12, 0xfe, 0xff, 0xb8, 0x00, 0x00, 0x32, 0xff, 0xff, 0x09, 0x00, /* OXa   XXa  .XX   */
0xaa, 0xff, 0xcb, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xe1, 0x00, 0x00, 0x51, 0xff, 0xf4, 0x00, 0x00, /* aXO  -XXX  -XX   */
0x8e, 0xff, 0xe9, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xfe, 0x0b, 0x00, 0x6e, 0xff, 0xd2, 0x00, 0x00, /* oXX  +XXX  +XO   */
0x6c, 0xff, 0xff, 0x0b, 0x00, 0xb0, 0xff, 0xcf, 0xff, 0x32, 0x00, 0x8c, 0xff, 0xaf, 0x00, 0x00, /* +XX  aXOX. oXa   */
0x41, 0xff, 0xff, 0x2e, 0x00, 0xdf, 0xdf, 0x9b, 0xff, 0x5c, 0x00, 0xab, 0xff, 0x87, 0x00, 0x00, /* -XX. OOoX- aXo   */
0x14, 0xff, 0xff, 0x53, 0x0f, 0xff, 0xae, 0x7f, 0xff, 0x88, 0x00, 0xc9, 0xff, 0x5c, 0x00, 0x00, /*  XX- Xa+Xo OX-   */
0x00, 0xe1, 0xff, 0x7a, 0x3d, 0xff, 0x7d, 0x60, 0xff, 0xb4, 0x00, 0xea, 0xff, 0x32, 0x00, 0x00, /*  XX+.X++Xa XX.   */
0x00, 0xa8, 0xff, 0xa1, 0x6b, 0xff, 0x4c, 0x41, 0xff, 0xe4, 0x0d, 0xff, 0xfc, 0x08, 0x00, 0x00, /*  aXa+X--XX XX    */
0x00, 0x6e, 0xff, 0xca, 0x96, 0xff, 0x1b, 0x1e, 0xff, 0xff, 0x47, 0xff, 0xd3, 0x00, 0x00, 0x00, /*  +XOoX  XX-XO    */
0x00, 0x2f, 0xff, 0xf3, 0xc3, 0xe5, 0x00, 0x01, 0xf5, 0xff, 0xa4, 0xff, 0x9f, 0x00, 0x00, 0x00, /*  .XXOX  XXaXo    */
0x00, 0x01, 0xe9, 0xff, 0xfa, 0xa4, 0x00, 0x00, 0xc4, 0xff, 0xf7, 0xff, 0x66, 0x00, 0x00, 0x00, /*   XXXa  OXXX+    */
0x00, 0x00, 0xa5, 0xff, 0xff, 0x62, 0x00, 0x00, 0x86, 0xff, 0xff, 0xff, 0x25, 0x00, 0x00, 0x00, /*   aXX+  oXXX.    */
0x00, 0x00, 0x57, 0xff, 0xfa, 0x1d, 0x00, 0x00, 0x32, 0xff, 0xff, 0xd4, 0x00, 0x00, 0x00, 0x00, /*   -XX   .XXO     */
0x00, 0x00, 0x01, 0x5d, 0x42, 0x00, 0x00, 0x00, 0x00, 0x48, 0x75, 0x1e, 0x00, 0x00, 0x00, 0x00, /*    --    -+      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 120 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x1d, 0x78, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x86, 0x4a, 0x00, 0x00, 0x00, /*   +.       o-    */
0x00, 0xa4, 0xff, 0xee, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x05, 0xc1, 0xff, 0xd7, 0x00, 0x00, 0x00, /*  aXX.     OXO    */
0x00, 0x66, 0xff, 0xff, 0xde, 0x13, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, /*  +XXO    oXX+    */
0x00, 0x01, 0xa6, 0xff, 0xff, 0xbb, 0x02, 0x00, 0x47, 0xfe, 0xff, 0xba, 0x02, 0x00, 0x00, 0x00, /*   aXXa  -XXa     */
0x00, 0x00, 0x05, 0xb7, 0xff, 0xff, 0x82, 0x16, 0xe7, 0xff, 0xe0, 0x13, 0x00, 0x00, 0x00, 0x00, /*    aXXo XXX      */
0x00, 0x00, 0x00, 0x0a, 0xc7, 0xff, 0xfe, 0xd1, 0xff, 0xf8, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, /*     OXXOXX.      */
0x00, 0x00, 0x00, 0x00, 0x15, 0xe0, 0xff, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XXXX+       */
0x00, 0x00, 0x00, 0x00, 0x03, 0xc3, 0xff, 0xff, 0xd9, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      OXXO        */
0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     oXXXXo       */
0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0x9c, 0xb2, 0xff, 0xfe, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, /*    +XXoaXX-      */
0x00, 0x00, 0x67, 0xff, 0xff, 0xc7, 0x07, 0x0e, 0xd9, 0xff, 0xf9, 0x44, 0x00, 0x00, 0x00, 0x00, /*   +XXO  OXX-     */
0x00, 0x50, 0xfd, 0xff, 0xe3, 0x18, 0x00, 0x00, 0x29, 0xf0, 0xff, 0xf3, 0x32, 0x00, 0x00, 0x00, /*  -XXX   .XXX.    */
0x0f, 0xf0, 0xff, 0xf5, 0x32, 0x00, 0x00, 0x00, 0x00, 0x42, 0xfa, 0xff, 0xdf, 0x07, 0x00, 0x00, /*  XXX.    -XXO    */
0x33, 0xff, 0xff, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0x3d, 0x00, 0x00, /* .XX-      +XX.   */
0x00, 0x74, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x73, 0x04, 0x00, 0x00, /*  ++        -+    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 121 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x01, 0xa3, 0xbf, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0xeb, 0x97, 0x00, 0x00, /*  aa        .Xo   */
0x28, 0xff, 0xff, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0xf2, 0x00, 0x00, /* .XXo       OXX   */
0x09, 0xf3, 0xff, 0xd9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0xff, 0xff, 0xbd, 0x00, 0x00, /*  XXO      .XXa   */
0x00, 0x9d, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x91, 0xff, 0xff, 0x53, 0x00, 0x00, /*  oXX.     oXX-   */
0x00, 0x3a, 0xff, 0xff, 0x91, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xf1, 0xff, 0xde, 0x03, 0x00, 0x00, /*  .XXo     XXO    */
0x00, 0x00, 0xd2, 0xff, 0xee, 0x09, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, /*   OXX    +XX+    */
0x00, 0x00, 0x65, 0xff, 0xff, 0x61, 0x00, 0x00, 0x02, 0xda, 0xff, 0xec, 0x0b, 0x00, 0x00, 0x00, /*   +XX+   OXX     */
0x00, 0x00, 0x09, 0xec, 0xff, 0xcf, 0x00, 0x00, 0x4f, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, /*    XXO  -XX+     */
0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x42, 0x00, 0xc4, 0xff, 0xf3, 0x12, 0x00, 0x00, 0x00, 0x00, /*    oXX- OXX      */
0x00, 0x00, 0x00, 0x13, 0xf5, 0xff, 0xb7, 0x3d, 0xff, 0xff, 0x8b, 0x00, 0x00, 0x00, 0x00, 0x00, /*     XXa.XXo      */
0x00, 0x00, 0x00, 0x00, 0x90, 0xff, 0xff, 0xd2, 0xff, 0xf7, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, /*     oXXOXX       */
0x00, 0x00, 0x00, 0x00, 0x1a, 0xf7, 0xff, 0xff, 0xff, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XXXXo       */
0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xfa, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      oXXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      .XXo        */
0x00, 0x00, 0x00, 0x00, 0x00, 0xa5, 0xff, 0xfc, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      aXX.        */
0x00, 0x00, 0x00, 0x00, 0x26, 0xfc, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     .XXa         */
0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xfe, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     aXX.         */
0x00, 0x00, 0x00, 0x24, 0xfc, 0xff, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    .XXa          */
0x00, 0x00, 0x00, 0x9f, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    oXX.          */
0x00, 0x00, 0x21, 0xfb, 0xff, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   .XXa           */
0x00, 0x00, 0x8a, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   oXX.           */
0x00, 0x00, 0x7c, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   +Xa            */
	/* 122 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x73, 0xa4, 0x8f, 0x7a, 0x65, 0x52, 0x48, 0x41, 0x39, 0x32, 0x0b, 0x00, 0x00, 0x00, /*   +ao++---..     */
0x00, 0x00, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0x00, 0x00, 0x00, /*   XXXXXXXXXXO    */
0x00, 0x00, 0x68, 0xbd, 0xd7, 0xe7, 0xf2, 0xf9, 0xfd, 0xff, 0xff, 0xff, 0xe5, 0x00, 0x00, 0x00, /*   +aOXXXXXXXX    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, /*          +XX+    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xfd, 0xff, 0xc4, 0x04, 0x00, 0x00, 0x00, /*         -XXO     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xfd, 0xff, 0xe9, 0x1a, 0x00, 0x00, 0x00, 0x00, /*        +XXX      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xfe, 0xff, 0xf7, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x00, /*       +XXX.      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0xf7, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      +XXX-       */
0x00, 0x00, 0x00, 0x00, 0x79, 0xff, 0xff, 0xf1, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     +XXX-        */
0x00, 0x00, 0x00, 0x87, 0xff, 0xff, 0xe7, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    oXXX.         */
0x00, 0x00, 0x90, 0xff, 0xff, 0xdf, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   oXXO.          */
0x00, 0x76, 0xff, 0xff, 0xf2, 0x4c, 0x2b, 0x27, 0x21, 0x16, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, /*  +XXX-...        */
0x00, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xa4, 0x00, 0x00, 0x00, /*  XXXXXXXXXXXa    */
0x00, 0x97, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xbd, 0x00, 0x00, 0x00, /*  oXXXXXXXXXXa    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 123 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x22, 0x21, 0x00, 0x00, 0x00, 0x00, /*           ..     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4b, 0xbf, 0xfa, 0xff, 0xff, 0x5d, 0x00, 0x00, 0x00, /*        -aXXX-    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0xff, 0xe3, 0x2a, 0x00, 0x00, 0x00, /*       oXXXXX.    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xd9, 0x54, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, /*      -XXO-       */
0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xf1, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      aXX         */
0x00, 0x00, 0x00, 0x00, 0x00, 0xf1, 0xff, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XXa         */
0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XXO         */
0x00, 0x00, 0x00, 0x00, 0x00, 0xdb, 0xff, 0xf0, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      OXX         */
0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0xff, 0xff, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      aXX-        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0xff, 0xff, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      .XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe2, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXX        */
0x00, 0x00, 0x00, 0x04, 0x1d, 0x75, 0xff, 0xff, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      +XX+        */
0x00, 0xc6, 0xff, 0xff, 0xff, 0xf6, 0xb0, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  OXXXXa.         */
0x00, 0xcd, 0xff, 0xff, 0xff, 0xee, 0x93, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  OXXXXo          */
0x00, 0x07, 0x33, 0x4a, 0x7d, 0xd6, 0xff, 0xf3, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   .-+OXX-        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc5, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       OXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0xe5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       OXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xf9, 0xff, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      -XX-        */
0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0xff, 0xfb, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      aXX         */
0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0xff, 0xcd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      OXO         */
0x00, 0x00, 0x00, 0x00, 0x00, 0xf7, 0xff, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XXa         */
0x00, 0x00, 0x00, 0x00, 0x00, 0xe9, 0xff, 0xda, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XXO         */
0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xde, 0x75, 0x40, 0x21, 0x00, 0x00, 0x00, 0x00, /*      oXXO+-.     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5b, 0x00, 0x00, 0x00, /*       aXXXXX-    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x97, 0xd0, 0xeb, 0xf2, 0x40, 0x00, 0x00, 0x00, /*        .oOXX-    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 124 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0x72, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       .+         */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xed, 0xff, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXo        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0xff, 0xff, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xd4, 0xe7, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       OX-        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 125 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x22, 0x19, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*   .              */
0x00, 0x59, 0xff, 0xff, 0xfc, 0xc7, 0x6b, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -XXXO+          */
0x00, 0x44, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xdd, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -XXXXXO         */
0x00, 0x00, 0x00, 0x13, 0x46, 0xb4, 0xff, 0xff, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*     -aXXa        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       OXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xba, 0xff, 0xec, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe3, 0xff, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       XXO        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0xff, 0xff, 0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      .XX+        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0xff, 0xfd, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      oXX         */
0x00, 0x00, 0x00, 0x00, 0x00, 0xdd, 0xff, 0xcd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      OXO         */
0x00, 0x00, 0x00, 0x00, 0x00, 0xf4, 0xff, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XXa         */
0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xf9, 0xff, 0xcb, 0x73, 0x46, 0x32, 0x07, 0x00, 0x00, 0x00, /*      +XXO+-.     */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x99, 0xef, 0xff, 0xff, 0xff, 0xc9, 0x00, 0x00, 0x00, /*       .oXXXXO    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0xaa, 0xf5, 0xff, 0xff, 0xff, 0xc6, 0x00, 0x00, 0x00, /*       .aXXXXO    */
0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xfd, 0xff, 0x7f, 0x24, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, /*      +XX+.       */
0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xdf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      XXO         */
0x00, 0x00, 0x00, 0x00, 0x00, 0xd2, 0xff, 0xfe, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      OXX.        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      +XXo        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xc9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      .XXO        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0xff, 0xe8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       OXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       aXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc9, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*       OXX        */
0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xfc, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*      .XXa        */
0x00, 0x00, 0x1a, 0x48, 0x86, 0xf4, 0xff, 0xf7, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*    -oXXX.        */
0x00, 0x41, 0xfa, 0xff, 0xff, 0xff, 0xf2, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -XXXXX-         */
0x00, 0x47, 0xf2, 0xf3, 0xd1, 0x8b, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  -XXOo           */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
	/* 126 */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x0c, 0xa7, 0xf8, 0xde, 0x55, 0x00, 0x00, 0x00, 0x00, 0x01, 0x82, 0x53, 0x00, 0x00, /*    aXO-     o-   */
0x00, 0x00, 0xb4, 0xff, 0xff, 0xff, 0xfb, 0x33, 0x00, 0x00, 0x00, 0x61, 0xff, 0x97, 0x00, 0x00, /*   aXXXX.   +Xo   */
0x00, 0x5a, 0xff, 0xff, 0xe8, 0xff, 0xff, 0xc5, 0x00, 0x00, 0x01, 0xd8, 0xff, 0x5b, 0x00, 0x00, /*  -XXXXXO   OX-   */
0x00, 0xd3, 0xff, 0xa9, 0x00, 0x6b, 0xff, 0xff, 0x57, 0x00, 0x63, 0xff, 0xed, 0x09, 0x00, 0x00, /*  OXa +XX- +XX    */
0x31, 0xff, 0xff, 0x2f, 0x00, 0x01, 0xc5, 0xff, 0xfc, 0xda, 0xfc, 0xff, 0x79, 0x00, 0x00, 0x00, /* .XX.  OXXOXX+    */
0x77, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x2c, 0xf5, 0xff, 0xff, 0xff, 0xce, 0x06, 0x00, 0x00, 0x00, /* +XO   .XXXXO     */
0x5d, 0xec, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xd1, 0xf7, 0xb1, 0x16, 0x00, 0x00, 0x00, 0x00, /* -X.    .OXa      */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*                  */
};
