/*	 $NetBSD: bold16x32.h,v 1.1 2019/04/07 13:48:27 jmcneill Exp $ */

/*-
 * Copyright (c) 1999-2019 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Andrew Doran.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * This font lives in the public domain. It it a PC font, IBM encoding,
 * which was designed for use with syscons.
 *
 * This is a pixel doubled version of the bold8x16 font.
 */
static u_char bold16x32_data[];

static struct wsdisplay_font bold16x32 = {
	"Boldface 16x32",		/* typeface name */
	1,				/* firstchar */
	254,				/* numchars */
	WSDISPLAY_FONTENC_IBM,		/* encoding */
	16,				/* width */
	32,				/* height */
	2,				/* stride */
	WSDISPLAY_FONTORDER_L2R,	/* bit order */
	WSDISPLAY_FONTORDER_L2R,	/* byte order */
	bold16x32_data			/* data */
};

static u_char bold16x32_data[] = {
	/* 0x01 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x30, 0x0c,	 /* ..**........**.. */
	0x30, 0x0c,	 /* ..**........**.. */
	0xc0, 0x03,	 /* **............** */
	0xc0, 0x03,	 /* **............** */
	0xfc, 0x3f,	 /* ******....****** */
	0xfc, 0x3f,	 /* ******....****** */
	0xcc, 0x33,	 /* **..**....**..** */
	0xcc, 0x33,	 /* **..**....**..** */
	0xc3, 0xc3,	 /* **....****....** */
	0xc3, 0xc3,	 /* **....****....** */
	0xc0, 0x03,	 /* **............** */
	0xc0, 0x03,	 /* **............** */
	0xc3, 0xc3,	 /* **....****....** */
	0xc3, 0xc3,	 /* **....****....** */
	0x30, 0x0c,	 /* ..**........**.. */
	0x30, 0x0c,	 /* ..**........**.. */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x02 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xc3, 0xc3,	 /* **....****....** */
	0xc3, 0xc3,	 /* **....****....** */
	0xf3, 0xcf,	 /* ****..****..**** */
	0xf3, 0xcf,	 /* ****..****..**** */
	0xfc, 0x3f,	 /* ******....****** */
	0xfc, 0x3f,	 /* ******....****** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xfc, 0x3f,	 /* ******....****** */
	0xfc, 0x3f,	 /* ******....****** */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x03 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x04 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x05 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x06 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x33, 0x30,	 /* ..**..**..**.... */
	0x33, 0x30,	 /* ..**..**..**.... */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x07 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x08 */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xfc, 0x3f,	 /* ******....****** */
	0xfc, 0x3f,	 /* ******....****** */
	0xf0, 0x0f,	 /* ****........**** */
	0xf0, 0x0f,	 /* ****........**** */
	0xf0, 0x0f,	 /* ****........**** */
	0xf0, 0x0f,	 /* ****........**** */
	0xfc, 0x3f,	 /* ******....****** */
	0xfc, 0x3f,	 /* ******....****** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */

	/* 0x09 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x30, 0x0c,	 /* ..**........**.. */
	0x30, 0x0c,	 /* ..**........**.. */
	0x30, 0x0c,	 /* ..**........**.. */
	0x30, 0x0c,	 /* ..**........**.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x0A */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xf0, 0x0f,	 /* ****........**** */
	0xf0, 0x0f,	 /* ****........**** */
	0xc3, 0xc3,	 /* **....****....** */
	0xc3, 0xc3,	 /* **....****....** */
	0xcf, 0xf3,	 /* **..********..** */
	0xcf, 0xf3,	 /* **..********..** */
	0xcf, 0xf3,	 /* **..********..** */
	0xcf, 0xf3,	 /* **..********..** */
	0xc3, 0xc3,	 /* **....****....** */
	0xc3, 0xc3,	 /* **....****....** */
	0xf0, 0x0f,	 /* ****........**** */
	0xf0, 0x0f,	 /* ****........**** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */

	/* 0x0B */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xfc,	 /* ......********.. */
	0x03, 0xfc,	 /* ......********.. */
	0x00, 0xfc,	 /* ........******.. */
	0x00, 0xfc,	 /* ........******.. */
	0x03, 0xcc,	 /* ......****..**.. */
	0x03, 0xcc,	 /* ......****..**.. */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x3f, 0xc0,	 /* ..********...... */
	0x3f, 0xc0,	 /* ..********...... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0x3f, 0xc0,	 /* ..********...... */
	0x3f, 0xc0,	 /* ..********...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x0C */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x0D */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0x30,	 /* ......**..**.... */
	0x03, 0x30,	 /* ......**..**.... */
	0x03, 0x30,	 /* ......**..**.... */
	0x03, 0x30,	 /* ......**..**.... */
	0x03, 0x30,	 /* ......**..**.... */
	0x03, 0x30,	 /* ......**..**.... */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x3f, 0x00,	 /* ..******........ */
	0x3f, 0x00,	 /* ..******........ */
	0x0c, 0x00,	 /* ....**.......... */
	0x0c, 0x00,	 /* ....**.......... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x0E */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xfc,	 /* ....**********.. */
	0x0f, 0xfc,	 /* ....**********.. */
	0x0c, 0x0c,	 /* ....**......**.. */
	0x0c, 0x0c,	 /* ....**......**.. */
	0x0f, 0xfc,	 /* ....**********.. */
	0x0f, 0xfc,	 /* ....**********.. */
	0x0c, 0x0c,	 /* ....**......**.. */
	0x0c, 0x0c,	 /* ....**......**.. */
	0x0c, 0x0c,	 /* ....**......**.. */
	0x0c, 0x0c,	 /* ....**......**.. */
	0x0c, 0x0c,	 /* ....**......**.. */
	0x0c, 0x0c,	 /* ....**......**.. */
	0x0c, 0x0c,	 /* ....**......**.. */
	0x0c, 0x0c,	 /* ....**......**.. */
	0x0c, 0x3c,	 /* ....**....****.. */
	0x0c, 0x3c,	 /* ....**....****.. */
	0x3c, 0xfc,	 /* ..****..******.. */
	0x3c, 0xfc,	 /* ..****..******.. */
	0xfc, 0x30,	 /* ******....**.... */
	0xfc, 0x30,	 /* ******....**.... */
	0x30, 0x00,	 /* ..**............ */
	0x30, 0x00,	 /* ..**............ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x0F */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0xc3, 0x0c,	 /* **....**....**.. */
	0xc3, 0x0c,	 /* **....**....**.. */
	0x33, 0x30,	 /* ..**..**..**.... */
	0x33, 0x30,	 /* ..**..**..**.... */
	0x0c, 0xc0,	 /* ....**..**...... */
	0x0c, 0xc0,	 /* ....**..**...... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x0c, 0xc0,	 /* ....**..**...... */
	0x0c, 0xc0,	 /* ....**..**...... */
	0x33, 0x30,	 /* ..**..**..**.... */
	0x33, 0x30,	 /* ..**..**..**.... */
	0xc3, 0x0c,	 /* **....**....**.. */
	0xc3, 0x0c,	 /* **....**....**.. */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x10 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3f, 0x00,	 /* ..******........ */
	0x3f, 0x00,	 /* ..******........ */
	0x3f, 0xc0,	 /* ..********...... */
	0x3f, 0xc0,	 /* ..********...... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xc0,	 /* ..********...... */
	0x3f, 0xc0,	 /* ..********...... */
	0x3f, 0x00,	 /* ..******........ */
	0x3f, 0x00,	 /* ..******........ */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x11 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0xfc,	 /* ........******.. */
	0x00, 0xfc,	 /* ........******.. */
	0x03, 0xfc,	 /* ......********.. */
	0x03, 0xfc,	 /* ......********.. */
	0x0f, 0xfc,	 /* ....**********.. */
	0x0f, 0xfc,	 /* ....**********.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x0f, 0xfc,	 /* ....**********.. */
	0x0f, 0xfc,	 /* ....**********.. */
	0x03, 0xfc,	 /* ......********.. */
	0x03, 0xfc,	 /* ......********.. */
	0x00, 0xfc,	 /* ........******.. */
	0x00, 0xfc,	 /* ........******.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x12 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x13 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x14 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0xff, 0x30,	 /* ********..**.... */
	0xff, 0x30,	 /* ********..**.... */
	0xff, 0x30,	 /* ********..**.... */
	0xff, 0x30,	 /* ********..**.... */
	0xff, 0x30,	 /* ********..**.... */
	0xff, 0x30,	 /* ********..**.... */
	0x3f, 0x30,	 /* ..******..**.... */
	0x3f, 0x30,	 /* ..******..**.... */
	0x03, 0x30,	 /* ......**..**.... */
	0x03, 0x30,	 /* ......**..**.... */
	0x03, 0x30,	 /* ......**..**.... */
	0x03, 0x30,	 /* ......**..**.... */
	0x03, 0x30,	 /* ......**..**.... */
	0x03, 0x30,	 /* ......**..**.... */
	0x03, 0x30,	 /* ......**..**.... */
	0x03, 0x30,	 /* ......**..**.... */
	0x03, 0x30,	 /* ......**..**.... */
	0x03, 0x30,	 /* ......**..**.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x15 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xfc,	 /* ......********.. */
	0x03, 0xfc,	 /* ......********.. */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x3f, 0xc0,	 /* ..********...... */
	0x3f, 0xc0,	 /* ..********...... */
	0xf3, 0xf0,	 /* ****..******.... */
	0xf3, 0xf0,	 /* ****..******.... */
	0xf0, 0xfc,	 /* ****....******.. */
	0xf0, 0xfc,	 /* ****....******.. */
	0xfc, 0x3f,	 /* ******....****** */
	0xfc, 0x3f,	 /* ******....****** */
	0x3f, 0x0f,	 /* ..******....**** */
	0x3f, 0x0f,	 /* ..******....**** */
	0x0f, 0xcf,	 /* ....******..**** */
	0x0f, 0xcf,	 /* ....******..**** */
	0x03, 0xfc,	 /* ......********.. */
	0x03, 0xfc,	 /* ......********.. */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x3f, 0xc0,	 /* ..********...... */
	0x3f, 0xc0,	 /* ..********...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x16 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x17 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x18 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x19 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x1A */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0xc0,	 /* ........**...... */
	0x00, 0xc0,	 /* ........**...... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xc0,	 /* ........**...... */
	0x00, 0xc0,	 /* ........**...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x1B */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x3f, 0xff,	 /* ..************** */
	0x3f, 0xff,	 /* ..************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0x3f, 0xff,	 /* ..************** */
	0x3f, 0xff,	 /* ..************** */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x1C */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0x0f,	 /* ....****....**** */
	0x0f, 0x0f,	 /* ....****....**** */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0xfc, 0xfc,	 /* ******..******.. */
	0xfc, 0xfc,	 /* ******..******.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x1D */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0c, 0x30,	 /* ....**....**.... */
	0x0c, 0x30,	 /* ....**....**.... */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x0c, 0x30,	 /* ....**....**.... */
	0x0c, 0x30,	 /* ....**....**.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x1E */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x1F */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/*   */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* ! */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* " */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0x3f,	 /* ..******..****** */
	0x3f, 0x3f,	 /* ..******..****** */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* # */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* $ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x00,	 /* ****..**........ */
	0xf3, 0x00,	 /* ****..**........ */
	0xf3, 0x00,	 /* ****..**........ */
	0xf3, 0x00,	 /* ****..**........ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x03, 0x3c,	 /* ......**..****.. */
	0x03, 0x3c,	 /* ......**..****.. */
	0x03, 0x3c,	 /* ......**..****.. */
	0x03, 0x3c,	 /* ......**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* % */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x30,	 /* ****......**.... */
	0xf0, 0x30,	 /* ****......**.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xc0,	 /* ........**...... */
	0x00, 0xc0,	 /* ........**...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0c, 0x00,	 /* ....**.......... */
	0x0c, 0x00,	 /* ....**.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x30, 0x3c,	 /* ..**......****.. */
	0x30, 0x3c,	 /* ..**......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* & */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x3f, 0x3c,	 /* ..******..****.. */
	0x3f, 0x3c,	 /* ..******..****.. */
	0xf3, 0xf0,	 /* ****..******.... */
	0xf3, 0xf0,	 /* ****..******.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0x3f, 0x3c,	 /* ..******..****.. */
	0x3f, 0x3c,	 /* ..******..****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* ' */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xf0,	 /* ......******.... */
	0x03, 0xf0,	 /* ......******.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* ( */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* ) */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* * */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* + */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* , */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xf0,	 /* ......******.... */
	0x03, 0xf0,	 /* ......******.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* - */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* . */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* / */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x30,	 /* ..........**.... */
	0x00, 0x30,	 /* ..........**.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xc0,	 /* ........**...... */
	0x00, 0xc0,	 /* ........**...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0c, 0x00,	 /* ....**.......... */
	0x0c, 0x00,	 /* ....**.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x30, 0x00,	 /* ..**............ */
	0x30, 0x00,	 /* ..**............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 1 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 2 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 3 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 4 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x03, 0xf0,	 /* ......******.... */
	0x03, 0xf0,	 /* ......******.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 5 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 6 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 7 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 8 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 9 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x3f, 0xc0,	 /* ..********...... */
	0x3f, 0xc0,	 /* ..********...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* : */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* ; */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* < */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* = */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* > */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* ? */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x03, 0xf0,	 /* ......******.... */
	0x03, 0xf0,	 /* ......******.... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* @ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf3, 0xfc,	 /* ****..********.. */
	0xf3, 0xfc,	 /* ****..********.. */
	0xf3, 0xfc,	 /* ****..********.. */
	0xf3, 0xfc,	 /* ****..********.. */
	0xf3, 0xfc,	 /* ****..********.. */
	0xf3, 0xfc,	 /* ****..********.. */
	0xf3, 0xfc,	 /* ****..********.. */
	0xf3, 0xfc,	 /* ****..********.. */
	0xf3, 0xf0,	 /* ****..******.... */
	0xf3, 0xf0,	 /* ****..******.... */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* A */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* B */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* C */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* D */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xc0,	 /* **********...... */
	0xff, 0xc0,	 /* **********...... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xff, 0xc0,	 /* **********...... */
	0xff, 0xc0,	 /* **********...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* E */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* F */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* G */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0xfc,	 /* ****....******.. */
	0xf0, 0xfc,	 /* ****....******.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* H */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* I */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* J */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xfc,	 /* ......********.. */
	0x03, 0xfc,	 /* ......********.. */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0x3f, 0xc0,	 /* ..********...... */
	0x3f, 0xc0,	 /* ..********...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* K */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xfc, 0x00,	 /* ******.......... */
	0xfc, 0x00,	 /* ******.......... */
	0xfc, 0x00,	 /* ******.......... */
	0xfc, 0x00,	 /* ******.......... */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* L */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* M */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xfc, 0xfc,	 /* ******..******.. */
	0xfc, 0xfc,	 /* ******..******.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* N */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xfc, 0x3c,	 /* ******....****.. */
	0xfc, 0x3c,	 /* ******....****.. */
	0xff, 0x3c,	 /* ********..****.. */
	0xff, 0x3c,	 /* ********..****.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xf3, 0xfc,	 /* ****..********.. */
	0xf3, 0xfc,	 /* ****..********.. */
	0xf0, 0xfc,	 /* ****....******.. */
	0xf0, 0xfc,	 /* ****....******.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* O */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* P */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* Q */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xff, 0x3c,	 /* ********..****.. */
	0xff, 0x3c,	 /* ********..****.. */
	0xf3, 0xfc,	 /* ****..********.. */
	0xf3, 0xfc,	 /* ****..********.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* R */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* S */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* T */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* U */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* V */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* W */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xfc, 0xfc,	 /* ******..******.. */
	0xfc, 0xfc,	 /* ******..******.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* X */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* Y */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* Z */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* [ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* \ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0x30, 0x00,	 /* ..**............ */
	0x30, 0x00,	 /* ..**............ */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x0c, 0x00,	 /* ....**.......... */
	0x0c, 0x00,	 /* ....**.......... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0xc0,	 /* ........**...... */
	0x00, 0xc0,	 /* ........**...... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0x30,	 /* ..........**.... */
	0x00, 0x30,	 /* ..........**.... */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* ] */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* ^ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* _ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* ` */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* a */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* b */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* c */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* d */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* e */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* f */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* g */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* h */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* i */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* j */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* k */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* l */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* m */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xfc, 0xf0,	 /* ******..****.... */
	0xfc, 0xf0,	 /* ******..****.... */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* n */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* o */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* p */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* q */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* r */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* s */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0x3f, 0x00,	 /* ..******........ */
	0x3f, 0x00,	 /* ..******........ */
	0x03, 0xf0,	 /* ......******.... */
	0x03, 0xf0,	 /* ......******.... */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* t */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x03, 0xf0,	 /* ......******.... */
	0x03, 0xf0,	 /* ......******.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* u */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* v */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* w */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xf3, 0x3c,	 /* ****..**..****.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* x */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* y */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* z */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* { */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0xfc,	 /* ........******.. */
	0x00, 0xfc,	 /* ........******.. */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0xfc,	 /* ........******.. */
	0x00, 0xfc,	 /* ........******.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* | */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* } */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0x00,	 /* ..******........ */
	0x3f, 0x00,	 /* ..******........ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x3f, 0x00,	 /* ..******........ */
	0x3f, 0x00,	 /* ..******........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* ~ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0x3c,	 /* ..******..****.. */
	0x3f, 0x3c,	 /* ..******..****.. */
	0xf3, 0xf0,	 /* ****..******.... */
	0xf3, 0xf0,	 /* ****..******.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x7F */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x80 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0xc3, 0xc0,	 /* **....****...... */
	0xc3, 0xc0,	 /* **....****...... */
	0x3f, 0x00,	 /* ..******........ */
	0x3f, 0x00,	 /* ..******........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x81 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x82 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x83 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x84 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x85 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x86 */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x87 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0xc3, 0xc0,	 /* **....****...... */
	0xc3, 0xc0,	 /* **....****...... */
	0x3f, 0x00,	 /* ..******........ */
	0x3f, 0x00,	 /* ..******........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x88 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x89 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x8A */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x8B */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x8C */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x8D */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x8E */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x8F */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x90 */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x91 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0xf3, 0xcf,	 /* ****..****..**** */
	0xf3, 0xcf,	 /* ****..****..**** */
	0x03, 0xcf,	 /* ......****..**** */
	0x03, 0xcf,	 /* ......****..**** */
	0x3f, 0xff,	 /* ..************** */
	0x3f, 0xff,	 /* ..************** */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xcf,	 /* ****..****..**** */
	0xf3, 0xcf,	 /* ****..****..**** */
	0x3c, 0xfc,	 /* ..****..******.. */
	0x3c, 0xfc,	 /* ..****..******.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x92 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xff,	 /* ..****..******** */
	0x3c, 0xff,	 /* ..****..******** */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xff,	 /* ****....******** */
	0xf0, 0xff,	 /* ****....******** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x93 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x94 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x95 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x96 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x97 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x98 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x99 */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x9A */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x9B */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0xf0, 0x0f,	 /* ****........**** */
	0xf0, 0x0f,	 /* ****........**** */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x0f,	 /* ****........**** */
	0xf0, 0x0f,	 /* ****........**** */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x9C */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x9D */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x9E */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0xff,	 /* ****....******** */
	0xf0, 0xff,	 /* ****....******** */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x3f,	 /* ..........****** */
	0x00, 0x3f,	 /* ..........****** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0x9F */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0xfc,	 /* ........******.. */
	0x00, 0xfc,	 /* ........******.. */
	0x03, 0xcf,	 /* ......****..**** */
	0x03, 0xcf,	 /* ......****..**** */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0x3f, 0x00,	 /* ..******........ */
	0x3f, 0x00,	 /* ..******........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xA0 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xA1 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xA2 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xA3 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xA4 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0x3c,	 /* ..******..****.. */
	0x3f, 0x3c,	 /* ..******..****.. */
	0xf3, 0xf0,	 /* ****..******.... */
	0xf3, 0xf0,	 /* ****..******.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xA5 */
	0x3f, 0x3c,	 /* ..******..****.. */
	0x3f, 0x3c,	 /* ..******..****.. */
	0xf3, 0xf0,	 /* ****..******.... */
	0xf3, 0xf0,	 /* ****..******.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xfc, 0x3c,	 /* ******....****.. */
	0xfc, 0x3c,	 /* ******....****.. */
	0xff, 0x3c,	 /* ********..****.. */
	0xff, 0x3c,	 /* ********..****.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xf3, 0xfc,	 /* ****..********.. */
	0xf3, 0xfc,	 /* ****..********.. */
	0xf0, 0xfc,	 /* ****....******.. */
	0xf0, 0xfc,	 /* ****....******.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xA6 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xA7 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xA8 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x3f, 0x00,	 /* ..******........ */
	0x3f, 0x00,	 /* ..******........ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xA9 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xAA */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xAB */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0c, 0xf0,	 /* ....**..****.... */
	0x0c, 0xf0,	 /* ....**..****.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xAC */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x3c, 0xc0,	 /* ..****..**...... */
	0x3c, 0xc0,	 /* ..****..**...... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xAD */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xAE */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0x3c,	 /* ....****..****.. */
	0x0f, 0x3c,	 /* ....****..****.. */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x0f, 0x3c,	 /* ....****..****.. */
	0x0f, 0x3c,	 /* ....****..****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xAF */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x0f, 0x3c,	 /* ....****..****.. */
	0x0f, 0x3c,	 /* ....****..****.. */
	0x0f, 0x3c,	 /* ....****..****.. */
	0x0f, 0x3c,	 /* ....****..****.. */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xB0 */
	0xc0, 0x0c,	 /* **..........**.. */
	0xc0, 0x0c,	 /* **..........**.. */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0xc0, 0x0c,	 /* **..........**.. */
	0xc0, 0x0c,	 /* **..........**.. */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0xc0, 0x0c,	 /* **..........**.. */
	0xc0, 0x0c,	 /* **..........**.. */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0xc0, 0x0c,	 /* **..........**.. */
	0xc0, 0x0c,	 /* **..........**.. */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0xc0, 0x0c,	 /* **..........**.. */
	0xc0, 0x0c,	 /* **..........**.. */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0xc0, 0x0c,	 /* **..........**.. */
	0xc0, 0x0c,	 /* **..........**.. */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0xc0, 0x0c,	 /* **..........**.. */
	0xc0, 0x0c,	 /* **..........**.. */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */
	0xc0, 0x0c,	 /* **..........**.. */
	0xc0, 0x0c,	 /* **..........**.. */
	0x03, 0x00,	 /* ......**........ */
	0x03, 0x00,	 /* ......**........ */

	/* 0xB1 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xc3, 0x33,	 /* **....**..**..** */
	0xc3, 0x33,	 /* **....**..**..** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xcc, 0xc3,	 /* **..**..**....** */
	0xcc, 0xc3,	 /* **..**..**....** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xc3, 0x33,	 /* **....**..**..** */
	0xc3, 0x33,	 /* **....**..**..** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xcc, 0xc3,	 /* **..**..**....** */
	0xcc, 0xc3,	 /* **..**..**....** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xc3, 0x33,	 /* **....**..**..** */
	0xc3, 0x33,	 /* **....**..**..** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xcc, 0xc3,	 /* **..**..**....** */
	0xcc, 0xc3,	 /* **..**..**....** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xc3, 0x33,	 /* **....**..**..** */
	0xc3, 0x33,	 /* **....**..**..** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xcc, 0xc3,	 /* **..**..**....** */
	0xcc, 0xc3,	 /* **..**..**....** */

	/* 0xB2 */
	0xc3, 0x0c,	 /* **....**....**.. */
	0xc3, 0x0c,	 /* **....**....**.. */
	0x30, 0xc3,	 /* ..**....**....** */
	0x30, 0xc3,	 /* ..**....**....** */
	0xc3, 0x0c,	 /* **....**....**.. */
	0xc3, 0x0c,	 /* **....**....**.. */
	0x30, 0xc3,	 /* ..**....**....** */
	0x30, 0xc3,	 /* ..**....**....** */
	0xc3, 0x0c,	 /* **....**....**.. */
	0xc3, 0x0c,	 /* **....**....**.. */
	0x30, 0xc3,	 /* ..**....**....** */
	0x30, 0xc3,	 /* ..**....**....** */
	0xc3, 0x0c,	 /* **....**....**.. */
	0xc3, 0x0c,	 /* **....**....**.. */
	0x30, 0xc3,	 /* ..**....**....** */
	0x30, 0xc3,	 /* ..**....**....** */
	0xc3, 0x0c,	 /* **....**....**.. */
	0xc3, 0x0c,	 /* **....**....**.. */
	0x30, 0xc3,	 /* ..**....**....** */
	0x30, 0xc3,	 /* ..**....**....** */
	0xc3, 0x0c,	 /* **....**....**.. */
	0xc3, 0x0c,	 /* **....**....**.. */
	0x30, 0xc3,	 /* ..**....**....** */
	0x30, 0xc3,	 /* ..**....**....** */
	0xc3, 0x0c,	 /* **....**....**.. */
	0xc3, 0x0c,	 /* **....**....**.. */
	0x30, 0xc3,	 /* ..**....**....** */
	0x30, 0xc3,	 /* ..**....**....** */
	0xc3, 0x0c,	 /* **....**....**.. */
	0xc3, 0x0c,	 /* **....**....**.. */
	0x30, 0xc3,	 /* ..**....**....** */
	0x30, 0xc3,	 /* ..**....**....** */

	/* 0xB3 */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */

	/* 0xB4 */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0xff, 0xc0,	 /* **********...... */
	0xff, 0xc0,	 /* **********...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */

	/* 0xB5 */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0xff, 0xc0,	 /* **********...... */
	0xff, 0xc0,	 /* **********...... */
	0xff, 0xc0,	 /* **********...... */
	0xff, 0xc0,	 /* **********...... */
	0xff, 0xc0,	 /* **********...... */
	0xff, 0xc0,	 /* **********...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */

	/* 0xB6 */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */

	/* 0xB7 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */

	/* 0xB8 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xc0,	 /* **********...... */
	0xff, 0xc0,	 /* **********...... */
	0xff, 0xc0,	 /* **********...... */
	0xff, 0xc0,	 /* **********...... */
	0xff, 0xc0,	 /* **********...... */
	0xff, 0xc0,	 /* **********...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */

	/* 0xB9 */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */

	/* 0xBA */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */

	/* 0xBB */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */

	/* 0xBC */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xBD */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xBE */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0xff, 0xc0,	 /* **********...... */
	0xff, 0xc0,	 /* **********...... */
	0xff, 0xc0,	 /* **********...... */
	0xff, 0xc0,	 /* **********...... */
	0xff, 0xc0,	 /* **********...... */
	0xff, 0xc0,	 /* **********...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xBF */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xc0,	 /* **********...... */
	0xff, 0xc0,	 /* **********...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */

	/* 0xC0 */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xff,	 /* ......********** */
	0x03, 0xff,	 /* ......********** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xC1 */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xC2 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */

	/* 0xC3 */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xff,	 /* ......********** */
	0x03, 0xff,	 /* ......********** */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */

	/* 0xC4 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xC5 */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */

	/* 0xC6 */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xff,	 /* ......********** */
	0x03, 0xff,	 /* ......********** */
	0x03, 0xff,	 /* ......********** */
	0x03, 0xff,	 /* ......********** */
	0x03, 0xff,	 /* ......********** */
	0x03, 0xff,	 /* ......********** */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */

	/* 0xC7 */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */

	/* 0xC8 */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xff,	 /* ....************ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xC9 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */

	/* 0xCA */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xCB */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */

	/* 0xCC */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */

	/* 0xCD */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xCE */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */

	/* 0xCF */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xD0 */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xD1 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */

	/* 0xD2 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */

	/* 0xD3 */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xff,	 /* ....************ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xD4 */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xff,	 /* ......********** */
	0x03, 0xff,	 /* ......********** */
	0x03, 0xff,	 /* ......********** */
	0x03, 0xff,	 /* ......********** */
	0x03, 0xff,	 /* ......********** */
	0x03, 0xff,	 /* ......********** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xD5 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xff,	 /* ......********** */
	0x03, 0xff,	 /* ......********** */
	0x03, 0xff,	 /* ......********** */
	0x03, 0xff,	 /* ......********** */
	0x03, 0xff,	 /* ......********** */
	0x03, 0xff,	 /* ......********** */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */

	/* 0xD6 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xff,	 /* ....************ */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */

	/* 0xD7 */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */

	/* 0xD8 */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */

	/* 0xD9 */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0xff, 0xc0,	 /* **********...... */
	0xff, 0xc0,	 /* **********...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xDA */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xff,	 /* ......********** */
	0x03, 0xff,	 /* ......********** */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */

	/* 0xDB */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */

	/* 0xDC */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */

	/* 0xDD */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */

	/* 0xDE */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */
	0x00, 0xff,	 /* ........******** */

	/* 0xDF */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0xff, 0xff,	 /* **************** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xE0 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0x3f,	 /* ..******..****** */
	0x3f, 0x3f,	 /* ..******..****** */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf3, 0xfc,	 /* ****..********.. */
	0xf3, 0xfc,	 /* ****..********.. */
	0x3f, 0x0f,	 /* ..******....**** */
	0x3f, 0x0f,	 /* ..******....**** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xE1 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x30,	 /* ****......**.... */
	0xf0, 0x30,	 /* ****......**.... */
	0xf0, 0xc0,	 /* ****....**...... */
	0xf0, 0xc0,	 /* ****....**...... */
	0xf0, 0x30,	 /* ****......**.... */
	0xf0, 0x30,	 /* ****......**.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf3, 0xf0,	 /* ****..******.... */
	0xf3, 0xf0,	 /* ****..******.... */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xE2 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xE3 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x0f,	 /* ............**** */
	0x00, 0x0f,	 /* ............**** */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0xfc, 0xf0,	 /* ******..****.... */
	0xfc, 0xf0,	 /* ******..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xc0,	 /* ..****..**...... */
	0x3c, 0xc0,	 /* ..****..**...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xE4 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xE5 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xff,	 /* ..************** */
	0x3f, 0xff,	 /* ..************** */
	0xff, 0x00,	 /* ********........ */
	0xff, 0x00,	 /* ********........ */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0x3f, 0x00,	 /* ..******........ */
	0x3f, 0x00,	 /* ..******........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xE6 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xE7 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0x3c,	 /* ..******..****.. */
	0x3f, 0x3c,	 /* ..******..****.. */
	0xf3, 0xf0,	 /* ****..******.... */
	0xf3, 0xf0,	 /* ****..******.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xE8 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0xf3, 0xcf,	 /* ****..****..**** */
	0xf3, 0xcf,	 /* ****..****..**** */
	0xf3, 0xcf,	 /* ****..****..**** */
	0xf3, 0xcf,	 /* ****..****..**** */
	0xf3, 0xcf,	 /* ****..****..**** */
	0xf3, 0xcf,	 /* ****..****..**** */
	0xf3, 0xcf,	 /* ****..****..**** */
	0xf3, 0xcf,	 /* ****..****..**** */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xE9 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xEA */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0xf0, 0x0f,	 /* ****........**** */
	0xf0, 0x0f,	 /* ****........**** */
	0xf0, 0x0f,	 /* ****........**** */
	0xf0, 0x0f,	 /* ****........**** */
	0xf0, 0x0f,	 /* ****........**** */
	0xf0, 0x0f,	 /* ****........**** */
	0xf0, 0x0f,	 /* ****........**** */
	0xf0, 0x0f,	 /* ****........**** */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x0c, 0x30,	 /* ....**....**.... */
	0x0c, 0x30,	 /* ....**....**.... */
	0xcc, 0x33,	 /* **..**....**..** */
	0xcc, 0x33,	 /* **..**....**..** */
	0xfc, 0x3f,	 /* ******....****** */
	0xfc, 0x3f,	 /* ******....****** */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xEB */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xfc,	 /* ......********.. */
	0x03, 0xfc,	 /* ......********.. */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x0f, 0xfc,	 /* ....**********.. */
	0x0f, 0xfc,	 /* ....**********.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x3c, 0x3c,	 /* ..****....****.. */
	0x0f, 0xf0,	 /* ....********.... */
	0x0f, 0xf0,	 /* ....********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xEC */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0xf3, 0xcf,	 /* ****..****..**** */
	0xf3, 0xcf,	 /* ****..****..**** */
	0xf3, 0xcf,	 /* ****..****..**** */
	0xf3, 0xcf,	 /* ****..****..**** */
	0xf3, 0xcf,	 /* ****..****..**** */
	0xf3, 0xcf,	 /* ****..****..**** */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xED */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x0f,	 /* ............**** */
	0x00, 0x0f,	 /* ............**** */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0xf0, 0xff,	 /* ****....******** */
	0xf0, 0xff,	 /* ****....******** */
	0xf3, 0xcf,	 /* ****..****..**** */
	0xf3, 0xcf,	 /* ****..****..**** */
	0xff, 0x0f,	 /* ********....**** */
	0xff, 0x0f,	 /* ********....**** */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0xf0, 0x00,	 /* ****............ */
	0xf0, 0x00,	 /* ****............ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xEE */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xf0,	 /* ......******.... */
	0x03, 0xf0,	 /* ......******.... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x03, 0xf0,	 /* ......******.... */
	0x03, 0xf0,	 /* ......******.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xEF */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0xf0, 0x3c,	 /* ****......****.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xF0 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xff, 0xfc,	 /* **************.. */
	0xff, 0xfc,	 /* **************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xF1 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xF2 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xF3 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xF4 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0xfc,	 /* ........******.. */
	0x00, 0xfc,	 /* ........******.. */
	0x03, 0xcf,	 /* ......****..**** */
	0x03, 0xcf,	 /* ......****..**** */
	0x03, 0xcf,	 /* ......****..**** */
	0x03, 0xcf,	 /* ......****..**** */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */

	/* 0xF5 */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0x3f, 0x00,	 /* ..******........ */
	0x3f, 0x00,	 /* ..******........ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xF6 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xfc,	 /* ..************.. */
	0x3f, 0xfc,	 /* ..************.. */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xF7 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0x3c,	 /* ..******..****.. */
	0x3f, 0x3c,	 /* ..******..****.. */
	0xf3, 0xf0,	 /* ****..******.... */
	0xf3, 0xf0,	 /* ****..******.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0x3c,	 /* ..******..****.. */
	0x3f, 0x3c,	 /* ..******..****.. */
	0xf3, 0xf0,	 /* ****..******.... */
	0xf3, 0xf0,	 /* ****..******.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xF8 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x0f, 0xc0,	 /* ....******...... */
	0x0f, 0xc0,	 /* ....******...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xF9 */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xFA */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xFB */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x0f,	 /* ............**** */
	0x00, 0x0f,	 /* ............**** */
	0x00, 0x0c,	 /* ............**.. */
	0x00, 0x0c,	 /* ............**.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x3c,	 /* ..........****.. */
	0x00, 0x30,	 /* ..........**.... */
	0x00, 0x30,	 /* ..........**.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xf0,	 /* ........****.... */
	0x00, 0xc0,	 /* ........**...... */
	0x00, 0xc0,	 /* ........**...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0x33, 0x00,	 /* ..**..**........ */
	0x33, 0x00,	 /* ..**..**........ */
	0x3f, 0x00,	 /* ..******........ */
	0x3f, 0x00,	 /* ..******........ */
	0x0c, 0x00,	 /* ....**.......... */
	0x0c, 0x00,	 /* ....**.......... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xFC */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0xf3, 0xc0,	 /* ****..****...... */
	0xf3, 0xc0,	 /* ****..****...... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x3c, 0xf0,	 /* ..****..****.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xFD */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xc0,	 /* ..********...... */
	0x3f, 0xc0,	 /* ..********...... */
	0xf0, 0xf0,	 /* ****....****.... */
	0xf0, 0xf0,	 /* ****....****.... */
	0x03, 0xc0,	 /* ......****...... */
	0x03, 0xc0,	 /* ......****...... */
	0x0f, 0x00,	 /* ....****........ */
	0x0f, 0x00,	 /* ....****........ */
	0x3c, 0x00,	 /* ..****.......... */
	0x3c, 0x00,	 /* ..****.......... */
	0xff, 0xf0,	 /* ************.... */
	0xff, 0xf0,	 /* ************.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */

	/* 0xFE */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x3f, 0xf0,	 /* ..**********.... */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
	0x00, 0x00,	 /* ................ */
};
