/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.regex.Matcher;
import org.eclipse.jetty.rewrite.handler.RegexRule;
import org.eclipse.jetty.util.annotation.Name;

public class HeaderRegexRule
extends RegexRule {
    private String _name;
    private String _value;
    private boolean _add = false;

    public HeaderRegexRule() {
        this(null, null, null);
    }

    public HeaderRegexRule(@Name(value="regex") String regex, @Name(value="name") String name, @Name(value="value") String value2) {
        super(regex);
        this.setHandling(false);
        this.setTerminating(false);
        this.setName(name);
        this.setValue(value2);
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setValue(String value2) {
        this._value = value2;
    }

    public void setAdd(boolean add) {
        this._add = add;
    }

    @Override
    protected String apply(String target, HttpServletRequest request, HttpServletResponse response, Matcher matcher) throws IOException {
        if (this._add) {
            response.addHeader(this._name, this._value);
        } else {
            response.setHeader(this._name, this._value);
        }
        return target;
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public boolean isAdd() {
        return this._add;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this._name + "," + this._value + "]";
    }
}

