/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ColumnFilter;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.SQLServerException;

abstract class IntColumnFilter
extends ColumnFilter {
    IntColumnFilter() {
    }

    abstract int odbcToJDBC(int var1);

    @Override
    final Object apply(Object object, JDBCType jDBCType) throws SQLServerException {
        switch (jDBCType) {
            case INTEGER: {
                return new Integer(this.odbcToJDBC((Integer)object));
            }
            case SMALLINT: 
            case TINYINT: {
                return new Short((short)this.odbcToJDBC(((Short)object).intValue()));
            }
            case BIGINT: {
                return new Long(this.odbcToJDBC(((Long)object).intValue()));
            }
            case CHAR: 
            case VARCHAR: 
            case LONGVARCHAR: {
                return Integer.toString(this.odbcToJDBC(Integer.parseInt((String)object)));
            }
        }
        DataTypes.throwConversionError("int", jDBCType.toString());
        return object;
    }

    @Override
    final byte apply(byte by) throws SQLServerException {
        return (byte)this.odbcToJDBC(by);
    }

    @Override
    final short apply(short s) throws SQLServerException {
        return (short)this.odbcToJDBC(s);
    }

    @Override
    final int apply(int n) throws SQLServerException {
        return this.odbcToJDBC(n);
    }
}

