/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;

public class IntegerBinding
extends TupleBinding {
    private static final int INT_SIZE = 4;

    @Override
    public Object entryToObject(TupleInput tupleInput) {
        return new Integer(tupleInput.readInt());
    }

    @Override
    public void objectToEntry(Object object, TupleOutput tupleOutput) {
        tupleOutput.writeInt(((Number)object).intValue());
    }

    @Override
    protected TupleOutput getTupleOutput(Object object) {
        return IntegerBinding.sizedOutput();
    }

    public static int entryToInt(DatabaseEntry databaseEntry) {
        return IntegerBinding.entryToInput(databaseEntry).readInt();
    }

    public static void intToEntry(int n, DatabaseEntry databaseEntry) {
        IntegerBinding.outputToEntry(IntegerBinding.sizedOutput().writeInt(n), databaseEntry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[4]);
    }
}

