/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.dcsctp4j;

import java.time.Instant;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jitsi.dcsctp4j.DcSctp4j;
import smjni.jnigen.CalledByNative;
import smjni.jnigen.ExposeToNative;

@ExposeToNative
class LogProxy {
    private final long nativePtr;
    private final Logger loggerDelegate = Logger.getLogger(DcSctp4j.class.getName());
    private static LogProxy instance;

    LogProxy() {
        long ptrCopy = this.nativePtr = this.registerNative(LogProxy.getEffectiveLoggingSeverity(this.loggerDelegate));
        DcSctp4j.CLEANER.register(this, () -> LogProxy.destruct(ptrCopy));
    }

    @CalledByNative
    void onLogMessage(String message, String filename, int line, Integer threadId, long timestampUs, LoggingSeverity severity) {
        String formattedMessage;
        if (filename == null && line == 0) {
            formattedMessage = message;
        } else {
            StringBuilder sb = new StringBuilder();
            if (filename != null) {
                sb.append(filename);
            }
            if (line != 0) {
                sb.append("#").append(line);
            }
            sb.append(": ");
            sb.append(message);
            formattedMessage = sb.toString();
        }
        LogRecord record = new LogRecord(severity.level, formattedMessage);
        record.setLoggerName(this.loggerDelegate.getName());
        if (timestampUs != Long.MIN_VALUE) {
            long secs = Math.floorDiv(timestampUs, 1000000L);
            long micros = Math.floorMod(timestampUs, 1000000L);
            Instant instant = Instant.ofEpochSecond(secs, micros * 1000L);
            record.setInstant(instant);
        }
        if (threadId != null) {
            record.setThreadID(threadId);
        }
        this.loggerDelegate.log(record);
    }

    private native long registerNative(LoggingSeverity var1);

    private static native void destruct(long var0);

    static void register() {
        if (instance == null) {
            instance = new LogProxy();
        }
    }

    private static LoggingSeverity getEffectiveLoggingSeverity(Logger logger) {
        LoggingSeverity ret = LoggingSeverity.LS_NONE;
        for (LoggingSeverity l : LoggingSeverity.values()) {
            if (!logger.isLoggable(l.level) || l.level.intValue() >= ret.level.intValue()) continue;
            ret = l;
        }
        return ret;
    }

    @ExposeToNative
    public static enum LoggingSeverity {
        LS_VERBOSE(Level.FINE),
        LS_INFO(Level.INFO),
        LS_WARNING(Level.WARNING),
        LS_ERROR(Level.SEVERE),
        LS_NONE(Level.OFF);

        public final Level level;

        private LoggingSeverity(Level level) {
            this.level = level;
        }

        public static LoggingSeverity fromLevel(Level level) {
            LoggingSeverity ret = LS_NONE;
            for (LoggingSeverity l : LoggingSeverity.values()) {
                if (l.level.intValue() < level.intValue() || l.level.intValue() >= ret.level.intValue()) continue;
                ret = l;
            }
            return ret;
        }
    }
}

