/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.encoder.mqtt5;

import com.hivemq.client.internal.mqtt.codec.encoder.MqttEncoderContext;
import com.hivemq.client.internal.mqtt.codec.encoder.MqttMessageEncoder;
import com.hivemq.client.internal.mqtt.codec.encoder.MqttMessageEncoderUtil;
import com.hivemq.client.internal.mqtt.codec.encoder.mqtt5.Mqtt5MessageEncoderUtil;
import com.hivemq.client.internal.mqtt.codec.encoder.mqtt5.Mqtt5PublishEncoder;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttVariableByteInteger;
import com.hivemq.client.internal.mqtt.message.auth.MqttEnhancedAuth;
import com.hivemq.client.internal.mqtt.message.auth.MqttSimpleAuth;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnectRestrictions;
import com.hivemq.client.internal.mqtt.message.connect.MqttStatefulConnect;
import com.hivemq.client.internal.mqtt.message.publish.MqttWillPublish;
import com.hivemq.client.mqtt.exceptions.MqttEncodeException;
import com.hivemq.client.mqtt.mqtt5.message.Mqtt5MessageType;
import io.netty.buffer.ByteBuf;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@Singleton
public class Mqtt5ConnectEncoder
extends MqttMessageEncoder<MqttStatefulConnect> {
    private static final int FIXED_HEADER = Mqtt5MessageType.CONNECT.getCode() << 4;
    private static final byte PROTOCOL_VERSION = 5;
    private static final int VARIABLE_HEADER_FIXED_LENGTH = 10;
    @NotNull
    private final Mqtt5PublishEncoder publishEncoder;

    @Inject
    Mqtt5ConnectEncoder(@NotNull Mqtt5PublishEncoder publishEncoder) {
        this.publishEncoder = publishEncoder;
    }

    @Override
    @NotNull
    protected ByteBuf encode(@NotNull MqttStatefulConnect message, @NotNull MqttEncoderContext context) {
        int propertyLength = this.propertyLength(message);
        int willPropertyLength = this.willPropertyLength(message);
        int remainingLengthWithoutProperties = this.remainingLengthWithoutProperties(message);
        int remainingLength = this.remainingLength(remainingLengthWithoutProperties, propertyLength, willPropertyLength);
        int encodedLength = MqttMessageEncoderUtil.encodedPacketLength(remainingLength);
        int omittedProperties = 0;
        while (encodedLength > context.getMaximumPacketSize()) {
            if ((propertyLength = this.propertyLength(message, propertyLength, ++omittedProperties)) < 0) {
                throw MqttMessageEncoderUtil.maximumPacketSizeExceeded(message, encodedLength, context.getMaximumPacketSize());
            }
            remainingLength = this.remainingLength(remainingLengthWithoutProperties, propertyLength, willPropertyLength);
            encodedLength = MqttMessageEncoderUtil.encodedPacketLength(remainingLength);
        }
        return this.encode(message, context, encodedLength, remainingLength, propertyLength, willPropertyLength, omittedProperties);
    }

    @NotNull
    private ByteBuf encode(@NotNull MqttStatefulConnect message, @NotNull MqttEncoderContext context, int encodedLength, int remainingLength, int propertyLength, int willPropertyLength, int omittedProperties) {
        ByteBuf out = context.getAllocator().ioBuffer(encodedLength, encodedLength);
        this.encode(message, out, remainingLength, propertyLength, willPropertyLength, omittedProperties);
        return out;
    }

    private int remainingLength(int remainingLengthWithoutProperties, int propertyLength, int willPropertyLength) {
        return remainingLengthWithoutProperties + MqttMessageEncoderUtil.encodedLengthWithHeader(propertyLength) + (willPropertyLength == -1 ? 0 : MqttMessageEncoderUtil.encodedLengthWithHeader(willPropertyLength));
    }

    private int remainingLengthWithoutProperties(@NotNull MqttStatefulConnect message) {
        MqttWillPublish willPublish;
        MqttConnect stateless = (MqttConnect)message.stateless();
        int remainingLength = 10;
        remainingLength += message.getClientIdentifier().encodedLength();
        MqttSimpleAuth simpleAuth = stateless.getRawSimpleAuth();
        if (simpleAuth != null) {
            remainingLength += MqttMessageEncoderUtil.nullableEncodedLength(simpleAuth.getRawUsername());
            remainingLength += MqttMessageEncoderUtil.nullableEncodedLength(simpleAuth.getRawPassword());
        }
        if ((willPublish = stateless.getRawWillPublish()) != null) {
            remainingLength += willPublish.getTopic().encodedLength();
            remainingLength += MqttMessageEncoderUtil.encodedOrEmptyLength(willPublish.getRawPayload());
        }
        return remainingLength;
    }

    private int propertyLength(@NotNull MqttStatefulConnect message) {
        MqttConnect stateless = (MqttConnect)message.stateless();
        int propertyLength = 0;
        propertyLength += Mqtt5MessageEncoderUtil.intPropertyEncodedLength(stateless.getSessionExpiryInterval(), 0L);
        MqttConnectRestrictions restrictions = stateless.getRestrictions();
        if (restrictions != MqttConnectRestrictions.DEFAULT) {
            propertyLength += Mqtt5MessageEncoderUtil.shortPropertyEncodedLength(restrictions.getReceiveMaximum(), 65535);
            propertyLength += Mqtt5MessageEncoderUtil.intPropertyEncodedLength(restrictions.getMaximumPacketSize(), 0x10000004L);
            propertyLength += Mqtt5MessageEncoderUtil.shortPropertyEncodedLength(restrictions.getTopicAliasMaximum(), 0);
            propertyLength += Mqtt5MessageEncoderUtil.booleanPropertyEncodedLength(restrictions.isRequestResponseInformation(), false);
            propertyLength += Mqtt5MessageEncoderUtil.booleanPropertyEncodedLength(restrictions.isRequestProblemInformation(), true);
        }
        propertyLength += message.getUserProperties().encodedLength();
        MqttEnhancedAuth enhancedAuth = message.getEnhancedAuth();
        if (enhancedAuth != null) {
            propertyLength += Mqtt5MessageEncoderUtil.propertyEncodedLength(enhancedAuth.getMethod());
            propertyLength += Mqtt5MessageEncoderUtil.nullablePropertyEncodedLength(enhancedAuth.getRawData());
        }
        return propertyLength;
    }

    private int propertyLength(@NotNull MqttStatefulConnect message, int propertyLength, int omittedProperties) {
        switch (omittedProperties) {
            case 0: {
                return propertyLength;
            }
            case 1: {
                return propertyLength - message.getUserProperties().encodedLength();
            }
        }
        return -1;
    }

    private int willPropertyLength(@NotNull MqttStatefulConnect message) {
        MqttWillPublish willPublish = ((MqttConnect)message.stateless()).getRawWillPublish();
        if (willPublish == null) {
            return -1;
        }
        int willPropertyLength = this.publishEncoder.fixedPropertyLength(willPublish);
        willPropertyLength += ((MqttUserPropertiesImpl)willPublish.getUserProperties()).encodedLength();
        if (!MqttVariableByteInteger.isInRange(willPropertyLength += Mqtt5MessageEncoderUtil.intPropertyEncodedLength(willPublish.getDelayInterval(), 0L))) {
            throw new MqttEncodeException("Will properties exceeded maximum length.");
        }
        return willPropertyLength;
    }

    private void encode(@NotNull MqttStatefulConnect message, @NotNull ByteBuf out, int remainingLength, int propertyLength, int willPropertyLength, int omittedProperties) {
        this.encodeFixedHeader(out, remainingLength);
        this.encodeVariableHeader(message, out, propertyLength, omittedProperties);
        this.encodePayload(message, out, willPropertyLength);
    }

    private void encodeFixedHeader(@NotNull ByteBuf out, int remainingLength) {
        out.writeByte(FIXED_HEADER);
        MqttVariableByteInteger.encode(remainingLength, out);
    }

    private void encodeVariableHeader(@NotNull MqttStatefulConnect message, @NotNull ByteBuf out, int propertyLength, int omittedProperties) {
        MqttWillPublish willPublish;
        MqttConnect stateless = (MqttConnect)message.stateless();
        MqttUtf8StringImpl.PROTOCOL_NAME.encode(out);
        out.writeByte(5);
        int connectFlags = 0;
        MqttSimpleAuth simpleAuth = stateless.getRawSimpleAuth();
        if (simpleAuth != null) {
            if (simpleAuth.getRawUsername() != null) {
                connectFlags |= 0x80;
            }
            if (simpleAuth.getRawPassword() != null) {
                connectFlags |= 0x40;
            }
        }
        if ((willPublish = stateless.getRawWillPublish()) != null) {
            if (willPublish.isRetain()) {
                connectFlags |= 0x20;
            }
            connectFlags |= willPublish.getQos().getCode() << 3;
            connectFlags |= 4;
        }
        if (stateless.isCleanStart()) {
            connectFlags |= 2;
        }
        out.writeByte(connectFlags);
        out.writeShort(stateless.getKeepAlive());
        this.encodeProperties(message, out, propertyLength, omittedProperties);
    }

    private void encodeProperties(@NotNull MqttStatefulConnect message, @NotNull ByteBuf out, int propertyLength, int omittedProperties) {
        MqttConnectRestrictions restrictions;
        MqttConnect stateless = (MqttConnect)message.stateless();
        MqttVariableByteInteger.encode(propertyLength, out);
        Mqtt5MessageEncoderUtil.encodeIntProperty(17, stateless.getSessionExpiryInterval(), 0L, out);
        MqttEnhancedAuth enhancedAuth = message.getEnhancedAuth();
        if (enhancedAuth != null) {
            Mqtt5MessageEncoderUtil.encodeProperty(21, enhancedAuth.getMethod(), out);
            Mqtt5MessageEncoderUtil.encodeNullableProperty(22, enhancedAuth.getRawData(), out);
        }
        if ((restrictions = stateless.getRestrictions()) != MqttConnectRestrictions.DEFAULT) {
            Mqtt5MessageEncoderUtil.encodeShortProperty(33, restrictions.getReceiveMaximum(), 65535, out);
            Mqtt5MessageEncoderUtil.encodeIntProperty(39, restrictions.getMaximumPacketSize(), 0x10000004L, out);
            Mqtt5MessageEncoderUtil.encodeShortProperty(34, restrictions.getTopicAliasMaximum(), 0, out);
            Mqtt5MessageEncoderUtil.encodeBooleanProperty(25, restrictions.isRequestResponseInformation(), false, out);
            Mqtt5MessageEncoderUtil.encodeBooleanProperty(23, restrictions.isRequestProblemInformation(), true, out);
        }
        if (omittedProperties == 0) {
            message.getUserProperties().encode(out);
        }
    }

    private void encodePayload(@NotNull MqttStatefulConnect message, @NotNull ByteBuf out, int willPropertyLength) {
        MqttConnect stateless = (MqttConnect)message.stateless();
        message.getClientIdentifier().encode(out);
        this.encodeWillPublish(stateless, out, willPropertyLength);
        MqttSimpleAuth simpleAuth = stateless.getRawSimpleAuth();
        if (simpleAuth != null) {
            MqttMessageEncoderUtil.encodeNullable(simpleAuth.getRawUsername(), out);
            MqttMessageEncoderUtil.encodeNullable(simpleAuth.getRawPassword(), out);
        }
    }

    private void encodeWillPublish(@NotNull MqttConnect message, @NotNull ByteBuf out, int willPropertyLength) {
        MqttWillPublish willPublish = message.getRawWillPublish();
        if (willPublish != null) {
            MqttVariableByteInteger.encode(willPropertyLength, out);
            this.publishEncoder.encodeFixedProperties(willPublish, out);
            ((MqttUserPropertiesImpl)willPublish.getUserProperties()).encode(out);
            Mqtt5MessageEncoderUtil.encodeIntProperty(24, willPublish.getDelayInterval(), 0L, out);
            willPublish.getTopic().encode(out);
            MqttMessageEncoderUtil.encodeOrEmpty(willPublish.getRawPayload(), out);
        }
    }
}

