/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import javax.sound.sampled.AudioFormat;

public class AuTool {
    public static final int AU_HEADER_MAGIC = 779316836;
    public static final int AUDIO_UNKNOWN_SIZE = -1;
    public static final int DATA_OFFSET = 24;
    public static final int SND_FORMAT_UNSPECIFIED = 0;
    public static final int SND_FORMAT_MULAW_8 = 1;
    public static final int SND_FORMAT_LINEAR_8 = 2;
    public static final int SND_FORMAT_LINEAR_16 = 3;
    public static final int SND_FORMAT_LINEAR_24 = 4;
    public static final int SND_FORMAT_LINEAR_32 = 5;
    public static final int SND_FORMAT_FLOAT = 6;
    public static final int SND_FORMAT_DOUBLE = 7;
    public static final int SND_FORMAT_ADPCM_G721 = 23;
    public static final int SND_FORMAT_ADPCM_G722 = 24;
    public static final int SND_FORMAT_ADPCM_G723_3 = 25;
    public static final int SND_FORMAT_ADPCM_G723_5 = 26;
    public static final int SND_FORMAT_ALAW_8 = 27;

    public static int getFormatCode(AudioFormat format) {
        boolean frameSizeOK;
        AudioFormat.Encoding encoding = format.getEncoding();
        int nSampleSize = format.getSampleSizeInBits();
        boolean bigEndian = format.isBigEndian();
        boolean bl = frameSizeOK = format.getFrameSize() == -1 || format.getChannels() != -1 || format.getFrameSize() == nSampleSize / 8 * format.getChannels();
        if (encoding.equals(AudioFormat.Encoding.ULAW) && nSampleSize == 8 && frameSizeOK) {
            return 1;
        }
        if (encoding.equals(AudioFormat.Encoding.PCM_SIGNED) && frameSizeOK) {
            if (nSampleSize == 8) {
                return 2;
            }
            if (nSampleSize == 16 && bigEndian) {
                return 3;
            }
            if (nSampleSize == 24 && bigEndian) {
                return 4;
            }
            if (nSampleSize == 32 && bigEndian) {
                return 5;
            }
        } else if (encoding.equals(AudioFormat.Encoding.ALAW) && nSampleSize == 8 && frameSizeOK) {
            return 27;
        }
        return 0;
    }
}

