/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.codecache.disk.adapters;

import jadx.api.metadata.ICodeAnnotation;
import jadx.core.dex.nodes.RootNode;
import jadx.gui.utils.codecache.disk.adapters.ClassNodeAdapter;
import jadx.gui.utils.codecache.disk.adapters.DataAdapter;
import jadx.gui.utils.codecache.disk.adapters.FieldNodeAdapter;
import jadx.gui.utils.codecache.disk.adapters.InsnCodeOffsetAdapter;
import jadx.gui.utils.codecache.disk.adapters.MethodNodeAdapter;
import jadx.gui.utils.codecache.disk.adapters.NodeDeclareRefAdapter;
import jadx.gui.utils.codecache.disk.adapters.NodeEndAdapter;
import jadx.gui.utils.codecache.disk.adapters.VarNodeAdapter;
import jadx.gui.utils.codecache.disk.adapters.VarRefAdapter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;

public class CodeAnnotationAdapter
implements DataAdapter<ICodeAnnotation> {
    private final Map<ICodeAnnotation.AnnType, TypeInfo> adaptersByCls;
    private final TypeInfo[] adaptersByTag;

    public CodeAnnotationAdapter(RootNode root) {
        Map<ICodeAnnotation.AnnType, DataAdapter<?>> map = this.registerAdapters(root);
        int size = map.size();
        this.adaptersByCls = new EnumMap<ICodeAnnotation.AnnType, TypeInfo>(ICodeAnnotation.AnnType.class);
        this.adaptersByTag = new TypeInfo[size + 1];
        int tag = 1;
        for (Map.Entry<ICodeAnnotation.AnnType, DataAdapter<?>> entry : map.entrySet()) {
            TypeInfo typeInfo = new TypeInfo(tag, entry.getValue());
            this.adaptersByCls.put(entry.getKey(), typeInfo);
            this.adaptersByTag[tag] = typeInfo;
            ++tag;
        }
    }

    private Map<ICodeAnnotation.AnnType, DataAdapter<?>> registerAdapters(RootNode root) {
        EnumMap map = new EnumMap(ICodeAnnotation.AnnType.class);
        MethodNodeAdapter mthAdapter = new MethodNodeAdapter(root);
        map.put(ICodeAnnotation.AnnType.CLASS, new ClassNodeAdapter(root));
        map.put(ICodeAnnotation.AnnType.FIELD, new FieldNodeAdapter(root));
        map.put(ICodeAnnotation.AnnType.METHOD, mthAdapter);
        map.put(ICodeAnnotation.AnnType.DECLARATION, new NodeDeclareRefAdapter(this));
        map.put(ICodeAnnotation.AnnType.VAR, new VarNodeAdapter(mthAdapter));
        map.put(ICodeAnnotation.AnnType.VAR_REF, VarRefAdapter.INSTANCE);
        map.put(ICodeAnnotation.AnnType.OFFSET, InsnCodeOffsetAdapter.INSTANCE);
        map.put(ICodeAnnotation.AnnType.END, new NodeEndAdapter());
        return map;
    }

    @Override
    public void write(DataOutput out, ICodeAnnotation value) throws IOException {
        if (value == null) {
            out.writeByte(0);
            return;
        }
        TypeInfo typeInfo = this.adaptersByCls.get(value.getAnnType());
        if (typeInfo == null) {
            throw new RuntimeException("Unexpected code annotation type: " + value.getClass().getSimpleName());
        }
        out.writeByte(typeInfo.getTag());
        typeInfo.getAdapter().write(out, value);
    }

    @Override
    public ICodeAnnotation read(DataInput in) throws IOException {
        byte tag = in.readByte();
        if (tag == 0) {
            return null;
        }
        TypeInfo typeInfo = this.adaptersByTag[tag];
        if (typeInfo == null) {
            throw new RuntimeException("Unknown type tag: " + tag);
        }
        return (ICodeAnnotation)typeInfo.getAdapter().read(in);
    }

    private static class TypeInfo {
        private final int tag;
        private final DataAdapter adapter;

        private TypeInfo(int tag, DataAdapter adapter) {
            this.tag = tag;
            this.adapter = adapter;
        }

        public int getTag() {
            return this.tag;
        }

        public DataAdapter getAdapter() {
            return this.adapter;
        }
    }
}

