/*
 * Decompiled with CFR 0.152.
 */
package sun.management.counter.perf;

import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import sun.management.counter.AbstractCounter;
import sun.management.counter.ByteArrayCounter;
import sun.management.counter.Units;
import sun.management.counter.Variability;
import sun.management.counter.perf.ByteArrayCounterSnapshot;

public class PerfByteArrayCounter
extends AbstractCounter
implements ByteArrayCounter {
    ByteBuffer bb;
    private static final long serialVersionUID = 2545474036937279921L;

    PerfByteArrayCounter(String string, Units units, Variability variability, int n, int n2, ByteBuffer byteBuffer) {
        super(string, units, variability, n, n2);
        this.bb = byteBuffer;
    }

    @Override
    public Object getValue() {
        return this.byteArrayValue();
    }

    @Override
    public byte[] byteArrayValue() {
        this.bb.position(0);
        byte[] byArray = new byte[this.bb.limit()];
        this.bb.get(byArray);
        return byArray;
    }

    @Override
    public byte byteAt(int n) {
        this.bb.position(n);
        return this.bb.get();
    }

    @Override
    public String toString() {
        String string = this.getName() + ": " + new String(this.byteArrayValue()) + " " + this.getUnits();
        if (this.isInternal()) {
            return string + " [INTERNAL]";
        }
        return string;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new ByteArrayCounterSnapshot(this.getName(), this.getUnits(), this.getVariability(), this.getFlags(), this.getVectorLength(), this.byteArrayValue());
    }
}

