/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct InputAnalogActionData_t")
public class InputAnalogActionData
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BACTIVE;
    public static final int ACTIVEORIGIN;
    public static final int X;
    public static final int Y;
    public static final int Z;
    public static final int DELTAX;
    public static final int DELTAY;
    public static final int DELTAZ;
    public static final int FUPDATETIME;

    public InputAnalogActionData(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), InputAnalogActionData.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bool")
    public boolean bActive() {
        return InputAnalogActionData.nbActive(this.address());
    }

    @NativeType(value="VRInputValueHandle_t")
    public long activeOrigin() {
        return InputAnalogActionData.nactiveOrigin(this.address());
    }

    public float x() {
        return InputAnalogActionData.nx(this.address());
    }

    public float y() {
        return InputAnalogActionData.ny(this.address());
    }

    public float z() {
        return InputAnalogActionData.nz(this.address());
    }

    public float deltaX() {
        return InputAnalogActionData.ndeltaX(this.address());
    }

    public float deltaY() {
        return InputAnalogActionData.ndeltaY(this.address());
    }

    public float deltaZ() {
        return InputAnalogActionData.ndeltaZ(this.address());
    }

    public float fUpdateTime() {
        return InputAnalogActionData.nfUpdateTime(this.address());
    }

    public static InputAnalogActionData malloc() {
        return (InputAnalogActionData)InputAnalogActionData.wrap(InputAnalogActionData.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static InputAnalogActionData calloc() {
        return (InputAnalogActionData)InputAnalogActionData.wrap(InputAnalogActionData.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static InputAnalogActionData create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (InputAnalogActionData)InputAnalogActionData.wrap(InputAnalogActionData.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static InputAnalogActionData create(long address) {
        return (InputAnalogActionData)InputAnalogActionData.wrap(InputAnalogActionData.class, (long)address);
    }

    @Nullable
    public static InputAnalogActionData createSafe(long address) {
        return address == 0L ? null : (InputAnalogActionData)InputAnalogActionData.wrap(InputAnalogActionData.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)InputAnalogActionData.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)InputAnalogActionData.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)InputAnalogActionData.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = InputAnalogActionData.__create((int)capacity, (int)SIZEOF);
        return (Buffer)InputAnalogActionData.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)InputAnalogActionData.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)InputAnalogActionData.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static InputAnalogActionData mallocStack() {
        return InputAnalogActionData.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static InputAnalogActionData callocStack() {
        return InputAnalogActionData.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static InputAnalogActionData mallocStack(MemoryStack stack) {
        return InputAnalogActionData.malloc(stack);
    }

    @Deprecated
    public static InputAnalogActionData callocStack(MemoryStack stack) {
        return InputAnalogActionData.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return InputAnalogActionData.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return InputAnalogActionData.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return InputAnalogActionData.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return InputAnalogActionData.calloc(capacity, stack);
    }

    public static InputAnalogActionData malloc(MemoryStack stack) {
        return (InputAnalogActionData)InputAnalogActionData.wrap(InputAnalogActionData.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static InputAnalogActionData calloc(MemoryStack stack) {
        return (InputAnalogActionData)InputAnalogActionData.wrap(InputAnalogActionData.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)InputAnalogActionData.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)InputAnalogActionData.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static boolean nbActive(long struct) {
        return UNSAFE.getByte(null, struct + (long)BACTIVE) != 0;
    }

    public static long nactiveOrigin(long struct) {
        return UNSAFE.getLong(null, struct + (long)ACTIVEORIGIN);
    }

    public static float nx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)X);
    }

    public static float ny(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Y);
    }

    public static float nz(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Z);
    }

    public static float ndeltaX(long struct) {
        return UNSAFE.getFloat(null, struct + (long)DELTAX);
    }

    public static float ndeltaY(long struct) {
        return UNSAFE.getFloat(null, struct + (long)DELTAY);
    }

    public static float ndeltaZ(long struct) {
        return UNSAFE.getFloat(null, struct + (long)DELTAZ);
    }

    public static float nfUpdateTime(long struct) {
        return UNSAFE.getFloat(null, struct + (long)FUPDATETIME);
    }

    static {
        Struct.Layout layout = InputAnalogActionData.__struct((Struct.Member[])new Struct.Member[]{InputAnalogActionData.__member((int)1), InputAnalogActionData.__member((int)8), InputAnalogActionData.__member((int)4), InputAnalogActionData.__member((int)4), InputAnalogActionData.__member((int)4), InputAnalogActionData.__member((int)4), InputAnalogActionData.__member((int)4), InputAnalogActionData.__member((int)4), InputAnalogActionData.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BACTIVE = layout.offsetof(0);
        ACTIVEORIGIN = layout.offsetof(1);
        X = layout.offsetof(2);
        Y = layout.offsetof(3);
        Z = layout.offsetof(4);
        DELTAX = layout.offsetof(5);
        DELTAY = layout.offsetof(6);
        DELTAZ = layout.offsetof(7);
        FUPDATETIME = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<InputAnalogActionData, Buffer>
    implements NativeResource {
        private static final InputAnalogActionData ELEMENT_FACTORY = InputAnalogActionData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected InputAnalogActionData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="bool")
        public boolean bActive() {
            return InputAnalogActionData.nbActive(this.address());
        }

        @NativeType(value="VRInputValueHandle_t")
        public long activeOrigin() {
            return InputAnalogActionData.nactiveOrigin(this.address());
        }

        public float x() {
            return InputAnalogActionData.nx(this.address());
        }

        public float y() {
            return InputAnalogActionData.ny(this.address());
        }

        public float z() {
            return InputAnalogActionData.nz(this.address());
        }

        public float deltaX() {
            return InputAnalogActionData.ndeltaX(this.address());
        }

        public float deltaY() {
            return InputAnalogActionData.ndeltaY(this.address());
        }

        public float deltaZ() {
            return InputAnalogActionData.ndeltaZ(this.address());
        }

        public float fUpdateTime() {
            return InputAnalogActionData.nfUpdateTime(this.address());
        }
    }
}

