# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("msvfw32.dll")
prototypes = \
    {
        #
        'VideoForWindowsVersion': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        #
        'ICInfo': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "fccType": SimTypeInt(signed=False, label="UInt32"), "fccHandler": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "dwVersionICM": SimTypeInt(signed=False, label="UInt32"), "szName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 16), "szDescription": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128), "szDriver": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128)}, name="ICINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["fccType", "fccHandler", "lpicinfo"]),
        #
        'ICInstall': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["fccType", "fccHandler", "lParam", "szDesc", "wFlags"]),
        #
        'ICRemove': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["fccType", "fccHandler", "wFlags"]),
        #
        'ICGetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "fccType": SimTypeInt(signed=False, label="UInt32"), "fccHandler": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "dwVersionICM": SimTypeInt(signed=False, label="UInt32"), "szName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 16), "szDescription": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128), "szDriver": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128)}, name="ICINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hic", "picinfo", "cb"]),
        #
        'ICOpen': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["fccType", "fccHandler", "wMode"]),
        #
        'ICOpenFunction': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["fccType", "fccHandler", "wMode", "lpfnHandler"]),
        #
        'ICClose': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hic"]),
        #
        'ICSendMessage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hic", "msg", "dw1", "dw2"]),
        #
        'ICCompress': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hic", "dwFlags", "lpbiOutput", "lpData", "lpbiInput", "lpBits", "lpckid", "lpdwFlags", "lFrameNum", "dwFrameSize", "dwQuality", "lpbiPrev", "lpPrev"]),
        #
        'ICDecompress': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hic", "dwFlags", "lpbiFormat", "lpData", "lpbi", "lpBits"]),
        #
        'ICDrawBegin': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hic", "dwFlags", "hpal", "hwnd", "hdc", "xDst", "yDst", "dxDst", "dyDst", "lpbi", "xSrc", "ySrc", "dxSrc", "dySrc", "dwRate", "dwScale"]),
        #
        'ICDraw': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hic", "dwFlags", "lpFormat", "lpData", "cbData", "lTime"]),
        #
        'ICLocate': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), offset=0), SimTypeShort(signed=False, label="UInt16")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["fccType", "fccHandler", "lpbiIn", "lpbiOut", "wFlags"]),
        #
        'ICGetDisplayFormat': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hic", "lpbiIn", "lpbiOut", "BitDepth", "dx", "dy"]),
        #
        'ICImageCompress': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"bmiHeader": SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), "bmiColors": SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), offset=0)}, name="BITMAPINFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"bmiHeader": SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), "bmiColors": SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), offset=0)}, name="BITMAPINFO", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hic", "uiFlags", "lpbiIn", "lpBits", "lpbiOut", "lQuality", "plSize"]),
        #
        'ICImageDecompress': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"bmiHeader": SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), "bmiColors": SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), offset=0)}, name="BITMAPINFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"bmiHeader": SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), "bmiColors": SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), offset=0)}, name="BITMAPINFO", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hic", "uiFlags", "lpbiIn", "lpBits", "lpbiOut"]),
        #
        'ICCompressorChoose': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=True, label="Int32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "hic": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "fccType": SimTypeInt(signed=False, label="UInt32"), "fccHandler": SimTypeInt(signed=False, label="UInt32"), "lpbiIn": SimTypePointer(SimStruct({"bmiHeader": SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), "bmiColors": SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), offset=0)}, name="BITMAPINFO", pack=False, align=None), offset=0), "lpbiOut": SimTypePointer(SimStruct({"bmiHeader": SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), "bmiColors": SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), offset=0)}, name="BITMAPINFO", pack=False, align=None), offset=0), "lpBitsOut": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lpBitsPrev": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lFrame": SimTypeInt(signed=True, label="Int32"), "lKey": SimTypeInt(signed=True, label="Int32"), "lDataRate": SimTypeInt(signed=True, label="Int32"), "lQ": SimTypeInt(signed=True, label="Int32"), "lKeyCount": SimTypeInt(signed=True, label="Int32"), "lpState": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbState": SimTypeInt(signed=True, label="Int32")}, name="COMPVARS", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "uiFlags", "pvIn", "lpData", "pc", "lpszTitle"]),
        #
        'ICSeqCompressFrameStart': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=True, label="Int32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "hic": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "fccType": SimTypeInt(signed=False, label="UInt32"), "fccHandler": SimTypeInt(signed=False, label="UInt32"), "lpbiIn": SimTypePointer(SimStruct({"bmiHeader": SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), "bmiColors": SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), offset=0)}, name="BITMAPINFO", pack=False, align=None), offset=0), "lpbiOut": SimTypePointer(SimStruct({"bmiHeader": SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), "bmiColors": SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), offset=0)}, name="BITMAPINFO", pack=False, align=None), offset=0), "lpBitsOut": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lpBitsPrev": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lFrame": SimTypeInt(signed=True, label="Int32"), "lKey": SimTypeInt(signed=True, label="Int32"), "lDataRate": SimTypeInt(signed=True, label="Int32"), "lQ": SimTypeInt(signed=True, label="Int32"), "lKeyCount": SimTypeInt(signed=True, label="Int32"), "lpState": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbState": SimTypeInt(signed=True, label="Int32")}, name="COMPVARS", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"bmiHeader": SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), "bmiColors": SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), offset=0)}, name="BITMAPINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pc", "lpbiIn"]),
        #
        'ICSeqCompressFrameEnd': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=True, label="Int32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "hic": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "fccType": SimTypeInt(signed=False, label="UInt32"), "fccHandler": SimTypeInt(signed=False, label="UInt32"), "lpbiIn": SimTypePointer(SimStruct({"bmiHeader": SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), "bmiColors": SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), offset=0)}, name="BITMAPINFO", pack=False, align=None), offset=0), "lpbiOut": SimTypePointer(SimStruct({"bmiHeader": SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), "bmiColors": SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), offset=0)}, name="BITMAPINFO", pack=False, align=None), offset=0), "lpBitsOut": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lpBitsPrev": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lFrame": SimTypeInt(signed=True, label="Int32"), "lKey": SimTypeInt(signed=True, label="Int32"), "lDataRate": SimTypeInt(signed=True, label="Int32"), "lQ": SimTypeInt(signed=True, label="Int32"), "lKeyCount": SimTypeInt(signed=True, label="Int32"), "lpState": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbState": SimTypeInt(signed=True, label="Int32")}, name="COMPVARS", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pc"]),
        #
        'ICSeqCompressFrame': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=True, label="Int32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "hic": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "fccType": SimTypeInt(signed=False, label="UInt32"), "fccHandler": SimTypeInt(signed=False, label="UInt32"), "lpbiIn": SimTypePointer(SimStruct({"bmiHeader": SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), "bmiColors": SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), offset=0)}, name="BITMAPINFO", pack=False, align=None), offset=0), "lpbiOut": SimTypePointer(SimStruct({"bmiHeader": SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), "bmiColors": SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), offset=0)}, name="BITMAPINFO", pack=False, align=None), offset=0), "lpBitsOut": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lpBitsPrev": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lFrame": SimTypeInt(signed=True, label="Int32"), "lKey": SimTypeInt(signed=True, label="Int32"), "lDataRate": SimTypeInt(signed=True, label="Int32"), "lQ": SimTypeInt(signed=True, label="Int32"), "lKeyCount": SimTypeInt(signed=True, label="Int32"), "lpState": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbState": SimTypeInt(signed=True, label="Int32")}, name="COMPVARS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["pc", "uiFlags", "lpBits", "pfKey", "plSize"]),
        #
        'ICCompressorFree': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=True, label="Int32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "hic": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "fccType": SimTypeInt(signed=False, label="UInt32"), "fccHandler": SimTypeInt(signed=False, label="UInt32"), "lpbiIn": SimTypePointer(SimStruct({"bmiHeader": SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), "bmiColors": SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), offset=0)}, name="BITMAPINFO", pack=False, align=None), offset=0), "lpbiOut": SimTypePointer(SimStruct({"bmiHeader": SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), "bmiColors": SimTypePointer(SimStruct({"rgbBlue": SimTypeChar(label="Byte"), "rgbGreen": SimTypeChar(label="Byte"), "rgbRed": SimTypeChar(label="Byte"), "rgbReserved": SimTypeChar(label="Byte")}, name="RGBQUAD", pack=False, align=None), offset=0)}, name="BITMAPINFO", pack=False, align=None), offset=0), "lpBitsOut": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lpBitsPrev": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lFrame": SimTypeInt(signed=True, label="Int32"), "lKey": SimTypeInt(signed=True, label="Int32"), "lDataRate": SimTypeInt(signed=True, label="Int32"), "lQ": SimTypeInt(signed=True, label="Int32"), "lKeyCount": SimTypeInt(signed=True, label="Int32"), "lpState": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbState": SimTypeInt(signed=True, label="Int32")}, name="COMPVARS", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pc"]),
        #
        'DrawDibOpen': SimTypeFunction([], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),
        #
        'DrawDibClose': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdd"]),
        #
        'DrawDibGetBuffer': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hdd", "lpbi", "dwSize", "dwFlags"]),
        #
        'DrawDibGetPalette': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hdd"]),
        #
        'DrawDibSetPalette': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdd", "hpal"]),
        #
        'DrawDibChangePalette': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"peRed": SimTypeChar(label="Byte"), "peGreen": SimTypeChar(label="Byte"), "peBlue": SimTypeChar(label="Byte"), "peFlags": SimTypeChar(label="Byte")}, name="PALETTEENTRY", pack=False, align=None), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdd", "iStart", "iLen", "lppe"]),
        #
        'DrawDibRealize': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hdd", "hdc", "fBackground"]),
        #
        'DrawDibStart': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdd", "rate"]),
        #
        'DrawDibStop': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdd"]),
        #
        'DrawDibBegin': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdd", "hdc", "dxDst", "dyDst", "lpbi", "dxSrc", "dySrc", "wFlags"]),
        #
        'DrawDibDraw': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hdd", "hdc", "xDst", "yDst", "dxDst", "dyDst", "lpbi", "lpBits", "xSrc", "ySrc", "dxSrc", "dySrc", "wFlags"]),
        #
        'DrawDibEnd': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdd"]),
        #
        'DrawDibTime': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"timeCount": SimTypeInt(signed=True, label="Int32"), "timeDraw": SimTypeInt(signed=True, label="Int32"), "timeDecompress": SimTypeInt(signed=True, label="Int32"), "timeDither": SimTypeInt(signed=True, label="Int32"), "timeStretch": SimTypeInt(signed=True, label="Int32"), "timeBlt": SimTypeInt(signed=True, label="Int32"), "timeSetDIBits": SimTypeInt(signed=True, label="Int32")}, name="DRAWDIBTIME", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hdd", "lpddtime"]),
        #
        'DrawDibProfileDisplay': SimTypeFunction([SimTypePointer(SimStruct({"biSize": SimTypeInt(signed=False, label="UInt32"), "biWidth": SimTypeInt(signed=True, label="Int32"), "biHeight": SimTypeInt(signed=True, label="Int32"), "biPlanes": SimTypeShort(signed=False, label="UInt16"), "biBitCount": SimTypeShort(signed=False, label="UInt16"), "biCompression": SimTypeInt(signed=False, label="UInt32"), "biSizeImage": SimTypeInt(signed=False, label="UInt32"), "biXPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biYPelsPerMeter": SimTypeInt(signed=True, label="Int32"), "biClrUsed": SimTypeInt(signed=False, label="UInt32"), "biClrImportant": SimTypeInt(signed=False, label="UInt32")}, name="BITMAPINFOHEADER", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpbi"]),
        #
        'MCIWndCreateA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hwndParent", "hInstance", "dwStyle", "szFile"]),
        #
        'MCIWndCreateW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hwndParent", "hInstance", "dwStyle", "szFile"]),
        #
        'MCIWndRegisterClass': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        #
        'GetOpenFileNamePreviewA': SimTypeFunction([SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpstrFilter": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpstrCustomFilter": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "nMaxCustFilter": SimTypeInt(signed=False, label="UInt32"), "nFilterIndex": SimTypeInt(signed=False, label="UInt32"), "lpstrFile": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "nMaxFile": SimTypeInt(signed=False, label="UInt32"), "lpstrFileTitle": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "nMaxFileTitle": SimTypeInt(signed=False, label="UInt32"), "lpstrInitialDir": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpstrTitle": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Flags": SimTypeInt(signed=False, label="OPEN_FILENAME_FLAGS"), "nFileOffset": SimTypeShort(signed=False, label="UInt16"), "nFileExtension": SimTypeShort(signed=False, label="UInt16"), "lpstrDefExt": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpfnHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpTemplateName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvReserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "FlagsEx": SimTypeInt(signed=False, label="OPEN_FILENAME_FLAGS_EX")}, name="OPENFILENAMEA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpofn"]),
        #
        'GetSaveFileNamePreviewA': SimTypeFunction([SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpstrFilter": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpstrCustomFilter": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "nMaxCustFilter": SimTypeInt(signed=False, label="UInt32"), "nFilterIndex": SimTypeInt(signed=False, label="UInt32"), "lpstrFile": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "nMaxFile": SimTypeInt(signed=False, label="UInt32"), "lpstrFileTitle": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "nMaxFileTitle": SimTypeInt(signed=False, label="UInt32"), "lpstrInitialDir": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpstrTitle": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Flags": SimTypeInt(signed=False, label="OPEN_FILENAME_FLAGS"), "nFileOffset": SimTypeShort(signed=False, label="UInt16"), "nFileExtension": SimTypeShort(signed=False, label="UInt16"), "lpstrDefExt": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpfnHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpTemplateName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvReserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "FlagsEx": SimTypeInt(signed=False, label="OPEN_FILENAME_FLAGS_EX")}, name="OPENFILENAMEA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpofn"]),
        #
        'GetOpenFileNamePreviewW': SimTypeFunction([SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpstrFilter": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpstrCustomFilter": SimTypePointer(SimTypeChar(label="Char"), offset=0), "nMaxCustFilter": SimTypeInt(signed=False, label="UInt32"), "nFilterIndex": SimTypeInt(signed=False, label="UInt32"), "lpstrFile": SimTypePointer(SimTypeChar(label="Char"), offset=0), "nMaxFile": SimTypeInt(signed=False, label="UInt32"), "lpstrFileTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "nMaxFileTitle": SimTypeInt(signed=False, label="UInt32"), "lpstrInitialDir": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpstrTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="OPEN_FILENAME_FLAGS"), "nFileOffset": SimTypeShort(signed=False, label="UInt16"), "nFileExtension": SimTypeShort(signed=False, label="UInt16"), "lpstrDefExt": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpfnHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpTemplateName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pvReserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "FlagsEx": SimTypeInt(signed=False, label="OPEN_FILENAME_FLAGS_EX")}, name="OPENFILENAMEW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpofn"]),
        #
        'GetSaveFileNamePreviewW': SimTypeFunction([SimTypePointer(SimStruct({"lStructSize": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpstrFilter": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpstrCustomFilter": SimTypePointer(SimTypeChar(label="Char"), offset=0), "nMaxCustFilter": SimTypeInt(signed=False, label="UInt32"), "nFilterIndex": SimTypeInt(signed=False, label="UInt32"), "lpstrFile": SimTypePointer(SimTypeChar(label="Char"), offset=0), "nMaxFile": SimTypeInt(signed=False, label="UInt32"), "lpstrFileTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "nMaxFileTitle": SimTypeInt(signed=False, label="UInt32"), "lpstrInitialDir": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpstrTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="OPEN_FILENAME_FLAGS"), "nFileOffset": SimTypeShort(signed=False, label="UInt16"), "nFileExtension": SimTypeShort(signed=False, label="UInt16"), "lpstrDefExt": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpfnHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["param0", "param1", "param2", "param3"]), offset=0), "lpTemplateName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pvReserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwReserved": SimTypeInt(signed=False, label="UInt32"), "FlagsEx": SimTypeInt(signed=False, label="OPEN_FILENAME_FLAGS_EX")}, name="OPENFILENAMEW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpofn"]),
    }

lib.set_prototypes(prototypes)
