/*
 * Decompiled with CFR 0.152.
 */
package liquibase.statement.core;

import java.util.LinkedList;
import java.util.List;
import liquibase.statement.AbstractSqlStatement;
import liquibase.statement.core.DatabaseTableIdentifier;
import liquibase.statement.core.InsertStatement;

public class InsertSetStatement
extends AbstractSqlStatement {
    private final LinkedList<InsertStatement> inserts = new LinkedList();
    private final int batchSize;
    private DatabaseTableIdentifier databaseTableIdentifier = new DatabaseTableIdentifier(null, null, null);

    public InsertSetStatement(String catalogName, String schemaName, String tableName) {
        this(catalogName, schemaName, tableName, 50);
    }

    public InsertSetStatement(String catalogName, String schemaName, String tableName, int batchSize) {
        this.databaseTableIdentifier.setCatalogName(catalogName);
        this.databaseTableIdentifier.setSchemaName(schemaName);
        this.databaseTableIdentifier.setTableName(tableName);
        this.batchSize = batchSize;
    }

    public String getCatalogName() {
        return this.databaseTableIdentifier.getCatalogName();
    }

    public String getSchemaName() {
        return this.databaseTableIdentifier.getSchemaName();
    }

    public String getTableName() {
        return this.databaseTableIdentifier.getTableName();
    }

    public int getBatchThreshold() {
        return this.batchSize;
    }

    public InsertSetStatement addInsertStatement(InsertStatement statement) {
        this.inserts.add(statement);
        return this;
    }

    public InsertStatement peek() {
        return this.inserts.peek();
    }

    public List<InsertStatement> getStatements() {
        return this.inserts;
    }

    public InsertStatement[] getStatementsArray() {
        return this.inserts.toArray(new InsertStatement[0]);
    }
}

