/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hsqldb.Column;
import org.hsqldb.Library;
import org.hsqldb.jdbc.Util;
import org.hsqldb.jdbc.jdbcConnection;
import org.hsqldb.jdbc.jdbcResultSet;
import org.hsqldb.lib.StringUtil;

public class jdbcDatabaseMetaData
implements DatabaseMetaData {
    static final Integer INT_COLUMNS_NO_NULLS = new Integer(0);
    private jdbcConnection connection;
    private boolean useSchemaDefault;
    private static final String BRI_SESSION_SCOPE_IN_LIST = "(2)";
    private static final String BRI_TEMPORARY_SCOPE_IN_LIST = "(0,1,2)";
    private static final String BRI_TRANSACTION_SCOPE_IN_LIST = "(1,2)";
    private static final String selstar = "SELECT * FROM INFORMATION_SCHEMA.";
    private static final String whereTrue = " WHERE 1=1";

    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    public String getUserName() throws SQLException {
        ResultSet resultSet = this.execute("CALL USER()");
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        return string;
    }

    public boolean isReadOnly() throws SQLException {
        ResultSet resultSet = this.execute("CALL \"org.hsqldb.Library.isReadOnlyDatabase\"()");
        resultSet.next();
        boolean bl = resultSet.getBoolean(1);
        resultSet.close();
        return bl;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        ResultSet resultSet = this.execute("call \"org.hsqldb.Library.getDatabaseProductName\"()");
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        return string;
    }

    public String getDatabaseProductVersion() throws SQLException {
        ResultSet resultSet = this.execute("call \"org.hsqldb.Library.getDatabaseProductVersion\"()");
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        return string;
    }

    public String getDriverName() throws SQLException {
        return "HSQL Database Engine Driver";
    }

    public String getDriverVersion() throws SQLException {
        return "1.8.0";
    }

    public int getDriverMajorVersion() {
        return 1;
    }

    public int getDriverMinorVersion() {
        return 8;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        return "BEFORE,BIGINT,BINARY,CACHED,DATETIME,LIMIT,LONGVARBINARY,LONGVARCHAR,OBJECT,OTHER,SAVEPOINT,TEMP,TEXT,TOP,TRIGGER,TINYINT,VARBINARY,VARCHAR_IGNORECASE";
    }

    public String getNumericFunctions() throws SQLException {
        return StringUtil.getList(Library.sNumeric, ",", "");
    }

    public String getStringFunctions() throws SQLException {
        return StringUtil.getList(Library.sString, ",", "");
    }

    public String getSystemFunctions() throws SQLException {
        return StringUtil.getList(Library.sSystem, ",", "");
    }

    public String getTimeDateFunctions() throws SQLException {
        return StringUtil.getList(Library.sTimeDate, ",", "");
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return true;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        return true;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        return "SCHEMA";
    }

    public String getProcedureTerm() throws SQLException {
        return "";
    }

    public String getCatalogTerm() throws SQLException {
        return "";
    }

    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    public String getCatalogSeparator() throws SQLException {
        return "";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 1;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        return n == 1 || n == 2 || n == 4 || n == 8;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return true;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        if (jdbcDatabaseMetaData.wantsIsNull(string3)) {
            return this.executeSelect("SYSTEM_PROCEDURES", "0=1");
        }
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_PROCEDURES").append(jdbcDatabaseMetaData.and("PROCEDURE_CAT", "=", string)).append(jdbcDatabaseMetaData.and("PROCEDURE_SCHEM", "LIKE", string2)).append(jdbcDatabaseMetaData.and("PROCEDURE_NAME", "LIKE", string3));
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (jdbcDatabaseMetaData.wantsIsNull(string3) || jdbcDatabaseMetaData.wantsIsNull(string4)) {
            return this.executeSelect("SYSTEM_PROCEDURECOLUMNS", "0=1");
        }
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_PROCEDURECOLUMNS").append(jdbcDatabaseMetaData.and("PROCEDURE_CAT", "=", string)).append(jdbcDatabaseMetaData.and("PROCEDURE_SCHEM", "LIKE", string2)).append(jdbcDatabaseMetaData.and("PROCEDURE_NAME", "LIKE", string3)).append(jdbcDatabaseMetaData.and("COLUMN_NAME", "LIKE", string4));
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        if (jdbcDatabaseMetaData.wantsIsNull(string3) || stringArray != null && stringArray.length == 0) {
            return this.executeSelect("SYSTEM_TABLES", "0=1");
        }
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_TABLES").append(jdbcDatabaseMetaData.and("TABLE_CAT", "=", string)).append(jdbcDatabaseMetaData.and("TABLE_SCHEM", "LIKE", string2)).append(jdbcDatabaseMetaData.and("TABLE_NAME", "LIKE", string3));
        if (stringArray != null) {
            stringBuffer.append(" AND TABLE_TYPE IN (").append(StringUtil.getList(stringArray, ",", "'")).append(')');
        }
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getSchemas() throws SQLException {
        return this.executeSelect("SYSTEM_SCHEMAS", null);
    }

    public ResultSet getCatalogs() throws SQLException {
        return this.executeSelect("SYSTEM_CATALOGS", null);
    }

    public ResultSet getTableTypes() throws SQLException {
        return this.executeSelect("SYSTEM_TABLETYPES", null);
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (jdbcDatabaseMetaData.wantsIsNull(string3) || jdbcDatabaseMetaData.wantsIsNull(string4)) {
            return this.executeSelect("SYSTEM_COLUMNS", "0=1");
        }
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_COLUMNS").append(jdbcDatabaseMetaData.and("TABLE_CAT", "=", string)).append(jdbcDatabaseMetaData.and("TABLE_SCHEM", "LIKE", string2)).append(jdbcDatabaseMetaData.and("TABLE_NAME", "LIKE", string3)).append(jdbcDatabaseMetaData.and("COLUMN_NAME", "LIKE", string4));
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        if (string3 == null) {
            Util.sqlException(62);
        }
        if (jdbcDatabaseMetaData.wantsIsNull(string4)) {
            return this.executeSelect("SYSTEM_COLUMNPRIVILEGES", "0=1");
        }
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_COLUMNPRIVILEGES").append(jdbcDatabaseMetaData.and("TABLE_CAT", "=", string)).append(jdbcDatabaseMetaData.and("TABLE_SCHEM", "=", string2)).append(jdbcDatabaseMetaData.and("TABLE_NAME", "=", string3)).append(jdbcDatabaseMetaData.and("COLUMN_NAME", "LIKE", string4));
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        if (jdbcDatabaseMetaData.wantsIsNull(string3)) {
            return this.executeSelect("SYSTEM_TABLEPRIVILEGES", "0=1");
        }
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_TABLEPRIVILEGES").append(jdbcDatabaseMetaData.and("TABLE_CAT", "=", string)).append(jdbcDatabaseMetaData.and("TABLE_SCHEM", "LIKE", string2)).append(jdbcDatabaseMetaData.and("TABLE_NAME", "LIKE", string3));
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        String string4;
        switch (n) {
            case 0: {
                string4 = BRI_TEMPORARY_SCOPE_IN_LIST;
                break;
            }
            case 1: {
                string4 = BRI_TRANSACTION_SCOPE_IN_LIST;
                break;
            }
            case 2: {
                string4 = BRI_SESSION_SCOPE_IN_LIST;
                break;
            }
            default: {
                throw Util.sqlException(38, 118, null);
            }
        }
        if (string3 == null) {
            Util.sqlException(62);
        }
        string2 = this.translateSchema(string2);
        Integer n2 = bl ? null : INT_COLUMNS_NO_NULLS;
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_BESTROWIDENTIFIER").append(jdbcDatabaseMetaData.and("TABLE_CAT", "=", string)).append(jdbcDatabaseMetaData.and("TABLE_SCHEM", "=", string2)).append(jdbcDatabaseMetaData.and("TABLE_NAME", "=", string3)).append(jdbcDatabaseMetaData.and("NULLABLE", "=", n2)).append(" AND SCOPE IN " + string4);
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        if (string3 == null) {
            Util.sqlException(62);
        }
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_VERSIONCOLUMNS").append(jdbcDatabaseMetaData.and("TABLE_CAT", "=", string)).append(jdbcDatabaseMetaData.and("TABLE_SCHEM", "=", string2)).append(jdbcDatabaseMetaData.and("TABLE_NAME", "=", string3));
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        if (string3 == null) {
            Util.sqlException(62);
        }
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_PRIMARYKEYS").append(jdbcDatabaseMetaData.and("TABLE_CAT", "=", string)).append(jdbcDatabaseMetaData.and("TABLE_SCHEM", "=", string2)).append(jdbcDatabaseMetaData.and("TABLE_NAME", "=", string3));
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        if (string3 == null) {
            Util.sqlException(62);
        }
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_CROSSREFERENCE").append(jdbcDatabaseMetaData.and("FKTABLE_CAT", "=", string)).append(jdbcDatabaseMetaData.and("FKTABLE_SCHEM", "=", string2)).append(jdbcDatabaseMetaData.and("FKTABLE_NAME", "=", string3)).append(" ORDER BY PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, KEY_SEQ");
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        if (string3 == null) {
            Util.sqlException(62);
        }
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_CROSSREFERENCE").append(jdbcDatabaseMetaData.and("PKTABLE_CAT", "=", string)).append(jdbcDatabaseMetaData.and("PKTABLE_SCHEM", "=", string2)).append(jdbcDatabaseMetaData.and("PKTABLE_NAME", "=", string3));
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        if (string3 == null || string6 == null) {
            Util.sqlException(62);
        }
        string2 = this.translateSchema(string2);
        string5 = this.translateSchema(string5);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_CROSSREFERENCE").append(jdbcDatabaseMetaData.and("PKTABLE_CAT", "=", string)).append(jdbcDatabaseMetaData.and("PKTABLE_SCHEM", "=", string2)).append(jdbcDatabaseMetaData.and("PKTABLE_NAME", "=", string3)).append(jdbcDatabaseMetaData.and("FKTABLE_CAT", "=", string4)).append(jdbcDatabaseMetaData.and("FKTABLE_SCHEM", "=", string5)).append(jdbcDatabaseMetaData.and("FKTABLE_NAME", "=", string6));
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getTypeInfo() throws SQLException {
        return this.executeSelect("SYSTEM_TYPEINFO", null);
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        if (string3 == null) {
            Util.sqlException(62);
        }
        string2 = this.translateSchema(string2);
        Boolean bl3 = bl ? Boolean.FALSE : null;
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_INDEXINFO").append(jdbcDatabaseMetaData.and("TABLE_CAT", "=", string)).append(jdbcDatabaseMetaData.and("TABLE_SCHEM", "=", string2)).append(jdbcDatabaseMetaData.and("TABLE_NAME", "=", string3)).append(jdbcDatabaseMetaData.and("NON_UNIQUE", "=", bl3));
        return this.execute(stringBuffer.toString());
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        return n == 1003 || n == 1004;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        return this.supportsResultSetType(n) && n2 == 1007;
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        if (jdbcDatabaseMetaData.wantsIsNull(string3) || nArray != null && nArray.length == 0) {
            this.executeSelect("SYSTEM_UDTS", "0=1");
        }
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_UDTS").append(jdbcDatabaseMetaData.and("TYPE_CAT", "=", string)).append(jdbcDatabaseMetaData.and("TYPE_SCHEM", "LIKE", string2)).append(jdbcDatabaseMetaData.and("TYPE_NAME", "LIKE", string3));
        if (nArray != null) {
            stringBuffer.append(" AND DATA_TYPE IN (").append(StringUtil.getList(nArray, ",", "'")).append(')');
        }
        return this.execute(stringBuffer.toString());
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        if (jdbcDatabaseMetaData.wantsIsNull(string3)) {
            return this.executeSelect("SYSTEM_SUPERTYPES", "0=1");
        }
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_SUPERTYPES").append(jdbcDatabaseMetaData.and("TYPE_CAT", "=", string)).append(jdbcDatabaseMetaData.and("TYPE_SCHEM", "LIKE", string2)).append(jdbcDatabaseMetaData.and("TYPE_NAME", "LIKE", string3));
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        if (jdbcDatabaseMetaData.wantsIsNull(string3)) {
            return this.executeSelect("SYSTEM_SUPERTABLES", "0=1");
        }
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_SUPERTABLES").append(jdbcDatabaseMetaData.and("TABLE_CAT", "=", string)).append(jdbcDatabaseMetaData.and("TABLE_SCHEM", "LIKE", string2)).append(jdbcDatabaseMetaData.and("TABLE_NAME", "LIKE", string3));
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        if (jdbcDatabaseMetaData.wantsIsNull(string3) || jdbcDatabaseMetaData.wantsIsNull(string4)) {
            return this.executeSelect("SYSTEM_UDTATTRIBUTES", "0=1");
        }
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_UDTATTRIBUTES").append(jdbcDatabaseMetaData.and("TYPE_CAT", "=", string)).append(jdbcDatabaseMetaData.and("TYPE_SCHEM", "LIKE", string2)).append(jdbcDatabaseMetaData.and("TYPE_NAME", "LIKE", string3)).append(jdbcDatabaseMetaData.and("ATTR_NAME", "LIKE", string4));
        return this.execute(stringBuffer.toString());
    }

    public boolean supportsResultSetHoldability(int n) throws SQLException {
        return n == 1;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        ResultSet resultSet = this.execute("call \"org.hsqldb.Library.getDatabaseMajorVersion\"()");
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        return n;
    }

    public int getDatabaseMinorVersion() throws SQLException {
        ResultSet resultSet = this.execute("call \"org.hsqldb.Library.getDatabaseMinorVersion\"()");
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        return n;
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public int getSQLStateType() throws SQLException {
        return 2;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    jdbcDatabaseMetaData(jdbcConnection jdbcConnection2) throws SQLException {
        this.connection = jdbcConnection2;
        this.useSchemaDefault = jdbcConnection2.connProperties.isPropertyTrue("default_schema");
    }

    private static String and(String string, String string2, Object object) {
        if (object == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = object instanceof String;
        if (bl && ((String)object).length() == 0) {
            return stringBuffer.append(" AND ").append(string).append(" IS NULL").toString();
        }
        String string3 = bl ? Column.createSQLString((String)object) : String.valueOf(object);
        stringBuffer.append(" AND ").append(string).append(' ');
        if (bl && "LIKE".equalsIgnoreCase(string2)) {
            if (string3.indexOf(95) < 0 && string3.indexOf(37) < 0) {
                stringBuffer.append("=").append(' ').append(string3);
            } else {
                stringBuffer.append("LIKE").append(' ').append(string3);
                if (string3.indexOf("\\_") >= 0 || string3.indexOf("\\%") >= 0) {
                    stringBuffer.append(" ESCAPE '\\'");
                }
            }
        } else {
            stringBuffer.append(string2).append(' ').append(string3);
        }
        return stringBuffer.toString();
    }

    private ResultSet execute(String string) throws SQLException {
        ResultSet resultSet = this.connection.createStatement(1004, 1007).executeQuery(string);
        ((jdbcResultSet)resultSet).autoClose = true;
        return resultSet;
    }

    private ResultSet executeSelect(String string, String string2) throws SQLException {
        String string3 = selstar + string;
        if (string2 != null) {
            string3 = string3 + " WHERE " + string2;
        }
        return this.execute(string3);
    }

    private StringBuffer toQueryPrefix(String string) {
        StringBuffer stringBuffer = new StringBuffer(255);
        return stringBuffer.append(selstar).append(string).append(whereTrue);
    }

    private static boolean wantsIsNull(String string) {
        return string != null && string.length() == 0;
    }

    private String translateSchema(String string) throws SQLException {
        if (this.useSchemaDefault && string != null && string.length() == 0) {
            ResultSet resultSet = this.executeSelect("SYSTEM_SCHEMAS", "IS_DEFAULT=TRUE");
            if (resultSet.next()) {
                return resultSet.getString(1);
            }
            return string;
        }
        return string;
    }
}

