/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.buildfile;

import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.buildfile.BuildFile;
import io.quarkus.devtools.project.extensions.Extensions;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.utilities.MojoUtils;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.util.PlatformArtifacts;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;

@Deprecated
public class MavenBuildFile
extends BuildFile {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{(.+)}");
    private final AtomicReference<Model> modelRef = new AtomicReference();

    public MavenBuildFile(Path projectDirPath, ExtensionCatalog catalog) {
        super(projectDirPath, catalog);
    }

    @Override
    public void writeToDisk() throws IOException {
        if (this.getModel() == null) {
            return;
        }
        try (ByteArrayOutputStream pomOutputStream = new ByteArrayOutputStream();){
            MojoUtils.write(this.getModel(), pomOutputStream);
            this.writeToProjectFile(BuildTool.MAVEN.getDependenciesFile(), pomOutputStream.toByteArray());
        }
    }

    @Override
    protected boolean importBom(ArtifactCoords coords) {
        if (!"pom".equals(coords.getType())) {
            throw new IllegalArgumentException(String.valueOf(coords) + " is not a POM");
        }
        Model model = this.getModel();
        Dependency d = new Dependency();
        d.setGroupId(coords.getGroupId());
        d.setArtifactId(coords.getArtifactId());
        d.setType(coords.getType());
        d.setScope("import");
        DependencyManagement dependencyManagement = model.getDependencyManagement();
        if (dependencyManagement == null) {
            dependencyManagement = new DependencyManagement();
            model.setDependencyManagement(dependencyManagement);
        }
        if (dependencyManagement.getDependencies().stream().map(this::toResolvedDependency).noneMatch(thisDep -> d.getManagementKey().equals(thisDep.getManagementKey()))) {
            dependencyManagement.addDependency(d);
            return true;
        }
        return false;
    }

    @Override
    protected boolean addDependency(ArtifactCoords coords, boolean managed) {
        Model model = this.getModel();
        Dependency d = new Dependency();
        d.setGroupId(coords.getGroupId());
        d.setArtifactId(coords.getArtifactId());
        if (!managed) {
            d.setVersion(coords.getVersion());
        }
        if (coords.getClassifier() != null && !coords.getClassifier().isEmpty()) {
            d.setClassifier(coords.getClassifier());
        }
        d.setType(coords.getType());
        if ("pom".equals(coords.getType())) {
            d.setScope("import");
            DependencyManagement dependencyManagement = model.getDependencyManagement();
            if (dependencyManagement == null) {
                dependencyManagement = new DependencyManagement();
                model.setDependencyManagement(dependencyManagement);
            }
            if (dependencyManagement.getDependencies().stream().map(this::toResolvedDependency).noneMatch(thisDep -> d.getManagementKey().equals(thisDep.getManagementKey()))) {
                dependencyManagement.addDependency(d);
                return true;
            }
        } else if (model.getDependencies().stream().noneMatch(thisDep -> d.getManagementKey().equals(thisDep.getManagementKey()))) {
            int index = this.getIndexToAddExtension();
            if (index >= 0) {
                model.getDependencies().add(index, d);
            } else {
                model.getDependencies().add(d);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void removeDependency(ArtifactKey key) throws IOException {
        if (this.getModel() != null) {
            this.getModel().getDependencies().removeIf(d -> Objects.equals(Extensions.toKey(d), key));
        }
    }

    @Override
    public List<ArtifactCoords> getDependencies() throws IOException {
        return this.getModel() == null ? Collections.emptyList() : this.getModel().getDependencies().stream().map(Extensions::toCoords).collect(Collectors.toList());
    }

    @Override
    public final Collection<ArtifactCoords> getInstalledPlatforms() throws IOException {
        Model model = this.getModel();
        if (model == null || model.getDependencyManagement() == null) {
            return Collections.emptyList();
        }
        ArrayList<ArtifactCoords> tmp = new ArrayList<ArtifactCoords>(4);
        for (Dependency c : model.getDependencyManagement().getDependencies()) {
            if (!PlatformArtifacts.isCatalogArtifactId((String)c.getArtifactId())) continue;
            tmp.add(ArtifactCoords.pom((String)c.getGroupId(), (String)c.getArtifactId().substring(0, c.getArtifactId().length() - "-quarkus-platform-descriptor".length()), (String)c.getVersion()));
        }
        return tmp;
    }

    @Override
    protected void refreshData() {
        this.modelRef.set(null);
    }

    @Override
    public String getProperty(String propertyName) {
        if (this.getModel() == null) {
            return null;
        }
        return this.getModel().getProperties().getProperty(propertyName);
    }

    @Override
    public BuildTool getBuildTool() {
        return BuildTool.MAVEN;
    }

    private Model getModel() {
        return this.modelRef.updateAndGet(model -> {
            if (model == null) {
                try {
                    return this.initModel();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return model;
        });
    }

    private int getIndexToAddExtension() {
        List dependencies = this.getModel().getDependencies();
        for (int i = 0; i < dependencies.size(); ++i) {
            if (!"test".equals(((Dependency)dependencies.get(i)).getScope())) continue;
            return i;
        }
        return -1;
    }

    private Model initModel() throws IOException {
        if (!this.hasProjectFile(BuildTool.MAVEN.getDependenciesFile())) {
            return null;
        }
        byte[] content = this.readProjectFile(BuildTool.MAVEN.getDependenciesFile());
        return MojoUtils.readPom(new ByteArrayInputStream(content));
    }

    private Dependency toResolvedDependency(Dependency dependency) {
        String resolvedGroupId = this.toResolvedProperty(dependency.getGroupId());
        String resolvedArtifactId = this.toResolvedProperty(dependency.getArtifactId());
        String resolvedVersion = this.toResolvedProperty(dependency.getVersion());
        if (!(resolvedGroupId.equals(dependency.getGroupId()) && resolvedArtifactId.equals(dependency.getArtifactId()) && resolvedVersion.equals(dependency.getVersion()))) {
            Dependency newDep = dependency.clone();
            newDep.setGroupId(resolvedGroupId);
            newDep.setArtifactId(resolvedArtifactId);
            newDep.setVersion(resolvedVersion);
            return newDep;
        }
        return dependency;
    }

    private String toResolvedProperty(String value) {
        Matcher matcher = PROPERTY_PATTERN.matcher(value);
        if (matcher.matches()) {
            String property = this.getProperty(matcher.group(1));
            return property == null ? value : property;
        }
        return value;
    }
}

