untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEhRKa5FigUv6AatIyXYO6cfuazpsE+KM50R2dY83u9KmvQtolOIt1D6su0FhJDkX8k35uMfzVzQF58L8pt9BDwM=

OpenBSD 6.1 errata 018, August 3, 2017:

An alignment issue in recv() may result in an info leak via ktrace().

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 018_recv.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/uipc_syscalls.c
===================================================================
RCS file: /cvs/src/sys/kern/uipc_syscalls.c,v
diff -u -p -u -r1.151 -r1.151.4.2
--- sys/kern/uipc_syscalls.c	27 Mar 2017 11:45:49 -0000	1.151
+++ sys/kern/uipc_syscalls.c	1 Aug 2017 22:21:24 -0000	1.151.4.2
@@ -879,16 +879,16 @@ recvit(struct proc *p, int s, struct msg
 					i = len;
 				}
 				error = copyout(mtod(m, caddr_t), cp, i);
+#ifdef KTRACE
+				if (KTRPOINT(p, KTR_STRUCT) && error == 0 && i)
+					ktrcmsghdr(p, mtod(m, char *), i);
+#endif
 				if (m->m_next)
 					i = ALIGN(i);
 				cp += i;
 				len -= i;
 				if (error != 0 || len <= 0)
 					break;
-#ifdef KTRACE
-				if (KTRPOINT(p, KTR_STRUCT) && i)
-					ktrcmsghdr(p, mtod(m, char *), i);
-#endif
 			} while ((m = m->m_next) != NULL);
 			len = cp - (caddr_t)mp->msg_control;
 		}
