untrusted comment: verify with openbsd-70-base.pub
RWR3KL+gSr4QZ9HyBn3ccVcTvN36lmVKITCNjip3NEH8ntCAcTPnGJN7/lPdWcl1oft1Fs208eeNBmcSomsaV7T2yeGoP1CRyQ4=

OpenBSD 7.0 errata 008, December 16, 2021:

If multicast routing is used, kernel memory is leaked to userland.

Apply by doing:
    signify -Vep /etc/signify/openbsd-70-base.pub -x 008_mrt.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/netinet/ip_mroute.c
===================================================================
RCS file: /cvs/src/sys/netinet/ip_mroute.c,v
diff -u -p -r1.130 ip_mroute.c
--- sys/netinet/ip_mroute.c	27 May 2020 11:19:29 -0000	1.130
+++ sys/netinet/ip_mroute.c	15 Dec 2021 17:39:21 -0000
@@ -353,6 +353,7 @@ mrt_sysctl_vif(void *oldp, size_t *oldle
 
 	given = *oldlenp;
 	needed = 0;
+	memset(&vinfo, 0, sizeof vinfo);
 	TAILQ_FOREACH(ifp, &ifnet, if_list) {
 		if ((vifp = (struct vif *)ifp->if_mcast) == NULL)
 			continue;
Index: sys/netinet6/ip6_mroute.c
===================================================================
RCS file: /cvs/src/sys/netinet6/ip6_mroute.c,v
diff -u -p -r1.126 ip6_mroute.c
--- sys/netinet6/ip6_mroute.c	10 Mar 2021 10:21:49 -0000	1.126
+++ sys/netinet6/ip6_mroute.c	15 Dec 2021 17:39:21 -0000
@@ -330,6 +330,7 @@ mrt6_sysctl_mif(void *oldp, size_t *oldl
 
 	given = *oldlenp;
 	needed = 0;
+	memset(&minfo, 0, sizeof minfo);
 	TAILQ_FOREACH(ifp, &ifnet, if_list) {
 		if ((mifp = (struct mif6 *)ifp->if_mcast6) == NULL)
 			continue;
