untrusted comment: verify with openbsd-72-base.pub
RWQTKNnK3CZZ8PYAFJuzpHnmKoR8Y+HmK0LK9Szd+EHxT5DcpcYibOotzMETJn4FWMrIBP8jruk+qf2m9++QeFBRmzZfRX3AoAg=

OpenBSD 7.2 errata 011, December 14, 2022: 

TLB entries were not invalidated for all types of engine on
12th generation Intel graphics (Tiger Lake, Rocket Lake, Alder Lake).

Apply by doing: 
    signify -Vep /etc/signify/openbsd-72-base.pub -x 011_gpuinv.patch.sig \
        -m - | (cd /usr/src && patch -p0) 

And then rebuild and install a new kernel: 
    KK=`sysctl -n kern.osversion | cut -d# -f1` 
    cd /usr/src/sys/arch/`machine`/compile/$KK 
    make obj 
    make config 
    make 
    make install

Index: sys/dev/pci/drm/i915/gt/intel_gt.c
===================================================================
RCS file: /cvs/src/sys/dev/pci/drm/i915/gt/intel_gt.c,v
diff -u -p -r1.7 intel_gt.c
--- sys/dev/pci/drm/i915/gt/intel_gt.c	5 Sep 2022 14:06:39 -0000	1.7
+++ sys/dev/pci/drm/i915/gt/intel_gt.c	11 Dec 2022 07:20:30 -0000
@@ -986,6 +986,10 @@ void intel_gt_invalidate_tlbs(struct int
 		if (!i915_mmio_reg_offset(rb.reg))
 			continue;
 
+		if (GRAPHICS_VER(i915) == 12 && (engine->class == VIDEO_DECODE_CLASS ||
+		    engine->class == VIDEO_ENHANCEMENT_CLASS))
+			rb.bit = _MASKED_BIT_ENABLE(rb.bit);
+
 		intel_uncore_write_fw(uncore, rb.reg, rb.bit);
 	}
 
