untrusted comment: verify with openbsd-75-base.pub
RWRGj1pRpprAfsncmkHqXJApaYJMPP6ypAGDQga4nji/DTl7JQTtN/xLe6txjJw6KSLSluXOFQ5+iJ8pYzV74kEyiNY+6hRxDAc=

OpenBSD 7.5 errata 005, August 2, 2024:

sndiod(8) main process could crash due to buffer overread.

Apply by doing:
    signify -Vep /etc/signify/openbsd-75-base.pub -x 005_sndiod.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install sndiod:
    cd /usr/src/usr.bin/sndiod
    make obj
    make
    make install

Index: usr.bin/sndiod/sock.c
===================================================================
RCS file: /cvs/src/usr.bin/sndiod/sock.c,v
diff -u -p -r1.47 sock.c
--- usr.bin/sndiod/sock.c	26 Dec 2022 19:16:03 -0000	1.47
+++ usr.bin/sndiod/sock.c	31 Jul 2024 11:59:43 -0000
@@ -988,7 +988,7 @@ sock_execmsg(struct sock *f)
 	struct slot *s = f->slot;
 	struct amsg *m = &f->rmsg;
 	unsigned char *data;
-	int size, ctl;
+	unsigned int size, ctl;
 
 	switch (ntohl(m->cmd)) {
 	case AMSG_DATA:
@@ -1020,7 +1020,7 @@ sock_execmsg(struct sock *f)
 			return 0;
 		}
 		size = ntohl(m->u.data.size);
-		if (size <= 0) {
+		if (size == 0) {
 #ifdef DEBUG
 			if (log_level >= 1) {
 				sock_log(f);
