/* gnome-sudoku.c generated by valac 0.27.1.15-b1df0, the Vala compiler
 * generated from gnome-sudoku.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "libsudoku.h"
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <gee.h>


#define TYPE_SUDOKU (sudoku_get_type ())
#define SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU, Sudoku))
#define SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU, SudokuClass))
#define IS_SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU))
#define IS_SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU))
#define SUDOKU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU, SudokuClass))

typedef struct _Sudoku Sudoku;
typedef struct _SudokuClass SudokuClass;
typedef struct _SudokuPrivate SudokuPrivate;

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;

#define TYPE_SUDOKU_PRINTER (sudoku_printer_get_type ())
#define SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinter))
#define SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))
#define IS_SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINTER))
#define IS_SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINTER))
#define SUDOKU_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))

typedef struct _SudokuPrinter SudokuPrinter;
typedef struct _SudokuPrinterClass SudokuPrinterClass;

#define TYPE_PRINT_DIALOG (print_dialog_get_type ())
#define PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_DIALOG, PrintDialog))
#define PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_DIALOG, PrintDialogClass))
#define IS_PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_DIALOG))
#define IS_PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_DIALOG))
#define PRINT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_DIALOG, PrintDialogClass))

typedef struct _PrintDialog PrintDialog;
typedef struct _PrintDialogClass PrintDialogClass;
typedef struct _Block3Data Block3Data;

struct _Sudoku {
	GtkApplication parent_instance;
	SudokuPrivate * priv;
};

struct _SudokuClass {
	GtkApplicationClass parent_class;
};

struct _SudokuPrivate {
	GSettings* settings;
	gboolean is_maximized;
	gboolean is_tiled;
	gint window_width;
	gint window_height;
	GtkApplicationWindow* window;
	SudokuGame* game;
	SudokuView* view;
	GtkHeaderBar* headerbar;
	GtkStack* main_stack;
	GtkBox* game_box;
	GtkBox* undo_redo_box;
	GtkButton* back_button;
	SudokuSaver* saver;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
	GSimpleAction* clear_action;
	GSimpleAction* print_action;
	GSimpleAction* print_multiple_action;
	gboolean show_possibilities;
	gchar* desktop;
};

struct _Block1Data {
	int _ref_count_;
	Sudoku* self;
	GtkMessageDialog* dialog;
};

struct _Block2Data {
	int _ref_count_;
	Sudoku* self;
	GtkMessageDialog* dialog;
};

struct _Block3Data {
	int _ref_count_;
	Sudoku* self;
	PrintDialog* print_dialog;
};


static gpointer sudoku_parent_class = NULL;

GType sudoku_get_type (void) G_GNUC_CONST;
GType sudoku_view_get_type (void) G_GNUC_CONST;
#define SUDOKU_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU, SudokuPrivate))
enum  {
	SUDOKU_DUMMY_PROPERTY
};
static void sudoku_new_game_cb (Sudoku* self);
static void _sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_start_game_cb (Sudoku* self, GSimpleAction* action, GVariant* difficulty);
static void _sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_reset_cb (Sudoku* self);
static void _sudoku_reset_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_back_cb (Sudoku* self);
static void _sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_undo_cb (Sudoku* self);
static void _sudoku_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_redo_cb (Sudoku* self);
static void _sudoku_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_print_cb (Sudoku* self);
static void _sudoku_print_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_print_multiple_cb (Sudoku* self);
static void _sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_help_cb (Sudoku* self);
static void _sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_about_cb (Sudoku* self);
static void _sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Sudoku* sudoku_new (void);
Sudoku* sudoku_construct (GType object_type);
static gint sudoku_real_handle_local_options (GApplication* base, GVariantDict* options);
static gboolean sudoku_is_desktop (Sudoku* self, const gchar* name);
static void sudoku_real_startup (GApplication* base);
static void __lambda21_ (Sudoku* self);
void sudoku_view_set_show_warnings (SudokuView* self, gboolean value);
static void ___lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda22_ (Sudoku* self);
void sudoku_view_set_highlighter (SudokuView* self, gboolean value);
static void ___lambda22__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void sudoku_size_allocate_cb (Sudoku* self, GtkAllocation* allocation);
static void _sudoku_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean sudoku_window_state_event_cb (Sudoku* self, GdkEventWindowState* event);
static gboolean _sudoku_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void sudoku_start_game (Sudoku* self, SudokuBoard* board);
static void sudoku_show_new_game_screen (Sudoku* self);
static void sudoku_real_activate (GApplication* base);
static void sudoku_real_shutdown (GApplication* base);
SudokuView* sudoku_view_new (SudokuGame* game);
SudokuView* sudoku_view_construct (GType object_type, SudokuGame* game);
void sudoku_view_set_show_possibilities (SudokuView* self, gboolean value);
static void __lambda14_ (Sudoku* self);
static void ___lambda14__sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self);
static void __lambda15_ (Sudoku* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda16_ (Block1Data* _data1_, gint response_id);
static void ___lambda16__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void ___lambda15__sudoku_board_completed (SudokuBoard* _sender, gpointer self);
static void __lambda13_ (Sudoku* self, GObject* obj, GAsyncResult* res);
static void ___lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda17_ (Block2Data* _data2_, gint response_id);
void sudoku_view_clear (SudokuView* self);
static void ___lambda17__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
GType sudoku_printer_get_type (void) G_GNUC_CONST;
SudokuPrinter* sudoku_printer_new (GeeList* boards, GtkWindow* window);
SudokuPrinter* sudoku_printer_construct (GType object_type, GeeList* boards, GtkWindow* window);
GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self);
GType print_dialog_get_type (void) G_GNUC_CONST;
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
PrintDialog* print_dialog_new (SudokuSaver* saver, GtkWindow* window);
PrintDialog* print_dialog_construct (GType object_type, SudokuSaver* saver, GtkWindow* window);
static void __lambda20_ (Block3Data* _data3_);
static void ___lambda20__print_dialog_finished (PrintDialog* _sender, gpointer self);
gint sudoku_main (gchar** args, int args_length1);
static void sudoku_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GActionEntry SUDOKU_action_entries[11] = {{"new-game", _sudoku_new_game_cb_gsimple_action_activate_callback}, {"start-game", _sudoku_start_game_cb_gsimple_action_activate_callback, "i"}, {"reset", _sudoku_reset_cb_gsimple_action_activate_callback}, {"back", _sudoku_back_cb_gsimple_action_activate_callback}, {"undo", _sudoku_undo_cb_gsimple_action_activate_callback}, {"redo", _sudoku_redo_cb_gsimple_action_activate_callback}, {"print", _sudoku_print_cb_gsimple_action_activate_callback}, {"print-multiple", _sudoku_print_multiple_cb_gsimple_action_activate_callback}, {"help", _sudoku_help_cb_gsimple_action_activate_callback}, {"about", _sudoku_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};
static const GOptionEntry SUDOKU_option_entries[3] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Show release version", NULL}, {"show-possible-values", 's', 0, G_OPTION_ARG_NONE, NULL, "Show the possible values for each cell", NULL}, {NULL}};
static const gchar* SUDOKU_authors[6] = {"Robert Ancell <robert.ancell@gmail.com>", "Christopher Baines <cbaines8@gmail.com>", "Thomas M. Hinkle <Thomas_Hinkle@alumni.brown.edu>", "Parin Porecha <parinporecha@gmail.com>", "John Stowers <john.stowers@gmail.com>", NULL};

static void _sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_new_game_cb ((Sudoku*) self);
#line 230 "gnome-sudoku.c"
}


static void _sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_start_game_cb ((Sudoku*) self, action, parameter);
#line 237 "gnome-sudoku.c"
}


static void _sudoku_reset_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_reset_cb ((Sudoku*) self);
#line 244 "gnome-sudoku.c"
}


static void _sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_back_cb ((Sudoku*) self);
#line 251 "gnome-sudoku.c"
}


static void _sudoku_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_undo_cb ((Sudoku*) self);
#line 258 "gnome-sudoku.c"
}


static void _sudoku_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_redo_cb ((Sudoku*) self);
#line 265 "gnome-sudoku.c"
}


static void _sudoku_print_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_print_cb ((Sudoku*) self);
#line 272 "gnome-sudoku.c"
}


static void _sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_print_multiple_cb ((Sudoku*) self);
#line 279 "gnome-sudoku.c"
}


static void _sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_help_cb ((Sudoku*) self);
#line 286 "gnome-sudoku.c"
}


static void _sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_about_cb ((Sudoku*) self);
#line 293 "gnome-sudoku.c"
}


static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_application_quit ((GApplication*) self);
#line 300 "gnome-sudoku.c"
}


Sudoku* sudoku_construct (GType object_type) {
	Sudoku * self = NULL;
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	setlocale (LC_ALL, "");
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	textdomain (GETTEXT_PACKAGE);
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) g_object_new (object_type, "application-id", "org.gnome.sudoku", "flags", G_APPLICATION_FLAGS_NONE, NULL);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_application_add_main_option_entries ((GApplication*) self, SUDOKU_option_entries);
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return self;
#line 320 "gnome-sudoku.c"
}


Sudoku* sudoku_new (void) {
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return sudoku_construct (TYPE_SUDOKU);
#line 327 "gnome-sudoku.c"
}


static gint sudoku_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Sudoku * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GVariantDict* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = options;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp1_) {
#line 348 "gnome-sudoku.c"
		FILE* _tmp2_ = NULL;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = stderr;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		fprintf (_tmp2_, "gnome-sudoku %s\n", VERSION);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		result = EXIT_SUCCESS;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return result;
#line 358 "gnome-sudoku.c"
	}
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = options;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = g_variant_dict_contains (_tmp3_, "show-possible-values");
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp4_) {
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->show_possibilities = TRUE;
#line 368 "gnome-sudoku.c"
	}
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = -1;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 374 "gnome-sudoku.c"
}


static gboolean sudoku_is_desktop (Sudoku* self, const gchar* name) {
	gboolean result = FALSE;
	gchar* desktop_name_list = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = g_getenv ("XDG_CURRENT_DESKTOP");
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	desktop_name_list = _tmp1_;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = desktop_name_list;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp2_ == NULL) {
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		result = FALSE;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (desktop_name_list);
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return result;
#line 407 "gnome-sudoku.c"
	}
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = desktop_name_list;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ":", 0);
#line 413 "gnome-sudoku.c"
	{
		gchar** n_collection = NULL;
		gint n_collection_length1 = 0;
		gint _n_collection_size_ = 0;
		gint n_it = 0;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		n_collection = _tmp5_;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		n_collection_length1 = _vala_array_length (_tmp4_);
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		for (n_it = 0; n_it < _vala_array_length (_tmp4_); n_it = n_it + 1) {
#line 425 "gnome-sudoku.c"
			gchar* _tmp6_ = NULL;
			gchar* n = NULL;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp6_ = g_strdup (n_collection[n_it]);
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			n = _tmp6_;
#line 432 "gnome-sudoku.c"
			{
				const gchar* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp7_ = n;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp8_ = name;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				if (g_strcmp0 (_tmp7_, _tmp8_) == 0) {
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					result = TRUE;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					_g_free0 (n);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					n_collection = (_vala_array_free (n_collection, n_collection_length1, (GDestroyNotify) g_free), NULL);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					_g_free0 (desktop_name_list);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					return result;
#line 452 "gnome-sudoku.c"
				}
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_g_free0 (n);
#line 456 "gnome-sudoku.c"
			}
		}
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		n_collection = (_vala_array_free (n_collection, n_collection_length1, (GDestroyNotify) g_free), NULL);
#line 461 "gnome-sudoku.c"
	}
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = FALSE;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (desktop_name_list);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 469 "gnome-sudoku.c"
}


static void __lambda21_ (Sudoku* self) {
	SudokuView* _tmp0_ = NULL;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->view;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ != NULL) {
#line 479 "gnome-sudoku.c"
		SudokuView* _tmp1_ = NULL;
		GSettings* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = self->priv->view;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->settings;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = g_settings_get_boolean (_tmp2_, "show-warnings");
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_view_set_show_warnings (_tmp1_, _tmp3_);
#line 491 "gnome-sudoku.c"
	}
}


static void ___lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda21_ ((Sudoku*) self);
#line 499 "gnome-sudoku.c"
}


static void __lambda22_ (Sudoku* self) {
	SudokuView* _tmp0_ = NULL;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->view;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ != NULL) {
#line 509 "gnome-sudoku.c"
		SudokuView* _tmp1_ = NULL;
		GSettings* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = self->priv->view;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->settings;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = g_settings_get_boolean (_tmp2_, "highlighter");
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_view_set_highlighter (_tmp1_, _tmp3_);
#line 521 "gnome-sudoku.c"
	}
}


static void ___lambda22__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda22_ ((Sudoku*) self);
#line 529 "gnome-sudoku.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return self ? g_object_ref (self) : NULL;
#line 536 "gnome-sudoku.c"
}


static void _sudoku_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_size_allocate_cb ((Sudoku*) self, allocation);
#line 543 "gnome-sudoku.c"
}


static gboolean _sudoku_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = sudoku_window_state_event_cb ((Sudoku*) self, event);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 552 "gnome-sudoku.c"
}


static void sudoku_real_startup (GApplication* base) {
	Sudoku * self;
	GSettings* _tmp0_ = NULL;
	GAction* action = NULL;
	GSettings* _tmp1_ = NULL;
	GAction* _tmp2_ = NULL;
	GAction* _tmp3_ = NULL;
	GAction* _tmp4_ = NULL;
	GAction* highlighter_action = NULL;
	GSettings* _tmp5_ = NULL;
	GAction* _tmp6_ = NULL;
	GAction* _tmp7_ = NULL;
	GAction* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gchar* _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gchar** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gchar* _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gchar* _tmp21_ = NULL;
	gchar** _tmp22_ = NULL;
	gchar** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	gchar* _tmp24_ = NULL;
	gchar** _tmp25_ = NULL;
	gchar** _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	gchar* _tmp27_ = NULL;
	gchar** _tmp28_ = NULL;
	gchar** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp30_ = NULL;
	GtkCssProvider* _tmp31_ = NULL;
	GdkScreen* _tmp32_ = NULL;
	GtkCssProvider* _tmp33_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp34_ = NULL;
	GtkBuilder* _tmp35_ = NULL;
	GObject* _tmp36_ = NULL;
	GtkApplicationWindow* _tmp37_ = NULL;
	GtkApplicationWindow* _tmp38_ = NULL;
	GtkApplicationWindow* _tmp39_ = NULL;
	GtkApplicationWindow* _tmp40_ = NULL;
	GSettings* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	GSettings* _tmp43_ = NULL;
	gint _tmp44_ = 0;
	GSettings* _tmp45_ = NULL;
	gboolean _tmp46_ = FALSE;
	GtkApplicationWindow* _tmp48_ = NULL;
	GtkBuilder* _tmp49_ = NULL;
	GObject* _tmp50_ = NULL;
	GtkHeaderBar* _tmp51_ = NULL;
	GtkBuilder* _tmp52_ = NULL;
	GObject* _tmp53_ = NULL;
	GtkStack* _tmp54_ = NULL;
	GtkBuilder* _tmp55_ = NULL;
	GObject* _tmp56_ = NULL;
	GtkBox* _tmp57_ = NULL;
	GtkBuilder* _tmp58_ = NULL;
	GObject* _tmp59_ = NULL;
	GtkBox* _tmp60_ = NULL;
	GtkBuilder* _tmp61_ = NULL;
	GObject* _tmp62_ = NULL;
	GtkButton* _tmp63_ = NULL;
	GAction* _tmp64_ = NULL;
	GSimpleAction* _tmp65_ = NULL;
	GAction* _tmp66_ = NULL;
	GSimpleAction* _tmp67_ = NULL;
	GAction* _tmp68_ = NULL;
	GSimpleAction* _tmp69_ = NULL;
	GAction* _tmp70_ = NULL;
	GSimpleAction* _tmp71_ = NULL;
	GAction* _tmp72_ = NULL;
	GSimpleAction* _tmp73_ = NULL;
	gboolean _tmp74_ = FALSE;
	SudokuSaver* _tmp83_ = NULL;
	SudokuGame* savegame = NULL;
	SudokuSaver* _tmp84_ = NULL;
	SudokuGame* _tmp85_ = NULL;
	SudokuGame* _tmp86_ = NULL;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_APPLICATION_CLASS (sudoku_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_action_map_add_action_entries ((GActionMap*) self, SUDOKU_action_entries, G_N_ELEMENTS (SUDOKU_action_entries), self);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = g_settings_new ("org.gnome.sudoku");
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->settings);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->settings = _tmp0_;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->settings;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = g_settings_create_action (_tmp1_, "show-warnings");
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	action = _tmp2_;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = action;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GObject*) _tmp3_, "notify::state", (GCallback) ___lambda21__g_object_notify, self, 0);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = action;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp4_);
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = self->priv->settings;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = g_settings_create_action (_tmp5_, "highlighter");
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	highlighter_action = _tmp6_;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = highlighter_action;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GObject*) _tmp7_, "notify::state", (GCallback) ___lambda22__g_object_notify, self, 0);
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = highlighter_action;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp8_);
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = g_strdup ("<Primary>n");
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_ = g_new0 (gchar*, 1 + 1);
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_[0] = _tmp9_;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = _tmp10_;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11__length1 = 1;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-game", _tmp11_);
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp12_ = g_strdup ("<Primary>p");
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_ = g_new0 (gchar*, 1 + 1);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_[0] = _tmp12_;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = _tmp13_;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14__length1 = 1;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.print", _tmp14_);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = g_strdup ("<Primary>q");
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp16_ = g_new0 (gchar*, 1 + 1);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp16_[0] = _tmp15_;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = _tmp16_;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17__length1 = 1;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp17_);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp18_ = g_strdup ("<Primary>r");
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_ = g_new0 (gchar*, 1 + 1);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_[0] = _tmp18_;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = _tmp19_;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20__length1 = 1;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.reset", _tmp20_);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp21_ = g_strdup ("<Primary>z");
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = g_new0 (gchar*, 1 + 1);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_[0] = _tmp21_;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = _tmp22_;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23__length1 = 1;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.undo", _tmp23_);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = g_strdup ("<Primary><Shift>z");
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_ = g_new0 (gchar*, 1 + 1);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_[0] = _tmp24_;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26_ = _tmp25_;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26__length1 = 1;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.redo", _tmp26_);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp27_ = g_strdup ("F1");
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp28_ = g_new0 (gchar*, 1 + 1);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp28_[0] = _tmp27_;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29_ = _tmp28_;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29__length1 = 1;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp29_);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29_ = (_vala_array_free (_tmp29_, _tmp29__length1, (GDestroyNotify) g_free), NULL);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_set_default_icon_name ("gnome-sudoku");
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp30_ = gtk_css_provider_new ();
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	css_provider = _tmp30_;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp31_ = css_provider;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_css_provider_load_from_resource (_tmp31_, "/org/gnome/sudoku/ui/gnome-sudoku.css");
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp32_ = gdk_screen_get_default ();
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp33_ = css_provider;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_style_context_add_provider_for_screen (_tmp32_, (GtkStyleProvider*) _tmp33_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp34_ = gtk_builder_new_from_resource ("/org/gnome/sudoku/ui/gnome-sudoku.ui");
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	builder = _tmp34_;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp35_ = builder;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp36_ = gtk_builder_get_object (_tmp35_, "sudoku_app");
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_application_window_get_type (), GtkApplicationWindow));
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->window);
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->window = _tmp37_;
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp38_ = self->priv->window;
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GtkWidget*) _tmp38_, "size-allocate", (GCallback) _sudoku_size_allocate_cb_gtk_widget_size_allocate, self, 0);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp39_ = self->priv->window;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GtkWidget*) _tmp39_, "window-state-event", (GCallback) _sudoku_window_state_event_cb_gtk_widget_window_state_event, self, 0);
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp40_ = self->priv->window;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp41_ = self->priv->settings;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp42_ = g_settings_get_int (_tmp41_, "window-width");
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp43_ = self->priv->settings;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp44_ = g_settings_get_int (_tmp43_, "window-height");
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_set_default_size ((GtkWindow*) _tmp40_, _tmp42_, _tmp44_);
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp45_ = self->priv->settings;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp46_ = g_settings_get_boolean (_tmp45_, "window-is-maximized");
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp46_) {
#line 842 "gnome-sudoku.c"
		GtkApplicationWindow* _tmp47_ = NULL;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp47_ = self->priv->window;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_window_maximize ((GtkWindow*) _tmp47_);
#line 848 "gnome-sudoku.c"
	}
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp48_ = self->priv->window;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp48_);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp49_ = builder;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp50_ = gtk_builder_get_object (_tmp49_, "headerbar");
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp51_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, gtk_header_bar_get_type (), GtkHeaderBar));
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->headerbar = _tmp51_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp52_ = builder;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp53_ = gtk_builder_get_object (_tmp52_, "main_stack");
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp54_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_stack_get_type (), GtkStack));
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->main_stack = _tmp54_;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp55_ = builder;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp56_ = gtk_builder_get_object (_tmp55_, "game_box");
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp57_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, gtk_box_get_type (), GtkBox));
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game_box);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->game_box = _tmp57_;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp58_ = builder;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp59_ = gtk_builder_get_object (_tmp58_, "undo_redo_box");
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_box_get_type (), GtkBox));
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_redo_box);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->undo_redo_box = _tmp60_;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp61_ = builder;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp62_ = gtk_builder_get_object (_tmp61_, "back_button");
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp63_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, gtk_button_get_type (), GtkButton));
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->back_button);
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->back_button = _tmp63_;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp64_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp65_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, g_simple_action_get_type (), GSimpleAction));
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_action);
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->undo_action = _tmp65_;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp66_ = g_action_map_lookup_action ((GActionMap*) self, "redo");
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp67_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, g_simple_action_get_type (), GSimpleAction));
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->redo_action);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->redo_action = _tmp67_;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp68_ = g_action_map_lookup_action ((GActionMap*) self, "reset");
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp69_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, g_simple_action_get_type (), GSimpleAction));
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clear_action);
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->clear_action = _tmp69_;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp70_ = g_action_map_lookup_action ((GActionMap*) self, "print");
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp71_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, g_simple_action_get_type (), GSimpleAction));
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_action);
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->print_action = _tmp71_;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp72_ = g_action_map_lookup_action ((GActionMap*) self, "print-multiple");
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp73_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, g_simple_action_get_type (), GSimpleAction));
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_multiple_action);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->print_multiple_action = _tmp73_;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp74_ = sudoku_is_desktop (self, "Unity");
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (!_tmp74_) {
#line 948 "gnome-sudoku.c"
		GtkHeaderBar* _tmp75_ = NULL;
		GtkApplicationWindow* _tmp76_ = NULL;
		GtkHeaderBar* _tmp77_ = NULL;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp75_ = self->priv->headerbar;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_show_close_button (_tmp75_, TRUE);
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp76_ = self->priv->window;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp77_ = self->priv->headerbar;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_window_set_titlebar ((GtkWindow*) _tmp76_, (GtkWidget*) _tmp77_);
#line 962 "gnome-sudoku.c"
	} else {
		GtkBox* vbox = NULL;
		GtkBuilder* _tmp78_ = NULL;
		GObject* _tmp79_ = NULL;
		GtkBox* _tmp80_ = NULL;
		GtkBox* _tmp81_ = NULL;
		GtkHeaderBar* _tmp82_ = NULL;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp78_ = builder;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp79_ = gtk_builder_get_object (_tmp78_, "vbox");
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp80_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, gtk_box_get_type (), GtkBox));
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		vbox = _tmp80_;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp81_ = vbox;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp82_ = self->priv->headerbar;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_box_pack_start (_tmp81_, (GtkWidget*) _tmp82_, FALSE, FALSE, (guint) 0);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (vbox);
#line 986 "gnome-sudoku.c"
	}
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp83_ = sudoku_saver_new ();
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->saver);
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->saver = _tmp83_;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp84_ = self->priv->saver;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp85_ = sudoku_saver_get_savedgame (_tmp84_);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	savegame = _tmp85_;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp86_ = savegame;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp86_ != NULL) {
#line 1004 "gnome-sudoku.c"
		SudokuGame* _tmp87_ = NULL;
		SudokuBoard* _tmp88_ = NULL;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp87_ = savegame;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp88_ = _tmp87_->board;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_start_game (self, _tmp88_);
#line 1013 "gnome-sudoku.c"
	} else {
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_show_new_game_screen (self);
#line 1017 "gnome-sudoku.c"
	}
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (savegame);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (builder);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (css_provider);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (highlighter_action);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (action);
#line 1029 "gnome-sudoku.c"
}


static void sudoku_real_activate (GApplication* base) {
	Sudoku * self;
	GtkApplicationWindow* _tmp0_ = NULL;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->window;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 1042 "gnome-sudoku.c"
}


static void sudoku_real_shutdown (GApplication* base) {
	Sudoku * self;
	SudokuGame* _tmp0_ = NULL;
	GSettings* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	GSettings* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	GSettings* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	GError * _inner_error_ = NULL;
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ != NULL) {
#line 1062 "gnome-sudoku.c"
		gboolean _tmp1_ = FALSE;
		SudokuGame* _tmp2_ = NULL;
		SudokuBoard* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp11_ = FALSE;
		SudokuGame* _tmp12_ = NULL;
		SudokuBoard* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->game;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = _tmp2_->board;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = sudoku_board_is_empty (_tmp3_);
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (!_tmp4_) {
#line 1079 "gnome-sudoku.c"
			SudokuGame* _tmp5_ = NULL;
			SudokuBoard* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp5_ = self->priv->game;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp6_ = _tmp5_->board;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp7_ = sudoku_board_get_complete (_tmp6_);
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp8_ = _tmp7_;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp1_ = !_tmp8_;
#line 1094 "gnome-sudoku.c"
		} else {
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp1_ = FALSE;
#line 1098 "gnome-sudoku.c"
		}
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp1_) {
#line 1102 "gnome-sudoku.c"
			SudokuSaver* _tmp9_ = NULL;
			SudokuGame* _tmp10_ = NULL;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp9_ = self->priv->saver;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp10_ = self->priv->game;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			sudoku_saver_save_game (_tmp9_, _tmp10_);
#line 1111 "gnome-sudoku.c"
		}
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = self->priv->game;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp13_ = _tmp12_->board;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp14_ = sudoku_board_is_empty (_tmp13_);
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp14_) {
#line 1121 "gnome-sudoku.c"
			SudokuSaver* _tmp15_ = NULL;
			SudokuGame* _tmp16_ = NULL;
			SudokuGame* _tmp17_ = NULL;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp15_ = self->priv->saver;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp16_ = sudoku_saver_get_savedgame (_tmp15_);
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp17_ = _tmp16_;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp11_ = _tmp17_ != NULL;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_g_object_unref0 (_tmp17_);
#line 1135 "gnome-sudoku.c"
		} else {
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp11_ = FALSE;
#line 1139 "gnome-sudoku.c"
		}
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp11_) {
#line 1143 "gnome-sudoku.c"
			GFile* file = NULL;
			const gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			GFile* _tmp20_ = NULL;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp18_ = sudoku_saver_get_savegame_file ();
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp19_ = _tmp18_;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp20_ = g_file_new_for_path (_tmp19_);
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			file = _tmp20_;
#line 1156 "gnome-sudoku.c"
			{
				GFile* _tmp21_ = NULL;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp21_ = file;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_file_delete (_tmp21_, NULL, &_inner_error_);
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1165 "gnome-sudoku.c"
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				e = _inner_error_;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_inner_error_ = NULL;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp22_ = e;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp23_ = _tmp22_->message;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_warning ("gnome-sudoku.vala:223: Failed to delete saved game: %s", _tmp23_);
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_g_error_free0 (e);
#line 1187 "gnome-sudoku.c"
			}
			__finally0:
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_g_object_unref0 (file);
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_clear_error (&_inner_error_);
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				return;
#line 1200 "gnome-sudoku.c"
			}
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_g_object_unref0 (file);
#line 1204 "gnome-sudoku.c"
		}
	}
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = self->priv->settings;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_ = self->priv->window_width;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_settings_set_int (_tmp24_, "window-width", _tmp25_);
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26_ = self->priv->settings;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp27_ = self->priv->window_height;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_settings_set_int (_tmp26_, "window-height", _tmp27_);
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp28_ = self->priv->settings;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29_ = self->priv->is_maximized;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_settings_set_boolean (_tmp28_, "window-is-maximized", _tmp29_);
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_APPLICATION_CLASS (sudoku_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 1227 "gnome-sudoku.c"
}


static void sudoku_size_allocate_cb (Sudoku* self, GtkAllocation* allocation) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkAllocation _tmp3_ = {0};
	gint _tmp4_ = 0;
	GtkAllocation _tmp5_ = {0};
	gint _tmp6_ = 0;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (allocation != NULL);
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->is_maximized;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp1_) {
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = TRUE;
#line 1248 "gnome-sudoku.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->is_tiled;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = _tmp2_;
#line 1255 "gnome-sudoku.c"
	}
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_) {
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 1261 "gnome-sudoku.c"
	}
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = *allocation;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = _tmp3_.width;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->window_width = _tmp4_;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = *allocation;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = _tmp5_.height;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->window_height = _tmp6_;
#line 1275 "gnome-sudoku.c"
}


static gboolean sudoku_window_state_event_cb (Sudoku* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState* _tmp4_ = NULL;
	GdkWindowState _tmp5_ = 0;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = event;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 1295 "gnome-sudoku.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = event;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1304 "gnome-sudoku.c"
	}
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = event;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = _tmp4_->changed_mask;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
#line 1312 "gnome-sudoku.c"
		GdkEventWindowState* _tmp6_ = NULL;
		GdkWindowState _tmp7_ = 0;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp6_ = event;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp7_ = _tmp6_->new_window_state;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->is_tiled = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
#line 1321 "gnome-sudoku.c"
	}
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = FALSE;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 1327 "gnome-sudoku.c"
}


static void __lambda14_ (Sudoku* self) {
	GSimpleAction* _tmp0_ = NULL;
	SudokuGame* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GSimpleAction* _tmp3_ = NULL;
	SudokuGame* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GSimpleAction* _tmp6_ = NULL;
	SudokuGame* _tmp7_ = NULL;
	SudokuBoard* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->undo_action;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->game;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = sudoku_game_is_undostack_null (_tmp1_);
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp0_, !_tmp2_);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->redo_action;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->game;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = sudoku_game_is_redostack_null (_tmp4_);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->clear_action;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = self->priv->game;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = _tmp7_->board;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = sudoku_board_is_empty (_tmp8_);
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp6_, !_tmp9_);
#line 1368 "gnome-sudoku.c"
}


static void ___lambda14__sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self) {
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda14_ ((Sudoku*) self);
#line 1375 "gnome-sudoku.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return _data1_;
#line 1384 "gnome-sudoku.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 1393 "gnome-sudoku.c"
		Sudoku* self;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self = _data1_->self;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_data1_->dialog);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (self);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_slice_free (Block1Data, _data1_);
#line 1403 "gnome-sudoku.c"
	}
}


static void __lambda16_ (Block1Data* _data1_, gint response_id) {
	Sudoku* self;
	gint _tmp0_ = 0;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = _data1_->self;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = response_id;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_show_new_game_screen (self);
#line 1419 "gnome-sudoku.c"
	} else {
		gint _tmp1_ = 0;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = response_id;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp1_ == ((gint) GTK_RESPONSE_REJECT)) {
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_application_quit ((GApplication*) self);
#line 1428 "gnome-sudoku.c"
		}
	}
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_destroy ((GtkWidget*) _data1_->dialog);
#line 1433 "gnome-sudoku.c"
}


static void ___lambda16__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda16_ (self, response_id);
#line 1440 "gnome-sudoku.c"
}


static void __lambda15_ (Sudoku* self) {
	Block1Data* _data1_;
	SudokuSaver* _tmp15_ = NULL;
	SudokuGame* _tmp16_ = NULL;
	gint minutes = 0;
	SudokuGame* _tmp17_ = NULL;
	gdouble _tmp18_ = 0.0;
	gint _tmp19_ = 0;
	gchar* time_str = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GtkApplicationWindow* _tmp22_ = NULL;
	GtkMessageDialog* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data1_->_ref_count_ = 1;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data1_->self = g_object_ref (self);
#line 1465 "gnome-sudoku.c"
	{
		gint i = 0;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		i = 0;
#line 1470 "gnome-sudoku.c"
		{
			gboolean _tmp0_ = FALSE;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp0_ = TRUE;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			while (TRUE) {
#line 1477 "gnome-sudoku.c"
				gint _tmp2_ = 0;
				SudokuGame* _tmp3_ = NULL;
				SudokuBoard* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				if (!_tmp0_) {
#line 1485 "gnome-sudoku.c"
					gint _tmp1_ = 0;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					_tmp1_ = i;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					i = _tmp1_ + 1;
#line 1491 "gnome-sudoku.c"
				}
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp0_ = FALSE;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp2_ = i;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp3_ = self->priv->game;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp4_ = _tmp3_->board;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp5_ = sudoku_board_get_rows (_tmp4_);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp6_ = _tmp5_;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				if (!(_tmp2_ < _tmp6_)) {
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					break;
#line 1509 "gnome-sudoku.c"
				}
				{
					gint j = 0;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					j = 0;
#line 1515 "gnome-sudoku.c"
					{
						gboolean _tmp7_ = FALSE;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
						_tmp7_ = TRUE;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
						while (TRUE) {
#line 1522 "gnome-sudoku.c"
							gint _tmp9_ = 0;
							SudokuGame* _tmp10_ = NULL;
							SudokuBoard* _tmp11_ = NULL;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							SudokuView* _tmp14_ = NULL;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							if (!_tmp7_) {
#line 1531 "gnome-sudoku.c"
								gint _tmp8_ = 0;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
								_tmp8_ = j;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
								j = _tmp8_ + 1;
#line 1537 "gnome-sudoku.c"
							}
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp7_ = FALSE;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp9_ = j;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp10_ = self->priv->game;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp11_ = _tmp10_->board;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp12_ = sudoku_board_get_cols (_tmp11_);
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp13_ = _tmp12_;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							if (!(_tmp9_ < _tmp13_)) {
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
								break;
#line 1555 "gnome-sudoku.c"
							}
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp14_ = self->priv->view;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							g_object_set ((GtkWidget*) _tmp14_, "can-focus", FALSE, NULL);
#line 1561 "gnome-sudoku.c"
						}
					}
				}
			}
		}
	}
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = self->priv->saver;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp16_ = self->priv->game;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_saver_add_game_to_finished (_tmp15_, _tmp16_, TRUE);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = self->priv->game;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp18_ = sudoku_game_get_total_time_played (_tmp17_);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_ = MAX (1, ((gint) _tmp18_) / 60);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	minutes = _tmp19_;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = ngettext ("Well done, you completed the puzzle in %d minute!", "Well done, you completed the puzzle in %d minutes!", (gulong) minutes);
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp21_ = g_strdup_printf (_tmp20_, minutes);
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	time_str = _tmp21_;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = self->priv->window;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp22_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, time_str);
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp23_);
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data1_->dialog = _tmp23_;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = _ ("Play _Again");
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_dialog_add_button ((GtkDialog*) _data1_->dialog, _tmp24_, (gint) GTK_RESPONSE_ACCEPT);
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_ = _ ("_Quit");
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_dialog_add_button ((GtkDialog*) _data1_->dialog, _tmp25_, (gint) GTK_RESPONSE_REJECT);
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_data ((GtkDialog*) _data1_->dialog, "response", (GCallback) ___lambda16__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _data1_->dialog);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (time_str);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	block1_data_unref (_data1_);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data1_ = NULL;
#line 1614 "gnome-sudoku.c"
}


static void ___lambda15__sudoku_board_completed (SudokuBoard* _sender, gpointer self) {
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda15_ ((Sudoku*) self);
#line 1621 "gnome-sudoku.c"
}


static void sudoku_start_game (Sudoku* self, SudokuBoard* board) {
	GSimpleAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	SudokuView* _tmp2_ = NULL;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_ = NULL;
	GtkHeaderBar* _tmp20_ = NULL;
	SudokuBoard* _tmp21_ = NULL;
	SudokuGame* _tmp22_ = NULL;
	SudokuGame* _tmp23_ = NULL;
	GTimer* _tmp24_ = NULL;
	SudokuGame* _tmp25_ = NULL;
	SudokuView* _tmp26_ = NULL;
	SudokuView* _tmp27_ = NULL;
	SudokuView* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	SudokuView* _tmp30_ = NULL;
	GSettings* _tmp31_ = NULL;
	gboolean _tmp32_ = FALSE;
	SudokuView* _tmp33_ = NULL;
	GSettings* _tmp34_ = NULL;
	gboolean _tmp35_ = FALSE;
	SudokuView* _tmp36_ = NULL;
	GtkBox* _tmp37_ = NULL;
	SudokuView* _tmp38_ = NULL;
	SudokuGame* _tmp39_ = NULL;
	SudokuGame* _tmp40_ = NULL;
	SudokuBoard* _tmp41_ = NULL;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (board != NULL);
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->undo_action;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp0_, FALSE);
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->redo_action;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp1_, FALSE);
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->view;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp2_ != NULL) {
#line 1669 "gnome-sudoku.c"
		GtkBox* _tmp3_ = NULL;
		SudokuView* _tmp4_ = NULL;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = self->priv->game_box;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = self->priv->view;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_container_remove ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
#line 1678 "gnome-sudoku.c"
	}
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->desktop;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp6_ == NULL) {
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = TRUE;
#line 1686 "gnome-sudoku.c"
	} else {
		const gchar* _tmp7_ = NULL;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp7_ = self->priv->desktop;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = g_strcmp0 (_tmp7_, "Unity") != 0;
#line 1693 "gnome-sudoku.c"
	}
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp5_) {
#line 1697 "gnome-sudoku.c"
		GtkHeaderBar* _tmp8_ = NULL;
		SudokuBoard* _tmp9_ = NULL;
		DifficultyCategory _tmp10_ = 0;
		DifficultyCategory _tmp11_ = 0;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp8_ = self->priv->headerbar;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp9_ = board;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp10_ = sudoku_board_get_difficulty_category (_tmp9_);
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp11_ = _tmp10_;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = difficulty_category_to_string (_tmp11_);
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp13_ = _tmp12_;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_subtitle (_tmp8_, _tmp13_);
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp13_);
#line 1720 "gnome-sudoku.c"
	} else {
		GtkHeaderBar* _tmp14_ = NULL;
		SudokuBoard* _tmp15_ = NULL;
		DifficultyCategory _tmp16_ = 0;
		DifficultyCategory _tmp17_ = 0;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp14_ = self->priv->headerbar;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp15_ = board;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp16_ = sudoku_board_get_difficulty_category (_tmp15_);
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp17_ = _tmp16_;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp18_ = difficulty_category_to_string (_tmp17_);
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp19_ = _tmp18_;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_title (_tmp14_, _tmp19_);
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp19_);
#line 1744 "gnome-sudoku.c"
	}
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = self->priv->headerbar;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp20_, TRUE);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp21_ = board;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = sudoku_game_new (_tmp21_);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->game = _tmp22_;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_back_cb (self);
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = self->priv->game;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = _tmp23_->timer;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_timer_start (_tmp24_);
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_ = self->priv->game;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26_ = sudoku_view_new (_tmp25_);
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp26_);
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->view);
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->view = _tmp26_;
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp27_ = self->priv->view;
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp27_, 480, 480);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp28_ = self->priv->view;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29_ = self->priv->show_possibilities;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_view_set_show_possibilities (_tmp28_, _tmp29_);
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp30_ = self->priv->view;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp31_ = self->priv->settings;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp32_ = g_settings_get_boolean (_tmp31_, "show-warnings");
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_view_set_show_warnings (_tmp30_, _tmp32_);
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp33_ = self->priv->view;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp34_ = self->priv->settings;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp35_ = g_settings_get_boolean (_tmp34_, "highlighter");
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_view_set_highlighter (_tmp33_, _tmp35_);
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp36_ = self->priv->view;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _tmp36_);
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp37_ = self->priv->game_box;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp38_ = self->priv->view;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_box_pack_start (_tmp37_, (GtkWidget*) _tmp38_, TRUE, TRUE, (guint) 0);
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp39_ = self->priv->game;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object (_tmp39_, "cell-changed", (GCallback) ___lambda14__sudoku_game_cell_changed, self, 0);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp40_ = self->priv->game;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp41_ = _tmp40_->board;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object (_tmp41_, "completed", (GCallback) ___lambda15__sudoku_board_completed, self, 0);
#line 1822 "gnome-sudoku.c"
}


static void sudoku_show_new_game_screen (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	SudokuGame* _tmp3_ = NULL;
	GtkBox* _tmp4_ = NULL;
	GSimpleAction* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "start_box");
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->clear_action;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp1_, FALSE);
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->back_button;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->game;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, _tmp3_ != NULL);
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->undo_redo_box;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp4_, FALSE);
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = self->priv->print_action;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp5_, FALSE);
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = self->priv->desktop;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp7_ == NULL) {
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp6_ = TRUE;
#line 1865 "gnome-sudoku.c"
	} else {
		const gchar* _tmp8_ = NULL;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp8_ = self->priv->desktop;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp6_ = g_strcmp0 (_tmp8_, "Unity") != 0;
#line 1872 "gnome-sudoku.c"
	}
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp6_) {
#line 1876 "gnome-sudoku.c"
		GtkHeaderBar* _tmp9_ = NULL;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp9_ = self->priv->headerbar;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_subtitle (_tmp9_, NULL);
#line 1882 "gnome-sudoku.c"
	} else {
		GtkHeaderBar* _tmp10_ = NULL;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp10_ = self->priv->headerbar;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp10_, FALSE);
#line 1889 "gnome-sudoku.c"
	}
}


static void sudoku_new_game_cb (Sudoku* self) {
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_show_new_game_screen (self);
#line 1899 "gnome-sudoku.c"
}


static void __lambda13_ (Sudoku* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (res != NULL);
#line 1907 "gnome-sudoku.c"
	{
		GeeList* gen_boards = NULL;
		GAsyncResult* _tmp0_ = NULL;
		GeeList* _tmp1_ = NULL;
		GtkButton* _tmp2_ = NULL;
		gpointer _tmp3_ = NULL;
		SudokuBoard* _tmp4_ = NULL;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = res;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = sudoku_generator_generate_boards_finish (_tmp0_, &_inner_error_);
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gen_boards = _tmp1_;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			if (_inner_error_->domain == G_THREAD_ERROR) {
#line 1925 "gnome-sudoku.c"
				goto __catch1_g_thread_error;
			}
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_clear_error (&_inner_error_);
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			return;
#line 1934 "gnome-sudoku.c"
		}
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->back_button;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, TRUE);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = gee_list_get (gen_boards, 0);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = (SudokuBoard*) _tmp3_;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_start_game (self, _tmp4_);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_tmp4_);
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (gen_boards);
#line 1950 "gnome-sudoku.c"
	}
	goto __finally1;
	__catch1_g_thread_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_ = NULL;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		e = _inner_error_;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_inner_error_ = NULL;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = e->message;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_error ("gnome-sudoku.vala:353: Thread error: %s", _tmp5_);
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_error_free0 (e);
#line 1967 "gnome-sudoku.c"
	}
	__finally1:
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_clear_error (&_inner_error_);
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 1978 "gnome-sudoku.c"
	}
}


static void ___lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda13_ ((Sudoku*) self, source_object, res);
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_unref (self);
#line 1988 "gnome-sudoku.c"
}


static void sudoku_start_game_cb (Sudoku* self, GSimpleAction* action, GVariant* difficulty) {
	DifficultyCategory selected_difficulty = 0;
	GVariant* _tmp0_ = NULL;
	gint32 _tmp1_ = 0;
	GtkButton* _tmp2_ = NULL;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (action != NULL);
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = difficulty;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = g_variant_get_int32 (_tmp0_);
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	selected_difficulty = (DifficultyCategory) _tmp1_;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->back_button;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_generator_generate_boards_async (1, selected_difficulty, ___lambda13__gasync_ready_callback, g_object_ref (self));
#line 2013 "gnome-sudoku.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return _data2_;
#line 2022 "gnome-sudoku.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 2031 "gnome-sudoku.c"
		Sudoku* self;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self = _data2_->self;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_data2_->dialog);
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (self);
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_slice_free (Block2Data, _data2_);
#line 2041 "gnome-sudoku.c"
	}
}


static void __lambda17_ (Block2Data* _data2_, gint response_id) {
	Sudoku* self;
	gint _tmp0_ = 0;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = _data2_->self;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = response_id;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
#line 2055 "gnome-sudoku.c"
		SudokuView* _tmp1_ = NULL;
		SudokuGame* _tmp2_ = NULL;
		GSimpleAction* _tmp3_ = NULL;
		GSimpleAction* _tmp4_ = NULL;
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = self->priv->view;
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_view_clear (_tmp1_);
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->game;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_game_reset (_tmp2_);
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = self->priv->undo_action;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp3_, FALSE);
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = self->priv->redo_action;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp4_, FALSE);
#line 2076 "gnome-sudoku.c"
	}
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_destroy ((GtkWidget*) _data2_->dialog);
#line 2080 "gnome-sudoku.c"
}


static void ___lambda17__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda17_ (self, response_id);
#line 2087 "gnome-sudoku.c"
}


static void sudoku_reset_cb (Sudoku* self) {
	Block2Data* _data2_;
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkMessageDialog* _tmp2_ = NULL;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_->_ref_count_ = 1;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_->self = g_object_ref (self);
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->window;
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _ ("Reset the board to its original state?");
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_OK_CANCEL, _tmp1_);
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp2_);
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_->dialog = _tmp2_;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_data ((GtkDialog*) _data2_->dialog, "response", (GCallback) ___lambda17__gtk_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _data2_->dialog);
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	block2_data_unref (_data2_);
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_ = NULL;
#line 2122 "gnome-sudoku.c"
}


static void sudoku_back_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	SudokuGame* _tmp2_ = NULL;
	SudokuBoard* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GtkButton* _tmp5_ = NULL;
	GtkBox* _tmp6_ = NULL;
	GSimpleAction* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 378 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 378 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "frame");
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->clear_action;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->game;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = _tmp2_->board;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = sudoku_board_is_empty (_tmp3_);
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp1_, !_tmp4_);
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = self->priv->back_button;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, FALSE);
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->undo_redo_box;
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, TRUE);
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = self->priv->print_action;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp7_, TRUE);
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = self->priv->desktop;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp9_ == NULL) {
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp8_ = TRUE;
#line 2171 "gnome-sudoku.c"
	} else {
		const gchar* _tmp10_ = NULL;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp10_ = self->priv->desktop;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp8_ = g_strcmp0 (_tmp10_, "Unity") != 0;
#line 2178 "gnome-sudoku.c"
	}
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp8_) {
#line 2182 "gnome-sudoku.c"
		GtkHeaderBar* _tmp11_ = NULL;
		SudokuGame* _tmp12_ = NULL;
		SudokuBoard* _tmp13_ = NULL;
		DifficultyCategory _tmp14_ = 0;
		DifficultyCategory _tmp15_ = 0;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp11_ = self->priv->headerbar;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = self->priv->game;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp13_ = _tmp12_->board;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp14_ = sudoku_board_get_difficulty_category (_tmp13_);
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp15_ = _tmp14_;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp16_ = difficulty_category_to_string (_tmp15_);
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp17_ = _tmp16_;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_subtitle (_tmp11_, _tmp17_);
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp17_);
#line 2208 "gnome-sudoku.c"
	} else {
		GtkHeaderBar* _tmp18_ = NULL;
		SudokuGame* _tmp19_ = NULL;
		SudokuBoard* _tmp20_ = NULL;
		DifficultyCategory _tmp21_ = 0;
		DifficultyCategory _tmp22_ = 0;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp18_ = self->priv->headerbar;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp19_ = self->priv->game;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp20_ = _tmp19_->board;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp21_ = sudoku_board_get_difficulty_category (_tmp20_);
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp22_ = _tmp21_;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp23_ = difficulty_category_to_string (_tmp22_);
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp24_ = _tmp23_;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_title (_tmp18_, _tmp24_);
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp24_);
#line 2235 "gnome-sudoku.c"
	}
}


static void sudoku_undo_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	SudokuGame* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	SudokuGame* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	SudokuView* _tmp6_ = NULL;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2258 "gnome-sudoku.c"
	}
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->game;
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_undo (_tmp2_);
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->undo_action;
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->game;
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = sudoku_game_is_undostack_null (_tmp4_);
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->view;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
#line 2276 "gnome-sudoku.c"
}


static void sudoku_redo_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	SudokuGame* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	SudokuGame* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	SudokuView* _tmp6_ = NULL;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2298 "gnome-sudoku.c"
	}
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->game;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_redo (_tmp2_);
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->redo_action;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->game;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = sudoku_game_is_redostack_null (_tmp4_);
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->view;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
#line 2316 "gnome-sudoku.c"
}


static void sudoku_print_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp4_ = NULL;
	GeeArrayList* _tmp5_ = NULL;
	SudokuGame* _tmp6_ = NULL;
	SudokuBoard* _tmp7_ = NULL;
	SudokuBoard* _tmp8_ = NULL;
	SudokuBoard* _tmp9_ = NULL;
	SudokuPrinter* printer = NULL;
	GeeArrayList* _tmp10_ = NULL;
	GtkApplicationWindow* _tmp11_ = NULL;
	SudokuPrinter* _tmp12_ = NULL;
	SudokuPrinter* _tmp13_ = NULL;
	GSimpleAction* _tmp14_ = NULL;
	GSimpleAction* _tmp15_ = NULL;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2349 "gnome-sudoku.c"
	}
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->print_action;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp2_, FALSE);
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->print_multiple_action;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, FALSE);
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = gee_array_list_new (TYPE_SUDOKU_BOARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	list = _tmp4_;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = list;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->game;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = _tmp6_->board;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = sudoku_board_clone (_tmp7_);
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = _tmp8_;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp9_);
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (_tmp9_);
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_ = list;
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = self->priv->window;
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp12_ = sudoku_printer_new ((GeeList*) _tmp10_, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_window_get_type (), GtkWindow));
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	printer = _tmp12_;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_ = printer;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_printer_print_sudoku (_tmp13_);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = self->priv->print_action;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp14_, TRUE);
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = self->priv->print_multiple_action;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp15_, TRUE);
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (printer);
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (list);
#line 2401 "gnome-sudoku.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return _data3_;
#line 2410 "gnome-sudoku.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 2419 "gnome-sudoku.c"
		Sudoku* self;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self = _data3_->self;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_data3_->print_dialog);
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (self);
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_slice_free (Block3Data, _data3_);
#line 2429 "gnome-sudoku.c"
	}
}


static void __lambda20_ (Block3Data* _data3_) {
	Sudoku* self;
	GSimpleAction* _tmp0_ = NULL;
	GtkStack* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = _data3_->self;
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_destroy ((GtkWidget*) _data3_->print_dialog);
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->print_action;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->main_stack;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = gtk_stack_get_visible_child_name (_tmp1_);
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp0_, g_strcmp0 (_tmp2_, "frame") == 0);
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->print_multiple_action;
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, TRUE);
#line 2456 "gnome-sudoku.c"
}


static void ___lambda20__print_dialog_finished (PrintDialog* _sender, gpointer self) {
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda20_ (self);
#line 2463 "gnome-sudoku.c"
}


static void sudoku_print_multiple_cb (Sudoku* self) {
	Block3Data* _data3_;
	GSimpleAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	SudokuSaver* _tmp2_ = NULL;
	GtkApplicationWindow* _tmp3_ = NULL;
	PrintDialog* _tmp4_ = NULL;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_->_ref_count_ = 1;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_->self = g_object_ref (self);
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->print_action;
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp0_, FALSE);
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->print_multiple_action;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp1_, FALSE);
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->saver;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->window;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = print_dialog_new (_tmp2_, (GtkWindow*) _tmp3_);
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp4_);
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_->print_dialog = _tmp4_;
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_data (_data3_->print_dialog, "finished", (GCallback) ___lambda20__print_dialog_finished, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_dialog_run ((GtkDialog*) _data3_->print_dialog);
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	block3_data_unref (_data3_);
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_ = NULL;
#line 2508 "gnome-sudoku.c"
}


static void sudoku_help_cb (Sudoku* self) {
	GError * _inner_error_ = NULL;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 2516 "gnome-sudoku.c"
	{
		GtkApplicationWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = self->priv->window;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_show_uri (_tmp1_, "help:gnome-sudoku", _tmp2_, &_inner_error_);
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2531 "gnome-sudoku.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		e = _inner_error_;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_inner_error_ = NULL;
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = e;
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = _tmp3_->message;
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_warning ("gnome-sudoku.vala:445: Unable to open help: %s", _tmp4_);
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_error_free0 (e);
#line 2553 "gnome-sudoku.c"
	}
	__finally2:
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_clear_error (&_inner_error_);
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2564 "gnome-sudoku.c"
	}
}


static void sudoku_about_cb (Sudoku* self) {
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->window;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _ ("Sudoku");
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = sudoku_generator_qqwing_version ();
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = _tmp2_;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = g_strdup_printf ("The popular Japanese logic puzzle\n\nPuzzles generated by QQwing %s", _tmp3_);
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = _tmp4_;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = _ (_tmp5_);
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = _ ("translator-credits");
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_show_about_dialog ((GtkWindow*) _tmp0_, "program-name", _tmp1_, "logo-icon-name", "gnome-sudoku", "version", VERSION, "comments", _tmp6_, "copyright", "Copyright © 2005–2008 Thomas M. Hinkle\n" \
"Copyright © 2010–2011 Robert Ancell\n" \
"Copyright © 2014 Parin Porecha", "license-type", GTK_LICENSE_GPL_2_0, "authors", SUDOKU_authors, "artists", NULL, "translator-credits", _tmp7_, "website", "https://wiki.gnome.org/Apps/Sudoku/", NULL);
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (_tmp5_);
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (_tmp3_);
#line 2602 "gnome-sudoku.c"
}


gint sudoku_main (gchar** args, int args_length1) {
	gint result = 0;
	Sudoku* _tmp0_ = NULL;
	Sudoku* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = sudoku_new ();
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _tmp0_;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = args;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2__length1 = args_length1;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = g_application_run ((GApplication*) _tmp1_, _tmp2__length1, _tmp2_);
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = _tmp3_;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (_tmp1_);
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = _tmp4_;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 2632 "gnome-sudoku.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return sudoku_main (argv, argc);
#line 2642 "gnome-sudoku.c"
}


static void sudoku_class_init (SudokuClass * klass) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_type_class_add_private (klass, sizeof (SudokuPrivate));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->handle_local_options = sudoku_real_handle_local_options;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->startup = sudoku_real_startup;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->activate = sudoku_real_activate;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->shutdown = sudoku_real_shutdown;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_finalize;
#line 2661 "gnome-sudoku.c"
}


static void sudoku_instance_init (Sudoku * self) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv = SUDOKU_GET_PRIVATE (self);
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->show_possibilities = FALSE;
#line 2670 "gnome-sudoku.c"
}


static void sudoku_finalize (GObject* obj) {
	Sudoku * self;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU, Sudoku);
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->settings);
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->window);
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->view);
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game_box);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_redo_box);
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->back_button);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->saver);
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_action);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->redo_action);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clear_action);
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_action);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_multiple_action);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (self->priv->desktop);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_OBJECT_CLASS (sudoku_parent_class)->finalize (obj);
#line 2712 "gnome-sudoku.c"
}


GType sudoku_get_type (void) {
	static volatile gsize sudoku_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Sudoku), 0, (GInstanceInitFunc) sudoku_instance_init, NULL };
		GType sudoku_type_id;
		sudoku_type_id = g_type_register_static (gtk_application_get_type (), "Sudoku", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_type_id__volatile, sudoku_type_id);
	}
	return sudoku_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



