/* rygel-http-time-seek-request.c generated by valac 0.28.0, the Vala compiler
 * generated from rygel-http-time-seek-request.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>


#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;
typedef struct _RygelHTTPSeekRequestPrivate RygelHTTPSeekRequestPrivate;

#define RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST (rygel_http_time_seek_request_get_type ())
#define RYGEL_HTTP_TIME_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequest))
#define RYGEL_HTTP_TIME_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequestClass))
#define RYGEL_IS_HTTP_TIME_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST))
#define RYGEL_IS_HTTP_TIME_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST))
#define RYGEL_HTTP_TIME_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequestClass))

typedef struct _RygelHTTPTimeSeekRequest RygelHTTPTimeSeekRequest;
typedef struct _RygelHTTPTimeSeekRequestClass RygelHTTPTimeSeekRequestClass;
typedef struct _RygelHTTPTimeSeekRequestPrivate RygelHTTPTimeSeekRequestPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_PLAY_SPEED (rygel_play_speed_get_type ())
#define RYGEL_PLAY_SPEED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeed))
#define RYGEL_PLAY_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeedClass))
#define RYGEL_IS_PLAY_SPEED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED))
#define RYGEL_IS_PLAY_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED))
#define RYGEL_PLAY_SPEED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeedClass))

typedef struct _RygelPlaySpeed RygelPlaySpeed;
typedef struct _RygelPlaySpeedClass RygelPlaySpeedClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelHTTPSeekRequest {
	GObject parent_instance;
	RygelHTTPSeekRequestPrivate * priv;
};

struct _RygelHTTPSeekRequestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPTimeSeekRequest {
	RygelHTTPSeekRequest parent_instance;
	RygelHTTPTimeSeekRequestPrivate * priv;
	gint64 start_time;
	gint64 end_time;
	gint64 range_duration;
	gint64 total_duration;
};

struct _RygelHTTPTimeSeekRequestClass {
	RygelHTTPSeekRequestClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekRequestError;
#define RYGEL_HTTP_SEEK_REQUEST_ERROR rygel_http_seek_request_error_quark ()
struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelHTTPSeekRequest* seek;
	RygelPlaySpeedRequest* speed_request;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()

static gpointer rygel_http_time_seek_request_parent_class = NULL;

GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_http_time_seek_request_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_TIME_SEEK_REQUEST_DUMMY_PROPERTY
};
#define RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER "TimeSeekRange.dlna.org"
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
gpointer rygel_play_speed_ref (gpointer instance);
void rygel_play_speed_unref (gpointer instance);
GParamSpec* rygel_param_spec_play_speed (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_play_speed (GValue* value, gpointer v_object);
void rygel_value_take_play_speed (GValue* value, gpointer v_object);
gpointer rygel_value_get_play_speed (const GValue* value);
GType rygel_play_speed_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_request_error_quark (void);
RygelHTTPTimeSeekRequest* rygel_http_time_seek_request_new (RygelHTTPGet* request, RygelPlaySpeed* speed, GError** error);
RygelHTTPTimeSeekRequest* rygel_http_time_seek_request_construct (GType object_type, RygelHTTPGet* request, RygelPlaySpeed* speed, GError** error);
RygelHTTPSeekRequest* rygel_http_seek_request_construct (GType object_type);
gboolean rygel_play_speed_is_positive (RygelPlaySpeed* self);
gboolean rygel_play_speed_is_normal_rate (RygelPlaySpeed* self);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
gint64 rygel_http_get_handler_get_resource_duration (RygelHTTPGetHandler* self);
#define RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED ((gint64) (-1))
static gboolean rygel_http_time_seek_request_parse_npt_time (const gchar* range_token, gint64* value);
gchar* rygel_http_time_seek_request_to_string (RygelHTTPTimeSeekRequest* self);
gboolean rygel_http_time_seek_request_supported (RygelHTTPGet* request);
GQuark rygel_client_hacks_error_quark (void);
RygelClientHacks* rygel_client_hacks_create (SoupMessage* message, GError** error);
gboolean rygel_client_hacks_force_seek (RygelClientHacks* self);
gboolean rygel_http_get_handler_supports_time_seek (RygelHTTPGetHandler* self);
gboolean rygel_http_time_seek_request_requested (RygelHTTPGet* request);
static gboolean rygel_http_time_seek_request_parse_npt_seconds (const gchar* range_token, gint64* value);
static void rygel_http_time_seek_request_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
     * Create a HTTPTimeSeekRequest corresponding with a HTTPGet that contains a
     * TimeSeekRange.dlna.org header value.
     *
     * Note: This constructor will check the syntax of the request (per DLNA
     * 7.5.4.3.2.24.3) as well as perform some range validation. If the
     * provided request is associated with a handler that can provide content
     * duration, the start and end time will be checked for out-of-bounds
     * conditions. Additionally, the start and end will be checked according
     * to playspeed direction (with rate +1.0 assumed when speed is not
     * provided). When speed is provided, the range end parameter check is
     * relaxed when the rate is not +1.0 (per DLNA 7.5.4.3.2.24.4).
     *
     * @param request The HTTP GET/HEAD request
     * @param speed An associated speed request
     */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


RygelHTTPTimeSeekRequest* rygel_http_time_seek_request_construct (GType object_type, RygelHTTPGet* request, RygelPlaySpeed* speed, GError** error) {
	RygelHTTPTimeSeekRequest * self = NULL;
	gboolean _tmp0_ = FALSE;
	RygelPlaySpeed* _tmp1_ = NULL;
	gboolean positive_rate = FALSE;
	gboolean _tmp4_ = FALSE;
	RygelPlaySpeed* _tmp5_ = NULL;
	gboolean trick_mode = FALSE;
	RygelHTTPGet* _tmp8_ = NULL;
	RygelHTTPGetHandler* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	gint64 _tmp11_ = 0LL;
	gchar* range = NULL;
	RygelHTTPGet* _tmp12_ = NULL;
	SoupMessage* _tmp13_ = NULL;
	SoupMessageHeaders* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	gchar* parsed_range = NULL;
	const gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	gchar** range_tokens = NULL;
	const gchar* _tmp29_ = NULL;
	gchar** _tmp30_ = NULL;
	gchar** _tmp31_ = NULL;
	gint range_tokens_length1 = 0;
	gint _range_tokens_size_ = 0;
	gint64 start = 0LL;
	gchar** _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
	const gchar* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp37_ = FALSE;
	gint64 _tmp38_ = 0LL;
	gint64 end = 0LL;
	gchar** _tmp51_ = NULL;
	gint _tmp51__length1 = 0;
	const gchar* _tmp52_ = NULL;
	gboolean _tmp53_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (request != NULL, NULL);
	self = (RygelHTTPTimeSeekRequest*) rygel_http_seek_request_construct (object_type);
	_tmp1_ = speed;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		RygelPlaySpeed* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = speed;
		_tmp3_ = rygel_play_speed_is_positive (_tmp2_);
		_tmp0_ = _tmp3_;
	}
	positive_rate = _tmp0_;
	_tmp5_ = speed;
	if (_tmp5_ != NULL) {
		RygelPlaySpeed* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = speed;
		_tmp7_ = rygel_play_speed_is_normal_rate (_tmp6_);
		_tmp4_ = !_tmp7_;
	} else {
		_tmp4_ = FALSE;
	}
	trick_mode = _tmp4_;
	_tmp8_ = request;
	_tmp9_ = _tmp8_->handler;
	_tmp10_ = rygel_http_get_handler_get_resource_duration (_tmp9_);
	self->total_duration = _tmp10_;
	_tmp11_ = self->total_duration;
	if (_tmp11_ <= ((gint64) 0)) {
		self->total_duration = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	}
	_tmp12_ = request;
	_tmp13_ = ((RygelHTTPRequest*) _tmp12_)->msg;
	_tmp14_ = _tmp13_->request_headers;
	_tmp15_ = soup_message_headers_get_one (_tmp14_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER);
	_tmp16_ = g_strdup (_tmp15_);
	range = _tmp16_;
	_tmp17_ = range;
	if (_tmp17_ == NULL) {
		GError* _tmp18_ = NULL;
		_tmp18_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "%s not present", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER);
		_inner_error_ = _tmp18_;
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp19_ = range;
	_tmp20_ = g_str_has_prefix (_tmp19_, "npt=");
	if (!_tmp20_) {
		const gchar* _tmp21_ = NULL;
		GError* _tmp22_ = NULL;
		_tmp21_ = range;
		_tmp22_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid %s value (missing npt field): '%s'", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp21_);
		_inner_error_ = _tmp22_;
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp23_ = range;
	_tmp24_ = string_substring (_tmp23_, (glong) 4, (glong) (-1));
	parsed_range = _tmp24_;
	_tmp25_ = parsed_range;
	_tmp26_ = string_contains (_tmp25_, "-");
	if (!_tmp26_) {
		const gchar* _tmp27_ = NULL;
		GError* _tmp28_ = NULL;
		_tmp27_ = range;
		_tmp28_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid %s request with no '-': '%s'", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp27_);
		_inner_error_ = _tmp28_;
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (parsed_range);
			_g_free0 (range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (parsed_range);
			_g_free0 (range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp29_ = parsed_range;
	_tmp31_ = _tmp30_ = g_strsplit (_tmp29_, "-", 2);
	range_tokens = _tmp31_;
	range_tokens_length1 = _vala_array_length (_tmp30_);
	_range_tokens_size_ = range_tokens_length1;
	start = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	_tmp32_ = range_tokens;
	_tmp32__length1 = range_tokens_length1;
	_tmp33_ = _tmp32_[0];
	_tmp34_ = rygel_http_time_seek_request_parse_npt_time (_tmp33_, &start);
	if (!_tmp34_) {
		const gchar* _tmp35_ = NULL;
		GError* _tmp36_ = NULL;
		_tmp35_ = range;
		_tmp36_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid %s value (no start): '%s'", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp35_);
		_inner_error_ = _tmp36_;
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (parsed_range);
			_g_free0 (range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (parsed_range);
			_g_free0 (range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp38_ = self->total_duration;
	if (_tmp38_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		gint64 _tmp39_ = 0LL;
		gint64 _tmp40_ = 0LL;
		_tmp39_ = start;
		_tmp40_ = self->total_duration;
		_tmp37_ = _tmp39_ > _tmp40_;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		gboolean _tmp41_ = FALSE;
		gboolean _tmp42_ = FALSE;
		_tmp42_ = trick_mode;
		if (_tmp42_) {
			gboolean _tmp43_ = FALSE;
			_tmp43_ = positive_rate;
			_tmp41_ = !_tmp43_;
		} else {
			_tmp41_ = FALSE;
		}
		if (_tmp41_) {
			gint64 _tmp44_ = 0LL;
			_tmp44_ = self->total_duration;
			self->start_time = _tmp44_;
		} else {
			gchar* msg = NULL;
			gchar* _tmp45_ = NULL;
			const gchar* _tmp46_ = NULL;
			gint64 _tmp47_ = 0LL;
			gint64 _tmp48_ = 0LL;
			GError* _tmp49_ = NULL;
			_tmp45_ = g_strdup ("Invalid %s start time %lldns is beyond the content duration of %lldns");
			msg = _tmp45_;
			_tmp46_ = msg;
			_tmp47_ = start;
			_tmp48_ = self->total_duration;
			_tmp49_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE, _tmp46_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp47_, _tmp48_);
			_inner_error_ = _tmp49_;
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (parsed_range);
				_g_free0 (range);
				_g_object_unref0 (self);
				return NULL;
			} else {
				_g_free0 (msg);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (parsed_range);
				_g_free0 (range);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_free0 (msg);
		}
	} else {
		gint64 _tmp50_ = 0LL;
		_tmp50_ = start;
		self->start_time = _tmp50_;
	}
	end = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	_tmp51_ = range_tokens;
	_tmp51__length1 = range_tokens_length1;
	_tmp52_ = _tmp51_[1];
	_tmp53_ = rygel_http_time_seek_request_parse_npt_time (_tmp52_, &end);
	if (_tmp53_) {
		gboolean _tmp54_ = FALSE;
		_tmp54_ = positive_rate;
		if (_tmp54_) {
			gboolean _tmp55_ = FALSE;
			gint64 _tmp56_ = 0LL;
			gint64 _tmp67_ = 0LL;
			gint64 _tmp68_ = 0LL;
			gint64 _tmp69_ = 0LL;
			_tmp56_ = self->total_duration;
			if (_tmp56_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
				gint64 _tmp57_ = 0LL;
				gint64 _tmp58_ = 0LL;
				_tmp57_ = end;
				_tmp58_ = self->total_duration;
				_tmp55_ = _tmp57_ > _tmp58_;
			} else {
				_tmp55_ = FALSE;
			}
			if (_tmp55_) {
				gboolean _tmp59_ = FALSE;
				_tmp59_ = trick_mode;
				if (_tmp59_) {
					gint64 _tmp60_ = 0LL;
					_tmp60_ = self->total_duration;
					self->end_time = _tmp60_;
				} else {
					gchar* msg = NULL;
					gchar* _tmp61_ = NULL;
					const gchar* _tmp62_ = NULL;
					gint64 _tmp63_ = 0LL;
					gint64 _tmp64_ = 0LL;
					GError* _tmp65_ = NULL;
					_tmp61_ = g_strdup ("Invalid %s start time %lldns is beyond the content duration of %lldns");
					msg = _tmp61_;
					_tmp62_ = msg;
					_tmp63_ = end;
					_tmp64_ = self->total_duration;
					_tmp65_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE, _tmp62_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp63_, _tmp64_);
					_inner_error_ = _tmp65_;
					if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (msg);
						range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (parsed_range);
						_g_free0 (range);
						_g_object_unref0 (self);
						return NULL;
					} else {
						_g_free0 (msg);
						range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (parsed_range);
						_g_free0 (range);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_g_free0 (msg);
				}
			} else {
				gint64 _tmp66_ = 0LL;
				_tmp66_ = end;
				self->end_time = _tmp66_;
			}
			_tmp67_ = self->end_time;
			_tmp68_ = self->start_time;
			self->range_duration = _tmp67_ - _tmp68_;
			_tmp69_ = self->range_duration;
			if (_tmp69_ <= ((gint64) 0)) {
				gchar* msg = NULL;
				gchar* _tmp70_ = NULL;
				const gchar* _tmp71_ = NULL;
				const gchar* _tmp72_ = NULL;
				GError* _tmp73_ = NULL;
				_tmp70_ = g_strdup ("Invalid %s value (start time after end time - forward scan): '%s'");
				msg = _tmp70_;
				_tmp71_ = msg;
				_tmp72_ = range;
				_tmp73_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp71_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp72_);
				_inner_error_ = _tmp73_;
				if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (parsed_range);
					_g_free0 (range);
					_g_object_unref0 (self);
					return NULL;
				} else {
					_g_free0 (msg);
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (parsed_range);
					_g_free0 (range);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (msg);
			}
		} else {
			gint64 _tmp74_ = 0LL;
			gint64 _tmp75_ = 0LL;
			gint64 _tmp76_ = 0LL;
			gint64 _tmp77_ = 0LL;
			_tmp74_ = end;
			self->end_time = _tmp74_;
			_tmp75_ = self->start_time;
			_tmp76_ = self->end_time;
			self->range_duration = _tmp75_ - _tmp76_;
			_tmp77_ = self->range_duration;
			if (_tmp77_ <= ((gint64) 0)) {
				gchar* msg = NULL;
				gchar* _tmp78_ = NULL;
				const gchar* _tmp79_ = NULL;
				const gchar* _tmp80_ = NULL;
				GError* _tmp81_ = NULL;
				_tmp78_ = g_strdup ("Invalid %s value (start time before end time - reverse scan): '%s'");
				msg = _tmp78_;
				_tmp79_ = msg;
				_tmp80_ = range;
				_tmp81_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp79_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp80_);
				_inner_error_ = _tmp81_;
				if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (parsed_range);
					_g_free0 (range);
					_g_object_unref0 (self);
					return NULL;
				} else {
					_g_free0 (msg);
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (parsed_range);
					_g_free0 (range);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (msg);
			}
		}
	} else {
		gint64 _tmp82_ = 0LL;
		self->end_time = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
		_tmp82_ = self->total_duration;
		if (_tmp82_ == RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
			self->range_duration = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
		} else {
			gboolean _tmp83_ = FALSE;
			_tmp83_ = positive_rate;
			if (_tmp83_) {
				gint64 _tmp84_ = 0LL;
				gint64 _tmp85_ = 0LL;
				gint64 _tmp86_ = 0LL;
				_tmp84_ = self->total_duration;
				self->end_time = _tmp84_ - G_TIME_SPAN_MILLISECOND;
				_tmp85_ = self->total_duration;
				_tmp86_ = self->start_time;
				self->range_duration = _tmp85_ - _tmp86_;
			} else {
				gint64 _tmp87_ = 0LL;
				self->end_time = (gint64) 0;
				_tmp87_ = self->start_time;
				self->range_duration = _tmp87_;
			}
		}
	}
	range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (parsed_range);
	_g_free0 (range);
	return self;
}


RygelHTTPTimeSeekRequest* rygel_http_time_seek_request_new (RygelHTTPGet* request, RygelPlaySpeed* speed, GError** error) {
	return rygel_http_time_seek_request_construct (RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, request, speed, error);
}


gchar* rygel_http_time_seek_request_to_string (RygelHTTPTimeSeekRequest* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp5_ = 0LL;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->end_time;
	if (_tmp1_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		gint64 _tmp2_ = 0LL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = self->end_time;
		_tmp3_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_ = NULL;
		_tmp4_ = g_strdup ("*");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = self->start_time;
	_tmp6_ = g_strdup_printf ("HTTPTimeSeekRequest (npt=%lld-%s)", _tmp5_, _tmp0_);
	result = _tmp6_;
	_g_free0 (_tmp0_);
	return result;
}


/**
     * Return true if time-seek is supported.
     *
     * This method utilizes elements associated with the request to determine if
     * a TimeSeekRange request is supported for the given request/resource.
     */
gboolean rygel_http_time_seek_request_supported (RygelHTTPGet* request) {
	gboolean result = FALSE;
	gboolean force_seek = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (request != NULL, FALSE);
	force_seek = FALSE;
	{
		RygelClientHacks* hack = NULL;
		RygelHTTPGet* _tmp0_ = NULL;
		SoupMessage* _tmp1_ = NULL;
		RygelClientHacks* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp0_ = request;
		_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
		_tmp2_ = rygel_client_hacks_create (_tmp1_, &_inner_error_);
		hack = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch51_g_error;
		}
		_tmp3_ = rygel_client_hacks_force_seek (hack);
		force_seek = _tmp3_;
		_g_object_unref0 (hack);
	}
	goto __finally51;
	__catch51_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally51:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp5_ = force_seek;
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		RygelHTTPGet* _tmp6_ = NULL;
		RygelHTTPGetHandler* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp6_ = request;
		_tmp7_ = _tmp6_->handler;
		_tmp8_ = rygel_http_get_handler_supports_time_seek (_tmp7_);
		_tmp4_ = _tmp8_;
	}
	result = _tmp4_;
	return result;
}


/**
     * Return true of the HTTPGet contains a TimeSeekRange request.
     */
gboolean rygel_http_time_seek_request_requested (RygelHTTPGet* request) {
	gboolean result = FALSE;
	gchar* header = NULL;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (request != NULL, FALSE);
	_tmp0_ = request;
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
	_tmp2_ = _tmp1_->request_headers;
	_tmp3_ = soup_message_headers_get_one (_tmp2_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER);
	_tmp4_ = g_strdup (_tmp3_);
	header = _tmp4_;
	result = header != NULL;
	_g_free0 (header);
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


static gboolean rygel_http_time_seek_request_parse_npt_seconds (const gchar* range_token, gint64* value) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar _tmp1_ = '\0';
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (range_token != NULL, FALSE);
	_tmp0_ = range_token;
	_tmp1_ = string_get (_tmp0_, (glong) 0);
	_tmp2_ = g_ascii_isdigit (_tmp1_);
	if (_tmp2_) {
		const gchar* _tmp3_ = NULL;
		gdouble _tmp4_ = 0.0;
		_tmp3_ = range_token;
		_tmp4_ = double_parse (_tmp3_);
		*value = (gint64) (_tmp4_ * G_TIME_SPAN_SECOND);
	} else {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gboolean rygel_http_time_seek_request_parse_npt_time (const gchar* range_token, gint64* value) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint64 seconds_sum = 0LL;
	gint time_factor = 0;
	gchar** time_tokens = NULL;
	gint time_tokens_length1 = 0;
	gint _time_tokens_size_ = 0;
	const gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	const gchar* _tmp11_ = NULL;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint64 _tmp26_ = 0LL;
	_tmp0_ = range_token;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = range_token;
	_tmp2_ = string_index_of (_tmp1_, ":", 0);
	if (_tmp2_ == (-1)) {
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = range_token;
		_tmp4_ = rygel_http_time_seek_request_parse_npt_seconds (_tmp3_, value);
		result = _tmp4_;
		return result;
	}
	seconds_sum = (gint64) 0;
	time_factor = 0;
	seconds_sum = (gint64) 0;
	time_factor = 3600;
	_tmp5_ = range_token;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, ":", 3);
	time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
	time_tokens = _tmp7_;
	time_tokens_length1 = _vala_array_length (_tmp6_);
	_time_tokens_size_ = time_tokens_length1;
	_tmp10_ = time_tokens;
	_tmp10__length1 = time_tokens_length1;
	_tmp11_ = _tmp10_[0];
	if (_tmp11_ == NULL) {
		_tmp9_ = TRUE;
	} else {
		gchar** _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		const gchar* _tmp13_ = NULL;
		_tmp12_ = time_tokens;
		_tmp12__length1 = time_tokens_length1;
		_tmp13_ = _tmp12_[1];
		_tmp9_ = _tmp13_ == NULL;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		gchar** _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		const gchar* _tmp15_ = NULL;
		_tmp14_ = time_tokens;
		_tmp14__length1 = time_tokens_length1;
		_tmp15_ = _tmp14_[2];
		_tmp8_ = _tmp15_ == NULL;
	}
	if (_tmp8_) {
		result = FALSE;
		time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp16_ = time_tokens;
	_tmp16__length1 = time_tokens_length1;
	{
		gchar** time_collection = NULL;
		gint time_collection_length1 = 0;
		gint _time_collection_size_ = 0;
		gint time_it = 0;
		time_collection = _tmp16_;
		time_collection_length1 = _tmp16__length1;
		for (time_it = 0; time_it < _tmp16__length1; time_it = time_it + 1) {
			gchar* _tmp17_ = NULL;
			gchar* time = NULL;
			_tmp17_ = g_strdup (time_collection[time_it]);
			time = _tmp17_;
			{
				const gchar* _tmp18_ = NULL;
				gchar _tmp19_ = '\0';
				gboolean _tmp20_ = FALSE;
				gint _tmp25_ = 0;
				_tmp18_ = time;
				_tmp19_ = string_get (_tmp18_, (glong) 0);
				_tmp20_ = g_ascii_isdigit (_tmp19_);
				if (_tmp20_) {
					gint64 _tmp21_ = 0LL;
					const gchar* _tmp22_ = NULL;
					gdouble _tmp23_ = 0.0;
					gint _tmp24_ = 0;
					_tmp21_ = seconds_sum;
					_tmp22_ = time;
					_tmp23_ = double_parse (_tmp22_);
					_tmp24_ = time_factor;
					seconds_sum = _tmp21_ + ((gint64) ((_tmp23_ * G_TIME_SPAN_SECOND) * _tmp24_));
				} else {
					result = FALSE;
					_g_free0 (time);
					time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_tmp25_ = time_factor;
				time_factor = _tmp25_ / 60;
				_g_free0 (time);
			}
		}
	}
	_tmp26_ = seconds_sum;
	*value = _tmp26_;
	result = TRUE;
	time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void rygel_http_time_seek_request_class_init (RygelHTTPTimeSeekRequestClass * klass) {
	rygel_http_time_seek_request_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_http_time_seek_request_finalize;
}


static void rygel_http_time_seek_request_instance_init (RygelHTTPTimeSeekRequest * self) {
}


static void rygel_http_time_seek_request_finalize (GObject* obj) {
	RygelHTTPTimeSeekRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequest);
	G_OBJECT_CLASS (rygel_http_time_seek_request_parent_class)->finalize (obj);
}


/**
 * This class represents a DLNA TimeSeekRange request.
 *
 * A TimeSeekRange request can only have a time range ("npt=start-end").
 */
GType rygel_http_time_seek_request_get_type (void) {
	static volatile gsize rygel_http_time_seek_request_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_time_seek_request_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTimeSeekRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_time_seek_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTimeSeekRequest), 0, (GInstanceInitFunc) rygel_http_time_seek_request_instance_init, NULL };
		GType rygel_http_time_seek_request_type_id;
		rygel_http_time_seek_request_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK_REQUEST, "RygelHTTPTimeSeekRequest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_time_seek_request_type_id__volatile, rygel_http_time_seek_request_type_id);
	}
	return rygel_http_time_seek_request_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



