/* rygel-media-export-dvd-parser.c generated by valac 0.34.4, the Vala compiler
 * generated from rygel-media-export-dvd-parser.vala, do not modify */

/*
 * Copyright (C) 2013,2015 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <libsoup/soup.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>


#define RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR (rygel_media_export_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor))
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractorClass))

typedef struct _RygelMediaExportExtractor RygelMediaExportExtractor;
typedef struct _RygelMediaExportExtractorClass RygelMediaExportExtractorClass;
typedef struct _RygelMediaExportExtractorPrivate RygelMediaExportExtractorPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER (rygel_media_export_dvd_parser_get_type ())
#define RYGEL_MEDIA_EXPORT_DVD_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER, RygelMediaExportDVDParser))
#define RYGEL_MEDIA_EXPORT_DVD_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER, RygelMediaExportDVDParserClass))
#define RYGEL_MEDIA_EXPORT_IS_DVD_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER))
#define RYGEL_MEDIA_EXPORT_IS_DVD_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER))
#define RYGEL_MEDIA_EXPORT_DVD_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER, RygelMediaExportDVDParserClass))

typedef struct _RygelMediaExportDVDParser RygelMediaExportDVDParser;
typedef struct _RygelMediaExportDVDParserClass RygelMediaExportDVDParserClass;
typedef struct _RygelMediaExportDVDParserPrivate RygelMediaExportDVDParserPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _RygelMediaExportDvdParserRunData RygelMediaExportDvdParserRunData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaExportDvdParserGetInformationData RygelMediaExportDvdParserGetInformationData;

typedef enum  {
	DVD_PARSER_ERROR_GENERAL,
	DVD_PARSER_ERROR_NOT_AVAILABLE
} DVDParserError;
#define DVD_PARSER_ERROR dvd_parser_error_quark ()
struct _RygelMediaExportExtractor {
	GObject parent_instance;
	RygelMediaExportExtractorPrivate * priv;
	GVariantDict* serialized_info;
};

struct _RygelMediaExportExtractorClass {
	GObjectClass parent_class;
	void (*run) (RygelMediaExportExtractor* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelMediaExportExtractor* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaExportDVDParser {
	RygelMediaExportExtractor parent_instance;
	RygelMediaExportDVDParserPrivate * priv;
};

struct _RygelMediaExportDVDParserClass {
	RygelMediaExportExtractorClass parent_class;
};

struct _RygelMediaExportDVDParserPrivate {
	GFile* cache_file;
};

struct _RygelMediaExportDvdParserRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportDVDParser* self;
	const gchar* _tmp0_;
	GError* _tmp1_;
	xmlDoc* doc;
	xmlDoc* _tmp2_;
	xmlDoc* _tmp3_;
	GError* _tmp4_;
	GVariant* id;
	GVariantDict* _tmp5_;
	const GVariantType* _tmp6_;
	GVariant* _tmp7_;
	GVariant* uri;
	GVariantDict* _tmp8_;
	const GVariantType* _tmp9_;
	GVariant* _tmp10_;
	GVariantDict* _tmp11_;
	xmlXPathContext* context;
	xmlDoc* _tmp12_;
	xmlXPathContext* _tmp13_;
	xmlXPathObject* xpo;
	xmlXPathContext* _tmp14_;
	xmlXPathObject* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	xmlXPathObject* _tmp18_;
	xmlXPathObject* _tmp19_;
	xmlXPathObjectType _tmp20_;
	xmlXPathObject* _tmp21_;
	xmlNodeSet* _tmp22_;
	gint _tmp23_;
	SoupURI* new_uri;
	GVariant* _tmp24_;
	const gchar* _tmp25_;
	SoupURI* _tmp26_;
	SoupURI* _tmp27_;
	SoupURI* _tmp28_;
	GVariantDict* _tmp29_;
	GVariantDict* _tmp30_;
	GVariant* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GVariantDict* _tmp37_;
	GVariantDict* _tmp38_;
	SoupURI* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	xmlNode* node;
	xmlXPathObject* _tmp42_;
	xmlNodeSet* _tmp43_;
	xmlNode* _tmp44_;
	xmlNode* it;
	xmlNode* _tmp45_;
	xmlNode* _tmp46_;
	xmlNode* _tmp47_;
	xmlNode* _tmp48_;
	const gchar* _tmp49_;
	gint duration;
	xmlNode* _tmp50_;
	xmlNode* _tmp51_;
	const gchar* _tmp52_;
	gdouble _tmp53_;
	GVariantDict* _tmp54_;
	gint _tmp55_;
	xmlNode* _tmp56_;
	const gchar* _tmp57_;
	gint width;
	xmlNode* _tmp58_;
	xmlNode* _tmp59_;
	const gchar* _tmp60_;
	gint _tmp61_;
	GVariantDict* _tmp62_;
	gint _tmp63_;
	xmlNode* _tmp64_;
	const gchar* _tmp65_;
	gint height;
	xmlNode* _tmp66_;
	xmlNode* _tmp67_;
	const gchar* _tmp68_;
	gint _tmp69_;
	GVariantDict* _tmp70_;
	gint _tmp71_;
	xmlNode* _tmp72_;
	const gchar* _tmp73_;
	gchar* dlna_profile;
	xmlNode* _tmp74_;
	xmlNode* _tmp75_;
	const gchar* _tmp76_;
	gchar* _tmp77_;
	GVariantDict* _tmp78_;
	const gchar* _tmp79_;
	xmlNode* _tmp80_;
	xmlNode* _tmp81_;
	GVariantDict* _tmp82_;
	GVariant* _tmp83_;
	const gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	GVariantDict* _tmp87_;
	GVariantDict* _tmp88_;
	xmlXPathObject* _tmp89_;
	xmlXPathObject* _tmp90_;
	xmlDoc* _tmp91_;
	GError * _inner_error_;
};

struct _RygelMediaExportDvdParserGetInformationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportDVDParser* self;
	xmlDoc* result;
	GFile* _tmp0_;
	gboolean _tmp1_;
	GSubprocessLauncher* launcher;
	GSubprocessLauncher* _tmp2_;
	GSubprocessLauncher* _tmp3_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** args;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gint args_length1;
	gint _args_size_;
	GSubprocess* process;
	GSubprocessLauncher* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GSubprocess* _tmp19_;
	GSubprocess* _tmp20_;
	gboolean _tmp21_;
	GSubprocess* _tmp22_;
	gboolean _tmp23_;
	GSubprocess* _tmp24_;
	gint _tmp25_;
	GFile* _tmp26_;
	GError* _error_;
	GError* _tmp27_;
	const gchar* _tmp28_;
	GError* _tmp29_;
	GFile* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	xmlDoc* _tmp33_;
	xmlDoc* _tmp34_;
	GError * _inner_error_;
};


static gpointer rygel_media_export_dvd_parser_parent_class = NULL;
static gchar* rygel_media_export_dvd_parser_lsdvd_binary_path;
static gchar* rygel_media_export_dvd_parser_lsdvd_binary_path = NULL;

GQuark dvd_parser_error_quark (void);
GType rygel_media_export_extractor_get_type (void) G_GNUC_CONST;
GType rygel_media_export_dvd_parser_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_DVD_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER, RygelMediaExportDVDParserPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_DVD_PARSER_DUMMY_PROPERTY
};
RygelMediaExportDVDParser* rygel_media_export_dvd_parser_new (GFile* file);
RygelMediaExportDVDParser* rygel_media_export_dvd_parser_construct (GType object_type, GFile* file);
gchar* rygel_media_export_dvd_parser_get_cache_path (const gchar* image_path);
static void rygel_media_export_dvd_parser_real_constructed (GObject* base);
GFile* rygel_media_export_extractor_get_file (RygelMediaExportExtractor* self);
static void rygel_media_export_dvd_parser_real_run_data_free (gpointer _data);
static void rygel_media_export_dvd_parser_real_run (RygelMediaExportExtractor* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_dvd_parser_real_run_co (RygelMediaExportDvdParserRunData* _data_);
void rygel_media_export_extractor_run (RygelMediaExportExtractor* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_export_extractor_run_finish (RygelMediaExportExtractor* self, GAsyncResult* _res_, GError** error);
static void rygel_media_export_dvd_parser_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_export_dvd_parser_get_information (RygelMediaExportDVDParser* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
xmlDoc* rygel_media_export_dvd_parser_get_information_finish (RygelMediaExportDVDParser* self, GAsyncResult* _res_, GError** error);
#define RYGEL_MEDIA_EXPORT_SERIALIZER_ID "Id"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_URI "Uri"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_SIZE "Size"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_UPNP_CLASS "UPnPClass"
#define UPNP_CLASS_VIDEO "object.item.videoItem"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_MIME_TYPE "MimeType"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_DURATION "Duration"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_WIDTH "VideoWidth"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_HEIGHT "VideoHeight"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_DLNA_PROFILE "DLNAProfile"
static void _vala_SoupURI_free (SoupURI* self);
#define UPNP_CLASS_PLAYLIST_CONTAINER_DVD "object.container.playlistContainer.DVD"
static void rygel_media_export_dvd_parser_get_information_data_free (gpointer _data);
static gboolean rygel_media_export_dvd_parser_get_information_co (RygelMediaExportDvdParserGetInformationData* _data_);
static void rygel_media_export_dvd_parser_get_information_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_media_export_dvd_parser_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark dvd_parser_error_quark (void) {
	return g_quark_from_static_string ("dvd_parser_error-quark");
}


RygelMediaExportDVDParser* rygel_media_export_dvd_parser_construct (GType object_type, GFile* file) {
	RygelMediaExportDVDParser * self = NULL;
	GFile* _tmp0_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = file;
	self = (RygelMediaExportDVDParser*) g_object_new (object_type, "file", _tmp0_, NULL);
	return self;
}


RygelMediaExportDVDParser* rygel_media_export_dvd_parser_new (GFile* file) {
	return rygel_media_export_dvd_parser_construct (RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER, file);
}


gchar* rygel_media_export_dvd_parser_get_cache_path (const gchar* image_path) {
	gchar* result = NULL;
	const gchar* user_cache = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* id = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* cache_folder = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (image_path != NULL, NULL);
	_tmp0_ = g_get_user_cache_dir ();
	user_cache = _tmp0_;
	_tmp1_ = image_path;
	_tmp2_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp1_, (gsize) -1);
	id = _tmp2_;
	_tmp3_ = g_build_filename (user_cache, "rygel", "dvd-content", NULL);
	cache_folder = _tmp3_;
	g_mkdir_with_parents (cache_folder, 0700);
	_tmp4_ = g_build_filename (cache_folder, id, NULL);
	result = _tmp4_;
	_g_free0 (cache_folder);
	_g_free0 (id);
	return result;
}


static void rygel_media_export_dvd_parser_real_constructed (GObject* base) {
	RygelMediaExportDVDParser * self;
	gchar* path = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	self = (RygelMediaExportDVDParser*) base;
	G_OBJECT_CLASS (rygel_media_export_dvd_parser_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor));
	_tmp0_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = rygel_media_export_dvd_parser_get_cache_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	path = _tmp5_;
	_tmp6_ = g_file_new_for_path (path);
	_g_object_unref0 (self->priv->cache_file);
	self->priv->cache_file = _tmp6_;
	_g_free0 (path);
}


static void rygel_media_export_dvd_parser_real_run_data_free (gpointer _data) {
	RygelMediaExportDvdParserRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportDvdParserRunData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_media_export_dvd_parser_real_run (RygelMediaExportExtractor* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportDVDParser * self;
	RygelMediaExportDvdParserRunData* _data_;
	RygelMediaExportDVDParser* _tmp0_ = NULL;
	self = (RygelMediaExportDVDParser*) base;
	_data_ = g_slice_new0 (RygelMediaExportDvdParserRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_dvd_parser_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_dvd_parser_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_export_dvd_parser_real_run_co (_data_);
}


static void rygel_media_export_dvd_parser_real_run_finish (RygelMediaExportExtractor* base, GAsyncResult* _res_, GError** error) {
	RygelMediaExportDvdParserRunData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_media_export_dvd_parser_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportDvdParserRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_dvd_parser_real_run_co (_data_);
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


static void _vala_SoupURI_free (SoupURI* self) {
	g_boxed_free (soup_uri_get_type (), self);
}


static gboolean rygel_media_export_dvd_parser_real_run_co (RygelMediaExportDvdParserRunData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	RYGEL_MEDIA_EXPORT_EXTRACTOR_CLASS (rygel_media_export_dvd_parser_parent_class)->run (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor), rygel_media_export_dvd_parser_run_ready, _data_);
	return FALSE;
	_state_1:
	RYGEL_MEDIA_EXPORT_EXTRACTOR_CLASS (rygel_media_export_dvd_parser_parent_class)->run_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor), _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = rygel_media_export_dvd_parser_lsdvd_binary_path;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = g_error_new_literal (DVD_PARSER_ERROR, DVD_PARSER_ERROR_NOT_AVAILABLE, "No DVD extractor found");
		_data_->_inner_error_ = _data_->_tmp1_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	rygel_media_export_dvd_parser_get_information (_data_->self, rygel_media_export_dvd_parser_run_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = rygel_media_export_dvd_parser_get_information_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	_data_->doc = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->doc;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = g_error_new_literal (DVD_PARSER_ERROR, DVD_PARSER_ERROR_GENERAL, "Failed to read cache file");
		_data_->_inner_error_ = _data_->_tmp4_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = G_VARIANT_TYPE_STRING;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = g_variant_dict_lookup_value (_data_->_tmp5_, RYGEL_MEDIA_EXPORT_SERIALIZER_ID, _data_->_tmp6_);
	_data_->id = _data_->_tmp7_;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = G_VARIANT_TYPE_STRING;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = g_variant_dict_lookup_value (_data_->_tmp8_, RYGEL_MEDIA_EXPORT_SERIALIZER_URI, _data_->_tmp9_);
	_data_->uri = _data_->_tmp10_;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
	g_variant_dict_insert (_data_->_tmp11_, RYGEL_MEDIA_EXPORT_SERIALIZER_SIZE, "i", -1, NULL);
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->doc;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = xmlXPathNewContext (_data_->_tmp12_);
	_data_->context = _data_->_tmp13_;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->context;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = xmlXPathEval ((xmlChar*) "/lsdvd/track", _data_->_tmp14_);
	_data_->xpo = _data_->_tmp15_;
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->xpo;
	if (_data_->_tmp18_ != NULL) {
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->xpo;
		_data_->_tmp20_ = 0;
		_data_->_tmp20_ = _data_->_tmp19_->type;
		_data_->_tmp17_ = _data_->_tmp20_ == XPATH_NODESET;
	} else {
		_data_->_tmp17_ = FALSE;
	}
	if (_data_->_tmp17_) {
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->xpo;
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->_tmp21_->nodesetval;
		_data_->_tmp23_ = 0;
		_data_->_tmp23_ = xmlXPathNodeSetGetLength (_data_->_tmp22_);
		_data_->_tmp16_ = _data_->_tmp23_ == 1;
	} else {
		_data_->_tmp16_ = FALSE;
	}
	if (_data_->_tmp16_) {
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _data_->uri;
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = g_variant_get_string (_data_->_tmp24_, NULL);
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = soup_uri_new (_data_->_tmp25_);
		_data_->new_uri = _data_->_tmp26_;
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _data_->new_uri;
		soup_uri_set_scheme (_data_->_tmp27_, "dvd");
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = _data_->new_uri;
		soup_uri_set_query (_data_->_tmp28_, "title=1");
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		g_variant_dict_insert (_data_->_tmp29_, RYGEL_MEDIA_EXPORT_SERIALIZER_UPNP_CLASS, "s", UPNP_CLASS_VIDEO, NULL);
		_data_->_tmp30_ = NULL;
		_data_->_tmp30_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp31_ = NULL;
		_data_->_tmp31_ = _data_->id;
		_data_->_tmp32_ = NULL;
		_data_->_tmp32_ = g_variant_get_string (_data_->_tmp31_, NULL);
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = g_strconcat ("dvd-track:", _data_->_tmp32_, NULL);
		_data_->_tmp34_ = NULL;
		_data_->_tmp34_ = _data_->_tmp33_;
		_data_->_tmp35_ = NULL;
		_data_->_tmp35_ = g_strconcat (_data_->_tmp34_, ":0", NULL);
		_data_->_tmp36_ = NULL;
		_data_->_tmp36_ = _data_->_tmp35_;
		g_variant_dict_insert (_data_->_tmp30_, RYGEL_MEDIA_EXPORT_SERIALIZER_ID, "s", _data_->_tmp36_, NULL);
		_g_free0 (_data_->_tmp36_);
		_g_free0 (_data_->_tmp34_);
		_data_->_tmp37_ = NULL;
		_data_->_tmp37_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		g_variant_dict_insert (_data_->_tmp37_, RYGEL_MEDIA_EXPORT_SERIALIZER_MIME_TYPE, "s", "video/mpeg", NULL);
		_data_->_tmp38_ = NULL;
		_data_->_tmp38_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp39_ = NULL;
		_data_->_tmp39_ = _data_->new_uri;
		_data_->_tmp40_ = NULL;
		_data_->_tmp40_ = soup_uri_to_string (_data_->_tmp39_, FALSE);
		_data_->_tmp41_ = NULL;
		_data_->_tmp41_ = _data_->_tmp40_;
		g_variant_dict_insert (_data_->_tmp38_, RYGEL_MEDIA_EXPORT_SERIALIZER_URI, "s", _data_->_tmp41_, NULL);
		_g_free0 (_data_->_tmp41_);
		_data_->_tmp42_ = NULL;
		_data_->_tmp42_ = _data_->xpo;
		_data_->_tmp43_ = NULL;
		_data_->_tmp43_ = _data_->_tmp42_->nodesetval;
		_data_->_tmp44_ = NULL;
		_data_->_tmp44_ = xmlXPathNodeSetItem (_data_->_tmp43_, 0);
		_data_->node = _data_->_tmp44_;
		_data_->_tmp45_ = NULL;
		_data_->_tmp45_ = _data_->node;
		_data_->_tmp46_ = NULL;
		_data_->_tmp46_ = _data_->_tmp45_->children;
		_data_->it = _data_->_tmp46_;
		while (TRUE) {
			_data_->_tmp47_ = NULL;
			_data_->_tmp47_ = _data_->it;
			if (!(_data_->_tmp47_ != NULL)) {
				break;
			}
			_data_->_tmp48_ = NULL;
			_data_->_tmp48_ = _data_->it;
			_data_->_tmp49_ = NULL;
			_data_->_tmp49_ = _data_->_tmp48_->name;
			if (g_strcmp0 (_data_->_tmp49_, "length") == 0) {
				_data_->_tmp50_ = NULL;
				_data_->_tmp50_ = _data_->it;
				_data_->_tmp51_ = NULL;
				_data_->_tmp51_ = _data_->_tmp50_->children;
				_data_->_tmp52_ = NULL;
				_data_->_tmp52_ = _data_->_tmp51_->content;
				_data_->_tmp53_ = 0.0;
				_data_->_tmp53_ = double_parse (_data_->_tmp52_);
				_data_->duration = (gint) _data_->_tmp53_;
				_data_->_tmp54_ = NULL;
				_data_->_tmp54_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
				_data_->_tmp55_ = 0;
				_data_->_tmp55_ = _data_->duration;
				g_variant_dict_insert (_data_->_tmp54_, RYGEL_MEDIA_EXPORT_SERIALIZER_DURATION, "i", _data_->_tmp55_, NULL);
			} else {
				_data_->_tmp56_ = NULL;
				_data_->_tmp56_ = _data_->it;
				_data_->_tmp57_ = NULL;
				_data_->_tmp57_ = _data_->_tmp56_->name;
				if (g_strcmp0 (_data_->_tmp57_, "width") == 0) {
					_data_->_tmp58_ = NULL;
					_data_->_tmp58_ = _data_->it;
					_data_->_tmp59_ = NULL;
					_data_->_tmp59_ = _data_->_tmp58_->children;
					_data_->_tmp60_ = NULL;
					_data_->_tmp60_ = _data_->_tmp59_->content;
					_data_->_tmp61_ = 0;
					_data_->_tmp61_ = atoi (_data_->_tmp60_);
					_data_->width = _data_->_tmp61_;
					_data_->_tmp62_ = NULL;
					_data_->_tmp62_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
					_data_->_tmp63_ = 0;
					_data_->_tmp63_ = _data_->width;
					g_variant_dict_insert (_data_->_tmp62_, RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_WIDTH, "i", _data_->_tmp63_, NULL);
				} else {
					_data_->_tmp64_ = NULL;
					_data_->_tmp64_ = _data_->it;
					_data_->_tmp65_ = NULL;
					_data_->_tmp65_ = _data_->_tmp64_->name;
					if (g_strcmp0 (_data_->_tmp65_, "height") == 0) {
						_data_->_tmp66_ = NULL;
						_data_->_tmp66_ = _data_->it;
						_data_->_tmp67_ = NULL;
						_data_->_tmp67_ = _data_->_tmp66_->children;
						_data_->_tmp68_ = NULL;
						_data_->_tmp68_ = _data_->_tmp67_->content;
						_data_->_tmp69_ = 0;
						_data_->_tmp69_ = atoi (_data_->_tmp68_);
						_data_->height = _data_->_tmp69_;
						_data_->_tmp70_ = NULL;
						_data_->_tmp70_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
						_data_->_tmp71_ = 0;
						_data_->_tmp71_ = _data_->height;
						g_variant_dict_insert (_data_->_tmp70_, RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_HEIGHT, "i", _data_->_tmp71_, NULL);
					} else {
						_data_->_tmp72_ = NULL;
						_data_->_tmp72_ = _data_->it;
						_data_->_tmp73_ = NULL;
						_data_->_tmp73_ = _data_->_tmp72_->name;
						if (g_strcmp0 (_data_->_tmp73_, "format") == 0) {
							_data_->_tmp74_ = NULL;
							_data_->_tmp74_ = _data_->it;
							_data_->_tmp75_ = NULL;
							_data_->_tmp75_ = _data_->_tmp74_->children;
							_data_->_tmp76_ = NULL;
							_data_->_tmp76_ = _data_->_tmp75_->content;
							_data_->_tmp77_ = NULL;
							_data_->_tmp77_ = g_strconcat ("MPEG_PS_", _data_->_tmp76_, NULL);
							_data_->dlna_profile = _data_->_tmp77_;
							_data_->_tmp78_ = NULL;
							_data_->_tmp78_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
							_data_->_tmp79_ = NULL;
							_data_->_tmp79_ = _data_->dlna_profile;
							g_variant_dict_insert (_data_->_tmp78_, RYGEL_MEDIA_EXPORT_SERIALIZER_DLNA_PROFILE, "s", _data_->_tmp79_, NULL);
							_g_free0 (_data_->dlna_profile);
						}
					}
				}
			}
			_data_->_tmp80_ = NULL;
			_data_->_tmp80_ = _data_->it;
			_data_->_tmp81_ = NULL;
			_data_->_tmp81_ = _data_->_tmp80_->next;
			_data_->it = _data_->_tmp81_;
		}
		__vala_SoupURI_free0 (_data_->new_uri);
	} else {
		_data_->_tmp82_ = NULL;
		_data_->_tmp82_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		_data_->_tmp83_ = NULL;
		_data_->_tmp83_ = _data_->id;
		_data_->_tmp84_ = NULL;
		_data_->_tmp84_ = g_variant_get_string (_data_->_tmp83_, NULL);
		_data_->_tmp85_ = NULL;
		_data_->_tmp85_ = g_strconcat ("dvd:", _data_->_tmp84_, NULL);
		_data_->_tmp86_ = NULL;
		_data_->_tmp86_ = _data_->_tmp85_;
		g_variant_dict_insert (_data_->_tmp82_, RYGEL_MEDIA_EXPORT_SERIALIZER_ID, "s", _data_->_tmp86_, NULL);
		_g_free0 (_data_->_tmp86_);
		_data_->_tmp87_ = NULL;
		_data_->_tmp87_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		g_variant_dict_insert (_data_->_tmp87_, RYGEL_MEDIA_EXPORT_SERIALIZER_UPNP_CLASS, "s", UPNP_CLASS_PLAYLIST_CONTAINER_DVD, NULL);
		_data_->_tmp88_ = NULL;
		_data_->_tmp88_ = ((RygelMediaExportExtractor*) _data_->self)->serialized_info;
		g_variant_dict_insert (_data_->_tmp88_, RYGEL_MEDIA_EXPORT_SERIALIZER_MIME_TYPE, "s", "application/x-cd-image", NULL);
	}
	_data_->_tmp89_ = NULL;
	_data_->_tmp89_ = _data_->xpo;
	if (_data_->_tmp89_ != NULL) {
		_data_->_tmp90_ = NULL;
		_data_->_tmp90_ = _data_->xpo;
		xmlXPathFreeObject (_data_->_tmp90_);
	}
	_data_->_tmp91_ = NULL;
	_data_->_tmp91_ = _data_->doc;
	xmlFreeDoc (_data_->_tmp91_);
	_xmlXPathFreeContext0 (_data_->context);
	_g_variant_unref0 (_data_->uri);
	_g_variant_unref0 (_data_->id);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_media_export_dvd_parser_get_information_data_free (gpointer _data) {
	RygelMediaExportDvdParserGetInformationData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportDvdParserGetInformationData, _data_);
}


void rygel_media_export_dvd_parser_get_information (RygelMediaExportDVDParser* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportDvdParserGetInformationData* _data_;
	RygelMediaExportDVDParser* _tmp0_ = NULL;
	_data_ = g_slice_new0 (RygelMediaExportDvdParserGetInformationData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_dvd_parser_get_information);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_dvd_parser_get_information_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_export_dvd_parser_get_information_co (_data_);
}


xmlDoc* rygel_media_export_dvd_parser_get_information_finish (RygelMediaExportDVDParser* self, GAsyncResult* _res_, GError** error) {
	xmlDoc* result;
	RygelMediaExportDvdParserGetInformationData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_export_dvd_parser_get_information_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportDvdParserGetInformationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_dvd_parser_get_information_co (_data_);
}


static gboolean rygel_media_export_dvd_parser_get_information_co (RygelMediaExportDvdParserGetInformationData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->cache_file;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = g_file_query_exists (_data_->_tmp0_, NULL);
	if (!_data_->_tmp1_) {
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = g_subprocess_launcher_new (G_SUBPROCESS_FLAGS_STDERR_SILENCE);
		_data_->launcher = _data_->_tmp2_;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->launcher;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->self->priv->cache_file;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = g_file_get_path (_data_->_tmp4_);
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->_tmp5_;
		g_subprocess_launcher_set_stdout_file_path (_data_->_tmp3_, _data_->_tmp6_);
		_g_free0 (_data_->_tmp6_);
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = rygel_media_export_dvd_parser_lsdvd_binary_path;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = g_strdup (_data_->_tmp7_);
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = g_strdup ("-Ox");
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = g_strdup ("-a");
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = g_strdup ("-v");
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = g_strdup ("-q");
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = rygel_media_export_extractor_get_file ((RygelMediaExportExtractor*) _data_->self);
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = g_file_get_path (_data_->_tmp14_);
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = g_new0 (gchar*, 7 + 1);
		_data_->_tmp16_[0] = _data_->_tmp8_;
		_data_->_tmp16_[1] = _data_->_tmp9_;
		_data_->_tmp16_[2] = _data_->_tmp10_;
		_data_->_tmp16_[3] = _data_->_tmp11_;
		_data_->_tmp16_[4] = _data_->_tmp12_;
		_data_->_tmp16_[5] = _data_->_tmp15_;
		_data_->_tmp16_[6] = NULL;
		_data_->args_length1 = 0;
		_data_->_args_size_ = 0;
		_data_->args = _data_->_tmp16_;
		_data_->args_length1 = 7;
		_data_->_args_size_ = _data_->args_length1;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->launcher;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18__length1 = 0;
		_data_->_tmp18_ = _data_->args;
		_data_->_tmp18__length1 = _data_->args_length1;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = g_subprocess_launcher_spawnv (_data_->_tmp17_, _data_->_tmp18_, &_data_->_inner_error_);
		_data_->process = _data_->_tmp19_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->launcher);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->process;
		_data_->_state_ = 1;
		g_subprocess_wait_async (_data_->_tmp20_, NULL, rygel_media_export_dvd_parser_get_information_ready, _data_);
		return FALSE;
		_state_1:
		g_subprocess_wait_finish (_data_->_tmp20_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->process);
			_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->launcher);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->process;
		_data_->_tmp23_ = FALSE;
		_data_->_tmp23_ = g_subprocess_get_if_exited (_data_->_tmp22_);
		if (_data_->_tmp23_) {
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = _data_->process;
			_data_->_tmp25_ = 0;
			_data_->_tmp25_ = g_subprocess_get_exit_status (_data_->_tmp24_);
			_data_->_tmp21_ = _data_->_tmp25_ == 0;
		} else {
			_data_->_tmp21_ = FALSE;
		}
		if (!_data_->_tmp21_) {
			{
				_data_->_tmp26_ = NULL;
				_data_->_tmp26_ = _data_->self->priv->cache_file;
				g_file_delete (_data_->_tmp26_, NULL, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					goto __catch6_g_error;
				}
			}
			goto __finally6;
			__catch6_g_error:
			{
				_data_->_error_ = _data_->_inner_error_;
				_data_->_inner_error_ = NULL;
				_data_->_tmp27_ = NULL;
				_data_->_tmp27_ = _data_->_error_;
				_data_->_tmp28_ = NULL;
				_data_->_tmp28_ = _data_->_tmp27_->message;
				g_debug ("rygel-media-export-dvd-parser.vala:171: Failed to delete cache file: %" \
"s", _data_->_tmp28_);
				_g_error_free0 (_data_->_error_);
			}
			__finally6:
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->process);
				_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (_data_->launcher);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp29_ = NULL;
			_data_->_tmp29_ = g_error_new_literal (DVD_PARSER_ERROR, DVD_PARSER_ERROR_GENERAL, "lsdvd did die or file is not a DVD");
			_data_->_inner_error_ = _data_->_tmp29_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->process);
			_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->launcher);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->process);
		_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_data_->launcher);
	}
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _data_->self->priv->cache_file;
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = g_file_get_path (_data_->_tmp30_);
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = _data_->_tmp31_;
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = xmlReadFile (_data_->_tmp32_, NULL, (gint) ((((XML_PARSE_NOERROR | XML_PARSE_NOWARNING) | XML_PARSE_RECOVER) | XML_PARSE_NOENT) | XML_PARSE_NONET));
	_data_->_tmp34_ = NULL;
	_data_->_tmp34_ = _data_->_tmp33_;
	_g_free0 (_data_->_tmp32_);
	_data_->result = _data_->_tmp34_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_media_export_dvd_parser_class_init (RygelMediaExportDVDParserClass * klass) {
	gchar* path = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	rygel_media_export_dvd_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportDVDParserPrivate));
	((GObjectClass *) klass)->constructed = rygel_media_export_dvd_parser_real_constructed;
	((RygelMediaExportExtractorClass *) klass)->run = rygel_media_export_dvd_parser_real_run;
	((RygelMediaExportExtractorClass *) klass)->run_finish = rygel_media_export_dvd_parser_real_run_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_dvd_parser_finalize;
	_tmp0_ = g_find_program_in_path ("lsdvd");
	path = _tmp0_;
	_tmp1_ = path;
	if (_tmp1_ == NULL) {
		gchar* msg = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = _ ("Failed to find lsdvd binary in path. DVD extraction will not be availa" \
"ble");
		_tmp3_ = g_strdup (_tmp2_);
		msg = _tmp3_;
		_tmp4_ = msg;
		g_warning ("rygel-media-export-dvd-parser.vala:40: %s", _tmp4_);
		_g_free0 (msg);
	}
	_tmp5_ = path;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (rygel_media_export_dvd_parser_lsdvd_binary_path);
	rygel_media_export_dvd_parser_lsdvd_binary_path = _tmp6_;
	_g_free0 (path);
}


static void rygel_media_export_dvd_parser_instance_init (RygelMediaExportDVDParser * self) {
	self->priv = RYGEL_MEDIA_EXPORT_DVD_PARSER_GET_PRIVATE (self);
}


static void rygel_media_export_dvd_parser_finalize (GObject* obj) {
	RygelMediaExportDVDParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER, RygelMediaExportDVDParser);
	_g_object_unref0 (self->priv->cache_file);
	G_OBJECT_CLASS (rygel_media_export_dvd_parser_parent_class)->finalize (obj);
}


GType rygel_media_export_dvd_parser_get_type (void) {
	static volatile gsize rygel_media_export_dvd_parser_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_dvd_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportDVDParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_dvd_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportDVDParser), 0, (GInstanceInitFunc) rygel_media_export_dvd_parser_instance_init, NULL };
		GType rygel_media_export_dvd_parser_type_id;
		rygel_media_export_dvd_parser_type_id = g_type_register_static (RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, "RygelMediaExportDVDParser", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_dvd_parser_type_id__volatile, rygel_media_export_dvd_parser_type_id);
	}
	return rygel_media_export_dvd_parser_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



