/* minefield.c generated by valac 0.34.4, the Vala compiler
 * generated from minefield.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define TYPE_FLAG_TYPE (flag_type_get_type ())

#define TYPE_LOCATION (location_get_type ())
#define LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOCATION, Location))
#define LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOCATION, LocationClass))
#define IS_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOCATION))
#define IS_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOCATION))
#define LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOCATION, LocationClass))

typedef struct _Location Location;
typedef struct _LocationClass LocationClass;
typedef struct _LocationPrivate LocationPrivate;

#define TYPE_NEIGHBOUR (neighbour_get_type ())
typedef struct _Neighbour Neighbour;

#define TYPE_MINEFIELD (minefield_get_type ())
#define MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD, Minefield))
#define MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD, MinefieldClass))
#define IS_MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD))
#define IS_MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD))
#define MINEFIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD, MinefieldClass))

typedef struct _Minefield Minefield;
typedef struct _MinefieldClass MinefieldClass;
typedef struct _MinefieldPrivate MinefieldPrivate;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	FLAG_TYPE_NONE,
	FLAG_TYPE_FLAG,
	FLAG_TYPE_MAYBE
} FlagType;

struct _Location {
	GObject parent_instance;
	LocationPrivate * priv;
	gboolean has_mine;
	gboolean cleared;
	FlagType flag;
	gint adjacent_mines;
};

struct _LocationClass {
	GObjectClass parent_class;
};

struct _Neighbour {
	gint x;
	gint y;
};

struct _Minefield {
	GObject parent_instance;
	MinefieldPrivate * priv;
	guint width;
	guint height;
	guint n_mines;
	Location** locations;
	gint locations_length1;
	gint locations_length2;
	gboolean exploded;
	gboolean placed_mines;
	gboolean _use_autoflag;
};

struct _MinefieldClass {
	GObjectClass parent_class;
};

struct _MinefieldPrivate {
	guint _n_cleared;
	guint _n_flags;
	gdouble clock_elapsed;
	GTimer* clock;
	guint clock_timeout;
	gboolean _paused;
};


static gpointer location_parent_class = NULL;
static gpointer minefield_parent_class = NULL;

GType flag_type_get_type (void) G_GNUC_CONST;
GType location_get_type (void) G_GNUC_CONST;
enum  {
	LOCATION_DUMMY_PROPERTY
};
Location* location_new (void);
Location* location_construct (GType object_type);
static void location_finalize (GObject* obj);
GType neighbour_get_type (void) G_GNUC_CONST;
Neighbour* neighbour_dup (const Neighbour* self);
void neighbour_free (Neighbour* self);
GType minefield_get_type (void) G_GNUC_CONST;
#define MINEFIELD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MINEFIELD, MinefieldPrivate))
enum  {
	MINEFIELD_DUMMY_PROPERTY,
	MINEFIELD_N_CLEARED,
	MINEFIELD_IS_COMPLETE,
	MINEFIELD_N_FLAGS,
	MINEFIELD_USE_AUTOFLAG,
	MINEFIELD_ELAPSED,
	MINEFIELD_PAUSED
};
Minefield* minefield_new (guint width, guint height, guint n_mines);
Minefield* minefield_construct (GType object_type, guint width, guint height, guint n_mines);
gboolean minefield_is_clock_started (Minefield* self);
gdouble minefield_get_elapsed (Minefield* self);
gboolean minefield_has_mine (Minefield* self, guint x, guint y);
gboolean minefield_is_cleared (Minefield* self, guint x, guint y);
gboolean minefield_is_location (Minefield* self, gint x, gint y);
void minefield_multi_release (Minefield* self, guint x, guint y);
FlagType minefield_get_flag (Minefield* self, guint x, guint y);
guint minefield_get_n_adjacent_mines (Minefield* self, guint x, guint y);
gboolean minefield_get_use_autoflag (Minefield* self);
void minefield_clear_mine (Minefield* self, guint x, guint y);
void minefield_set_flag (Minefield* self, guint x, guint y, FlagType flag);
static void minefield_place_mines (Minefield* self, guint x, guint y);
static void minefield_start_clock (Minefield* self);
static void minefield_clear_mines_recursive (Minefield* self, guint x, guint y);
static void minefield_stop_clock (Minefield* self);
gboolean minefield_get_is_complete (Minefield* self);
guint minefield_get_n_cleared (Minefield* self);
void minefield_set_n_cleared (Minefield* self, guint value);
guint minefield_get_n_flags (Minefield* self);
void minefield_set_n_flags (Minefield* self, guint value);
gboolean minefield_has_flag_warning (Minefield* self, guint x, guint y);
static void minefield_start_timer (Minefield* self);
static gboolean minefield_timeout_cb (Minefield* self);
static gboolean _minefield_timeout_cb_gsource_func (gpointer self);
static void minefield_continue_clock (Minefield* self);
void minefield_set_use_autoflag (Minefield* self, gboolean value);
gboolean minefield_get_paused (Minefield* self);
void minefield_set_paused (Minefield* self, gboolean value);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void minefield_finalize (GObject* obj);
static void _vala_minefield_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_minefield_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const Neighbour neighbour_map[8] = {{-1, 1}, {0, 1}, {1, 1}, {1, 0}, {1, -1}, {0, -1}, {-1, -1}, {-1, 0}};

GType flag_type_get_type (void) {
	static volatile gsize flag_type_type_id__volatile = 0;
	if (g_once_init_enter (&flag_type_type_id__volatile)) {
		static const GEnumValue values[] = {{FLAG_TYPE_NONE, "FLAG_TYPE_NONE", "none"}, {FLAG_TYPE_FLAG, "FLAG_TYPE_FLAG", "flag"}, {FLAG_TYPE_MAYBE, "FLAG_TYPE_MAYBE", "maybe"}, {0, NULL, NULL}};
		GType flag_type_type_id;
		flag_type_type_id = g_enum_register_static ("FlagType", values);
		g_once_init_leave (&flag_type_type_id__volatile, flag_type_type_id);
	}
	return flag_type_type_id__volatile;
}


Location* location_construct (GType object_type) {
	Location * self = NULL;
	self = (Location*) g_object_new (object_type, NULL);
	return self;
}


Location* location_new (void) {
	return location_construct (TYPE_LOCATION);
}


static void location_class_init (LocationClass * klass) {
	location_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = location_finalize;
}


static void location_instance_init (Location * self) {
	self->has_mine = FALSE;
	self->cleared = FALSE;
	self->flag = FLAG_TYPE_NONE;
	self->adjacent_mines = 0;
}


static void location_finalize (GObject* obj) {
	Location * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LOCATION, Location);
	G_OBJECT_CLASS (location_parent_class)->finalize (obj);
}


GType location_get_type (void) {
	static volatile gsize location_type_id__volatile = 0;
	if (g_once_init_enter (&location_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LocationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) location_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Location), 0, (GInstanceInitFunc) location_instance_init, NULL };
		GType location_type_id;
		location_type_id = g_type_register_static (G_TYPE_OBJECT, "Location", &g_define_type_info, 0);
		g_once_init_leave (&location_type_id__volatile, location_type_id);
	}
	return location_type_id__volatile;
}


Neighbour* neighbour_dup (const Neighbour* self) {
	Neighbour* dup;
	dup = g_new0 (Neighbour, 1);
	memcpy (dup, self, sizeof (Neighbour));
	return dup;
}


void neighbour_free (Neighbour* self) {
	g_free (self);
}


GType neighbour_get_type (void) {
	static volatile gsize neighbour_type_id__volatile = 0;
	if (g_once_init_enter (&neighbour_type_id__volatile)) {
		GType neighbour_type_id;
		neighbour_type_id = g_boxed_type_register_static ("Neighbour", (GBoxedCopyFunc) neighbour_dup, (GBoxedFreeFunc) neighbour_free);
		g_once_init_leave (&neighbour_type_id__volatile, neighbour_type_id);
	}
	return neighbour_type_id__volatile;
}


Minefield* minefield_construct (GType object_type, guint width, guint height, guint n_mines) {
	Minefield * self = NULL;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	Location** _tmp2_ = NULL;
	guint _tmp16_ = 0U;
	guint _tmp17_ = 0U;
	guint _tmp18_ = 0U;
	self = (Minefield*) g_object_new (object_type, NULL);
	_tmp0_ = width;
	_tmp1_ = height;
	_tmp2_ = g_new0 (Location*, (_tmp0_ * _tmp1_) + 1);
	self->locations = (_vala_array_free (self->locations, self->locations_length1 * self->locations_length2, (GDestroyNotify) g_object_unref), NULL);
	self->locations = _tmp2_;
	self->locations_length1 = _tmp0_;
	self->locations_length2 = _tmp1_;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				guint _tmp6_ = 0U;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = x;
					x = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = x;
				_tmp6_ = width;
				if (!(((guint) _tmp5_) < _tmp6_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							gint _tmp9_ = 0;
							guint _tmp10_ = 0U;
							Location** _tmp11_ = NULL;
							gint _tmp11__length1 = 0;
							gint _tmp11__length2 = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							Location* _tmp14_ = NULL;
							Location* _tmp15_ = NULL;
							if (!_tmp7_) {
								gint _tmp8_ = 0;
								_tmp8_ = y;
								y = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = y;
							_tmp10_ = height;
							if (!(((guint) _tmp9_) < _tmp10_)) {
								break;
							}
							_tmp11_ = self->locations;
							_tmp11__length1 = self->locations_length1;
							_tmp11__length2 = self->locations_length2;
							_tmp12_ = x;
							_tmp13_ = y;
							_tmp14_ = location_new ();
							_g_object_unref0 (_tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_]);
							_tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_] = _tmp14_;
							_tmp15_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
						}
					}
				}
			}
		}
	}
	_tmp16_ = width;
	self->width = _tmp16_;
	_tmp17_ = height;
	self->height = _tmp17_;
	_tmp18_ = n_mines;
	self->n_mines = _tmp18_;
	return self;
}


Minefield* minefield_new (guint width, guint height, guint n_mines) {
	return minefield_construct (TYPE_MINEFIELD, width, height, n_mines);
}


gboolean minefield_is_clock_started (Minefield* self) {
	gboolean result = FALSE;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = minefield_get_elapsed (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ > ((gdouble) 0);
	return result;
}


gboolean minefield_has_mine (Minefield* self, guint x, guint y) {
	gboolean result = FALSE;
	Location** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	Location* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->locations;
	_tmp0__length1 = self->locations_length1;
	_tmp0__length2 = self->locations_length2;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = _tmp3_->has_mine;
	result = _tmp4_;
	return result;
}


gboolean minefield_is_cleared (Minefield* self, guint x, guint y) {
	gboolean result = FALSE;
	Location** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	Location* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->locations;
	_tmp0__length1 = self->locations_length1;
	_tmp0__length2 = self->locations_length2;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = _tmp3_->cleared;
	result = _tmp4_;
	return result;
}


gboolean minefield_is_location (Minefield* self, gint x, gint y) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = x;
	if (_tmp3_ >= 0) {
		gint _tmp4_ = 0;
		_tmp4_ = y;
		_tmp2_ = _tmp4_ >= 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint _tmp5_ = 0;
		guint _tmp6_ = 0U;
		_tmp5_ = x;
		_tmp6_ = self->width;
		_tmp1_ = ((guint) _tmp5_) < _tmp6_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp7_ = 0;
		guint _tmp8_ = 0U;
		_tmp7_ = y;
		_tmp8_ = self->height;
		_tmp0_ = ((guint) _tmp7_) < _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


void minefield_multi_release (Minefield* self, guint x, guint y) {
	gboolean _tmp0_ = FALSE;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	gboolean _tmp3_ = FALSE;
	guint n_mines = 0U;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	guint n_flags = 0U;
	guint n_unknown = 0U;
	gboolean do_clear = FALSE;
	guint _tmp27_ = 0U;
	guint _tmp28_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = minefield_is_cleared (self, _tmp1_, _tmp2_);
	if (!_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		guint _tmp4_ = 0U;
		guint _tmp5_ = 0U;
		FlagType _tmp6_ = 0;
		_tmp4_ = x;
		_tmp5_ = y;
		_tmp6_ = minefield_get_flag (self, _tmp4_, _tmp5_);
		_tmp0_ = _tmp6_ == FLAG_TYPE_FLAG;
	}
	if (_tmp0_) {
		return;
	}
	_tmp7_ = x;
	_tmp8_ = y;
	_tmp9_ = minefield_get_n_adjacent_mines (self, _tmp7_, _tmp8_);
	n_mines = _tmp9_;
	n_flags = (guint) 0;
	n_unknown = (guint) 0;
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				gint nx = 0;
				guint _tmp10_ = 0U;
				Neighbour _tmp11_ = {0};
				gint _tmp12_ = 0;
				gint ny = 0;
				guint _tmp13_ = 0U;
				Neighbour _tmp14_ = {0};
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				gboolean _tmp18_ = FALSE;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				FlagType _tmp21_ = 0;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
				gboolean _tmp25_ = FALSE;
				_tmp10_ = x;
				_tmp11_ = neighbour;
				_tmp12_ = _tmp11_.x;
				nx = ((gint) _tmp10_) + _tmp12_;
				_tmp13_ = y;
				_tmp14_ = neighbour;
				_tmp15_ = _tmp14_.y;
				ny = ((gint) _tmp13_) + _tmp15_;
				_tmp16_ = nx;
				_tmp17_ = ny;
				_tmp18_ = minefield_is_location (self, _tmp16_, _tmp17_);
				if (!_tmp18_) {
					continue;
				}
				_tmp19_ = nx;
				_tmp20_ = ny;
				_tmp21_ = minefield_get_flag (self, (guint) _tmp19_, (guint) _tmp20_);
				if (_tmp21_ == FLAG_TYPE_FLAG) {
					guint _tmp22_ = 0U;
					_tmp22_ = n_flags;
					n_flags = _tmp22_ + 1;
				}
				_tmp23_ = nx;
				_tmp24_ = ny;
				_tmp25_ = minefield_is_cleared (self, (guint) _tmp23_, (guint) _tmp24_);
				if (!_tmp25_) {
					guint _tmp26_ = 0U;
					_tmp26_ = n_unknown;
					n_unknown = _tmp26_ + 1;
				}
			}
		}
	}
	do_clear = FALSE;
	_tmp27_ = n_mines;
	_tmp28_ = n_flags;
	if (_tmp27_ == _tmp28_) {
		do_clear = TRUE;
	} else {
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		_tmp30_ = minefield_get_use_autoflag (self);
		_tmp31_ = _tmp30_;
		if (_tmp31_) {
			guint _tmp32_ = 0U;
			guint _tmp33_ = 0U;
			_tmp32_ = n_unknown;
			_tmp33_ = n_mines;
			_tmp29_ = _tmp32_ == _tmp33_;
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			do_clear = FALSE;
		} else {
			return;
		}
	}
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				gint nx = 0;
				guint _tmp34_ = 0U;
				Neighbour _tmp35_ = {0};
				gint _tmp36_ = 0;
				gint ny = 0;
				guint _tmp37_ = 0U;
				Neighbour _tmp38_ = {0};
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				gint _tmp41_ = 0;
				gboolean _tmp42_ = FALSE;
				gboolean _tmp43_ = FALSE;
				gboolean _tmp44_ = FALSE;
				_tmp34_ = x;
				_tmp35_ = neighbour;
				_tmp36_ = _tmp35_.x;
				nx = ((gint) _tmp34_) + _tmp36_;
				_tmp37_ = y;
				_tmp38_ = neighbour;
				_tmp39_ = _tmp38_.y;
				ny = ((gint) _tmp37_) + _tmp39_;
				_tmp40_ = nx;
				_tmp41_ = ny;
				_tmp42_ = minefield_is_location (self, _tmp40_, _tmp41_);
				if (!_tmp42_) {
					continue;
				}
				_tmp44_ = do_clear;
				if (_tmp44_) {
					gint _tmp45_ = 0;
					gint _tmp46_ = 0;
					FlagType _tmp47_ = 0;
					_tmp45_ = nx;
					_tmp46_ = ny;
					_tmp47_ = minefield_get_flag (self, (guint) _tmp45_, (guint) _tmp46_);
					_tmp43_ = _tmp47_ != FLAG_TYPE_FLAG;
				} else {
					_tmp43_ = FALSE;
				}
				if (_tmp43_) {
					gint _tmp48_ = 0;
					gint _tmp49_ = 0;
					_tmp48_ = nx;
					_tmp49_ = ny;
					minefield_clear_mine (self, (guint) _tmp48_, (guint) _tmp49_);
				} else {
					gint _tmp50_ = 0;
					gint _tmp51_ = 0;
					_tmp50_ = nx;
					_tmp51_ = ny;
					minefield_set_flag (self, (guint) _tmp50_, (guint) _tmp51_, FLAG_TYPE_FLAG);
				}
			}
		}
	}
}


void minefield_clear_mine (Minefield* self, guint x, guint y) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	Location** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gint _tmp7__length2 = 0;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	Location* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	guint _tmp17_ = 0U;
	guint _tmp18_ = 0U;
	Location** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	gint _tmp19__length2 = 0;
	guint _tmp20_ = 0U;
	guint _tmp21_ = 0U;
	Location* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->placed_mines;
	if (!_tmp0_) {
		guint _tmp1_ = 0U;
		guint _tmp2_ = 0U;
		_tmp1_ = x;
		_tmp2_ = y;
		minefield_place_mines (self, _tmp1_, _tmp2_);
		self->placed_mines = TRUE;
	}
	_tmp4_ = self->exploded;
	if (!_tmp4_) {
		GTimer* _tmp5_ = NULL;
		_tmp5_ = self->priv->clock;
		_tmp3_ = _tmp5_ == NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		minefield_start_clock (self);
	}
	_tmp7_ = self->locations;
	_tmp7__length1 = self->locations_length1;
	_tmp7__length2 = self->locations_length2;
	_tmp8_ = x;
	_tmp9_ = y;
	_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
	_tmp11_ = _tmp10_->cleared;
	if (_tmp11_) {
		_tmp6_ = TRUE;
	} else {
		Location** _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		gint _tmp12__length2 = 0;
		guint _tmp13_ = 0U;
		guint _tmp14_ = 0U;
		Location* _tmp15_ = NULL;
		FlagType _tmp16_ = 0;
		_tmp12_ = self->locations;
		_tmp12__length1 = self->locations_length1;
		_tmp12__length2 = self->locations_length2;
		_tmp13_ = x;
		_tmp14_ = y;
		_tmp15_ = _tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_];
		_tmp16_ = _tmp15_->flag;
		_tmp6_ = _tmp16_ == FLAG_TYPE_FLAG;
	}
	if (_tmp6_) {
		return;
	}
	_tmp17_ = x;
	_tmp18_ = y;
	minefield_clear_mines_recursive (self, _tmp17_, _tmp18_);
	_tmp19_ = self->locations;
	_tmp19__length1 = self->locations_length1;
	_tmp19__length2 = self->locations_length2;
	_tmp20_ = x;
	_tmp21_ = y;
	_tmp22_ = _tmp19_[(_tmp20_ * _tmp19__length2) + _tmp21_];
	_tmp23_ = _tmp22_->has_mine;
	if (_tmp23_) {
		gboolean _tmp24_ = FALSE;
		_tmp24_ = self->exploded;
		if (!_tmp24_) {
			self->exploded = TRUE;
			minefield_stop_clock (self);
			g_signal_emit_by_name (self, "explode");
		}
		return;
	}
	_tmp25_ = minefield_get_is_complete (self);
	_tmp26_ = _tmp25_;
	if (_tmp26_) {
		minefield_stop_clock (self);
		{
			gint tx = 0;
			tx = 0;
			{
				gboolean _tmp27_ = FALSE;
				_tmp27_ = TRUE;
				while (TRUE) {
					gint _tmp29_ = 0;
					guint _tmp30_ = 0U;
					if (!_tmp27_) {
						gint _tmp28_ = 0;
						_tmp28_ = tx;
						tx = _tmp28_ + 1;
					}
					_tmp27_ = FALSE;
					_tmp29_ = tx;
					_tmp30_ = self->width;
					if (!(((guint) _tmp29_) < _tmp30_)) {
						break;
					}
					{
						gint ty = 0;
						ty = 0;
						{
							gboolean _tmp31_ = FALSE;
							_tmp31_ = TRUE;
							while (TRUE) {
								gint _tmp33_ = 0;
								guint _tmp34_ = 0U;
								gint _tmp35_ = 0;
								gint _tmp36_ = 0;
								gboolean _tmp37_ = FALSE;
								if (!_tmp31_) {
									gint _tmp32_ = 0;
									_tmp32_ = ty;
									ty = _tmp32_ + 1;
								}
								_tmp31_ = FALSE;
								_tmp33_ = ty;
								_tmp34_ = self->height;
								if (!(((guint) _tmp33_) < _tmp34_)) {
									break;
								}
								_tmp35_ = tx;
								_tmp36_ = ty;
								_tmp37_ = minefield_has_mine (self, (guint) _tmp35_, (guint) _tmp36_);
								if (_tmp37_) {
									gint _tmp38_ = 0;
									gint _tmp39_ = 0;
									_tmp38_ = tx;
									_tmp39_ = ty;
									minefield_set_flag (self, (guint) _tmp38_, (guint) _tmp39_, FLAG_TYPE_FLAG);
								}
							}
						}
					}
				}
			}
		}
		g_signal_emit_by_name (self, "cleared");
	}
}


static void minefield_clear_mines_recursive (Minefield* self, guint x, guint y) {
	Location** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	Location* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	Location** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp5__length2 = 0;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	Location* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	Location** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gint _tmp11__length2 = 0;
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	Location* _tmp14_ = NULL;
	FlagType _tmp15_ = 0;
	Location** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gint _tmp18__length2 = 0;
	guint _tmp19_ = 0U;
	guint _tmp20_ = 0U;
	Location* _tmp21_ = NULL;
	guint _tmp22_ = 0U;
	guint _tmp23_ = 0U;
	gboolean _tmp24_ = FALSE;
	Location** _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	gint _tmp25__length2 = 0;
	guint _tmp26_ = 0U;
	guint _tmp27_ = 0U;
	Location* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->locations;
	_tmp0__length1 = self->locations_length1;
	_tmp0__length2 = self->locations_length2;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = _tmp3_->cleared;
	if (_tmp4_) {
		return;
	}
	_tmp5_ = self->locations;
	_tmp5__length1 = self->locations_length1;
	_tmp5__length2 = self->locations_length2;
	_tmp6_ = x;
	_tmp7_ = y;
	_tmp8_ = _tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_];
	_tmp8_->cleared = TRUE;
	_tmp9_ = minefield_get_n_cleared (self);
	_tmp10_ = _tmp9_;
	minefield_set_n_cleared (self, _tmp10_ + 1);
	_tmp11_ = self->locations;
	_tmp11__length1 = self->locations_length1;
	_tmp11__length2 = self->locations_length2;
	_tmp12_ = x;
	_tmp13_ = y;
	_tmp14_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
	_tmp15_ = _tmp14_->flag;
	if (_tmp15_ == FLAG_TYPE_FLAG) {
		guint _tmp16_ = 0U;
		guint _tmp17_ = 0U;
		_tmp16_ = minefield_get_n_flags (self);
		_tmp17_ = _tmp16_;
		minefield_set_n_flags (self, _tmp17_ - 1);
	}
	_tmp18_ = self->locations;
	_tmp18__length1 = self->locations_length1;
	_tmp18__length2 = self->locations_length2;
	_tmp19_ = x;
	_tmp20_ = y;
	_tmp21_ = _tmp18_[(_tmp19_ * _tmp18__length2) + _tmp20_];
	_tmp21_->flag = FLAG_TYPE_NONE;
	_tmp22_ = x;
	_tmp23_ = y;
	g_signal_emit_by_name (self, "redraw-sector", _tmp22_, _tmp23_);
	g_signal_emit_by_name (self, "marks-changed");
	_tmp25_ = self->locations;
	_tmp25__length1 = self->locations_length1;
	_tmp25__length2 = self->locations_length2;
	_tmp26_ = x;
	_tmp27_ = y;
	_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
	_tmp29_ = _tmp28_->has_mine;
	if (!_tmp29_) {
		guint _tmp30_ = 0U;
		guint _tmp31_ = 0U;
		guint _tmp32_ = 0U;
		_tmp30_ = x;
		_tmp31_ = y;
		_tmp32_ = minefield_get_n_adjacent_mines (self, _tmp30_, _tmp31_);
		_tmp24_ = _tmp32_ == ((guint) 0);
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		{
			Neighbour* neighbour_collection = NULL;
			gint neighbour_collection_length1 = 0;
			gint _neighbour_collection_size_ = 0;
			gint neighbour_it = 0;
			neighbour_collection = neighbour_map;
			neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
			for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
				Neighbour neighbour = {0};
				neighbour = neighbour_collection[neighbour_it];
				{
					gint nx = 0;
					guint _tmp33_ = 0U;
					Neighbour _tmp34_ = {0};
					gint _tmp35_ = 0;
					gint ny = 0;
					guint _tmp36_ = 0U;
					Neighbour _tmp37_ = {0};
					gint _tmp38_ = 0;
					gint _tmp39_ = 0;
					gint _tmp40_ = 0;
					gboolean _tmp41_ = FALSE;
					_tmp33_ = x;
					_tmp34_ = neighbour;
					_tmp35_ = _tmp34_.x;
					nx = ((gint) _tmp33_) + _tmp35_;
					_tmp36_ = y;
					_tmp37_ = neighbour;
					_tmp38_ = _tmp37_.y;
					ny = ((gint) _tmp36_) + _tmp38_;
					_tmp39_ = nx;
					_tmp40_ = ny;
					_tmp41_ = minefield_is_location (self, _tmp39_, _tmp40_);
					if (_tmp41_) {
						gint _tmp42_ = 0;
						gint _tmp43_ = 0;
						_tmp42_ = nx;
						_tmp43_ = ny;
						minefield_clear_mines_recursive (self, (guint) _tmp42_, (guint) _tmp43_);
					}
				}
			}
		}
	}
}


void minefield_set_flag (Minefield* self, guint x, guint y, FlagType flag) {
	gboolean _tmp0_ = FALSE;
	Location** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp1__length2 = 0;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	Location* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	FlagType _tmp12_ = 0;
	Location** _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	gint _tmp22__length2 = 0;
	guint _tmp23_ = 0U;
	guint _tmp24_ = 0U;
	Location* _tmp25_ = NULL;
	FlagType _tmp26_ = 0;
	guint _tmp27_ = 0U;
	guint _tmp28_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->locations;
	_tmp1__length1 = self->locations_length1;
	_tmp1__length2 = self->locations_length2;
	_tmp2_ = x;
	_tmp3_ = y;
	_tmp4_ = _tmp1_[(_tmp2_ * _tmp1__length2) + _tmp3_];
	_tmp5_ = _tmp4_->cleared;
	if (_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		Location** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		gint _tmp6__length2 = 0;
		guint _tmp7_ = 0U;
		guint _tmp8_ = 0U;
		Location* _tmp9_ = NULL;
		FlagType _tmp10_ = 0;
		FlagType _tmp11_ = 0;
		_tmp6_ = self->locations;
		_tmp6__length1 = self->locations_length1;
		_tmp6__length2 = self->locations_length2;
		_tmp7_ = x;
		_tmp8_ = y;
		_tmp9_ = _tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_];
		_tmp10_ = _tmp9_->flag;
		_tmp11_ = flag;
		_tmp0_ = _tmp10_ == _tmp11_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp12_ = flag;
	if (_tmp12_ == FLAG_TYPE_FLAG) {
		guint _tmp13_ = 0U;
		guint _tmp14_ = 0U;
		_tmp13_ = minefield_get_n_flags (self);
		_tmp14_ = _tmp13_;
		minefield_set_n_flags (self, _tmp14_ + 1);
	} else {
		Location** _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		gint _tmp15__length2 = 0;
		guint _tmp16_ = 0U;
		guint _tmp17_ = 0U;
		Location* _tmp18_ = NULL;
		FlagType _tmp19_ = 0;
		_tmp15_ = self->locations;
		_tmp15__length1 = self->locations_length1;
		_tmp15__length2 = self->locations_length2;
		_tmp16_ = x;
		_tmp17_ = y;
		_tmp18_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
		_tmp19_ = _tmp18_->flag;
		if (_tmp19_ == FLAG_TYPE_FLAG) {
			guint _tmp20_ = 0U;
			guint _tmp21_ = 0U;
			_tmp20_ = minefield_get_n_flags (self);
			_tmp21_ = _tmp20_;
			minefield_set_n_flags (self, _tmp21_ - 1);
		}
	}
	_tmp22_ = self->locations;
	_tmp22__length1 = self->locations_length1;
	_tmp22__length2 = self->locations_length2;
	_tmp23_ = x;
	_tmp24_ = y;
	_tmp25_ = _tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_];
	_tmp26_ = flag;
	_tmp25_->flag = _tmp26_;
	_tmp27_ = x;
	_tmp28_ = y;
	g_signal_emit_by_name (self, "redraw-sector", _tmp27_, _tmp28_);
	g_signal_emit_by_name (self, "marks-changed");
}


FlagType minefield_get_flag (Minefield* self, guint x, guint y) {
	FlagType result = 0;
	Location** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	Location* _tmp3_ = NULL;
	FlagType _tmp4_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->locations;
	_tmp0__length1 = self->locations_length1;
	_tmp0__length2 = self->locations_length2;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = _tmp3_->flag;
	result = _tmp4_;
	return result;
}


guint minefield_get_n_adjacent_mines (Minefield* self, guint x, guint y) {
	guint result = 0U;
	Location** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	Location* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->locations;
	_tmp0__length1 = self->locations_length1;
	_tmp0__length2 = self->locations_length2;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = _tmp3_->adjacent_mines;
	result = (guint) _tmp4_;
	return result;
}


gboolean minefield_has_flag_warning (Minefield* self, guint x, guint y) {
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	guint n_mines = 0U;
	guint n_flags = 0U;
	guint _tmp20_ = 0U;
	guint _tmp21_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = x;
	_tmp1_ = y;
	_tmp2_ = minefield_is_cleared (self, _tmp0_, _tmp1_);
	if (!_tmp2_) {
		result = FALSE;
		return result;
	}
	n_mines = (guint) 0;
	n_flags = (guint) 0;
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				gint nx = 0;
				guint _tmp3_ = 0U;
				Neighbour _tmp4_ = {0};
				gint _tmp5_ = 0;
				gint ny = 0;
				guint _tmp6_ = 0U;
				Neighbour _tmp7_ = {0};
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gboolean _tmp11_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gboolean _tmp14_ = FALSE;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				FlagType _tmp18_ = 0;
				_tmp3_ = x;
				_tmp4_ = neighbour;
				_tmp5_ = _tmp4_.x;
				nx = ((gint) _tmp3_) + _tmp5_;
				_tmp6_ = y;
				_tmp7_ = neighbour;
				_tmp8_ = _tmp7_.y;
				ny = ((gint) _tmp6_) + _tmp8_;
				_tmp9_ = nx;
				_tmp10_ = ny;
				_tmp11_ = minefield_is_location (self, _tmp9_, _tmp10_);
				if (!_tmp11_) {
					continue;
				}
				_tmp12_ = nx;
				_tmp13_ = ny;
				_tmp14_ = minefield_has_mine (self, (guint) _tmp12_, (guint) _tmp13_);
				if (_tmp14_) {
					guint _tmp15_ = 0U;
					_tmp15_ = n_mines;
					n_mines = _tmp15_ + 1;
				}
				_tmp16_ = nx;
				_tmp17_ = ny;
				_tmp18_ = minefield_get_flag (self, (guint) _tmp16_, (guint) _tmp17_);
				if (_tmp18_ == FLAG_TYPE_FLAG) {
					guint _tmp19_ = 0U;
					_tmp19_ = n_flags;
					n_flags = _tmp19_ + 1;
				}
			}
		}
	}
	_tmp20_ = n_flags;
	_tmp21_ = n_mines;
	result = _tmp20_ > _tmp21_;
	return result;
}


static void minefield_place_mines (Minefield* self, guint x, guint y) {
	g_return_if_fail (self != NULL);
	{
		gint n = 0;
		n = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp1_ = 0;
				guint _tmp2_ = 0U;
				gint32 rx = 0;
				guint _tmp3_ = 0U;
				gint32 _tmp4_ = 0;
				gint32 ry = 0;
				guint _tmp5_ = 0U;
				gint32 _tmp6_ = 0;
				gboolean _tmp7_ = FALSE;
				gint32 _tmp8_ = 0;
				guint _tmp9_ = 0U;
				Location** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				gint _tmp12__length2 = 0;
				gint32 _tmp13_ = 0;
				gint32 _tmp14_ = 0;
				Location* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
				if (!_tmp0_) {
				}
				_tmp0_ = FALSE;
				_tmp1_ = n;
				_tmp2_ = self->n_mines;
				if (!(((guint) _tmp1_) < _tmp2_)) {
					break;
				}
				_tmp3_ = self->width;
				_tmp4_ = g_random_int_range ((gint32) 0, (gint32) _tmp3_);
				rx = _tmp4_;
				_tmp5_ = self->height;
				_tmp6_ = g_random_int_range ((gint32) 0, (gint32) _tmp5_);
				ry = _tmp6_;
				_tmp8_ = rx;
				_tmp9_ = x;
				if (((guint) _tmp8_) == _tmp9_) {
					gint32 _tmp10_ = 0;
					guint _tmp11_ = 0U;
					_tmp10_ = ry;
					_tmp11_ = y;
					_tmp7_ = ((guint) _tmp10_) == _tmp11_;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					continue;
				}
				_tmp12_ = self->locations;
				_tmp12__length1 = self->locations_length1;
				_tmp12__length2 = self->locations_length2;
				_tmp13_ = rx;
				_tmp14_ = ry;
				_tmp15_ = _tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_];
				_tmp16_ = _tmp15_->has_mine;
				if (!_tmp16_) {
					gboolean adj_found = FALSE;
					gboolean _tmp26_ = FALSE;
					adj_found = FALSE;
					{
						Neighbour* neighbour_collection = NULL;
						gint neighbour_collection_length1 = 0;
						gint _neighbour_collection_size_ = 0;
						gint neighbour_it = 0;
						neighbour_collection = neighbour_map;
						neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
						for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
							Neighbour neighbour = {0};
							neighbour = neighbour_collection[neighbour_it];
							{
								gboolean _tmp17_ = FALSE;
								gint32 _tmp18_ = 0;
								guint _tmp19_ = 0U;
								Neighbour _tmp20_ = {0};
								gint _tmp21_ = 0;
								_tmp18_ = rx;
								_tmp19_ = x;
								_tmp20_ = neighbour;
								_tmp21_ = _tmp20_.x;
								if (((guint) _tmp18_) == (_tmp19_ + _tmp21_)) {
									gint32 _tmp22_ = 0;
									guint _tmp23_ = 0U;
									Neighbour _tmp24_ = {0};
									gint _tmp25_ = 0;
									_tmp22_ = ry;
									_tmp23_ = y;
									_tmp24_ = neighbour;
									_tmp25_ = _tmp24_.y;
									_tmp17_ = ((guint) _tmp22_) == (_tmp23_ + _tmp25_);
								} else {
									_tmp17_ = FALSE;
								}
								if (_tmp17_) {
									adj_found = TRUE;
									break;
								}
							}
						}
					}
					_tmp26_ = adj_found;
					if (!_tmp26_) {
						Location** _tmp27_ = NULL;
						gint _tmp27__length1 = 0;
						gint _tmp27__length2 = 0;
						gint32 _tmp28_ = 0;
						gint32 _tmp29_ = 0;
						Location* _tmp30_ = NULL;
						gint _tmp31_ = 0;
						_tmp27_ = self->locations;
						_tmp27__length1 = self->locations_length1;
						_tmp27__length2 = self->locations_length2;
						_tmp28_ = rx;
						_tmp29_ = ry;
						_tmp30_ = _tmp27_[(_tmp28_ * _tmp27__length2) + _tmp29_];
						_tmp30_->has_mine = TRUE;
						_tmp31_ = n;
						n = _tmp31_ + 1;
						{
							Neighbour* neighbour_collection = NULL;
							gint neighbour_collection_length1 = 0;
							gint _neighbour_collection_size_ = 0;
							gint neighbour_it = 0;
							neighbour_collection = neighbour_map;
							neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
							for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
								Neighbour neighbour = {0};
								neighbour = neighbour_collection[neighbour_it];
								{
									gint32 nx = 0;
									gint32 _tmp32_ = 0;
									Neighbour _tmp33_ = {0};
									gint _tmp34_ = 0;
									gint32 ny = 0;
									gint32 _tmp35_ = 0;
									Neighbour _tmp36_ = {0};
									gint _tmp37_ = 0;
									gint32 _tmp38_ = 0;
									gint32 _tmp39_ = 0;
									gboolean _tmp40_ = FALSE;
									_tmp32_ = rx;
									_tmp33_ = neighbour;
									_tmp34_ = _tmp33_.x;
									nx = _tmp32_ + _tmp34_;
									_tmp35_ = ry;
									_tmp36_ = neighbour;
									_tmp37_ = _tmp36_.y;
									ny = _tmp35_ + _tmp37_;
									_tmp38_ = nx;
									_tmp39_ = ny;
									_tmp40_ = minefield_is_location (self, (gint) _tmp38_, (gint) _tmp39_);
									if (_tmp40_) {
										Location** _tmp41_ = NULL;
										gint _tmp41__length1 = 0;
										gint _tmp41__length2 = 0;
										gint32 _tmp42_ = 0;
										gint32 _tmp43_ = 0;
										Location* _tmp44_ = NULL;
										gint _tmp45_ = 0;
										_tmp41_ = self->locations;
										_tmp41__length1 = self->locations_length1;
										_tmp41__length2 = self->locations_length2;
										_tmp42_ = nx;
										_tmp43_ = ny;
										_tmp44_ = _tmp41_[(_tmp42_ * _tmp41__length2) + _tmp43_];
										_tmp45_ = _tmp44_->adjacent_mines;
										_tmp44_->adjacent_mines = _tmp45_ + 1;
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static gboolean _minefield_timeout_cb_gsource_func (gpointer self) {
	gboolean result;
	result = minefield_timeout_cb ((Minefield*) self);
	return result;
}


static void minefield_start_timer (Minefield* self) {
	guint _tmp0_ = 0U;
	guint _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clock_timeout;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->clock_timeout;
		g_source_remove (_tmp1_);
	}
	self->priv->clock_timeout = (guint) 0;
	_tmp2_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, _minefield_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->clock_timeout = _tmp2_;
}


static void minefield_start_clock (Minefield* self) {
	GTimer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clock;
	if (_tmp0_ == NULL) {
		GTimer* _tmp1_ = NULL;
		_tmp1_ = g_timer_new ();
		_g_timer_destroy0 (self->priv->clock);
		self->priv->clock = _tmp1_;
	}
	g_signal_emit_by_name (self, "clock-started");
	g_signal_emit_by_name (self, "tick");
	minefield_start_timer (self);
}


static void minefield_stop_clock (Minefield* self) {
	GTimer* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	GTimer* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	guint _tmp4_ = 0U;
	GTimer* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clock;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->clock_elapsed;
	_tmp2_ = self->priv->clock;
	_tmp3_ = g_timer_elapsed (_tmp2_, NULL);
	self->priv->clock_elapsed = _tmp1_ + _tmp3_;
	_tmp4_ = self->priv->clock_timeout;
	if (_tmp4_ != ((guint) 0)) {
		guint _tmp5_ = 0U;
		_tmp5_ = self->priv->clock_timeout;
		g_source_remove (_tmp5_);
	}
	self->priv->clock_timeout = (guint) 0;
	_tmp6_ = self->priv->clock;
	g_timer_stop (_tmp6_);
	_g_timer_destroy0 (self->priv->clock);
	self->priv->clock = NULL;
	g_signal_emit_by_name (self, "tick");
}


static void minefield_continue_clock (Minefield* self) {
	GTimer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clock;
	if (_tmp0_ == NULL) {
		GTimer* _tmp1_ = NULL;
		_tmp1_ = g_timer_new ();
		_g_timer_destroy0 (self->priv->clock);
		self->priv->clock = _tmp1_;
	} else {
		GTimer* _tmp2_ = NULL;
		_tmp2_ = self->priv->clock;
		g_timer_continue (_tmp2_);
	}
	g_signal_emit_by_name (self, "tick");
	minefield_start_timer (self);
}


static gboolean minefield_timeout_cb (Minefield* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_signal_emit_by_name (self, "tick");
	result = TRUE;
	return result;
}


guint minefield_get_n_cleared (Minefield* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_n_cleared;
	result = _tmp0_;
	return result;
}


void minefield_set_n_cleared (Minefield* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_n_cleared = _tmp0_;
	g_object_notify ((GObject *) self, "n-cleared");
}


gboolean minefield_get_is_complete (Minefield* self) {
	gboolean result;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = minefield_get_n_cleared (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->width;
	_tmp3_ = self->height;
	_tmp4_ = self->n_mines;
	result = _tmp1_ == ((_tmp2_ * _tmp3_) - _tmp4_);
	return result;
}


guint minefield_get_n_flags (Minefield* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_n_flags;
	result = _tmp0_;
	return result;
}


void minefield_set_n_flags (Minefield* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_n_flags = _tmp0_;
	g_object_notify ((GObject *) self, "n-flags");
}


gboolean minefield_get_use_autoflag (Minefield* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->_use_autoflag;
	result = _tmp0_;
	return result;
}


void minefield_set_use_autoflag (Minefield* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->_use_autoflag = _tmp0_;
	g_object_notify ((GObject *) self, "use-autoflag");
}


gdouble minefield_get_elapsed (Minefield* self) {
	gdouble result;
	gdouble _tmp0_ = 0.0;
	GTimer* _tmp1_ = NULL;
	gdouble _tmp4_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp1_ = self->priv->clock;
	if (_tmp1_ == NULL) {
		_tmp0_ = 0.0;
	} else {
		GTimer* _tmp2_ = NULL;
		gdouble _tmp3_ = 0.0;
		_tmp2_ = self->priv->clock;
		_tmp3_ = g_timer_elapsed (_tmp2_, NULL);
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = self->priv->clock_elapsed;
	result = _tmp4_ + _tmp0_;
	return result;
}


gboolean minefield_get_paused (Minefield* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_paused;
	result = _tmp0_;
	return result;
}


void minefield_set_paused (Minefield* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp10_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = minefield_get_is_complete (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = self->exploded;
		_tmp0_ = _tmp3_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp5_ = value;
	if (_tmp5_) {
		gboolean _tmp6_ = FALSE;
		_tmp6_ = self->priv->_paused;
		_tmp4_ = !_tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		minefield_stop_clock (self);
	} else {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_tmp8_ = value;
		if (!_tmp8_) {
			gboolean _tmp9_ = FALSE;
			_tmp9_ = self->priv->_paused;
			_tmp7_ = _tmp9_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			minefield_continue_clock (self);
		}
	}
	_tmp10_ = value;
	self->priv->_paused = _tmp10_;
	g_signal_emit_by_name (self, "paused-changed");
	g_object_notify ((GObject *) self, "paused");
}


static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void minefield_class_init (MinefieldClass * klass) {
	minefield_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MinefieldPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_minefield_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_minefield_set_property;
	G_OBJECT_CLASS (klass)->finalize = minefield_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MINEFIELD_N_CLEARED, g_param_spec_uint ("n-cleared", "n-cleared", "n-cleared", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MINEFIELD_IS_COMPLETE, g_param_spec_boolean ("is-complete", "is-complete", "is-complete", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MINEFIELD_N_FLAGS, g_param_spec_uint ("n-flags", "n-flags", "n-flags", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MINEFIELD_USE_AUTOFLAG, g_param_spec_boolean ("use-autoflag", "use-autoflag", "use-autoflag", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MINEFIELD_ELAPSED, g_param_spec_double ("elapsed", "elapsed", "elapsed", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MINEFIELD_PAUSED, g_param_spec_boolean ("paused", "paused", "paused", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("clock_started", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("paused_changed", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("tick", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("redraw_sector", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
	g_signal_new ("marks_changed", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("explode", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("cleared", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void minefield_instance_init (Minefield * self) {
	self->priv = MINEFIELD_GET_PRIVATE (self);
	self->width = (guint) 0;
	self->height = (guint) 0;
	self->n_mines = (guint) 0;
	self->exploded = FALSE;
	self->placed_mines = FALSE;
	self->priv->_n_cleared = (guint) 0;
	self->priv->_n_flags = (guint) 0;
	self->priv->_paused = FALSE;
}


static void minefield_finalize (GObject* obj) {
	Minefield * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MINEFIELD, Minefield);
	self->locations = (_vala_array_free (self->locations, self->locations_length1 * self->locations_length2, (GDestroyNotify) g_object_unref), NULL);
	_g_timer_destroy0 (self->priv->clock);
	G_OBJECT_CLASS (minefield_parent_class)->finalize (obj);
}


GType minefield_get_type (void) {
	static volatile gsize minefield_type_id__volatile = 0;
	if (g_once_init_enter (&minefield_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MinefieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) minefield_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Minefield), 0, (GInstanceInitFunc) minefield_instance_init, NULL };
		GType minefield_type_id;
		minefield_type_id = g_type_register_static (G_TYPE_OBJECT, "Minefield", &g_define_type_info, 0);
		g_once_init_leave (&minefield_type_id__volatile, minefield_type_id);
	}
	return minefield_type_id__volatile;
}


static void _vala_minefield_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Minefield * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MINEFIELD, Minefield);
	switch (property_id) {
		case MINEFIELD_N_CLEARED:
		g_value_set_uint (value, minefield_get_n_cleared (self));
		break;
		case MINEFIELD_IS_COMPLETE:
		g_value_set_boolean (value, minefield_get_is_complete (self));
		break;
		case MINEFIELD_N_FLAGS:
		g_value_set_uint (value, minefield_get_n_flags (self));
		break;
		case MINEFIELD_USE_AUTOFLAG:
		g_value_set_boolean (value, minefield_get_use_autoflag (self));
		break;
		case MINEFIELD_ELAPSED:
		g_value_set_double (value, minefield_get_elapsed (self));
		break;
		case MINEFIELD_PAUSED:
		g_value_set_boolean (value, minefield_get_paused (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_minefield_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Minefield * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MINEFIELD, Minefield);
	switch (property_id) {
		case MINEFIELD_N_CLEARED:
		minefield_set_n_cleared (self, g_value_get_uint (value));
		break;
		case MINEFIELD_N_FLAGS:
		minefield_set_n_flags (self, g_value_get_uint (value));
		break;
		case MINEFIELD_USE_AUTOFLAG:
		minefield_set_use_autoflag (self, g_value_get_boolean (value));
		break;
		case MINEFIELD_PAUSED:
		minefield_set_paused (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



