// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_DBUSMESSAGE_H
#define _GIOMM_DBUSMESSAGE_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2010 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <glibmm/variant.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GDBusMessage GDBusMessage;
typedef struct _GDBusMessageClass GDBusMessageClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class DBusMessage_Class; } // namespace Gio
namespace Gio
{

/** @addtogroup giommEnums giomm Enums and Flags */

/**
 * @ingroup giommEnums
 */
enum DBusMessageType
{
  DBUS_MESSAGE_TYPE_INVALID,
  DBUS_MESSAGE_TYPE_METHOD_CALL,
  DBUS_MESSAGE_TYPE_METHOD_RETURN,
  DBUS_MESSAGE_TYPE_ERROR,
  DBUS_MESSAGE_TYPE_SIGNAL
};


/**
 * @ingroup giommEnums
 * @par Bitwise operators:
 * <tt>%DBusMessageFlags operator|(DBusMessageFlags, DBusMessageFlags)</tt><br>
 * <tt>%DBusMessageFlags operator&(DBusMessageFlags, DBusMessageFlags)</tt><br>
 * <tt>%DBusMessageFlags operator^(DBusMessageFlags, DBusMessageFlags)</tt><br>
 * <tt>%DBusMessageFlags operator~(DBusMessageFlags)</tt><br>
 * <tt>%DBusMessageFlags& operator|=(DBusMessageFlags&, DBusMessageFlags)</tt><br>
 * <tt>%DBusMessageFlags& operator&=(DBusMessageFlags&, DBusMessageFlags)</tt><br>
 * <tt>%DBusMessageFlags& operator^=(DBusMessageFlags&, DBusMessageFlags)</tt><br>
 */
enum DBusMessageFlags
{
  DBUS_MESSAGE_FLAGS_NONE = 0x0,
  DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED = (1<<0),
  DBUS_MESSAGE_FLAGS_NO_AUTO_START = (1<<1)
};

/** @ingroup giommEnums */
inline DBusMessageFlags operator|(DBusMessageFlags lhs, DBusMessageFlags rhs)
  { return static_cast<DBusMessageFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusMessageFlags operator&(DBusMessageFlags lhs, DBusMessageFlags rhs)
  { return static_cast<DBusMessageFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusMessageFlags operator^(DBusMessageFlags lhs, DBusMessageFlags rhs)
  { return static_cast<DBusMessageFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusMessageFlags operator~(DBusMessageFlags flags)
  { return static_cast<DBusMessageFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup giommEnums */
inline DBusMessageFlags& operator|=(DBusMessageFlags& lhs, DBusMessageFlags rhs)
  { return (lhs = static_cast<DBusMessageFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DBusMessageFlags& operator&=(DBusMessageFlags& lhs, DBusMessageFlags rhs)
  { return (lhs = static_cast<DBusMessageFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DBusMessageFlags& operator^=(DBusMessageFlags& lhs, DBusMessageFlags rhs)
  { return (lhs = static_cast<DBusMessageFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/**
 * @ingroup giommEnums
 */
enum DBusMessageHeaderField
{
  DBUS_MESSAGE_HEADER_FIELD_INVALID,
  DBUS_MESSAGE_HEADER_FIELD_PATH,
  DBUS_MESSAGE_HEADER_FIELD_INTERFACE,
  DBUS_MESSAGE_HEADER_FIELD_MEMBER,
  DBUS_MESSAGE_HEADER_FIELD_ERROR_NAME,
  DBUS_MESSAGE_HEADER_FIELD_REPLY_SERIAL,
  DBUS_MESSAGE_HEADER_FIELD_DESTINATION,
  DBUS_MESSAGE_HEADER_FIELD_SENDER,
  DBUS_MESSAGE_HEADER_FIELD_SIGNATURE,
  DBUS_MESSAGE_HEADER_FIELD_NUM_UNIX_FDS
};


class UnixFDList;

/** DBusMessage - D-Bus Message.
 * A type for representing D-Bus messages that can be sent or received on a
 * DBusConnection.
 *
 * @newin{2,26}
 */

class DBusMessage : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DBusMessage CppObjectType;
  typedef DBusMessage_Class CppClassType;
  typedef GDBusMessage BaseObjectType;
  typedef GDBusMessageClass BaseClassType;

private:  friend class DBusMessage_Class;
  static CppClassType dbusmessage_class_;

private:
  // noncopyable
  DBusMessage(const DBusMessage&);
  DBusMessage& operator=(const DBusMessage&);

protected:
  explicit DBusMessage(const Glib::ConstructParams& construct_params);
  explicit DBusMessage(GDBusMessage* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DBusMessage();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GDBusMessage*       gobj()       { return reinterpret_cast<GDBusMessage*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GDBusMessage* gobj() const { return reinterpret_cast<GDBusMessage*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDBusMessage* gobj_copy();

private:


protected:
  DBusMessage();
  

public:
  

  static Glib::RefPtr<DBusMessage> create();


  // TODO: We can't use _WRAP_CTOR() and _WRAP_CREATE() because the C functions do more than just call g_object_new():
  // http://bugzilla.gnome.org/show_bug.cgi?id=624977
  // TODO: Should these paramters be ustring or std::string?
  
  static Glib::RefPtr<DBusMessage> create_signal(const Glib::ustring& path, const Glib::ustring& interface, const Glib::ustring& signal);
  
  static Glib::RefPtr<DBusMessage> create_method_call(const Glib::ustring& name, const Glib::ustring& path, const Glib::ustring& interface, const Glib::ustring& method);
  
  static Glib::RefPtr<DBusMessage> create_method_reply(const Glib::RefPtr<DBusMessage>& method_call_message);
  
  static Glib::RefPtr<DBusMessage> create_method_error_literal(const Glib::RefPtr<const DBusMessage>& method_call_message, const Glib::ustring& error_name, const Glib::ustring& error_message);

  
  Glib::ustring print(guint indent);

  
  DBusMessageType get_message_type() const;
  
  void set_message_type(DBusMessageType type);

  
  guint32 get_serial() const;
  
  void set_serial(guint32 serial);

  
  DBusMessageFlags get_flags() const;
  
  void set_flags(DBusMessageFlags flags);

  /** Gets the body of a message.  The body is returned in @a value.
   * @param value Location in which to store the header.
   */
  void get_body(Glib::VariantBase& value) const;
  

  void set_body(const Glib::VariantBase& body);

#ifdef G_OS_UNIX
  
  Glib::RefPtr<UnixFDList> get_unix_fd_list();
  
  Glib::RefPtr<const UnixFDList> get_unix_fd_list() const;
  
  void set_unix_fd_list(const Glib::RefPtr<UnixFDList>& fd_list);

  /** Clears the existing UNIX file descriptor list.
   */
  void unset_unix_fd_list();
#endif //G_OS_UNIX

  
  guint32 get_num_unix_fds() const;
  
  void set_num_unix_fds(guint32 value);

  //TODO: _WRAP_METHOD(guchar* get_header_fields() const, g_dbus_message_get_header_fields)

  /** Gets a header field on the message.  The header is returned in @a value.
   * @param value Location in which to store the header.
   * @param header_field The header field type.
   */
  void get_header(Glib::VariantBase& value, DBusMessageHeaderField header_field) const;
  
  
  void set_header(DBusMessageHeaderField header_field, const Glib::VariantBase& value);

  
  Glib::ustring get_destination() const;
  
  void set_destination(const Glib::ustring& value);

  
  Glib::ustring get_error_name() const;
  
  void set_error_name(const Glib::ustring& value);

  
  Glib::ustring get_interface() const;
  
  void set_interface(const Glib::ustring& value);

  
  Glib::ustring get_member() const;
  
  void set_member(const Glib::ustring& value);

  
  Glib::ustring get_path() const;
  
  void set_path(const Glib::ustring& value);

  
  guint32 get_reply_serial() const;
  
  void set_reply_serial(guint32 value);

  
  Glib::ustring get_sender() const;
  
  void set_sender(const Glib::ustring& value);

  
  Glib::ustring get_signature() const;
  
  void set_signature(const Glib::ustring& value);

  
  Glib::ustring get_arg0() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};


} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DBusMessage
   */
  Glib::RefPtr<Gio::DBusMessage> wrap(GDBusMessage* object, bool take_copy = false);
}


#endif /* _GIOMM_DBUSMESSAGE_H */

