#include "obgnomeAppWin.h"

static void
gnome_app_objc_do_menu_creation(GtkWidget *parent_widget,
				GnomeMenuInfo *menuinfo,
				id msgobject)
{
  int i;
  for(i = 0; menuinfo[i].type != GNOME_APP_MENU_ENDOFINFO; i++)
    {
      menuinfo[i].widget = gtk_menu_item_new_with_label(menuinfo[i].label);
      gtk_widget_show(menuinfo[i].widget);
      gtk_menu_shell_append(GTK_MENU_SHELL(parent_widget),
			    menuinfo[i].widget);

      if(menuinfo[i].type == GNOME_APP_MENU_ITEM)
	{
	  gtk_object_set_data(GTK_OBJECT(menuinfo[i].widget),
			      "objc_id", msgobject);
	  gtk_signal_connect_interp(GTK_OBJECT(menuinfo[i].widget),
				    "activate",
				    (GtkCallbackMarshal)
				    obgtk_signal_relay,
				    menuinfo[i].moreinfo,
				    NULL,
				    TRUE);
	}
      else if(menuinfo[i].type == GNOME_APP_MENU_SUBMENU)
	{
	  GtkWidget *submenu;
	  submenu = gtk_menu_new();
	  gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuinfo[i].widget),
				    submenu);
	  gnome_app_objc_do_menu_creation(submenu, menuinfo[i].moreinfo,
					  msgobject);
	}
    }
}

static void
gnome_app_objc_do_toolbar_creation(GnomeApp *app,
				   GtkWidget *parent_widget,
				   GnomeToolbarInfo *tbinfo,
				   id msgobject)
{
  int i;
  GtkWidget *pmap;

  if(!GTK_WIDGET(app)->window)
    gtk_widget_realize(GTK_WIDGET(app));

  gtk_object_set_data(GTK_OBJECT(parent_widget),
		      "obgtk_callback_relay",
		      msgobject);

  for(i = 0; tbinfo[i].type != GNOME_APP_TOOLBAR_ENDOFINFO; i++)
    {
      if(tbinfo[i].type == GNOME_APP_TOOLBAR_ITEM)
	{
	  if(tbinfo[i].pixmap_type == GNOME_APP_PIXMAP_DATA)
	    pmap = gnome_create_pixmap_widget_d(GTK_WIDGET(app),
						parent_widget,
						(char **)tbinfo[i].pixmap_info);
	  else if(tbinfo[i].pixmap_type == GNOME_APP_PIXMAP_FILENAME)
	    pmap = gnome_create_pixmap_widget(GTK_WIDGET(app),
					      parent_widget,
					      (char *)tbinfo[i].pixmap_info);
	  else
	    pmap = NULL;
	  gtk_object_set_data(
			      gtk_toolbar_append_item(GTK_TOOLBAR(parent_widget),
						      tbinfo[i].text,
						      tbinfo[i].tooltip_text,
						      pmap?GTK_PIXMAP(pmap):NULL,
						      (GtkSignalFunc)obgtk_callback_relay,
						      tbinfo[i].clicked_callback),
			      "obgtk_callback_relay",
			      msgobject);
	}
      else if(tbinfo[i].type == GNOME_APP_TOOLBAR_SPACE)
	{
	  gtk_toolbar_append_space(GTK_TOOLBAR(parent_widget));
	}
    }
}

@implementation Gnome_AppWin
- initWithAppWinInfo:(char *) name
                    :(char *) title
{
  return [self castGnomeApp:GNOME_APP(gnome_app_new(name, title))];
}

- castGnomeApp:(GnomeApp *) castitem
{
  gnomeapp = castitem;
  return [super castGtkWindow:GTK_WINDOW(castitem)];
}

/* Need to find a way to make these send ObjC messages */
- create_menus:(GnomeMenuInfo *) menuinfo
{
  menubar = [[Gtk_MenuBar new] show];
  gnome_app_objc_do_menu_creation(GTK_WIDGET(menubar->gtkmenubar),
				  menuinfo,
				  self);
  gnome_app_set_menus(gnomeapp, menubar->gtkmenubar);
  return self;
}

- create_toolbar:(GnomeToolbarInfo *) tbinfo
{
  toolbar = [[Gtk_Toolbar new] show];
  gnome_app_objc_do_toolbar_creation(gnomeapp,
				     GTK_WIDGET(toolbar->gtktoolbar),
				     tbinfo,
				     self);
  gnome_app_set_toolbar(gnomeapp, toolbar->gtktoolbar);
  return self;
}

- set_menus:(Gtk_MenuBar *) setmenubar
{
  menubar = setmenubar;
  gnome_app_set_menus(gnomeapp, menubar->gtkmenubar);
  return self;
}

- set_toolbar:(Gtk_Toolbar *) settoolbar
{
  toolbar = settoolbar;
  gnome_app_set_toolbar(gnomeapp, toolbar->gtktoolbar);
  return self;
}

- set_contents:(Gtk_Widget *) setcontents
{
  contents = setcontents;
  gnome_app_set_contents(gnomeapp, setcontents->gtkwidget);
  return self;
}

- set_menubar_position:(GnomeAppWidgetPositionType) pos_menubar
{
  gnome_app_menu_set_position(gnomeapp, pos_menubar);
  return self;
}

- set_toolbar_position:(GnomeAppWidgetPositionType) pos_toolbar
{
  gnome_app_toolbar_set_position(gnomeapp, pos_toolbar);
  return self;
}

@end
